/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFluxoCaixaSemanal
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL_CONTA = "filtroFilialConta";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_MES_LANCAMENTO = "filtroMesLancamento";
    private final String FILTRO_ANO_LANCAMENTO = "filtroAnoLancamento";
    private final String FILTRO_NIVEL = "filtroNivel";
    private final String FILTRO_DATAS = "filtroDatas";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String[] MESES = ConstantesGerais.MESES_ANO;
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"descricaoConta", "reduzidoConta", "tipoConta", "data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "valor1", "valor2", "valor3", "valor4", "valor5", "somatorio1", "somatorio2", "somatorio3", "somatorio4", "somatorio5", "valorComSinal1", "valorComSinal2", "valorComSinal3", "valorComSinal4", "valorComSinal5", "somatorioComSinal1", "somatorioComSinal2", "somatorioComSinal3", "somatorioComSinal4", "somatorioComSinal5", "valorSaldoInicial", "somaTotal1", "somaTotal2", "somaTotal3", "somaTotal4", "somaTotal5"});
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Emiss\u00e3o", "Concilia\u00e7\u00e3o"};
    private final String[] CAMPOSDATABANCO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    public static final int TIPO_PLANOCONTA = 0;
    public static final int TIPO_CENTROCUSTO = 1;
    private int tipoRelatorio = 0;
    private int QTDE_PERIODOS = 5;
    private boolean naoHaPlanosCentros = false;

    public RelatorioFluxoCaixaSemanal(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Fluxo de Caixa Semanal por <br>Plano de Contas</html>", "Acumulado das movimenta\u00e7\u00f5es nas contas por semana", "relatorios/rel_fluxo_caixa_semanal_plano.jpg");
        } else {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Fluxo de Caixa Semanal por <br>Centro de Custo</html>", "Acumulado das movimenta\u00e7\u00f5es nos centros de custo por semana", "relatorios/rel_fluxo_caixa_semanal_centro-de-custo.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialConta", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        try {
            String selectNivel = "";
            selectNivel = tipoRelatorio == 0 ? "select max(plc_nivel) as qtde from planoconta " : "select max(ccu_nivel) as qtde from centrocusto ";
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), selectNivel);
            if (rs.next()) {
                Object[] arrayNiveis = new Integer[rs.getInt("qtde")];
                for (int i = 1; i <= rs.getInt("qtde"); ++i) {
                    arrayNiveis[i - 1] = i;
                }
                if (tipoRelatorio == 0) {
                    this.adicionaFiltroCombo("filtroNivel", "N\u00edvel Plano", arrayNiveis, rs.getInt("qtde") - 1);
                } else {
                    this.adicionaFiltroCombo("filtroNivel", "N\u00edvel", arrayNiveis, rs.getInt("qtde") - 1);
                }
                if (arrayNiveis.length == 0) {
                    this.naoHaPlanosCentros = true;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identificar os n\u00edveis. " + ex.getMessage(), ex.getStackTrace());
        }
        Calendar dataAtual = Calendar.getInstance();
        this.adicionaFiltroCombo("filtroDatas", "Campo Data", this.CAMPOSDATA, 0);
        this.adicionaFiltroCombo("filtroMesLancamento", "M\u00eas Compet.", this.MESES, dataAtual.get(2));
        this.adicionaFiltroNumero("filtroAnoLancamento", "Ano Compet.", 4);
        this.setFiltroNumero("filtroAnoLancamento", String.valueOf(dataAtual.get(1)));
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioFluxoCaixaSemanal.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block65: {
            st = Conexao.getStatement();
            String[] origem = null;
            String whereAux = "";
            if (this.naoHaPlanosCentros) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 " + (this.tipoRelatorio == 0 ? "planos de contas" : "centros de custo") + " cadastrados.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String[] filiais = this.getSelecionadosFiltro("filtroFilialConta", 0);
            String filAux = "";
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroNumero("filtroAnoLancamento").equals("")) {
                Funcoes.mensagem(this, "Insira um ano de compet\u00eancia. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int nivel;
                int j;
                String dataBase = this.getFiltroNumero("filtroAnoLancamento").toString() + "-" + (this.getFiltroComboIndice("filtroMesLancamento") + 1) + "-01";
                String selectData = "";
                selectData = selectData + "select  date_trunc('month', cast('" + dataBase + "' as date)) as semana1 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '5 day' as semana2 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '6 day' as semana3 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '11 day' as semana4 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '12 day' as semana5 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '17 day' as semana6 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '18 day' as semana7 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '23 day' as semana8 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '24 day' as semana9 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '1 month' - interval '1 day' as semana10 ";
                ResultSet rs = Conexao.executeQuery(st, selectData);
                String[] arraySemanas = new String[10];
                if (rs.next()) {
                    for (j = 1; j <= 10; ++j) {
                        arraySemanas[j - 1] = rs.getString("semana" + j);
                    }
                }
                if (filiais == null || filiais.length == 0) {
                    filAux = filAux + " = " + Variaveis.filialPadrao;
                } else {
                    filAux = filAux + " in (";
                    for (j = 0; j < filiais.length; ++j) {
                        filAux = filAux + filiais[j];
                        if (j >= filiais.length - 1) continue;
                        filAux = filAux + ", ";
                    }
                    filAux = filAux + ")";
                }
                int qtdePlanos = 0;
                int maxNivel = 0;
                String selectAux = "";
                selectAux = selectAux + "select count(1) as qtde ";
                selectAux = this.tipoRelatorio == 0 ? selectAux + "  from planoconta plc where plc.fil_codigo  " : selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    qtdePlanos = rs.getInt("qtde");
                }
                selectAux = "";
                if (this.tipoRelatorio == 0) {
                    selectAux = selectAux + "select max(plc_nivel) as maxNivel ";
                    selectAux = selectAux + "  from planoconta plc where plc.fil_codigo  ";
                } else {
                    selectAux = selectAux + "select max(ccu_nivel) as maxNivel ";
                    selectAux = selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                }
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    maxNivel = rs.getInt("maxNivel");
                }
                rs.close();
                StringBuilder buf = null;
                String[] usuario = null;
                ArrayDados[] arrayDados = new ArrayDados[qtdePlanos];
                for (int i = 1; i <= this.QTDE_PERIODOS; ++i) {
                    int j2;
                    whereAux = "";
                    String data1 = arraySemanas[2 * i - 2];
                    String data2 = arraySemanas[2 * i - 1];
                    usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                    if (usuario != null) {
                        whereAux = whereAux + " and (lcx.usr_codigo in (";
                        for (j2 = 0; j2 < usuario.length; ++j2) {
                            whereAux = whereAux + "'";
                            whereAux = whereAux + usuario[j2];
                            whereAux = whereAux + "'";
                            if (j2 >= usuario.length - 1) continue;
                            whereAux = whereAux + ", ";
                        }
                        whereAux = whereAux + ") OR lcx.usr_codigo IS NULL)";
                    }
                    if ((origem = this.getSelecionadosFiltro("filtroOrigem", 0)) != null) {
                        whereAux = whereAux + " and lcp.opc_codigo in (";
                        for (j2 = 0; j2 < origem.length; ++j2) {
                            whereAux = whereAux + "'";
                            whereAux = whereAux + origem[j2];
                            whereAux = whereAux + "'";
                            if (j2 >= origem.length - 1) continue;
                            whereAux = whereAux + ", ";
                        }
                        whereAux = whereAux + ")";
                    }
                    buf = new StringBuilder();
                    buf.append("select ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("\t\t  ,a.plc_reduzido as reduzidoConta ");
                    buf.append("      ,a.plc_descricao as descricaoConta ");
                    if (this.tipoRelatorio == 0) {
                        buf.append("      ,a.plc_tipo as tipoConta");
                    } else {
                        buf.append("      ,'X' as tipoConta");
                    }
                    buf.append("      ,a.plc_pai as paiConta");
                    buf.append("      ,a.plc_nivel as nivelConta");
                    buf.append("      ,case when plc_valor is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valor ");
                    buf.append("       end ");
                    buf.append("       as valorConta ");
                    buf.append("      ,case when plc_valorcomsinal is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valorcomsinal ");
                    buf.append("       end as valorContaComSinal ");
                    buf.append("  from (select plc.fil_codigo");
                    buf.append("\t\t          ,plc.plc_reduzido ");
                    buf.append("              ,plc.plc_descricao ");
                    buf.append("              ,plc.plc_tipo ");
                    buf.append("              ,plc.plc_conta ");
                    buf.append("              ,plc.plc_pai ");
                    buf.append("              ,plc.plc_nivel ");
                    buf.append("              ,plc.plc_operacao ");
                    buf.append("              ,SUM(CASE WHEN plc.plc_operacao = '").append("A").append("' THEN ");
                    buf.append("                             res.lpl_valor ");
                    buf.append("                        ELSE ");
                    buf.append("                             (res.lpl_valor * -1)");
                    buf.append("                        END ");
                    buf.append("               ) as plc_valorcomsinal ");
                    if (this.tipoRelatorio == 0) {
                        buf.append("              ,SUM(case when plc.plc_tipo = 'R' then ");
                        buf.append("\t                      case when res.lcx_tipo = 'C' then ");
                        buf.append("\t\t\t                       res.lpl_valor ");
                        buf.append("\t\t                    else ");
                        buf.append("\t\t\t                       (res.lpl_valor * -1) ");
                        buf.append("\t\t                    end ");
                        buf.append("\t                 else ");
                        buf.append("\t                      case when res.lcx_tipo = 'D' then ");
                        buf.append("\t\t\t\t                     res.lpl_valor ");
                        buf.append("\t\t\t                  else ");
                        buf.append("\t\t\t                       (res.lpl_valor * -1) ");
                        buf.append("\t                      end ");
                        buf.append("                   end ");
                    } else {
                        buf.append("              ,SUM(case when res.lcx_tipo = 'C' then ");
                        buf.append("\t\t\t                  res.lpl_valor ");
                        buf.append("\t\t               else ");
                        buf.append("\t\t\t                  (res.lpl_valor * -1) ");
                        buf.append("\t\t               end ");
                    }
                    buf.append("               ) as plc_valor ");
                    buf.append("          from planoconta plc ");
                    buf.append("     left join (select lcp.fil_codigo ");
                    buf.append("                      ,lcp.plc_reduzido ");
                    buf.append("                      ,lcx.lcx_tipo ");
                    buf.append("                      ,SUM(lcp.lpl_valor) as lpl_valor ");
                    buf.append("                  from lanctocaixaplanoconta lcp ");
                    buf.append("                      ,lanctocaixa lcx ");
                    buf.append("                 where lcp.fil_codigo = lcx.fil_codigo ");
                    buf.append("                   and lcp.lcx_codigo = lcx.lcx_codigo ");
                    buf.append("                   and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereAux + " ");
                    buf.append("                   and cast(lcx.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]).append(" as date ) ");
                    buf.append(" >= cast('" + data1 + "' as date) ");
                    buf.append(" and cast(lcx.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]).append(" as date ) ");
                    buf.append(" <= cast('" + data2 + "' as date) ");
                    buf.append("                 group by lcp.fil_codigo ");
                    buf.append("                         ,lcp.plc_reduzido ");
                    buf.append("                         ,lcx.lcx_tipo ");
                    buf.append("               ) as res ");
                    buf.append("            on (plc.fil_codigo = res.fil_codigo and plc.plc_reduzido = res.plc_reduzido) ");
                    buf.append("         where plc.fil_codigo  ");
                    buf.append(filAux + " ");
                    buf.append("      group by plc.fil_codigo, plc.plc_reduzido, plc.plc_descricao, plc.plc_tipo, plc_pai, plc_nivel, plc_operacao, plc_conta) a ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(" order by  a.plc_tipo desc ,a.plc_conta ");
                    } else {
                        buf.append(" order by  a.plc_conta ");
                    }
                    if (this.tipoRelatorio == 1) {
                        String aux = buf.toString();
                        aux = aux.replaceAll("plc", "ccu");
                        aux = aux.replaceAll("planoconta", "centrocusto");
                        aux = aux.replaceAll("lcp", "lcc");
                        aux = aux.replaceAll("lpl_valor", "lcc_valor");
                        aux = aux.replaceAll(", ccu.ccu_tipo", " ");
                        aux = aux.replaceAll(",ccu.ccu_tipo", " ");
                        aux = aux.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(aux);
                    }
                    rs = Conexao.executeQuery(st, buf);
                    j2 = 0;
                    while (rs.next()) {
                        if (arrayDados[j2] == null) {
                            arrayDados[j2] = new ArrayDados(rs.getInt("reduzidoConta"), rs.getInt("paiConta"), rs.getInt("nivelConta"));
                        }
                        arrayDados[j2].valoresPlano[i - 1] = rs.getFloat("valorConta");
                        arrayDados[j2].valoresPlanoComSinal[i - 1] = rs.getFloat("valorContaComSinal");
                        ++j2;
                    }
                }
                for (int j3 = maxNivel; j3 > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); --j3) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            if (arrayDados[k].nivelPlano != j3 || arrayDados[k].paiPlano == -1) continue;
                            int n = l;
                            arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano[n] = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano[n] + arrayDados[k].valoresPlano[l];
                            int n2 = l;
                            arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal[n2] = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal[n2] + arrayDados[k].valoresPlanoComSinal[l];
                        }
                    }
                }
                for (int j4 = nivel = Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); j4 > 0; --j4) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            int indicePlano;
                            if (arrayDados[k].nivelPlano != j4 || arrayDados[k].paiPlano == -1 || (indicePlano = this.getIndicePlano(arrayDados, arrayDados[k].paiPlano)) <= -1) continue;
                            int n = l;
                            arrayDados[indicePlano].valoresPlano[n] = arrayDados[indicePlano].valoresPlano[n] + arrayDados[k].valoresPlano[l];
                            int n3 = l;
                            arrayDados[indicePlano].valoresPlanoComSinal[n3] = arrayDados[indicePlano].valoresPlanoComSinal[n3] + arrayDados[k].valoresPlanoComSinal[l];
                        }
                    }
                }
                rs.beforeFirst();
                ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
                int aux = -1;
                while (rs.next()) {
                    ++aux;
                    if (rs.getInt("nivelConta") > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                    Object[] o = new Object[camposRelatorio.length];
                    for (int i = 0; i < camposRelatorio.length; ++i) {
                        if (camposRelatorio[i].equals("tipoConta")) {
                            if (rs.getString(camposRelatorio[i]).equals("R")) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = "ENTRADAS";
                                continue;
                            }
                            if (rs.getString(camposRelatorio[i]).equals("D")) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = "SA\u00cdDAS";
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = "CENTROS DE CUSTO";
                            continue;
                        }
                        if (camposRelatorio[i].equalsIgnoreCase("valorSaldoInicial")) continue;
                        if (camposRelatorio[i].substring(0, 4).equals("data")) {
                            if (camposRelatorio[i].length() == 5) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = arraySemanas[Integer.valueOf(camposRelatorio[i].substring(4, 5)) - 1];
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = arraySemanas[Integer.valueOf(camposRelatorio[i].substring(4, 6)) - 1];
                            continue;
                        }
                        if (camposRelatorio[i].length() >= 13 && camposRelatorio[i].substring(0, 13).equals("valorComSinal")) {
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(camposRelatorio[i].substring(13, 14)) - 1]);
                            if (rs.getInt("nivelConta") != 1) continue;
                            o[modelo.findColumn((String)new StringBuilder().append((String)"somaTotal").append((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i].substring((int)13, (int)14)).toString())] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(camposRelatorio[i].substring(13, 14)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].substring(0, 5).equals("valor")) {
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(5, 6)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].length() >= 17 && camposRelatorio[i].substring(0, 17).equals("somatorioComSinal")) {
                            if (rs.getInt("nivelConta") != 1) continue;
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(camposRelatorio[i].substring(17, 18)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].substring(0, 9).equals("somatorio")) {
                            if (this.tipoRelatorio == 0) {
                                if (rs.getString("tipoConta").equals("R")) {
                                    o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(9, 10)) - 1]);
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.parseInt(camposRelatorio[i].substring(9, 10)) - 1] * -1.0f);
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(9, 10)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].contains("somaTotal")) continue;
                        o[modelo.findColumn((String)RelatorioFluxoCaixaSemanal.camposRelatorio[i])] = rs.getObject(camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                }
                if (modelo.getRowCount() > 0) {
                    if (buf != null) {
                        buf.delete(0, buf.length());
                    } else {
                        buf = new StringBuilder();
                    }
                    buf.append(" select SUM(case when plc.plc_operacao = '").append("A").append("' then ");
                    buf.append("                      lcp.lpl_valor ");
                    buf.append("            else (");
                    buf.append("                      lcp.lpl_valor * (-1) ) ");
                    buf.append("            end) as saldoInicial ");
                    buf.append("   from lanctocaixaplanoconta lcp ");
                    buf.append("       ,lanctocaixa lcx ");
                    buf.append("       ,planoconta plc ");
                    buf.append("  where lcp.fil_codigo = lcx.fil_codigo ");
                    buf.append("    and lcp.lcx_codigo = lcx.lcx_codigo ");
                    buf.append("    and lcp.fil_codigo = plc.fil_codigo ");
                    buf.append("    and lcp.plc_reduzido = plc.plc_reduzido ");
                    buf.append("    and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereAux);
                    buf.append("    and cast(").append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]).append(" as date ) ");
                    buf.append(" < '").append(dataBase).append("' ");
                    buf.append("    and lcx.fil_codigo ").append(filAux).append(" ");
                    if (this.tipoRelatorio == 1) {
                        String auxBuf = buf.toString();
                        auxBuf = auxBuf.replaceAll("plc", "ccu");
                        auxBuf = auxBuf.replaceAll("planoconta", "centrocusto");
                        auxBuf = auxBuf.replaceAll("lcp", "lcc");
                        auxBuf = auxBuf.replaceAll("lpl_valor", "lcc_valor");
                        auxBuf = auxBuf.replaceAll(", ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll(",ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(auxBuf);
                    }
                    if ((rs = st.executeQuery(buf.toString())).next()) {
                        for (int i = 0; i < modelo.getRowCount(); ++i) {
                            modelo.setValueAt(rs.getBigDecimal("saldoInicial"), i, modelo.findColumn("valorSaldoInicial"));
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(RelatorioFluxoCaixaSemanal.getModuloAcesso(0));
                    } else {
                        buf.append(RelatorioFluxoCaixaSemanal.getModuloAcesso(1));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioFluxoCaixaSemanal.this.panelCentro.removeAll();
                                RelatorioFluxoCaixaSemanal.this.panelCentro.repaint();
                                RelatorioFluxoCaixaSemanal.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroNivel", this.getFiltroCombo("filtroNivel"));
                        var.put("filtroDatas", this.getFiltroCombo("filtroDatas"));
                        var.put("filtroMesLancamento", this.getFiltroCombo("filtroMesLancamento"));
                        var.put("filtroAnoLancamento", this.getFiltroTexto("filtroAnoLancamento"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put("filtroFilialConta", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (i = 0; i < origem.length; ++i) {
                                buf.append(origem[i]);
                                if (i >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroOrigem", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block65;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int getIndicePlano(ArrayDados[] arr, int reduzidoPlano) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].reduzidoPlano != reduzidoPlano) continue;
            return i;
        }
        return -1;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850805100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850905100");
        }
        return Long.parseLong("0850805100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850805101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850905101");
        }
        return Long.parseLong("0850805101");
    }

    class ArrayDados {
        protected int reduzidoPlano = -1;
        protected int paiPlano = -1;
        protected int nivelPlano = -1;
        protected float[] valoresPlano;
        protected float[] valoresPlanoComSinal;

        public ArrayDados(int reduzidoPlano, int paiPlano, int nivelPlano) {
            this.reduzidoPlano = reduzidoPlano;
            this.paiPlano = paiPlano;
            this.nivelPlano = nivelPlano;
            this.valoresPlano = new float[RelatorioFluxoCaixaSemanal.this.QTDE_PERIODOS];
            this.valoresPlanoComSinal = new float[RelatorioFluxoCaixaSemanal.this.QTDE_PERIODOS];
        }
    }
}

