/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFluxoCaixaMensal
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL_CONTA = "filtroFilialConta";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_MES_INICIAL = "filtroMesInicial";
    private final String FILTRO_ANO_INICIAL = "filtroAnoInicial";
    private final String FILTRO_NIVEL = "filtroNivel";
    private final String FILTRO_DATAS = "filtroDatas";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String[] MESES = ConstantesGerais.MESES_ANO;
    private String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"descricaoConta", "reduzidoConta", "tipoConta", "mes1", "mes2", "mes3", "mes4", "mes5", "mes6", "mes7", "mes8", "mes9", "mes10", "mes11", "mes12", "data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "data11", "data12", "somatorio1", "somatorio2", "somatorio3", "somatorio4", "somatorio5", "somatorio6", "somatorio7", "somatorio8", "somatorio9", "somatorio10", "somatorio11", "somatorio12", "mesComSinal1", "mesComSinal2", "mesComSinal3", "mesComSinal4", "mesComSinal5", "mesComSinal6", "mesComSinal7", "mesComSinal8", "mesComSinal9", "mesComSinal10", "mesComSinal11", "mesComSinal12", "somatorioComSinal1", "somatorioComSinal2", "somatorioComSinal3", "somatorioComSinal4", "somatorioComSinal5", "somatorioComSinal6", "somatorioComSinal7", "somatorioComSinal8", "somatorioComSinal9", "somatorioComSinal10", "somatorioComSinal11", "somatorioComSinal12", "valorSaldoInicial", "nivelConta"});
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private final String[] CAMPOSDATABANCO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    public static final int TIPO_PLANOCONTA = 0;
    public static final int TIPO_CENTROCUSTO = 1;
    private int tipoRelatorio = 0;
    private int QTDE_PERIODOS = 12;
    private boolean naoHaPlanosCentros = false;

    public RelatorioFluxoCaixaMensal(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, new String[]{"contaPlanoConta"});
        } else if (tipoRelatorio == 1) {
            this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, new String[]{"contaCentroCusto"});
        }
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposTotal());
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Fluxo de Caixa Mensal por <br> Plano de Contas</html>", "Acumulado das movimenta\u00e7\u00f5es nas contas por m\u00eas", "relatorios/rel_fluxo_caixa_mensal_plano.jpg");
        } else {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Fluxo de Caixa Mensal por <br> Centro de Custo</html>", "Acumulado das movimenta\u00e7\u00f5es nos centros de custo por m\u00eas", "relatorios/rel_fluxo_caixa_mensal_centro-de-custo.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialConta", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        try {
            String selectNivel = "";
            selectNivel = tipoRelatorio == 0 ? "select max(plc_nivel) as qtde from planoconta " : "select max(ccu_nivel) as qtde from centrocusto ";
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), selectNivel);
            if (rs.next()) {
                Object[] arrayNiveis = new Integer[rs.getInt("qtde")];
                for (int i = 1; i <= rs.getInt("qtde"); ++i) {
                    arrayNiveis[i - 1] = i;
                }
                if (tipoRelatorio == 0) {
                    this.adicionaFiltroCombo("filtroNivel", "N\u00edvel Plano", arrayNiveis, rs.getInt("qtde") - 1);
                } else {
                    this.adicionaFiltroCombo("filtroNivel", "N\u00edvel", arrayNiveis, rs.getInt("qtde") - 1);
                }
                if (arrayNiveis.length == 0) {
                    this.naoHaPlanosCentros = true;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identificar os n\u00edveis. " + ex.getMessage(), ex.getStackTrace());
        }
        this.adicionaFiltroCombo("filtroDatas", "Campo Data", this.CAMPOSDATA, 0);
        this.adicionaFiltroCombo("filtroMesInicial", "M\u00eas Inicial", this.MESES, 0);
        this.adicionaFiltroNumero("filtroAnoInicial", "Ano Inicial", 4);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioFluxoCaixaMensal.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block69: {
            st = Conexao.getStatement();
            String[] origem = null;
            String whereAux = "";
            if (this.naoHaPlanosCentros) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 " + (this.tipoRelatorio == 0 ? "planos de contas" : "centros de custo") + " cadastrados.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String[] filiais = this.getSelecionadosFiltro("filtroFilialConta", 0);
            String filAux = "";
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroNumero("filtroAnoInicial").equals("")) {
                Funcoes.mensagem(this, "Insira um ano inicial para o relat\u00f3rio. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int nivel;
                int j;
                String dataBase = "01/" + (this.getFiltroComboIndice("filtroMesInicial") + 1) + "/" + this.getFiltroNumero("filtroAnoInicial").toString();
                String selectData = "";
                selectData = selectData + "select  date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) as mes1 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '1 month' as mes2 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '2 month' as mes3 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '3 month' as mes4 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '4 month' as mes5 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '5 month' as mes6 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '6 month' as mes7 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '7 month' as mes8 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '8 month' as mes9 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '9 month' as mes10 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '10 month' as mes11 ";
                selectData = selectData + "       ,date_trunc('month', to_timestamp('" + dataBase + "', 'DD/MM/YYYY')) + interval '11 month' as mes12 ";
                ResultSet rs = Conexao.executeQuery(st, selectData);
                String[] arrayMeses = new String[12];
                if (rs.next()) {
                    for (j = 1; j <= arrayMeses.length; ++j) {
                        arrayMeses[j - 1] = rs.getString("mes" + j);
                    }
                }
                if (filiais == null || filiais.length == 0) {
                    filAux = filAux + " = " + Variaveis.filialPadrao;
                } else {
                    filAux = filAux + " in (";
                    for (j = 0; j < filiais.length; ++j) {
                        filAux = filAux + filiais[j];
                        if (j >= filiais.length - 1) continue;
                        filAux = filAux + ", ";
                    }
                    filAux = filAux + ")";
                }
                int qtdePlanos = 0;
                int maxNivel = 0;
                String selectAux = "";
                selectAux = selectAux + "select count(1) as qtde ";
                selectAux = this.tipoRelatorio == 0 ? selectAux + "  from planoconta plc where plc.fil_codigo  " : selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    qtdePlanos = rs.getInt("qtde");
                }
                selectAux = "";
                if (this.tipoRelatorio == 0) {
                    selectAux = selectAux + "select max(plc_nivel) as maxNivel ";
                    selectAux = selectAux + "  from planoconta plc where plc.fil_codigo  ";
                } else {
                    selectAux = selectAux + "select max(ccu_nivel) as maxNivel ";
                    selectAux = selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                }
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    maxNivel = rs.getInt("maxNivel");
                }
                rs.close();
                StringBuilder buf = null;
                String[] usuario = null;
                ArrayDados[] arrayDados = new ArrayDados[qtdePlanos];
                for (int i = 0; i < this.QTDE_PERIODOS; ++i) {
                    int j2;
                    whereAux = "";
                    String data1 = arrayMeses[i];
                    usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                    if (usuario != null) {
                        whereAux = whereAux + " and (lcx.usr_codigo in (";
                        for (j2 = 0; j2 < usuario.length; ++j2) {
                            whereAux = whereAux + "'";
                            whereAux = whereAux + usuario[j2];
                            whereAux = whereAux + "'";
                            if (j2 >= usuario.length - 1) continue;
                            whereAux = whereAux + ", ";
                        }
                        whereAux = whereAux + ") OR lcx.usr_codigo IS NULL)";
                    }
                    if ((origem = this.getSelecionadosFiltro("filtroOrigem", 0)) != null) {
                        whereAux = whereAux + " and lcp.opc_codigo in (";
                        for (j2 = 0; j2 < origem.length; ++j2) {
                            whereAux = whereAux + "'";
                            whereAux = whereAux + origem[j2];
                            whereAux = whereAux + "'";
                            if (j2 >= origem.length - 1) continue;
                            whereAux = whereAux + ", ";
                        }
                        whereAux = whereAux + ")";
                    }
                    buf = new StringBuilder();
                    buf.append("select ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("\t\t  ,a.plc_reduzido as reduzidoConta ");
                    buf.append("      ,a.plc_descricao as descricaoConta ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(" \t\t\t,a.plc_conta as contaPlanoConta ");
                    } else {
                        buf.append(" \t\t\t,a.ccu_conta as contaCentroCusto ");
                    }
                    if (this.tipoRelatorio == 0) {
                        buf.append("      ,a.plc_tipo as tipoConta");
                    } else {
                        buf.append("      ,'X' as tipoConta");
                    }
                    buf.append("      ,a.plc_pai as paiConta");
                    buf.append("      ,a.plc_nivel as nivelConta");
                    buf.append("      ,case when plc_valor is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valor ");
                    buf.append("       end ");
                    buf.append("       as valorConta ");
                    buf.append("      ,case when plc_valorcomsinal is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valorcomsinal ");
                    buf.append("       end as valorContaComSinal ");
                    buf.append("  from (select plc.fil_codigo");
                    buf.append("\t\t          ,plc.plc_reduzido ");
                    buf.append("              ,plc.plc_descricao ");
                    buf.append("              ,plc.plc_tipo ");
                    buf.append("              ,plc.plc_conta ");
                    buf.append("              ,plc.plc_pai ");
                    buf.append("              ,plc.plc_nivel ");
                    buf.append("              ,plc.plc_operacao ");
                    buf.append("              ,SUM(CASE WHEN plc.plc_operacao = '").append("A").append("' THEN ");
                    buf.append("                             res.lpl_valor ");
                    buf.append("                        ELSE ");
                    buf.append("                             (res.lpl_valor * -1)");
                    buf.append("                        END ");
                    buf.append("               ) as plc_valorcomsinal ");
                    if (this.tipoRelatorio == 0) {
                        buf.append("              ,SUM(case when plc.plc_tipo = 'R' then ");
                        buf.append("\t                      case when res.lcx_tipo = 'C' then ");
                        buf.append("\t\t\t                       res.lpl_valor ");
                        buf.append("\t\t                    else ");
                        buf.append("\t\t\t                       (res.lpl_valor * -1) ");
                        buf.append("\t\t                    end ");
                        buf.append("\t                 else ");
                        buf.append("\t                      case when res.lcx_tipo = 'D' then ");
                        buf.append("\t\t\t\t                     res.lpl_valor ");
                        buf.append("\t\t\t                  else ");
                        buf.append("\t\t\t                       (res.lpl_valor * -1) ");
                        buf.append("\t                      end ");
                        buf.append("                   end ");
                    } else {
                        buf.append("              ,SUM(case when res.lcx_tipo = 'C' then ");
                        buf.append("\t\t\t                  res.lpl_valor ");
                        buf.append("\t\t               else ");
                        buf.append("\t\t\t                  (res.lpl_valor * -1) ");
                        buf.append("\t\t               end ");
                    }
                    buf.append("               ) as plc_valor ");
                    buf.append("          from planoconta plc ");
                    buf.append("     left join (select lcp.fil_codigo ");
                    buf.append("                      ,lcp.plc_reduzido ");
                    buf.append("                      ,lcx.lcx_tipo ");
                    buf.append("                      ,SUM(lcp.lpl_valor) as lpl_valor ");
                    buf.append("                  from lanctocaixaplanoconta lcp ");
                    buf.append("                      ,lanctocaixa lcx ");
                    buf.append("                 where lcp.fil_codigo = lcx.fil_codigo ");
                    buf.append("                   and lcp.lcx_codigo = lcx.lcx_codigo ");
                    buf.append("                   and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereAux + " ");
                    buf.append("                   and lcx.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]);
                    buf.append(" >= cast('" + data1 + "' as date) ");
                    buf.append(" and lcx.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]);
                    buf.append(" <= (cast('" + data1 + "' as date) + interval '1 month' - interval '1 day') ");
                    buf.append("                 group by lcp.fil_codigo ");
                    buf.append("                         ,lcp.plc_reduzido ");
                    buf.append("                         ,lcx.lcx_tipo ");
                    buf.append("               ) as res ");
                    buf.append("            on (plc.fil_codigo = res.fil_codigo and plc.plc_reduzido = res.plc_reduzido) ");
                    buf.append("         where plc.fil_codigo  ");
                    buf.append(filAux + " ");
                    buf.append("      group by plc.fil_codigo, plc.plc_reduzido, plc.plc_descricao, plc.plc_tipo, plc_pai, plc_nivel, plc_operacao, plc_conta) a ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(" order by a.plc_tipo desc , a.plc_conta ");
                    } else {
                        buf.append(" order by tipoConta desc, a.ccu_conta ");
                    }
                    if (this.tipoRelatorio == 1) {
                        String aux = buf.toString();
                        aux = aux.replaceAll("plc", "ccu");
                        aux = aux.replaceAll("planoconta", "centrocusto");
                        aux = aux.replaceAll("lcp", "lcc");
                        aux = aux.replaceAll("lpl_valor", "lcc_valor");
                        aux = aux.replaceAll(", ccu.ccu_tipo", " ");
                        aux = aux.replaceAll(",ccu.ccu_tipo", " ");
                        aux = aux.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(aux);
                    }
                    if (!(rs = Conexao.executeQuery(st, buf)).next()) continue;
                    int j3 = 0;
                    do {
                        if (arrayDados[j3] == null) {
                            arrayDados[j3] = new ArrayDados(rs.getInt("reduzidoConta"), rs.getInt("paiConta"), rs.getInt("nivelConta"));
                        }
                        arrayDados[j3].valoresPlano[i] = Float.valueOf(rs.getFloat("valorConta"));
                        arrayDados[j3].valoresPlanoComSinal[i] = Float.valueOf(rs.getFloat("valorContaComSinal"));
                        ++j3;
                    } while (rs.next());
                }
                for (int j4 = maxNivel; j4 > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); --j4) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            if (arrayDados[k].nivelPlano != j4 || arrayDados[k].paiPlano == -1) continue;
                            Float[] floatArray = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano;
                            int n = l;
                            Float.valueOf(floatArray[n].floatValue() + arrayDados[k].valoresPlano[l].floatValue());
                            floatArray = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal;
                            n = l;
                            Float.valueOf(floatArray[n].floatValue() + arrayDados[k].valoresPlanoComSinal[l].floatValue());
                        }
                    }
                }
                for (int j5 = nivel = Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); j5 > 0; --j5) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            int indicePlano;
                            if (arrayDados[k].nivelPlano != j5 || arrayDados[k].paiPlano == -1 || (indicePlano = this.getIndicePlano(arrayDados, arrayDados[k].paiPlano)) <= -1) continue;
                            Float[] floatArray = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano;
                            int n = l;
                            Float.valueOf(floatArray[n].floatValue() + arrayDados[k].valoresPlano[l].floatValue());
                            floatArray = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal;
                            n = l;
                            Float.valueOf(floatArray[n].floatValue() + arrayDados[k].valoresPlanoComSinal[l].floatValue());
                        }
                    }
                }
                rs.beforeFirst();
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                int aux = -1;
                while (rs.next()) {
                    ++aux;
                    if (rs.getInt("nivelConta") > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                    Object[] o = new Object[this.camposRelatorio.length];
                    for (int i = 0; i < this.camposRelatorio.length; ++i) {
                        String auxSoma;
                        if (this.camposRelatorio[i].equals("tipoConta")) {
                            if (rs.getString(this.camposRelatorio[i]).equals("R")) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = "ENTRADAS";
                                continue;
                            }
                            if (rs.getString(this.camposRelatorio[i]).equals("D")) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = "SA\u00cdDAS";
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = "CENTROS DE CUSTO";
                            continue;
                        }
                        if (this.camposRelatorio[i].equalsIgnoreCase("valorSaldoInicial")) continue;
                        if (this.camposRelatorio[i].length() >= 4 && this.camposRelatorio[i].substring(0, 4).equals("data")) {
                            if (this.camposRelatorio[i].length() == 5) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayMeses[Integer.valueOf(this.camposRelatorio[i].substring(4, 5)) - 1];
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayMeses[Integer.valueOf(this.camposRelatorio[i].substring(4, 6)) - 1];
                            continue;
                        }
                        if (this.camposRelatorio[i].length() >= 11 && this.camposRelatorio[i].substring(0, 11).equals("mesComSinal")) {
                            if (this.camposRelatorio[i].length() == 12) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(this.camposRelatorio[i].substring(11, 12)) - 1];
                                if (rs.getInt("nivelConta") != 1) continue;
                                o[modelo.findColumn((String)new StringBuilder().append((String)"somaMesComSinal").append((String)this.camposRelatorio[i].substring((int)11, (int)12).toString()).toString())] = arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(this.camposRelatorio[i].substring(11, 12)) - 1];
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(this.camposRelatorio[i].substring(11, 13)) - 1];
                            if (rs.getInt("nivelConta") != 1) continue;
                            o[modelo.findColumn((String)new StringBuilder().append((String)"somaMesComSinal").append((String)this.camposRelatorio[i].substring((int)11, (int)13).toString()).toString())] = arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(this.camposRelatorio[i].substring(11, 13)) - 1];
                            continue;
                        }
                        if (this.camposRelatorio[i].length() >= 3 && this.camposRelatorio[i].substring(0, 3).equals("mes")) {
                            if (this.camposRelatorio[i].length() == 4) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlano[Integer.valueOf(this.camposRelatorio[i].substring(3, 4)) - 1];
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlano[Integer.valueOf(this.camposRelatorio[i].substring(3, 5)) - 1];
                            continue;
                        }
                        if (this.camposRelatorio[i].length() >= 17 && this.camposRelatorio[i].substring(0, 17).equals("somatorioComSinal")) {
                            auxSoma = "";
                            auxSoma = this.camposRelatorio[i].length() == 18 ? this.camposRelatorio[i].substring(17, 18) : this.camposRelatorio[i].substring(17, 19);
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(auxSoma) - 1];
                            continue;
                        }
                        if (this.camposRelatorio[i].length() >= 9 && this.camposRelatorio[i].substring(0, 9).equals("somatorio")) {
                            auxSoma = "";
                            auxSoma = this.camposRelatorio[i].length() == 10 ? this.camposRelatorio[i].substring(9, 10) : this.camposRelatorio[i].substring(9, 11);
                            if (this.tipoRelatorio == 0) {
                                if (rs.getString("tipoConta").equals("R")) {
                                    o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlano[Integer.valueOf(auxSoma) - 1];
                                    continue;
                                }
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.parseInt(auxSoma) - 1].floatValue() * -1.0f);
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = arrayDados[aux].valoresPlano[Integer.valueOf(auxSoma) - 1];
                            continue;
                        }
                        if (!this.naoContemCampoTotal(this.camposRelatorio[i])) continue;
                        o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                }
                if (modelo.getRowCount() > 0) {
                    if (buf != null) {
                        buf.delete(0, buf.length());
                    } else {
                        buf = new StringBuilder();
                    }
                    buf.append(" select SUM(case when plc.plc_operacao = '").append("A").append("' then ");
                    buf.append("                      lcp.lpl_valor ");
                    buf.append("            else (");
                    buf.append("                      lcp.lpl_valor * (-1) ) ");
                    buf.append("            end) as saldoInicial ");
                    buf.append("   from lanctocaixaplanoconta lcp ");
                    buf.append("       ,lanctocaixa lcx ");
                    buf.append("       ,planoconta plc ");
                    buf.append("  where lcp.fil_codigo = lcx.fil_codigo ");
                    buf.append("    and lcp.lcx_codigo = lcx.lcx_codigo ");
                    buf.append("    and lcp.fil_codigo = plc.fil_codigo ");
                    buf.append("    and lcp.plc_reduzido = plc.plc_reduzido ");
                    buf.append("    and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereAux);
                    buf.append("    and ").append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroDatas")]);
                    buf.append(" < '").append(Funcoes.formataData("yyyy-MM-dd", dataBase)).append("' ");
                    buf.append("    and lcx.fil_codigo ").append(filAux).append(" ");
                    if (this.tipoRelatorio == 1) {
                        String auxBuf = buf.toString();
                        auxBuf = auxBuf.replaceAll("plc", "ccu");
                        auxBuf = auxBuf.replaceAll("planoconta", "centrocusto");
                        auxBuf = auxBuf.replaceAll("lcp", "lcc");
                        auxBuf = auxBuf.replaceAll("lpl_valor", "lcc_valor");
                        auxBuf = auxBuf.replaceAll(", ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll(",ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(auxBuf);
                    }
                    if ((rs = st.executeQuery(buf.toString())).next()) {
                        for (int i = 0; i < modelo.getRowCount(); ++i) {
                            modelo.setValueAt(rs.getBigDecimal("saldoInicial"), i, modelo.findColumn("valorSaldoInicial"));
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(RelatorioFluxoCaixaMensal.getModuloAcesso(0));
                    } else {
                        buf.append(RelatorioFluxoCaixaMensal.getModuloAcesso(1));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioFluxoCaixaMensal.this.panelCentro.removeAll();
                                RelatorioFluxoCaixaMensal.this.panelCentro.repaint();
                                RelatorioFluxoCaixaMensal.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroNivel", this.getFiltroCombo("filtroNivel"));
                        var.put("filtroDatas", this.getFiltroCombo("filtroDatas"));
                        var.put("filtroMesInicial", this.getFiltroCombo("filtroMesInicial"));
                        var.put("filtroAnoInicial", this.getFiltroTexto("filtroAnoInicial"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put("filtroFilialConta", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (int i = 0; i < origem.length; ++i) {
                                buf.append(origem[i]);
                                if (i >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroOrigem", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block69;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean naoContemCampoTotal(String string) {
        for (int i = 0; i < this.camposTotal().length; ++i) {
            if (!this.camposTotal()[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    private int getIndicePlano(ArrayDados[] arr, int reduzidoPlano) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].reduzidoPlano != reduzidoPlano) continue;
            return i;
        }
        return -1;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850807100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850907100");
        }
        return Long.parseLong("0850807100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850807101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850907101");
        }
        return Long.parseLong("0850807101");
    }

    private String[] camposTotal() {
        return new String[]{"somaMesComSinal1", "somaMesComSinal2", "somaMesComSinal3", "somaMesComSinal4", "somaMesComSinal5", "somaMesComSinal6", "somaMesComSinal7", "somaMesComSinal8", "somaMesComSinal9", "somaMesComSinal10", "somaMesComSinal11", "somaMesComSinal12"};
    }

    class ArrayDados {
        protected int reduzidoPlano = -1;
        protected int paiPlano = -1;
        protected int nivelPlano = -1;
        protected Float[] valoresPlano = new Float[0];
        protected Float[] valoresPlanoComSinal = new Float[0];

        public ArrayDados(int reduzidoPlano, int paiPlano, int nivelPlano) {
            this.reduzidoPlano = reduzidoPlano;
            this.paiPlano = paiPlano;
            this.nivelPlano = nivelPlano;
            this.valoresPlano = new Float[RelatorioFluxoCaixaMensal.this.QTDE_PERIODOS];
            this.valoresPlanoComSinal = new Float[RelatorioFluxoCaixaMensal.this.QTDE_PERIODOS];
        }
    }
}

