/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioExtratoContaCorrente
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_CONTA_CORRENTE = "filtroContaCorrente";
    private final String FILTRO_SALDO_A_LIBERAR = "filtroSaldoALiberar";
    private final String FILTRO_CAMPO_DATA_LANCTO_NAO_CONC = "filtroCampoDataLanctoNaoConc";
    private final String FILTRO_CAMPO_DATA_LANCTO_CONC = "filtroCampoDataLanctoConc";
    private final String[] CAMPOS_DATA_CONCILIADOS = new String[]{"Concilia\u00e7\u00e3o", "Vencimento"};
    private final String[] CAMPOS_DATA = new String[]{"Vencimento", "Compet\u00eancia"};
    private final String[] CAMPOS_BANCO_DATA = new String[]{"lcx.lcx_vencimento", "lcx.lcx_competencia"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"dataConciliacaoApenasUmaLinha", "observacaoLancamento", "valorCredito", "valorDebito", "valorSaldo", "dataConciliacao", "codigoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "valorSaldoLiberar", "tipoLancamento", "isAberto", "dataSaldoAnterior", "valorSaldoAnterior", "valorSaldoAnteriorALiberar", "saldoFinalDisponivel", "descricaoHistoricoUsuario", "identificacaoPagamentoLancamento", "tipoPagamentoLancamento", "codigoConta", "contaConta", "codigoBancoConta", "emissaoLancamento", "vencimentoLancamento", "conciliacaoLancamento", "competenciaLancamento", "saldoTotal", "saldoALiberarTotal", "saldoDisponivelTotal", "saldoAnterior", "saldo", "identificacaoPagamentoLancamentoComObservacao"});
    private JComboBox auxComboListener;
    private JCheckBox auxCheckListener;

    public RelatorioExtratoContaCorrente() {
        this.montaBarraDescricao("Extrato de conta", "Listagem da movimenta\u00e7\u00e3o nas contas correntes", "relatorios/rel_financeiro_movimento_extrato_conta.jpg");
        this.adicionaRelatorioListener(this);
        if (!this.naoPermiteFiltrarFilial()) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroContaCorrente", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        this.adicionaFiltroCombo("filtroCampoDataLanctoConc", "Campo Data:", this.CAMPOS_DATA_CONCILIADOS, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.auxCheckListener = this.adicionaRetornaFiltroCheck("filtroSaldoALiberar", "Mostrar Saldo a Liberar", true);
        this.auxComboListener = this.adicionaRetornaFiltroCombo("filtroCampoDataLanctoNaoConc", "Data a Liberar:", this.CAMPOS_DATA, 0);
        ChangeListener listenerCheck = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == RelatorioExtratoContaCorrente.this.auxCheckListener) {
                    JCheckBox aux = (JCheckBox)e.getSource();
                    if (aux.isSelected()) {
                        RelatorioExtratoContaCorrente.this.auxComboListener.setEnabled(true);
                    } else {
                        RelatorioExtratoContaCorrente.this.auxComboListener.setEnabled(false);
                    }
                }
            }
        };
        this.auxCheckListener.addChangeListener(listenerCheck);
        this.setModuloAcesso(Long.parseLong("0851800100"));
        this.setModuloConfigurar(Long.parseLong("0851800101"));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void imprimirPressionado() {
        block96: {
            block97: {
                block94: {
                    block95: {
                        block92: {
                            block93: {
                                st = null;
                                filiais = null;
                                if (this.naoPermiteFiltrarFilial() || (filiais = this.getSelecionadosFiltro("filtroFilial", 0)) == null || filiais.length <= 1) break block92;
                                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                                this.habilitaBotaoImprimir(true);
                                if (st == null) break block93;
                                Conexao.fecharStatement(new Statement[]{st});
                            }
                            return;
                        }
                        if (!Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) break block94;
                        Funcoes.mensagem(this, "Insira uma data inicial para o relat\u00f3rio", 2);
                        this.habilitaBotaoImprimir(true);
                        if (st == null) break block95;
                        Conexao.fecharStatement(new Statement[]{st});
                    }
                    return;
                }
                contacorrente = this.getSelecionadosFiltro("filtroContaCorrente", 0);
                if (contacorrente != null) break block96;
                Funcoes.mensagem(this, "Selecione pelo menos uma conta para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                if (st == null) break block97;
                Conexao.fecharStatement(new Statement[]{st});
            }
            return;
        }
        try {
            mostrarALiberar = this.getFiltroCheck("filtroSaldoALiberar");
            campoBanco = null;
            indiceCombo = this.getFiltroComboIndice("filtroCampoDataLanctoNaoConc");
            if (indiceCombo >= 0) {
                campoBanco = this.CAMPOS_BANCO_DATA[indiceCombo];
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            buf = new StringBuilder();
            bufNaoConc = new StringBuilder();
            bufAux = new StringBuilder();
            bufSaldoAnterior = new StringBuilder();
            if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                buf.append("select lcx.lcx_conciliacao as dataConciliacaoApenasUmaLinha ");
            } else {
                buf.append("select lcx.lcx_vencimento as dataConciliacaoApenasUmaLinha ");
            }
            buf.append("\t\t\t,lcx.lcx_datahora    as emissaoLancamento ");
            buf.append("\t\t\t,lcx.lcx_vencimento  as vencimentoLancamento ");
            buf.append("\t\t\t,lcx.lcx_conciliacao as conciliacaoLancamento ");
            buf.append("\t\t\t,lcx.lcx_competencia as competenciaLancamento ");
            buf.append("\t\t\t,UPPER(lcx.lcx_obs)  as observacaoLancamento ");
            buf.append("\t\t\t,lcx.lcx_tipo        as tipoLancamento ");
            buf.append("\t\t\t,lcx.lcx_valortotal  as valorTotalLancamento ");
            if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                buf.append("      ,sld.sld_saldo       as valorSaldo ");
            } else {
                buf.append("      ,sld.slv_saldo       as valorSaldo ");
            }
            buf.append("      ,lcx.lcx_codigo      as codigoLancamento ");
            buf.append("      ,lcx.lcx_tipopagamento as tipoPagamentoLancamento ");
            buf.append("      ,CASE WHEN lcx.lcx_tipopagamento IN ('H', 'A', 'T', 'P') THEN ");
            buf.append("                      'CHQ ' || lcx.lcx_nrcheque ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'C' THEN ");
            buf.append("                      'CAR ' || lcx.lcx_nrcartao ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'I' THEN ");
            buf.append("                      'CAD ' || lcx.lcx_nrcartao ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'O' THEN ");
            buf.append("                      'CAC ' || lcx.lcx_nrcartao ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'Z' THEN ");
            buf.append("                      'AUT ' || lcx.lcx_documento ");
            buf.append("            ELSE lcx.lcx_obs END as identificacaoPagamentoLancamento ");
            buf.append("      ,CASE WHEN lcx.lcx_tipopagamento IN ('H', 'A', 'T', 'P') THEN ");
            buf.append("                      'CHQ ' || lcx.lcx_nrcheque || ' - ' || lcx.lcx_obs ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'C' THEN ");
            buf.append("                      'CAR ' || lcx.lcx_nrcartao || ' - ' || lcx.lcx_obs ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'I' THEN ");
            buf.append("                      'CAD ' || lcx.lcx_nrcartao || ' - ' || lcx.lcx_obs ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'O' THEN ");
            buf.append("                      'CAC ' || lcx.lcx_nrcartao || ' - ' || lcx.lcx_obs ");
            buf.append("            WHEN lcx.lcx_tipopagamento = 'Z' THEN ");
            buf.append("                      'AUT ' || lcx.lcx_documento || ' - ' || lcx.lcx_obs ");
            buf.append("            ELSE lcx.lcx_obs END as identificacaoPagamentoLancamentoComObservacao ");
            buf.append("      ,lcx.lcx_descricaohistorico as descricaoHistoricoUsuario ");
            buf.append("      ,hpa.hpa_codigo      as codigoHistoricoPadrao ");
            buf.append("      ,hpa.hpa_descricao   as descricaoHistoricoPadrao ");
            buf.append("      ,case when lcx.lcx_situacao = '").append("A").append("' then true else false end as isAberto ");
            buf.append("      ,a.cco_reduzido as codigoConta ");
            buf.append("      ,a.cco_conta as contaConta ");
            buf.append("      ,a.bac_codigo as codigoBancoConta ");
            buf.append("      ,");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("\t\tfrom contacorrente a ");
            buf.append("    join lanctocaixa   lcx on (lcx.cco_reduzido = a.cco_reduzido and lcx.fil_codigo = a.fil_codigo) ");
            buf.append("    left join historicopadrao hpa on (lcx.hpa_codigo = hpa.hpa_codigo and lcx.fil_codigo = hpa.fil_codigo) ");
            if (mostrarALiberar) {
                aux = buf.toString();
                if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                    aux = aux.replaceAll("lcx.lcx_conciliacao", campoBanco);
                    aux = aux.replaceAll("sld.sld_saldo", "null");
                } else {
                    aux = aux.replaceAll("lcx.lcx_vencimento", campoBanco);
                    aux = aux.replaceAll("sld.slv_saldo", "null");
                }
                bufNaoConc.append(aux);
            }
            if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                buf.append(" join saldocontas sld on (sld.cco_reduzido = a.cco_reduzido and sld.fil_codigo = a.fil_codigo and sld.sld_data = lcx.lcx_conciliacao) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            } else {
                buf.append(" join saldocontasvencimento sld on (sld.cco_reduzido = a.cco_reduzido and sld.fil_codigo = a.fil_codigo and sld.slv_data = lcx.lcx_vencimento) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            if (mostrarALiberar) {
                bufNaoConc.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                bufNaoConc.append(" where ");
                bufNaoConc.append(" lcx.lcx_situacao = '").append("A").append("' ");
                bufSaldoAnterior.append(" lcx.lcx_situacao = '").append("A").append("' ");
            }
            buf.append("   where (lcx.lcx_conciliacao is not null and lcx.lcx_situacao <> '").append("C").append("') ");
            buf.append("     and a.fil_codigo = ");
            bufNaoConc.append(" and a.fil_codigo = ");
            bufSaldoAnterior.append(" and a.fil_codigo = ");
            if (filiais == null || filiais.length == 0 || this.naoPermiteFiltrarFilial()) {
                bufAux.append(Variaveis.filialPadrao);
            } else {
                bufAux.append(filiais[0]);
            }
            buf.append(bufAux.toString());
            bufNaoConc.append(bufAux.toString());
            bufSaldoAnterior.append(bufAux.toString());
            bufAux = new StringBuilder();
            bufAux.append(" and a.cco_reduzido in(");
            for (i = 0; i < contacorrente.length; ++i) {
                bufAux.append(contacorrente[i]);
                if (i >= contacorrente.length - 1) continue;
                bufAux.append(", ");
            }
            bufAux.append(")");
            buf.append(bufAux.toString());
            bufNaoConc.append(bufAux.toString());
            bufSaldoAnterior.append(bufAux.toString());
            if (mostrarALiberar) {
                bufAux = new StringBuilder();
                bufAux.append(" select a.cco_reduzido as codigoConta, SUM(CASE WHEN lcx.lcx_tipo = 'C' THEN lcx.lcx_valortotal ELSE lcx.lcx_valortotal * (-1) END) as valorSaldoAnteriorALiberar ");
                bufAux.append("   from contacorrente a ");
                bufAux.append("   join lanctocaixa lcx on (lcx.cco_reduzido = a.cco_reduzido and lcx.fil_codigo = a.fil_codigo) ");
                bufAux.append("  where  ");
                bufSaldoAnterior.insert(0, bufAux.toString());
                bufSaldoAnterior.append(" and ");
                bufSaldoAnterior.append(" cast(lcx.lcx_vencimento as date) < '");
                bufSaldoAnterior.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufSaldoAnterior.append("'");
                bufSaldoAnterior.append(" group by a.cco_reduzido ");
            }
            bufAux = new StringBuilder();
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufAux.append(" and ");
                if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                    bufAux.append(" cast(lcx.lcx_conciliacao as date) >= '");
                } else {
                    bufAux.append(" cast(lcx.lcx_vencimento as date) >= '");
                }
                bufAux.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufAux.append("'");
            }
            buf.append(bufAux.toString());
            bufNaoConc.append(bufAux.toString().replaceAll("lcx.lcx_conciliacao", campoBanco));
            bufAux = new StringBuilder();
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufAux.append(" and ");
                if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                    bufAux.append(" cast(lcx.lcx_conciliacao as date) <= '");
                } else {
                    bufAux.append(" cast(lcx.lcx_vencimento as date) <= '");
                }
                bufAux.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                bufAux.append("'");
            }
            buf.append(bufAux.toString());
            bufNaoConc.append(bufAux.toString().replaceAll("lcx.lcx_conciliacao", campoBanco));
            if (mostrarALiberar) {
                buf.append(" UNION ").append(bufNaoConc.toString());
            }
            st = Conexao.getStatement();
            bufSaldo = new StringBuilder();
            arrayContas = new ArrayDadosIniciaisConta();
            if (this.getFiltroCombo("filtroCampoDataLanctoConc").equals("Concilia\u00e7\u00e3o")) {
                bufSaldo.append(" select sld_data as data, ");
                bufSaldo.append("        sld_saldo as valor, ");
                bufSaldo.append("        cco_reduzido as codigoConta ");
                bufSaldo.append("   from saldocontas sld ");
                bufSaldo.append("  where ");
                if (filiais != null) {
                    bufSaldo.append("   sld.fil_codigo = ").append(filiais[0]);
                } else {
                    bufSaldo.append("   sld.fil_codigo = ").append(Variaveis.filialPadrao);
                }
                bufSaldo.append("        and (sld.sld_data, sld.cco_reduzido) IN ( ");
                bufSaldo.append("        select MAX(sld_data), ");
                bufSaldo.append("               cco_reduzido ");
                bufSaldo.append("          from saldocontas ");
                bufSaldo.append("         where cast(sld_data as date) < '");
                bufSaldo.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufSaldo.append("'");
                bufSaldo.append("   and cco_reduzido IN (");
                for (i = 0; i < contacorrente.length; ++i) {
                    bufSaldo.append(contacorrente[i]);
                    if (i >= contacorrente.length - 1) continue;
                    bufSaldo.append(", ");
                }
                bufSaldo.append(")");
                if (filiais != null) {
                    bufSaldo.append("   and fil_codigo = ").append(filiais[0]);
                } else {
                    bufSaldo.append("   and fil_codigo = ").append(Variaveis.filialPadrao);
                }
                bufSaldo.append(" group by cco_reduzido) ");
            } else {
                bufSaldo.append(" select slv_data as data, ");
                bufSaldo.append("        slv_saldo as valor, ");
                bufSaldo.append("        cco_reduzido as codigoConta ");
                bufSaldo.append("   from saldocontasvencimento slv ");
                bufSaldo.append("  where ");
                if (filiais != null) {
                    bufSaldo.append("   slv.fil_codigo = ").append(filiais[0]);
                } else {
                    bufSaldo.append("   slv.fil_codigo = ").append(Variaveis.filialPadrao);
                }
                bufSaldo.append("     and  (slv.slv_data, slv.cco_reduzido) IN ( ");
                bufSaldo.append("        select MAX(slv_data), ");
                bufSaldo.append("               cco_reduzido ");
                bufSaldo.append("          from saldocontasvencimento ");
                bufSaldo.append("         where cast(slv_data as date) < '");
                bufSaldo.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufSaldo.append("'");
                bufSaldo.append("   and cco_reduzido IN (");
                for (i = 0; i < contacorrente.length; ++i) {
                    bufSaldo.append(contacorrente[i]);
                    if (i >= contacorrente.length - 1) continue;
                    bufSaldo.append(", ");
                }
                bufSaldo.append(")");
                if (filiais != null) {
                    bufSaldo.append("   and fil_codigo = ").append(filiais[0]);
                } else {
                    bufSaldo.append("   and fil_codigo = ").append(Variaveis.filialPadrao);
                }
                bufSaldo.append(" group by cco_reduzido) ");
            }
            rs = Conexao.executeQuery(st, bufSaldo.toString());
            if (rs.next()) {
                do {
                    arrayContas.adicionaDadosIniciais(rs.getInt("codigoConta"), rs.getDate("data"), rs.getBigDecimal("valor"), BigDecimal.ZERO, BigDecimal.ZERO, null);
                } while (rs.next());
            }
            bufSaldo.setLength(0);
            bufSaldo.append("select cco_sldinicial as valor ");
            bufSaldo.append("      ,cco_dtsldinicial as data ");
            bufSaldo.append("      ,cco_reduzido as codigoConta ");
            bufSaldo.append("  from contacorrente ");
            bufSaldo.append(" where cco_reduzido IN (");
            for (i = 0; i < contacorrente.length; ++i) {
                bufSaldo.append(contacorrente[i]);
                if (i >= contacorrente.length - 1) continue;
                bufSaldo.append(", ");
            }
            bufSaldo.append(")");
            if (filiais != null) {
                bufSaldo.append(" and fil_codigo = ").append(filiais[0]);
            } else {
                bufSaldo.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
            }
            rs = Conexao.executeQuery(st, bufSaldo.toString());
            if (rs.next()) {
                do {
                    if (arrayContas.getSaldoInicialConta(rs.getInt("codigoConta")) != null) continue;
                    arrayContas.adicionaDadosIniciais(rs.getInt("codigoConta"), rs.getDate("data"), rs.getBigDecimal("valor"), BigDecimal.ZERO, BigDecimal.ZERO, null);
                } while (rs.next());
            }
            if (mostrarALiberar && (rs = Conexao.executeQuery(st, bufSaldoAnterior.toString())).next()) {
                do {
                    arrayContas.setSaldoInicialALiberarConta(rs.getInt("codigoConta"), rs.getBigDecimal("valorSaldoAnteriorALiberar"));
                } while (rs.next());
            }
            buf.append(" order by codigoConta, dataConciliacaoApenasUmaLinha, codigoLancamento ");
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                modelo = new ModeloGridTable(RelatorioExtratoContaCorrente.camposRelatorio);
                dataAnt = "";
                contaAnt = -1;
                o = new Object[RelatorioExtratoContaCorrente.camposRelatorio.length];
                do {
                    o = new Object[RelatorioExtratoContaCorrente.camposRelatorio.length];
                    for (i = 0; i < RelatorioExtratoContaCorrente.camposRelatorio.length; ++i) {
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("dataConciliacao")) {
                            o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getObject("dataConciliacaoApenasUmaLinha");
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("dataConciliacaoApenasUmaLinha")) {
                            if (!rs.getString(RelatorioExtratoContaCorrente.camposRelatorio[i]).toString().equals(dataAnt.toString()) || contaAnt != rs.getInt("codigoConta")) {
                                o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getObject(RelatorioExtratoContaCorrente.camposRelatorio[i]);
                            }
                            dataAnt = rs.getObject(RelatorioExtratoContaCorrente.camposRelatorio[i]);
                            contaAnt = rs.getInt("codigoConta");
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorCredito")) {
                            if (rs.getString("tipoLancamento") != null && rs.getString("tipoLancamento").equals("C")) {
                                o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getBigDecimal("valorTotalLancamento");
                                if (!rs.getBoolean("isAberto")) continue;
                                conta = rs.getInt("codigoConta");
                                if (rs.getBigDecimal("valorTotalLancamento") == null) continue;
                                arrayContas.setSaldoALiberarConta(conta, arrayContas.getSaldoALiberarConta(conta).add(rs.getBigDecimal("valorTotalLancamento")));
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = Float.valueOf(0.0f);
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorDebito")) {
                            if (rs.getString("tipoLancamento") != null && rs.getString("tipoLancamento").equals("D")) {
                                o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getBigDecimal("valorTotalLancamento");
                                if (!rs.getBoolean("isAberto")) continue;
                                conta = rs.getInt("codigoConta");
                                if (rs.getBigDecimal("valorTotalLancamento") == null) continue;
                                arrayContas.setSaldoALiberarConta(conta, arrayContas.getSaldoALiberarConta(conta).subtract(rs.getBigDecimal("valorTotalLancamento")));
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = Float.valueOf(0.0f);
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorSaldo")) {
                            saldo = rs.getBigDecimal("valorSaldo");
                            o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = saldo;
                            if (saldo == null) continue;
                            arrayContas.setSaldo(rs.getInt("codigoConta"), saldo);
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorSaldoLiberar")) {
                            o[modelo.findColumn((String)"valorSaldoLiberar")] = arrayContas.getSaldoALiberarConta(rs.getInt("codigoConta"));
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldoFinalDisponivel")) {
                            if (rs.getBigDecimal("valorSaldo") != null) {
                                o[modelo.findColumn((String)"saldoFinalDisponivel")] = rs.getBigDecimal("valorSaldo").add(arrayContas.getSaldoALiberarConta(rs.getInt("codigoConta")));
                                continue;
                            }
                            o[modelo.findColumn((String)"saldoFinalDisponivel")] = null;
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("dataSaldoAnterior")) {
                            o[modelo.findColumn((String)"dataSaldoAnterior")] = arrayContas.getDataInicialConta(rs.getInt("codigoConta"));
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorSaldoAnterior")) {
                            conta = rs.getInt("codigoConta");
                            saldoInicial = arrayContas.getSaldoInicialConta(conta);
                            o[modelo.findColumn((String)"valorSaldoAnterior")] = saldoInicial;
                            if (arrayContas.getSaldo(conta) != null) continue;
                            arrayContas.setSaldo(conta, saldoInicial);
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("valorSaldoAnteriorALiberar")) {
                            o[modelo.findColumn((String)"valorSaldoAnteriorALiberar")] = arrayContas.getSaldoInicialALiberarConta(rs.getInt("codigoConta"));
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("tipoPagamentoLancamento")) {
                            o[modelo.findColumn((String)"tipoPagamentoLancamento")] = Tipos.tipoPagamento(rs.getString(RelatorioExtratoContaCorrente.camposRelatorio[i]));
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("identificacaoPagamentoLancamento")) {
                            o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getObject(RelatorioExtratoContaCorrente.camposRelatorio[i]);
                            continue;
                        }
                        if (RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldoTotal") || RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldoALiberarTotal") || RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldoDisponivelTotal") || RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldoAnterior") || RelatorioExtratoContaCorrente.camposRelatorio[i].equals("saldo")) continue;
                        o[modelo.findColumn((String)RelatorioExtratoContaCorrente.camposRelatorio[i])] = rs.getObject(RelatorioExtratoContaCorrente.camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                saldoInicial = null;
                saldoInicialALiberar = null;
                contaAux = -1;
                for (i = 0; i < modelo.getRowCount(); ++i) {
                    if (saldoInicial == null || contaAux == -1) {
                        contaAux = (Integer)modelo.getValueAt(i, modelo.findColumn("codigoConta"));
                        saldoInicial = arrayContas.getSaldoInicialConta(contaAux);
                        saldoInicialALiberar = arrayContas.getSaldoInicialALiberarConta(contaAux);
                    } else if (contaAux.intValue() != ((Integer)modelo.getValueAt(i, modelo.findColumn("codigoConta"))).intValue()) {
                        contaAux = -1;
                        saldoInicial = null;
                        saldoInicialALiberar = null;
                        --i;
                        continue;
                    }
                    if (modelo.getValueAt(i, modelo.findColumn("valorSaldo")) == null) {
                        modelo.setValueAt(saldoInicial, i, modelo.findColumn("valorSaldo"));
                    }
                    if (mostrarALiberar && modelo.getValueAt(i, modelo.findColumn("valorSaldoAnteriorALiberar")) == null) {
                        modelo.setValueAt(saldoInicialALiberar, i, modelo.findColumn("valorSaldoAnteriorALiberar"));
                    }
                    if (modelo.getValueAt(i, modelo.findColumn("saldoFinalDisponivel")) == null) {
                        modelo.setValueAt(((BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldo"))).add((BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldoLiberar"))), i, modelo.findColumn("saldoFinalDisponivel"));
                    }
                    saldoInicial = new BigDecimal(((BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldo"))).doubleValue());
                    saldoAnterior = (BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldoAnterior"));
                    saldoAnteriorALiberar = (BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldoAnteriorALiberar"));
                    modelo.setValueAt(saldoAnterior.add(saldoAnteriorALiberar), i, modelo.findColumn("saldoAnterior"));
                    saldoLiberar = (BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorSaldoLiberar"));
                    modelo.setValueAt(saldoInicial.add(saldoLiberar).add(saldoAnteriorALiberar), i, modelo.findColumn("saldo"));
                }
                saldoTotal = BigDecimal.ZERO;
                saldoALiberarTotal = BigDecimal.ZERO;
                saldoDisponivelTotal = BigDecimal.ZERO;
                for (i = 0; i < contacorrente.length; ++i) {
                    conta = Integer.parseInt(contacorrente[i]);
                    saldoDisponivelTotal = saldoDisponivelTotal.add(arrayContas.getSaldo(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldo(conta));
                    saldoALiberarTotal = saldoALiberarTotal.add(arrayContas.getSaldoALiberarConta(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldoALiberarConta(conta)).add(arrayContas.getSaldoInicialALiberarConta(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldoInicialALiberarConta(conta));
                    saldoTotal = saldoTotal.add(arrayContas.getSaldo(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldo(conta)).add(arrayContas.getSaldoALiberarConta(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldoALiberarConta(conta)).add(arrayContas.getSaldoInicialALiberarConta(conta) == null ? BigDecimal.ZERO : arrayContas.getSaldoInicialALiberarConta(conta));
                }
                for (i = 0; i < modelo.getRowCount(); ++i) {
                    modelo.setValueAt(saldoTotal, i, modelo.findColumn("saldoTotal"));
                    modelo.setValueAt(saldoALiberarTotal, i, modelo.findColumn("saldoALiberarTotal"));
                    modelo.setValueAt(saldoDisponivelTotal, i, modelo.findColumn("saldoDisponivelTotal"));
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                if (!mostrarALiberar) {
                    buf.append(RelatorioExtratoContaCorrente.getModuloAcesso());
                } else {
                    buf.append(Long.parseLong("0851800100"));
                }
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExtratoContaCorrente.this.panelCentro.removeAll();
                            RelatorioExtratoContaCorrente.this.panelCentro.repaint();
                            RelatorioExtratoContaCorrente.this.habilitaBotaoImprimir(true);
                        }
                    });
                    var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroCampoDataLanctoConc", this.CAMPOS_DATA_CONCILIADOS[this.getFiltroComboIndice("filtroCampoDataLanctoConc")]);
                    var.put("filtroCampoDataLanctoNaoConc", this.CAMPOS_DATA[this.getFiltroComboIndice("filtroCampoDataLanctoNaoConc")]);
                    if (this.getFiltroCheck("filtroSaldoALiberar")) {
                        var.put("filtroSaldoALiberar", true);
                    } else {
                        var.put("filtroSaldoALiberar", false);
                    }
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    if (buf.length() == 0) {
                        buf.append(Variaveis.filialPadrao);
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (contacorrente != null) {
                        for (i = 0; i < contacorrente.length; ++i) {
                            buf.append(contacorrente[i]);
                            if (i >= contacorrente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroContaCorrente", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            ** if (st == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                ** if (st == null) goto lbl-1000
            }
            catch (Throwable var27_40) {
                if (st != null) {
                    Conexao.fecharStatement(new Statement[]{st});
                }
                throw var27_40;
            }
lbl-1000:
            // 1 sources

            {
                Conexao.fecharStatement(new Statement[]{st});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Conexao.fecharStatement(new Statement[]{st});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850300100");
    }

    public long getConfigurarAcesso() {
        return Long.parseLong("0850300101");
    }

    public static long getModuloAcessoNaoPermiteFiltrarFilial() {
        return Long.parseLong("0851800102");
    }

    public boolean naoPermiteFiltrarFilial() {
        return Acesso.getAcesso(RelatorioExtratoContaCorrente.getModuloAcessoNaoPermiteFiltrarFilial());
    }

    class ArrayDadosIniciaisConta {
        ArrayList<Integer> codigoConta = new ArrayList();
        ArrayList<Date> dataInicial = new ArrayList();
        ArrayList<BigDecimal> saldoInicial = new ArrayList();
        ArrayList<BigDecimal> saldoInicialALiberar = new ArrayList();
        ArrayList<BigDecimal> saldoALiberar = new ArrayList();
        ArrayList<BigDecimal> saldo = new ArrayList();

        public void adicionaDadosIniciais(Integer codigoConta, Date dataInicial, BigDecimal saldoInicial, BigDecimal saldoInicialALiberar, BigDecimal saldoALiberar, BigDecimal saldo) {
            this.codigoConta.add(codigoConta);
            this.dataInicial.add(dataInicial);
            this.saldoInicial.add(saldoInicial);
            this.saldoInicialALiberar.add(saldoInicialALiberar);
            this.saldoALiberar.add(saldoALiberar);
            this.saldo.add(saldo);
        }

        private int getPosicaoConta(Integer conta) {
            for (int i = 0; i < this.codigoConta.size(); ++i) {
                if (this.codigoConta.get(i).intValue() != conta.intValue()) continue;
                return i;
            }
            return -1;
        }

        public Date getDataInicialConta(Integer conta) {
            int posicao = this.getPosicaoConta(conta);
            return posicao != -1 ? this.dataInicial.get(posicao) : null;
        }

        public BigDecimal getSaldoInicialConta(Integer conta) {
            int posicao = this.getPosicaoConta(conta);
            return posicao != -1 ? this.saldoInicial.get(posicao) : null;
        }

        public BigDecimal getSaldoInicialALiberarConta(Integer conta) {
            int posicao = this.getPosicaoConta(conta);
            return posicao != -1 ? this.saldoInicialALiberar.get(posicao) : null;
        }

        public BigDecimal getSaldoALiberarConta(Integer conta) {
            int posicao = this.getPosicaoConta(conta);
            return posicao != -1 ? this.saldoALiberar.get(posicao) : BigDecimal.ZERO;
        }

        public BigDecimal getSaldo(Integer conta) {
            int posicao = this.getPosicaoConta(conta);
            return posicao != -1 ? this.saldo.get(posicao) : BigDecimal.ZERO;
        }

        public void setDataInicialConta(Integer conta, Date dataInicial) {
            int posicao = this.getPosicaoConta(conta);
            if (posicao != -1) {
                this.dataInicial.set(posicao, dataInicial);
            }
        }

        public void setSaldoInicialConta(Integer conta, BigDecimal saldoInicial) {
            int posicao = this.getPosicaoConta(conta);
            if (posicao != -1) {
                this.saldoInicial.set(posicao, saldoInicial);
            }
        }

        public void setSaldoInicialALiberarConta(Integer conta, BigDecimal saldoInicialALiberar) {
            int posicao = this.getPosicaoConta(conta);
            if (posicao != -1) {
                this.saldoInicialALiberar.set(posicao, saldoInicialALiberar);
            }
        }

        public void setSaldoALiberarConta(Integer conta, BigDecimal saldoInicialALiberar) {
            int posicao = this.getPosicaoConta(conta);
            if (posicao != -1) {
                this.saldoALiberar.set(posicao, saldoInicialALiberar);
            }
        }

        public void setSaldo(Integer conta, BigDecimal saldo) {
            int posicao = this.getPosicaoConta(conta);
            if (posicao != -1) {
                this.saldo.set(posicao, saldo);
            }
        }
    }
}

