/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioDetalhamentoImpostos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_CLIENTE = 0;
    private static int tipoRelatorio = 0;
    private final int ORDEM_CPFCNPJ = 6;
    private final String[] ORDEM = new String[]{"Vencimento", "N\u00famero NF", "Valor Bruto", "Vlr. L\u00edquido", "Fantasia", "Dt. Pagto.", "CPF/Cnpj"};
    private final String[] CAMPOSBANCOORDEM = new String[]{"dataVencimentoReceberPagar", "numeroNotaFiscal", "valorReceberPagarComSinal", "valorTotalReceberPagarComSinal", "fantasiaCadastro", "dataBaixaReceberPagar", "cpfCnpjCadastro"};
    private final String[] SITUACAO = new String[]{"Todas", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("A") + " e " + Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("L"), Tipos.tipoSituacaoReceberPagar("G"), Tipos.tipoSituacaoReceberPagar("E"), Tipos.tipoSituacaoReceberPagar("R"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S"), Tipos.tipoSituacaoReceberPagar("N")};
    private final String[] TIPO = new String[]{"Todos", Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")};
    private final String[] TIPOCADASTRO = new String[]{"Todos", Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")};
    private final String[] TIPODOCUMENTO = new String[]{"Todos", Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Data da Baixa"};
    private final String[] CAMPOSDATABANCO = new String[]{"a.rpg_vencimento", "a.rpg_competencia", "a.rpg_datahora", "brp.bxa_datahora"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_SERIE = "filtroSerie";
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO_CADASTRO = "filtroTipoCadastro";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_TIPO_DOCUMENTO = "filtroTipoDocumento";
    private final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String[] camposCadastros = new String[]{"tipoLogradouroCadastro", "codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "cpfCnpjCadastro", "tipoPessoa"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorTotalReceberPagarComSinal", "valorReceberPagarComSinal", "valorImpostosReceberPagarComSinal", "valorTaxaTotalReceberPagarComSinal", "valorDescontoReceberPagarComSinal", "dataBaixaReceberPagar", "valorTotalReceberPagar", "numeroNotaFiscal", "situacaoNotaFiscal", "serieNotaFiscal", "descricaoFormaPgto", "valorJurosReceberPagarComSinal", "valorMultaReceberPagarComSinal", "valorAcrescimoReceberPagarComSinal", "valorDescontoReceberPagarComSinal", "valorTaxaReceberPagarComSinal", "valorIrrfReceberPagarComSinal", "valorIssReceberPagarComSinal", "valorPisReceberPagarComSinal", "valorCsllReceberPagarComSinal", "valorCofinsReceberPagarComSinal", "valorInssReceberPagarComSinal", "valorIpiReceberPagar", "valorIpiReceberPagarComSinal", "percentualIpiReceberPagar", "valorIcmsReceberPagar", "valorIcmsReceberPagarComSinal", "percentualIcmsReceberPagar"});
    private static final String[] camposBaixa = new String[]{"dataBaixa", "qtdeTitulosBaixa", "valorTotalBaixa", "tipoBaixa"};
    private String[] campos = ArraysUtil.concatenar(this.campos, camposBaixa);

    public RelatorioDetalhamentoImpostos(int tipoRelatorio) {
        RelatorioDetalhamentoImpostos.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de detalhamento de impostos", "Listagem de contas a pagar e receber com impostos detalhados", "relatorios/rel_financeiro_movimento_detalhamento_imposto.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false ", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroSerie", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Doc:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroTipoCadastro", "Cadastro:", this.TIPOCADASTRO, 0);
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.TIPO, 0);
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.SITUACAO, 0);
        this.adicionaFiltroCombo("filtroTipoDocumento", "Tipo Doc:", this.TIPODOCUMENTO, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ORDEM, 0);
        this.setModuloConfigurar(RelatorioDetalhamentoImpostos.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioDetalhamentoImpostos.getModuloAcesso(tipoRelatorio));
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block96: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            try {
                String[] serie;
                String[] paciente;
                String[] entidade;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("\t\t\t\ta.rpg_valor as valorReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_taxa as valorTaxaReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_valoracrescimo as valorAcrescimoReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valordesconto, 0) as valorDescontoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_codigo as codigoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_datahora as dataHoraReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_vencimento as dataVencimentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_competencia as dataCompetenciaReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_tipojuros as tipoJurosReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_tipo as tipoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_numerodocumento as numeroDocumentoReceberPagar,  ");
                buf.append("\t\t\t\ta.rpg_parcela as numeroParcelaReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_obs as observacaoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_tipocadastro as tipoCadastroReceberPagar, ");
                buf.append("\t\t\t\tusrrecpag.usr_codigo as codigoUsuarioReceberPagar, ");
                buf.append("\t\t\t\tusrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
                buf.append("\t\t\t\tusuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, ");
                buf.append("\t\t\t\tusuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_datacancelado as dataCancelamentoReceberPagar, ");
                buf.append("\t\t\t\ta.rpg_situacao as situacaoReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valor, 0) + COALESCE(a.rpg_taxa, 0) as valorComTaxaReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valorjuro, 0) as valorJuroReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valormulta, 0) as valorMultaReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valoracrescimo, 0) as valorAcrescimoReceberPagar, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valortotal ELSE a.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valor ELSE a.rpg_valor * (-1) END as valorReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valorjuro ELSE a.rpg_valorjuro * (-1) END as valorJurosReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valormulta ELSE a.rpg_valormulta * (-1) END as valorMultaReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valoracrescimo ELSE a.rpg_valoracrescimo * (-1) END as valorAcrescimoReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valordesconto * (-1) ELSE a.rpg_valordesconto END as valorDescontoReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_taxa ELSE a.rpg_taxa * (-1) END as valorTaxaReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_irrfvalor * (-1), 0) as valorIrrfReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_issvalor * (-1), 0) as valorIssReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_pisvalor * (-1), 0) as valorPisReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_csllvalor * (-1), 0) as valorCsllReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_cofinsvalor * (-1), 0) as valorCofinsReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_inssvalor * (-1), 0) as valorInssReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_ipivalor * (-1), 0) as valorIpiReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_icmsvalor * (-1), 0) as valorIcmsReceberPagarComSinal, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_percentualmulta, 0) as percentualMultaReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_percentualjuro, 0) as percentualJuroReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_percentualacrescimo, 0) as percentualAcrescimoReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_percentualdesconto, 0) as percentualDescontoReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_irrfvalor, 0) as valorIrrfReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_irrfpercentual, 0) as percentualIrrfReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_issvalor, 0) as valorIssReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_isspercentual, 0) as percentualIssReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_pisvalor, 0) as valorPisReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_pispercentual, 0) as percentualPisReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_csllvalor, 0) as valorCsllReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_csllpercentual, 0) as percentualCsllReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_cofinsvalor, 0) as valorCofinsReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_cofinspercentual, 0) as percentualCofinsReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_inssvalor, 0) as valorInssReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_insspercentual, 0) as percentualInssReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_ipivalor, 0) as valorIpiReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_ipipercentual, 0) as percentualIpiReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_icmsvalor, 0) as valorIcmsReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_icmspercentual, 0) as percentualIcmsReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE( ");
                buf.append("    \t\t\t\t(case when a.nfi_codigo is null then ");
                buf.append("          \t\t\t\t     a.rpg_irrfvalor + a.rpg_issvalor + a.rpg_pisvalor + a.rpg_csllvalor + a.rpg_cofinsvalor + a.rpg_inssvalor + a.rpg_ipivalor + a.rpg_icmsvalor ");
                buf.append("     \t\t\t\t      else ");
                buf.append("          \t\t\t\t\t\t nfi.nfi_irrfvalor + nfi.nfi_issvalor + nfi.nfi_pisvalor + nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor + nfi.nfi_ipivalor + nfi.nfi_icmsvalor ");
                buf.append("                  end), 0) as valorImpostosReceberPagar, ");
                buf.append("\t\t\t\tCOALESCE(a.rpg_valormulta + a.rpg_valoracrescimo + a.rpg_valorjuro, 0) as valorTaxaTotalReceberPagar, ");
                buf.append("\t\t\t\ta.ser_codigo as codigoSerie, ");
                buf.append("\t\t\t\ts.ser_descricao as descricaoSerie, ");
                buf.append("\t\t\t\tcase when a.rpg_tipocadastro = '").append("O").append("' then a.con_codigo ");
                buf.append("  \t\t\t\t\t when a.rpg_tipocadastro = '").append("P").append("' then a.pac_codigo ");
                buf.append("  \t\t\t\t\t when a.rpg_tipocadastro = '").append("U").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\t\t when a.rpg_tipocadastro = '").append("F").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\t\t when a.rpg_tipocadastro = '").append("C").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\t\t when a.rpg_tipocadastro = '").append("R").append("' then a.ent_codigo ");
                buf.append("  \t\t\telse a.ent_codigo ");
                buf.append("\t\t\t  end as codigoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fantasia ");
                buf.append("  \t\t\t\t\telse con.con_fantasia ");
                buf.append("\t\t\t end as fantasiaCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append("  \t\t\t\t\telse '' ");
                buf.append("\t\t\t end as nomeSocialPaciente ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_razaosocial ");
                buf.append("  \t\t\t\t\telse con.con_razao ");
                buf.append("\t\t\t end as razaoSocialCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fone ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fone ");
                buf.append("  \t\t\t\t\telse con.con_fone ");
                buf.append("\t\t\t end as foneCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_endereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_endereco ");
                buf.append("  \t\t\t\t\telse con.con_endereco ");
                buf.append("\t\t\t end as enderecoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_numeroendereco ");
                buf.append("  \t\t\t\t\telse con.con_numeroendereco ");
                buf.append("\t\t\t end as numeroEnderecoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_tipologradouroendereco ");
                buf.append("  \t\t\t\t\telse con.con_tipologradouroendereco ");
                buf.append("\t\t\t end as tipoLogradouroCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fax ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fax ");
                buf.append("  \t\t\t\t\telse con.con_fax ");
                buf.append("\t\t\t end as faxCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_complemento ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_complemento ");
                buf.append("  \t\t\t\t\telse con.con_complemento ");
                buf.append("\t\t\t end as complementoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_cep ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cep ");
                buf.append("  \t\t\t\t\telse con.con_cep ");
                buf.append("\t\t\t end as cepCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then COALESCE(pac.pac_cpf, pac.pac_cnpj) ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cpfcnpj ");
                buf.append("  \t\t\t\t\telse con.con_cnpjcpf ");
                buf.append("\t\t\t end as cpfCnpjCadastro, ");
                buf.append("\t\t\t nfi.nfi_numero as numeroNotaFiscal, ");
                buf.append("\t\t\t nfi.ser_codigo as serieNotaFiscal, ");
                buf.append("\t\t\t nfi.nfi_situacao as situacaoNotaFiscal, ");
                buf.append("       nfi.nfi_numerorps IS NOT NULL as isEletronica, ");
                buf.append("\t\t\t fpg.fpg_descricao as descricaoFormaPgto, ");
                buf.append("       CASE WHEN a.rpg_situacao = 'Q' THEN cast(brp.bxa_datahora as text) ELSE cast(a.rpg_situacao as text) END as dataBaixaReceberPagar, ");
                buf.append("      case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_tipopessoa ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_tipopessoa ");
                buf.append("  \t\t\t\t\twhen a.con_codigo is not null then con.con_tipopessoa ");
                buf.append("\t\t\t end as tipoPessoa, ");
                if (this.getFiltroCombo("filtroCampoData").equals(this.CAMPOSDATA[3])) {
                    buf.append(" brp.bxa_datahora as dataBaixa, ");
                    buf.append(" brp.bxa_quantidadetitulos as qtdeTitulosBaixa, ");
                    buf.append(" brp.bxa_valortotal as valorTotalBaixa, ");
                    buf.append(" brp.bxa_tipo as tipoBaixa, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("\t\t\t  from receberpagar a ");
                buf.append("\t\t\t\tleft join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append("\t\t\t\tleft join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("\t\t\t\tleft join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo  = s.ser_codigo ");
                buf.append("\t\t\t\tleft join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("\t\t\t\tleft join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("\t\t\t\tleft join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
                buf.append("\t\t\t \tleft join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
                buf.append("\t\t\t  left join formapagto fpg on (nfi.fil_codigo = fpg.fil_codigo and nfi.fpg_codigo = fpg.fpg_codigo) ");
                if (!this.getFiltroCombo("filtroCampoData").equals(this.CAMPOSDATA[3])) {
                    buf.append("left ");
                }
                buf.append("        join (select brp.fil_codigo, ");
                buf.append("                     brp.bxa_codigo, ");
                buf.append("                     brp.rpg_codigo,  ");
                buf.append("                     bxa.bxa_datahora, ");
                buf.append("                     bxa.bxa_quantidadetitulos, ");
                buf.append("                     bxa.bxa_valortotal, ");
                buf.append("                     bxa.bxa_tipo ");
                buf.append("                from baixareceberpagar brp ");
                buf.append("                join baixa bxa on (brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao <> 'E')) brp ");
                buf.append("                               on (a.fil_codigo = brp.fil_codigo and a.rpg_codigo = brp.rpg_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                StringBuilder bufUsuario = new StringBuilder();
                String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                if (convenio != null) {
                    bufUsuario.append(" a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        bufUsuario.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        bufUsuario.append("'");
                        bufUsuario.append(entidade[i]);
                        bufUsuario.append("'");
                        if (i >= entidade.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" a.pac_codigo in (");
                    for (int i = 0; i < paciente.length; ++i) {
                        bufUsuario.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (bufUsuario.length() > 0) {
                    buf.append(" and (").append(bufUsuario.toString()).append(") ");
                }
                if ((serie = this.getSelecionadosFiltro("filtroSerie", 0)) != null) {
                    buf.append(" and a.ser_codigo in (");
                    for (int i = 0; i < serie.length; ++i) {
                        buf.append("'");
                        buf.append(serie[i]);
                        buf.append("'");
                        if (i >= serie.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (!this.getFiltroCombo("filtroTipo").equals(this.TIPO[0])) {
                    if (this.getFiltroCombo("filtroTipo").equals(this.TIPO[1])) {
                        buf.append(" and a.rpg_tipo = '").append("P").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipo = '").append("R").append("' ");
                    }
                }
                if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[0])) {
                    buf.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    buf.append("Q").append("', '");
                    buf.append("L").append("', '");
                    buf.append("G").append("', '");
                    buf.append("E").append("', '");
                    buf.append("R").append("', '");
                    buf.append("V").append("', '");
                    buf.append("T").append("', '");
                    buf.append("N").append("', '");
                    buf.append("S").append("') ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[1])) {
                    buf.append(" and a.rpg_situacao = '").append("A").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[2])) {
                    buf.append(" and a.rpg_situacao = '").append("Q").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[3])) {
                    buf.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    buf.append("Q").append("') ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[4])) {
                    buf.append(" and a.rpg_situacao = '").append("L").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[5])) {
                    buf.append(" and a.rpg_situacao = '").append("G").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[6])) {
                    buf.append(" and a.rpg_situacao = '").append("E").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[7])) {
                    buf.append(" and a.rpg_situacao = '").append("R").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[8])) {
                    buf.append(" and a.rpg_situacao = '").append("V").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[9])) {
                    buf.append(" and a.rpg_situacao = '").append("T").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[10])) {
                    buf.append(" and a.rpg_situacao = '").append("S").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[11])) {
                    buf.append(" and a.rpg_situacao = '").append("N").append("' ");
                }
                if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[1])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("U").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[2])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("F").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[3])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("C").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[4])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("R").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[5])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("P").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.TIPOCADASTRO[6])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("O").append("' ");
                }
                if (!this.getFiltroCombo("filtroTipoDocumento").equals(this.TIPODOCUMENTO[0])) {
                    if (this.getFiltroCombo("filtroTipoDocumento").equals(this.TIPODOCUMENTO[1])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("B").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.TIPODOCUMENTO[2])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("D").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.TIPODOCUMENTO[4])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("A").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipodocumento = '").append("C").append("' ");
                    }
                }
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    buf.append(" and a.rpg_numerodocumento ILIKE '%").append(this.getFiltroTexto("filtroNumeroDocumento")).append("%' ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" and a.rpg_valor >= ").append(this.getFiltroTexto("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" and a.rpg_valor <= ").append(this.getFiltroTexto("filtroValorFinal")).append(" ");
                }
                buf.append(" order by a.fil_codigo ");
                if (this.getFiltroComboIndice("ordemRelatorio") == 6) {
                    buf.append(", tipoPessoa, ").append(this.CAMPOSBANCOORDEM[this.getFiltroComboIndice("ordemRelatorio")]);
                } else {
                    buf.append(", ").append(this.CAMPOSBANCOORDEM[this.getFiltroComboIndice("ordemRelatorio")]);
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.campos){

                        @Override
                        public String getColumnName(int column) {
                            return this.colunas[column];
                        }
                    };
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            if (this.campos[i].equals("tipoReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoReceberPagar(rs.getString(this.campos[i]));
                                continue;
                            }
                            if (this.campos[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                                continue;
                            }
                            if (this.campos[i].equals("valorDescontoReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Float.valueOf(rs.getFloat(this.campos[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    double aux = rs.getDouble(this.campos[i]);
                                    o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                    continue;
                                }
                                o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[i]).append((String)"ComSinal").toString())] = rs.getDouble(this.campos[i]);
                                continue;
                            }
                            if (this.campos[i].equals("valorImpostosReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Float.valueOf(rs.getFloat(this.campos[i]));
                                double aux = rs.getDouble(this.campos[i]);
                                o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                continue;
                            }
                            if (this.campos[i].equals("tipoDocumentoReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoDocumento(rs.getString(this.campos[i]));
                                continue;
                            }
                            if (this.campos[i].equals("situacaoReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.campos[i]));
                                continue;
                            }
                            if (this.campos[i].equals("situacaoNotaFiscal")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoSituacaoNotaFiscal(rs.getString(this.campos[i]), rs.getBoolean("isEletronica"));
                                continue;
                            }
                            if (this.campos[i].equals("tipoCadastroReceberPagar")) {
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoCadastro(rs.getString(this.campos[i]));
                                continue;
                            }
                            if (this.campos[i].equals("dataBaixaReceberPagar")) {
                                if (rs.getString("situacaoReceberPagar").equalsIgnoreCase("Q")) {
                                    o[modelo.findColumn((String)this.campos[i])] = Funcoes.formataData(rs.getDate(this.campos[i]));
                                    continue;
                                }
                                o[modelo.findColumn((String)this.campos[i])] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.campos[i]));
                                continue;
                            }
                            try {
                                o[modelo.findColumn((String)this.campos[i])] = rs.getObject(this.campos[i]);
                                continue;
                            }
                            catch (Exception aux) {
                                // empty catch block
                            }
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioDetalhamentoImpostos.getModuloAcesso(tipoRelatorio));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioDetalhamentoImpostos.this.panelCentro.removeAll();
                                RelatorioDetalhamentoImpostos.this.panelCentro.repaint();
                                RelatorioDetalhamentoImpostos.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        var.put("filtroTipoDocumento", this.getFiltroCombo("filtroTipoDocumento"));
                        var.put("filtroTipoCadastro", this.getFiltroCombo("filtroTipoCadastro"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                        buf.delete(0, buf.length());
                        if (serie != null) {
                            for (int i = 0; i < serie.length; ++i) {
                                buf.append(serie[i]);
                                if (i >= serie.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSerie", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block96;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0852000100");
        }
        return Long.parseLong("0852000100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0852000101");
        }
        return Long.parseLong("0852000101");
    }
}

