/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.table.TableModel;

public class RelatorioCheques
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O"), Tipos.tipoSituacaoLancamento("C"), "Exceto Cancelados"};
    private String[] itensPagamento = new String[]{"Todos", Tipos.tipoPagamento("H"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("T")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Concilia\u00e7\u00e3o", "Emiss\u00e3o", "Compet\u00eancia"};
    private final String[] CAMPOSBANCODATA = new String[]{"lcx_vencimento", "lcx_conciliacao", "lcx_datahora", "lcx_competencia"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CONTA = "filtroConta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_PAGAMENTO = "filtroPagamento";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLancamento", "dataHoraLancamento", "tipoLancamento", "valorLancamento", "bancoLancamento", "agenciaLancamento", "documentoLancamento", "observacaoLancamento", "tipoDocumentoLancamento", "tipoPagamentoLancamento", "numeroChequeLancamento", "validadeCartaoLancamento", "cartaoCreditoLancamento", "contaLancamento", "dataConciliacaoLancamento", "dataVencimentoLancamento", "dataCompetenciaLancamento", "valorTotalLancamento", "valorMultaLancamento", "percentualMultaLancamento", "valorJuroLancamento", "percentualJuroLancamento", "valorAcrescimoLancamento", "percentualAcrescimoLancamento", "valorDescontoLancamento", "percentualDescontoLancamento", "indiceTipoLancamento", "numeroCartaoLancamento", "canceladoLancamento", "situacaoLancamento", "conciliadoLancamento", "usuarioCancelamentoLancamento", "dataCancelamentoLancamento", "nomeUsuarioCancelamentoLancamento", "codigoMotivoCancelamento", "descricaoMotivoCancelamento", "descricaoCancelamentoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "codigoEstacaoLancamento", "descricaoEstacaoLancamento", "codigoReduzidoConta", "contaConta", "titularConta", "codigoUsuarioLancamento", "nomeUsuarioLancamento", "descricaoHistoricoUsuario"});
    private JComboBox auxComboListener;

    public RelatorioCheques() {
        this.montaBarraDescricao("Relat\u00f3rio de Cheques", "Listagem de cheques", "rel_lanc_financeiro_cheques.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConta", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao + " and cco_inativa = false", 2, new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"C\u00f3digo", "Conta", "Titular"}, new int[]{70, 100, 0});
        this.adicionaFiltroCombo("filtroPagamento", "Tipo:", this.itensPagamento, 0);
        this.auxComboListener = this.adicionaRetornaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioCheques.getModuloConfigurar());
        this.setModuloAcesso(RelatorioCheques.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] conta;
            String[] usuario;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append("a.lcx_codigo as codigoLancamento, a.lcx_datahora as dataHoraLancamento,");
            buf.append("a.lcx_tipo as tipoLancamento, ");
            buf.append("case when a.lcx_valor is null then 0 else a.lcx_valor end as valorLancamento,");
            buf.append("a.lcx_banco as bancoLancamento,a.lcx_agencia as agenciaLancamento, ");
            buf.append("a.lcx_documento as documentoLancamento, a.lcx_obs as observacaoLancamento,");
            buf.append("a.lcx_tipodocumento as tipoDocumentoLancamento, a.lcx_tipopagamento as tipoPagamentoLancamento, ");
            buf.append("a.lcx_nrcheque as numeroChequeLancamento, a.lcx_validadecartao as validadeCartaoLancamento, ");
            buf.append("a.lcx_nrcartao as numeroCartaoLancamento, ");
            buf.append("a.lcx_situacao = '").append("C").append("' as canceladoLancamento, ");
            buf.append("a.lcx_situacao = '").append("O").append("' as conciliadoLancamento, ");
            buf.append("a.lcx_situacao as situacaoLancamento, ");
            buf.append("a.lcx_cartaocredito as cartaoCreditoLancamento, a.lcx_conta as contaLancamento, ");
            buf.append("a.lcx_conciliacao as dataConciliacaoLancamento, a.lcx_vencimento as dataVencimentoLancamento, ");
            buf.append("a.lcx_competencia as dataCompetenciaLancamento, ");
            buf.append("a.usr_codigo as usuarioCancelamentoLancamento, a.lcx_datacancelado as dataCancelamentoLancamento, ");
            buf.append("usuariocancela.usr_nome as nomeUsuarioCancelamentoLancamento, ");
            buf.append("a.est_codigo as codigoEstacaoLancamento, estacoes.est_descricao as descricaoEstacaoLancamento, ");
            buf.append("conta.cco_reduzido as codigoReduzidoConta, conta.cco_conta as contaConta, conta.cco_titular as titularConta,");
            buf.append("usrlancto.usr_codigo as codigoUsuarioLancamento, usrlancto.usr_nome as nomeUsuarioLancamento, ");
            buf.append("motivo.mov_codigo as codigoMotivoCancelamento, motivo.mov_descricao as descricaoMotivoCancelamento, ");
            buf.append("a.lcx_descricaocancelado as descricaoCancelamentoLancamento, ");
            buf.append("historico.hpa_codigo as codigoHistoricoPadrao, historico.hpa_descricao as descricaoHistoricoPadrao, ");
            buf.append("a.lcx_descricaohistorico as descricaoHistoricoUsuario, ");
            buf.append("case when a.lcx_valortotal is null then 0 else a.lcx_valortotal end as valorTotalLancamento, ");
            buf.append("a.lcx_valormulta as valorMultaLancamento, ");
            buf.append("a.lcx_percentualmulta as percentualMultaLancamento, ");
            buf.append("a.lcx_valorjuro as valorJuroLancamento, ");
            buf.append("a.lcx_percentualjuro as percentualJuroLancamento, ");
            buf.append("a.lcx_valoracrescimo as valorAcrescimoLancamento, ");
            buf.append("a.lcx_percentualacrescimo as percentualAcrescimoLancamento, ");
            buf.append("a.lcx_valordesconto as valorDescontoLancamento, ");
            buf.append("a.lcx_percentualdesconto as percentualDescontoLancamento, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from lanctocaixa a ");
            buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
            buf.append("left join motivoscancelamentos motivo on a.fil_codigo = motivo.fil_codigo and a.mov_codigo = motivo.mov_codigo ");
            buf.append("left join historicopadrao historico on a.fil_codigo = historico.fil_codigo and a.hpa_codigo = historico.hpa_codigo ");
            buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
            buf.append("left join contacorrente conta on a.fil_codigo = conta.fil_codigo and a.cco_reduzido = conta.cco_reduzido ");
            buf.append("left join usuario usrlancto on a.usr_codigo = usrlancto.usr_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] estacao = this.getSelecionadosFiltro("filtroEstacao", 0);
            if (estacao != null) {
                buf.append(" and a.est_codigo in (");
                for (int i = 0; i < estacao.length; ++i) {
                    buf.append(estacao[i]);
                    if (i >= estacao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((conta = this.getSelecionadosFiltro("filtroConta", 0)) != null) {
                buf.append(" and a.cco_reduzido in (");
                for (int i = 0; i < conta.length; ++i) {
                    buf.append(conta[i]);
                    if (i >= conta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (!this.getFiltroCombo("filtroPagamento").toString().equals(this.itensPagamento[0])) {
                String combo = this.getFiltroCombo("filtroPagamento").toString();
                buf.append(" and a.lcx_tipopagamento = '");
                if (combo.equals(this.itensPagamento[1])) {
                    buf.append("H");
                } else if (combo.equals(this.itensPagamento[2])) {
                    buf.append("P");
                } else if (combo.equals(this.itensPagamento[3])) {
                    buf.append("A");
                } else if (combo.equals(this.itensPagamento[4])) {
                    buf.append("T");
                }
                buf.append("'");
            } else {
                buf.append(" and a.lcx_tipopagamento in('").append("H").append("','").append("P").append("','").append("A").append("','").append("T").append("') ");
            }
            if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[1])) {
                buf.append(" and a.lcx_situacao = '").append("A").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[2])) {
                buf.append(" and a.lcx_situacao = '").append("O").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[3])) {
                buf.append(" and a.lcx_situacao = '").append("C").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[4])) {
                buf.append(" and a.lcx_situacao <> '").append("C").append("' ");
            }
            buf.append(" and conta.cco_inativa = false ");
            buf.append(" order by a.fil_codigo, a.cco_reduzido, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]);
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("a.usr_codigo");
            } else {
                buf.append("a.lcx_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("tipoLancamento") ? Tipos.tipoLancamentoCaixa(rs.getString(campos[i])) : (campos[i].equals("indiceTipoLancamento") ? Integer.valueOf(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1) : (campos[i].equals("valorLancamento") ? rs.getBigDecimal(campos[i]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i].equals("valorTotalLancamento") ? rs.getBigDecimal(campos[i]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i].equals("tipoDocumentoLancamento") ? Tipos.tipoDocumento(rs.getString(campos[i])) : (campos[i].equals("tipoUltimoPagamentoRequisicao") || campos[i].equals("tipoPagamentoLancamento") ? Tipos.tipoPagamento(rs.getString(campos[i])) : (campos[i].equals("situacaoLancamento") ? Tipos.tipoSituacaoLancamento(rs.getString(campos[i])) : rs.getObject(campos[i])))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioCheques.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioCheques.this.panelCentro.removeAll();
                            RelatorioCheques.this.panelCentro.repaint();
                            RelatorioCheques.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    var.put("filtroPagamento", this.getFiltroCombo("filtroPagamento"));
                    var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (estacao != null) {
                        for (i = 0; i < estacao.length; ++i) {
                            buf.append(estacao[i]);
                            if (i >= estacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    buf.delete(0, buf.length());
                    if (conta != null) {
                        for (i = 0; i < conta.length; ++i) {
                            buf.append(conta[i]);
                            if (i >= conta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConta", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0852500100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0852500101");
    }
}

