/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioBaixa
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_BAIXA = 0;
    public static final int TIPO_BAIXA_TITULOS = 1;
    public static final int TIPO_BAIXA_PAGAMENTOS = 2;
    public static final int TIPO_BAIXA_TITULOS_PAGAMENTOS = 3;
    private int tipoRelatorio = 0;
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private static final String[] ORDEM = new String[]{"C\u00f3digo", "Valor Total", "Qtde. T\u00edtulos", "Situa\u00e7\u00e3o"};
    private static final String[] CAMPOSBANCO_ORDEM = new String[]{"a.bxa_codigo", "a.bxa_valortotal", "a.bxa_quantidadetitulos", "a.bxa_situacao"};
    private static final String[] ORDEM_RECPAG = new String[]{"C\u00f3digo", "Cadastro", "Documento", "Dt Emiss\u00e3o", "Dt Compet\u00eancia", "Dt Vencimento", "Tipo", "Valor"};
    private static final String[] CAMPOSBANCO_ORDEM_RECPAG = new String[]{"rpg.rpg_codigo", "pac.pac_nome,pac.pac_nomeSocial,pac.pac_nomesocial, ent.ent_fantasia, con.con_fantasia", "rpg.rpg_numerodocumento", "rpg.rpg_datahora", "rpg.rpg_competencia", "rpg.rpg_vencimento", "rpg.rpg_tipo", "rpg.rpg_valor"};
    private static final String[] ORDEM_LANCTO = new String[]{"C\u00f3digo", "Conta Pagto.", "Hist\u00f3rico", "Tipo Pagamento", "Situa\u00e7\u00e3o", "Valor Total"};
    private static final String[] CAMPOSBANCO_ORDEM_LANCTO = new String[]{"lcx.lcx_codigo", "lcx.cco_reduzido", "lcx.hpa_codigo", "lcx.lcx_tipopagamento", "lcx.lcx_situacao", "lcx.lcx_valortotal"};
    private static final String[] SITUACAO = new String[]{"Todas", "Exceto Estornada", Tipos.tipoSituacaoBaixa("Q"), Tipos.tipoSituacaoBaixa("A"), Tipos.tipoSituacaoBaixa("E")};
    private static final String[] TIPOBAIXA = new String[]{"Todas", Tipos.tipoBaixa("C"), Tipos.tipoBaixa("D")};
    private static final String[] CAMPOSBAIXA = new String[]{"codigoFilialBaixa", "codigoBaixa", "dataBaixa", "qtdeTitulosBaixa", "valorTotalBaixa", "valorJurosBaixa", "valorMultaBaixa", "valorAcrescimoBaixa", "valorDescontoBaixa", "valorTaxaBaixa", "codigoUsuarioBaixa", "codigoUsuarioCancelamentoBaixa", "situacaoBaixa", "dataCancelamentoBaixa", "valorIrrfBaixa", "valorIssBaixa", "valorPisBaixa", "valorCsllBaixa", "valorCofinsBaixa", "valorInssBaixa", "diaSemanaBaixa", "tipoBaixa", "valorTotalBaixaComSinal", "valorJurosBaixaComSinal", "valorMultaBaixaComSinal", "valorAcrescimoBaixaComSinal", "valorDescontoBaixaComSinal", "valorTaxaBaixaComSinal", "valorIrrfBaixaComSinal", "valorIssBaixaComSinal", "valorPisBaixaComSinal", "valorCsllBaixaComSinal", "valorCofinsBaixaComSinal", "valorInssBaixaComSinal", "dataHoraBaixa", "usuarioBaixa", "codigoMotivoCancelamentoBaixa", "descricaoMotivoCancelamentoBaixa", "descricaoCancelamentoBaixa", "valorSomatorioBaixaComSinal", "valorTotalBaixaComImpostos"};
    private static final String[] CAMPOSRECEBERPAGAR = new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorTotalReceberPagar", "valorReceberPagarComSinal", "valorTotalReceberPagarComSinal", "valorImpostosReceberPagarComSinal", "valorReceberPagarComImpostoComSinal", "codigosPlanoContas", "contasPlanoContas", "descricoesPlanoContas"};
    private static final String[] CAMPOSLANCAMENTO = new String[]{"codigoLancamento", "dataHoraLancamento", "tipoLancamento", "valorLancamento", "bancoLancamento", "agenciaLancamento", "documentoLancamento", "observacaoLancamento", "tipoDocumentoLancamento", "tipoPagamentoLancamento", "numeroChequeLancamento", "validadeCartaoLancamento", "cartaoCreditoLancamento", "contaBancoLancamento", "dataConciliacaoLancamento", "dataVencimentoLancamento", "dataCompetenciaLancamento", "valorTotalLancamento", "valorMultaLancamento", "percentualMultaLancamento", "valorJuroLancamento", "percentualJuroLancamento", "valorAcrescimoLancamento", "percentualAcrescimoLancamento", "valorDescontoLancamento", "percentualDescontoLancamento", "numeroCartaoLancamento", "situacaoLancamento", "usuarioCancelamentoLancamento", "dataCancelamentoLancamento", "nomeUsuarioCancelamentoLancamento", "codigoMotivoCancelamento", "descricaoMotivoCancelamento", "descricaoCancelamentoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "codigoEstacaoLancamento", "descricaoEstacaoLancamento", "codigoReduzidoConta", "contaConta", "titularConta", "codigoUsuarioLancamento", "nomeUsuarioLancamento", "contaLancamento", "valorTotalLancamentoComSinal", "descricaoHistoricoUsuario"};
    private static final String[] CAMPOSRECEBERPAGARLANCAMENTO = new String[]{"dataPagamento", "jurosPagamento", "descontoPagamento", "valorPagamento", "valorPagamentoComSinal", "detalheTodosPagamentos", "jurosSomatorioPagamento", "descontoSomatorioPagamento", "valorSomatorioPagamentoComSinal", "impostosPagamento", "impostosPagamentoComSinal", "impostosSomatorioPagamento", "impostosSomatorioPagamentoComSinal", "valorReceberPagarSomatorioComSinal", "valorTituloPagamentoComSinal"};
    private static final String[] CAMPOSCADASTRO = new String[]{"tipoLogradouroCadastro", "codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_QTDE_TITULOS = "filtroQtdeTitulos";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_ORDEM_RECPAG = "filtroOrdemRecPag";
    private static final String FILTRO_ORDEM_LANCTO = "filtroOrdemLancto";
    private static final String FILTRO_TIPO_BAIXA = "filtroTipoBaixa";
    private String[] campos;

    public RelatorioBaixa(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de baixa", "Listagem das Baixas no per\u00edodo", "relatorios/rel_financeiro_movimento_baixa.jpg");
        } else if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de receber/pagar por baixa", "Listagem das contas a Receber e Pagar por Baixa no per\u00edodo", "relatorios/rel_financeiro_movimento-rec_pag_baixa.jpg");
        } else if (tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de lan\u00e7amentos por baixa", "Listagem dos Lan\u00e7amentos (pagamentos) por Baixa no per\u00edodo", "relatorios/rel_lancto_por_baixa.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio receber/pagar baixados", "Listagem das contas a Receber e Pagar baixados no per\u00edodo", "relatorios/rel_financeiro_movimento_rec-pag_baixados.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        if (tipoRelatorio == 1 || tipoRelatorio == 3) {
            this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
            this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false ", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
            }
        }
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor final:", 0);
        this.adicionaFiltroNumero(FILTRO_QTDE_TITULOS, "Qtde. T\u00edtulos:", 3);
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", SITUACAO, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem  Baixa:", ORDEM, 0);
        this.adicionaFiltroCombo(FILTRO_TIPO_BAIXA, "Tipo Baixa:", TIPOBAIXA, 0);
        if (tipoRelatorio == 1 || tipoRelatorio == 3) {
            this.adicionaFiltroCombo(FILTRO_ORDEM_RECPAG, "Ordem Agrup.:", ORDEM_RECPAG, 0);
        } else if (tipoRelatorio == 2) {
            this.adicionaFiltroCombo(FILTRO_ORDEM_LANCTO, "Ordem Agrup.:", ORDEM_LANCTO, 0);
        }
        this.setModuloConfigurar(RelatorioBaixa.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioBaixa.getModuloAcesso(tipoRelatorio));
        this.campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOSBAIXA);
        if (tipoRelatorio == 1) {
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSCADASTRO);
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSRECEBERPAGAR);
        } else if (tipoRelatorio == 2) {
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSLANCAMENTO);
        } else if (tipoRelatorio == 3) {
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSCADASTRO);
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSRECEBERPAGAR);
            this.campos = ArraysUtil.concatenar(this.campos, CAMPOSRECEBERPAGARLANCAMENTO);
        }
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select ");
            if (this.tipoRelatorio == 3) {
                buf.append("        array_to_string(array_agg(plc.plc_reduzido), ', ') AS codigosPlanoContas,");
                buf.append("        array_to_string(array_agg(plc.plc_conta), ', ')  AS contasPlanoContas,");
                buf.append("        array_to_string(array_agg(plc.plc_descricao), ', ')  AS descricoesPlanoContas,");
            }
            buf.append(" \t\t    a.fil_codigo as codigoFilialBaixa, ");
            buf.append("        a.bxa_codigo as codigoBaixa, ");
            buf.append("        date_trunc('day', a.bxa_datahora) as dataBaixa, ");
            buf.append("        COALESCE(a.bxa_quantidadetitulos, 0) as qtdeTitulosBaixa, ");
            buf.append("        COALESCE(a.bxa_valortotal, 0) as valorTotalBaixa, ");
            buf.append("        COALESCE(a.bxa_valorjuros, 0) as valorJurosBaixa, ");
            buf.append("        COALESCE(a.bxa_valormultas, 0) as valorMultaBaixa, ");
            buf.append("        COALESCE(a.bxa_valoracrescimo, 0) as valorAcrescimoBaixa, ");
            buf.append("        COALESCE(a.bxa_valordescontos, 0) as valorDescontoBaixa, ");
            buf.append("        COALESCE(a.bxa_valortaxas, 0) as valorTaxaBaixa, ");
            buf.append("        a.usr_codigo as codigoUsuarioBaixa, ");
            buf.append("        a.usr_codcancelado as codigoUsuariocancelamentoBaixa, ");
            buf.append("        a.bxa_situacao as situacaoBaixa, ");
            buf.append("        a.bxa_datacancelado as dataCancelamentoBaixa, ");
            buf.append("        COALESCE(a.bxa_irrfvalor, 0) as valorIrrfBaixa, ");
            buf.append("        COALESCE(a.bxa_issvalor, 0) as valorIssBaixa, ");
            buf.append("        COALESCE(a.bxa_pisvalor, 0) as valorPisBaixa, ");
            buf.append("        COALESCE(a.bxa_csllvalor, 0) as valorCsllBaixa, ");
            buf.append("        COALESCE(a.bxa_cofinsvalor, 0) as valorCofinsBaixa, ");
            buf.append("        COALESCE(a.bxa_inssvalor, 0) as valorInssBaixa, ");
            buf.append("        a.bxa_tipo as tipoBaixa, ");
            buf.append("        a.bxa_datahora as dataHoraBaixa, ");
            buf.append("        a.usr_codigo as usuarioBaixa, ");
            buf.append(" \t\t\t\tmotCancBaixa.mov_codigo as codigoMotivoCancelamentoBaixa, ");
            buf.append(" \t\t\t\tmotCancBaixa.mov_descricao as descricaoMotivoCancelamentoBaixa, ");
            buf.append(" \t\t\t\ta.bxa_descricaocancelamento as descricaoCancelamentoBaixa, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valortotal ELSE a.bxa_valortotal * (-1) END as valorTotalBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valorjuros ELSE a.bxa_valorjuros * (-1) END as valorJurosBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valormultas ELSE a.bxa_valormultas * (-1) END as valorMultaBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valoracrescimo ELSE a.bxa_valoracrescimo * (-1) END as valorAcrescimoBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valordescontos * (-1) ELSE a.bxa_valordescontos END as valorDescontoBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valortaxas ELSE a.bxa_valortaxas * (-1) END as valorTaxaBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_irrfvalor * (-1) ELSE a.bxa_irrfvalor * (-1) END as valorIrrfBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_issvalor * (-1) ELSE a.bxa_issvalor * (-1) END as valorIssBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_pisvalor * (-1) ELSE a.bxa_pisvalor * (-1) END as valorPisBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_csllvalor * (-1) ELSE a.bxa_csllvalor * (-1) END as valorCsllBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_cofinsvalor * (-1) ELSE a.bxa_cofinsvalor * (-1) END as valorCofinsBaixaComSinal, ");
            buf.append("        CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_inssvalor * (-1) ELSE a.bxa_inssvalor * (-1) END as valorInssBaixaComSinal, ");
            buf.append("        ('{Domingo, Segunda-Feira, Ter\u00e7a-Feira, Quarta-Feira, Quinta-Feira, Sexta-Feira, S\u00e1bado}'::text[])[extract(dow from a.bxa_datahora) + 1] as diaSemanaBaixa, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                buf.append(" , ");
                buf.append(" CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valortotal ELSE rpg.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                buf.append(" CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valor ELSE rpg.rpg_valor * (-1) END as valorReceberPagarComSinal, ");
                buf.append(" COALESCE(rpg.rpg_valortotal, 0) as valorTotalReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valor, 0) as valorReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_taxa, 0) as valorTaxaReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valoracrescimo, 0) as valorAcrescimoReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valordesconto, 0) as valorDescontoReceberPagar, ");
                buf.append(" rpg.rpg_codigo as codigoReceberPagar, ");
                buf.append(" rpg.rpg_datahora as dataHoraReceberPagar, ");
                buf.append(" rpg.rpg_vencimento as dataVencimentoReceberPagar, ");
                buf.append(" rpg.rpg_competencia as dataCompetenciaReceberPagar, ");
                buf.append(" rpg.rpg_tipojuros as tipoJurosReceberPagar, ");
                buf.append(" rpg.rpg_tipo as tipoReceberPagar, ");
                buf.append(" rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                buf.append(" rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                buf.append(" rpg.rpg_parcela as numeroParcelaReceberPagar, ");
                buf.append(" rpg.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                buf.append(" rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append(" rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                buf.append(" rpg.rpg_obs as observacaoReceberPagar, ");
                buf.append(" rpg.rpg_tipocadastro as tipoCadastroReceberPagar, ");
                buf.append(" usrrecpag.usr_codigo as codigoUsuarioReceberPagar, ");
                buf.append(" usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
                buf.append(" usuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, ");
                buf.append(" usuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
                buf.append(" rpg.rpg_datacancelado as dataCancelamentoReceberPagar, ");
                buf.append(" rpg.rpg_situacao as situacaoReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valor, 0) + COALESCE(rpg.rpg_taxa, 0) as valorComTaxaReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valorjuro, 0) as valorJuroReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_valormulta, 0) as valorMultaReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_percentualmulta, 0) as percentualMultaReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_percentualjuro, 0) as percentualJuroReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_percentualacrescimo, 0) as percentualAcrescimoReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_percentualdesconto, 0) as percentualDescontoReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_irrfvalor, 0) as valorIrrfReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_irrfpercentual, 0) as percentualIrrfReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_issvalor, 0) as valorIssReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_isspercentual, 0) as percentualIssReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_pisvalor, 0) as valorPisReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_pispercentual, 0) as percentualPisReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_csllvalor, 0) as valorCsllReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_csllpercentual, 0) as percentualCsllReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_cofinsvalor, 0) as valorCofinsReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_cofinspercentual, 0) as percentualCofinsReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_inssvalor, 0) as valorInssReceberPagar, ");
                buf.append(" COALESCE(rpg.rpg_insspercentual, 0) as percentualInssReceberPagar, ");
                buf.append(" COALESCE( ");
                buf.append("    (case when rpg.nfi_codigo is null then ");
                buf.append("          COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0) ");
                buf.append("     else ");
                buf.append("          COALESCE(nfi.nfi_irrfvalor, 0) + COALESCE(nfi.nfi_issvalor, 0) + COALESCE(nfi.nfi_pisvalor, 0) + COALESCE(nfi.nfi_csllvalor, 0) + COALESCE(nfi.nfi_cofinsvalor, 0) + COALESCE(nfi.nfi_inssvalor, 0) + COALESCE(nfi.nfi_icmsvalor,0) + COALESCE(nfi.nfi_ipivalor,0) ");
                buf.append("    end), 0) as valorImpostosReceberPagar, ");
                buf.append(" COALESCE( ");
                buf.append("    (case when rpg.nfi_codigo is null then ");
                buf.append("          COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0) ");
                buf.append("     else ");
                buf.append("          COALESCE(nfi.nfi_irrfvalor, 0) + COALESCE(nfi.nfi_issvalor, 0) + COALESCE(nfi.nfi_pisvalor, 0) + COALESCE(nfi.nfi_csllvalor, 0) + COALESCE(nfi.nfi_cofinsvalor, 0) + COALESCE(nfi.nfi_inssvalor, 0) + COALESCE(nfi.nfi_icmsvalor,0) + COALESCE(nfi.nfi_ipivalor,0) ");
                buf.append("    end), 0)  as valorImpostosReceberPagarComSinal, ");
                buf.append(" COALESCE(rpg.rpg_valormulta, 0) + COALESCE(rpg.rpg_valoracrescimo, 0) + COALESCE(rpg.rpg_valorjuro, 0) + COALESCE(rpg.rpg_taxa, 0) as valorTaxaTotalReceberPagar, ");
                buf.append(" rpg.ser_codigo as codigoSerie, ser.ser_descricao as descricaoSerie, ");
                buf.append(" case ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("O").append("' then rpg.con_codigo ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("P").append("' then rpg.pac_codigo ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("U").append("' then rpg.ent_codigo ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("F").append("' then rpg.ent_codigo ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("C").append("' then rpg.ent_codigo ");
                buf.append("   when rpg.rpg_tipocadastro = '").append("R").append("' then rpg.ent_codigo ");
                buf.append("   else rpg.ent_codigo ");
                buf.append(" end as codigoCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_nome ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_fantasia ");
                buf.append("   else con.con_fantasia ");
                buf.append(" end as fantasiaCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append("   else '' ");
                buf.append(" end as nomeSocialPaciente, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_nome ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_razaosocial ");
                buf.append("   else con.con_razao ");
                buf.append(" end as razaoSocialCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_fone ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_fone ");
                buf.append("   else con.con_fone ");
                buf.append(" end as foneCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_numeroendereco ");
                buf.append("   else con.con_numeroendereco ");
                buf.append(" end as numeroEnderecoCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_endereco ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_endereco ");
                buf.append("   else con.con_endereco ");
                buf.append(" end as enderecoCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_tipologradouroendereco ");
                buf.append("   else con.con_tipologradouroendereco ");
                buf.append(" end as tipoLogradouroCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_fax ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_fax ");
                buf.append("   else con.con_fax ");
                buf.append(" end as faxCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_complemento ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_complemento ");
                buf.append("   else con.con_complemento ");
                buf.append(" end as complementoCadastro, ");
                buf.append(" case ");
                buf.append("   when rpg.pac_codigo is not null then pac.pac_cep ");
                buf.append("   when rpg.ent_codigo is not null then ent.ent_cep ");
                buf.append("   else con.con_cep ");
                buf.append(" end as cepCadastro ");
            } else if (this.tipoRelatorio == 2) {
                buf.append(" , ");
                buf.append(" lcx.lcx_codigo as codigoLancamento, ");
                buf.append(" lcx.lcx_datahora as dataHoraLancamento, ");
                buf.append(" lcx.lcx_tipo as tipoLancamento, ");
                buf.append(" COALESCE(lcx.lcx_valor, 0) as valorLancamento, ");
                buf.append(" lcx.lcx_banco as bancoLancamento, ");
                buf.append(" lcx.lcx_agencia as agenciaLancamento, ");
                buf.append(" lcx.lcx_documento as documentoLancamento, ");
                buf.append(" lcx.lcx_obs as observacaoLancamento, ");
                buf.append(" lcx.lcx_tipodocumento as tipoDocumentoLancamento, ");
                buf.append(" lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                buf.append(" lcx.lcx_nrcheque as numeroChequeLancamento, ");
                buf.append(" lcx.lcx_validadecartao as validadeCartaoLancamento, ");
                buf.append(" lcx.lcx_nrcartao as numeroCartaoLancamento, ");
                buf.append(" lcx.lcx_situacao as situacaoLancamento, ");
                buf.append(" lcx.lcx_cartaocredito as cartaoCreditoLancamento, ");
                buf.append(" lcx.lcx_conta as contaBancoLancamento, ");
                buf.append(" lcx.lcx_conciliacao as dataConciliacaoLancamento, ");
                buf.append(" lcx.lcx_vencimento as dataVencimentoLancamento, ");
                buf.append(" lcx.lcx_competencia as dataCompetenciaLancamento, ");
                buf.append(" lcx.usr_codigo as usuarioCancelamentoLancamento, ");
                buf.append(" lcx.lcx_datacancelado as dataCancelamentoLancamento, ");
                buf.append(" lcx.cco_reduzido as contaLancamento, ");
                buf.append(" usuariocancela.usr_nome as nomeUsuarioCancelamentoLancamento, ");
                buf.append(" lcx.est_codigo as codigoEstacaoLancamento, ");
                buf.append(" estacoes.est_descricao as descricaoEstacaoLancamento, ");
                buf.append(" conta.cco_reduzido as codigoReduzidoConta, ");
                buf.append(" conta.cco_conta as contaConta, ");
                buf.append(" conta.cco_titular as titularConta,");
                buf.append(" usrlancto.usr_codigo as codigoUsuarioLancamento, ");
                buf.append(" usrlancto.usr_nome as nomeUsuarioLancamento, ");
                buf.append(" motivo.mov_codigo as codigoMotivoCancelamento, ");
                buf.append(" '' as nomeSocialPaciente, ");
                buf.append(" motivo.mov_descricao as descricaoMotivoCancelamento, ");
                buf.append(" lcx.lcx_descricaocancelado as descricaoCancelamentoLancamento, ");
                buf.append(" historico.hpa_codigo as codigoHistoricoPadrao, ");
                buf.append(" historico.hpa_descricao as descricaoHistoricoPadrao, ");
                buf.append(" lcx.lcx_descricaohistorico as descricaoHistoricoUsuario, ");
                buf.append(" COALESCE(lcx.lcx_valortotal, 0) as valorTotalLancamento, ");
                buf.append(" CASE WHEN lcx.lcx_tipo = 'C' THEN COALESCE(lcx.lcx_valortotal, 0) ELSE COALESCE(lcx.lcx_valortotal, 0) * (-1) END as valorTotalLancamentoComSinal, ");
                buf.append(" COALESCE(lcx.lcx_valormulta, 0) as valorMultaLancamento, ");
                buf.append(" COALESCE(lcx.lcx_percentualmulta, 0) as percentualMultaLancamento, ");
                buf.append(" COALESCE(lcx.lcx_valorjuro, 0) as valorJuroLancamento, ");
                buf.append(" COALESCE(lcx.lcx_percentualjuro, 0) as percentualJuroLancamento, ");
                buf.append(" COALESCE(lcx.lcx_valoracrescimo, 0) as valorAcrescimoLancamento, ");
                buf.append(" COALESCE(lcx.lcx_percentualacrescimo, 0) as percentualAcrescimoLancamento, ");
                buf.append(" COALESCE(lcx.lcx_valordesconto, 0) as valorDescontoLancamento, ");
                buf.append(" COALESCE(lcx.lcx_percentualdesconto, 0) as percentualDescontoLancamento ");
            }
            buf.append(" from baixa a ");
            buf.append(" left join motivoscancelamentos motCancBaixa on (a.fil_codigo = motCancBaixa.fil_codigo and a.mov_codigo = motCancBaixa.mov_codigo) ");
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                buf.append(" left join baixareceberpagar brp on (a.fil_codigo = brp.fil_codigo and a.bxa_codigo = brp.bxa_codigo) ");
                buf.append(" join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and rpg.rpg_situacao = '").append("Q").append("') ");
                buf.append(" left join usuario usuariocancela on rpg.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append(" left join usuario usrrecpag on rpg.usr_codigo = usrrecpag.usr_codigo ");
                buf.append(" left join series ser on (rpg.fil_codigo = ser.fil_codigo and rpg.ser_codigo = ser.ser_codigo) ");
                buf.append(" left join entidade ent on (rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo) ");
                buf.append(" left join convenios con on (rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) ");
                buf.append(" left join paciente pac on (rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo) ");
                buf.append(" left join notafiscal nfi on (rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo) ");
            } else if (this.tipoRelatorio == 2) {
                buf.append(" left join baixalanctocaixa blc on (a.fil_codigo = blc.fil_codigo and a.bxa_codigo = blc.bxa_codigo) ");
                buf.append(" left join lanctocaixa lcx on (blc.fil_codigo = lcx.fil_codigo and blc.est_codigo = lcx.est_codigo and blc.lcx_codigo = lcx.lcx_codigo) ");
                buf.append(" left join usuario usuariocancela on lcx.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append(" left join motivoscancelamentos motivo on (lcx.fil_codigo = motivo.fil_codigo and lcx.mov_codigo = motivo.mov_codigo) ");
                buf.append(" left join historicopadrao historico on (lcx.fil_codigo = historico.fil_codigo and lcx.hpa_codigo = historico.hpa_codigo) ");
                buf.append(" left join estacoes on lcx.est_codigo = estacoes.est_codigo ");
                buf.append(" left join contacorrente conta on (lcx.fil_codigo = conta.fil_codigo and lcx.cco_reduzido = conta.cco_reduzido) ");
                buf.append(" left join usuario usrlancto on lcx.usr_codigo = usrlancto.usr_codigo ");
            }
            if (this.tipoRelatorio == 3) {
                buf.append(" left join baixalanctocaixa blc on (a.fil_codigo = blc.fil_codigo and a.bxa_codigo = blc.bxa_codigo) ");
                buf.append(" left join lanctocaixaplanoconta lpl on (blc.fil_codigo = lpl.fil_codigo and blc.lcx_codigo = lpl.lcx_codigo and blc.est_codigo = lpl.est_codigo) ");
                buf.append(" left join planoconta plc on (lpl.fil_codigo = plc.fil_codigo and lpl.plc_reduzido = plc.plc_reduzido) ");
            }
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null || filiais.length == 0) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
            if (usuario != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0);
            String[] paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0);
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                int i;
                StringBuilder bufUsuario = new StringBuilder();
                if (convenio != null) {
                    bufUsuario.append(" rpg.con_codigo in (");
                    for (i = 0; i < convenio.length; ++i) {
                        bufUsuario.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (entidade != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" rpg.ent_codigo in (");
                    for (i = 0; i < entidade.length; ++i) {
                        bufUsuario.append("'");
                        bufUsuario.append(entidade[i]);
                        bufUsuario.append("'");
                        if (i >= entidade.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (paciente != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" rpg.pac_codigo in (");
                    for (i = 0; i < paciente.length; ++i) {
                        bufUsuario.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (bufUsuario.length() > 0) {
                    buf.append(" and ").append(bufUsuario.toString());
                }
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                buf.append(" and cast(a.bxa_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                buf.append(" and cast(a.bxa_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                buf.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                buf.append(" and a.bxa_valortotal >= ").append(this.getFiltroTexto(FILTRO_VALOR_INICIAL)).append(" ");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                buf.append(" and a.bxa_valortotal <= ").append(this.getFiltroTexto(FILTRO_VALOR_FINAL)).append(" ");
            }
            if (!Funcoes.textoVazio(this.getFiltroNumero(FILTRO_QTDE_TITULOS))) {
                buf.append(" and a.bxa_quantidadetitulos = ").append(this.getFiltroNumero(FILTRO_QTDE_TITULOS)).append(" ");
            }
            if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[1])) {
                buf.append(" and a.bxa_situacao IN ('").append("Q").append("', '").append("A").append("') ");
            }
            if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[2])) {
                buf.append(" and a.bxa_situacao = '").append("Q").append("' ");
            } else if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[3])) {
                buf.append(" and a.bxa_situacao = '").append("A").append("' ");
            } else if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[4])) {
                buf.append(" and a.bxa_situacao = '").append("E").append("' ");
            }
            if (this.getFiltroCombo(FILTRO_TIPO_BAIXA).equals(TIPOBAIXA[1])) {
                buf.append(" and a.bxa_tipo = '").append("C").append("' ");
            } else if (this.getFiltroCombo(FILTRO_TIPO_BAIXA).equals(TIPOBAIXA[2])) {
                buf.append(" and a.bxa_tipo = '").append("D").append("' ");
            }
            if (this.tipoRelatorio == 3) {
                buf.append(this.getAgrupamento());
            }
            if (this.tipoRelatorio == 3) {
                buf.append(" order by a.fil_codigo, a.bxa_tipo, a.bxa_codigo ");
            } else {
                buf.append(" order by a.fil_codigo, cast(a.bxa_datahora as date), a.bxa_tipo ");
            }
            buf.append(" , ").append(CAMPOSBANCO_ORDEM[this.getFiltroComboIndice(FILTRO_ORDEM)]);
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                buf.append(" , ").append(CAMPOSBANCO_ORDEM_RECPAG[this.getFiltroComboIndice(FILTRO_ORDEM_RECPAG)]).append(" , rpg.rpg_codigo ");
            } else if (this.tipoRelatorio == 2) {
                buf.append(" , ").append(CAMPOSBANCO_ORDEM_LANCTO[this.getFiltroComboIndice(FILTRO_ORDEM_LANCTO)]).append(" , lcx.lcx_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equals("dataBaixa")) {
                            o[i] = Funcoes.formataData("dd/MM/yyyy", rs.getDate(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoBaixa")) {
                            o[i] = Tipos.tipoSituacaoBaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoReceberPagar")) {
                            o[i] = Tipos.tipoReceberPagar(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoDocumentoReceberPagar")) {
                            o[i] = Tipos.tipoDocumento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoReceberPagar")) {
                            o[i] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCadastroReceberPagar")) {
                            o[i] = Tipos.tipoCadastro(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoLancamento")) {
                            o[i] = Tipos.tipoLancamentoCaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoDocumentoLancamento")) {
                            o[i] = Tipos.tipoDocumento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoUltimoPagamentoRequisicao") || this.campos[i].equals("tipoPagamentoLancamento")) {
                            o[i] = Tipos.tipoPagamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoLancamento")) {
                            o[i] = Tipos.tipoSituacaoLancamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoBaixa")) {
                            o[i] = Tipos.tipoBaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("valorSomatorioBaixaComSinal")) {
                            o[i] = rs.getBigDecimal("valorTotalBaixa").divide(rs.getBigDecimal("qtdeTitulosBaixa") == null ? BigDecimal.ONE : rs.getBigDecimal("qtdeTitulosBaixa"), this.ROUND);
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorImpostosReceberPagarComSinal")) {
                            o[i] = rs.getBigDecimal("valorImpostosReceberPagarComSinal");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorImpostosReceberPagar")) {
                            o[i] = rs.getBigDecimal("valorImpostosReceberPagar");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorReceberPagarComImpostoComSinal")) {
                            o[i] = rs.getBigDecimal("valorReceberPagarComSinal");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).add(rs.getBigDecimal("valorImpostosReceberPagarComSinal").multiply(new BigDecimal(-1)));
                            continue;
                        }
                        if (this.campos[i].equals("dataPagamento") || this.campos[i].equals("jurosPagamento") || this.campos[i].equals("descontoPagamento") || this.campos[i].equals("valorPagamento") || this.campos[i].equals("jurosSomatorioPagamento") || this.campos[i].equals("impostosSomatorioPagamento") || this.campos[i].equals("impostosSomatorioPagamentoComSinal") || this.campos[i].equals("impostosPagamento") || this.campos[i].equals("impostosPagamentoComSinal") || this.campos[i].equals("descontoSomatorioPagamento") || this.campos[i].equals("valorSomatorioPagamentoComSinal") || this.campos[i].equals("valorPagamentoComSinal") || this.campos[i].equals("detalheTodosPagamentos") || this.campos[i].equals("valorTotalBaixaComImpostos") || this.campos[i].equals("valorReceberPagarSomatorioComSinal") || this.campos[i].equals("valorTituloPagamentoComSinal")) continue;
                        boolean campoCadastro = false;
                        if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                            for (int j = 0; j < CAMPOSCADASTRO.length; ++j) {
                                if (!this.campos[i].equals(CAMPOSCADASTRO[j])) continue;
                                campoCadastro = true;
                                break;
                            }
                        }
                        if (campoCadastro) continue;
                        if (!(this.tipoRelatorio == 3 || this.campos[i].equalsIgnoreCase("codigosPlanoContas") || this.campos[i].equalsIgnoreCase("contasPlanoContas") || this.campos[i].equalsIgnoreCase("descricoesPlanoContas"))) {
                            o[i] = rs.getObject(this.campos[i]);
                            continue;
                        }
                        if (this.tipoRelatorio != 3) continue;
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                        this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastroReceberPagar"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (this.tipoRelatorio == 3) {
                    for (int i = 0; i < modelo.getRowCount(); ++i) {
                        buf.delete(0, buf.length());
                        buf.append(" select lcx.lcx_vencimento as dataPagamento ");
                        buf.append("       ,lcx.lcx_tipopagamento as tipoPagamento ");
                        buf.append("       ,lcx.lcx_tipo as tipo ");
                        buf.append("       , conta.cco_conta as contaConta ");
                        buf.append("       , conta.cco_titular as titularConta ");
                        buf.append("       ,COALESCE(lcx.lcx_valorjuro, 0) as jurosPagamento ");
                        buf.append("       ,COALESCE(lcx.lcx_valordesconto, 0) as descontoPagamento ");
                        buf.append("       ,COALESCE(lcx.lcx_valortotal, 0) as valorPagamento ");
                        buf.append("       ,CASE WHEN lcx.lcx_tipo = '").append("C").append("' THEN");
                        buf.append("             COALESCE(lcx.lcx_valortotal, 0) ");
                        buf.append("        ELSE ");
                        buf.append("             COALESCE(lcx.lcx_valortotal, 0) * (-1) ");
                        buf.append("        END as valorPagamentoComSinal, ");
                        buf.append("       (select sum(COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0)) ");
                        buf.append("                   from baixa bxa ");
                        buf.append("                   join baixareceberpagar brp on (bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo) ");
                        buf.append("                   join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and rpg.rpg_situacao ='").append("Q").append("') ");
                        buf.append("                   where bxa.fil_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoFilialBaixa")));
                        buf.append("                     and bxa.bxa_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoBaixa")));
                        buf.append("        ) as impostosPagamento, ");
                        buf.append("       (select sum(COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0)) ");
                        buf.append("                   from baixa bxa ");
                        buf.append("                   join baixareceberpagar brp on (bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo) ");
                        buf.append("                   join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and rpg.rpg_situacao ='").append("Q").append("') ");
                        buf.append("                   where bxa.fil_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoFilialBaixa")));
                        buf.append("                     and bxa.bxa_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoBaixa")));
                        buf.append("        )  as impostosPagamentoComSinal ");
                        buf.append("   from lanctocaixa lcx ");
                        buf.append("   join baixalanctocaixa blc on blc.fil_codigo = lcx.fil_codigo ");
                        buf.append("                            and blc.lcx_codigo = lcx.lcx_codigo ");
                        buf.append("                            and blc.est_codigo = lcx.est_codigo ");
                        buf.append("   join contacorrente conta on  lcx.fil_codigo = conta.fil_codigo ");
                        buf.append("                            and lcx.cco_reduzido = conta.cco_reduzido ");
                        buf.append("  where blc.fil_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoFilialBaixa")));
                        buf.append("    and blc.bxa_codigo =\n ").append(modelo.getValueAt(i, modelo.findColumn("codigoBaixa")));
                        try {
                            rs = st.executeQuery(buf.toString());
                            StringBuilder dataPagamento = new StringBuilder();
                            BigDecimal jurosPagamento = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal descontoPagamento = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal impostosPagamento = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal impostosPagamentoComSinal = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal valorPagamento = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal valorPagamentoComSinal = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal valorTotalBaixaComImpostos = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal valorTotalBaixa = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            BigDecimal valorTituloPagamentoComSinal = BigDecimal.ZERO.setScale(this.CASAS, this.ROUND);
                            valorTotalBaixa = valorTotalBaixa.add((BigDecimal)modelo.getValueAt(i, modelo.findColumn("valorTotalBaixaComSinal")));
                            valorTotalBaixaComImpostos = valorTotalBaixaComImpostos.add(valorTotalBaixa);
                            StringBuilder detalheTodosPagamentos = new StringBuilder();
                            detalheTodosPagamentos.delete(0, detalheTodosPagamentos.length());
                            while (rs.next()) {
                                dataPagamento.append(dataPagamento.length() > 0 ? " " : "").append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataPagamento")));
                                jurosPagamento = jurosPagamento.add(rs.getBigDecimal("jurosPagamento")).setScale(this.CASAS, this.ROUND);
                                descontoPagamento = descontoPagamento.add(rs.getBigDecimal("descontoPagamento")).setScale(this.CASAS, this.ROUND);
                                impostosPagamento = impostosPagamento.add(rs.getBigDecimal("impostosPagamento")).setScale(this.CASAS, this.ROUND);
                                valorPagamento = valorPagamento.add(rs.getBigDecimal("valorPagamento")).setScale(this.CASAS, this.ROUND);
                                valorPagamentoComSinal = valorPagamentoComSinal.add(rs.getBigDecimal("valorPagamentoComSinal")).setScale(this.CASAS, this.ROUND);
                                if (rs.getString("tipo").equalsIgnoreCase("C")) {
                                    impostosPagamentoComSinal = impostosPagamentoComSinal.add(rs.getBigDecimal("impostosPagamentoComSinal")).setScale(this.CASAS, this.ROUND);
                                    valorTituloPagamentoComSinal = valorTituloPagamentoComSinal.add(valorPagamentoComSinal).add(impostosPagamentoComSinal);
                                } else {
                                    valorTituloPagamentoComSinal = valorTituloPagamentoComSinal.add(valorPagamentoComSinal).add(rs.getBigDecimal("impostosPagamentoComSinal"));
                                }
                                if (detalheTodosPagamentos.length() > 0) {
                                    detalheTodosPagamentos.append(" , ");
                                }
                                detalheTodosPagamentos.append("[");
                                detalheTodosPagamentos.append(Funcoes.formataData("dd/MM/yy", rs.getDate("dataPagamento"))).append(" - ");
                                detalheTodosPagamentos.append(Funcoes.formataDecimal(rs.getBigDecimal("valorPagamento").setScale(this.CASAS, this.ROUND).doubleValue())).append(" (");
                                detalheTodosPagamentos.append(Tipos.tipoPagamento(rs.getString("tipoPagamento"))).append(") - ");
                                detalheTodosPagamentos.append("Conta: ").append(rs.getString("contaConta"));
                                detalheTodosPagamentos.append("]");
                            }
                            valorTotalBaixaComImpostos = valorTotalBaixaComImpostos.add(impostosPagamentoComSinal).setScale(this.CASAS, this.ROUND);
                            modelo.setValueAt(dataPagamento, i, modelo.findColumn("dataPagamento"));
                            modelo.setValueAt(jurosPagamento, i, modelo.findColumn("jurosPagamento"));
                            modelo.setValueAt(jurosPagamento.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), this.ROUND), i, modelo.findColumn("jurosSomatorioPagamento"));
                            modelo.setValueAt(descontoPagamento, i, modelo.findColumn("descontoPagamento"));
                            modelo.setValueAt(descontoPagamento.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), this.ROUND), i, modelo.findColumn("descontoSomatorioPagamento"));
                            modelo.setValueAt(impostosPagamento, i, modelo.findColumn("impostosPagamento"));
                            modelo.setValueAt(impostosPagamentoComSinal, i, modelo.findColumn("impostosPagamentoComSinal"));
                            modelo.setValueAt(impostosPagamentoComSinal.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), this.ROUND), i, modelo.findColumn("impostosSomatorioPagamentoComSinal"));
                            modelo.setValueAt(valorPagamento, i, modelo.findColumn("valorPagamento"));
                            modelo.setValueAt(valorPagamentoComSinal, i, modelo.findColumn("valorPagamentoComSinal"));
                            modelo.setValueAt(valorPagamentoComSinal.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), this.ROUND), i, modelo.findColumn("valorSomatorioPagamentoComSinal"));
                            modelo.setValueAt(detalheTodosPagamentos, i, modelo.findColumn("detalheTodosPagamentos"));
                            modelo.setValueAt(valorTotalBaixaComImpostos, i, modelo.findColumn("valorTotalBaixaComImpostos"));
                            modelo.setValueAt(valorTotalBaixaComImpostos.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), this.ROUND), i, modelo.findColumn("valorReceberPagarSomatorioComSinal"));
                            modelo.setValueAt(valorTituloPagamentoComSinal, i, modelo.findColumn("valorTituloPagamentoComSinal"));
                            continue;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                if (this.tipoRelatorio == 0) {
                    buf.append(RelatorioBaixa.getModuloAcesso(0));
                } else if (this.tipoRelatorio == 1) {
                    buf.append(RelatorioBaixa.getModuloAcesso(1));
                } else if (this.tipoRelatorio == 2) {
                    buf.append(RelatorioBaixa.getModuloAcesso(2));
                } else if (this.tipoRelatorio == 3) {
                    buf.append(RelatorioBaixa.getModuloAcesso(3));
                }
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioBaixa.this.panelCentro.removeAll();
                            RelatorioBaixa.this.panelCentro.repaint();
                            RelatorioBaixa.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_VALOR_INICIAL, this.getFiltroData(FILTRO_VALOR_INICIAL));
                    var.put(FILTRO_VALOR_FINAL, this.getFiltroData(FILTRO_VALOR_FINAL));
                    var.put(FILTRO_QTDE_TITULOS, this.getFiltroData(FILTRO_QTDE_TITULOS));
                    var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO));
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                    var.put(FILTRO_TIPO_BAIXA, this.getFiltroCombo(FILTRO_TIPO_BAIXA));
                    if (this.tipoRelatorio == 1) {
                        var.put(FILTRO_ORDEM_RECPAG, this.getFiltroCombo(FILTRO_ORDEM_RECPAG));
                    } else if (this.tipoRelatorio == 2) {
                        var.put(FILTRO_ORDEM_LANCTO, this.getFiltroCombo(FILTRO_ORDEM_LANCTO));
                    }
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    if (buf.length() > 0) {
                        var.put(FILTRO_FILIAL, buf.toString());
                    } else {
                        var.put(FILTRO_FILIAL, Variaveis.filialPadrao);
                    }
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (int i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_USUARIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (entidade != null) {
                        for (int i = 0; i < entidade.length; ++i) {
                            buf.append(entidade[i]);
                            if (i >= entidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_ENTIDADE, buf.toString());
                    buf.delete(0, buf.length());
                    if (paciente != null) {
                        for (int i = 0; i < paciente.length; ++i) {
                            buf.append(paciente[i]);
                            if (i >= paciente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_PACIENTE, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (int i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (int i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_USUARIO, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo == null) {
            return;
        }
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro, pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, con.con_razao as razaoSocialCadastro,'' as nomeSocialPaciente, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro,'' as nomeSocialPaciente, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : CAMPOSCADASTRO) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[modelo.findColumn((String)s)] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(modelo.getColumnName(pos))) : rs.getObject(s);
            }
        }
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0851500100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0851600100");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0852100100");
        }
        return Long.parseLong("0851700100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0851500101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0851600101");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0852100101");
        }
        return Long.parseLong("0851700101");
    }

    public String getAgrupamento() {
        StringBuilder buf = new StringBuilder();
        buf.append(" group by a.fil_codigo, ");
        buf.append("          a.bxa_codigo, ");
        buf.append("          a.bxa_datahora, ");
        buf.append("          a.bxa_quantidadetitulos, ");
        buf.append("          a.bxa_valortotal, ");
        buf.append("          a.bxa_valorjuros, ");
        buf.append("          a.bxa_valormultas, ");
        buf.append("          a.bxa_valoracrescimo, ");
        buf.append("          a.bxa_valordescontos, ");
        buf.append("          a.bxa_valortaxas, ");
        buf.append("          a.usr_codigo, ");
        buf.append("          a.usr_codcancelado, ");
        buf.append("          a.bxa_situacao, ");
        buf.append("          a.bxa_datacancelado, ");
        buf.append("          a.bxa_irrfvalor, ");
        buf.append("          a.bxa_issvalor, ");
        buf.append("          a.bxa_pisvalor, ");
        buf.append("          a.bxa_csllvalor, ");
        buf.append("          a.bxa_cofinsvalor, ");
        buf.append("          a.bxa_inssvalor, ");
        buf.append("          a.bxa_tipo, ");
        buf.append("          a.bxa_datahora, ");
        buf.append("          a.usr_codigo, ");
        buf.append("          motCancBaixa.mov_codigo, ");
        buf.append("          motCancBaixa.mov_descricao, ");
        buf.append("          a.bxa_descricaocancelamento, ");
        buf.append("          rpg.rpg_valortotal, ");
        buf.append("          rpg.rpg_valor, ");
        buf.append("          rpg.rpg_taxa, ");
        buf.append("          rpg.rpg_valoracrescimo, ");
        buf.append("          rpg.rpg_valordesconto, ");
        buf.append("          rpg.rpg_codigo, ");
        buf.append("          rpg.rpg_datahora, ");
        buf.append("          rpg.rpg_vencimento, ");
        buf.append("          rpg.rpg_competencia, ");
        buf.append("          rpg.rpg_tipojuros, ");
        buf.append("          rpg.rpg_tipo, ");
        buf.append("          rpg.rpg_tipodocumento, ");
        buf.append("          rpg.rpg_numerodocumento, ");
        buf.append("          rpg.rpg_parcela, ");
        buf.append("          rpg.rpg_codigodocumento, ");
        buf.append("          rpg.rpg_datadocumento, ");
        buf.append("          rpg.rpg_dataprocessamento, ");
        buf.append("          rpg.rpg_obs, ");
        buf.append("          rpg.rpg_tipocadastro, ");
        buf.append("          usrrecpag.usr_codigo, ");
        buf.append("          usrrecpag.usr_nome, ");
        buf.append("          usuariocancela.usr_codigo, ");
        buf.append("          usuariocancela.usr_nome, ");
        buf.append("          rpg.rpg_datacancelado, ");
        buf.append("          rpg.rpg_situacao, ");
        buf.append("          rpg.ser_codigo, ");
        buf.append("          ser.ser_descricao, ");
        buf.append("          rpg.rpg_valorjuro, ");
        buf.append("          rpg.rpg_valormulta, ");
        buf.append("          rpg.rpg_percentualmulta, ");
        buf.append("          rpg.rpg_percentualjuro, ");
        buf.append("          rpg.rpg_percentualacrescimo, ");
        buf.append("          rpg.rpg_percentualdesconto, ");
        buf.append("          rpg.rpg_irrfvalor, ");
        buf.append("          rpg.rpg_irrfpercentual, ");
        buf.append("          rpg.rpg_issvalor, ");
        buf.append("          rpg.rpg_isspercentual, ");
        buf.append("          rpg.rpg_pisvalor, ");
        buf.append("          rpg.rpg_pispercentual, ");
        buf.append("          rpg.rpg_csllvalor, ");
        buf.append("          rpg.rpg_csllpercentual, ");
        buf.append("          rpg.rpg_cofinsvalor, ");
        buf.append("          rpg.rpg_cofinspercentual, ");
        buf.append("          rpg.rpg_inssvalor, ");
        buf.append("          rpg.rpg_insspercentual, ");
        buf.append("          rpg.nfi_codigo, ");
        buf.append("          rpg.rpg_icmsvalor, ");
        buf.append("          rpg.rpg_ipivalor, ");
        buf.append("          nfi.nfi_irrfvalor, ");
        buf.append("          nfi.nfi_issvalor, ");
        buf.append("          nfi.nfi_pisvalor, ");
        buf.append("          nfi.nfi_csllvalor, ");
        buf.append("          nfi.nfi_cofinsvalor, ");
        buf.append("          nfi.nfi_issvalor, ");
        buf.append("          nfi.nfi_inssvalor, ");
        buf.append("          nfi.nfi_icmsvalor, ");
        buf.append("          nfi.nfi_ipivalor, ");
        buf.append("          rpg.con_codigo, ");
        buf.append("          rpg.pac_codigo, ");
        buf.append("          rpg.ent_codigo, ");
        buf.append("          pac.pac_nome, ");
        buf.append("          pac.pac_nomesocial, ");
        buf.append("          ent.ent_fantasia, ");
        buf.append("          con.con_fantasia, ");
        buf.append("          ent.ent_razaosocial, ");
        buf.append("          con.con_razao, ");
        buf.append("          pac.pac_fone, ");
        buf.append("          ent.ent_fone, ");
        buf.append("          con.con_fone, ");
        buf.append("          pac.pac_endereco, ");
        buf.append(" \t\t\t\t\tent.ent_numeroendereco, ");
        buf.append("          pac.pac_numeroendereco, ");
        buf.append("\t\t\t\t\tcon.con_numeroendereco, ");
        buf.append("\t\t\t\t\tent.ent_tipologradouroendereco, ");
        buf.append("\t\t\t\t\tpac.pac_tipologradouroendereco, ");
        buf.append("\t\t\t\t\tcon.con_tipologradouroendereco, ");
        buf.append("\t\t\t\t\tcon.con_numeroendereco, ");
        buf.append("          ent.ent_endereco, ");
        buf.append("          con.con_endereco, ");
        buf.append("          rpg.pac_codigo, ");
        buf.append("          pac.pac_fax, ");
        buf.append("          rpg.ent_codigo, ");
        buf.append("          ent.ent_fax, ");
        buf.append("          con.con_fax, ");
        buf.append("          faxCadastro, ");
        buf.append("          rpg.pac_codigo, ");
        buf.append("          pac.pac_complemento, ");
        buf.append("          rpg.ent_codigo, ");
        buf.append("          ent.ent_complemento, ");
        buf.append("          con.con_complemento, ");
        buf.append("          complementoCadastro, ");
        buf.append("          rpg.pac_codigo, ");
        buf.append("          pac.pac_cep, ");
        buf.append("          rpg.ent_codigo, ");
        buf.append("          ent.ent_cep, ");
        buf.append("          con.con_cep, ");
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        return buf.toString();
    }
}

