/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class RelatorioAvisoCobranca
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_RECEBER_PAGAR = "filtroReceberPagar";
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};
    private static final String[] camposRecPag = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "numeroNotaFiscal", "situacaoNotaFiscal", "serieNotaFiscal", "valorTotalReceberPagar", "dataPorExtenso", "estadoCadastro", "isEletronica"});
    protected static final String[] camposRelatorio = ArraysUtil.concatenar(camposCadastros, camposRecPag);
    public String codigoReceberPagar = null;

    public RelatorioAvisoCobranca(boolean montaTela) {
        if (montaTela) {
            this.montaBarraDescricao("Relat\u00f3rio de aviso de cobran\u00e7a", "Impress\u00e3o/Reimpress\u00e3o de avisos de cobran\u00e7a", "relatorios/rel_financeiro_movimento_aviso_cobranca.jpg");
            this.adicionaRelatorioListener(this);
            this.adicionaFiltroComPesquisa(FILTRO_RECEBER_PAGAR, "Conta Receber", 10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Hashtable pesq = Pesquisas.tituloAvisoCobranca(Laboratorio.getInstancia());
                        if (pesq == null) {
                            return;
                        }
                        ReceberPagarBean recpag = (ReceberPagarBean)new ReceberPagarService().get(String.valueOf((Integer)pesq.get("rpg_codigo")));
                        if (recpag != null) {
                            RelatorioAvisoCobranca.this.setFiltroComPesquisa(RelatorioAvisoCobranca.FILTRO_RECEBER_PAGAR, String.valueOf(recpag.getCodigo()));
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(RelatorioAvisoCobranca.this, e1.getMessage(), e1.getStackTrace(), "RelatorioAvisoCobranca");
                    }
                }
            }, 1);
            this.setModuloConfigurar(RelatorioAvisoCobranca.getModuloConfigurar());
            this.setModuloAcesso(RelatorioAvisoCobranca.getModuloAcesso());
            this.setCamposConfigurador(camposRelatorio);
        }
    }

    public void imprimirPressionado(String codigoReceberPagar) {
        if (codigoReceberPagar == null) {
            Funcoes.mensagem(this, "O t\u00edtulo n\u00e3o p\u00f4de ser impresso.", 2);
            return;
        }
        this.codigoReceberPagar = codigoReceberPagar;
        this.imprimirPressionado();
        this.codigoReceberPagar = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block12: {
            if (this.codigoReceberPagar == null && (this.getFiltroComPesquisa(FILTRO_RECEBER_PAGAR) == null || this.getFiltroComPesquisa(FILTRO_RECEBER_PAGAR).length() == 0)) {
                Funcoes.mensagem(this, "Nenhum t\u00edtulo foi selecionado.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append("a.rpg_valor as valorReceberPagar, ");
            buf.append("a.rpg_taxa as valorTaxaReceberPagar, ");
            buf.append("a.rpg_valortotal as valorTotalReceberPagar, ");
            buf.append("a.rpg_valoracrescimo as valorAcrescimoReceberPagar, ");
            buf.append("COALESCE(a.rpg_valordesconto, 0) as valorDescontoReceberPagar, ");
            buf.append("a.rpg_codigo as codigoReceberPagar, ");
            buf.append("a.rpg_datahora as dataHoraReceberPagar, ");
            buf.append("a.rpg_vencimento as dataVencimentoReceberPagar, ");
            buf.append("a.rpg_competencia as dataCompetenciaReceberPagar, ");
            buf.append("a.rpg_tipojuros as tipoJurosReceberPagar, ");
            buf.append("a.rpg_tipo as tipoReceberPagar, ");
            buf.append("a.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
            buf.append("a.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
            buf.append("a.rpg_parcela as numeroParcelaReceberPagar, ");
            buf.append("a.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
            buf.append("a.rpg_datadocumento as dataDocumentoReceberPagar, ");
            buf.append("a.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
            buf.append("a.rpg_obs as observacaoReceberPagar, ");
            buf.append("a.rpg_tipocadastro as tipoCadastroReceberPagar, ");
            buf.append("usrrecpag.usr_codigo as codigoUsuarioReceberPagar, ");
            buf.append("usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
            buf.append("usuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, ");
            buf.append("usuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
            buf.append("a.rpg_datacancelado as dataCancelamentoReceberPagar, ");
            buf.append("a.rpg_situacao as situacaoReceberPagar, ");
            buf.append("a.rpg_valor + a.rpg_taxa as valorComTaxaReceberPagar, ");
            buf.append("a.rpg_valorjuro as valorJuroReceberPagar, ");
            buf.append("a.rpg_valormulta as valorMultaReceberPagar, ");
            buf.append("a.rpg_valoracrescimo as valorAcrescimoReceberPagar, ");
            buf.append("a.rpg_percentualmulta as percentualMultaReceberPagar, ");
            buf.append("a.rpg_percentualjuro as percentualJuroReceberPagar, ");
            buf.append("a.rpg_percentualacrescimo as percentualAcrescimoReceberPagar, ");
            buf.append("a.rpg_percentualdesconto as percentualDescontoReceberPagar, ");
            buf.append("a.rpg_irrfvalor as valorIrrfReceberPagar, ");
            buf.append("a.rpg_irrfpercentual as percentualIrrfReceberPagar, ");
            buf.append("a.rpg_issvalor as valorIssReceberPagar, ");
            buf.append("a.rpg_isspercentual as percentualIssReceberPagar, ");
            buf.append("a.rpg_pisvalor as valorPisReceberPagar, ");
            buf.append("a.rpg_pispercentual as percentualPisReceberPagar, ");
            buf.append("a.rpg_csllvalor as valorCsllReceberPagar, ");
            buf.append("a.rpg_csllpercentual as percentualCsllReceberPagar, ");
            buf.append("a.rpg_cofinsvalor as valorCofinsReceberPagar, ");
            buf.append("a.rpg_cofinspercentual as percentualCofinsReceberPagar, ");
            buf.append("a.rpg_inssvalor as valorInssReceberPagar, ");
            buf.append("a.rpg_insspercentual as percentualInssReceberPagar, ");
            buf.append("COALESCE( ");
            buf.append("    (case when a.nfi_codigo is null then ");
            buf.append("          a.rpg_irrfvalor + a.rpg_issvalor + a.rpg_pisvalor + a.rpg_csllvalor + a.rpg_cofinsvalor + a.rpg_inssvalor ");
            buf.append("     else ");
            buf.append("          nfi.nfi_irrfvalor + nfi.nfi_issvalor + nfi.nfi_pisvalor + nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor ");
            buf.append("    end), 0) as valorImpostosReceberPagar, ");
            buf.append("COALESCE(a.rpg_valormulta + a.rpg_valoracrescimo + a.rpg_valorjuro, 0) as valorTaxaTotalReceberPagar, ");
            buf.append("a.ser_codigo as codigoSerie, s.ser_descricao as descricaoSerie, ");
            buf.append("case ");
            buf.append("  when a.rpg_tipocadastro = '").append("O").append("' then a.con_codigo ");
            buf.append("  when a.rpg_tipocadastro = '").append("P").append("' then a.pac_codigo ");
            buf.append("  when a.rpg_tipocadastro = '").append("U").append("' then a.ent_codigo ");
            buf.append("  when a.rpg_tipocadastro = '").append("F").append("' then a.ent_codigo ");
            buf.append("  when a.rpg_tipocadastro = '").append("C").append("' then a.ent_codigo ");
            buf.append("  when a.rpg_tipocadastro = '").append("R").append("' then a.ent_codigo ");
            buf.append("  else a.ent_codigo ");
            buf.append("end as codigoCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fantasia ");
            buf.append("  \t\t\t\t\telse con.con_fantasia ");
            buf.append("\t\t\t end as fantasiaCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_nomesocial ");
            buf.append("  \t\t\t\t\telse '' ");
            buf.append("\t\t\t end as nomeSocialPaciente ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_razaosocial ");
            buf.append("  \t\t\t\t\telse con.con_razao ");
            buf.append("\t\t\t end as razaoSocialCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_fone ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fone ");
            buf.append("  \t\t\t\t\telse con.con_fone ");
            buf.append("\t\t\t end as foneCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_endereco ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_endereco ");
            buf.append("  \t\t\t\t\telse con.con_endereco ");
            buf.append("\t\t\t end as enderecoCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_numeroendereco ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_numeroendereco ");
            buf.append("\t\t\t end as numeroEnderecoCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_tipologradouroendereco ");
            buf.append("\t\t\t end as tipoLogradouroCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_fax ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fax ");
            buf.append("  \t\t\t\t\telse con.con_fax ");
            buf.append("\t\t\t end as faxCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_complemento ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_complemento ");
            buf.append("  \t\t\t\t\telse con.con_complemento ");
            buf.append("\t\t\t end as complementoCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.cid_codigo ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.cid_codigo ");
            buf.append("  \t\t\t\t\telse con.cid_codigo ");
            buf.append("\t\t\t end as codigoCidadeCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then cidp.cid_nome ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then cide.cid_nome ");
            buf.append("  \t\t\t\t\telse cidc.cid_nome ");
            buf.append("\t\t\t end as nomeCidadeCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then cidp.cid_uf ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then cide.cid_uf ");
            buf.append("  \t\t\t\t\telse cidc.cid_uf ");
            buf.append("\t\t\t end as estadoCadastro ");
            buf.append("      ,case ");
            buf.append("            when a.pac_codigo is not null then pac.pac_cep ");
            buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cep ");
            buf.append("  \t\t\t\t\telse con.con_cep ");
            buf.append("\t\t\t end as cepCadastro, ");
            buf.append("nfi.nfi_numero as numeroNotaFiscal, ");
            buf.append("nfi.ser_codigo as serieNotaFiscal, ");
            buf.append("nfi.nfi_situacao as situacaoNotaFiscal, ");
            buf.append(" nfi.nfi_numerorps IS NOT NULL as isEletronica, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from receberpagar a ");
            buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
            buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
            buf.append("left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
            buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
            buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
            buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
            buf.append("left join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
            buf.append("left join cidades cidp on (a.fil_codigo = cidp.fil_codigo and pac.cid_codigo = cidp.cid_codigo and a.rpg_tipocadastro = '").append("P").append("')");
            buf.append("left join cidades cidc on (a.fil_codigo = cidc.fil_codigo and con.cid_codigo = cidc.cid_codigo and a.rpg_tipocadastro = '").append("O").append("')");
            buf.append("left join cidades cide on (a.fil_codigo = cide.fil_codigo and ent.cid_codigo = cide.cid_codigo and a.rpg_tipocadastro NOT IN('").append("P").append("', '").append("O").append("'))");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            if (this.codigoReceberPagar == null) {
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("   and a.rpg_codigo = ").append(this.getFiltroComPesquisa(FILTRO_RECEBER_PAGAR));
            } else {
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("   and a.rpg_codigo = ").append(this.codigoReceberPagar);
            }
            buf.append(" and a.rpg_situacao = '").append("V").append("'");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(camposRelatorio){

                        @Override
                        public String getColumnName(int column) {
                            return this.colunas[column];
                        }
                    };
                    do {
                        Object[] o = new Object[camposRelatorio.length];
                        for (int i = 0; i < camposRelatorio.length; ++i) {
                            o[modelo.findColumn((String)RelatorioAvisoCobranca.camposRelatorio[i])] = camposRelatorio[i].equals("tipoReceberPagar") ? Tipos.tipoReceberPagar(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("valorTotalReceberPagar") || camposRelatorio[i].equals("valorReceberPagar") || camposRelatorio[i].equals("valorTaxaTotalReceberPagar") ? Float.valueOf(rs.getFloat(camposRelatorio[i])) : (camposRelatorio[i].equals("valorDescontoReceberPagar") ? Float.valueOf(rs.getFloat(camposRelatorio[i])) : (camposRelatorio[i].equals("valorImpostosReceberPagar") ? Float.valueOf(rs.getFloat(camposRelatorio[i])) : (camposRelatorio[i].equals("tipoDocumentoReceberPagar") ? Tipos.tipoDocumento(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("situacaoReceberPagar") ? Tipos.tipoSituacaoReceberPagar(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("tipoCadastroReceberPagar") ? Tipos.tipoCadastro(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getString(camposRelatorio[i]), rs.getBoolean("isEletronica")) : (camposRelatorio[i].equals("dataPorExtenso") ? Funcoes.dataPorExtenso(new Date(), true) : rs.getObject(camposRelatorio[i]))))))))));
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (modelo == null || modelo.getRowCount() <= 0) break block12;
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAvisoCobranca.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block12;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    if (this.codigoReceberPagar == null) {
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAvisoCobranca.this.panelCentro.removeAll();
                                RelatorioAvisoCobranca.this.panelCentro.repaint();
                                RelatorioAvisoCobranca.this.habilitaBotaoImprimir(true);
                            }
                        });
                    }
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_RECEBER_PAGAR, this.getFiltroComPesquisa(FILTRO_RECEBER_PAGAR));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    if (this.codigoReceberPagar == null) {
                        this.panelCentro.revalidate();
                    }
                    break block12;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0852200100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0852200101");
    }
}

