/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.BaixaService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class RelatorioAutorizacaoDebito
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private boolean auxErro = false;
    private static final String FILTRO_BAIXA = "filtroBaixa";
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "nomeSocialPaciente", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "cnpjCadastro", "cpfCadastro", "ieCadastro", "rgCadastro"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "taxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "codigoBaixa", "dataHoraBaixa", "quantidadeTitulosBaixa", "valorTotalBaixa", "valorJurosBaixa", "valorMultasBaixa", "valorAcrescimosBaixa", "valorDescontosBaixa", "valorTaxasBaixa", "situacaoBaixa", "dataCancelamentoBaixa", "valorIrrfBaixa", "valorIssBaixa", "valorPisBaixa", "valorCsllBaixa", "valorCofinsBaixa", "valorInssBaixa", "codigoUsuarioBaixa", "nomeUsuarioBaixa", "codigoUsuarioCancelamentoBaixa", "nomeUsuarioCancelamentoBaixa", "valorTotalReceberPagar", "codigoLancamento", "dataHoraLancamento", "valorLancamento", "codigoContaCorrente", "contaContaCorrente", "titularContaCorrente", "codigoAgencia", "descricaoAgencia", "codigoBanco", "descricaoBanco", "numeroDocumentoLancamento", "dataVencimentoLancamento", "dataCompetenciaLancamento"});
    protected static final String[] campos = ArraysUtil.concatenar(camposRelatorio, camposCadastros);

    public RelatorioAutorizacaoDebito() {
        this.montaBarraDescricao("Relat\u00f3rio Autoriza\u00e7\u00e3o de D\u00e9bito", "Listagem com os t\u00edtulos pertencentes a baixa para relacionamento na autoriza\u00e7\u00e3o de d\u00e9bito", "relatorios/autorizacao_debito.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa(FILTRO_BAIXA, "Baixa", 5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hashtable pesq = Pesquisas.baixaAutorizacaoDebito(Laboratorio.getInstancia(), false);
                    if (pesq == null) {
                        return;
                    }
                    BaixaBean baixa = (BaixaBean)new BaixaService().get(String.valueOf((Integer)pesq.get("bxa_codigo")));
                    if (baixa != null) {
                        RelatorioAutorizacaoDebito.this.setFiltroComPesquisa(RelatorioAutorizacaoDebito.FILTRO_BAIXA, String.valueOf(baixa.getCodigo()));
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(RelatorioAutorizacaoDebito.this, e1.getMessage(), e1.getStackTrace(), "RelatorioAutorizacaoDebito: 80");
                }
            }
        }, 1);
        this.setModuloConfigurar(Long.parseLong("0850700101"));
        this.setModuloAcesso(RelatorioAutorizacaoDebito.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block7: {
            this.auxErro = false;
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, Variaveis.filialPadrao, this.getFiltroComPesquisa(FILTRO_BAIXA));
                if (modelo != null && modelo.getRowCount() > 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoDebito.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAutorizacaoDebito.this.panelCentro.removeAll();
                                RelatorioAutorizacaoDebito.this.panelCentro.repaint();
                                RelatorioAutorizacaoDebito.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_BAIXA, this.getFiltroComPesquisa(FILTRO_BAIXA));
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block7;
                }
                if (!this.auxErro) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDialog gerarRelatorio(Frame owner, Dimension dimensoesDialogo, Statement st, Statement st2, String filial, String codigoBaixa) {
        JDialog dialogo;
        block6: {
            dialogo = null;
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, filial, codigoBaixa);
                if (modelo != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoDebito.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        dialogo = new JDialog(owner, true);
                        dialogo.setPreferredSize(dimensoesDialogo);
                        dialogo.setMinimumSize(dimensoesDialogo);
                        final Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(dialogo);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                gerador.getPai().setVisible(false);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_BAIXA, codigoBaixa);
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    }
                    break block6;
                }
                Funcoes.mensagem(owner, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        return dialogo;
    }

    private ModeloGridTable geraModeloDados(Statement st, Statement st2, String filial, String codigoBaixa) throws SQLException {
        if (Funcoes.textoVazio(codigoBaixa)) {
            Funcoes.mensagem(this, "Uma baixa deve ser selecionada para o relat\u00f3rio", 2);
            this.habilitaBotaoImprimir(true);
            this.auxErro = true;
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("select a.bxa_codigo as codigoBaixa, a.bxa_datahora as dataHoraBaixa, a.bxa_quantidadetitulos as quantidadeTitulosBaixa, ");
        buf.append("a.bxa_valortotal as valorTotalBaixa, a.bxa_valorjuros as valorJurosBaixa, a.bxa_valormultas as valorMultasBaixa, ");
        buf.append("a.bxa_valoracrescimo as valorAcrescimosBaixa, a.bxa_valordescontos as valorDescontosBaixa, ");
        buf.append("a.bxa_valortaxas as valorTaxasBaixa, a.bxa_situacao as situacaoBaixa, ");
        buf.append("a.bxa_datacancelado as dataCancelamentoBaixa, a.bxa_irrfvalor as valorIrrfBaixa, ");
        buf.append("a.bxa_issvalor as valorIssBaixa, a.bxa_pisvalor as valorPisBaixa, a.bxa_csllvalor as valorCsllBaixa, ");
        buf.append("a.bxa_cofinsvalor as valorCofinsBaixa, a.bxa_inssvalor as valorInssBaixa, ");
        buf.append("a.usr_codigo as codigoUsuarioBaixa, usuario.usr_nome as nomeUsuarioBaixa, ");
        buf.append("a.usr_codcancelado as codigoUsuarioCancelamentoBaixa, usuariocancelado.usr_nome as nomeUsuarioCancelamentoBaixa, ");
        buf.append("lc.lcx_codigo as codigoLancamento, lc.lcx_datahora as dataHoraLancamento, lc.lcx_valortotal as valorLancamento, ");
        buf.append("lc.lcx_documento as numeroDocumentoLancamento, ");
        buf.append("lc.lcx_vencimento as dataVencimentoLancamento, lc.lcx_competencia as dataCompetenciaLancamento, ");
        buf.append("lc.cco_reduzido as codigoContaCorrente, cc.cco_conta as contaContaCorrente, cc.cco_titular as titularContaCorrente, ");
        buf.append("cc.age_codigo as codigoAgencia, ag.age_descricao as descricaoAgencia, ");
        buf.append("cc.bac_codigo as codigoBanco, bc.bac_descricao as descricaoBanco, ");
        buf.append("rpg.rpg_codigo as codigoReceberPagar, rpg.rpg_datahora as dataHoraReceberPagar, rpg.rpg_vencimento as dataVencimentoReceberPagar, ");
        buf.append("rpg.rpg_valor as valorReceberPagar, rpg.rpg_tipojuros as tipoJurosReceberPagar, rpg.rpg_tipo as tipoReceberPagar, ");
        buf.append("rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, rpg.rpg_taxa as taxaReceberPagar, ");
        buf.append("rpg.rpg_parcela as numeroParcelaReceberPagar, rpg.rpg_codigodocumento as codigoDocumentoReceberPagar, rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
        buf.append("rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, rpg.rpg_obs as observacaoReceberPagar, rpg.rpg_tipocadastro as tipoCadastroReceberPagar, ");
        buf.append("usrrecpag.usr_codigo as codigoUsuarioReceberPagar, usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
        buf.append("rpg.rpg_datacancelado as dataCancelamentoReceberPagar, rpg.rpg_situacao as situacaoReceberPagar, ");
        buf.append("rpg.rpg_valor + rpg.rpg_taxa as valorComTaxaReceberPagar, ");
        buf.append("rpg.rpg_valorjuro as valorJuroReceberPagar, rpg.rpg_valormulta as valorMultaReceberPagar, ");
        buf.append("rpg.rpg_valoracrescimo as valorAcrescimoReceberPagar, rpg.rpg_valordesconto as valorDescontoReceberPagar, ");
        buf.append("rpg.rpg_percentualmulta as percentualMultaReceberPagar, rpg.rpg_percentualjuro as percentualJuroReceberPagar, ");
        buf.append("rpg.rpg_percentualacrescimo as percentualAcrescimoReceberPagar, rpg.rpg_percentualdesconto as percentualDescontoReceberPagar, ");
        buf.append("rpg.ser_codigo as codigoSerie, s.ser_descricao as descricaoSerie, ");
        buf.append("rpg.rpg_valortotal as valorTotalReceberPagar, ");
        buf.append("case ");
        buf.append("  when rpg.rpg_tipocadastro = '").append("O").append("' then rpg.con_codigo ");
        buf.append("  when rpg.rpg_tipocadastro = '").append("P").append("' then rpg.pac_codigo ");
        buf.append("  else rpg.ent_codigo ");
        buf.append("end as codigoCadastro, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from baixa a ");
        buf.append("left join usuario usuario on upper(a.usr_codigo) = upper(usuario.usr_codigo) ");
        buf.append("left join usuario usuariocancelado on upper(a.usr_codcancelado) = upper(usuariocancelado.usr_codigo) ");
        buf.append("left join baixareceberpagar b on a.fil_codigo = b.fil_codigo and a.bxa_codigo = b.bxa_codigo ");
        buf.append("left join receberpagar rpg on b.fil_codigo = rpg.fil_codigo and b.rpg_codigo = rpg.rpg_codigo ");
        buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
        buf.append("left join series s on a.fil_codigo = s.fil_codigo and rpg.ser_codigo = s.ser_codigo ");
        buf.append("left join baixalanctocaixa bcl on a.fil_codigo = bcl.fil_codigo and a.bxa_codigo = bcl.bxa_codigo ");
        buf.append("left join lanctocaixa lc on bcl.fil_codigo = lc.fil_codigo and bcl.lcx_codigo = lc.lcx_codigo and bcl.est_codigo = lc.est_codigo ");
        buf.append("left join contacorrente cc on lc.fil_codigo = cc.fil_codigo and lc.cco_reduzido = cc.cco_reduzido ");
        buf.append("left join agencia ag on cc.fil_codigo = ag.fil_codigo and cc.age_codigo = ag.age_codigo and cc.bac_codigo = ag.bac_codigo ");
        buf.append("left join banco bc on ag.fil_codigo = bc.fil_codigo and ag.bac_codigo = bc.bac_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append(" and a.bxa_codigo = ").append(codigoBaixa);
        buf.append(" and lc.lcx_tipopagamento = '").append("Z").append("' ");
        buf.append(" and rpg.rpg_situacao = '").append("Q").append("' ");
        buf.append(" order by a.fil_codigo, a.bxa_codigo, rpg.rpg_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ModeloGridTable modelo = new ModeloGridTable(campos);
        if (rs.next()) {
            do {
                Object[] o = new Object[camposRelatorio.length + camposCadastros.length];
                for (int i = 0; i < camposRelatorio.length; ++i) {
                    o[modelo.findColumn((String)RelatorioAutorizacaoDebito.camposRelatorio[i])] = camposRelatorio[i].equals("tipoReceberPagar") ? Tipos.tipoReceberPagar(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("valorReceberPagar") ? Double.valueOf(rs.getDouble(camposRelatorio[i])) : (camposRelatorio[i].equals("tipoDocumentoReceberPagar") ? Tipos.tipoDocumento(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("situacaoReceberPagar") ? Tipos.tipoSituacaoReceberPagar(rs.getString(camposRelatorio[i])) : (camposRelatorio[i].equals("tipoCadastroReceberPagar") ? Tipos.tipoCadastro(rs.getString(camposRelatorio[i])) : rs.getObject(camposRelatorio[i])))));
                }
                RelatorioAutorizacaoDebito.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastroReceberPagar"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                modelo.addLine(o);
            } while (rs.next());
        }
        if (modelo != null) {
            modelo.ordenarColunaAvancado(modelo.findColumn("fantasiaCadastro"), modelo.findColumn("codigoReceberPagar"));
        }
        return modelo;
    }

    private static void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        if (tipo == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("pac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro, pac.pac_nome as razaoSocialCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_fone as foneCadastro, ");
            buf.append("pac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_fax as faxCadastro, ");
            buf.append("pac.pac_tipologradouroendereco as tipoLogradouroCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("pac.pac_cpf as cpfCadastro, pac.pac_cnpj as cnpjCadastro, pac.pac_rg as rgCadastro, '' as ieCadastro, ");
            buf.append("pac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("con.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("con.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro,  con.con_fax as faxCadastro, con.con_complemento as complementoCadastro, ");
            buf.append("con.con_tipologradouroendereco as tipoLogradouroCadastro, con.con_cep as cepCadastro, ");
            buf.append("'' as cpfCadastro, con.con_cnpjcpf as cnpjCadastro, '' as rgCadastro, con.con_inscrest as ieCadastro, ");
            buf.append("con.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("left join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("ent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro,  ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ");
            buf.append("ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("ent.ent_cpfcnpj as cpfCadastro, ent.ent_cpfcnpj as cnpjCadastro, ent.ent_rgie as rgCadastro, ent.ent_rgie as ieCadastro, ");
            buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[modelo.findColumn((String)s)] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850700100");
    }
}

