/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoReceberPagarPlanoConta
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] tipoPlanoConta = new String[]{"Todos", Tipos.tipoPlanoContas("R"), Tipos.tipoPlanoContas("D")};
    private final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    private final String FILTRO_FILIAL_PLANO_CONTA = "filtroFilialPlanoConta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_TIPO_PLANO = "filtroTipoPlanoConta";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String FILTRO_CAMPO_DATA = "filtroData";
    private final String FILTRO_CONTA = "filtroConta";
    private final String[] CAMPOSDATA_LANCAMENTO = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private final String[] CAMPOSDATABANCO_LANCAMENTO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    private final String[] CAMPOSDATA_RECEBERPAGAR = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro"};
    private final String[] CAMPOSDATABANCO_RECEBERPAGAR = new String[]{"rpg_vencimento", "rpg_competencia", "rpg_datahora"};
    public static final int TIPO_RECEBERPAGAR = 0;
    public static final int TIPO_LANCAMENTO = 1;
    private int tipoRelatorio = 0;
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "apropriarPlanoConta", "filialPlanoConta", "nivelPlanoConta", "paiPlanoConta", "totalPlanoConta", "valorSomatorio", "totalPlanoContaComSinal", "valorSomatorioComSinal", "reduzidoPlanoPrimeiroNivel", "descricaoPlanoPrimeiroNivel", "totalPlanoPrimeiroNivel", "totalPlanoPrimeiroNivelComSinal", "contaPlanoPrimeiroNivel", "saldoAnteriorContas", "valorFinalPeriodoContas"});

    public RelatorioAcumuladoReceberPagarPlanoConta(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio Acumulado de Receber/Pagar por Plano de Contas", "Acumulado da movimenta\u00e7\u00e3o nos planos de contas", "relatorios/rel_acumulado_rec_pag_plano_de_contas.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio Acumulado de Lan\u00e7amentos por Plano de Contas", "Acumulado da movimenta\u00e7\u00e3o nos planos de contas", "relatorios/rel_acumulado_lancamento_por_plano_de_contas.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialPlanoConta", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroPlanoConta", "Plano Contas", "planoconta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        if (this.tipoRelatorio == 1) {
            this.adicionaItemFiltro("filtroConta", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        }
        this.adicionaFiltroCombo("filtroData", "Campo Data:", this.tipoRelatorio == 1 ? this.CAMPOSDATA_LANCAMENTO : this.CAMPOSDATA_RECEBERPAGAR, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroTipoPlanoConta", "Tipo Plano:", this.tipoPlanoConta, 0);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioAcumuladoReceberPagarPlanoConta.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block77: {
            String[] origem;
            String[] usuario;
            st = Conexao.getStatement();
            String[] filiais = this.getSelecionadosFiltro("filtroFilialPlanoConta", 0);
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder whereRpg = new StringBuilder();
            StringBuilder whereRpl = new StringBuilder();
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                if (this.tipoRelatorio == 1) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCO_LANCAMENTO[this.getFiltroComboIndice("filtroData")] + " as date) >= '");
                } else {
                    whereRpg.append(" and cast(rpg." + this.CAMPOSDATABANCO_RECEBERPAGAR[this.getFiltroComboIndice("filtroData")] + " as date) >= '");
                }
                whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                whereRpg.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                if (this.tipoRelatorio == 1) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCO_LANCAMENTO[this.getFiltroComboIndice("filtroData")] + " as date) <= '");
                } else {
                    whereRpg.append(" and cast(rpg." + this.CAMPOSDATABANCO_RECEBERPAGAR[this.getFiltroComboIndice("filtroData")] + " as date) <= '");
                }
                whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                whereRpg.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                whereRpl.append(" and lcx.lcx_valortotal >= ");
                whereRpl.append(this.getFiltroTexto("filtroValorInicial"));
                whereRpl.append(" ");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                whereRpl.append(" and lcx.lcx_valortotal <= ");
                whereRpl.append(this.getFiltroTexto("filtroValorFinal"));
                whereRpl.append(" ");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                whereRpg.append(" and (lcx.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    whereRpg.append("'");
                    whereRpg.append(usuario[i]);
                    whereRpg.append("'");
                    if (i >= usuario.length - 1) continue;
                    whereRpg.append(", ");
                }
                whereRpg.append(") OR lcx.usr_codigo IS NULL)");
            }
            if ((origem = this.getSelecionadosFiltro("filtroOrigem", 0)) != null) {
                whereRpl.append(" and lpc.opc_codigo in (");
                for (int i = 0; i < origem.length; ++i) {
                    whereRpl.append("'");
                    whereRpl.append(origem[i]);
                    whereRpl.append("'");
                    if (i >= origem.length - 1) continue;
                    whereRpl.append(", ");
                }
                whereRpl.append(")");
            }
            StringBuilder bufLancto = new StringBuilder();
            String[] contas = this.getSelecionadosFiltro("filtroConta", 0);
            if (this.tipoRelatorio == 1 && contas != null) {
                bufLancto.append(" and lcx.cco_reduzido in (");
                for (int i = 0; i < contas.length; ++i) {
                    bufLancto.append(contas[i]);
                    if (i >= contas.length - 1) continue;
                    bufLancto.append(", ");
                }
                bufLancto.append(")");
            }
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.plc_reduzido as reduzidoPlanoConta, a.plc_descricao as descricaoPlanoConta, a.plc_conta as contaPlanoConta, ");
                buf.append("a.plc_tipo as tipoPlanoConta, a.plc_apropriar as apropriarPlanoConta, a.fil_codigo as filialPlanoConta, ");
                buf.append("a.plc_nivel as nivelPlanoConta, a.plc_pai as paiPlanoConta, a.plc_operacao as operacaoPlanoConta, ");
                if (this.tipoRelatorio == 1) {
                    buf.append("SUM(COALESCE(case when lcx.lcx_tipo = 'C' then lcx.lpl_valor else lcx.lpl_valor * (-1) end)) as totalPlanoConta, ");
                    buf.append("SUM(COALESCE(CASE WHEN a.plc_tipo = 'R' THEN (CASE WHEN lcx.lcx_tipo = 'C' THEN lcx.lpl_valor ELSE lcx.lpl_valor * ( -1) END) ELSE lcx.lpl_valor * ( -1) END)) as totalPlanoContaComSinal, ");
                    buf.append("0 as saldoAnteriorContas, ");
                    buf.append("0 as valorFinalPeriodoContas, ");
                } else {
                    buf.append("SUM(COALESCE(case when rpg.rpg_tipo = '").append("R").append("' then rpg.rpl_valor else rpg.rpl_valor * (-1) end)) as totalPlanoConta, ");
                    buf.append("SUM(COALESCE(case when a.plc_operacao = '").append("S").append("' then rpg.rpl_valor * (-1) else rpg.rpl_valor end)) as totalPlanoContaComSinal, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from planoconta a ");
                if (this.tipoRelatorio == 1) {
                    buf.append("left join (select lpc.*,  lcx.lcx_tipo from lanctocaixaplanoconta lpc, lanctocaixa lcx where lcx.lcx_codigo = lpc.lcx_codigo ");
                    buf.append("and lcx.fil_codigo = lpc.fil_codigo and lcx.est_codigo = lpc.est_codigo ");
                    buf.append("and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRpg.toString() + whereRpl.toString() + bufLancto.toString());
                    buf.append(") as lcx on (a.plc_reduzido = lcx.plc_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                } else {
                    buf.append("left join (select rpl.plc_reduzido, rpl.rpl_valor, rpl.opc_codigo, rpg.* from receberpagarplanoconta rpl, receberpagar rpg where rpl.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("and rpl.fil_codigo = rpg.fil_codigo and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    buf.append(whereRpg.toString().replaceAll("lcx", "rpg").replaceAll("lpl", "rpl"));
                    buf.append(") as rpg on (a.plc_reduzido = rpg.plc_reduzido and a.fil_codigo = rpg.fil_codigo ");
                    buf.append(whereRpl.toString().replaceAll("lcx_valortotal ", "rpl_valor").replaceAll("lcx", "rpg").replaceAll("lpl", "rpl").replaceAll("lpc", "rpg"));
                    buf.append(") ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.plc_nivel) as maiorNivel from planoconta a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                String[] planoconta = this.getSelecionadosFiltro("filtroPlanoConta", 0);
                if (planoconta != null) {
                    int i3;
                    buf.append(" and a.plc_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i4 = 0; i4 < planoconta.length; ++i4) {
                        arrayAux.add(new Integer(planoconta[i4]));
                    }
                    ArrayList<Integer> arrayAcima = this.getPlanosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getPlanosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i3 = 0; i3 < arrayAcima.size(); ++i3) {
                            if (arrayAux.contains(arrayAcima.get(i3))) continue;
                            arrayAux.add(arrayAcima.get(i3));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i3 = 0; i3 < arrayAbaixo.size(); ++i3) {
                            if (arrayAux.contains(arrayAbaixo.get(i3))) continue;
                            arrayAux.add(arrayAbaixo.get(i3));
                        }
                    }
                    for (i3 = 0; i3 < arrayAux.size(); ++i3) {
                        buf.append(arrayAux.get(i3));
                        if (i3 >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCombo("filtroTipoPlanoConta").toString().equals(this.tipoPlanoConta[0])) {
                    String combo = this.getFiltroCombo("filtroTipoPlanoConta").toString();
                    buf.append(" and a.plc_tipo = '");
                    if (combo.equals(this.tipoPlanoConta[1])) {
                        buf.append("R");
                    } else if (combo.equals(this.tipoPlanoConta[2])) {
                        buf.append("D");
                    } else {
                        buf.append("C");
                    }
                    buf.append("'");
                }
                buf.append(" group by a.plc_reduzido, a.plc_descricao, a.plc_conta, ");
                buf.append(" a.plc_tipo, a.plc_apropriar, a.fil_codigo, ");
                buf.append(" a.plc_nivel, a.plc_pai, a.plc_operacao, ");
                for (int i5 = 0; i5 < Constantes.CAMPOS_FILIAL.length; ++i5) {
                    if (i5 > 0) {
                        buf.append(", ");
                    }
                    buf.append(Constantes.CAMPOS_FILIAL[i5]);
                }
                buf.append(" order by a.plc_conta ");
                rs = Conexao.executeQuery(st, buf.toString());
                BigDecimal somatorioAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                BigDecimal somatorioComSinalAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                arrayValoresPlanoConta arrayContas = null;
                if (rs.next()) {
                    maiorNivel = 0;
                    rs.last();
                    int qtdeLinhas = rs.getRow();
                    arrayContas = new arrayValoresPlanoConta(qtdeLinhas);
                    rs.first();
                    do {
                        if (rs.getInt("nivelPlanoConta") <= maiorNivel) continue;
                        maiorNivel = rs.getInt("nivelPlanoConta");
                    } while (rs.next());
                    for (i = maiorNivel; i > 0; --i) {
                        rs.first();
                        do {
                            if (rs.getInt("nivelPlanoConta") != i) continue;
                            arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getFloat("totalPlanoConta"), rs.getFloat("totalPlanoContaComSinal"));
                            try {
                                somatorioComSinalAux = somatorioComSinalAux.add(rs.getBigDecimal("totalPlanoContaComSinal"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (rs.getInt("paiPlanoConta") == 0) continue;
                            arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getInt("reduzidoPlanoConta"));
                        } while (rs.next());
                    }
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (i = 0; i < camposRelatorio.length; ++i) {
                    if (!camposRelatorio[i].equals("reduzidoPlanoConta")) continue;
                    posCampoReduzidoRelatorio = i;
                    break;
                }
                rs.beforeFirst();
                if (rs.next()) {
                    int i6;
                    ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
                    do {
                        Object[] o = new Object[camposRelatorio.length];
                        for (int i7 = 0; i7 < camposRelatorio.length; ++i7) {
                            if (camposRelatorio[i7].equals("tipoPlanoConta")) {
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = Tipos.tipoPlanoContas(rs.getString(camposRelatorio[i7]));
                                continue;
                            }
                            if (camposRelatorio[i7].equals("totalPlanoConta")) {
                                if (arrayContas == null) continue;
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = arrayContas.getValorConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                                continue;
                            }
                            if (camposRelatorio[i7].equals("totalPlanoContaComSinal")) {
                                if (arrayContas == null) continue;
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = arrayContas.getValorContaComSinal(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                                continue;
                            }
                            if (camposRelatorio[i7].equals("valorSomatorio") || camposRelatorio[i7].equals("valorSomatorioComSinal") || camposRelatorio[i7].equals("reduzidoPlanoPrimeiroNivel") || camposRelatorio[i7].equals("contaPlanoPrimeiroNivel") || camposRelatorio[i7].equals("descricaoPlanoPrimeiroNivel") || camposRelatorio[i7].equals("totalPlanoPrimeiroNivel") || camposRelatorio[i7].equals("totalPlanoPrimeiroNivelComSinal")) continue;
                            if (camposRelatorio[i7].equals("saldoAnteriorContas") || camposRelatorio[i7].equals("valorFinalPeriodoContas")) {
                                if (this.tipoRelatorio != 1) continue;
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = rs.getObject(camposRelatorio[i7]);
                                continue;
                            }
                            if (camposRelatorio[i7].equals("tipoLancamento")) {
                                if (rs.getString(camposRelatorio[i7]) != null) {
                                    o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = Tipos.tipoLancamentoCaixa(rs.getString(camposRelatorio[i7]));
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = null;
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarPlanoConta.camposRelatorio[i7])] = rs.getObject(camposRelatorio[i7]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (this.tipoRelatorio == 1) {
                        BigDecimal saldoAnteriorContas = this.getSaldoAnteriorContas(contas, filiais, this.getFiltroData("filtroDataInicial"));
                        BigDecimal valorFinalPeriodoContas = saldoAnteriorContas.add(somatorioComSinalAux);
                        int posSaldoAnteriorContas = modelo.findColumn("saldoAnteriorContas");
                        int posValorFinalPeriodoContas = modelo.findColumn("valorFinalPeriodoContas");
                        for (int i8 = 0; i8 < modelo.getRowCount(); ++i8) {
                            modelo.setValueAt(saldoAnteriorContas, i8, posSaldoAnteriorContas);
                            modelo.setValueAt(valorFinalPeriodoContas, i8, posValorFinalPeriodoContas);
                        }
                    }
                    int posValorSomatorio = modelo.findColumn("valorSomatorio");
                    int posValorSomatorioComSinal = modelo.findColumn("valorSomatorioComSinal");
                    int posReduzidoPlanoPrimeiroNivel = modelo.findColumn("reduzidoPlanoPrimeiroNivel");
                    for (int i9 = 0; i9 < modelo.getRowCount(); ++i9) {
                        modelo.setValueAt(somatorioAux, i9, posValorSomatorio);
                        modelo.setValueAt(somatorioComSinalAux, i9, posValorSomatorioComSinal);
                        modelo.setValueAt(this.getPlanoPrimeiroNivel((Integer)modelo.getValueAt(i9, modelo.findColumn("reduzidoPlanoConta"))), i9, posReduzidoPlanoPrimeiroNivel);
                    }
                    int posNivelPlanoConta = modelo.findColumn("nivelPlanoConta");
                    int posReduzidoPlanoConta = modelo.findColumn("reduzidoPlanoConta");
                    int posReduzidoPlanoContaPrimeiroNivel = modelo.findColumn("reduzidoPlanoPrimeiroNivel");
                    int posTotalPlanoConta = modelo.findColumn("totalPlanoConta");
                    int posDescricaoPlanoConta = modelo.findColumn("descricaoPlanoConta");
                    int posDescricaoPlanoPrimeiroNivel = modelo.findColumn("descricaoPlanoPrimeiroNivel");
                    int posTotalPlanoContaComSinal = modelo.findColumn("totalPlanoContaComSinal");
                    int posTotalPlanoPrimeiroNivelComSinal = modelo.findColumn("totalPlanoPrimeiroNivelComSinal");
                    int posTotalPlanoPrimeiroNivel = modelo.findColumn("totalPlanoPrimeiroNivel");
                    int posContaPlanoPrimeiroNivel = modelo.findColumn("contaPlanoPrimeiroNivel");
                    int posContaPlanoConta = modelo.findColumn("contaPlanoConta");
                    for (i6 = 0; i6 < modelo.getRowCount(); ++i6) {
                        if ((Integer)modelo.getValueAt(i6, posNivelPlanoConta) != 1) continue;
                        modelo.setValueAt(modelo.getValueAt(i6, posReduzidoPlanoConta), i6 + 1, posReduzidoPlanoContaPrimeiroNivel);
                        modelo.setValueAt(modelo.getValueAt(i6, posDescricaoPlanoConta), i6 + 1, posDescricaoPlanoPrimeiroNivel);
                        modelo.setValueAt(modelo.getValueAt(i6, posTotalPlanoConta), i6 + 1, posTotalPlanoPrimeiroNivel);
                        modelo.setValueAt(modelo.getValueAt(i6, posTotalPlanoContaComSinal), i6 + 1, posTotalPlanoPrimeiroNivelComSinal);
                        modelo.setValueAt(modelo.getValueAt(i6, posContaPlanoConta), i6 + 1, posContaPlanoPrimeiroNivel);
                    }
                    for (i6 = 0; i6 < modelo.getRowCount(); ++i6) {
                        if ((Integer)modelo.getValueAt(i6, posNivelPlanoConta) != 1) continue;
                        modelo.removeLine(i6);
                        i6 = 0;
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 1) {
                        buf.append(RelatorioAcumuladoReceberPagarPlanoConta.getModuloAcesso(1));
                    } else {
                        buf.append(RelatorioAcumuladoReceberPagarPlanoConta.getModuloAcesso(0));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i10;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAcumuladoReceberPagarPlanoConta.this.panelCentro.removeAll();
                                RelatorioAcumuladoReceberPagarPlanoConta.this.panelCentro.repaint();
                                RelatorioAcumuladoReceberPagarPlanoConta.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroTipoPlanoConta", this.getFiltroCombo("filtroTipoPlanoConta"));
                        var.put("filtroData", this.getFiltroCombo("filtroData"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i10 = 0; i10 < filiais.length; ++i10) {
                                buf.append(filiais[i10]);
                                if (i10 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilialPlanoConta", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i10 = 0; i10 < usuario.length; ++i10) {
                                buf.append(usuario[i10]);
                                if (i10 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (planoconta != null) {
                            for (i10 = 0; i10 < planoconta.length; ++i10) {
                                buf.append(planoconta[i10]);
                                if (i10 >= planoconta.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroPlanoConta", buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (i10 = 0; i10 < origem.length; ++i10) {
                                buf.append(origem[i10]);
                                if (i10 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroOrigem", buf.toString());
                        buf.delete(0, buf.length());
                        if (contas != null) {
                            for (i10 = 0; i10 < contas.length; ++i10) {
                                buf.append(contas[i10]);
                                if (i10 >= contas.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConta", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block77;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                    this.habilitaBotaoImprimir(true);
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getSaldoAnteriorContas(String[] contasFiltro, String[] filiaisFiltros, String dataInicial) throws SQLException {
        String[] contasArray;
        String contas = contasFiltro != null ? StringUtil.implode(contasFiltro, ",") : null;
        String filiais = filiaisFiltros != null ? StringUtil.implode(filiaisFiltros, ",") : Variaveis.filialPadrao;
        String dataInicio = Funcoes.formataData("yyyy-MM-dd", dataInicial);
        BigDecimal soma = new BigDecimal(0.0);
        StringBuilder sql = new StringBuilder();
        if (Funcoes.textoVazio(contas)) {
            sql.append("select array_agg(cco_reduzido) as codigoContaCorrente from contacorrente where fil_codigo = ").append(filiais);
            Statement st = Conexao.getStatement();
            ResultSet rsContas = Conexao.executeQuery(st, sql);
            if (rsContas.next()) {
                contas = rsContas.getString("codigoContaCorrente").replace("{", "").replace("}", "");
            }
            rsContas.close();
        }
        if ((contasArray = contas.split(",")) != null) {
            for (String conta : contasArray) {
                Statement stSaldo;
                block9: {
                    if (Funcoes.textoVazio(conta)) continue;
                    sql.setLength(0);
                    sql.append(" select sld_saldo as soma from saldocontas ");
                    sql.append(" where sld_data < ").append("'").append(dataInicio).append("' ");
                    sql.append(" and fil_codigo = ").append(filiais);
                    sql.append(" and cco_reduzido = ").append(conta);
                    sql.append(" order by sld_data desc limit 1;");
                    stSaldo = Conexao.getStatement();
                    ResultSet rsSaldo = Conexao.executeQuery(stSaldo, sql);
                    try {
                        Statement stConta;
                        block10: {
                            if (rsSaldo.next()) {
                                soma = soma.add(rsSaldo.getBigDecimal("soma"));
                                break block9;
                            }
                            sql.setLength(0);
                            sql.append(" select cco_dtsldinicial as dataInicial ");
                            sql.append("       ,cco_sldinicial as saldoInicial ");
                            sql.append("   from contacorrente ");
                            sql.append("  where fil_codigo = ").append(filiais);
                            sql.append("    and cco_reduzido = ").append(conta);
                            stConta = Conexao.getStatement();
                            try {
                                ResultSet rsConta = Conexao.executeQuery(stConta, sql);
                                if (!rsConta.next() || new Date(rsConta.getDate("dataInicial").getTime()).compareTo(Funcoes.getData("yyyy-MM-dd", dataInicio)) >= 0) break block10;
                                soma = soma.add(rsConta.getBigDecimal("saldoInicial"));
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(stConta);
                                throw throwable;
                            }
                        }
                        Conexao.fecharStatement(stConta);
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(stSaldo);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(stSaldo);
            }
        }
        return soma;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850803100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850804100");
        }
        return Long.parseLong("0850803100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850803101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850804101");
        }
        return Long.parseLong("0850803101");
    }

    private ArrayList<Integer> getPlanosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_pai ");
            buf.append("   from planoconta ");
            buf.append("  where plc_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_pai") == null || resultado.contains(rs.getInt("plc_pai"))) continue;
                        resultado.add(rs.getInt("plc_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getPlanosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_reduzido ");
            buf.append("   from planoconta ");
            buf.append("  where plc_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_reduzido") == null || resultado.contains(rs.getInt("plc_reduzido"))) continue;
                        resultado.add(rs.getInt("plc_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private Integer getPlanoPrimeiroNivel(Integer plano) {
        Statement st = Conexao.getStatement();
        Integer planoAux = new Integer(plano);
        Integer resultado = null;
        StringBuilder buf = null;
        while (plano != null) {
            buf = new StringBuilder();
            buf.append(" select plc_pai ");
            buf.append("   from planoconta ");
            buf.append("  where plc_reduzido = ").append(plano);
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                plano = null;
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_pai") == null) continue;
                        resultado = new Integer(rs.getInt("plc_pai"));
                        plano = new Integer(rs.getInt("plc_pai"));
                    } while (rs.next());
                    continue;
                }
                plano = null;
            }
            catch (SQLException e) {
                // empty catch block
                break;
            }
        }
        Conexao.fecharStatement(st);
        return resultado == null ? planoAux : resultado;
    }

    public class arrayValoresPlanoConta {
        private Integer[] reduzidoPlanoConta = null;
        private Float[] valorPlanoConta = null;
        private Float[] valorPlanoContaComSinal = null;

        public arrayValoresPlanoConta(Integer tamanho) {
            this.reduzidoPlanoConta = new Integer[tamanho.intValue()];
            this.valorPlanoConta = new Float[tamanho.intValue()];
            this.valorPlanoContaComSinal = new Float[tamanho.intValue()];
        }

        public void setContaValorPosicao(int posicao, int reduzidoPlanoConta, float valorPlanoConta, float valorPlanoContaComSinal) {
            this.reduzidoPlanoConta[posicao] = reduzidoPlanoConta;
            this.valorPlanoConta[posicao] = Float.valueOf(valorPlanoConta);
            this.valorPlanoContaComSinal[posicao] = Float.valueOf(valorPlanoContaComSinal);
        }

        public void setValorConta(int reduzidoPlanoConta, float valorPlanoConta, float valorPlanoContaComSinal) {
            int i;
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || !this.reduzidoPlanoConta[i].equals(reduzidoPlanoConta)) continue;
                this.valorPlanoConta[i] = Float.valueOf(valorPlanoConta);
                this.valorPlanoContaComSinal[i] = Float.valueOf(valorPlanoContaComSinal);
                return;
            }
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] != null) continue;
                this.setContaValorPosicao(i, reduzidoPlanoConta, valorPlanoConta, valorPlanoContaComSinal);
                return;
            }
        }

        public Float getValorConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorContaComSinal(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoContaComSinal[i];
            }
            return new Float(0.0f);
        }

        public void somaValorConta(int reduzidoPlanoConta, int reduzidoFilho) {
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).floatValue() + this.getValorConta(reduzidoFilho).floatValue(), this.getValorContaComSinal(reduzidoPlanoConta).floatValue() + this.getValorContaComSinal(reduzidoFilho).floatValue());
        }

        public void somaValorConta(int reduzidoPlanoConta, float valorAdicionar, float valorAdicionarComSinal) {
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).floatValue() + valorAdicionar, this.getValorContaComSinal(reduzidoPlanoConta).floatValue() + valorAdicionarComSinal);
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoPlanoConta[posicao];
        }

        public Float getValorPosicao(int posicao) {
            return this.valorPlanoConta[posicao];
        }

        public Float getValorComSinalPosicao(int posicao) {
            return this.valorPlanoContaComSinal[posicao];
        }
    }
}

