/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoReceberPagarCentroCusto
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_CENTRO_CUSTO = "filtroCentroCusto";
    private final String FILTRO_FILIAL_CENTRO_CUSTO = "filtroFilialCentroCusto";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String FILTRO_CAMPO_DATA = "filtroData";
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private final String[] CAMPOSDATABANCO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    public static final int TIPO_RECEBERPAGAR = 0;
    public static final int TIPO_LANCAMENTO = 1;
    private int tipoRelatorio = 0;
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoCentroCusto", "descricaoCentroCusto", "contaCentroCusto", "filialCentroCusto", "nivelCentroCusto", "paiCentroCusto", "totalCentroCusto", "totalCentroCustoComSinal", "reduzidoCentroPrimeiroNivel", "descricaoCentroPrimeiroNivel", "totalCentroPrimeiroNivel", "totalCentroPrimeiroNivelComSinal", "contaCentroPrimeiroNivel"});

    public RelatorioAcumuladoReceberPagarCentroCusto(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio Acumulado de Receber/Pagar por Centro de Custo", "Acumulado da movimenta\u00e7\u00e3o nos centros de custo", "relatorios/rel_acumulado_rec_pag_centro-de-custo.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio Acumulado de Lan\u00e7amentos por Centro de Custo", "Acumulado da movimenta\u00e7\u00e3o nos centros de custo", "relatorios/rel_acumulado_lancamento_centro-de-custo.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialCentroCusto", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCentroCusto", "Centro Custo", "centrocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ccu_reduzido", "ccu_conta", "ccu_descricao"}, new String[]{"C\u00f3digo", "Centro de Custo", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        this.adicionaFiltroCombo("filtroData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioAcumuladoReceberPagarCentroCusto.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block55: {
            st = Conexao.getStatement();
            String[] filiais = this.getSelecionadosFiltro("filtroFilialCentroCusto", 0);
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String[] origem;
                String[] usuario;
                StringBuilder whereRpg = new StringBuilder();
                StringBuilder whereRcc = new StringBuilder();
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroData")] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")) + "'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroData")] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")) + "'");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    whereRcc.append(" and lcc.lcc_valor >= " + this.getFiltroTexto("filtroValorInicial") + " ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    whereRcc.append(" and lcc.lcc_valor <= " + this.getFiltroTexto("filtroValorFinal") + " ");
                }
                if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                    whereRpg.append(" and (lcx.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        whereRpg.append("'" + usuario[i] + "'");
                        if (i >= usuario.length - 1) continue;
                        whereRpg.append(", ");
                    }
                    whereRpg.append(") OR lcx.usr_codigo IS NULL)");
                }
                if ((origem = this.getSelecionadosFiltro("filtroOrigem", 0)) != null) {
                    whereRcc.append(" and lcc.opc_codigo in (");
                    for (int i = 0; i < origem.length; ++i) {
                        whereRcc.append("'" + origem[i] + "'");
                        if (i >= origem.length - 1) continue;
                        whereRcc.append(", ");
                    }
                    whereRcc.append(")");
                }
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.ccu_reduzido as reduzidoCentroCusto, a.ccu_descricao as descricaoCentroCusto, a.ccu_conta as contaCentroCusto, ");
                buf.append("a.fil_codigo as filialCentroCusto, a.ccu_nivel as nivelCentroCusto, a.ccu_pai as paiCentroCusto, ");
                if (this.tipoRelatorio == 1) {
                    buf.append("SUM(COALESCE(CASE WHEN lcx.lcx_tipo = 'C' then lcx.lcc_valor else (lcx.lcc_valor * -1) end, 0)) as totalCentroCusto, ");
                    buf.append("SUM(COALESCE(case when a.ccu_operacao = '").append("S").append("' then lcx.lcc_valor * (-1) else lcx.lcc_valor end, 0)) as totalCentroCustoComSinal, ");
                } else {
                    buf.append("SUM(COALESCE(CASE WHEN rpg.rpg_tipo = 'R' then rpg.rcc_valor else (rpg.rcc_valor * -1) end, 0)) as totalCentroCusto, ");
                    buf.append("SUM(COALESCE(case when a.ccu_operacao = '").append("S").append("' then rpg.rcc_valor * (-1) else rpg.rcc_valor end, 0)) as totalCentroCustoComSinal, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from centrocusto a ");
                if (this.tipoRelatorio == 1) {
                    buf.append("left join (select lcc.ccu_reduzido, lcc.lcc_valor, lcx.* from lanctocaixacentrocusto lcc, lanctocaixa lcx where lcc.lcx_codigo = lcx.lcx_codigo ");
                    buf.append("and lcc.fil_codigo = lcx.fil_codigo and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRcc.toString());
                    buf.append(") as lcx on (a.ccu_reduzido = lcx.ccu_reduzido and a.fil_codigo = lcx.fil_codigo ");
                    buf.append(whereRpg.toString());
                    buf.append(") ");
                } else {
                    buf.append("left join (select rcc.ccu_reduzido, rcc.rcc_valor, rcc.opc_codigo, rpg.* from receberpagarcentrocusto rcc, receberpagar rpg where rcc.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("and rcc.fil_codigo = rpg.fil_codigo and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    buf.append(whereRpg.toString().replaceAll("lcx", "rpg").replaceAll("lcc", "rcc"));
                    buf.append(") as rpg on (a.ccu_reduzido = rpg.ccu_reduzido and a.fil_codigo = rpg.fil_codigo ");
                    buf.append(whereRcc.toString().replaceAll("lcx", "rpg").replaceAll("lcc", "rpg"));
                    buf.append(") ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                rs = Conexao.executeQuery(st, "select MAX(a.ccu_nivel) as maiorNivel from centrocusto a");
                rs.next();
                maiorNivel = rs.getInt("maiorNivel");
                String[] centrocusto = this.getSelecionadosFiltro("filtroCentroCusto", 0);
                if (centrocusto != null) {
                    int i;
                    buf.append(" and a.ccu_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i2 = 0; i2 < centrocusto.length; ++i2) {
                        arrayAux.add(new Integer(centrocusto[i2]));
                    }
                    ArrayList<Integer> arrayAcima = this.getCentrosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getCentrosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i = 0; i < arrayAcima.size(); ++i) {
                            if (arrayAux.contains(arrayAcima.get(i))) continue;
                            arrayAux.add(arrayAcima.get(i));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i = 0; i < arrayAbaixo.size(); ++i) {
                            if (arrayAux.contains(arrayAbaixo.get(i))) continue;
                            arrayAux.add(arrayAbaixo.get(i));
                        }
                    }
                    for (i = 0; i < arrayAux.size(); ++i) {
                        buf.append(arrayAux.get(i));
                        if (i >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append(" group by a.ccu_reduzido, a.ccu_descricao, a.ccu_conta, ");
                buf.append(" a.fil_codigo, a.ccu_nivel, a.ccu_pai, ");
                for (int i = 0; i < Constantes.CAMPOS_FILIAL.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(Constantes.CAMPOS_FILIAL[i]);
                }
                buf.append(" order by a.ccu_conta ");
                rs = Conexao.executeQuery(st, buf.toString());
                arrayValoresCentroCusto arrayCentros = null;
                if (rs.next()) {
                    maiorNivel = 0;
                    rs.last();
                    int qtdeLinhas = rs.getRow();
                    arrayCentros = new arrayValoresCentroCusto(qtdeLinhas);
                    rs.first();
                    do {
                        if (rs.getInt("nivelCentroCusto") <= maiorNivel) continue;
                        maiorNivel = rs.getInt("nivelCentroCusto");
                    } while (rs.next());
                    for (int i = maiorNivel; i > 0; --i) {
                        rs.first();
                        do {
                            if (rs.getInt("nivelCentroCusto") != i) continue;
                            arrayCentros.somaValorConta(rs.getInt("reduzidoCentroCusto"), rs.getFloat("totalCentroCusto"), rs.getFloat("totalCentroCustoComSinal"));
                            if (rs.getInt("paiCentroCusto") == 0) continue;
                            arrayCentros.somaValorConta(rs.getInt("paiCentroCusto"), rs.getInt("reduzidoCentroCusto"));
                        } while (rs.next());
                    }
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (int i = 0; i < camposRelatorio.length; ++i) {
                    if (!camposRelatorio[i].equals("reduzidoCentroCusto")) continue;
                    posCampoReduzidoRelatorio = i;
                    break;
                }
                rs.beforeFirst();
                if (rs.next()) {
                    int i;
                    ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
                    do {
                        Object[] o = new Object[camposRelatorio.length];
                        for (int i3 = 0; i3 < camposRelatorio.length; ++i3) {
                            if (camposRelatorio[i3].equals("totalCentroCustoComSinal")) {
                                if (arrayCentros == null) continue;
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarCentroCusto.camposRelatorio[i3])] = arrayCentros.getValorContaComSinal(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                                continue;
                            }
                            if (camposRelatorio[i3].equals("totalCentroCusto")) {
                                if (arrayCentros == null) continue;
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarCentroCusto.camposRelatorio[i3])] = arrayCentros.getValorConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                                continue;
                            }
                            if (camposRelatorio[i3].equals("tipoLancamento")) {
                                if (rs.getString(camposRelatorio[i3]) != null) {
                                    o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarCentroCusto.camposRelatorio[i3])] = Tipos.tipoLancamentoCaixa(rs.getString(camposRelatorio[i3]));
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarCentroCusto.camposRelatorio[i3])] = null;
                                continue;
                            }
                            if (camposRelatorio[i3].equals("reduzidoCentroPrimeiroNivel") || camposRelatorio[i3].equals("contaCentroPrimeiroNivel") || camposRelatorio[i3].equals("descricaoCentroPrimeiroNivel") || camposRelatorio[i3].equals("totalCentroPrimeiroNivel") || camposRelatorio[i3].equals("totalCentroPrimeiroNivelComSinal")) continue;
                            o[modelo.findColumn((String)RelatorioAcumuladoReceberPagarCentroCusto.camposRelatorio[i3])] = rs.getObject(camposRelatorio[i3]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    for (i = 0; i < modelo.getRowCount(); ++i) {
                        modelo.setValueAt(this.getCentroPrimeiroNivel((Integer)modelo.getValueAt(i, modelo.findColumn("reduzidoCentroCusto"))), i, modelo.findColumn("reduzidoCentroPrimeiroNivel"));
                    }
                    for (i = 0; i < modelo.getRowCount(); ++i) {
                        if ((Integer)modelo.getValueAt(i, modelo.findColumn("nivelCentroCusto")) != 1) continue;
                        modelo.setValueAt(modelo.getValueAt(i, modelo.findColumn("reduzidoCentroCusto")), i + 1, modelo.findColumn("reduzidoCentroPrimeiroNivel"));
                        modelo.setValueAt(modelo.getValueAt(i, modelo.findColumn("descricaoCentroCusto")), i + 1, modelo.findColumn("descricaoCentroPrimeiroNivel"));
                        modelo.setValueAt(modelo.getValueAt(i, modelo.findColumn("totalCentroCusto")), i + 1, modelo.findColumn("totalCentroPrimeiroNivel"));
                        modelo.setValueAt(modelo.getValueAt(i, modelo.findColumn("totalCentroCustoComSinal")), i + 1, modelo.findColumn("totalCentroPrimeiroNivelComSinal"));
                        modelo.setValueAt(modelo.getValueAt(i, modelo.findColumn("contaCentroCusto")), i + 1, modelo.findColumn("contaCentroPrimeiroNivel"));
                    }
                    for (i = 0; i < modelo.getRowCount(); ++i) {
                        if ((Integer)modelo.getValueAt(i, modelo.findColumn("nivelCentroCusto")) != 1) continue;
                        modelo.removeLine(i);
                        i = 0;
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 1) {
                        buf.append(RelatorioAcumuladoReceberPagarCentroCusto.getModuloAcesso(1));
                    } else {
                        buf.append(RelatorioAcumuladoReceberPagarCentroCusto.getModuloAcesso(0));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i4;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAcumuladoReceberPagarCentroCusto.this.panelCentro.removeAll();
                                RelatorioAcumuladoReceberPagarCentroCusto.this.panelCentro.repaint();
                                RelatorioAcumuladoReceberPagarCentroCusto.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroData", this.getFiltroCombo("filtroData"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i4 = 0; i4 < filiais.length; ++i4) {
                                buf.append(filiais[i4]);
                                if (i4 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilialCentroCusto", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i4 = 0; i4 < usuario.length; ++i4) {
                                buf.append(usuario[i4]);
                                if (i4 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (centrocusto != null) {
                            for (i4 = 0; i4 < centrocusto.length; ++i4) {
                                buf.append(centrocusto[i4]);
                                if (i4 >= centrocusto.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroCentroCusto", buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (i4 = 0; i4 < origem.length; ++i4) {
                                buf.append(origem[i4]);
                                if (i4 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroOrigem", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block55;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850903100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850904100");
        }
        return Long.parseLong("0850903100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850903101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850904101");
        }
        return Long.parseLong("0850903101");
    }

    private ArrayList<Integer> getCentrosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_pai ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_pai") == null || resultado.contains(rs.getInt("ccu_pai"))) continue;
                        resultado.add(rs.getInt("ccu_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getCentrosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_reduzido ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_reduzido") == null || resultado.contains(rs.getInt("ccu_reduzido"))) continue;
                        resultado.add(rs.getInt("ccu_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private Integer getCentroPrimeiroNivel(Integer centro) {
        Statement st = Conexao.getStatement();
        Integer centroAux = new Integer(centro);
        Integer resultado = null;
        StringBuilder buf = null;
        while (centro != null) {
            buf = new StringBuilder();
            buf.append(" select ccu_pai ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_reduzido = ").append(centro);
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                centro = null;
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_pai") == null) continue;
                        resultado = new Integer(rs.getInt("ccu_pai"));
                        centro = new Integer(rs.getInt("ccu_pai"));
                    } while (rs.next());
                    continue;
                }
                centro = null;
            }
            catch (SQLException e) {
                // empty catch block
                break;
            }
        }
        Conexao.fecharStatement(st);
        return resultado == null ? centroAux : resultado;
    }

    public class arrayValoresCentroCusto {
        private Integer[] reduzidoPlanoConta = null;
        private Float[] valorPlanoConta = null;
        private Float[] valorPlanoContaComSinal = null;

        public arrayValoresCentroCusto(Integer tamanho) {
            this.reduzidoPlanoConta = new Integer[tamanho.intValue()];
            this.valorPlanoConta = new Float[tamanho.intValue()];
            this.valorPlanoContaComSinal = new Float[tamanho.intValue()];
        }

        public void setContaValorPosicao(int posicao, int reduzidoPlanoConta, float valorPlanoConta, float valorPlanoContaComSinal) {
            this.reduzidoPlanoConta[posicao] = reduzidoPlanoConta;
            this.valorPlanoConta[posicao] = Float.valueOf(valorPlanoConta);
            this.valorPlanoContaComSinal[posicao] = Float.valueOf(valorPlanoContaComSinal);
        }

        public void setValorConta(int reduzidoPlanoConta, float valorPlanoConta, float valorPlanoContaComSinal) {
            int i;
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || !this.reduzidoPlanoConta[i].equals(reduzidoPlanoConta)) continue;
                this.valorPlanoConta[i] = Float.valueOf(valorPlanoConta);
                this.valorPlanoContaComSinal[i] = Float.valueOf(valorPlanoContaComSinal);
                return;
            }
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] != null) continue;
                this.setContaValorPosicao(i, reduzidoPlanoConta, valorPlanoConta, valorPlanoContaComSinal);
                return;
            }
        }

        public Float getValorConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorContaComSinal(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoContaComSinal[i];
            }
            return new Float(0.0f);
        }

        public void somaValorConta(int reduzidoPlanoConta, int reduzidoFilho) {
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).floatValue() + this.getValorConta(reduzidoFilho).floatValue(), this.getValorContaComSinal(reduzidoPlanoConta).floatValue() + this.getValorContaComSinal(reduzidoFilho).floatValue());
        }

        public void somaValorConta(int reduzidoPlanoConta, float valorAdicionar, float valorAdicionarComSinal) {
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).floatValue() + valorAdicionar, this.getValorContaComSinal(reduzidoPlanoConta).floatValue() + valorAdicionarComSinal);
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoPlanoConta[posicao];
        }

        public Float getValorPosicao(int posicao) {
            return this.valorPlanoConta[posicao];
        }

        public Float getValorComSinalPosicao(int posicao) {
            return this.valorPlanoContaComSinal[posicao];
        }
    }
}

