/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento.relatoriorequisicoesconferidas;

import jalis.comum.Tipos;
import jalis.laboratorio.relatorios.financeiro.faturamento.relatoriorequisicoesconferidas.RelatorioRequisicoesConferidasDao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.util.ArraysUtil;
import jalis.util.ModeloGridTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public class RelatorioRequisicoesConferidasService {
    private final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "totalTaxaRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "tipoUltimoPagamentoRequisicao", "complementoDestinoRequisicao", "quartoRequisicao", "leitoRequisicao", "situacaoExameRequisicao", "entregueParaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "dataColeta", "dataEntregueExameRequisicao", "dataRecoletaExameRequisicao", "motivoRecoletaExameRequisicao", "dataRepeticaoExameRequisicao", "dataEtiquetaTriagemExameRequisicao", "naoFaturarExameRequisicao", "urgenteExameRequisicao", "dataImpressaoExameRequisicao", "dataFaturaExameRequisicao", "valorTotalExameRequisicao", "valorFaturarExameRequisicao", "valorExame", "valorCHExameExameRequisicaoOriginal", "valorCHExameExameRequisicao", "materialExternoExameRequisicao", "dataEntregaExameRequisicao", "interfaceadoExameRequisicao", "loteReagenteExameRequisicao", "quantidadeReagenteExameRequisicao", "valorCHExameRequisicaoOriginal", "valorCHExameRequisicao", "valorMaterialExameRequisicao", "valorPagoBalcaoExameRequisicao", "dataImpressaoMapaExameRequisicao", "codigoAutorizacaoExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "dataCortesiaExameRequisicao", "serialReagenteExameRequisicao", "autorizarExameRequisicao", "tempoJejumExameRequisicao", "descricaoMaterialInformadoExameRequisicao", "observacaoPrazoCarenciaExameRequisicao,deveGuiaRequisicao", "deveGuiaExameRequisicao", "dataGuiaExameRequisicao", "numeroGuia", "validadeGuia", "avisarPacienteExameRequisicao", "codigosMultiGuias", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino,impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoColeta", "descricaoColeta", "complementoColeta", "cepColeta", "enderecoColeta,foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "corSetor", "codigoUsuarioSetor", "nomeUsuarioSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "observacaoConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "normaConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "numeroEnderecoConvenio", "tipoLogradouroConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroCobrancaConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "percentualAcrescimoConvenio", "obrigaValidadeGuiaConvenio", "proibidoWebConvenio", "diasValidadeGuia", "obrigaGuiaConvenio", "cobrarMateriaisConvenio", "ordemFaturaConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoUsuarioGuiaConferida", "nomeUsuarioGuiaConferida", "codExame", "descricaoExame", "sexoExame", "horaEntradaExame", "horaSaidaExame", "proibidoExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "codigoSituacao", "descricaoSituacao", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "numeroEnderecoPaciente", "emailPaciente", "tipoLogradouroPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "observacaoMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "numeroEnderecoMedico", "tipoLogradouroMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoAmb", "dataConferencia", "usuarioConferencia"});
    private final RelatorioRequisicoesConferidasDao dao = new RelatorioRequisicoesConferidasDao();
    private String[] filiaisSelecionadas;
    private String[] conveniosSelecionados;
    private String[] situacoesSelecionadas;
    private String[] destinosSelecionados;
    private String[] coletasSelecionadas;
    private String[] setoresSelecionados;
    private String[] pacientesSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;
    private int ordemSelecionada;
    private ModeloGridTable modelo;

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        return this.dao.getLayoutRelatorio(codigoModuloAcesso);
    }

    public boolean modeloPreenchido() throws SQLException {
        this.definirFiltrosSelecionadosPeloUsuario();
        this.modelo = new ModeloGridTable(this.campos);
        ResultSet resultadoConsulta = this.dao.recuperarDados();
        if (resultadoConsulta.next()) {
            do {
                this.converterRegistroParaModelo(resultadoConsulta);
            } while (resultadoConsulta.next());
            return true;
        }
        return false;
    }

    private void converterRegistroParaModelo(ResultSet resultadoConsulta) throws SQLException {
        Object[] o = new Object[this.campos.length];
        for (int i = 0; i < this.campos.length; ++i) {
            if (this.campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || this.campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || this.campos[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                o[i] = Tipos.tipoLogradouroDescricao(resultadoConsulta.getString(this.campos[i]));
                continue;
            }
            if (this.campos[i].equals("codigosMultiGuias")) {
                Object[] filhas = this.dao.verificarMultiguias(resultadoConsulta.getString("codigoFilial"), resultadoConsulta.getString("codRequisicao"));
                if (filhas != null) {
                    o[i] = Arrays.toString(filhas);
                    continue;
                }
                o[i] = null;
                continue;
            }
            if (RelatorioUtil.possuiColuna(resultadoConsulta, this.campos[i]) <= -1) continue;
            o[i] = resultadoConsulta.getObject(this.campos[i]);
        }
        this.modelo.addLine(o);
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.dao.setColetasSelecionadas(this.coletasSelecionadas);
        this.dao.setConveniosSelecionados(this.conveniosSelecionados);
        this.dao.setDataFinalInformada(this.dataFinalInformada);
        this.dao.setDataInicialInformada(this.dataInicialInformada);
        this.dao.setDestinosSelecionados(this.destinosSelecionados);
        this.dao.setFiliaisSelecionadas(this.filiaisSelecionadas);
        this.dao.setOrdemSelecionada(this.ordemSelecionada);
        this.dao.setPacientesSelecionados(this.pacientesSelecionados);
        this.dao.setSetoresSelecionados(this.setoresSelecionados);
        this.dao.setSituacoesSelecionadas(this.situacoesSelecionadas);
    }

    public String[] getCampos() {
        return this.campos;
    }

    public ModeloGridTable getModelo() {
        return this.modelo;
    }

    public String[] getFiliaisSelecionadas() {
        return this.filiaisSelecionadas;
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public String[] getConveniosSelecionados() {
        return this.conveniosSelecionados;
    }

    public void setConveniosSelecionados(String[] conveniosSelecionados) {
        this.conveniosSelecionados = conveniosSelecionados;
    }

    public String[] getSituacoesSelecionadas() {
        return this.situacoesSelecionadas;
    }

    public void setSituacoesSelecionadas(String[] situacoesSelecionadas) {
        this.situacoesSelecionadas = situacoesSelecionadas;
    }

    public String[] getDestinosSelecionados() {
        return this.destinosSelecionados;
    }

    public void setDestinosSelecionados(String[] destinosSelecionados) {
        this.destinosSelecionados = destinosSelecionados;
    }

    public String[] getColetasSelecionadas() {
        return this.coletasSelecionadas;
    }

    public void setColetasSelecionadas(String[] coletasSelecionadas) {
        this.coletasSelecionadas = coletasSelecionadas;
    }

    public String[] getSetoresSelecionados() {
        return this.setoresSelecionados;
    }

    public void setSetoresSelecionados(String[] setoresSelecionados) {
        this.setoresSelecionados = setoresSelecionados;
    }

    public String[] getPacientesSelecionados() {
        return this.pacientesSelecionados;
    }

    public void setPacientesSelecionados(String[] pacientesSelecionados) {
        this.pacientesSelecionados = pacientesSelecionados;
    }

    public String getDataInicialInformada() {
        return this.dataInicialInformada;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public String getDataFinalInformada() {
        return this.dataFinalInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }

    public int getOrdemSelecionada() {
        return this.ordemSelecionada;
    }

    public void setOrdemSelecionada(int ordemSelecionada) {
        this.ordemSelecionada = ordemSelecionada;
    }
}

