/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento.relatoriorequisicoesconferidas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RelatorioRequisicoesConferidasDao {
    private String[] filiaisSelecionadas;
    private String[] conveniosSelecionados;
    private String[] situacoesSelecionadas;
    private String[] destinosSelecionados;
    private String[] coletasSelecionadas;
    private String[] setoresSelecionados;
    private String[] pacientesSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;
    private int ordemSelecionada;

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(codigoModuloAcesso);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    public ResultSet recuperarDados() throws SQLException {
        Statement st = Conexao.getStatement();
        ResultSet resultadoConsulta = Conexao.executeQuery(st, this.getSqlRelatorio());
        return resultadoConsulta;
    }

    private String getSqlRelatorio() {
        StringBuilder sqlRelatorio = new StringBuilder();
        sqlRelatorio.append(this.getSqlSelect());
        sqlRelatorio.append(this.getSqlFrom());
        sqlRelatorio.append(this.getSqlWhere());
        sqlRelatorio.append(this.getSqlOrderBy());
        return sqlRelatorio.toString();
    }

    private String getSqlSelect() {
        StringBuilder sqlSelect = new StringBuilder("select ");
        sqlSelect.append("r.req_codigo as codRequisicao, r.req_data as dataRequisicao, r.req_dtfatura as dataFaturaRequisicao, ");
        sqlSelect.append("r.req_urgente as urgenteRequisicao, r.req_dataentregaprev as dataEntregaRequisicao, r.req_dclinicos as dadosClinicosRequisicao, ");
        sqlSelect.append("r.req_notacaixa as notaCaixaRequisicao, r.req_obs as observacaoRequisicao, r.req_totpago as totalPagoRequisicao, ");
        sqlSelect.append("r.req_total as totalRequisicao, r.req_totaltaxa as totalTaxaRequisicao, r.req_horaentregaprev as horaEntregaRequisicao, ");
        sqlSelect.append("r.req_horafatura as horaFaturaRequisicao, r.req_hora as horaRequisicao, r.req_gestante as gestanteRequisicao, ");
        sqlSelect.append("r.req_dum as dumRequisicao, r.req_matricula as matriculaRequisicao, r.req_anomes as anomesIdadeRequisicao, ");
        sqlSelect.append("r.req_idade as idadeRequisicao, r.req_avisarpaciente as avisarPacienteRequisicao, r.req_senhaweb as senhaWebRequisicao, ");
        sqlSelect.append("r.req_titular as titularRequisicao, r.req_altura as alturaRequisicao, r.req_peso as pesoRequisicao, ");
        sqlSelect.append("r.req_vlracrescimo as valorAcrescimoRequisicao, r.req_acrescimo as percentualAcrescimoRequisicao, r.req_vlrdesconto as valorDescontoRequisicao, ");
        sqlSelect.append("r.req_desconto as percentualDescontoRequisicao, r.req_telacoleta as coletadoRequisicao, r.req_datarequisicao as dataAberturaRequisicao, ");
        sqlSelect.append("r.req_neonato as neonatoRequisicao, r.req_validadeguia as validadeGuiaRequisicao, r.req_guia as guiaRequisicao, ");
        sqlSelect.append("r.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, r.req_complementodestino as complementoDestinoRequisicao, r.req_quarto as quartoRequisicao, ");
        sqlSelect.append("r.req_leito as leitoRequisicao, er.exr_situacao as situacaoExameRequisicao, er.exr_entrpara as entregueParaExameRequisicao, ");
        sqlSelect.append("er.exr_dataassina as dataAssinaturaExameRequisicao, er.exr_datadigita as dataDigitacaoExameRequisicao, er.exr_datamaterial as dataColeta, ");
        sqlSelect.append("er.exr_dataentreguerst as dataEntregueExameRequisicao, er.exr_datarecoleta as dataRecoletaExameRequisicao, er.exr_motivorecoleta as motivoRecoletaExameRequisicao, ");
        sqlSelect.append("er.exr_datarepeticao as dataRepeticaoExameRequisicao, er.exr_dataetqtriagem as dataEtiquetaTriagemExameRequisicao, er.exr_naofaturar as naoFaturarExameRequisicao, ");
        sqlSelect.append("coalesce(er.exr_urgente, false) as urgenteExameRequisicao, er.exr_dataimpresso as dataImpressaoExameRequisicao, er.exr_datafatura as dataFaturaExameRequisicao, ");
        sqlSelect.append("calculaprecototalexamerequisicao(r.fil_codigo, r.con_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo, true, false, true, er.exr_vlrchexame, er.exr_vlrch, er.exr_valorporte, er.exr_valorcusto, er.exr_valoruco, er.exr_vlrbalcaoconvenio, er.exr_datafatura IS NOT NULL OR er.usr_codfatura IS NOT NULL, er.exr_vlrmaterial, er.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", er.met_codigo").append(") as valorTotalExameRequisicao, ");
        sqlSelect.append("calculaprecototalexamerequisicao(r.fil_codigo, r.con_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo, false, true, true, er.exr_vlrchexame, er.exr_vlrch, er.exr_valorporte, er.exr_valorcusto, er.exr_valoruco, er.exr_vlrbalcaoconvenio, er.exr_datafatura IS NOT NULL OR er.usr_codfatura IS NOT NULL, er.exr_vlrmaterial, er.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", er.met_codigo").append(") as valorFaturarExameRequisicao, ");
        sqlSelect.append("er.exr_vlrexame as valorExame, er.exr_vlrchexame as valorCHExameExameRequisicaoOriginal, ");
        sqlSelect.append("calculachexamerequisicao( r.fil_codigo, r.con_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo) as valorCHExameExameRequisicao, ");
        sqlSelect.append("er.exr_matexterno as materialExternoExameRequisicao, er.exr_dataentregaprev as dataEntregaExameRequisicao, er.exr_interfaciado as interfaceadoExameRequisicao, ");
        sqlSelect.append("er.exr_lotereag as loteReagenteExameRequisicao, er.exr_quantreag as quantidadeReagenteExameRequisicao, er.exr_vlrch as valorCHExameRequisicaoOriginal, ");
        sqlSelect.append("calculachconvenio(r.fil_codigo, r.con_codigo, r.req_codigo, er.exa_codigo, er.mco_codigo) as valorCHExameRequisicao, ");
        sqlSelect.append("er.exr_vlrmaterial as valorMaterialExameRequisicao, er.exr_vlrbalcaoconvenio as valorPagoBalcaoExameRequisicao, er.exr_datamapa as dataImpressaoMapaExameRequisicao, ");
        sqlSelect.append("er.exr_codautorizacao as codigoAutorizacaoExameRequisicao, er.exr_data as dataInsercaoExameRequisicao, er.exr_obs as observacaoExameRequisicao, ");
        sqlSelect.append("er.exr_datacortesia as dataCortesiaExameRequisicao, er.exr_serialreag as serialReagenteExameRequisicao, er.exr_autorizar as autorizarExameRequisicao, ");
        sqlSelect.append("CASE WHEN er.exr_intervalojejum IS NULL THEN TO_CHAR(er.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(er.exr_intervalojejum, 'HH24:MI') END AS tempoJejumExameRequisicao, ");
        sqlSelect.append("er.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao, er.exr_motivoprazo as observacaoPrazoCarenciaExameRequisicao, r.req_deveguia as deveGuiaRequisicao, ");
        sqlSelect.append("er.exr_deveguia as deveGuiaExameRequisicao, er.exr_dataguia as dataGuiaExameRequisicao, er.exr_guia as numeroGuia, ");
        sqlSelect.append("er.exr_validadeguia as validadeGuia, er.exr_avisarentrega as avisarPacienteExameRequisicao, '' as codigosMultiGuias, ");
        sqlSelect.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, ");
        sqlSelect.append("usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
        sqlSelect.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino, destino.des_impressora as impressoraDestino, ");
        sqlSelect.append("destino.des_naoimprimir as naoImprimirDestino, destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
        sqlSelect.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, destino.des_enviarweb as enviarWebDestino, ");
        sqlSelect.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ciddestino.cid_uf as estadoCidadeDestino, ");
        sqlSelect.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta, coleta.col_complemento as complementoColeta, ");
        sqlSelect.append("coleta.col_cep as cepColeta, coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
        sqlSelect.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, cidcoleta.cid_uf as estadoCidadeColeta, ");
        sqlSelect.append("setor.set_codigo as codigoSetor, setor.set_descricao as descricaoSetor, setor.set_responsavel as responsavelSetor, ");
        sqlSelect.append("setor.set_sigla as siglaSetor, setor.set_cor as corSetor, usrsetor.usr_codigo as codigoUsuarioSetor, ");
        sqlSelect.append("usrsetor.usr_nome as nomeUsuarioSetor, conv.con_codigo as codigoConvenio, conv.con_razao as razaoSocialConvenio, ");
        sqlSelect.append("conv.con_fantasia as fantasiaConvenio, conv.con_cnpjcpf as cnpjConvenio, conv.con_observ as observacaoConvenio, ");
        sqlSelect.append("conv.con_tppgto as tipoPagamentoConvenio, conv.con_fatfmaterial as faturarFaltaMaterialConvenio, conv.con_descexame as habilitarDescontoConvenio, ");
        sqlSelect.append("conv.con_norma as normaConvenio, conv.con_multa as multaConvenio, conv.con_mora as moraConvenio, ");
        sqlSelect.append("conv.con_fatfiliais as faturarFiliaisConvenio, conv.con_nr1via as quantidade1ViaConvenio, conv.con_nrexames as numeroExamesConvenio, ");
        sqlSelect.append("conv.con_viasfatura as viasFaturaConvenio, conv.con_impbloqueto as imprimirBloquetoConvenio, conv.con_nr2via as quantidade2ViaConvenio, ");
        sqlSelect.append("conv.con_tpcalcfatu as tipoCalculoFaturaConvenio, coalesce(conv.con_percpgto, 0) as percentualBalcaoConvenio, ");
        sqlSelect.append("conv.con_cobrexame as cobrarExameBalcaoConvenio, conv.con_inscrest as inscricaoEstadualConvenio, conv.con_titdep as titularDependenteConvenio, ");
        sqlSelect.append("conv.con_maskcart as mascaraCarteiraConvenio, conv.con_contato as contatoConvenio, conv.con_informarmat as obrigaMatriculaConvenio, ");
        sqlSelect.append("conv.con_cep as cepConvenio, conv.con_complemento as complementoConvenio, conv.con_endereco as enderecoConvenio, ");
        sqlSelect.append("conv.con_numeroendereco as numeroEnderecoConvenio, conv.con_tipologradouroendereco as tipoLogradouroConvenio, ");
        sqlSelect.append("conv.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, conv.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
        sqlSelect.append("conv.con_cepcobranca as cepCobrancaConvenio, conv.con_complcobranca as complementoCobrancaConvenio, ");
        sqlSelect.append("conv.con_endcobranca as enderecoCobrancaConvenio, conv.con_fax as faxConvenio, conv.con_fone as foneConvenio, ");
        sqlSelect.append("conv.con_valorfilme as valorFilmeConvenio, conv.con_valorch as valorCHConvenio, conv.con_site as siteConvenio, ");
        sqlSelect.append("conv.con_email2 as email2Convenio, conv.con_email1 as email1Convenio, conv.con_tpcalcch as tipoCalculoCHConvenio, ");
        sqlSelect.append("conv.con_inscmunic as inscricaoMunicipalConvenio, conv.con_bonus as percentualBonusConvenio, conv.con_senhaweb as senhaWebConvenio, ");
        sqlSelect.append("conv.con_acrescimo as percentualAcrescimoConvenio, conv.con_validadeguia as obrigaValidadeGuiaConvenio, conv.con_proibidoweb as proibidoWebConvenio, ");
        sqlSelect.append("conv.con_diasvalidade as diasValidadeGuia, conv.con_codigoguia as obrigaGuiaConvenio, conv.con_cobrmaterial as cobrarMateriaisConvenio, ");
        sqlSelect.append("conv.con_ordemfatura as ordemFaturaConvenio, cid.cid_codigo as codigoCidadeConvenio, cid.cid_nome as descricaoCidadeConvenio, ");
        sqlSelect.append("cid.cid_uf as estadoCidadeConvenio, usr.usr_codigo as codigoUsuarioGuiaConferida, usr.usr_nome as nomeUsuarioGuiaConferida, ");
        sqlSelect.append("er.exa_codigo as codExame, exa.exa_descricao as descricaoExame, exa.exa_sexo as sexoExame, ");
        sqlSelect.append("exa.exa_horaentrada as horaEntradaExame, exa.exa_horasaida as horaSaidaExame, exa.exa_proibido as proibidoExame, ");
        sqlSelect.append("exa.exa_idademax as idadeMaximaExame, exa.exa_idademin as idadeMinimaExame, exa.exa_idademaxtipo as tipoIdadeMaximaExame, ");
        sqlSelect.append("exa.exa_idademintipo as tipoIdadeMinimaExame, exa.exa_proibidoweb as proibidoWebExame, exa.exa_qtdeamostras as quantidadeAmostrasExame, ");
        sqlSelect.append("sit.sit_codigo as codigoSituacao, sit.sit_descricao as descricaoSituacao, pac.pac_codigo as codigoPaciente, ");
        sqlSelect.append("pac.pac_nome as nomePaciente, pac.pac_nomesocial as nomeSocialPaciente, pac.pac_datanasc as dataNascimentoPaciente, ");
        sqlSelect.append("pac.pac_sexo as sexoPaciente, pac.pac_vip as vipPaciente, pac.pac_grpsangue as grupoSanguineoPaciente, ");
        sqlSelect.append("pac.pac_fatorrh as fatorrhPaciente, pac.pac_fatordu as fatorduPaciente, pac.pac_cor as corPaciente, ");
        sqlSelect.append("pac.pac_observ as observacaoPaciente, pac.pac_dadoclinico as dadosClinicosPaciente, pac.pac_peso as pesoPaciente, ");
        sqlSelect.append("pac.pac_altura as alturaPaciente, pac.pac_matricconv as matriculaConvenioPaciente, pac.pac_titularconv as titularConvenioPaciente, ");
        sqlSelect.append("pac.pac_profissao as profissaoPaciente, pac.pac_fumante as fumantePaciente, pac.pac_diabetico as diabeticoPaciente, ");
        sqlSelect.append("pac.pac_rg as rgPaciente, pac.pac_cpf as cpfPaciente, pac.pac_estcivil as estadoCivilPaciente, ");
        sqlSelect.append("pac.pac_numfilho as numeroFilhosPaciente, pac.pac_datahora as dataHoraCadastroPaciente, pac.pac_dum as dumPaciente, ");
        sqlSelect.append("pac.pac_fax as faxPaciente, pac.pac_celular as celularPaciente, pac.pac_fonecomercial as foneComercialPaciente, ");
        sqlSelect.append("pac.pac_fone as fonePaciente, pac.pac_cep as cepPaciente, pac.pac_complemento as complementoPaciente, ");
        sqlSelect.append("pac.pac_endereco as enderecoPaciente, pac.pac_numeroendereco as numeroEnderecoPaciente, pac.pac_email as emailPaciente, ");
        sqlSelect.append("pac.pac_tipologradouroendereco as tipoLogradouroPaciente, pac.pac_anomes as anomesIdadePaciente, ");
        sqlSelect.append("pac.pac_idade as idadePaciente, pac.pac_fonecontato as foneContatoPaciente, pac.pac_nomecontato as contatoPaciente, ");
        sqlSelect.append("pac.pac_mae as maePaciente, pac.pac_pai as paiPaciente, cidpaciente.cid_codigo as codigoCidadePaciente, ");
        sqlSelect.append("cidpaciente.cid_nome as descricaoCidadePaciente, cidpaciente.cid_uf as estadoCidadePaciente, baipaciente.bai_codigo as codigoBairroPaciente, ");
        sqlSelect.append("baipaciente.bai_descricao as descricaoBairroPaciente, med.med_conselho as conselhoMedico, med.med_crm as crmMedico, ");
        sqlSelect.append("med.med_uf as ufMedico, med.med_nome as nomeMedico, med.med_abrev as abreviaturaMedico, ");
        sqlSelect.append("med.med_observ as observacaoMedico, med.med_tipo as tipoMedico, med.med_comissao as comissaoMedico, ");
        sqlSelect.append("med.med_cep as cepMedico, med.med_complemento as complementoMedico, med.med_endereco as enderecoMedico, ");
        sqlSelect.append("med.med_celular as celularMedico, med.med_fax as faxMedico, med.med_numeroendereco as numeroEnderecoMedico, ");
        sqlSelect.append("med.med_tipologradouroendereco as tipoLogradouroMedico, med.med_fone as foneMedico, med.med_email as emailMedico, ");
        sqlSelect.append("med.med_site as siteMedico, med.med_senhaweb as senhaWebMedico, filial.fil_codigo as codigoFilial, ");
        sqlSelect.append("filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, ");
        sqlSelect.append("filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, ");
        sqlSelect.append("filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, ");
        sqlSelect.append("filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, ");
        sqlSelect.append("cidadefilial.cid_uf as estadoCidadeFilial, bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial, ");
        sqlSelect.append("detalhetabela.dtp_codamb as codigoamb, r.req_dataguiaconferida as dataConferencia, r.usr_codguiaconferida as usuarioConferencia ");
        return sqlSelect.toString();
    }

    private String getSqlFrom() {
        StringBuilder sqlFrom = new StringBuilder("from ");
        sqlFrom.append("requisicao r ");
        sqlFrom.append("join examerequisicao er on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
        sqlFrom.append("left join exames exa on er.fil_codigo = exa.fil_codigo and er.exa_codigo = exa.exa_codigo ");
        sqlFrom.append("left join convenios conv on r.fil_codigo = conv.fil_codigo and r.con_codigo = conv.con_codigo ");
        sqlFrom.append("left join medico med on r.fil_codigo = med.fil_codigo and r.med_conselho = med.med_conselho and r.med_crm = med.med_crm and r.med_uf = med.med_uf ");
        sqlFrom.append("left join examesetor es on er.fil_codigo = es.fil_codigo and er.exa_codigo = es.exa_codigo and es.ese_default = true ");
        sqlFrom.append("left join situacao sit on r.fil_codigo = sit.fil_codigo and r.sit_codigo = sit.sit_codigo ");
        sqlFrom.append("left join paciente pac on r.fil_codigo = pac.fil_codigo and r.pac_codigo = pac.pac_codigo ");
        sqlFrom.append("left join cidades cidpaciente on pac.fil_codigo = cidpaciente.fil_codigo and pac.cid_codigo = cidpaciente.cid_codigo ");
        sqlFrom.append("left join bairro baipaciente on cidpaciente.fil_codigo = baipaciente.fil_codigo and pac.bai_codigo = baipaciente.bai_codigo ");
        sqlFrom.append("left join cidades cid on conv.fil_codigo = cid.fil_codigo and conv.cid_codigo = cid.cid_codigo ");
        sqlFrom.append("left join bairro bai on conv.fil_codigo = bai.fil_codigo and conv.bai_codigo = bai.bai_codigo ");
        sqlFrom.append("left join setores setor on es.fil_codigo = setor.fil_codigo and es.set_codigo = setor.set_codigo ");
        sqlFrom.append("left join usuario usr on r.usr_codguiaconferida = usr.usr_codigo ");
        sqlFrom.append("left join usuario usrrequisicao on r.usr_codigo = usrrequisicao.usr_codigo ");
        sqlFrom.append("left join usuario usrabertura on r.usr_codabertura = usrabertura.usr_codigo ");
        sqlFrom.append("left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
        sqlFrom.append("left join destino on r.fil_codigo = destino.fil_codigo and r.des_codigo = destino.des_codigo ");
        sqlFrom.append("left join coletas coleta on r.fil_codigo = coleta.fil_codigo and r.col_codigo = coleta.col_codigo ");
        sqlFrom.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        sqlFrom.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        sqlFrom.append("left join filiais_postocoleta filial on r.fil_codigo = filial.fil_codigo ");
        sqlFrom.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
        sqlFrom.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sqlFrom.append("left join tabelaprecoexames tabelapreco on conv.fil_codigo = tabelapreco.fil_codigo and conv.tpe_codigo = tabelapreco.tpe_codigo ");
        sqlFrom.append("left join detalhetabelapreco detalhetabela on tabelapreco.tpe_codigo = detalhetabela.tpe_codigo and tabelapreco.fil_codigo = detalhetabela.fil_codigo and er.exa_codigo = detalhetabela.exa_codigo and er.mco_codigo = detalhetabela.mco_codigo ");
        return sqlFrom.toString();
    }

    private String getSqlWhere() {
        StringBuilder sqlWhere = new StringBuilder(" where ");
        sqlWhere.append(this.filialIn());
        sqlWhere.append(this.convenioIn());
        sqlWhere.append(this.situacaoIn());
        sqlWhere.append(this.destinoIn());
        sqlWhere.append(this.coletaIn());
        sqlWhere.append(this.setorIn());
        sqlWhere.append(this.pacienteIn());
        sqlWhere.append(this.dataBetween());
        sqlWhere.append(" and r.req_excluida = false and er.exr_excluido = false ");
        sqlWhere.append(" and (r.req_dataguiaconferida is not null or r.usr_codguiaconferida is not null) ");
        return sqlWhere.toString();
    }

    private String filialIn() {
        StringBuilder filialIn = new StringBuilder("r.fil_codigo in(");
        if (this.filiaisSelecionadas == null || this.filiaisSelecionadas.length <= 0) {
            this.filiaisSelecionadas = new String[]{Variaveis.filialPadrao};
        }
        filialIn.append(this.getCondicoesIntegerIn(this.filiaisSelecionadas));
        return filialIn.toString();
    }

    private String convenioIn() {
        StringBuilder convenioIn = new StringBuilder();
        if (this.conveniosSelecionados != null && this.conveniosSelecionados.length > 0) {
            convenioIn.append(" and r.con_codigo in (");
            convenioIn.append(this.getCondicoesIntegerIn(this.conveniosSelecionados));
        }
        return convenioIn.toString();
    }

    private String situacaoIn() {
        StringBuilder situacaoIn = new StringBuilder();
        if (this.situacoesSelecionadas != null && this.situacoesSelecionadas.length > 0) {
            situacaoIn.append(" and r.sit_codigo in (");
            situacaoIn.append(this.getCondicoesIntegerIn(this.situacoesSelecionadas));
        }
        return situacaoIn.toString();
    }

    private String coletaIn() {
        StringBuilder coletaIn = new StringBuilder();
        if (this.coletasSelecionadas != null && this.coletasSelecionadas.length > 0) {
            coletaIn.append(" and r.col_codigo in ('");
            coletaIn.append(this.getCondicoesStringIn(this.coletasSelecionadas));
        }
        return coletaIn.toString();
    }

    private String destinoIn() {
        StringBuilder destinoIn = new StringBuilder();
        if (this.destinosSelecionados != null && this.destinosSelecionados.length > 0) {
            destinoIn.append(" and r.des_codigo in ('");
            destinoIn.append(this.getCondicoesStringIn(this.destinosSelecionados));
        }
        return destinoIn.toString();
    }

    private String setorIn() {
        StringBuilder setorIn = new StringBuilder();
        if (this.setoresSelecionados != null && this.setoresSelecionados.length > 0) {
            setorIn.append(" and es.set_codigo in (");
            setorIn.append(this.getCondicoesIntegerIn(this.setoresSelecionados));
        }
        return setorIn.toString();
    }

    private String pacienteIn() {
        StringBuilder pacienteIn = new StringBuilder();
        if (this.pacientesSelecionados != null && this.pacientesSelecionados.length > 0) {
            pacienteIn.append(" and r.pac_codigo in (");
            pacienteIn.append(this.getCondicoesIntegerIn(this.pacientesSelecionados));
        }
        return pacienteIn.toString();
    }

    private String dataBetween() {
        StringBuilder data = new StringBuilder();
        if (!Funcoes.textoVazio(this.dataInicialInformada) && Funcoes.verificaData(this.dataInicialInformada)) {
            data.append(" and r.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialInformada)).append("'");
        }
        if (!Funcoes.textoVazio(this.dataFinalInformada) && Funcoes.verificaData(this.dataFinalInformada)) {
            data.append(" and r.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalInformada)).append("'");
        }
        return data.toString();
    }

    private String getCondicoesIntegerIn(String[] condicoesInteger) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < condicoesInteger.length; ++i) {
            sb.append(condicoesInteger[i]);
            if (i >= condicoesInteger.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getCondicoesStringIn(String[] condicoesString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < condicoesString.length; ++i) {
            sb.append(condicoesString[i].replaceAll("'", "''").trim());
            sb.append(i < condicoesString.length - 1 ? "','" : "'");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getSqlOrderBy() {
        StringBuilder orderBy = new StringBuilder(" order by ");
        orderBy.append("filial.fil_codigo, ");
        if (this.ordemSelecionada == 0) {
            orderBy.append("r.con_codigo, r.req_codigo, er.exa_codigo ");
        }
        if (this.ordemSelecionada == 1) {
            orderBy.append("conv.con_fantasia, r.req_codigo ");
        }
        if (this.ordemSelecionada == 2) {
            orderBy.append("pac.pac_nome, r.con_codigo, r.req_codigo ");
        }
        return orderBy.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] verificarMultiguias(String codigoFilial, String codigoRequisicao) throws SQLException {
        Integer[] multiguias;
        try (Statement st = Conexao.getStatement();){
            multiguias = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, false);
        }
        return multiguias;
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public void setConveniosSelecionados(String[] conveniosSelecionados) {
        this.conveniosSelecionados = conveniosSelecionados;
    }

    public void setSituacoesSelecionadas(String[] situacoesSelecionadas) {
        this.situacoesSelecionadas = situacoesSelecionadas;
    }

    public void setDestinosSelecionados(String[] destinosSelecionados) {
        this.destinosSelecionados = destinosSelecionados;
    }

    public void setColetasSelecionadas(String[] coletasSelecionadas) {
        this.coletasSelecionadas = coletasSelecionadas;
    }

    public void setSetoresSelecionados(String[] setoresSelecionados) {
        this.setoresSelecionados = setoresSelecionados;
    }

    public void setPacientesSelecionados(String[] pacientesSelecionados) {
        this.pacientesSelecionados = pacientesSelecionados;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }

    public void setOrdemSelecionada(int ordemSelecionada) {
        this.ordemSelecionada = ordemSelecionada;
    }
}

