/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento.relatoriorequisicoesconferidas;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.financeiro.faturamento.relatoriorequisicoesconferidas.RelatorioRequisicoesConferidasService;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesConferidas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String RELATORIO_ICONE = "relatorios/rel_requisicoes_com_guia_conferida.jpg";
    private static final String RELATORIO_DESCRITIVO = "Listagem de requisi\u00e7\u00f5es com guia conferida";
    private static final String RELATORIO_TITULO = "Relat\u00f3rio de requisi\u00e7\u00f5es com guia conferida";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private final String[] ordem = new String[]{"C\u00f3d. Exame", "Conv\u00eanio", "Paciente"};
    private static final long MODULO_ACESSO_CODIGO = Long.parseLong("0870102700");
    private static final long MODULO_CONFIGURAR_CODIGO = Long.parseLong("0870101701");
    private final RelatorioRequisicoesConferidasService service = new RelatorioRequisicoesConferidasService();

    public RelatorioRequisicoesConferidas() {
        this.montaBarraDescricao(RELATORIO_TITULO, RELATORIO_DESCRITIVO, RELATORIO_ICONE);
        this.adicionaRelatorioListener(this);
        this.adicionarFiltros();
        this.adicionarFiltrosAvancados();
        this.adicionarFiltrosPorData();
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioRequisicoesConferidas.getModuloConfigurar());
        this.setModuloAcesso(RelatorioRequisicoesConferidas.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    private void adicionarFiltros() {
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SITUACAO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
    }

    private void adicionarFiltrosAvancados() {
        this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
    }

    private void adicionarFiltrosPorData() {
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
    }

    @Override
    public void imprimirPressionado() {
        try {
            this.definirFiltrosSelecionadosPeloUsuario();
            if (Funcoes.textoVazio(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO))) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.service.modeloPreenchido()) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.gerarRelatorio();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.service.setFiliaisSelecionadas(this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
        this.service.setConveniosSelecionados(this.getSelecionadosFiltro(FILTRO_CONVENIO, 0));
        this.service.setSituacoesSelecionadas(this.getSelecionadosFiltro(FILTRO_SITUACAO, 0));
        this.service.setDestinosSelecionados(this.getSelecionadosFiltro(FILTRO_DESTINO, 0));
        this.service.setColetasSelecionadas(this.getSelecionadosFiltro(FILTRO_COLETA, 0));
        this.service.setSetoresSelecionados(this.getSelecionadosFiltro(FILTRO_SETOR, 0));
        this.service.setPacientesSelecionados(this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0));
        this.service.setDataInicialInformada(this.getFiltroData(FILTRO_DATA_INICIAL));
        this.service.setDataFinalInformada(this.getFiltroData(FILTRO_DATA_FINAL));
        this.service.setOrdemSelecionada(this.getFiltroComboIndice(FILTRO_ORDEM));
    }

    private void gerarRelatorio() throws SQLException {
        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
        gerador.setPai(this.panelCentro);
        gerador.setPreVisualizar(true);
        gerador.setZoomPreVisualizar(0.5f);
        gerador.setAcaoFechar(new Runnable(){

            @Override
            public void run() {
                RelatorioRequisicoesConferidas.this.panelCentro.removeAll();
                RelatorioRequisicoesConferidas.this.panelCentro.repaint();
                RelatorioRequisicoesConferidas.this.habilitaBotaoImprimir(true);
            }
        });
        gerador.executar(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO), (TableModel)this.service.getModelo(), this.adicionarVariaveisAoRelatorio());
        this.panelCentro.revalidate();
    }

    private Map<String, Object> adicionarVariaveisAoRelatorio() {
        HashMap<String, Object> variaveis = new HashMap<String, Object>();
        variaveis.put(FILTRO_FILIAL, this.getValoresSelecionados(this.service.getFiliaisSelecionadas()));
        variaveis.put(FILTRO_CONVENIO, this.getValoresSelecionados(this.service.getConveniosSelecionados()));
        variaveis.put(FILTRO_SITUACAO, this.getValoresSelecionados(this.service.getSituacoesSelecionadas()));
        variaveis.put(FILTRO_DESTINO, this.getValoresSelecionados(this.service.getDestinosSelecionados()));
        variaveis.put(FILTRO_COLETA, this.getValoresSelecionados(this.service.getColetasSelecionadas()));
        variaveis.put(FILTRO_SETOR, this.getValoresSelecionados(this.service.getSetoresSelecionados()));
        variaveis.put(FILTRO_PACIENTE, this.getValoresSelecionados(this.service.getPacientesSelecionados()));
        variaveis.put(FILTRO_DATA_FINAL, this.service.getDataFinalInformada());
        variaveis.put(FILTRO_DATA_INICIAL, this.service.getDataInicialInformada());
        variaveis.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
        return variaveis;
    }

    private String getValoresSelecionados(String[] selecionados) {
        StringBuilder sb = new StringBuilder();
        if (selecionados != null && selecionados.length > 0) {
            for (int i = 0; i < selecionados.length; ++i) {
                sb.append(selecionados[i]);
                if (i >= selecionados.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static long getModuloAcesso() {
        return MODULO_ACESSO_CODIGO;
    }

    public static long getModuloConfigurar() {
        return MODULO_CONFIGURAR_CODIGO;
    }
}

