/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class RelatorioSituacaoFatura
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static String[] ORDEM = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social", "Vencimento"};
    private static final String[] CAMPOSDATA = new String[]{"Emiss\u00e3o", "Vencimento"};
    private static final String[] CAMPOSDATABANCO = new String[]{"a.fat_dtemis", "a.fat_dtvenc"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String FILTRO_EMPRESA = "filtroEmpresa";
    public static final int TIPO_FATURA_CONFERIDA = 1;
    public static final int TIPO_FATURA_PARA_CONFERIR = 2;
    public static final int TIPO_FATURA_CONFERIDA_DETALHADO = 3;
    public static final int TIPO_FATURA_PARA_CONFERIR_DETALHADO = 4;
    public static final int TIPO_FATURA_POR_PACIENTE = 5;
    public static final int TIPO_FATURA_POR_PACIENTE_DETALHADO = 6;
    public static final int TIPO_FATURA_SEM_NF = 7;
    public String[] campos;
    public static String[] camposDetalhado = new String[]{"codigoExame", "descricaoExame", "codigoMaterialColeta", "descricaoMaterialColeta", "abreviaturaMaterialColeta", "valorExame", "valorMaterialExame", "valorTotalExame", "ambExame", "cbhpmExame", "codigoExamePai", "descricaoExamePai", "codigoMaterialColetaPai", "descricaoMaterialColetaPai", "abreviatauraMaterialColetaPai", "codigoRequisicao", "dataFaturaRequisicao", "dataRequisicao", "titularRequisicao", "codigoConvenioRequisicao", "fantasiaConvenioRequisicao", "crmMedicoRequisicao", "ufMedicoRequisicao", "conselhoMedicoRequiscao", "nomeMedicoRequisicao", "quantidadeExameRequisicaoFatura"};
    public static String[] camposUsuario = new String[]{"codigoUsuarioConferencia", "nomeUsuarioConferencia", "dataConferenciaFatura"};
    private int tipoRelatorio = 1;

    public RelatorioSituacaoFatura(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        this.campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "codigoCidadeConvenio", "nomeCidadeConvenio", "estadoCidadeConvenio", "totalMateriaisFatura", "totalExamesFatura", "totalCHFatura", "totalFatura", "codigoFatura", "conferidaFatura", "quantidadeRequisicoesFatura", "quantidadeExamesFatura", "totalAdicionaisFatura", "totalDespesasCobrancaFatura", "codigoUsuario", "nomeUsuario", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "dataVencimentoFatura", "percDescontoFatura", "percAcrescimoFatura", "dataEmissaoFatura", "dataInicialPeriodoFatura", "dataFinalPeriodoFatura", "descontoFatura", "acrescimoFatura"});
        String[] campoEmpresa = new String[]{"codigoEmpresaPaciente", "empresaPaciente"};
        if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas conferidas", "Listagem das faturas conferidas no per\u00edodo", "relatorios/rel_financeiro_faturamento_faturas_conferidas.jpg");
            this.campos = ArraysUtil.concatenar(this.campos, camposUsuario);
        } else if (tipoRelatorio == 3) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas conferidas detalhado", "Listagem das faturas conferidas no per\u00edodo com detalhe dos exames", "relatorios/rel_financeiro_faturamento_faturas_conferidas_detalhado.jpg");
            this.campos = ArraysUtil.concatenar(ArraysUtil.concatenar(this.campos, camposUsuario), camposDetalhado);
        } else if (tipoRelatorio == 4) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas para conferir detalhado", "Listagem das faturas n\u00e3o conferidas no per\u00edodo com detalhe dos exames", "relatorios/rel_financeiro_faturamento_faturas_para_conferir_detalhado.jpg");
            this.campos = ArraysUtil.concatenar(ArraysUtil.concatenar(this.campos, camposUsuario), camposDetalhado);
        } else if (tipoRelatorio == 5) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas por paciente", "Listagem das faturas no per\u00edodo agrupadas por paciente", "relatorios/rel_financeiro_faturamento_faturas_por_paciente.jpg");
            this.campos = ArraysUtil.concatenar(this.campos, camposUsuario);
            this.campos = ArraysUtil.concatenar(this.campos, campoEmpresa);
        } else if (tipoRelatorio == 6) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas por paciente detalhado", "Listagem das faturas no per\u00edodo agrupadas por paciente com detalhe dos exames", "relatorios/rel_financeiro_faturamento_faturas_paciente_detalhado.jpg");
            this.campos = ArraysUtil.concatenar(ArraysUtil.concatenar(this.campos, camposUsuario), camposDetalhado);
            this.campos = ArraysUtil.concatenar(this.campos, campoEmpresa);
        } else if (tipoRelatorio == 7) {
            this.montaBarraDescricao("Relat\u00f3rio de faturas sem nota fiscal", "Listagem das faturas sem nota fiscal", "relatorios/rel_financeiro_faturamento_faturas_sem_nota-fiscal.jpg");
            this.campos = ArraysUtil.concatenar(this.campos, camposUsuario);
        } else {
            this.montaBarraDescricao("Relat\u00f3rio de faturas para conferir", "Listagem das faturas n\u00e3o conferidas no per\u00edodo", "relatorios/rel_financeiro_faturamento_faturas_para_conferir.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        if (tipoRelatorio != 7) {
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
            }
        }
        ORDEM = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social", "Vencimento"};
        if (!this.isFilialTipoAlimento() && this.isTipoRelatorioPorPaciente()) {
            this.adicionaItemFiltro(FILTRO_EMPRESA, "Empresa", "entidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
            if (ORDEM.length < 5) {
                String[] ordemEmpresa = new String[]{"Empresa"};
                ORDEM = ArraysUtil.concatenar(ORDEM, ordemEmpresa);
            }
        }
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATA, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ORDEM, 0);
        this.setModuloConfigurar(RelatorioSituacaoFatura.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioSituacaoFatura.getModuloAcesso(tipoRelatorio));
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.isTipoRelatorioPorPaciente() && (this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) == null || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length <= 0) && this.getSelecionadosFiltro(FILTRO_EMPRESA, 0) == null) {
            Funcoes.mensagem(this, "Paciente ou empresa deve ser selecionado", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] empresa;
            String[] convenio;
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            if (this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length > 0 || this.tipoRelatorio == 2) {
                buf.append(" distinct ");
            }
            buf.append(" count(1) as quantidadeExameRequisicaoFatura, ");
            buf.append("a.fat_totalmateriais as totalMateriaisFatura, ");
            buf.append("a.fat_codigo as codigoFatura, ");
            buf.append("a.fat_dtconferencia is not null as conferidaFatura, ");
            buf.append("a.fat_totalexames as totalExamesFatura, ");
            buf.append("a.fat_totalexamesch as totalCHFatura, ");
            buf.append("(a.fat_totalexames + a.fat_totalmateriais) as totalFatura, ");
            buf.append("a.fat_qtderequisicao as quantidadeRequisicoesFatura, ");
            buf.append("a.fat_qtdeexames as quantidadeExamesFatura, ");
            buf.append("a.fat_adicional as totalAdicionaisFatura, ");
            buf.append("a.fat_despcobranca as totalDespesasCobrancaFatura, ");
            buf.append("a.fat_dtvenc as dataVencimentoFatura, ");
            buf.append("a.fat_dtemis as dataEmissaoFatura, ");
            buf.append("a.fat_dtinicio as dataInicialPeriodoFatura, ");
            buf.append("a.fat_dtfim as dataFinalPeriodoFatura, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("cid.cid_codigo as codigoCidadeConvenio, ");
            buf.append("cid.cid_nome as nomeCidadeConvenio, ");
            buf.append("cid.cid_uf as estadoCidadeConvenio, ");
            buf.append("usr.usr_codigo as codigoUsuario, ");
            buf.append("usr.usr_nome as nomeUsuario, ");
            buf.append("a.fat_percdesconto as percDescontoFatura, ");
            buf.append("a.fat_adicional as acrescimoFatura, ");
            if (this.isTipoRelatorioPorPaciente() || this.tipoRelatorio == 3 || this.tipoRelatorio == 4 || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length > 0) {
                buf.append("p.pac_codigo as codigoPaciente, ");
                buf.append("p.pac_nome as nomePaciente, ");
                buf.append("p.pac_nomesocial as nomeSocialPaciente ");
            } else {
                buf.append("'' as codigoPaciente, ");
                buf.append("'' as nomePaciente, ");
                buf.append("'' as nomeSocialPaciente ");
            }
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 6 || this.tipoRelatorio == 3 || this.tipoRelatorio == 4 || this.tipoRelatorio == 7) {
                buf.append(", usrconf.usr_codigo as codigoUsuarioConferencia, ");
                buf.append("usrconf.usr_nome as nomeUsuarioConferencia, ");
                buf.append("a.fat_dtconferencia as dataConferenciaFatura ");
            }
            if (this.tipoRelatorio == 6 || this.tipoRelatorio == 3 || this.tipoRelatorio == 4) {
                buf.append(", fer.exa_codigo as codigoExame, exm.exa_descricao as descricaoExame, ");
                buf.append("mat.mco_codigo as codigoMaterialColeta, mat.mco_descricao as descricaoMaterialColeta, mat.mco_abreviatura as abreviaturaMaterialColeta, ");
                buf.append("fer.fer_total as valorExame, fer.fer_totalmateriais as totalvalorMaterialExame, fer.fer_total + fer.fer_totalmateriais as valorTotalExame, ");
                buf.append("'' as ambExame, '' as cbhpmExame, ");
                buf.append("fer.exa_codfilho as codigoExamePai, exmpai.exa_descricao as descricaoExamePai, ");
                buf.append("matpai.mco_codigo as codigoMaterialColetaPai, matpai.mco_descricao as descricaoMaterialColetaPai, matpai.mco_abreviatura as abreviaturaMaterialColetaPai, ");
                buf.append("r.req_codigo as codigoRequisicao, r.req_dtfatura as dataFaturaRequisicao, r.req_data as dataRequisicao, r.req_titular as titularRequisicao, ");
                buf.append("conr.con_codigo as codigoConvenioRequisicao, conr.con_fantasia as fantasiaConvenioRequisicao, ");
                buf.append("med.med_crm as crmMedicoRequisicao, med.med_uf as ufMedicoRequisicao, med.med_conselho as conselhoMedicoRequiscao, med.med_nome as nomeMedicoRequisicao ");
            }
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            if (this.isTipoRelatorioPorPaciente()) {
                buf.append(" ,entidadepaciente.ent_codigo as codigoempresapaciente, entidadepaciente.ent_razaosocial as empresapaciente, upper(entidadepaciente.ent_razaosocial) ");
            }
            buf.append("from fatura a  ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            buf.append("left join cidades cid on d.fil_codigo = cid.fil_codigo and d.cid_codigo = cid.cid_codigo ");
            buf.append("left join usuario usr on a.usr_codigo = usr.usr_codigo ");
            buf.append("left join usuario usrconf on a.usr_codconferencia = usrconf.usr_codigo ");
            if (this.isTipoRelatorioPorPaciente() || this.tipoRelatorio == 3 || this.tipoRelatorio == 4 || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length > 0 || this.tipoRelatorio == 7) {
                buf.append("left join faturarequisicao f on a.fil_codigo = f.fil_codigo and a.fat_codigo = f.fat_codigo ");
                buf.append("left join requisicao r on f.fil_kodigo = r.fil_codigo and f.req_codigo = r.req_codigo ");
                buf.append("left join paciente p on r.fil_codigo = p.fil_codigo and r.pac_codigo = p.pac_codigo ");
            }
            if (this.tipoRelatorio == 6 || this.tipoRelatorio == 3 || this.tipoRelatorio == 4) {
                buf.append("left join faturaexamerequisicao fer on f.fil_codigo = fer.fil_codigo and f.fat_codigo = fer.fat_codigo and f.fil_kodigo = fer.fil_kodigo and f.req_codigo = fer.req_codigo ");
                buf.append("left join exames exm on fer.fil_kodigo = exm.fil_codigo and fer.exa_codigo = exm.exa_codigo ");
                buf.append("left join exames exmpai on fer.fil_kodigo = exmpai.fil_codigo and fer.exa_codfilho = exmpai.exa_codigo ");
                buf.append("left join materialcoleta mat on fer.fil_kodigo = mat.fil_codigo and fer.mco_codigo = mat.mco_codigo ");
                buf.append("left join materialcoleta matpai on fer.fil_kodigo = matpai.fil_codigo and fer.mco_codfilho = matpai.mco_codigo ");
                buf.append("left join convenios conr on r.fil_codigo = conr.fil_codigo and r.con_codigo = conr.con_codigo ");
                buf.append("left join medico med on r.fil_codigo = med.fil_codigo and r.med_crm = med.med_crm and r.med_uf = med.med_uf and r.med_conselho = med.med_conselho ");
            }
            if (this.isTipoRelatorioPorPaciente()) {
                buf.append("left join entidade entidadepaciente on p.fil_codigo = entidadepaciente.fil_codigo and p.ent_codempresa = entidadepaciente.ent_codigo ");
            }
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            bufWhere.append(" and a.fat_datacancelamento is null ");
            if (this.tipoRelatorio != 5 && this.tipoRelatorio != 6 && this.tipoRelatorio != 7) {
                if (this.tipoRelatorio == 1 || this.tipoRelatorio == 3) {
                    bufWhere.append(" and a.fat_dtconferencia is not null ");
                } else {
                    bufWhere.append(" and a.fat_dtconferencia is null ");
                }
            }
            if (this.tipoRelatorio == 7) {
                bufWhere.append(" and (a.fil_codigo, a.fat_codigo) NOT IN ");
                bufWhere.append("        (select fat2.fil_codigo, ");
                bufWhere.append("                fat2.fat_codigo ");
                bufWhere.append("           from fatura fat2 ");
                bufWhere.append("           join faturanotafiscal fnf on fnf.fil_codigo = fat2.fil_codigo and fnf.fat_codigo = fat2.fat_codigo ");
                bufWhere.append("           join notafiscal nfi on nfi.fil_codigo = fnf.fil_codigo and nfi.nfi_codigo = fnf.nfi_codigo ");
                bufWhere.append("            and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                bufWhere.append("              or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
                bufWhere.append("          where fat2.fil_codigo = a.fil_codigo ");
                bufWhere.append("        ) ");
            }
            String[] paciente = null;
            if (this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length > 0 && (paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0)) != null) {
                bufWhere.append(" and r.pac_codigo in (");
                for (int i = 0; i < paciente.length; ++i) {
                    bufWhere.append(paciente[i]);
                    if (i >= paciente.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0)) != null) {
                bufWhere.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((empresa = this.getSelecionadosFiltro(FILTRO_EMPRESA, 0)) != null) {
                bufWhere.append(" and p.ent_codempresa in (");
                for (int i = 0; i < empresa.length; ++i) {
                    bufWhere.append(empresa[i]);
                    if (i >= empresa.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                bufWhere.append(" and ").append(CAMPOSDATABANCO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)]).append(" >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                bufWhere.append(" and ").append(CAMPOSDATABANCO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)]).append(" <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by totalMateriaisFatura, ");
            buf.append("          codigoFatura, ");
            buf.append("          conferidaFatura, ");
            buf.append("          totalExamesFatura, ");
            buf.append("          totalCHFatura, ");
            buf.append("\t\t \t\t\ttotalFatura, ");
            buf.append("          quantidadeRequisicoesFatura, ");
            buf.append("          quantidadeExamesFatura, ");
            buf.append("          totalAdicionaisFatura, ");
            buf.append("          totalDespesasCobrancaFatura, ");
            buf.append("          dataVencimentoFatura, ");
            buf.append("          dataEmissaoFatura, ");
            buf.append("          fantasiaConvenio, ");
            buf.append("          codigoConvenio, ");
            buf.append("          razaoSocialConvenio, ");
            buf.append("          codigoCidadeConvenio, ");
            buf.append("          nomeCidadeConvenio, ");
            buf.append("          estadoCidadeConvenio, ");
            buf.append("          codigoUsuario, ");
            buf.append("          nomeUsuario, ");
            buf.append("          codigoPaciente, ");
            buf.append("          nomePaciente, ");
            buf.append("          nomeSocialPaciente, ");
            buf.append("\t\t\t\t  dataInicialPeriodoFatura, ");
            buf.append("\t\t\t\t  dataFinalPeriodoFatura, ");
            buf.append("          percDescontoFatura, ");
            buf.append("          acrescimoFatura, ");
            if (this.tipoRelatorio != 2 && this.tipoRelatorio != 5) {
                buf.append("          codigoUsuarioConferencia, ");
                buf.append("          nomeUsuarioConferencia, ");
                buf.append("          dataConferenciaFatura, ");
                if (this.tipoRelatorio != 1 && this.tipoRelatorio != 7) {
                    buf.append("          codigoExame, ");
                    buf.append("          descricaoExame, ");
                    buf.append("          codigoMaterialColeta, ");
                    buf.append("          descricaoMaterialColeta, ");
                    buf.append("          abreviaturaMaterialColeta, ");
                    buf.append("          valorExame, ");
                    buf.append("          totalvalorMaterialExame, ");
                    buf.append("          valorTotalExame, ");
                    buf.append("          ambExame, ");
                    buf.append("          cbhpmExame, ");
                    buf.append("          codigoExamePai, ");
                    buf.append("          descricaoExamePai, ");
                    buf.append("          codigoMaterialColetaPai, ");
                    buf.append("          descricaoMaterialColetaPai, ");
                    buf.append("          abreviaturaMaterialColetaPai, ");
                    buf.append("          codigoRequisicao, ");
                    buf.append("          dataFaturaRequisicao, ");
                    buf.append("          dataRequisicao, ");
                    buf.append("          titularRequisicao, ");
                    buf.append("          codigoConvenioRequisicao, ");
                    buf.append("          fantasiaConvenioRequisicao, ");
                    buf.append("          crmMedicoRequisicao, ");
                    buf.append("          ufMedicoRequisicao, ");
                    buf.append("          conselhoMedicoRequiscao, ");
                    buf.append("          nomeMedicoRequisicao, ");
                }
            }
            buf.append(" codigoFilial, descricaoFilial, cnpjFilial, enderecoFilial, complementoFilial, cepFilial, foneFilial, faxFilial, ");
            buf.append(" razaoSocialFilial, CNESFilial, codigoCidadeFilial, descricaoCidadeFilial, estadoCidadeFilial,codigoBairroFilial, ");
            buf.append(" descricaoBairroFilial ");
            if (this.isTipoRelatorioPorPaciente()) {
                buf.append(" ,entidadepaciente.ent_razaosocial,  entidadepaciente.ent_codigo ");
            }
            buf.append(" order by ");
            if (this.tipoRelatorio == 2) {
                buf.append(" a.fat_codigo, ");
            }
            if (this.tipoRelatorio == 3 || this.tipoRelatorio == 4) {
                buf.append(" a.fat_codigo, p.pac_codigo, r.req_codigo, fer.exa_codigo, ");
            }
            if (!(ORDEM.length >= 5 && this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[4]) || this.tipoRelatorio != 6 || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) == null || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length <= 0)) {
                buf.append(" p.pac_codigo, a.fat_codigo, r.req_codigo, exm.exa_descricao, ");
            }
            if (!(ORDEM.length >= 5 && this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[4]) || this.tipoRelatorio != 5 && this.tipoRelatorio != 7 || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) == null || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length <= 0)) {
                buf.append(" p.pac_codigo, a.fat_codigo, ");
            }
            if (this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[1])) {
                buf.append("d.con_fantasia ");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[2])) {
                buf.append("d.con_razao ");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[3])) {
                buf.append(" a.fat_dtvenc ");
            } else if (!this.isFilialTipoAlimento() && this.isTipoRelatorioPorPaciente() && this.getFiltroCombo(FILTRO_ORDEM).equals(ORDEM[4])) {
                buf.append(" upper(entidadepaciente.ent_razaosocial)  ");
            } else {
                buf.append("a.fat_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equalsIgnoreCase("descontoFatura")) {
                            BigDecimal descontoFatura = rs.getBigDecimal("totalExamesFatura").add(rs.getBigDecimal("totalMateriaisFatura"));
                            descontoFatura = descontoFatura.multiply(rs.getBigDecimal("percDescontoFatura")).divide(new BigDecimal(100));
                            descontoFatura = descontoFatura.setScale(2, RoundingMode.HALF_UP);
                            o[i] = descontoFatura;
                            continue;
                        }
                        if (this.tipoRelatorio == 7 && this.campos[i].equalsIgnoreCase("percAcrescimoFatura")) {
                            BigDecimal total = rs.getBigDecimal("totalExamesFatura").add(rs.getBigDecimal("totalMateriaisFatura"));
                            BigDecimal percAcrescimoFatura = rs.getBigDecimal("acrescimoFatura");
                            percAcrescimoFatura = total.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : percAcrescimoFatura.multiply(new BigDecimal(100)).divide(total, 2, RoundingMode.HALF_UP);
                            percAcrescimoFatura = percAcrescimoFatura.setScale(2, RoundingMode.HALF_UP);
                            o[i] = percAcrescimoFatura;
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, this.campos[i]) <= -1) continue;
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) != null && this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioSituacaoFatura.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioSituacaoFatura.this.panelCentro.removeAll();
                            RelatorioSituacaoFatura.this.panelCentro.repaint();
                            RelatorioSituacaoFatura.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_CAMPO_DATA, CAMPOSDATA[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)]);
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (paciente != null) {
                        for (i = 0; i < paciente.length; ++i) {
                            buf.append(paciente[i]);
                            if (i >= paciente.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_PACIENTE, buf.toString());
                    Relatorio relatorio = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    relatorio.setConfiguracao(rs.getString("rel_xml"));
                    if (!(this.tipoRelatorio != 1 && this.tipoRelatorio != 2 && this.tipoRelatorio != 7 || this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0) != null && this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0).length > 0)) {
                        relatorio.removerBandaCabecalhoGrupo("GrupoPaciente");
                    }
                    gerador.executar(relatorio);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioSituacaoFatura (233)");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100800");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0870101000");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0870101100");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0870101200");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0870101300");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0870101400");
        }
        return Long.parseLong("0870100900");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100801");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0870101001");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0870101101");
        }
        if (tipoRelatorio == 5) {
            return Long.parseLong("0870101201");
        }
        if (tipoRelatorio == 6) {
            return Long.parseLong("0870101301");
        }
        if (tipoRelatorio == 7) {
            return Long.parseLong("0870101401");
        }
        return Long.parseLong("0870100901");
    }

    private boolean isFilialTipoAlimento() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    private boolean isTipoRelatorioPorPaciente() {
        return this.tipoRelatorio == 5 || this.tipoRelatorio == 6;
    }
}

