/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.postgresql.util.PGInterval;

public class RelatorioRequisicoesFaturamento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_A_FATURAR = 0;
    public static final int TIPO_NAO_FATURAR = 1;
    private static final String FILTRO_QTD_REQUISICOES = "filtroQtdRequisicoes";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_EXAME = "filtroExame";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_DEVE_GUIA = "deveGuia";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SITUACAO_REQUISICAO = "filtroSituacaoRequisicao";
    private static final String FILTRO_SITUACAO_EXAME = "filtroSituacaoExame";
    private static final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String FILTRO_DATAS_DIFERENCIADAS = "filtroDatasDiferenciadas";
    private static final String FILTRO_EMPRESAS = "filtroEmpresas";
    private final String[] CAMPOS_ORDEM_BANCO = new String[]{"filial.fil_codigo, a.req_codigo, convenio.con_codigo", "filial.fil_codigo, a.req_codigo , a.req_data, a.req_hora", "upper(paciente.pac_nome), filial.fil_codigo, a.req_codigo, convenio.con_codigo", "convenio.con_fantasia, filial.fil_codigo, a.req_codigo", "medico.med_nome, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "filial.fil_codigo, a.est_codigo, a.req_codigo", "upper(a.usr_codigo), filial.fil_codigo, a.req_codigo", "setor.set_codigo, filial.fil_codigo, a.req_codigo", "filial.fil_codigo, a.req_codigo", "a.est_codigo, upper(a.usr_codigo), filial.fil_codigo, a.req_codigo", "paciente.pac_codigo, filial.fil_codigo, a.req_codigo", "filial.fil_codigo, a.req_codigo", "medico.med_crm, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "a.req_dtfatura, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "a.req_data, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "a.req_data, b.exr_guia, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "a.req_guia, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "a.req_matricula, filial.fil_codigo, a.req_codigo, convenio.con_codigo", "upper(paciente.pac_nome), a.req_codigo", " filial.fil_codigo, to_ascii(upper(ep.ent_razaosocial)), a.req_codigo "};
    private String[] CAMPOS_ORDEM = new String[]{"C\u00f3d. Req.", "Data + Hora", "Nome Pac.", "Conv\u00eanio", "Nome M\u00e9d.", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Setor", "Fil. + Req.", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod. Paciente", "Req. + Adi\u00e7\u00e3o", "CRM M\u00e9dico", "Data Fatura", "Data Req.", "Dt. Req. + Guia Exame", "Guia Req.", "Matr\u00edcula", "Pac. + Adi\u00e7\u00e3o"};
    private final String[] CAMPOS_DATA_BANCO = new String[]{"a.req_dtfatura", "a.req_data"};
    private final String[] CAMPOS_DATA = new String[]{"Dt. Fatura", "Dt. Requisi\u00e7\u00e3o"};
    private final String[] CAMPOS_HORA_BANCO = new String[]{"a.req_horafatura", "a.req_hora"};
    private final String[] SITUACOES_EXAME_BANCO = new String[]{null, "T", "A", "C", "E", "F", "I", "L", "R", "O", "P", ""};
    private final String[] SITUACOES_EXAME = new String[]{Tipos.tipoSituacaoExame(null), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("P"), "Todas"};
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"guiaExameRequisicao", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "dataRecebeuGuiaRequisicao", "dataGuiaConferidaRequisicao", "dataRecebimentoProdutoRequisicao", "validadeCarteiraRequisicao", "validadeGuiaRepasseRequisicao", "validadeCarteiraRepasseRequisicao", "dataRecebeuGuiaRepasseRequisicao", "situacaoExameRequisicao", "entregueParaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "dataColetaExameRequisicao", "dataEntregueExameRequisicao", "dataImpressaoExameRequisicao", "dataFaturaExameRequisicao", "valorTotalExameRequisicao", "prontuarioRequisicao", "valorFaturarExameRequisicao", "complementoDestinoRequisicao", "motivoRecoletaExameRequisicao", "justificativaMotivoRecoleta", "descricaomotivorecoleta", "codigomotivorecoleta", "dataRecoletaExameRequisicao", "codigoUsuarioRecoleta", "nomeUsuarioRecoleta", "dataRepeticaoExameRequisicao", "codigoUsuarioRepeticao", "nomeUsuarioRepeticao", "valorExameExameRequisicao", "valorCHExameExameRequisicao", "materialExternoExameRequisicao", "valorCHExameTabelaPreco", "percentualCBHPMExameTabelaPreco", "porteCBHPMExameTabelaPreco", "codigoAMBExameTabelaPreco", "dataEntregaExameRequisicao", "interfaceadoExameRequisicao", "loteReagenteExameRequisicao", "tipoUltimoPagamentoRequisicao", "observacaoPrazoCarenciaExameRequisicao", "quantidadeReagenteExameRequisicao", "valorCHExameRequisicao", "valorMaterialExameRequisicao", "valorPagoBalcaoExameRequisicao", "dataImpressaoMapaExameRequisicao", "codigoAutorizacaoExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "dataCortesiaExameRequisicao", "serialReagenteExameRequisicao", "autorizarExameRequisicao", "tempoJejumExameRequisicao", "descricaoMaterialInformadoExameRequisicao", "urgenteExameRequisicao", "dataEtiquetaTriagemExameRequisicao", "naoFaturarExameRequisicao", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigosMultiGuias", "codigoPaciente", "dataTriagemExameRequisicao", "dataEtqColetaExameRequisicao", "tempoDiureseExameRequisicao", "dataLoteExternoExameRequisicao", "dataMaterialSetorExameRequisicao", "dataExcluidoExameRequisicao", "dataGuiaExameRequisicao", "validadeGuiaExameRequisicao", "dataFaturaRepasseExameRequisicao", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "corSetor", "codigoUsuarioSetor", "nomeUsuarioSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoUsuarioAssina", "nomeUsuarioAssina", "codigoUsuarioDigitador", "nomeUsuarioDigitador", "codigoUsuarioMaterial", "nomeUsuarioMaterial", "codigoUsuarioFatura", "nomeUsuarioFatura", "codigoUsuarioEntrega", "nomeUsuarioEntrega", "codigoUsuarioImpressao", "nomeUsuarioImpressao", "codigoUsuarioExame", "nomeUsuarioExame", "codigoUsuarioMapa", "nomeUsuarioMapa", "codigoUsuarioCortesia", "nomeUsuarioCortesia", "codigoExame", "descricaoExame", "sexoExame", "horaEntradaExame", "horaSaidaExame", "textoFiltroExame", "proibidoExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "padraoExame", "ordemExame", "paginaExame", "codigoCBHPMExame", "codigoAMBExame", "solicitarJejumExame", "solicitarTempoDiureseExame", "solicitarMedicamentoExame", "marcarExternoExame", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoPrazoEntrega", "descricaoPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "rotinaPrazoEntrega", "codigoMetodologia", "descricaoMetodologia", "solicitarDUMExame", "codigoEstacao", "descricaoEstacao", "medicamentosRequisicao", "avisarPacienteExameRequisicao", "valorCHExameExameRequisicaoOriginal", "valorCHExameRequisicaoOriginal", "codigoFilialCodigoRequisicao", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoResponsavelRequisicao", "numeroEnderecoMedico", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroResponsavelRequisicao", "tipoLogradouroMedico", "codigoEmpresaRequisicao", "descricaoEmpresaRequisicao", "generoPaciente", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao_", "cargoResponsavelRequisicao_", "foneResponsavelRequisicao_", "emailResponsavelRequisicao_", "nomeResponsavelRequisicao", "cargoResponsavelRequisicao", "foneResponsavelRequisicao", "emailResponsavelRequisicao", "razaoSocialResponsavelRequisicao", "enderecoResponsavelRequisicao", "complementoResponsavelRequisicao", "cepResponsavelRequisicao", "cpfCnpjResponsavelRequisicao", "descricaoCidadeResponsavelRequisicao", "estadoCidadeResponsavelRequisicao", "descricaoBairroResponsavelRequisicao", "descricaoEmbalagemProdutoRequisicao", "dataColetaProdutoRequisicao", "horaColetaProdutoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "motivoExclusao", "codigoOrcamento", "dataHoraOrcamento", "observacaoOrcamento", "validadeOrcamento", "solicitanteOrcamento", "contatoOrcamento", "foneOrcamento", "emailOrcamento", "fonecontatoOrcamento", "proprietarioOrcamento", "codigoUsuarioOrcamento", "nomeUsuarioOrcamento", "tempoTotalAteColetaExame", "tempoTotalAteDigitacaoExame", "tempoTotalAteConferenciaExame", "tempoTotalAteImpressaoExame", "tempoTotalAteEntregaExame", "totalTaxaRequisicao"});
    private int tipoRelatorio = -1;

    public RelatorioRequisicoesFaturamento(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para faturar", "Listagem das requisi\u00e7\u00f5es para faturamento", "relatorios/rel_requisicao_faturar.jpg");
        } else if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es para n\u00e3o faturar", "Listagem das requisi\u00e7\u00f5es com os exames marcados para n\u00e3o faturar", "relatorios/rel_requisicao_nao_faturar.jpg");
        }
        this.adicionaRelatorioListener(this);
        if (tipoRelatorio == 0) {
            this.CAMPOS_ORDEM = new String[]{"C\u00f3d. Req.", "Data + Hora", "Nome Pac.", "Conv\u00eanio", "Nome M\u00e9d.", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Setor", "Fil. + Req.", "Esta\u00e7\u00e3o + Usu\u00e1rio", "Cod. Paciente", "Req. + Adi\u00e7\u00e3o", "CRM M\u00e9dico", "Data Fatura", "Data Req.", "Dt. Req. + Guia Exame", "Guia Req.", "Matr\u00edcula", "Pac. + Adi\u00e7\u00e3o", "Empresa"};
        }
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Cons.", "C\u00f3digo", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
        }
        this.adicionaItemFiltro(FILTRO_SITUACAO_REQUISICAO, "Situa\u00e7\u00e3o.Req", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (tipoRelatorio == 0) {
            this.adicionaItemFiltro(FILTRO_EMPRESAS, "Empresa", "entidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        }
        this.adicionaFiltroCombo(FILTRO_SITUACAO_EXAME, "Situa\u00e7\u00e3o.Exa:", this.SITUACOES_EXAME, 0);
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data", this.CAMPOS_DATA, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.CAMPOS_ORDEM, 0);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_DEVE_GUIA, "Sem pedido/guia", false);
        this.adicionaNomeVariavel(FILTRO_QTD_REQUISICOES);
        final int tipo = tipoRelatorio;
        if (tipoRelatorio == 0) {
            JCheckBox checkApenasDatasDiferenciadas = null;
            checkApenasDatasDiferenciadas = this.adicionaRetornaFiltroCheck(FILTRO_DATAS_DIFERENCIADAS, "Apenas datas diferenciadas", false);
            if (checkApenasDatasDiferenciadas != null) {
                checkApenasDatasDiferenciadas.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        RelatorioRequisicoesFaturamento.this.setModuloAcesso(RelatorioRequisicoesFaturamento.getModuloAcesso(tipo, RelatorioRequisicoesFaturamento.this.getFiltroCheck(RelatorioRequisicoesFaturamento.FILTRO_DATAS_DIFERENCIADAS)));
                    }
                });
            }
        }
        this.setModuloConfigurar(RelatorioRequisicoesFaturamento.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioRequisicoesFaturamento.getModuloAcesso(tipoRelatorio, this.getFiltroCheck(FILTRO_DATAS_DIFERENCIADAS)));
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
        String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
        String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
        String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
        boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
        if (intervaloHora) {
            if (Funcoes.textoVazio(dataInicial)) {
                Funcoes.mensagem(this, "A data inicial deve ser preenchida.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (Funcoes.textoVazio(horaInicial)) {
                Funcoes.mensagem(this, "A hora inicial deve ser preenchida.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (Funcoes.textoVazio(dataFinal)) {
                Funcoes.mensagem(this, "A data final deve ser preenchida.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (Funcoes.textoVazio(horaFinal)) {
                Funcoes.mensagem(this, "A hora final deve ser preenchida.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            horaInicial = horaInicial + ":00";
            horaFinal = horaFinal + ":00";
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            HashMap<String, Object> var = new HashMap<String, Object>();
            StringBuilder buf = new StringBuilder();
            buf.append(this.getSelect());
            buf.append(this.getWhere(intervaloHora, dataInicial, horaInicial, dataFinal, horaFinal, var));
            buf.append(this.getOrderby());
            this.imprimirRelatorio(buf.toString(), var, new Runnable(){

                @Override
                public void run() {
                    RelatorioRequisicoesFaturamento.this.panelCentro.removeAll();
                    RelatorioRequisicoesFaturamento.this.panelCentro.repaint();
                    RelatorioRequisicoesFaturamento.this.habilitaBotaoImprimir(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    RelatorioRequisicoesFaturamento.this.habilitaBotaoImprimir(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void imprimirRelatorio(String sql, HashMap<String, Object> var, Runnable acaoFechar, Runnable acaoFimRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        ArrayList<String> listaReq = new ArrayList<String>();
        if (rs.next()) {
            ModeloGridTable modelo = new ModeloGridTable(campos);
            do {
                if (!listaReq.contains(rs.getString("codigoRequisicao"))) {
                    listaReq.add(rs.getString("codigoRequisicao"));
                }
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    if (campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico") || campos[i].equalsIgnoreCase("tipoLogradouroResponsavelRequisicao")) {
                        o[i] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoMedico")) {
                        o[i] = Tipos.tipoMedico(rs.getString("tipoMedico"));
                        continue;
                    }
                    if (campos[i].equals("anomesIdadeRequisicao") || campos[i].equals("anomesIdadePaciente") || campos[i].equals("tipoIdadeMinimaExame") || campos[i].equals("tipoIdadeMaximaExame")) {
                        o[i] = Tipos.tipoIdade(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("sexoPaciente") || campos[i].equals("sexoExame")) {
                        o[i] = Tipos.tipoSexo(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("situacaoExameRequisicao")) {
                        o[i] = Tipos.tipoSituacaoExame(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("corPaciente")) {
                        o[i] = Tipos.tipoCor(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("fumantePaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente"));
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("diabeticoPaciente")) {
                        o[i] = Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente"));
                        continue;
                    }
                    if (campos[i].equals("estadoCivilPaciente")) {
                        o[i] = Tipos.tipoEstadoCivil(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoPagamentoConvenio")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoCalculoFaturaConvenio")) {
                        o[i] = Tipos.tipoCalculoFatura(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("titularDependenteConvenio")) {
                        o[i] = Tipos.tipoTitularDependente(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoCalculoCHConvenio")) {
                        o[i] = Tipos.tipoCalculoCH(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("tipoUltimoPagamentoRequisicao")) {
                        o[i] = Tipos.tipoPagamento(rs.getString(campos[i]));
                        continue;
                    }
                    if (campos[i].equals("codigoFilialCodigoRequisicao")) {
                        o[i] = Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao());
                        continue;
                    }
                    if (campos[i].equals("tempoTotalAteDigitacaoExame") || campos[i].equals("tempoTotalAteColetaExame") || campos[i].equals("tempoTotalAteConferenciaExame") || campos[i].equals("tempoTotalAteImpressaoExame") || campos[i].equals("tempoTotalAteEntregaExame")) {
                        String retorno = "";
                        if (rs.getObject(campos[i]) != null) {
                            PGInterval interval = (PGInterval)rs.getObject(campos[i]);
                            StringBuilder bi = new StringBuilder();
                            bi.append(interval.getDays()).append(", ");
                            bi.append(Funcoes.preencheZero(interval.getHours(), 2)).append(":");
                            bi.append(Funcoes.preencheZero(interval.getMinutes(), 2)).append(":");
                            bi.append(Funcoes.preencheZero((int)interval.getSeconds(), 2));
                            retorno = bi.toString();
                        }
                        o[i] = retorno;
                        continue;
                    }
                    if (campos[i].equals("valorTotalExameRequisicao")) {
                        BigDecimal valor = new BigDecimal(0);
                        o[i] = valor.add(rs.getBigDecimal(campos[i]) == null ? BigDecimal.ZERO : rs.getBigDecimal(campos[i])).setScale(2, RoundingMode.HALF_UP);
                        continue;
                    }
                    if (campos[i].equals("medicamentosRequisicao")) {
                        o[i] = RelatorioRequisicoesFaturamento.pegaMedicamentos(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"));
                        continue;
                    }
                    if (campos[i].equals("codigosMultiGuias")) {
                        Object[] filhas = RecepcaoUtil.verificaMultiGuias(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), false);
                        if (filhas != null) {
                            o[i] = Arrays.toString(filhas);
                            continue;
                        }
                        o[i] = null;
                        continue;
                    }
                    o[i] = campos[i].equalsIgnoreCase("tempoDiureseExameRequisicao") ? rs.getString("tempoDiureseExameRequisicao") : rs.getObject(campos[i]);
                }
                modelo.addLine(o);
            } while (rs.next());
            if (modelo.getRowCount() == 0) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                if (acaoFimRelatorio != null) {
                    acaoFimRelatorio.run();
                }
                Conexao.fecharStatement(st, st2);
                return;
            }
            var.put(FILTRO_QTD_REQUISICOES, listaReq.size());
            StringBuilder buf = new StringBuilder();
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioRequisicoesFaturamento.getModuloAcesso(this.tipoRelatorio, this.getFiltroCheck(FILTRO_DATAS_DIFERENCIADAS)));
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                if (acaoFechar != null) {
                    gerador.setAcaoFechar(acaoFechar);
                }
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            }
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            if (acaoFimRelatorio != null) {
                acaoFimRelatorio.run();
            }
        }
        Conexao.fecharStatement(st, st2);
    }

    private String getOrderby() {
        StringBuilder buf = new StringBuilder();
        buf.append(" order by ");
        String campoOrdem = this.CAMPOS_ORDEM_BANCO[this.getFiltroComboIndice(FILTRO_ORDEM)];
        buf.append(campoOrdem);
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            buf.append(" ,b.exr_ordem, codigoexame, codigoMaterialColetado ");
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                buf.append(" ,setor.set_codigo ");
            }
            if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                buf.append(" ,codigoexame, codigoMaterialColetado ");
            } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                buf.append(" ,paginaexame, ordemexame, codigoexame, codigoMaterialColetado ");
            }
        }
        return buf.toString();
    }

    private String getWhere(boolean intervaloHora, String dataInicial, String horaInicial, String dataFinal, String horaFinal, HashMap<String, Object> var) {
        boolean deveGuia;
        StringBuilder buf = new StringBuilder();
        String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" where a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(",");
        }
        buf.append(") ");
        var.put(FILTRO_FILIAL, this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
        String[] usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
        if (usuario != null) {
            buf.append(" and a.usr_codabertura in('");
            for (int i = 0; i < usuario.length; ++i) {
                buf.append(usuario[i]);
                if (i >= usuario.length - 1) continue;
                buf.append("','");
            }
            buf.append("') ");
        }
        var.put(FILTRO_USUARIO, this.getSelecionadosFiltro(FILTRO_USUARIO, 0));
        String[] destinos = this.getSelecionadosFiltro(FILTRO_DESTINO, 0);
        if (destinos != null) {
            buf.append(" and a.des_codigo in (");
            for (int i = 0; i < destinos.length; ++i) {
                buf.append("'").append(destinos[i]).append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(",");
            }
            buf.append(") ");
        }
        var.put(FILTRO_DESTINO, this.getSelecionadosFiltro(FILTRO_DESTINO, 0));
        String[] coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
        if (coletas != null) {
            buf.append(" and a.col_codigo in (");
            for (int i = 0; i < coletas.length; ++i) {
                buf.append("'").append(coletas[i]).append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(",");
            }
            buf.append(") ");
        }
        var.put(FILTRO_COLETA, this.getSelecionadosFiltro(FILTRO_COLETA, 0));
        String[] convenios = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
        if (convenios != null) {
            buf.append(" and a.con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(",");
            }
            buf.append(") ");
        }
        var.put(FILTRO_CONVENIO, this.getSelecionadosFiltro(FILTRO_CONVENIO, 0));
        String[] conselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
        String[] crm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
        String[] uf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
        if (conselho != null && crm != null && uf != null) {
            buf.append(" and (a.med_conselho, a.med_crm, a.med_uf) in (");
            for (int i = 0; i < conselho.length; ++i) {
                buf.append("('").append((Object)conselho[i]).append("', '").append((Object)crm[i]).append("', '").append((Object)uf[i]).append("') ");
                if (i >= conselho.length - 1) continue;
                buf.append(" ,");
            }
            buf.append(") ");
        }
        var.put(FILTRO_MEDICO, this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1));
        String[] exames = this.getSelecionadosFiltro(FILTRO_EXAME, 0);
        if (exames != null) {
            buf.append(" and CASE WHEN(b1.exa_codigo = b.exa_codigo) then ");
            buf.append("   CASE WHEN(b1.exa_codfilho IS NOT NULL) THEN b1.exa_codfilho ELSE b.exa_codigo END ");
            buf.append(" ELSE ");
            buf.append("   b.exa_codigo ");
            buf.append(" END IN (");
            for (int i = 0; i < exames.length; ++i) {
                buf.append("'").append(exames[i]).append("'");
                if (i >= exames.length - 1) continue;
                buf.append(",");
            }
            buf.append(") ");
        }
        var.put(FILTRO_EXAME, this.getSelecionadosFiltro(FILTRO_EXAME, 0));
        String[] pacientes = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0);
        if (pacientes != null) {
            buf.append(" and a.pac_codigo in (");
            for (int i = 0; i < pacientes.length; ++i) {
                buf.append((Object)pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                buf.append(",");
            }
            buf.append(") ");
        }
        var.put(FILTRO_PACIENTE, this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0));
        String[] situacoes = this.getSelecionadosFiltro(FILTRO_SITUACAO_REQUISICAO, 0);
        if (situacoes != null && situacoes.length > 0) {
            buf.append(" and a.sit_codigo in (");
            for (int i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        var.put(FILTRO_SITUACAO_REQUISICAO, this.getSelecionadosFiltro(FILTRO_SITUACAO_REQUISICAO, 0));
        String[] empresas = this.getSelecionadosFiltro(FILTRO_EMPRESAS, 0);
        if (empresas != null && empresas.length > 0) {
            buf.append(" and a.ent_codempresa in (");
            for (int i = 0; i < empresas.length; ++i) {
                buf.append(empresas[i]);
                if (i >= empresas.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        var.put(FILTRO_EMPRESAS, this.getSelecionadosFiltro(FILTRO_EMPRESAS, 0));
        int indiceSituacaoExame = this.getFiltroComboIndice(FILTRO_SITUACAO_EXAME);
        var.put(FILTRO_SITUACAO_EXAME, this.SITUACOES_EXAME[indiceSituacaoExame]);
        String situacaoBanco = this.SITUACOES_EXAME_BANCO[indiceSituacaoExame];
        if (!Funcoes.textoVazio(situacaoBanco)) {
            buf.append(" and b.exr_situacao = '");
            buf.append(this.SITUACOES_EXAME_BANCO[indiceSituacaoExame]);
            buf.append("' ");
        } else if (situacaoBanco == null) {
            buf.append(" and (trim(b.exr_situacao) = '' or b.exr_situacao is null) ");
        }
        buf.append(" and NOT a.req_excluida ");
        buf.append(" and NOT b.exr_excluido ");
        int indice = this.getFiltroComboIndice(FILTRO_CAMPO_DATA);
        String campoData = this.CAMPOS_DATA_BANCO[indice];
        var.put(FILTRO_CAMPO_DATA, this.CAMPOS_DATA[indice]);
        String campoHora = this.CAMPOS_HORA_BANCO[indice];
        var.put(FILTRO_DATA_INICIAL, dataInicial);
        var.put(FILTRO_DATA_FINAL, dataFinal);
        var.put(FILTRO_HORA_INICIAL, horaInicial);
        var.put(FILTRO_HORA_FINAL, horaFinal);
        var.put(FILTRO_INTERVALO_HORA, intervaloHora ? "Sim" : "N?o");
        if (!intervaloHora) {
            if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                buf.append(" and ").append(campoData).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("'");
            }
            if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                buf.append(" and ").append(campoData).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("'");
            }
            if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and ").append(campoHora).append(" >= '").append(horaInicial).append("'");
            }
            if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and ").append(campoHora).append(" <= '").append(horaFinal).append("'");
            }
        } else {
            buf.append(" and ").append(campoData).append(" + ").append(campoHora).append(" >= '").append(Funcoes.formataData("yyyy-MM-dd ", dataInicial) + horaInicial).append("' ");
            buf.append(" and ").append(campoData).append(" + ").append(campoHora).append(" <= '").append(Funcoes.formataData("yyyy-MM-dd ", dataFinal) + horaFinal).append("' ");
        }
        var.put(FILTRO_DEVE_GUIA, (deveGuia = this.getFiltroCheck(FILTRO_DEVE_GUIA)) ? "Sim" : "N?o");
        if (deveGuia) {
            buf.append(" and a.req_deveguia = true ");
        }
        if (this.tipoRelatorio == 0) {
            buf.append(" and (b.exr_naofaturar = false or b.exr_naofaturar is null) ");
            buf.append(" and b.exr_datafatura is null ");
            buf.append(" and b.exr_datacortesia is null ");
            if (this.getFiltroCheck(FILTRO_DATAS_DIFERENCIADAS)) {
                buf.append(" and a.req_data <> a.req_dtfatura ");
            }
        } else if (this.tipoRelatorio == 1) {
            buf.append(" and b.exr_naofaturar = true ");
        }
        return buf.toString();
    }

    private String getSelect() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select DISTINCT ");
        buf.append("          CASE WHEN(b1.exa_codigo = b.exa_codigo) then ");
        buf.append("          CASE WHEN(b1.exa_codfilho IS NOT NULL) THEN b1.exa_codfilho ELSE b.exa_codigo END ");
        buf.append("          ELSE ");
        buf.append("          b.exa_codigo ");
        buf.append("          END AS codigoexame, ");
        buf.append("           ");
        buf.append("          CASE WHEN(b1.exa_codigo = b.exa_codigo) then ");
        buf.append("          CASE WHEN(b1.exa_codfilho IS NOT NULL) THEN coletado1.mco_abreviatura ELSE coletado.mco_abreviatura END ");
        buf.append("          ELSE ");
        buf.append("          coletado.mco_abreviatura ");
        buf.append("          END AS abreviaturamaterialcoletado, ");
        buf.append("             ");
        buf.append("          CASE WHEN(b1.exa_codigo = b.exa_codigo) then ");
        buf.append("          CASE WHEN(b1.exa_codfilho IS NOT NULL) THEN c1.exa_descricao ELSE c.exa_descricao END ");
        buf.append("          ELSE ");
        buf.append("          c.exa_descricao ");
        buf.append("          END AS descricaoexame, ");
        buf.append("          CASE WHEN(b1.exa_codigo = b.exa_codigo) then ");
        buf.append("            calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, case when(b1.exa_codfilho is not null) then b1.exa_codfilho else b.exa_codigo end, case when(b1.exa_codfilho is not null) then  b1.mco_codfilho else b.mco_codigo end, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") ");
        buf.append("          ELSE ");
        buf.append("            calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") ");
        buf.append("          END AS valorTotalExameRequisicao ");
        buf.append("          ,'' as codigoFilialCodigoRequisicao ");
        buf.append("          ,a.req_codigo as codigoRequisicao ");
        buf.append("          ,a.req_data as dataRequisicao ");
        buf.append("          ,a.req_dtfatura as dataFaturaRequisicao ");
        buf.append("                                         ,a.req_urgente as urgenteRequisicao ");
        buf.append("          ,a.req_dataentregaprev as dataEntregaRequisicao ");
        buf.append("                                        ,a.req_dclinicos as dadosClinicosRequisicao ");
        buf.append("          ,a.req_notacaixa as notaCaixaRequisicao ");
        buf.append("          ,a.req_obs as observacaoRequisicao ");
        buf.append("                 ,a.req_totpago as totalPagoRequisicao ");
        buf.append("          ,a.req_total as totalRequisicao ");
        buf.append("          ,a.req_totaltaxa as totalTaxaRequisicao ");
        buf.append("          ,a.req_horaentregaprev as horaEntregaRequisicao ");
        buf.append("          ,a.req_horafatura as horaFaturaRequisicao ");
        buf.append("          ,a.req_hora as horaRequisicao ");
        buf.append("          ,a.req_gestante as gestanteRequisicao ");
        buf.append("          ,a.req_dum as dumRequisicao ");
        buf.append("          ,a.req_matricula as matriculaRequisicao ");
        buf.append("          ,a.req_anomes as anomesIdadeRequisicao ");
        buf.append("          ,a.req_idade as idadeRequisicao ");
        buf.append("          ,a.req_avisarpaciente as avisarPacienteRequisicao ");
        buf.append("          ,a.req_senhaweb as senhaWebRequisicao ");
        buf.append("          ,a.req_titular as titularRequisicao ");
        buf.append("          ,a.req_altura as alturaRequisicao ");
        buf.append("          ,a.req_peso as pesoRequisicao ");
        buf.append("          ,a.req_vlracrescimo as valorAcrescimoRequisicao ");
        buf.append("          ,a.req_acrescimo as percentualAcrescimoRequisicao ");
        buf.append("          ,a.req_vlrdesconto as valorDescontoRequisicao ");
        buf.append("          ,a.req_desconto as percentualDescontoRequisicao ");
        buf.append("          ,a.req_telacoleta as coletadoRequisicao ");
        buf.append("          ,a.req_datarequisicao as dataAberturaRequisicao ");
        buf.append("          ,a.req_neonato as neonatoRequisicao ");
        buf.append("          ,a.req_validadeguia as validadeGuiaRequisicao ");
        buf.append("          ,a.req_guia as guiaRequisicao ");
        buf.append("          ,a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao ");
        buf.append("          ,a.req_complementodestino as complementoDestinoRequisicao ");
        buf.append("          ,a.req_motivoExclusao as motivoExclusao ");
        buf.append("          ,a.ent_codempresa as codigoEmpresaRequisicao ");
        buf.append("          ,to_ascii(ep.ent_razaosocial) as descricaoEmpresaRequisicao ");
        buf.append("          ,b.exr_guia as guiaExameRequisicao ");
        buf.append("          ,b.exr_situacao as situacaoExameRequisicao ");
        buf.append("          ,b.exr_entrpara as entregueParaExameRequisicao ");
        buf.append("          ,b.exr_dataassina as dataAssinaturaExameRequisicao ");
        buf.append("          ,b.exr_datadigita as dataDigitacaoExameRequisicao ");
        buf.append("          ,b.exr_datamaterial as dataColetaExameRequisicao ");
        buf.append("          ,b.exr_dataentreguerst as dataEntregueExameRequisicao ");
        buf.append("          ,b.exr_datarecoleta as dataRecoletaExameRequisicao ");
        buf.append("          ,b.exr_motivorecoleta as motivoRecoletaExameRequisicao ");
        buf.append("          ,b.exr_motivorecoleta as justificativaMotivoRecoleta ");
        buf.append("          ,mr.mrc_descricao as descricaomotivorecoleta ");
        buf.append("          ,mr.mrc_codigo as codigomotivorecoleta ");
        buf.append("          ,b.exr_datarepeticao as dataRepeticaoExameRequisicao ");
        buf.append("          ,b.exr_dataetqtriagem as dataEtiquetaTriagemExameRequisicao ");
        buf.append("          ,b.exr_naofaturar as naoFaturarExameRequisicao ");
        buf.append("          ,b.exr_datatriagem as dataTriagemExameRequisicao ");
        buf.append("          ,b.exr_dataetqcoleta as dataEtqColetaExameRequisicao ");
        buf.append("          ,b.exr_tempodiurese as tempoDiureseExameRequisicao ");
        buf.append("          ,b.exr_dataloteexterno as dataLoteExternoExameRequisicao ");
        buf.append("          ,b.exr_datamaterialsetor as dataMaterialSetorExameRequisicao ");
        buf.append("          ,b.exr_dataexcluido as dataExcluidoExameRequisicao ");
        buf.append("          ,b.exr_dataguia as dataGuiaExameRequisicao ");
        buf.append("          ,b.exr_validadeguia as validadeGuiaExameRequisicao ");
        buf.append("          ,b.exr_datafaturarepasse as dataFaturaRepasseExameRequisicao ");
        buf.append("          ,coalesce(b.exr_urgente, false) as urgenteExameRequisicao ");
        buf.append("          ,b.exr_dataimpresso as dataImpressaoExameRequisicao ");
        buf.append("          ,b.exr_datafatura as dataFaturaExameRequisicao ");
        buf.append("          ,calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, false, true, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, convenio.con_precosdiferenciados, convenio.con_reajuste, convenio.con_cobrmaterial, convenio.con_percpgtomaterial, convenio.con_percpgto, convenio.con_tpcalcfatu, convenio.con_tpcalcch, convenio.con_perguntarpercbalcao, convenio.con_acrescimo, convenio.con_bonus, convenio.tpe_codigo, convenio.con_acrescimoporte, convenio.con_acrescimouco, convenio.con_descontoporte, convenio.con_descontouco, convenio.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorFaturarExameRequisicao ");
        buf.append("          ,b.exr_vlrexame as valorExameExameRequisicao ");
        buf.append("          ,b.exr_vlrchexame as valorCHExameExameRequisicaoOriginal ");
        buf.append("          ,calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameExameRequisicao ");
        buf.append("          ,'' as codigosMultiGuias ");
        buf.append("          ,age(coalesce(b.exr_datamaterial, b.exr_data), b.exr_data) as tempoTotalAteColetaExame ");
        buf.append("          ,age(coalesce(b.exr_datadigita, b.exr_data), b.exr_data) as tempoTotalAteDigitacaoExame ");
        buf.append("          ,age(coalesce(b.exr_dataassina, b.exr_data), b.exr_data) as tempoTotalAteConferenciaExame ");
        buf.append("          ,age(coalesce(b.exr_dataimpresso, b.exr_data), b.exr_data) as tempoTotalAteImpressaoExame ");
        buf.append("          ,age(coalesce(b.exr_dataentreguerst, b.exr_data), b.exr_data) as tempoTotalAteEntregaExame ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("        ,COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb) as codigoAMBExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.cpr_valor else COALESCE(dtm.dtm_valor, dtp.dtp_valor) end as valorCHExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.cpr_percentual else COALESCE(dtm.dtm_percentual, dtp.dtp_percentual) end as percentualCBHPMExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.tpp_porte else COALESCE(dtm.tpp_porte, dtp.tpp_porte) end as porteCBHPMExameTabelaPreco ");
        } else {
            buf.append("        ,dtp.dtp_codamb as codigoAMBExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.cpr_valor else dtp.dtp_valor end as valorCHExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.cpr_percentual else dtp.dtp_percentual end as percentualCBHPMExameTabelaPreco ");
            buf.append("        ,case when convenio.con_precosdiferenciados = true then cpr.tpp_porte else dtp.tpp_porte end as porteCBHPMExameTabelaPreco ");
        }
        buf.append("          ,b.exr_matexterno as materialExternoExameRequisicao ");
        buf.append("          ,b.exr_dataentregaprev as dataEntregaExameRequisicao ");
        buf.append("          ,b.exr_interfaciado as interfaceadoExameRequisicao ");
        buf.append("          ,b.exr_lotereag as loteReagenteExameRequisicao ");
        buf.append("          ,b.exr_quantreag as quantidadeReagenteExameRequisicao ");
        buf.append("          ,b.exr_vlrch as valorCHExameRequisicaoOriginal ");
        buf.append("          ,calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameRequisicao ");
        buf.append("          ,b.exr_vlrmaterial as valorMaterialExameRequisicao ");
        buf.append("          ,b.exr_vlrbalcaoconvenio as valorPagoBalcaoExameRequisicao ");
        buf.append("          ,b.exr_datamapa as dataImpressaoMapaExameRequisicao ");
        buf.append("          ,b.exr_codautorizacao as codigoAutorizacaoExameRequisicao ");
        buf.append("          ,b.exr_data as dataInsercaoExameRequisicao ");
        buf.append("          ,b.exr_obs as observacaoExameRequisicao ");
        buf.append("          ,b.exr_datacortesia as dataCortesiaExameRequisicao ");
        buf.append("          ,b.exr_serialreag as serialReagenteExameRequisicao ");
        buf.append("          ,b.exr_autorizar as autorizarExameRequisicao ");
        buf.append("          , CASE WHEN b.exr_intervalojejum IS NULL THEN TO_CHAR(b.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(b.exr_intervalojejum, 'HH24:MI') END AS tempoJejumExameRequisicao");
        buf.append("          ,b.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao ");
        buf.append("          ,b.exr_motivoprazo as observacaoPrazoCarenciaExameRequisicao ");
        buf.append("          ,b.exr_avisarentrega as avisarPacienteExameRequisicao ");
        buf.append("          ,'' as medicamentosRequisicao ");
        buf.append("          ,a.req_quarto as quartoRequisicao ");
        buf.append("          ,a.req_leito as leitoRequisicao ");
        buf.append("          ,ala.ala_codigo as codigoAla ");
        buf.append("          ,ala.ala_descricao as descricaoAla ");
        buf.append("          ,paciente.pac_codigo as codigoPaciente ");
        buf.append("          ,upper(paciente.pac_nome) as nomePaciente ");
        buf.append("          ,upper(paciente.pac_nomesocial) as nomeSocialPaciente ");
        buf.append("          ,paciente.pac_datanasc as dataNascimentoPaciente ");
        buf.append("          ,paciente.pac_sexo as sexoPaciente ");
        buf.append("          ,paciente.pac_vip as vipPaciente ");
        buf.append("          ,paciente.pac_grpsangue as grupoSanguineoPaciente ");
        buf.append("          ,paciente.pac_fatorrh as fatorrhPaciente ");
        buf.append("          ,paciente.pac_fatordu as fatorduPaciente ");
        buf.append("          ,paciente.pac_cor as corPaciente ");
        buf.append("          ,paciente.pac_observ as observacaoPaciente ");
        buf.append("          ,paciente.pac_dadoclinico as dadosClinicosPaciente ");
        buf.append("          ,paciente.pac_peso as pesoPaciente ");
        buf.append("          ,paciente.pac_altura as alturaPaciente ");
        buf.append("          ,paciente.pac_matricconv as matriculaConvenioPaciente ");
        buf.append("          ,paciente.pac_titularconv as titularConvenioPaciente ");
        buf.append("          ,paciente.pac_profissao as profissaoPaciente ");
        buf.append("          ,paciente.pac_fumante as fumantePaciente ");
        buf.append("          ,paciente.pac_diabetico as diabeticoPaciente ");
        buf.append("          ,paciente.pac_rg as rgPaciente ");
        buf.append("          ,paciente.pac_cpf as cpfPaciente ");
        buf.append("          ,paciente.pac_estcivil as estadoCivilPaciente ");
        buf.append("          ,paciente.pac_numfilho as numeroFilhosPaciente ");
        buf.append("          ,paciente.pac_datahora as dataHoraCadastroPaciente ");
        buf.append("          ,paciente.pac_dum as dumPaciente ");
        buf.append("          ,paciente.pac_fax as faxPaciente ");
        buf.append("          ,paciente.pac_celular as celularPaciente ");
        buf.append("          ,paciente.pac_fonecomercial as foneComercialPaciente ");
        buf.append("          ,paciente.pac_fone as fonePaciente ");
        buf.append("          ,paciente.pac_cep as cepPaciente ");
        buf.append("          ,paciente.pac_complemento as complementoPaciente ");
        buf.append("          ,paciente.pac_endereco as enderecoPaciente ");
        buf.append("          ,paciente.pac_numeroendereco as numeroEnderecoPaciente ");
        buf.append("          ,paciente.pac_tipologradouroendereco as tipoLogradouroPaciente ");
        buf.append("          ,paciente.pac_email as emailPaciente ");
        buf.append("          ,paciente.pac_anomes as anomesIdadePaciente ");
        buf.append("          ,paciente.pac_idade as idadePaciente ");
        buf.append("          ,paciente.pac_fonecontato as foneContatoPaciente ");
        buf.append("          ,paciente.pac_nomecontato as contatoPaciente ");
        buf.append("          ,paciente.pac_mae as maePaciente ");
        buf.append("          ,paciente.pac_pai as paiPaciente ");
        buf.append("          ,cidpaciente.cid_codigo as codigoCidadePaciente ");
        buf.append("          ,cidpaciente.cid_nome as descricaoCidadePaciente ");
        buf.append("          ,cidpaciente.cid_uf as estadoCidadePaciente ");
        buf.append("          ,baipaciente.bai_codigo as codigoBairroPaciente ");
        buf.append("          ,baipaciente.bai_descricao as descricaoBairroPaciente ");
        buf.append("          ,usrrequisicao.usr_codigo as codigoUsuarioRequisicao ");
        buf.append("          ,usrrequisicao.usr_nome as nomeUsuarioRequisicao ");
        buf.append("          ,usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao ");
        buf.append("          ,usrabertura.usr_nome as nomeUsuarioAberturaRequisicao ");
        buf.append("          ,destino.des_codigo as codigoDestino ");
        buf.append("          ,destino.des_descricao as descricaoDestino ");
        buf.append("          ,destino.des_impressora as impressoraDestino ");
        buf.append("          ,destino.des_naoimprimir as naoImprimirDestino ");
        buf.append("          ,destino.des_cep as cepDestino ");
        buf.append("          ,destino.des_complemento as complementoDestino ");
        buf.append("          ,destino.des_endereco as enderecoDestino ");
        buf.append("          ,destino.des_fone as foneDestino ");
        buf.append("          ,destino.des_enviarweb as enviarWebDestino ");
        buf.append("          ,ciddestino.cid_codigo as codigoCidadeDestino ");
        buf.append("          ,ciddestino.cid_nome as descricaoCidadeDestino ");
        buf.append("          ,ciddestino.cid_uf as estadoCidadeDestino ");
        buf.append("          ,baidestino.bai_codigo as codigoBairroDestino ");
        buf.append("          ,baidestino.bai_descricao as descricaoBairroDestino ");
        buf.append("          ,coleta.col_codigo as codigoColeta ");
        buf.append("          ,coleta.col_descricao as descricaoColeta ");
        buf.append("          ,coleta.col_cep as cepColeta ");
        buf.append("          ,coleta.col_complemento as complementoColeta ");
        buf.append("          ,coleta.col_endereco as enderecoColeta ");
        buf.append("          ,coleta.col_fone as foneColeta ");
        buf.append("          ,cidcoleta.cid_codigo as codigoCidadeColeta ");
        buf.append("          ,cidcoleta.cid_nome as descricaoCidadeColeta ");
        buf.append("          ,cidcoleta.cid_uf as estadoCidadeColeta ");
        buf.append("          ,baicoleta.bai_codigo as codigoBairroColeta ");
        buf.append("          ,baicoleta.bai_descricao as descricaoBairroColeta ");
        buf.append("          ,setor.set_codigo as codigoSetor ");
        buf.append("          ,setor.set_descricao as descricaoSetor ");
        buf.append("          ,setor.set_responsavel as responsavelSetor ");
        buf.append("          ,setor.set_sigla as siglaSetor ");
        buf.append("          ,setor.set_cor as corSetor ");
        buf.append("          ,usrsetor.usr_codigo as codigoUsuarioSetor ");
        buf.append("          ,usrsetor.usr_nome as nomeUsuarioSetor ");
        buf.append("          ,convenio.con_codigo as codigoConvenio ");
        buf.append("          ,convenio.con_razao as razaoSocialConvenio ");
        buf.append("          ,convenio.con_fantasia as fantasiaConvenio ");
        buf.append("          ,convenio.con_cnpjcpf as cnpjConvenio ");
        buf.append("          ,convenio.con_tppgto as tipoPagamentoConvenio ");
        buf.append("          ,convenio.con_fatfmaterial as faturarFaltaMaterialConvenio ");
        buf.append("          ,convenio.con_descexame as habilitarDescontoConvenio ");
        buf.append("          ,convenio.con_multa as multaConvenio ");
        buf.append("          ,convenio.con_mora as moraConvenio ");
        buf.append("          ,convenio.con_fatfiliais as faturarFiliaisConvenio ");
        buf.append("          ,convenio.con_nr1via as quantidade1ViaConvenio ");
        buf.append("          ,convenio.con_nrexames as numeroExamesConvenio ");
        buf.append("          ,convenio.con_viasfatura as viasFaturaConvenio ");
        buf.append("          ,convenio.con_impbloqueto as imprimirBloquetoConvenio ");
        buf.append("          ,convenio.con_nr2via as quantidade2ViaConvenio ");
        buf.append("          ,convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio ");
        buf.append("          ,coalesce(convenio.con_percpgto, 0) as percentualBalcaoConvenio ");
        buf.append("          ,convenio.con_cobrexame as cobrarExameBalcaoConvenio ");
        buf.append("          ,convenio.con_inscrest as inscricaoEstadualConvenio ");
        buf.append("          ,convenio.con_titdep as titularDependenteConvenio ");
        buf.append("          ,convenio.con_maskcart as mascaraCarteiraConvenio ");
        buf.append("          ,convenio.con_contato as contatoConvenio ");
        buf.append("          ,convenio.con_informarmat as obrigaMatriculaConvenio ");
        buf.append("          ,convenio.con_cep as cepConvenio ");
        buf.append("          ,convenio.con_complemento as complementoConvenio ");
        buf.append("          ,convenio.con_endereco as enderecoConvenio ");
        buf.append("          ,convenio.con_cepcobranca as cepCobrancaConvenio ");
        buf.append("          ,convenio.con_complcobranca as complementoCobrancaConvenio ");
        buf.append("          ,convenio.con_endcobranca as enderecoCobrancaConvenio ");
        buf.append("          ,convenio.con_numeroendereco as numeroEnderecoConvenio ");
        buf.append("          ,convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio ");
        buf.append("          ,convenio.con_tipologradouroendereco as tipoLogradouroConvenio ");
        buf.append("          ,convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio ");
        buf.append("          ,convenio.con_fax as faxConvenio ");
        buf.append("          ,convenio.con_fone as foneConvenio ");
        buf.append("          ,convenio.con_valorfilme as valorFilmeConvenio ");
        buf.append("          ,convenio.con_valorch as valorCHConvenio ");
        buf.append("          ,convenio.con_site as siteConvenio ");
        buf.append("          ,convenio.con_email2 as email2Convenio ");
        buf.append("          ,convenio.con_email1 as email1Convenio ");
        buf.append("          ,convenio.con_tpcalcch as tipoCalculoCHConvenio ");
        buf.append("          ,convenio.con_inscmunic as inscricaoMunicipalConvenio ");
        buf.append("          ,convenio.con_bonus as percentualBonusConvenio ");
        buf.append("          ,convenio.con_senhaweb as senhaWebConvenio ");
        buf.append("          ,convenio.con_acrescimo as percentualAcrescimoConvenio ");
        buf.append("          ,convenio.con_proibidoweb as proibidoWebConvenio ");
        buf.append("          ,convenio.con_validadeguia as obrigaValidadeGuiaConvenio ");
        buf.append("          ,convenio.con_codigoguia as obrigaGuiaConvenio ");
        buf.append("          ,convenio.con_diasvalidade as diasValidadeGuia ");
        buf.append("          ,convenio.con_ordemfatura as ordemFaturaConvenio ");
        buf.append("          ,convenio.con_cobrmaterial as cobrarMateriaisConvenio ");
        buf.append("          ,prioridade.pri_codigo as codigoPrioridade ");
        buf.append("          ,prioridade.pri_descricao as descricaoPrioridade ");
        buf.append("          ,tabela.tpe_codigo as codigoTabela ");
        buf.append("          ,tabela.tpe_descricao as descricaoTabela ");
        buf.append("          ,tabela.tpe_valorch as valorCHTabela ");
        buf.append("          ,tabela.tpe_moeda as moedaTabela ");
        buf.append("          ,cidconvenio.cid_codigo as codigoCidadeConvenio ");
        buf.append("          ,cidconvenio.cid_nome as descricaoCidadeConvenio ");
        buf.append("          ,cidconvenio.cid_uf as estadoCidadeConvenio ");
        buf.append("          ,baiconvenio.bai_codigo as codigoBairroConvenio ");
        buf.append("          ,baiconvenio.bai_descricao as descricaoBairroConvenio ");
        buf.append("          ,layout.lay_codigo as codigoModelo ");
        buf.append("          ,layout.lay_descricao as descricaoModelo ");
        buf.append("          ,medico.med_conselho as conselhoMedico ");
        buf.append("          ,medico.med_crm as crmMedico ");
        buf.append("          ,medico.med_uf as ufMedico ");
        buf.append("          ,medico.med_nome as nomeMedico ");
        buf.append("          ,medico.med_abrev as abreviaturaMedico ");
        buf.append("          ,medico.med_tipo as tipoMedico ");
        buf.append("          ,medico.med_comissao as comissaoMedico ");
        buf.append("          ,medico.med_cep as cepMedico ");
        buf.append("          ,medico.med_complemento as complementoMedico ");
        buf.append("          ,medico.med_endereco as enderecoMedico ");
        buf.append("          ,medico.med_numeroendereco as numeroEnderecoMedico ");
        buf.append("          ,medico.med_tipologradouroendereco as tipoLogradouroMedico ");
        buf.append("          ,medico.med_celular as celularMedico ");
        buf.append("          ,medico.med_fax as faxMedico ");
        buf.append("          ,medico.med_fone as foneMedico ");
        buf.append("          ,medico.med_email as emailMedico ");
        buf.append("          ,medico.med_site as siteMedico ");
        buf.append("          ,medico.med_senhaweb as senhaWebMedico ");
        buf.append("          ,cidmedico.cid_codigo as codigoCidadeMedico ");
        buf.append("          ,cidmedico.cid_nome as descricaoCidadeMedico ");
        buf.append("          ,cidmedico.cid_uf as estadoCidadeMedico ");
        buf.append("          ,baimedico.bai_codigo as codigoBairroMedico ");
        buf.append("          ,baimedico.bai_descricao as descricaoBairroMedico ");
        buf.append("          ,usrassina.usr_codigo as codigoUsuarioAssina ");
        buf.append("          ,usrassina.usr_nome as nomeUsuarioAssina ");
        buf.append("          ,usrdigitador.usr_codigo as codigoUsuarioDigitador ");
        buf.append("          ,usrdigitador.usr_nome as nomeUsuarioDigitador ");
        buf.append("          ,usrmaterial.usr_codigo as codigoUsuarioMaterial ");
        buf.append("          ,usrmaterial.usr_nome as nomeUsuarioMaterial ");
        buf.append("          ,usrrecoleta.usr_codigo as codigoUsuarioRecoleta ");
        buf.append("          ,usrrecoleta.usr_nome as nomeUsuarioRecoleta ");
        buf.append("          ,usrrepeticao.usr_codigo as codigoUsuarioRepeticao ");
        buf.append("          ,usrrepeticao.usr_nome as nomeUsuarioRepeticao ");
        buf.append("          ,usrfatura.usr_codigo as codigoUsuarioFatura ");
        buf.append("          ,usrFatura.usr_nome as nomeUsuarioFatura ");
        buf.append("          ,usrentrega.usr_codigo as codigoUsuarioEntrega ");
        buf.append("          ,usrentrega.usr_nome as nomeUsuarioEntrega ");
        buf.append("          ,usrimpressao.usr_codigo as codigoUsuarioImpressao ");
        buf.append("          ,usrimpressao.usr_nome as nomeUsuarioImpressao ");
        buf.append("          ,usrexame.usr_codigo as codigoUsuarioExame ");
        buf.append("          ,usrexame.usr_nome as nomeUsuarioExame ");
        buf.append("          ,usrmapa.usr_codigo as codigoUsuarioMapa ");
        buf.append("          ,usrmapa.usr_nome as nomeUsuarioMapa ");
        buf.append("          ,usrcortesia.usr_codigo as codigoUsuarioCortesia ");
        buf.append("          ,usrcortesia.usr_nome as nomeUsuarioCortesia ");
        buf.append("          ,c.exa_sexo as sexoExame ");
        buf.append("          ,c.exa_horaentrada as horaEntradaExame ");
        buf.append("          ,c.exa_horasaida as horaSaidaExame ");
        buf.append("          ,c.exa_filtro as textoFiltroExame ");
        buf.append("          ,c.exa_proibido as proibidoExame ");
        buf.append("          ,c.exa_idademax as idadeMaximaExame ");
        buf.append("          ,c.exa_idademin as idadeMinimaExame ");
        buf.append("          ,c.exa_idademaxtipo as tipoIdadeMaximaExame ");
        buf.append("          ,c.exa_idademintipo as tipoIdadeMinimaExame ");
        buf.append("          ,c.exa_proibidoweb as proibidoWebExame ");
        buf.append("          ,c.exa_qtdeamostras as quantidadeAmostrasExame ");
        buf.append("          ,COALESCE(d1.emc_default, d.emc_default) as padraoExame ");
        buf.append("          ,COALESCE(d1.emc_ordem, d.emc_ordem) as ordemExame ");
        buf.append("          ,COALESCE(d1.emc_pagina, d.emc_pagina) as paginaExame ");
        buf.append("          ,COALESCE(d1.emc_codigocbhpm, d.emc_codigocbhpm) as codigoCBHPMExame ");
        buf.append("          ,COALESCE(d1.emc_codigoamb, d.emc_codigoamb) as codigoAMBExame ");
        buf.append("          ,COALESCE(d1.emc_solicitarjejum, d.emc_solicitarjejum) as solicitarJejumExame ");
        buf.append("          ,COALESCE(d1.emc_obrigamedicamento, d.emc_obrigamedicamento) as solicitarMedicamentoExame ");
        buf.append("          ,COALESCE(d1.emc_obrigadum, d.emc_obrigadum) as solicitarDUMExame ");
        buf.append("          ,COALESCE(d1.emc_obrigapeso, d.emc_obrigapeso) as solicitarPesoExame ");
        buf.append("          ,COALESCE(d1.emc_obrigaaltura, d.emc_obrigaaltura) as solicitarAlturaExame ");
        buf.append("          ,COALESCE(d1.emc_obrigavolume, d.emc_obrigavolume) as solicitarVolumeExame ");
        buf.append("          ,COALESCE(d1.emc_obrigatempodiurese, d.emc_obrigatempodiurese) as solicitarTempoDiureseExame ");
        buf.append("          ,COALESCE(d1.emc_marcarexterno, d.emc_marcarexterno) as marcarExternoExame ");
        buf.append("          ,COALESCE(coletado1.mco_codigo, coletado.mco_codigo) as codigoMaterialColetado ");
        buf.append("          ,COALESCE(coletado1.mco_descricao, coletado.mco_descricao) as descricaoMaterialColetado ");
        buf.append("          ,prazo.prz_codigo as codigoPrazoEntrega ");
        buf.append("          ,prazo.prz_descricao as descricaoPrazoEntrega ");
        buf.append("          ,prazo.prz_dias as diasPrazoEntrega ");
        buf.append("          ,prazo.prz_horaentrada as horaEntradaPrazoEntrega ");
        buf.append("          ,prazo.prz_horasaida as horaSaidaPrazoEntrega ");
        buf.append("          ,prazo.prz_prazo as rotinaPrazoEntrega ");
        buf.append("          ,metodologia.met_codigo as codigoMetodologia ");
        buf.append("          ,metodologia.met_descricao as descricaoMetodologia ");
        buf.append("          ,a.est_codigo as codigoEstacao ");
        buf.append("          ,estacoes.est_descricao as descricaoEstacao ");
        buf.append("          ,a.req_prontuario as prontuarioRequisicao ");
        buf.append("          ,sit.sit_codigo as codigoSituacao ");
        buf.append("          ,sit.sit_descricao as descricaoSituacao ");
        buf.append("          ,a.req_descricaoproduto as descricaoProdutoRequisicao ");
        buf.append("          ,a.req_datafabricacao as dataFabricacaoProdutoRequisicao ");
        buf.append("          ,a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao ");
        buf.append("          ,a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao ");
        buf.append("          ,a.req_numeroloteproduto as numeroLoteProdutoRequisicao ");
        buf.append("          ,a.req_datavalidade as dataValidadeProdutoRequisicao ");
        buf.append("          ,a.req_marcaproduto as marcaProdutoRequisicao ");
        buf.append("          ,a.req_lacreproduto as lacreProdutoRequisicao ");
        buf.append("          ,a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao ");
        buf.append("          ,a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao ");
        buf.append("          ,a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao ");
        buf.append("          ,a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao ");
        buf.append("          ,a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao ");
        buf.append("          ,a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao ");
        buf.append("          ,a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao ");
        buf.append("          ,a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao ");
        buf.append("          ,a.req_partidaproduto as partidaProdutoRequisicao ");
        buf.append("          ,a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao ");
        buf.append("          ,a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao ");
        buf.append("          ,a.unm_codigo as codigoUnidadeProdutoRequisicao ");
        buf.append("          ,a.req_datarecebeuguia as dataRecebeuGuiaRequisicao ");
        buf.append("          ,a.req_dataguiaconferida as dataGuiaConferidaRequisicao ");
        buf.append("          ,a.req_datarecebimentoproduto as dataRecebimentoProdutoRequisicao ");
        buf.append("          ,a.req_validadecarteira as validadeCarteiraRequisicao ");
        buf.append("          ,a.req_validadeguiarepasse as validadeGuiaRepasseRequisicao ");
        buf.append("          ,a.req_validadecarteirarepasse as validadeCarteiraRepasseRequisicao ");
        buf.append("          ,a.req_datarecebeuguiarepasse as dataRecebeuGuiaRepasseRequisicao ");
        buf.append("          ,a.req_datacoletaproduto as dataColetaProdutoRequisicao ");
        buf.append("          ,a.req_horacoletaproduto as horaColetaProdutoRequisicao ");
        buf.append("          ,unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao ");
        buf.append("          ,a.emb_codigo as codigoEmbalagemProdutoRequisicao ");
        buf.append("          ,emb.emb_descricao as descricaoEmbalagemProdutoRequisicao ");
        buf.append("          ,paccontatos.pco_nome as nomeResponsavelRequisicao_ ");
        buf.append("          ,paccontatos.pco_cargo as cargoResponsavelRequisicao_ ");
        buf.append("          ,paccontatos.pco_email as emailResponsavelRequisicao_ ");
        buf.append("          ,paccontatos.pco_fone as foneResponsavelRequisicao_ ");
        buf.append("          ,ent.ent_fantasia as nomeResponsavelRequisicao ");
        buf.append("          ,ent.ent_cargo as cargoResponsavelRequisicao ");
        buf.append("          ,ent.ent_email as emailResponsavelRequisicao ");
        buf.append("          ,ent.ent_fone as foneResponsavelRequisicao ");
        buf.append("          ,ent.ent_razaosocial as razaoSocialResponsavelRequisicao ");
        buf.append("          ,ent.ent_endereco as enderecoResponsavelRequisicao ");
        buf.append("          ,ent.ent_numeroendereco as numeroEnderecoResponsavelRequisicao ");
        buf.append("          ,ent.ent_tipologradouroendereco as tipoLogradouroResponsavelRequisicao ");
        buf.append("          ,ent.ent_complemento as complementoResponsavelRequisicao ");
        buf.append("          ,ent.ent_cep as cepResponsavelRequisicao ");
        buf.append("          ,ent.ent_cpfcnpj as cpfCnpjResponsavelRequisicao ");
        buf.append("          ,cidentidade.cid_nome as descricaoCidadeResponsavelRequisicao ");
        buf.append("          ,cidentidade.cid_uf as estadoCidadeResponsavelRequisicao ");
        buf.append("          ,baientidade.bai_descricao as descricaoBairroResponsavelRequisicao ");
        buf.append("          ,paciente.bai_codigocobranca as codigoBairroCobrancaPaciente ");
        buf.append("          ,baicobranca.bai_descricao as descricaoBairroCobrancaPaciente ");
        buf.append("          ,paciente.cid_codigocobranca as codigoCidadeCobrancaPaciente ");
        buf.append("          ,cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente ");
        buf.append("          ,cidcobranca.cid_uf as estadoCidadeCobrancaPaciente ");
        buf.append("          ,paciente.pac_razaosocial as razaoSocialPaciente ");
        buf.append("          ,paciente.pac_cnpj as cnpjPaciente ");
        buf.append("          ,paciente.pac_ie as inscricaoEstadualPaciente ");
        buf.append("          ,paciente.pac_proprietario as proprietarioPaciente ");
        buf.append("          ,paciente.pac_sif as sifPaciente ");
        buf.append("          ,paciente.pac_enderecocobranca as enderecoCobrancaPaciente ");
        buf.append("          ,paciente.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente ");
        buf.append("          ,paciente.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente ");
        buf.append("          ,paciente.pac_complementocobranca as complementoCobrancaPaciente");
        buf.append("          ,paciente.pac_cepcobranca as cepCobrancaPaciente ");
        buf.append("          ,paciente.pac_fonecobranca as foneCobrancaPaciente ");
        buf.append("          ,paciente.pac_responsavelcobranca as responsavelCobrancaPaciente ");
        buf.append("          ,orc.orc_codigo as codigoOrcamento ");
        buf.append("          ,orc.orc_datahora as dataHoraOrcamento ");
        buf.append("          ,orc.orc_observacao as observacaoOrcamento ");
        buf.append("          ,orc.orc_validade as validadeOrcamento ");
        buf.append("          ,orc.orc_solicitante as solicitanteOrcamento ");
        buf.append("          ,orc.orc_contato as contatoOrcamento ");
        buf.append("          ,orc.orc_fone as foneOrcamento ");
        buf.append("          ,orc.orc_email as emailOrcamento ");
        buf.append("          ,orc.orc_fonecontato as fonecontatoOrcamento ");
        buf.append("          ,orc.orc_proprietario as proprietarioOrcamento ");
        buf.append("          ,usrorcamento.usr_codigo as codigoUsuarioOrcamento ");
        buf.append("          ,usrorcamento.usr_nome as nomeUsuarioOrcamento ");
        buf.append("          ,cast(COALESCE(NULLIF(b.exr_situacao, ''), '-') as TEXT) = (select array_to_string(array_agg(distinct cast(COALESCE(NULLIF(exr2.exr_situacao, ''), '-') as TEXT)), '') ");
        buf.append("                                   from examerequisicao exr2 ");
        buf.append("                                  where a.fil_codigo = exr2.fil_codigo ");
        buf.append("                                    and a.req_codigo = exr2.req_codigo) as todosIguais ");
        buf.append("          ,b.exr_ordem ");
        buf.append("          ,convenio.con_fantasia ");
        buf.append("          ,upper(a.usr_codigo) ");
        buf.append("\t\t\t\t\t,idg.ige_descricao as generoPaciente, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("      from requisicao a ");
        buf.append("      left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("      left join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("      left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("      left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("      left join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("      left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("      join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("      left join usuario usrassina on b.usr_codassina = usrassina.usr_codigo ");
        buf.append("      left join usuario usrdigitador on b.usr_coddigitador = usrdigitador.usr_codigo ");
        buf.append("      left join usuario usrmaterial on b.usr_codmaterial = usrmaterial.usr_codigo ");
        buf.append("      left join usuario usrrecoleta on b.usr_codrecoleta = usrrecoleta.usr_codigo ");
        buf.append("      left join usuario usrrepeticao on b.usr_codrepeticao = usrrepeticao.usr_codigo ");
        buf.append("      left join usuario usrfatura on b.usr_codfatura = usrfatura.usr_codigo ");
        buf.append("      left join usuario usrentrega on b.usr_codentrega = usrentrega.usr_codigo ");
        buf.append("      left join usuario usrimpressao on b.usr_codimpressao = usrimpressao.usr_codigo ");
        buf.append("      left join usuario usrexame on b.usr_codigo = usrexame.usr_codigo ");
        buf.append("      left join usuario usrmapa on b.usr_codigo = usrmapa.usr_codigo ");
        buf.append("      left join usuario usrcortesia on b.usr_codcortesia = usrcortesia.usr_codigo ");
        buf.append("      left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        buf.append("      left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("      left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
        buf.append("      left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("      left join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("      left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("      left join estacoes on a.est_codigo = estacoes.est_codigo ");
        buf.append("      left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
        buf.append("      left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
        buf.append("      left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
        buf.append("      left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
        buf.append("      left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("      left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
        buf.append("      left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
        buf.append("      left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
        buf.append("      left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
        buf.append("      left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        buf.append("      left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
        buf.append("      left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
        buf.append("      left join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
        buf.append("      left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and b.exa_codigo = dtp.exa_codigo and b.mco_codigo = dtp.mco_codigo and tabela.tpe_codigo = dtp.tpe_codigo ");
        buf.append("      left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("      left join prazoentrega prazo on d.fil_codigo = prazo.fil_codigo and d.prz_codigo = prazo.prz_codigo ");
        buf.append("      left join metodologia on d.fil_codigo = metodologia.fil_codigo and d.met_codigo = metodologia.met_codigo ");
        buf.append("      left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("      left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo  and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("      left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("      left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
        buf.append("      left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
        buf.append("      left join cidades cidentidade on ent.fil_codigo = cidentidade.fil_codigo and ent.cid_codigo = cidentidade.cid_codigo ");
        buf.append("      left join bairro baientidade on ent.fil_codigo = baientidade.fil_codigo and ent.bai_codigo = baientidade.bai_codigo ");
        buf.append("      left join conveniospreco cpr on d.fil_codigo = cpr.fil_codigo and convenio.con_codigo = cpr.con_codigo and d.exa_codigo = cpr.exa_codigo and d.mco_codigo = cpr.mco_codigo ");
        buf.append("      left join orcamento orc on a.fil_codigo = orc.fil_codigo and a.orc_codigo = orc.orc_codigo ");
        buf.append("      left join usuario usrorcamento on usrorcamento.usr_codigo = orc.usr_codigo ");
        buf.append("      left join examerequisicaoguiaagrupada b1 on b.fil_codigo = b1.fil_codigo and b.req_codigo = b1.req_codigo and b.exa_codigo = b1.exa_codigo and b.mco_codigo = b1.mco_codigo ");
        buf.append("      left join examematcoleta d1 on b1.fil_codigo = d1.fil_codigo and b1.exa_codfilho = d1.exa_codigo and b1.mco_codfilho = d1.mco_codigo ");
        buf.append("      left join exames c1 on b1.fil_codigo = c1.fil_codigo and b1.exa_codfilho = c1.exa_codigo  ");
        buf.append("      left join materialcoleta coletado1 on d1.fil_codigo = coletado1.fil_codigo and d1.mco_codigo = coletado1.mco_codigo ");
        buf.append("      left join examesetor e on b.fil_codigo = e.fil_codigo and COALESCE(b1.exa_codfilho, b.exa_codigo) = e.exa_codigo and e.ese_default = true ");
        buf.append("      left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
        buf.append("      left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
        buf.append("      left join entidade ep on a.fil_codigo = ep.fil_codigo and a.ent_codempresa = ep.ent_codigo ");
        buf.append("      left join motivorecoleta mr on b.fil_codigo = mr.fil_codigo and b.mrc_codigo = mr.mrc_codigo ");
        buf.append("      left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("    left join detalhetabelaprecometodologia dtm on a.fil_codigo = dtm.fil_codigo and b.exa_codigo = dtm.exa_codigo and b.mco_codigo = dtm.mco_codigo and tabela.tpe_codigo = dtm.tpe_codigo and b.met_codigo = dtm.met_codigo ");
        }
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        return buf.toString();
    }

    private static String pegaMedicamentos(Statement st, String filial, String requisicao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select b.mto_descricao ");
        buf.append("   from requisicaomedicamento a ");
        buf.append("   left join medicamentos b on a.fil_codigo = b.fil_codigo and a.mto_codigo = b.mto_codigo ");
        buf.append("  where a.fil_codigo = ").append(filial);
        buf.append("    and a.req_codigo = ").append(requisicao);
        buf.append("  order by b.mto_descricao ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        buf.setLength(0);
        while (rs.next()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(rs.getString("mto_descricao"));
        }
        return buf.toString();
    }

    public static long getModuloAcesso(int tipoRelatorio, boolean datasDiferenciadas) {
        if (tipoRelatorio == 0) {
            if (datasDiferenciadas) {
                return Long.parseLong("0870100602");
            }
            return Long.parseLong("0870100600");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100700");
        }
        return Long.parseLong("0870100700");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0870100601");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100701");
        }
        return Long.parseLong("0870100701");
    }
}

