/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesFaturadasConvenioDestino
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final String PARAMETROS_REQUISICOESFATURADASCONVENIODESTINO = "RelatorioReqFaturadasConvenioDestino.ultimoFiltro";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_TIPO_DATA = "filtroTipoData";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private final String[] tiposData = new String[]{"Emiss\u00e3o Fat.", "Vencimento Fat.", "Fatura Req."};
    private final String[] ordemRelatorio = new String[]{"C\u00f3digo", "Paciente", "Conv\u00eanio", "Destino"};
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenioRequisicao", "razaoSocialConvenio", "fantasiaConvenioRequisicao", "CodigoFatura", "codigoDestino", "descricaoDestino", "dataEmissaoFatura", "dataVencimentoFatura", "dataConferenciaFatura", "dataInicialFatura", "dataFinalFatura", "usuarioFatura", "quantidadeExamesRequisicao", "valorExamesRequisicao", "valorMaterial", "valorCH", "codigoExamesRequisicao", "valorFaturaRequisicao", "codigoPacienteRequisicao", "nomePacienteRequisicao", "nomeSocialPacienteRequisicao", "codigoRequisicao", "dataFaturaRequisicao", "dataRequisicao", "titularRequisicao", "crmMedicoRequisicao", "ufMedicoRequisicao", "conselhoMedicoRequiscao", "nomeMedicoRequisicao"});

    public RelatorioRequisicoesFaturadasConvenioDestino() {
        this.montaBarraDescricao("Requisi\u00e7\u00f5es faturadas por conv\u00eanio/destino", "Listagem das requisi\u00e7\u00f5es faturadas no per\u00edodo agrupado por conv\u00eanio e destino", "relatorios/rel_fatura_req_convenio_destino.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroTipoData", "Data:", this.tiposData, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordemRelatorio, 0);
        this.setModuloConfigurar(RelatorioRequisicoesFaturadasConvenioDestino.getModuloConfigurar());
        this.setModuloAcesso(RelatorioRequisicoesFaturadasConvenioDestino.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_REQUISICOESFATURADASCONVENIODESTINO);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "convenio"))) {
                this.setSelecionadosFiltro("filtroConvenio", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "destino"))) {
                this.setSelecionadosFiltro("filtroDestino", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "tipodata"))) {
                this.setFiltroCombo("filtroTipoData", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData(FILTRO_DATA_INICIAL, tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData(FILTRO_DATA_FINAL, tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordem"))) {
                this.setFiltroCombo(FILTRO_ORDEM, tmp);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870102500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870102501");
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder(this.getSelectRelatorio());
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equalsIgnoreCase("codigoExamesRequisicao") ? this.getExamesRequisicao(rs.getInt("filCodigoFr"), rs.getInt("filKodigoFr"), rs.getInt("fatCodigoFr"), rs.getInt("reqCodigoFr")) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioRequisicoesFaturadasConvenioDestino.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioRequisicoesFaturadasConvenioDestino.this.panelCentro.removeAll();
                            RelatorioRequisicoesFaturadasConvenioDestino.this.panelCentro.repaint();
                            RelatorioRequisicoesFaturadasConvenioDestino.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    if (filiais != null) {
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
                    if (convenios != null) {
                        for (int i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    String[] destinos = this.getSelecionadosFiltro("filtroDestino", 0);
                    if (destinos != null) {
                        for (int i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    buf.append(this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_INICIAL, buf.toString());
                    buf.delete(0, buf.length());
                    buf.append(this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_DATA_FINAL, buf.toString());
                    buf.delete(0, buf.length());
                    buf.append(this.getFiltroCombo(FILTRO_ORDEM));
                    var.put(FILTRO_ORDEM, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioRequisicoesFaturadasConvenioDestino");
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getSelectRelatorio() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT fat.fat_codigo CodigoFatura, a.req_codigo, c.con_razao razaoSocialConvenio ,d.des_descricao,fat.fat_dtinicio as dataInicialFatura,");
        buf.append("fat.fat_dtfim as dataFinalFatura, fr.fre_total valorFaturaRequisicao,fat.usr_codigo usuarioFatura,a.pac_codigo codigoPacienteRequisicao,");
        buf.append("pac.pac_nome nomePacienteRequisicao,pac.pac_nomesocial nomeSocialPacienteRequisicao,a.req_codigo codigoRequisicao, a.des_codigo codigoDestino, ");
        buf.append("a.req_dtfatura dataFaturaRequisicao,count(fer.exa_codigo) as quantidadeExamesRequisicao,sum(fer.fer_total) as valorExamesRequisicao,");
        buf.append("sum(fer.fer_totalmateriais) as valorMaterial,sum(fer.fer_totalch) as valorCH, '' as codigoExamesRequisicao,");
        buf.append("a.req_data dataRequisicao,a.req_titular titularRequisicao,a.con_codigo codigoConvenioRequisicao,c.con_fantasia fantasiaConvenioRequisicao,");
        buf.append("a.med_crm crmMedicoRequisicao,a.med_uf ufMedicoRequisicao,a.med_conselho conselhoMedicoRequiscao,med.med_nome nomeMedicoRequisicao,d.des_descricao descricaoDestino,");
        buf.append(" fat.fat_dtemis dataEmissaoFatura,fat.fat_dtvenc dataVencimentoFatura, fat.fat_dtconferencia dataConferenciaFatura, ");
        buf.append(" fr.fil_codigo filCodigoFr, fr.fil_kodigo filKodigoFr, fr.fat_codigo fatCodigoFr, fr.req_codigo reqCodigoFr,");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" FROM requisicao a");
        buf.append(" JOIN\t faturarequisicao fr");
        buf.append(" ON a.fil_codigo = fr.fil_codigo");
        buf.append(" AND a.req_codigo = fr.req_codigo");
        buf.append(" JOIN faturaexamerequisicao fer");
        buf.append(" ON fer.fil_codigo = fr.fil_codigo");
        buf.append(" AND fer.fil_kodigo = fr.fil_kodigo");
        buf.append(" AND fer.fat_codigo = fr.fat_codigo");
        buf.append(" AND fer.req_codigo = fr.req_codigo");
        buf.append(" JOIN fatura fat");
        buf.append(" ON fr.fil_codigo = fat.fil_codigo");
        buf.append(" AND fr.fat_codigo = fat.fat_codigo");
        buf.append(" JOIN paciente pac");
        buf.append(" ON pac.fil_codigo = a.fil_codigo");
        buf.append(" AND pac.pac_codigo = a.pac_codigo");
        buf.append(" LEFT JOIN destino d");
        buf.append(" ON d.fil_codigo = fr.fil_codigo");
        buf.append(" AND d.des_codigo = a.des_codigo");
        buf.append(" LEFT JOIN convenios c");
        buf.append(" ON c.fil_codigo = a.fil_codigo");
        buf.append(" AND c.con_codigo = a.con_codigo");
        buf.append(" LEFT JOIN medico med");
        buf.append(" ON a.fil_codigo = med.fil_codigo");
        buf.append(" AND a.med_conselho = med.med_conselho");
        buf.append(" AND a.med_crm = med.med_crm");
        buf.append(" AND a.med_uf = med.med_uf ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" WHERE fat.fat_datacancelamento is null");
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
        String[] destinos = this.getSelecionadosFiltro("filtroDestino", 0);
        if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL)) || !Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
            int indexFiltroTipoData = this.getFiltroComboIndice("filtroTipoData");
            String campoData = "fat.fat_dtemis";
            if (indexFiltroTipoData == 1) {
                campoData = "fat.fat_dtvenc";
            } else if (indexFiltroTipoData == 2) {
                campoData = "a.req_dtfatura";
            }
            if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                buf.append(" AND ").append(campoData).append(" >= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL))).append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
                buf.append(" AND ").append(campoData).append(" <= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL))).append("'");
            }
        }
        if (filiais != null) {
            buf.append(" AND a.fil_codigo in (");
            for (i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        if (convenios != null) {
            buf.append(" AND a.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        if (destinos != null) {
            buf.append(" AND a.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append(StringUtil.textoDBEscape(destinos[i]));
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        }
        String ordem = "a.req_codigo";
        if (this.getFiltroComboIndice(FILTRO_ORDEM) > 0) {
            switch (this.getFiltroComboIndice(FILTRO_ORDEM)) {
                case 1: {
                    ordem = "pac.pac_nome";
                    break;
                }
                case 2: {
                    ordem = "a.con_codigo";
                    break;
                }
                case 3: {
                    ordem = "a.des_codigo";
                    break;
                }
            }
        }
        buf.append(" group by filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco,");
        buf.append(" filial.fil_complemento, filial.fil_cep, filial.fil_fone,");
        buf.append(" filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo,");
        buf.append(" cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo,");
        buf.append(" bairrofilial.bai_descricao, filial.fil_cnes,");
        buf.append(" c.con_codigo, c.con_fantasia,con_razao, a.des_codigo,d.des_descricao, a.req_codigo, ");
        buf.append(" fat_dtemis,fat_dtvenc,fat.fat_dtconferencia,fat.usr_codigo,");
        buf.append(" fr.fre_total,fat.fat_dtinicio,fat.fat_dtfim,fat.fat_codigo,");
        buf.append(" fr.fil_codigo,fr.fil_kodigo,fr.fat_codigo, fr.req_codigo,");
        buf.append(" a.pac_codigo,pac.pac_nome,");
        buf.append(" pac.pac_nomesocial,a.req_dtfatura,a.req_data,a.req_titular,a.con_codigo,");
        buf.append(" a.med_crm, a.med_uf, a.med_conselho, med.med_nome ");
        buf.append(" ORDER BY filial.fil_codigo, c.con_codigo, c.con_fantasia, a.des_codigo, d.des_descricao, ");
        buf.append(ordem);
        this.gravaParametrosUsuario(convenios, filiais, destinos);
        return buf.toString();
    }

    private String getExamesRequisicao(int fil_codigo, int fil_kodigo, int fat_codigo, int req_codigo) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String retornoExames = "";
        try {
            StringBuilder buf = new StringBuilder("SELECT exa_codigo FROM ");
            buf.append("faturaexamerequisicao ");
            buf.append("WHERE ");
            buf.append(" fil_codigo = ").append(fil_codigo);
            buf.append(" AND fil_kodigo = ").append(fil_kodigo);
            buf.append(" AND fat_codigo = ").append(fat_codigo);
            buf.append(" AND req_codigo = ").append(req_codigo);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    retornoExames = retornoExames.length() == 0 ? rs.getString("exa_codigo") : retornoExames + "," + rs.getString("exa_codigo");
                } while (rs.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioRequisicoesFaturadasConvenioDestino");
        }
        return retornoExames;
    }

    private void gravaParametrosUsuario(String[] convenio, String[] filial, String[] destino) {
        int i;
        StringBuilder p = new StringBuilder();
        p.append("<ordem>").append(this.getFiltroCombo(FILTRO_ORDEM)).append("</ordem>");
        p.append("<tipodata>").append(this.getFiltroCombo("filtroTipoData")).append("</tipodata>");
        p.append("<datainicial>").append(this.getFiltroData(FILTRO_DATA_INICIAL)).append("</datainicial>");
        p.append("<datafinal>").append(this.getFiltroData(FILTRO_DATA_FINAL)).append("</datafinal>");
        StringBuilder bufFiltro = new StringBuilder();
        if (filial != null) {
            p.append("<filial>");
            for (i = 0; i < filial.length; ++i) {
                bufFiltro.append(StringUtil.textoDB(filial[i]));
                if (i >= filial.length - 1) continue;
                bufFiltro.append(", ");
            }
        }
        p.append(bufFiltro.toString().replaceAll(" ", "")).append("</filial>");
        bufFiltro.delete(0, bufFiltro.length());
        if (convenio != null) {
            p.append("<convenio>");
            for (i = 0; i < convenio.length; ++i) {
                bufFiltro.append(StringUtil.textoDB(convenio[i]));
                if (i >= convenio.length - 1) continue;
                bufFiltro.append(", ");
            }
        }
        p.append(bufFiltro.toString().replaceAll(" ", "")).append("</convenio>");
        bufFiltro.delete(0, bufFiltro.length());
        if (destino != null) {
            p.append("<destino>");
            for (i = 0; i < destino.length; ++i) {
                bufFiltro.append(StringUtil.textoDB(destino[i]));
                if (i >= destino.length - 1) continue;
                bufFiltro.append(", ");
            }
        }
        p.append(bufFiltro.toString().replaceAll(" ", "")).append("</destino>");
        ParametrosUsuarios.setValor(PARAMETROS_REQUISICOESFATURADASCONVENIODESTINO, p.toString());
        ParametrosUsuarios.salvarParametros(true);
    }
}

