/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesConferenciaGuia
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3d. Exame", "Adi\u00e7\u00e3o Req."};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "tipoUltimoPagamentoRequisicao", "complementoDestinoRequisicao", "quartoRequisicao", "leitoRequisicao", "situacaoExameRequisicao", "entregueParaExameRequisicao", "dataAssinaturaExameRequisicao", "dataDigitacaoExameRequisicao", "dataColetaExameRequisicao", "dataEntregueExameRequisicao", "dataRecoletaExameRequisicao", "motivoRecoletaExameRequisicao", "justificativaMotivoRecoleta", "codigoMotivoRecoleta", "descricaoMotivoRecoleta", "dataRepeticaoExameRequisicao", "dataEtiquetaTriagemExameRequisicao", "naoFaturarExameRequisicao", "urgenteExameRequisicao", "dataImpressaoExameRequisicao", "dataFaturaExameRequisicao", "valorTotalExameRequisicao", "valorExameExameRequisicao", "valorCHExameExameRequisicao", "materialExternoExameRequisicao", "valorFaturarExameRequisicao", "dataEntregaExameRequisicao", "interfaceadoExameRequisicao", "loteReagenteExameRequisicao", "quantidadeReagenteExameRequisicao", "valorCHExameRequisicao", "valorCHExameRequisicaoOriginal", "valorMaterialExameRequisicao", "valorPagoBalcaoExameRequisicao", "dataImpressaoMapaExameRequisicao", "codigoAutorizacaoExameRequisicao", "dataInsercaoExameRequisicao", "observacaoExameRequisicao", "dataCortesiaExameRequisicao", "serialReagenteExameRequisicao", "autorizarExameRequisicao", "tempoJejumExameRequisicao", "descricaoMaterialInformadoExameRequisicao", "observacaoPrazoCarenciaExameRequisicao", "codigosMultiGuias", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoColeta", "descricaoColeta", "complementoColeta", "cepColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoSetor", "descricaoSetor", "responsavelSetor", "siglaSetor", "corSetor", "codigoUsuarioSetor", "nomeUsuarioSetor", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "observacaoConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "normaConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "percentualAcrescimoConvenio", "obrigaValidadeGuiaConvenio", "proibidoWebConvenio", "diasValidadeGuia", "obrigaGuiaConvenio", "cobrarMateriaisConvenio", "ordemFaturaConvenio", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoUsuarioGuiaConferida", "nomeUsuarioGuiaConferida", "codigoExame", "descricaoExame", "sexoExame", "horaEntradaExame", "horaSaidaExame", "proibidoExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "codigoSituacao", "descricaoSituacao", "deveGuiaExameRequisicao", "deveGuiaRequisicao", "dataGuiaExameRequisicao", "guiaExameRequisicao", "validadeGuiaExameRequisicao", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "observacaoMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "avisarPacienteExameRequisicao", "valorCHExameExameRequisicaoOriginal", "tipoLogradouroPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "numeroEnderecoPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoMedico", "totalTaxaRequisicao", "generoPaciente"});

    public RelatorioRequisicoesConferenciaGuia() {
        this.montaBarraDescricao("Relat\u00f3rio requisi\u00e7\u00f5es para conferir guia", "Listagem de requisi\u00e7\u00f5es que ainda devem ser conferidas", "relatorios/rel_requisicao_conferir_guia.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SITUACAO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioRequisicoesConferenciaGuia.getModuloConfigurar());
        this.setModuloAcesso(RelatorioRequisicoesConferenciaGuia.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870101600");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870101601");
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] setores;
            String[] coletas;
            String[] destinos;
            String[] situacao;
            String[] convenios;
            StringBuilder buf = new StringBuilder("Select ");
            buf.append("a.req_codigo as codigoRequisicao, ");
            buf.append("a.req_data as dataRequisicao, ");
            buf.append("a.req_dtfatura as dataFaturaRequisicao, ");
            buf.append("a.req_urgente as urgenteRequisicao, ");
            buf.append("a.req_dataentregaprev as dataEntregaRequisicao, ");
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, ");
            buf.append("a.req_notacaixa as notaCaixaRequisicao, ");
            buf.append("a.req_obs as observacaoRequisicao, ");
            buf.append("a.req_totpago as totalPagoRequisicao, ");
            buf.append("a.req_total as totalRequisicao, ");
            buf.append("a.req_totaltaxa as totalTaxaRequisicao,");
            buf.append("a.req_horaentregaprev as horaEntregaRequisicao, ");
            buf.append("a.req_horafatura as horaFaturaRequisicao, ");
            buf.append("a.req_hora as horaRequisicao, ");
            buf.append("a.req_gestante as gestanteRequisicao, ");
            buf.append("a.req_dum as dumRequisicao, ");
            buf.append("a.req_matricula as matriculaRequisicao, ");
            buf.append("a.req_anomes as anomesIdadeRequisicao, ");
            buf.append("a.req_idade as idadeRequisicao, ");
            buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, ");
            buf.append("a.req_senhaweb as senhaWebRequisicao, ");
            buf.append("a.req_titular as titularRequisicao, ");
            buf.append("a.req_altura as alturaRequisicao, ");
            buf.append("a.req_peso as pesoRequisicao, ");
            buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, ");
            buf.append("a.req_acrescimo as percentualAcrescimoRequisicao, ");
            buf.append("a.req_vlrdesconto as valorDescontoRequisicao, ");
            buf.append("a.req_desconto as percentualDescontoRequisicao, ");
            buf.append("a.req_telacoleta as coletadoRequisicao, ");
            buf.append("a.req_datarequisicao as dataAberturaRequisicao, ");
            buf.append("a.req_neonato as neonatoRequisicao, ");
            buf.append("a.req_validadeguia as validadeGuiaRequisicao, ");
            buf.append("a.req_guia as guiaRequisicao, ");
            buf.append("a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
            buf.append("a.req_complementodestino as complementoDestinoRequisicao, ");
            buf.append("a.req_quarto as quartoRequisicao, ");
            buf.append("a.req_leito as leitoRequisicao, ");
            buf.append("b.exr_situacao as situacaoExameRequisicao, ");
            buf.append("b.exr_entrpara as entregueParaExameRequisicao, ");
            buf.append("b.exr_dataassina as dataAssinaturaExameRequisicao, ");
            buf.append("b.exr_datadigita as dataDigitacaoExameRequisicao, ");
            buf.append("b.exr_datamaterial as dataColetaExameRequisicao, ");
            buf.append("b.exr_dataentreguerst as dataEntregueExameRequisicao, ");
            buf.append("b.exr_datarecoleta as dataRecoletaExameRequisicao, ");
            buf.append("b.exr_motivorecoleta as motivoRecoletaExameRequisicao, ");
            buf.append("b.exr_motivorecoleta as justificativaMotivoRecoleta, ");
            buf.append("mr.mrc_codigo as codigoMotivoRecoleta, ");
            buf.append("mr.mrc_descricao as descricaoMotivoRecoleta, ");
            buf.append("b.exr_datarepeticao as dataRepeticaoExameRequisicao, ");
            buf.append("b.exr_dataetqtriagem as dataEtiquetaTriagemExameRequisicao, ");
            buf.append("b.exr_naofaturar as naoFaturarExameRequisicao, ");
            buf.append("coalesce(b.exr_urgente, false) as urgenteExameRequisicao, ");
            buf.append("b.exr_dataimpresso as dataImpressaoExameRequisicao, ");
            buf.append("b.exr_datafatura as dataFaturaExameRequisicao, ");
            buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorTotalExameRequisicao, ");
            buf.append("calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, false, true, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(") as valorFaturarExameRequisicao, ");
            buf.append("b.exr_vlrexame as valorExameExameRequisicao, ");
            buf.append("b.exr_vlrchexame as valorCHExameExameRequisicaoOriginal, ");
            buf.append("calculachexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameExameRequisicao, ");
            buf.append("b.exr_matexterno as materialExternoExameRequisicao, ");
            buf.append("b.exr_dataentregaprev as dataEntregaExameRequisicao, ");
            buf.append("b.exr_interfaciado as interfaceadoExameRequisicao, ");
            buf.append("b.exr_lotereag as loteReagenteExameRequisicao, ");
            buf.append("b.exr_quantreag as quantidadeReagenteExameRequisicao, ");
            buf.append("b.exr_vlrch as valorCHExameRequisicaoOriginal, ");
            buf.append("calculachconvenio(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo) as valorCHExameRequisicao, ");
            buf.append("b.exr_vlrmaterial as valorMaterialExameRequisicao, ");
            buf.append("b.exr_vlrbalcaoconvenio as valorPagoBalcaoExameRequisicao, ");
            buf.append("b.exr_datamapa as dataImpressaoMapaExameRequisicao, ");
            buf.append("b.exr_codautorizacao as codigoAutorizacaoExameRequisicao, ");
            buf.append("b.exr_data as dataInsercaoExameRequisicao, ");
            buf.append("b.exr_obs as observacaoExameRequisicao, ");
            buf.append("b.exr_datacortesia as dataCortesiaExameRequisicao, ");
            buf.append("b.exr_serialreag as serialReagenteExameRequisicao, ");
            buf.append("b.exr_autorizar as autorizarExameRequisicao, ");
            buf.append("CASE WHEN b.exr_intervalojejum IS NULL THEN TO_CHAR(b.exr_tempojejum, 'HH24:MI') ELSE TO_CHAR(b.exr_intervalojejum, 'HH24:MI') END AS tempoJejumExameRequisicao, ");
            buf.append("b.exr_descricaomaterial as descricaoMaterialInformadoExameRequisicao, ");
            buf.append("b.exr_motivoprazo as observacaoPrazoCarenciaExameRequisicao, ");
            buf.append("a.req_deveguia as deveGuiaRequisicao, ");
            buf.append("b.exr_deveguia as deveGuiaExameRequisicao, ");
            buf.append("b.exr_dataguia as dataGuiaExameRequisicao, ");
            buf.append("b.exr_guia as guiaExameRequisicao, ");
            buf.append("b.exr_validadeguia as validadeGuiaExameRequisicao,");
            buf.append(" b.exr_avisarentrega as avisarPacienteExameRequisicao, ");
            buf.append("'' as codigosMultiGuias, ");
            buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, ");
            buf.append("usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
            buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, ");
            buf.append("usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
            buf.append("destino.des_codigo as codigoDestino, ");
            buf.append("destino.des_descricao as descricaoDestino, ");
            buf.append("destino.des_impressora as impressoraDestino, ");
            buf.append("destino.des_naoimprimir as naoImprimirDestino, ");
            buf.append("destino.des_cep as cepDestino, ");
            buf.append("destino.des_complemento as complementoDestino, ");
            buf.append("destino.des_endereco as enderecoDestino, ");
            buf.append("destino.des_fone as foneDestino, ");
            buf.append("destino.des_enviarweb as enviarWebDestino, ");
            buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ");
            buf.append("ciddestino.cid_nome as descricaoCidadeDestino, ");
            buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
            buf.append("coleta.col_codigo as codigoColeta, ");
            buf.append("coleta.col_descricao as descricaoColeta, ");
            buf.append("coleta.col_complemento as complementoColeta, ");
            buf.append("coleta.col_cep as cepColeta, ");
            buf.append("coleta.col_endereco as enderecoColeta, ");
            buf.append("coleta.col_fone as foneColeta, ");
            buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, ");
            buf.append("cidcoleta.cid_nome as descricaoCidadeColeta, ");
            buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
            buf.append("setor.set_codigo as codigoSetor, ");
            buf.append("setor.set_descricao as descricaoSetor, ");
            buf.append("setor.set_responsavel as responsavelSetor, ");
            buf.append("setor.set_sigla as siglaSetor, ");
            buf.append("setor.set_cor as corSetor, ");
            buf.append("usrsetor.usr_codigo as codigoUsuarioSetor, ");
            buf.append("usrsetor.usr_nome as nomeUsuarioSetor, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_cnpjcpf as cnpjConvenio, ");
            buf.append("d.con_observ as observacaoConvenio, ");
            buf.append("d.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("d.con_fatfmaterial as faturarFaltaMaterialConvenio, ");
            buf.append("d.con_descexame as habilitarDescontoConvenio, ");
            buf.append("d.con_norma as normaConvenio, ");
            buf.append("d.con_multa as multaConvenio, ");
            buf.append("d.con_mora as moraConvenio, ");
            buf.append("d.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("d.con_nr1via as quantidade1ViaConvenio, ");
            buf.append("d.con_nrexames as numeroExamesConvenio, ");
            buf.append("d.con_viasfatura as viasFaturaConvenio, ");
            buf.append("d.con_impbloqueto as imprimirBloquetoConvenio, ");
            buf.append("d.con_nr2via as quantidade2ViaConvenio, ");
            buf.append("d.con_tpcalcfatu as tipoCalculoFaturaConvenio, ");
            buf.append("coalesce(d.con_percpgto, 0) as percentualBalcaoConvenio, ");
            buf.append("d.con_cobrexame as cobrarExameBalcaoConvenio, ");
            buf.append("d.con_inscrest as inscricaoEstadualConvenio, ");
            buf.append("d.con_titdep as titularDependenteConvenio, ");
            buf.append("d.con_maskcart as mascaraCarteiraConvenio, ");
            buf.append("d.con_contato as contatoConvenio, ");
            buf.append("d.con_informarmat as obrigaMatriculaConvenio, ");
            buf.append("d.con_cep as cepConvenio, ");
            buf.append("d.con_complemento as complementoConvenio, ");
            buf.append("d.con_endereco as enderecoConvenio, ");
            buf.append("d.con_numeroendereco as numeroEnderecoConvenio, ");
            buf.append("d.con_tipologradouroendereco as tipoLogradouroConvenio, ");
            buf.append("d.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, ");
            buf.append("d.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("d.con_cepcobranca as cepCobrancaConvenio, ");
            buf.append("d.con_complcobranca as complementoCobrancaConvenio, ");
            buf.append("d.con_endcobranca as enderecoCobrancaConvenio, ");
            buf.append("d.con_fax as faxConvenio, ");
            buf.append("d.con_fone as foneConvenio, ");
            buf.append("d.con_valorfilme as valorFilmeConvenio, ");
            buf.append("d.con_valorch as valorCHConvenio, ");
            buf.append("d.con_site as siteConvenio, ");
            buf.append("d.con_email2 as email2Convenio, ");
            buf.append("d.con_email1 as email1Convenio, ");
            buf.append("d.con_tpcalcch as tipoCalculoCHConvenio, ");
            buf.append("d.con_inscmunic as inscricaoMunicipalConvenio, ");
            buf.append("d.con_bonus as percentualBonusConvenio, ");
            buf.append("d.con_senhaweb as senhaWebConvenio, ");
            buf.append("d.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("d.con_validadeguia as obrigaValidadeGuiaConvenio, ");
            buf.append("d.con_proibidoweb as proibidoWebConvenio, ");
            buf.append("d.con_diasvalidade as diasValidadeGuia, ");
            buf.append("d.con_codigoguia as obrigaGuiaConvenio, ");
            buf.append("d.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("d.con_ordemfatura as ordemFaturaConvenio, ");
            buf.append("cid.cid_codigo as codigoCidadeConvenio, ");
            buf.append("cid.cid_nome as descricaoCidadeConvenio, ");
            buf.append("cid.cid_uf as estadoCidadeConvenio, ");
            buf.append("usr.usr_codigo as codigoUsuarioGuiaConferida, ");
            buf.append("usr.usr_nome as nomeUsuarioGuiaConferida, ");
            buf.append("c.exa_codigo as codigoExame, ");
            buf.append("c.exa_descricao as descricaoExame, ");
            buf.append("c.exa_sexo as sexoExame, ");
            buf.append("c.exa_horaentrada as horaEntradaExame, ");
            buf.append("c.exa_horasaida as horaSaidaExame, ");
            buf.append("c.exa_proibido as proibidoExame, ");
            buf.append("c.exa_idademax as idadeMaximaExame, ");
            buf.append("c.exa_idademin as idadeMinimaExame, ");
            buf.append("c.exa_idademaxtipo as tipoIdadeMaximaExame, ");
            buf.append("c.exa_idademintipo as tipoIdadeMinimaExame, ");
            buf.append("c.exa_proibidoweb as proibidoWebExame, ");
            buf.append("c.exa_qtdeamostras as quantidadeAmostrasExame, ");
            buf.append("sit.sit_codigo as codigoSituacao, ");
            buf.append("sit.sit_descricao as descricaoSituacao, ");
            buf.append("pac.pac_codigo as codigoPaciente, pac.pac_nome as nomePaciente, pac.pac_nomesocial as nomeSocialPaciente, ");
            buf.append("pac.pac_datanasc as dataNascimentoPaciente, pac.pac_sexo as sexoPaciente, ");
            buf.append("pac.pac_vip as vipPaciente, pac.pac_grpsangue as grupoSanguineoPaciente, ");
            buf.append("pac.pac_fatorrh as fatorrhPaciente, pac.pac_fatordu as fatorduPaciente, ");
            buf.append("pac.pac_cor as corPaciente, pac.pac_observ as observacaoPaciente, ");
            buf.append("pac.pac_dadoclinico as dadosClinicosPaciente, pac.pac_peso as pesoPaciente, ");
            buf.append("pac.pac_altura as alturaPaciente, pac.pac_matricconv as matriculaConvenioPaciente, ");
            buf.append("pac.pac_titularconv as titularConvenioPaciente, pac.pac_profissao as profissaoPaciente, ");
            buf.append("pac.pac_fumante as fumantePaciente, pac.pac_diabetico as diabeticoPaciente, ");
            buf.append("pac.pac_rg as rgPaciente, pac.pac_cpf as cpfPaciente, ");
            buf.append("pac.pac_estcivil as estadoCivilPaciente, pac.pac_numfilho as numeroFilhosPaciente, ");
            buf.append("pac.pac_datahora as dataHoraCadastroPaciente, pac.pac_dum as dumPaciente, ");
            buf.append("pac.pac_fax as faxPaciente, pac.pac_celular as celularPaciente, ");
            buf.append("pac.pac_fonecomercial as foneComercialPaciente, pac.pac_fone as fonePaciente, ");
            buf.append("pac.pac_cep as cepPaciente, pac.pac_complemento as complementoPaciente, ");
            buf.append("pac.pac_endereco as enderecoPaciente, pac.pac_numeroendereco as numeroEnderecoPaciente, pac.pac_email as emailPaciente, ");
            buf.append("pac.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
            buf.append("pac.pac_anomes as anomesIdadePaciente, pac.pac_idade as idadePaciente, ");
            buf.append("pac.pac_fonecontato as foneContatoPaciente, pac.pac_nomecontato as contatoPaciente, ");
            buf.append("pac.pac_mae as maePaciente, pac.pac_pai as paiPaciente, ");
            buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
            buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
            buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
            buf.append("med.med_conselho as conselhoMedico, med.med_crm as crmMedico, med.med_uf as ufMedico, med.med_nome as nomeMedico,  ");
            buf.append("med.med_abrev as abreviaturaMedico, med.med_observ as observacaoMedico, med.med_tipo as tipoMedico,  ");
            buf.append("med.med_comissao as comissaoMedico, med.med_cep as cepMedico, med.med_complemento as complementoMedico,  ");
            buf.append("med.med_endereco as enderecoMedico, med.med_celular as celularMedico, med.med_fax as faxMedico,  ");
            buf.append("med.med_numeroendereco as numeroEnderecoMedico, ");
            buf.append("med.med_tipologradouroendereco as tipoLogradouroMedico, ");
            buf.append("med.med_fone as foneMedico, med.med_email as emailMedico, med.med_site as siteMedico, med.med_senhaweb as senhaWebMedico, ");
            buf.append("idg.ige_descricao as generoPaciente, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from requisicao a ");
            buf.append("join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            buf.append("left join medico med on a.fil_codigo = med.fil_codigo and a.med_conselho = med.med_conselho and a.med_crm = med.med_crm and a.med_uf = med.med_uf ");
            buf.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
            buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
            buf.append("left join cidades cidpaciente on pac.fil_codigo = cidpaciente.fil_codigo and pac.cid_codigo = cidpaciente.cid_codigo ");
            buf.append("left join bairro baipaciente on cidpaciente.fil_codigo = baipaciente.fil_codigo and pac.bai_codigo = baipaciente.bai_codigo ");
            buf.append("left join cidades cid on d.fil_codigo = cid.fil_codigo and d.cid_codigo = cid.cid_codigo ");
            buf.append("left join bairro bai on d.fil_codigo = bai.fil_codigo and d.bai_codigo = bai.bai_codigo ");
            buf.append("left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
            buf.append("left join usuario usr on a.usr_codguiaconferida = usr.usr_codigo ");
            buf.append("left join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
            buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
            buf.append("left join usuario usrsetor on setor.usr_codigo = usrsetor.usr_codigo ");
            buf.append("left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
            buf.append("left join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
            buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
            buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
            buf.append("left join motivorecoleta mr on b.fil_codigo = mr.fil_codigo and b.mrc_codigo = mr.mrc_codigo ");
            buf.append("left join identidadegenero idg on coalesce(pac.pac_genero, 0) = idg.ige_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder(" where ");
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
            if (this.getFiltroData(FILTRO_DATA_INICIAL) != null && Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                bufWhere.append(" and a.req_data >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                bufWhere.append("'");
            }
            if (this.getFiltroData(FILTRO_DATA_FINAL) != null && Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                bufWhere.append(" and a.req_data <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                bufWhere.append("'");
            }
            if ((convenios = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0)) != null) {
                bufWhere.append(" and a.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(convenios[i]);
                    bufWhere.append("'");
                    if (i >= convenios.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO, 0)) != null) {
                bufWhere.append(" and a.sit_codigo in (");
                for (int i = 0; i < situacao.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(situacao[i]);
                    bufWhere.append("'");
                    if (i >= situacao.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro(FILTRO_DESTINO, 0)) != null) {
                bufWhere.append(" and a.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0)) != null) {
                bufWhere.append(" and a.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setores = this.getSelecionadosFiltro(FILTRO_SETOR, 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(setores[i]);
                    bufWhere.append("'");
                    if (i >= setores.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            bufWhere.append(" and a.req_excluida = false and b.exr_excluido = false ");
            bufWhere.append(" and (a.req_dataguiaconferida is null or a.usr_codguiaconferida is null )");
            buf.append(bufWhere.toString());
            buf.append(" order by ");
            buf.append(" d.con_fantasia, a.con_codigo, a.req_codigo, ");
            if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[1])) {
                buf.append(" b.exr_ordem ");
            } else {
                buf.append(" b.exa_codigo");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("sexoPaciente")) {
                            o[i] = Tipos.tipoSexo(rs.getString(campos[i]));
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("estadoCivilPaciente")) {
                            o[i] = Tipos.tipoEstadoCivil(rs.getString(campos[i]));
                            continue;
                        }
                        if (campos[i].equals("codigosMultiGuias")) {
                            Object[] filhas = RecepcaoUtil.verificaMultiGuias(st2, rs.getString("codigoFilial"), rs.getString("codigoRequisicao"), false);
                            if (filhas != null) {
                                o[i] = Arrays.toString(filhas);
                                continue;
                            }
                            o[i] = null;
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioRequisicoesConferenciaGuia.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioRequisicoesConferenciaGuia.this.panelCentro.removeAll();
                            RelatorioRequisicoesConferenciaGuia.this.panelCentro.repaint();
                            RelatorioRequisicoesConferenciaGuia.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (int i = 0; i < convenios.length; ++i) {
                            buf.append(convenios[i]);
                            if (i >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (situacao != null) {
                        for (int i = 0; i < situacao.length; ++i) {
                            buf.append(situacao[i]);
                            if (i >= situacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SITUACAO, buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (int i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_DESTINO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (int i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    buf.delete(0, buf.length());
                    if (setores != null) {
                        for (int i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SETOR, buf.toString());
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioRequisicoesConferenciaGuia");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }
}

