/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class RelatorioPercentualExamesFaturados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_AGRUPAR_SETOR = "filtroAgruparSetor";
    private final String FILTRO_AGRUPAR_CIDADE = "filtroAgruparCidade";
    private final String FILTRO_VENCIMENTO = "filtrarVencimento";
    protected static String[] campos;

    public RelatorioPercentualExamesFaturados() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "quantidadeRequisicoes", "percentualExames", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoSetor", "descricaoSetor", "quantidadeExames"});
        this.montaBarraDescricao("Relat\u00f3rio de percentual de exames faturados", "Demonstrativo do percentual correspondente aos exames faturados por per\u00edodo apresentando por conv\u00eanios", "relatorios/rel_percentual_exames_faturados.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroAgruparCidade", "Agrupar por cidade", false);
        this.adicionaFiltroCheck("filtroAgruparSetor", "Agrupar por setor", false);
        this.adicionaFiltroCheck("filtrarVencimento", "Filtrar por vencimento", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPercentualExamesFaturados.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] exames;
            String[] coletas;
            String[] estacoes;
            String[] setor;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("0.0 as percentualExame, ");
            buf.append("0.0 as quantidadeRequisicoes, ");
            buf.append("cid.cid_codigo as codigoCidadeConvenio, ");
            buf.append("cid.cid_nome as descricaoCidadeConvenio, ");
            buf.append("cid.cid_uf as estadoCidadeConvenio ");
            if (this.getFiltroCheck("filtroAgruparSetor")) {
                buf.append(", e.set_codigo as codigoSetor, ");
                buf.append("f.set_descricao as descricaoSetor ");
            }
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from faturaexamerequisicao a ");
            buf.append("join faturarequisicao fat on a.fil_codigo = fat.fil_codigo and a.fat_codigo = fat.fat_codigo and a.fil_kodigo = a.fil_kodigo and a.req_codigo = fat.req_codigo ");
            buf.append("join fatura fa on fat.fil_codigo = fa.fil_codigo and fat.fat_codigo = fa.fat_codigo ");
            buf.append("join requisicao b on fat.fil_kodigo = b.fil_codigo and fat.req_codigo = b.req_codigo ");
            buf.append("left join convenios d on a.fil_kodigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("left join cidades cid on d.fil_codigo = cid.fil_codigo and d.cid_codigo = cid.cid_codigo ");
            buf.append("left join examesetor e on a.fil_kodigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            bufWhere.append(" and fa.fat_datacancelamento is null ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and d.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(setor[i]);
                    bufWhere.append("'");
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((estacoes = this.getSelecionadosFiltro("filtroEstacao", 0)) != null) {
                bufWhere.append(" and b.est_codigo in (");
                for (int i = 0; i < estacoes.length; ++i) {
                    bufWhere.append(estacoes[i]);
                    if (i >= estacoes.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                bufWhere.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(exames[i]);
                    bufWhere.append("'");
                    if (i >= exames.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            boolean filtrarVencimento = this.getFiltroCheck("filtrarVencimento");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and fa.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and fa.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao, ");
            buf.append("cid.cid_codigo, cid.cid_nome, cid.cid_uf ");
            if (this.getFiltroCheck("filtroAgruparSetor")) {
                buf.append(", e.set_codigo, f.set_descricao ");
            }
            buf.append(" order by ");
            if (this.getFiltroCheck("filtroAgruparCidade")) {
                buf.append("cid.cid_codigo, ");
            }
            if (this.getFiltroCheck("filtroAgruparSetor")) {
                buf.append("e.set_codigo, ");
            }
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.con_fantasia");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("quantidadeExames");
            } else {
                buf.append("d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int totalExames = 0;
                do {
                    totalExames += rs.getInt("quantidadeExames");
                } while (rs.next());
                rs.first();
                String[] colunas = new String[rs.getMetaData().getColumnCount()];
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    colunas[i - 1] = rs.getMetaData().getColumnName(i);
                }
                ModeloGridTable modelo = new ModeloGridTable(colunas);
                do {
                    Object[] o = new Object[colunas.length];
                    for (int i = 0; i < colunas.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, colunas[i]) <= -1) continue;
                        o[i] = colunas[i].equalsIgnoreCase("percentualExame") ? Double.valueOf(totalExames > 0 ? rs.getDouble("quantidadeExames") * 100.0 / (double)totalExames : 0.0) : (colunas[i].equalsIgnoreCase("quantidadeRequisicoes") ? Integer.valueOf(this.quantidadeRequisicoes(st2, rs.getString("codigoConvenio"), this.getFiltroCheck("filtroAgruparSetor") ? rs.getString("codigoSetor") : "", filtrarVencimento)) : rs.getObject(colunas[i]));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioPercentualExamesFaturados.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioPercentualExamesFaturados.this.panelCentro.removeAll();
                            RelatorioPercentualExamesFaturados.this.panelCentro.repaint();
                            RelatorioPercentualExamesFaturados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtrarVencimento", this.getFiltroCheck("filtrarVencimento") ? "data de vencimento" : "data de emiss\u00e3o");
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (estacoes != null) {
                        for (i = 0; i < estacoes.length; ++i) {
                            buf.append(estacoes[i]);
                            if (i >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (exames != null) {
                        for (i = 0; i < exames.length; ++i) {
                            buf.append(exames[i]);
                            if (i >= exames.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    if (!this.getFiltroCheck("filtroAgruparCidade")) {
                        rel.removerBandaCabecalhoGrupo("BandaGrupoCidade");
                    }
                    if (!this.getFiltroCheck("filtroAgruparSetor")) {
                        rel.removerBandaCabecalhoGrupo("bandaSetor");
                    }
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880101100");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880101101");
    }

    private int quantidadeRequisicoes(Statement st, String convenio, String setor, boolean filtrarPorVencimento) throws Exception {
        String[] exames;
        String[] coletas;
        int retorno = 0;
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct a.req_codigo) as quantidadeRequisicoes ");
        buf.append("from faturaexamerequisicao a ");
        buf.append("join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.fil_kodigo = b.fil_kodigo and a.fat_codigo = b.fat_codigo ");
        buf.append("join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append("left join requisicao c on b.fil_codigo = c.fil_codigo and b.req_codigo = c.req_codigo ");
        buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
        StringBuilder bufWhere = new StringBuilder();
        bufWhere.append("where a.fil_codigo = ");
        bufWhere.append(Variaveis.filialPadrao);
        bufWhere.append(" and fat.con_codigo = ").append(convenio);
        bufWhere.append(" and fat.fat_datacancelamento is null ");
        String[] setores = this.getSelecionadosFiltro("filtroSetor", 0);
        if (this.getFiltroCheck("filtroAgruparSetor") && !Funcoes.textoVazio(setor)) {
            bufWhere.append(" and e.set_codigo = ").append(setor);
        } else if (setores != null) {
            bufWhere.append(" and e.set_codigo in (");
            for (int i = 0; i < setores.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(setores[i]);
                bufWhere.append("'");
                if (i >= setores.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        String[] estacoes = this.getSelecionadosFiltro("filtroEstacao", 0);
        if (estacoes != null) {
            bufWhere.append(" and c.est_codigo in (");
            for (int i = 0; i < estacoes.length; ++i) {
                bufWhere.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
            bufWhere.append(" and c.col_codigo in (");
            for (int i = 0; i < coletas.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(coletas[i]);
                bufWhere.append("'");
                if (i >= coletas.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
            bufWhere.append(" and a.exa_codigo in (");
            for (int i = 0; i < exames.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(exames[i]);
                bufWhere.append("'");
                if (i >= exames.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            bufWhere.append(" and fat.").append(filtrarPorVencimento ? "fat_dtvenc" : "fat_dtemis").append(" >= '");
            bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
            bufWhere.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            bufWhere.append(" and fat.").append(filtrarPorVencimento ? "fat_dtvenc" : "fat_dtemis").append(" <= '");
            bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
            bufWhere.append("'");
        }
        buf.append(bufWhere.toString());
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }
}

