/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFaturamentoAcumulado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private String[] ordem = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social", "Cidade", "Estado"};
    private final String[] estados = ArraysUtil.concatenar(new String[]{"Todos"}, ConstantesGerais.ESTADOS);
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_ESTADO = "filtroEstado";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_VENCIMENTO = "filtrarVencimento";
    private final String FILTRO_ESTORNADAS = "filtrarEstornadas";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    protected static String[] campos;

    public RelatorioFaturamentoAcumulado() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "codigoCidadeConvenio", "nomeCidadeConvenio", "estadoCidadeConvenio", "totalMateriais", "totalExames", "totalCH", "totalFatura", "quantidadeRequisicoes", "quantidadeExames", "totalAdicionais", "totalDespesasCobranca"});
        this.montaBarraDescricao("Relat\u00f3rio faturamento acumulado por conv\u00eanio", "Listagem das faturas acumuladas no per\u00edodo", "relatorios/rel_financeiro_fat_acumulado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("filtroEstado", "Estado:", this.estados, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtrarVencimento", "Filtrar por vencimento", false);
        this.adicionaFiltroCheck("filtrarEstornadas", "Filtrar apenas estornadas", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioFaturamentoAcumulado.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            boolean filtrarEstornadas;
            String[] destino;
            String[] coleta;
            String[] convenio;
            String[] cidade;
            StringBuilder buf = new StringBuilder();
            buf.append("select sum(fer.fer_totalmateriais) as totalMateriais, ");
            buf.append("       sum(fer.fer_total)          as totalExames, ");
            buf.append("       sum(fer.fer_totalch)        as totalCH,");
            buf.append("       sum(fer.fer_total + fer.fer_totalmateriais ) as totalFatura, ");
            buf.append("\t\t\t a.fat_totalmateriais as valor_materiais, ");
            buf.append("\t\t\t a.fat_totalexames as valor_exames, ");
            buf.append("\t\t\t a.fat_adicional as valor_adicional, ");
            buf.append("\t\t\t a.fat_despcobranca as valor_desp_cobranca, ");
            buf.append("\t\t\t a.fat_percdesconto as perc_desconto, ");
            buf.append("       count(distinct cast(req.fil_codigo as text)||req.req_codigo) as quantidadeRequisicoes, ");
            buf.append("       count(distinct cast(req.fil_codigo as text)||req.req_codigo||fer.exa_codigo) as quantidadeExames, ");
            buf.append("       sum(a.fat_adicional)     / count(fre.*) as totalAdicionais, ");
            buf.append("       sum(a.fat_despcobranca)  / count(fre.*) as totalDespesasCobranca, ");
            buf.append("       d.con_fantasia as fantasiaConvenio, ");
            buf.append("       d.con_codigo as codigoConvenio, ");
            buf.append("       d.con_razao as razaoSocialConvenio, ");
            buf.append("       cid.cid_codigo as codigoCidadeConvenio, ");
            buf.append("       cid.cid_nome as nomeCidadeConvenio, ");
            buf.append("       cid.cid_uf as estadoCidadeConvenio, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from fatura a  ");
            buf.append("left join faturarequisicao fre on a.fil_codigo = fre.fil_codigo and a.fat_codigo = fre.fat_codigo  ");
            buf.append("left join requisicao req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo and fre.con_codigo = req.con_codigo ");
            buf.append("left join faturaexamerequisicao fer on req.fil_codigo = fer.fil_kodigo and req.req_codigo = fer.req_codigo and a.fat_codigo = fer.fat_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            buf.append("left join cidades cid on d.fil_codigo = cid.fil_codigo and d.cid_codigo = cid.cid_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where ");
            String[] filial = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filial != null) {
                bufWhere.append(" a.fil_codigo in (");
                for (int i = 0; i < filial.length; ++i) {
                    bufWhere.append(filial[i]);
                    if (i >= filial.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            } else {
                bufWhere.append(" a.fil_codigo = ").append(Variaveis.filialPadrao);
            }
            bufWhere.append(" and req.req_excluida = false");
            String estado = this.getFiltroCombo("filtroEstado").toString();
            if (!estado.equals(this.estados[0])) {
                bufWhere.append(" and cid.cid_uf = '").append(estado).append("' ");
            }
            if ((cidade = this.getSelecionadosFiltro("filtroCidade", 0)) != null) {
                bufWhere.append(" and d.cid_codigo in (");
                for (int i = 0; i < cidade.length; ++i) {
                    bufWhere.append(cidade[i]);
                    if (i >= cidade.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                bufWhere.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coleta = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and req.col_codigo in ('");
                for (int i = 0; i < coleta.length; ++i) {
                    bufWhere.append(coleta[i]);
                    if (i >= coleta.length - 1) continue;
                    bufWhere.append("', '");
                }
                bufWhere.append("')");
            }
            if ((destino = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and req.des_codigo in ('");
                for (int i = 0; i < destino.length; ++i) {
                    bufWhere.append(destino[i]);
                    if (i >= destino.length - 1) continue;
                    bufWhere.append("', '");
                }
                bufWhere.append("')");
            }
            boolean filtrarVencimento = this.getFiltroCheck("filtrarVencimento");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            if (filtrarEstornadas = this.getFiltroCheck("filtrarEstornadas")) {
                bufWhere.append(" and a.usr_codcancelamento is not null and a.fat_datacancelamento is not null");
            } else {
                bufWhere.append("  and a.fat_datacancelamento is null");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by a.fil_codigo, filial.fil_codigo, ");
            buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append("cid.cid_codigo, cid.cid_nome, cid.cid_uf, ");
            buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
            buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
            buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao, ");
            buf.append("a.fat_totalmateriais, a.fat_totalexames,  a.fat_adicional,  a.fat_despcobranca, a.fat_percdesconto ");
            buf.append(" order by a.fil_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.con_fantasia ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("d.con_razao ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append(" cid.cid_nome ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append(" cid.cid_uf ");
            } else {
                buf.append("d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equals("totalFatura")) {
                            BigDecimal valorMateriais = rs.getBigDecimal("valor_materiais");
                            BigDecimal valorExames = rs.getBigDecimal("valor_exames");
                            BigDecimal valorAdicional = rs.getBigDecimal("valor_adicional");
                            BigDecimal valorDespCobranca = rs.getBigDecimal("valor_desp_cobranca");
                            BigDecimal percDesconto = rs.getBigDecimal("perc_desconto");
                            BigDecimal totalFatura = RelatorioFaturamentoAcumulado.calculaTotalFatura(valorMateriais, valorExames, valorAdicional, valorDespCobranca, percDesconto);
                            o[i] = totalFatura;
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioFaturamentoAcumulado.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioFaturamentoAcumulado.this.panelCentro.removeAll();
                            RelatorioFaturamentoAcumulado.this.panelCentro.repaint();
                            RelatorioFaturamentoAcumulado.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroEstado", estado);
                    var.put("filtrarVencimento", this.getFiltroCheck("filtrarVencimento") ? "Vencimento" : "Emiss\u00e3o");
                    buf.delete(0, buf.length());
                    if (filial != null) {
                        for (int i = 0; i < filial.length; ++i) {
                            buf.append(filial[i]);
                            if (i >= filial.length - 1) continue;
                            buf.append(", ");
                        }
                    } else {
                        buf.append(Variaveis.filialPadrao);
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (int i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (cidade != null) {
                        for (int i = 0; i < cidade.length; ++i) {
                            buf.append(cidade[i]);
                            if (i >= cidade.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        for (int i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destino != null) {
                        for (int i = 0; i < destino.length; ++i) {
                            buf.append(destino[i]);
                            if (i >= destino.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioFaturamentoAcumulado");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static BigDecimal calculaTotalFatura(BigDecimal valorMateriais, BigDecimal valorExames, BigDecimal valorAdicional, BigDecimal valorDespCobranca, BigDecimal percDesconto) throws SQLException {
        BigDecimal valorBruto = new BigDecimal(0);
        BigDecimal valorDesconto = new BigDecimal(0);
        BigDecimal totalExames = new BigDecimal(0);
        valorMateriais = valorMateriais.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        valorExames = valorExames.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        valorBruto = valorExames.add(valorMateriais);
        valorDesconto = valorBruto.multiply(percDesconto).divide(new BigDecimal(100));
        totalExames = valorBruto.subtract(valorDesconto).add(valorAdicional).add(valorDespCobranca).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        return totalExames;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870100100");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0870100101");
    }
}

