/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class RelatorioExamesFaturadosDestino
extends FrmRelPadrao {
    private String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo AMB", "Qtde Exames"};
    private final String FILTRO_FATURA = "filtroFatura";
    private final String FILTRO_ORDEM = "filtroOrdem";
    protected static String[] campos;

    public RelatorioExamesFaturadosDestino() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "codigoDestino", "descricaoDestino", "dataEmissaoFatura", "dataVencimentoFatura", "dataConferenciaFatura", "dataInicialFatura", "dataFinalFatura", "valorExame", "valorMaterial", "valorCH", "codigoExame", "descricaoExame", "codigoAMB", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "quantidadeExames", "quantidadeRequisicoes"});
        this.montaBarraDescricao("Relat\u00f3rio exames faturados por destino", "Listagem dos exames faturados no per\u00edodo agrupado por destino", "relatorios/rel_exames_faturados_destino.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa("filtroFatura", "Fatura", 5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp;
                Hashtable hash = Pesquisas.fatura(RelatorioExamesFaturadosDestino.this.getTopLevelAncestor());
                if (hash != null && (tmp = hash.get("fat_codigo").toString()) != null) {
                    RelatorioExamesFaturadosDestino.this.setFiltroComPesquisa("filtroFatura", tmp);
                }
            }
        }, 1);
        this.adicionaFiltroCombo("filtroOrdem", "Ordem", this.ordem, 0);
        this.setModuloConfigurar(RelatorioExamesFaturadosDestino.getModuloConfigurar());
        this.setModuloAcesso(RelatorioExamesFaturadosDestino.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (Funcoes.textoVazio(this.getFiltroComPesquisa("filtroFatura"))) {
            Funcoes.mensagem(this, "O c\u00f3digo da fatura deve ser informado", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        System.gc();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("sum(a.fer_total) as valorExame, ");
            buf.append("sum(a.fer_totalch) as valorCH, ");
            buf.append("sum(a.fer_totalmateriais) as valorMaterial, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("fat.fat_dtinicio as dataInicialFatura, ");
            buf.append("fat.fat_dtfim as dataFinalFatura, ");
            buf.append("fat.fat_dtemis as dataEmissaoFatura, ");
            buf.append("fat.fat_dtvenc as dataVencimentoFatura, ");
            buf.append("fat.fat_dtconferencia as dataConferenciaFatura, ");
            buf.append("des.des_codigo as codigoDestino, ");
            buf.append("des.des_descricao as descricaoDestino, ");
            buf.append("c.exa_codigo as codigoExame, ");
            buf.append("c.exa_descricao as descricaoExame, ");
            buf.append("a.mco_codfilho as codigoMaterialColetado, ");
            buf.append("m.mco_descricao as descricaoMaterialColetado, ");
            buf.append("m.mco_abreviatura as abreviaturaMaterialColetado, ");
            buf.append("'' as codigoAMB, ");
            buf.append(" exr.met_codigo as codigoMetodologia, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from faturaexamerequisicao a ");
            buf.append("join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fil_kodigo = b.fil_kodigo and a.fat_codigo = b.fat_codigo and a.req_codigo = b.req_codigo ");
            buf.append("join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
            buf.append("join exames c on a.fil_kodigo = c.fil_codigo and a.exa_codfilho = c.exa_codigo ");
            buf.append(" join examerequisicao exr on a.fil_kodigo = exr.fil_codigo and a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo ");
            buf.append("left join requisicao req on a.fil_kodigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
            buf.append("left join destino des on b.fil_kodigo = des.fil_codigo and req.des_codigo = des.des_codigo\t");
            buf.append("left join convenios d on fat.fil_codigo = d.fil_codigo and fat.con_codigo = d.con_codigo ");
            buf.append("left join materialcoleta m on a.fil_kodigo = m.fil_codigo and a.mco_codfilho = m.mco_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo = ");
            bufWhere.append(Variaveis.filialPadrao);
            bufWhere.append(" and fat.fat_datacancelamento is null ");
            if (!Funcoes.textoVazio(this.getFiltroComPesquisa("filtroFatura"))) {
                bufWhere.append(" and fat.fat_codigo = '");
                bufWhere.append(this.getFiltroComPesquisa("filtroFatura"));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by filial.fil_codigo, ");
            buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
            buf.append("filial.fil_fax, filial.fil_razaosocial, des.des_codigo, des.des_descricao, cidadefilial.cid_codigo, ");
            buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append("bairrofilial.bai_descricao, filial.fil_cnes, fat.fat_dtinicio, fat.fat_dtfim,");
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao, fat.fat_dtemis, fat.fat_dtvenc, fat.fat_dtconferencia, ");
            buf.append("c.exa_codigo, c.exa_descricao, a.mco_codfilho, m.mco_descricao, m.mco_abreviatura, a.fil_codigo, exr.met_codigo ");
            buf.append("order by des.des_codigo, ");
            if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[1])) {
                buf.append("c.exa_descricao ");
            } else {
                buf.append("c.exa_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            System.gc();
            if (rs.next()) {
                int colunaExa;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("quantidadeRequisicoes") ? Integer.valueOf(this.quantidadeRequisicoesPorConvenio(st2, bufWhere.toString(), rs.getString("codigoExame"), rs.getString("codigoMaterialColetado"), rs.getString("codigoDestino"), rs.getString("codigoMetodologia"))) : (campos[i].equals("codigoAMB") ? ExameUtil.getCodigoAMB(rs.getString("codigoFilial"), rs.getString("codigoExame"), rs.getInt("codigoMaterialColetado"), rs.getInt("codigoConvenio"), rs.getInt("codigoMetodologia")) : rs.getObject(campos[i]));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                int codigoDestino = modelo.findColumn("codigoDestino");
                int codigoFilial = modelo.findColumn("codigoFilial");
                if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[2])) {
                    int colunaAMB = modelo.findColumn("codigoAMB");
                    if (colunaAMB > -1 || codigoDestino > -1 || codigoFilial > -1) {
                        modelo.ordenarColuna(codigoFilial, 1, false);
                        modelo.ordenarColuna(colunaAMB, 1, false);
                        modelo.ordenarColuna(codigoDestino, 1, false);
                    }
                } else if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[3]) && (colunaExa = modelo.findColumn("quantidadeExames")) > -1 && codigoDestino > -1 && codigoFilial > -1) {
                    modelo.ordenarColuna(codigoFilial, 1, false);
                    modelo.ordenarColuna(colunaExa, 1, false);
                    modelo.ordenarColuna(codigoDestino, 1, false);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesFaturadosDestino.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesFaturadosDestino.this.panelCentro.removeAll();
                            RelatorioExamesFaturadosDestino.this.panelCentro.repaint();
                            RelatorioExamesFaturadosDestino.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    buf.delete(0, buf.length());
                    buf.append(this.getFiltroComPesquisa("filtroFatura"));
                    var.put("filtroFatura", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioBPA");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int quantidadeRequisicoesPorConvenio(Statement st, String filtro, String exame, String material, String destino, String codigoMetodologia) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(b.req_codigo) as quantidadeRequisicoes ");
        buf.append("from faturarequisicao b ");
        buf.append("join faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fil_kodigo = c.fil_kodigo and b.fat_codigo = c.fat_codigo and b.req_codigo = c.req_codigo ");
        buf.append("join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append("join requisicao req on b.fil_kodigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
        buf.append("join destino des on b.fil_kodigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
        if (!Funcoes.textoVazio(codigoMetodologia)) {
            buf.append(" left join examerequisicao exr on c.fil_kodigo = exr.fil_codigo and c.req_codigo = exr.req_codigo and c.exa_codfilho = exr.exa_codigo and c.mco_codfilho = exr.mco_codigo ");
        }
        buf.append("where b.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and fat.fat_datacancelamento is null ");
        if (!Funcoes.textoVazio(this.getFiltroData("filtroFatura"))) {
            buf.append(" and fat.fat_codigo = '");
            buf.append(this.getFiltroData("filtroFatura"));
            buf.append("'");
        }
        if (!Funcoes.textoVazio(exame)) {
            buf.append(" and c.exa_codfilho = '").append(exame).append("'");
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and c.mco_codfilho = ").append(material);
        }
        if (!Funcoes.textoVazio(destino)) {
            buf.append(" and des.des_codigo= '").append(destino).append("'");
        }
        if (!Funcoes.textoVazio(codigoMetodologia)) {
            buf.append(" and exr.met_codigo = ").append(codigoMetodologia);
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870102400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870102401");
    }
}

