/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioExamesFaturados
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo A.M.B"};
    private String[] camposData = new String[]{"Emiss\u00e3o Fat.", "Vencimento Fat.", "Fatura Req."};
    private String[] agrupamento = new String[]{"N\u00e3o agrupar", "C\u00f3digo exame", "C\u00f3digo A.M.B"};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPO_DATA = "filtroTipoData";
    private final String FILTRO_AGRUPAMENTO = "filtroAgrupamento";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_ESTORNADAS = "filtrarEstornadas";
    protected static String[] campos;
    public static final int TIPO_CONVENIO = 1;
    public static final int TIPO_MEDICO = 2;
    private final String OPCOES_SALVAS = "relatorioExamesFaturados.filtroExameAgrupado";
    private int tipoRelatorio = 1;

    public RelatorioExamesFaturados(int tipo) {
        this.tipoRelatorio = tipo;
        if (this.tipoRelatorio == 1) {
            campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "codigoExame", "descricaoExame", "codigoAMB", "codigoMaterialColeta", "descricaoMaterialColeta", "abreviaturaMaterialColeta", "quantidadeExames", "quantidadeRequisicoes", "quantidadeTotalRequisicoesPorConvenio", "quantidadeGeralRequisicoes"});
            this.montaBarraDescricao("Relat\u00f3rio exames faturados por conv\u00eanio", "Listagem dos exames faturados no per\u00edodo agrupado por conv\u00eanio", "relatorios/rel_exames_faturados_convenio.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio exames faturados por m\u00e9dico", "Listagem dos exames faturados no per\u00edodo agrupado por m\u00e9dico", "relatorios/rel_exames_faturados_medico.jpg");
            campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "valorExame", "valorMaterial", "valorCH", "codigoExame", "descricaoExame", "codigoAMB", "codigoMaterialColeta", "descricaoMaterialColeta", "abreviaturaMaterialColeta", "quantidadeExames", "quantidadeRequisicoes", "quantidadeTotalRequisicoesPorConvenio", "quantidadeTotalRequisicoesPorMedico", "quantidadeGeralRequisicoes"});
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSituacao", "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (this.tipoRelatorio == 2) {
            this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "Uf", "Nome"}, new int[]{30, 70, 30, 0}, false, new int[]{0, 1, 2});
        }
        this.adicionaFiltroCombo("filtroTipoData", "Data:", this.camposData, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        String vlrFiltroAgrSalvo = StringUtil.getValor(ParametrosUsuarios.getValor("relatorioExamesFaturados.filtroExameAgrupado"), "filtroAgrupado");
        int opc = vlrFiltroAgrSalvo.matches("\\d+") ? Integer.parseInt(vlrFiltroAgrSalvo) : (vlrFiltroAgrSalvo.equalsIgnoreCase("true") ? 1 : 0);
        this.adicionaFiltroCombo("filtroAgrupamento", "Agrupar por:", this.agrupamento, opc);
        this.adicionaFiltroCheck("filtrarEstornadas", "Filtrar apenas estornadas", false);
        this.setModuloConfigurar(this.getModuloConfigurar(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioExamesFaturados.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        System.gc();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder xml = new StringBuilder("<relatorioExamesFaturados><filtroAgrupado>");
        xml.append(this.getFiltroComboIndice("filtroAgrupamento"));
        xml.append("</filtroAgrupado></relatorioExamesFaturados>");
        ParametrosUsuarios.setValor("relatorioExamesFaturados.filtroExameAgrupado", xml.toString());
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String campoData;
            String[] coletas;
            String[] destinos;
            String[] situacoes;
            String[] setores;
            StringBuilder buf = new StringBuilder();
            if (this.tipoRelatorio == 2 || this.getFiltroCombo("filtroTipoData").equals(this.camposData[2]) || this.getSelecionadosFiltro("filtroSituacao", 0) != null && this.getSelecionadosFiltro("filtroSituacao", 0).length > 0 && this.tipoRelatorio == 1) {
                buf.append("select count(distinct req.req_codigo) as quantidadeExames, ");
            } else if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[2])) {
                buf.append("select count(dtp.dtp_codamb) as quantidadeExames, ");
            } else {
                buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            }
            buf.append("sum(a.fer_total) as valorExame, ");
            buf.append("sum(a.fer_totalch) as valorCH, ");
            buf.append("sum(a.fer_totalmateriais) as valorMaterial, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append(" exr.met_codigo as codigoMetodologia, ");
            }
            if (this.tipoRelatorio == 2) {
                buf.append("med.med_conselho as conselhoMedico, ");
                buf.append("med.med_crm as crmMedico, ");
                buf.append("med.med_uf as ufMedico, ");
                buf.append("med.med_nome as nomeMedico, ");
            }
            if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0])) {
                buf.append("cfilho.exa_codigo as codigoExame, ");
                buf.append("cfilho.exa_descricao as descricaoExame, ");
                buf.append("mfilho.mco_codigo as codigoMaterialColeta, ");
                buf.append("mfilho.mco_descricao as descricaoMaterialColeta, ");
                buf.append("mfilho.mco_abreviatura as abreviaturaMaterialColeta, ");
                buf.append("'' as codigoAMB, ");
            } else if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[1])) {
                buf.append("a.exa_codigo as codigoExame, ");
                buf.append("c.exa_descricao as descricaoExame, ");
                buf.append("a.mco_codigo as codigoMaterialColeta, ");
                buf.append("m.mco_descricao as descricaoMaterialColeta, ");
                buf.append("m.mco_abreviatura as abreviaturaMaterialColeta, ");
                buf.append("'' as codigoAMB, ");
            } else if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[2])) {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" COALESCE(dtm.dtm_codamb, dtp.dtp_codamb) as codigoAMB, ");
                } else {
                    buf.append("dtp.dtp_codamb as codigoAMB, ");
                }
                buf.append("a.exa_codigo as codigoExame, ");
                buf.append("c.exa_descricao as descricaoExame, ");
                buf.append("'' as codigoMaterialColeta, ");
                buf.append("'' as descricaoMaterialColeta, ");
                buf.append("'' as abreviaturaMaterialColeta, ");
            }
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from faturaexamerequisicao a ");
            buf.append("join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fil_kodigo = b.fil_kodigo and a.fat_codigo = b.fat_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" join examerequisicao exr on a.fil_kodigo = exr.fil_codigo and a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo ");
            buf.append("left join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
            buf.append("left join exames c on a.fil_kodigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and fat.con_codigo = d.con_codigo ");
            if (this.tipoRelatorio == 2 || this.getFiltroCombo("filtroTipoData").equals(this.camposData[2]) || this.getSelecionadosFiltro("filtroSituacao", 0) != null && this.getSelecionadosFiltro("filtroSituacao", 0).length > 0 || this.tipoRelatorio == 1) {
                buf.append("left join requisicao req on b.fil_kodigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
            }
            if (this.tipoRelatorio == 2) {
                buf.append("left join medico med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
            }
            buf.append("left join materialcoleta m on a.fil_kodigo = m.fil_codigo and a.mco_codigo = m.mco_codigo ");
            buf.append("left join examesetor es on a.fil_kodigo = es.fil_codigo and a.exa_codigo = es.exa_codigo and es.ese_default = true ");
            if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0])) {
                buf.append("left join exames cfilho on a.fil_kodigo = cfilho.fil_codigo and a.exa_codfilho = cfilho.exa_codigo ");
                buf.append("left join materialcoleta mfilho on a.fil_kodigo = mfilho.fil_codigo and a.mco_codfilho = mfilho.mco_codigo ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" left join detalhetabelaprecometodologia dtm on a.met_codigo IS NOT NULL and d.fil_codigo = dtm.fil_codigo and d.tpe_codigo = dtm.tpe_codigo and cfilho.exa_codigo = dtm.exa_codigo and mfilho.mco_codigo = dtm.mco_codigo and a.met_codigo = dtm.met_codigo ");
                }
                buf.append(" left join detalhetabelapreco dtp on d.fil_codigo = dtp.fil_codigo and d.tpe_codigo = dtp.tpe_codigo and cfilho.exa_codigo = dtp.exa_codigo and mfilho.mco_codigo = dtp.mco_codigo ");
            } else {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" left join detalhetabelaprecometodologia dtm on a.met_codigo IS NOT NULL and d.fil_codigo = dtm.fil_codigo and d.tpe_codigo = dtm.tpe_codigo and a.exa_codigo = dtm.exa_codigo and a.mco_codigo = dtm.mco_codigo and a.met_codigo = dtm.met_codigo ");
                }
                buf.append("left join detalhetabelapreco dtp on d.fil_codigo = dtp.fil_codigo and d.tpe_codigo = dtp.tpe_codigo and a.exa_codigo = dtp.exa_codigo and a.mco_codigo = dtp.mco_codigo ");
            }
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo = ");
            bufWhere.append(Variaveis.filialPadrao);
            boolean filtrarEstornadas = this.getFiltroCheck("filtrarEstornadas");
            if (filtrarEstornadas) {
                bufWhere.append(" and fat.usr_codcancelamento is not null and fat.fat_datacancelamento is not null");
            } else {
                bufWhere.append(" and fat.fat_datacancelamento is null ");
            }
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and fat.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setores = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and es.set_codigo in (");
                for (int i = 0; i < setores.length; ++i) {
                    bufWhere.append(setores[i]);
                    if (i >= setores.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((situacoes = this.getSelecionadosFiltro("filtroSituacao", 0)) != null) {
                bufWhere.append(" and req.sit_codigo in (");
                for (int i = 0; i < situacoes.length; ++i) {
                    bufWhere.append(situacoes[i]);
                    if (i >= situacoes.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and req.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                bufWhere.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    bufWhere.append("(med.med_conselho = '");
                    bufWhere.append(conselho[i]);
                    bufWhere.append("' and med.med_crm = '");
                    bufWhere.append(crm[i]);
                    bufWhere.append("' and med.med_uf = '");
                    bufWhere.append(uf[i]);
                    bufWhere.append("')");
                    if (i >= crm.length - 1) continue;
                    bufWhere.append(" or ");
                }
                bufWhere.append(")");
            }
            String string = this.getFiltroCombo("filtroTipoData").equals(this.camposData[0]) ? "fat.fat_dtemis" : (campoData = this.getFiltroCombo("filtroTipoData").equals(this.camposData[1]) ? "fat.fat_dtvenc" : "req.req_dtfatura");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and ").append(campoData).append(" >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and ").append(campoData).append(" <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by filial.fil_codigo, ");
            buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
            buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
            buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao, ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append("exr.met_codigo, ");
            }
            if (this.tipoRelatorio == 2) {
                buf.append("med.med_conselho, med.med_crm, med.med_uf, med.med_nome, ");
            }
            if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0])) {
                buf.append(" a.mco_codigo, m.mco_descricao, m.mco_abreviatura, ");
                buf.append(" cfilho.exa_codigo, cfilho.exa_descricao, ");
                buf.append(" mfilho.mco_codigo, mfilho.mco_descricao, mfilho.mco_abreviatura, ");
                buf.append(" a.exa_codigo, c.exa_descricao ");
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    if (ParametrosGerais.getPrecoMetodologia()) {
                        buf.append(", dtm.dtm_codamb ");
                    }
                    buf.append(", dtp.dtp_codamb ");
                }
            } else if (this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[1])) {
                buf.append("a.exa_codigo, c.exa_descricao, ");
                buf.append(" a.mco_codigo, m.mco_descricao, m.mco_abreviatura ");
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    if (ParametrosGerais.getPrecoMetodologia()) {
                        buf.append(", dtm.dtm_codamb ");
                    }
                    buf.append(", dtp.dtp_codamb ");
                }
            } else {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append(" dtm.dtm_codamb , ");
                }
                buf.append("dtp.dtp_codamb, a.exa_codigo, c.exa_descricao ");
            }
            buf.append("order by ");
            if (this.tipoRelatorio == 2) {
                buf.append("med.med_conselho, med.med_crm, med.med_uf, d.con_codigo, ");
            } else {
                buf.append("d.con_codigo, ");
            }
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("to_ascii(upper(c.exa_descricao))");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                buf.append("a.exa_codigo");
                if (!this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[2])) {
                    buf.append(", a.mco_codigo");
                }
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("dtm.dtm_codamb ");
                }
                buf.append("dtp.dtp_codamb ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            System.gc();
            int quantidadeTotalRequisicoesPorConvenio = 0;
            int quantidadeTotalRequisicoesPorMedico = 0;
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                String codigoConvenio = "";
                String codigoMedicoCont1 = "";
                String codigoMedicoCont2 = "";
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equals("quantidadeRequisicoes")) {
                            if (this.tipoRelatorio == 1) {
                                o[i] = this.quantidadeRequisicoesPorConvenio(st2, bufWhere.toString(), rs.getString("codigoConvenio"), rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), false, situacoes, setores, destinos, coletas);
                                continue;
                            }
                            o[i] = this.quantidadeRequisicoesPorMedico(st2, bufWhere.toString(), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("codigoConvenio"), rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), false, situacoes, setores, destinos, coletas);
                            continue;
                        }
                        if (campos[i].equals("quantidadeTotalRequisicoesPorConvenio")) {
                            if (this.tipoRelatorio == 1 && !rs.getString("codigoConvenio").equalsIgnoreCase(codigoConvenio)) {
                                codigoConvenio = rs.getString("codigoConvenio");
                                quantidadeTotalRequisicoesPorConvenio = this.quantidadeRequisicoesPorConvenio(st2, bufWhere.toString(), rs.getString("codigoConvenio"), rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), true, situacoes, setores, destinos, coletas);
                            } else if (this.tipoRelatorio == 2 && !rs.getString("conselhoMedico").concat(rs.getString("crmMedico")).concat(rs.getString("ufMedico")).concat(rs.getString("codigoConvenio")).equalsIgnoreCase(codigoMedicoCont1)) {
                                codigoMedicoCont1 = rs.getString("conselhoMedico").concat(rs.getString("crmMedico")).concat(rs.getString("ufMedico")).concat(rs.getString("codigoConvenio"));
                                quantidadeTotalRequisicoesPorConvenio = this.quantidadeRequisicoesPorMedico(st2, bufWhere.toString(), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("codigoConvenio"), rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), true, situacoes, setores, destinos, coletas);
                            }
                            o[i] = quantidadeTotalRequisicoesPorConvenio;
                            continue;
                        }
                        if (campos[i].equals("quantidadeTotalRequisicoesPorMedico")) {
                            if (!rs.getString("conselhoMedico").concat(rs.getString("crmMedico")).concat(rs.getString("ufMedico")).equalsIgnoreCase(codigoMedicoCont2)) {
                                codigoMedicoCont2 = rs.getString("conselhoMedico").concat(rs.getString("crmMedico")).concat(rs.getString("ufMedico"));
                                if (this.tipoRelatorio == 2) {
                                    quantidadeTotalRequisicoesPorMedico = this.quantidadeRequisicoesPorMedico(st2, bufWhere.toString(), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), null, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), true, situacoes, setores, destinos, coletas);
                                }
                            }
                            o[i] = quantidadeTotalRequisicoesPorMedico;
                            continue;
                        }
                        if (campos[i].equals("quantidadeGeralRequisicoes")) {
                            int quantidadeGeralRequisicoes = this.quantidadeRequisicoesPorConvenio(st2, bufWhere.toString(), null, rs.getString("codigoExame"), rs.getString("codigoMaterialColeta"), campoData, this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[0]), true, situacoes, setores, destinos, coletas);
                            o[i] = quantidadeGeralRequisicoes;
                            continue;
                        }
                        if (!this.getFiltroCombo("filtroAgrupamento").equals(this.agrupamento[2]) && campos[i].equals("codigoAMB")) {
                            o[i] = ExameUtil.getCodigoAMB(rs.getString("codigoFilial"), rs.getString("codigoExame"), rs.getInt("codigoMaterialColeta"), rs.getInt("codigoConvenio"), ParametrosGerais.getPrecoMetodologia() ? Integer.valueOf(rs.getInt("codigoMetodologia")) : null);
                            continue;
                        }
                        if (campos[i].equals("valorExame")) {
                            BigDecimal valorExame = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                            o[i] = valorExame.add(rs.getBigDecimal("valorExame")).divide(rs.getBigDecimal("quantidadeExames"), RoundingMode.HALF_UP);
                            continue;
                        }
                        o[i] = rs.findColumn(campos[i]) > -1 ? rs.getObject(campos[i]) : "";
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesFaturados.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesFaturados.this.panelCentro.removeAll();
                            RelatorioExamesFaturados.this.panelCentro.repaint();
                            RelatorioExamesFaturados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroTipoData", this.getFiltroCombo("filtroTipoData").equals(this.camposData[0]) ? "emiss\u00e3o da fatura" : (this.getFiltroCombo("filtroTipoData").equals(this.camposData[1]) ? "vencimento da fatura" : "requisi\u00e7\u00e3o"));
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (setores != null) {
                        for (i = 0; i < setores.length; ++i) {
                            buf.append(setores[i]);
                            if (i >= setores.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (situacoes != null) {
                        for (i = 0; i < situacoes.length; ++i) {
                            buf.append(situacoes[i]);
                            if (i >= situacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSituacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    if (crm != null && uf != null) {
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioExamesFaturados");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int quantidadeRequisicoesPorConvenio(Statement st, String filtro, String convenio, String exame, String material, String campoData, boolean filtrarAgrupado, boolean totalConvenio, String[] situacoes, String[] setores, String[] destinos, String[] coletas) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct b.req_codigo) as quantidadeRequisicoes ");
        buf.append("from faturarequisicao b ");
        buf.append("left join faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fil_kodigo = c.fil_kodigo and b.fat_codigo = c.fat_codigo and b.req_codigo = c.req_codigo ");
        buf.append("left join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append("left join requisicao req on b.fil_kodigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
        buf.append("left join materialcoleta m on c.fil_kodigo = m.fil_codigo and c.mco_codigo = m.mco_codigo ");
        buf.append("left join examesetor es on c.fil_kodigo = es.fil_codigo and c.exa_codigo = es.exa_codigo and es.ese_default = true ");
        buf.append("where b.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        boolean filtrarEstornadas = this.getFiltroCheck("filtrarEstornadas");
        if (filtrarEstornadas) {
            buf.append(" and fat.usr_codcancelamento is not null and fat.fat_datacancelamento is not null");
        } else {
            buf.append(" and fat.fat_datacancelamento is null ");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" and ").append(campoData).append(" >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" and ").append(campoData).append(" <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
            buf.append("'");
        }
        if (situacoes != null) {
            buf.append(" and req.sit_codigo in (");
            for (i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and es.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (destinos != null) {
            buf.append(" and req.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (coletas != null) {
            buf.append(" and req.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (!Funcoes.textoVazio(convenio)) {
            buf.append(" and fat.con_codigo = ");
            buf.append(convenio);
        }
        if (!totalConvenio) {
            String colunaExame = "c.exa_codigo";
            String colunaMaterial = "c.mco_codigo";
            if (filtrarAgrupado) {
                colunaExame = "c.exa_codfilho";
                colunaMaterial = "c.mco_codfilho";
            }
            if (!Funcoes.textoVazio(exame)) {
                buf.append(" and ").append(colunaExame).append(" = '");
                buf.append(exame);
                buf.append("'");
            }
            if (!Funcoes.textoVazio(material)) {
                buf.append(" and ").append(colunaMaterial).append(" = ");
                buf.append(material);
            }
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    private int quantidadeRequisicoesPorMedico(Statement st, String filtro, String conselho, String crm, String uf, String convenio, String exame, String material, String campoData, boolean filtrarAgrupado, boolean totalMedico, String[] situacoes, String[] setores, String[] destinos, String[] coletas) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct b.req_codigo) as quantidadeRequisicoes ");
        buf.append("from faturarequisicao b ");
        buf.append("left join faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fil_kodigo = c.fil_kodigo and b.fat_codigo = c.fat_codigo and b.req_codigo = c.req_codigo ");
        buf.append("left join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append("left join requisicao req on b.fil_codigo = req.fil_codigo and b.req_codigo = req.req_codigo ");
        buf.append("left join materialcoleta m on c.fil_kodigo = m.fil_codigo and c.mco_codigo = m.mco_codigo ");
        buf.append("left join examesetor es on c.fil_kodigo = es.fil_codigo and c.exa_codigo = es.exa_codigo and es.ese_default = true ");
        buf.append("where b.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and fat.fat_datacancelamento is null ");
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" and ").append(campoData).append(" >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" and ").append(campoData).append(" <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
            buf.append("'");
        }
        if (situacoes != null) {
            buf.append(" and req.sit_codigo in (");
            for (i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and es.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (destinos != null) {
            buf.append(" and req.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (coletas != null) {
            buf.append(" and req.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (!Funcoes.textoVazio(convenio)) {
            buf.append(" and fat.con_codigo = ");
            buf.append(convenio);
        }
        if (!Funcoes.textoVazio(crm) && !Funcoes.textoVazio(uf)) {
            buf.append(" and req.med_conselho = '").append(StringUtil.textoDB(conselho)).append("' ");
            buf.append(" and req.med_crm = '").append(StringUtil.textoDB(crm)).append("' ");
            buf.append(" and req.med_uf = '").append(StringUtil.textoDB(uf)).append("' ");
        }
        if (!totalMedico) {
            String colunaExame = "c.exa_codigo";
            String colunaMaterial = "c.mco_codigo";
            if (filtrarAgrupado) {
                colunaExame = "c.exa_codfilho";
                colunaMaterial = "c.mco_codfilho";
            }
            if (!Funcoes.textoVazio(exame)) {
                buf.append(" and ").append(colunaExame).append(" = '");
                buf.append(exame);
                buf.append("'");
            }
            if (!Funcoes.textoVazio(material)) {
                buf.append(" and ").append(colunaMaterial).append(" = ");
                buf.append(material);
            }
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100200");
        }
        return Long.parseLong("0870100300");
    }

    private long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0870100201");
        }
        return Long.parseLong("0870100301");
    }
}

