/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioEvolucaoFaturamentoMedico
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final String PARAMETROS_EVOLUCAO_FATURAMENTO_MEDICO = "RelatorioEvolucaoFaturamentoMedico.ultimoFiltro";
    private String[] ordem = new String[]{"C\u00f3digo", "Nome", "Qtde Req.", "Qtde. Exames", "Total Fat."};
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_VENCIMENTO = "filtrarVencimento";
    private final String FILTRO_DETALHAR_EXAMES = "filtrarDetalharExames";
    protected static String[] campos;
    public static final int TIPO_NAO_DETALHAR = 0;
    public static final int TIPO_DETALHAR = 1;
    private int acessoDetalharExames = 0;

    public RelatorioEvolucaoFaturamentoMedico(int acessoDetalharExames) {
        this.acessoDetalharExames = acessoDetalharExames;
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"crmMedico", "nomeMedico", "totalMateriais", "totalExames", "anoMes", "quantidadeRequisicoes", "quantidadeGeralRequisicoes", "totalCH", "totalFatura", "quantidadeRequisicoesMes", "quantidadeExames", "quantidadeRequisicoesMedico", "anoEmissao", "mesEmissao", "codigoAuxMed", "medicoUf", "codigoExame", "descricaoExame"});
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.montaBarraDescricao("Relat\u00f3rio de evolu\u00e7\u00e3o de faturamento por coletador", "Evolu\u00e7\u00e3o dos faturamentos realizados por coletador", "relatorios/rel_evolucao_fatura_coletador.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio de evolu\u00e7\u00e3o de faturamento por m\u00e9dico", "Evolu\u00e7\u00e3o dos faturamentos realizados por m\u00e9dico", "relatorios/rel_evolucao_fatura_medico.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtrarVencimento", "Filtrar por vencimento", false);
        if (this.acessoDetalharExames == 1) {
            this.adicionaFiltroCheck("filtrarDetalharExames", "Detalhar Exames", false);
        }
        JCheckBox checkDetalharExames = null;
        if (Acesso.getAcesso(RelatorioEvolucaoFaturamentoMedico.getModuloAcesso(1))) {
            checkDetalharExames = this.adicionaRetornaFiltroCheck("filtrarDetalharExames", "Detalhar Exames", false);
        }
        if (checkDetalharExames != null) {
            checkDetalharExames.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RelatorioEvolucaoFaturamentoMedico.this.setModuloConfigurar(RelatorioEvolucaoFaturamentoMedico.getModuloConfigurar(1));
                        RelatorioEvolucaoFaturamentoMedico.this.setModuloAcesso(RelatorioEvolucaoFaturamentoMedico.getModuloAcesso(1));
                    } else {
                        RelatorioEvolucaoFaturamentoMedico.this.setModuloConfigurar(RelatorioEvolucaoFaturamentoMedico.getModuloConfigurar(0));
                        RelatorioEvolucaoFaturamentoMedico.this.setModuloAcesso(RelatorioEvolucaoFaturamentoMedico.getModuloAcesso(0));
                    }
                }
            });
        } else {
            this.setModuloConfigurar(RelatorioEvolucaoFaturamentoMedico.getModuloConfigurar(0));
            this.setModuloAcesso(RelatorioEvolucaoFaturamentoMedico.getModuloAcesso(0));
        }
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_EVOLUCAO_FATURAMENTO_MEDICO);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "medicos");
            if (!Funcoes.textoVazio(tmp)) {
                String[] medicos = StringUtil.getValores(tmp, "medico");
                Object[] filtro = new Object[medicos.length];
                for (int i = 0; i < medicos.length; ++i) {
                    String valor;
                    String valores = medicos[i];
                    Object[] aux = new Object[4];
                    int j = 0;
                    while (!Funcoes.textoVazio(valor = StringUtil.getValor(valores, String.valueOf(j)))) {
                        aux[j++] = valor;
                    }
                    filtro[i] = aux;
                }
                this.setSelecionadosFiltroAvancado("filtroMedico", filtro);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                this.setSelecionadosFiltro("filtroExame", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordem"))) {
                this.setFiltroCombo("ordemRelatorio", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "vencimento"))) {
                this.setFiltroCheck("filtrarVencimento", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "detalharexames")) && checkDetalharExames != null) {
                this.setFiltroCheck("filtrarDetalharExames", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        if (this.getFiltroCheck("filtrarDetalharExames") && this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
            Funcoes.mensagem(this, "Tipo de ordem n\u00e3o pemitida para detalhar exames, mude a ordem ou desmarque a op\u00e7\u00e3o detalhar!", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] exame;
            StringBuilder buf = new StringBuilder();
            StringBuilder bufQtdeReq = new StringBuilder();
            boolean filtrarVencimento = this.getFiltroCheck("filtrarVencimento");
            buf.append("select ");
            if (filtrarVencimento) {
                buf.append("extract(year from a.fat_dtvenc) as anoEmissao, extract(month from a.fat_dtvenc) as mesEmissao, ");
                buf.append("cast(extract(year from a.fat_dtvenc) as text) || ltrim(to_char(extract(month from a.fat_dtvenc),'00'),' ') as anoMes, ");
            } else {
                buf.append("extract(year from a.fat_dtemis) as anoEmissao, extract(month from a.fat_dtemis) as mesEmissao, ");
                buf.append("cast(extract(year from a.fat_dtemis) as text) || ltrim(to_char(extract(month from a.fat_dtemis),'00'),' ') as anoMes, ");
            }
            buf.append("sum(fer.fer_totalmateriais) as totalMateriais, ");
            buf.append("sum(fer.fer_total)          as totalExames, ");
            buf.append("sum(fer.fer_totalch)        as totalCH,");
            buf.append("sum(fer.fer_total + fer.fer_totalmateriais ) as totalFatura, ");
            buf.append("count(a.*) as quantidadeExames, ");
            if (this.getFiltroCheck("filtrarDetalharExames")) {
                buf.append("exa.exa_codigo as codigoExame, ");
                buf.append("exa.exa_descricao as descricaoExame, ");
                bufQtdeReq.append("select ");
                bufQtdeReq.append("count(distinct cast(req.fil_codigo as text)||a.fat_codigo||req.req_codigo) as quantidadeRequisicoes ");
            } else {
                buf.append("count(distinct cast(req.fil_codigo as text)||a.fat_codigo||req.req_codigo) as quantidadeRequisicoes, ");
            }
            buf.append("med.med_conselho, ");
            buf.append("med.med_nome as nomeMedico, ");
            buf.append("med.med_crm as crmMedico, ");
            buf.append("med.med_uf as medicoUf, ");
            buf.append("med.med_conselho||med.med_crm||med.med_uf as codigoAuxMed, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            StringBuilder bufTables = new StringBuilder();
            bufTables.append("from fatura a ");
            bufTables.append("left join faturarequisicao fre on a.fil_codigo = fre.fil_codigo and a.fat_codigo = fre.fat_codigo ");
            bufTables.append("left join requisicao req on  fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo and not req.req_excluida ");
            bufTables.append("left join medico med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
            bufTables.append("left join faturaexamerequisicao fer on fre.fil_kodigo = fer.fil_kodigo and fre.fil_codigo = fer.fil_codigo and fre.req_codigo = fer.req_codigo and a.fat_codigo = fer.fat_codigo ");
            if (this.getFiltroCheck("filtrarDetalharExames")) {
                bufTables.append("left join exames exa on fer.fil_codigo = exa.fil_codigo and fer.exa_codigo = exa.exa_codigo ");
            }
            bufTables.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(bufTables.toString());
            bufQtdeReq.append(bufTables.toString());
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo = ");
            bufWhere.append(Variaveis.filialPadrao);
            bufWhere.append(" and a.fat_datacancelamento is null ");
            bufWhere.append(" and req.med_crm <> '' and req.med_crm is not null ");
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                bufWhere.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    bufWhere.append("(med.med_conselho = '");
                    bufWhere.append(conselho[i]);
                    bufWhere.append("' and med.med_crm = '");
                    bufWhere.append(crm[i]);
                    bufWhere.append("' and med.med_uf = '");
                    bufWhere.append(uf[i]);
                    bufWhere.append("')");
                    if (i >= crm.length - 1) continue;
                    bufWhere.append(" or ");
                }
                bufWhere.append(")");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                bufWhere.append(" and fer.exa_codigo in ('");
                for (int i = 0; i < exame.length; ++i) {
                    bufWhere.append(exame[i]);
                    if (i >= exame.length - 1) continue;
                    bufWhere.append("', '");
                }
                bufWhere.append("')");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            bufQtdeReq.append(bufWhere.toString());
            buf.append(" group by filial.fil_codigo, ");
            buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
            buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
            buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append("bairrofilial.bai_descricao, filial.fil_cnes, 3, ");
            if (this.getFiltroCheck("filtrarDetalharExames")) {
                buf.append("exa.exa_codigo, exa.exa_descricao, ");
            }
            buf.append("med.med_conselho, med.med_nome, med.med_crm, med.med_uf, med.med_conselho||med.med_crm||med.med_uf, ");
            if (filtrarVencimento) {
                buf.append("extract(year from a.fat_dtvenc), extract(month from a.fat_dtvenc), ");
                buf.append("cast(extract(year from a.fat_dtvenc) as text) || ltrim(to_char(extract(month from a.fat_dtvenc),'00'),' ') ");
            } else {
                buf.append("extract(year from a.fat_dtemis), extract(month from a.fat_dtemis), ");
                buf.append("cast(extract(year from a.fat_dtemis) as text) || ltrim(to_char(extract(month from a.fat_dtemis),'00'),' ') ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("med.med_nome, ");
            } else {
                buf.append("med.med_crm, ");
            }
            if (this.getFiltroCheck("filtrarDetalharExames")) {
                buf.append("3, ");
            }
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("1, 2 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("9 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("8 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append("7 ");
            } else {
                buf.append("1, 2 ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ResultSet rs2;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                String qtdeReqMesChave = "";
                String qtdeReqMedChave = "";
                int qtdeReqMes = 0;
                int qtdeReqMed = 0;
                int qtdeGeralReq = 0;
                if (this.getFiltroCheck("filtrarDetalharExames") && (rs2 = Conexao.executeQuery(st2, bufQtdeReq.toString())).next()) {
                    qtdeGeralReq = rs2.getInt("quantidadeRequisicoes");
                }
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) > 0) {
                            o[i] = rs.getObject(campos[i]);
                            continue;
                        }
                        if (this.getFiltroCheck("filtrarDetalharExames") && campos[i].equals("quantidadeRequisicoesMes")) {
                            if (!qtdeReqMesChave.equals(rs.getString("anoEmissao") + rs.getString("mesEmissao") + rs.getString("med_conselho") + rs.getString("crmMedico") + rs.getString("medicoUf"))) {
                                qtdeReqMesChave = rs.getString("anoEmissao") + rs.getString("mesEmissao") + rs.getString("med_conselho") + rs.getString("crmMedico") + rs.getString("medicoUf");
                                qtdeReqMes = this.getQuantidadeRequisicoesMes(st2, bufQtdeReq, rs.getInt("anoEmissao"), rs.getInt("mesEmissao"), rs.getString("med_conselho"), rs.getString("crmMedico"), rs.getString("medicoUf"), filtrarVencimento ? "a.fat_dtvenc" : "a.fat_dtemis");
                            }
                            o[i] = qtdeReqMes;
                            continue;
                        }
                        if (this.getFiltroCheck("filtrarDetalharExames") && campos[i].equals("quantidadeRequisicoesMedico")) {
                            if (!qtdeReqMedChave.equals(rs.getString("med_conselho") + rs.getString("crmMedico") + rs.getString("medicoUf"))) {
                                qtdeReqMedChave = rs.getString("med_conselho") + rs.getString("crmMedico") + rs.getString("medicoUf");
                                qtdeReqMed = this.getQuantidadeRequisicoesMedico(st2, bufQtdeReq, rs.getString("med_conselho"), rs.getString("crmMedico"), rs.getString("medicoUf"), filtrarVencimento ? "a.fat_dtvenc" : "a.fat_dtemis");
                            }
                            o[i] = qtdeReqMed;
                            continue;
                        }
                        if (!this.getFiltroCheck("filtrarDetalharExames") || !campos[i].equals("quantidadeGeralRequisicoes")) continue;
                        o[i] = qtdeGeralReq;
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioEvolucaoFaturamentoMedico.getModuloAcesso(this.getFiltroCheck("filtrarDetalharExames") ? 1 : 0));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioEvolucaoFaturamentoMedico.this.panelCentro.removeAll();
                            RelatorioEvolucaoFaturamentoMedico.this.panelCentro.repaint();
                            RelatorioEvolucaoFaturamentoMedico.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtrarVencimento", this.getFiltroCheck("filtrarVencimento") ? "data de vencimento" : "data de emiss\u00e3o");
                    StringBuilder p = new StringBuilder();
                    p.append("<ordem>").append(this.getFiltroCombo("ordemRelatorio")).append("</ordem>");
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<vencimento>").append(this.getFiltroCheck("filtrarVencimento")).append("</vencimento>");
                    p.append("<detalharexames>").append(this.getFiltroCheck("filtrarDetalharExames")).append("</detalharexames>");
                    buf.delete(0, buf.length());
                    if (crm != null) {
                        p.append("<crm>");
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(crm[i]);
                            if (i >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</crm>");
                    buf.delete(0, buf.length());
                    if (conselho != null) {
                        p.append("<conselho>");
                        for (i = 0; i < conselho.length; ++i) {
                            buf.append(conselho[i]);
                            if (i >= conselho.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</conselho>");
                    buf.delete(0, buf.length());
                    if (uf != null) {
                        p.append("<uf>");
                        for (i = 0; i < uf.length; ++i) {
                            buf.append(uf[i]);
                            if (i >= uf.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</uf>");
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        p.append("<exame>");
                        for (i = 0; i < exame.length; ++i) {
                            buf.append(exame[i]);
                            if (i >= exame.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</exame>");
                    ParametrosUsuarios.setValor(PARAMETROS_EVOLUCAO_FATURAMENTO_MEDICO, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioEvolucaoFaturamento");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Integer getQuantidadeRequisicoesMes(Statement st, StringBuilder sql, int ano, int mes, String conselhoMedico, String crmMedico, String ufMedico, String campoFiltro) throws SQLException {
        StringBuilder buf = new StringBuilder(sql.toString());
        buf.append(" and extract(year from ").append(campoFiltro).append(") = ").append(ano);
        buf.append(" and extract(month from ").append(campoFiltro).append(") = ").append(mes);
        return this.getQuantidadeRequisicoesMedico(st, buf, conselhoMedico, crmMedico, ufMedico, campoFiltro);
    }

    private Integer getQuantidadeRequisicoesMedico(Statement st, StringBuilder sql, String conselhoMedico, String crmMedico, String ufMedico, String campoFiltro) throws SQLException {
        StringBuilder buf = new StringBuilder(sql.toString());
        buf.append(" and med.med_conselho = '").append(conselhoMedico).append("'");
        buf.append(" and med.med_crm = '").append(crmMedico).append("'");
        buf.append(" and med.med_uf = '").append(ufMedico).append("'");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("quantidadeRequisicoes");
        }
        return 0;
    }

    public static long getModuloAcesso(int acessoDetalharExames) {
        if (0 == acessoDetalharExames) {
            return Long.parseLong("0870101900");
        }
        return Long.parseLong("0870101902");
    }

    public static long getModuloConfigurar(int acessoDetalharExames) {
        if (0 == acessoDetalharExames) {
            return Long.parseLong("0870101901");
        }
        return Long.parseLong("0870101902");
    }
}

