/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioEvolucaoFaturamento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final String PARAMETROS_EVOLUCAO_FATURAMENTO = "RelatorioEvolucaoFaturamento.ultimoFiltro";
    private String[] ordem = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social", "Qtde Req.", "Qtde. Exames", "Total Fat."};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_VENCIMENTO = "filtrarVencimento";
    protected static String[] campos;

    public RelatorioEvolucaoFaturamento() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "totalMateriais", "totalExames", "totalCH", "totalFatura", "quantidadeRequisicoes", "quantidadeExames", "totalAdicionais", "totalDespesasCobranca", "anoEmissao", "mesEmissao"});
        this.montaBarraDescricao("Relat\u00f3rio de evolu\u00e7\u00e3o de faturamento", "Evolu\u00e7\u00e3o dos faturamentos realizados por conv\u00eanio", "relatorios/rel_evolucao_fatura.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtrarVencimento", "Filtrar por vencimento", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEvolucaoFaturamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_EVOLUCAO_FATURAMENTO);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "convenio");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroConvenio", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordem"))) {
                this.setFiltroCombo("ordemRelatorio", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "vencimento"))) {
                this.setFiltroCheck("filtrarVencimento", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            boolean filtrarVencimento = this.getFiltroCheck("filtrarVencimento");
            buf.append("select ");
            if (filtrarVencimento) {
                buf.append("extract(year from a.fat_dtvenc) as anoEmissao, extract(month from a.fat_dtvenc) as mesEmissao, ");
            } else {
                buf.append("extract(year from a.fat_dtemis) as anoEmissao, extract(month from a.fat_dtemis) as mesEmissao, ");
            }
            buf.append("sum(a.fat_totalmateriais) as totalMateriais, ");
            buf.append("sum(a.fat_totalexames) as totalExames, ");
            buf.append("sum(a.fat_totalexamesch) as totalCH, ");
            buf.append("sum(a.fat_totalexames + a.fat_totalmateriais + a.fat_adicional + a.fat_despcobranca) as totalFatura, ");
            buf.append("sum(a.fat_qtderequisicao) as quantidadeRequisicoes, ");
            buf.append("sum(a.fat_qtdeexames) as quantidadeExames, ");
            buf.append("sum(a.fat_adicional) as totalAdicionais, ");
            buf.append("sum(a.fat_despcobranca) as totalDespesasCobranca, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from fatura a  ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo = ");
            bufWhere.append(Variaveis.filialPadrao);
            bufWhere.append(" and a.fat_datacancelamento is null ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and a.").append(filtrarVencimento ? "fat_dtvenc" : "fat_dtemis").append(" <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by filial.fil_codigo, ");
            buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
            buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
            buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao, a.con_codigo, ");
            if (filtrarVencimento) {
                buf.append("extract(year from a.fat_dtvenc), extract(month from a.fat_dtvenc) ");
            } else {
                buf.append("extract(year from a.fat_dtemis), extract(month from a.fat_dtemis) ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.con_fantasia, 1, 2 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("d.con_razao, 1, 2 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append(" d.con_codigo, 6 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append(" d.con_codigo, 7 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                buf.append(" d.con_codigo, 5 ");
            } else {
                buf.append("d.con_codigo, 1, 2 ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioEvolucaoFaturamento.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioEvolucaoFaturamento.this.panelCentro.removeAll();
                            RelatorioEvolucaoFaturamento.this.panelCentro.repaint();
                            RelatorioEvolucaoFaturamento.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtrarVencimento", this.getFiltroCheck("filtrarVencimento") ? "data de vencimento" : "data de emiss\u00e3o");
                    StringBuilder p = new StringBuilder();
                    p.append("<ordem>").append(this.getFiltroCombo("ordemRelatorio")).append("</ordem>");
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<vencimento>").append(this.getFiltroCheck("filtrarVencimento")).append("</vencimento>");
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        p.append("<convenio>");
                        for (int i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</convenio>");
                    ParametrosUsuarios.setValor(PARAMETROS_EVOLUCAO_FATURAMENTO, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioEvolucaoFaturamento");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870100500");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0870100501");
    }
}

