/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioCotaFaturamento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private static String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "quantidadeExames", "quantidadeRequisicoes", "data", "quantidadeExamesFaturados", "quantidadeRequisicoesFaturadas"});

    public RelatorioCotaFaturamento() {
        this.montaBarraDescricao("Relat\u00f3rio de cotas de faturamento", "Acumulados de exames e requisi\u00e7\u00f5es faturados por data", "relatorios/rel_cota_faturamento.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SITUACAO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.setModuloConfigurar(RelatorioCotaFaturamento.getModuloConfigurar());
        this.setModuloAcesso(RelatorioCotaFaturamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            String[] situacao;
            String[] coletas;
            StringBuilder buf = new StringBuilder();
            buf.append("select cast(req.req_dtfatura as date) as data, ");
            buf.append("       count(distinct (a.fil_codigo||'-'||req.req_codigo||(case  when agr.exa_kodigo is not null then agr.exa_kodigo else (case when agr2.exa_kodigo is not null then agr2.exa_kodigo else a.exa_codigo end) end))) as quantidadeExames, ");
            buf.append("       count(distinct req.fil_codigo||'-'||req.req_codigo ) as quantidadeRequisicoes, ");
            buf.append("       count(distinct a.fil_codigo||'-'||req.req_codigo||fer.exa_codfilho) as quantidadeExamesFaturados, ");
            buf.append("       count(distinct a.fil_codigo||'-'||fer.req_codigo ) as quantidadeRequisicoesFaturadas, ");
            buf.append("       con.con_codigo as codigoConvenio, ");
            buf.append("       con.con_razao as razaoSocialConvenio, ");
            buf.append("       con.con_fantasia as fantasiaConvenio ");
            buf.append("  from examerequisicao a ");
            buf.append("  join requisicao req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
            buf.append("  join exames exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            buf.append("  join convenios con on a.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("  left join situacao sit on req.fil_codigo = sit.fil_codigo and req.sit_codigo = sit.sit_codigo ");
            buf.append("  join usuario usr on a.usr_codmaterial = usr.usr_codigo ");
            buf.append("  left join faturaexamerequisicao fer on a.fil_codigo = fer.fil_kodigo  and a.exa_codigo = fer.exa_codigo and a.req_codigo = fer.req_codigo ");
            buf.append("                                      and (select count(fat.fat_codigo) from fatura fat where fer.fil_codigo = fat.fil_codigo and fer.fat_codigo = fat.fat_codigo and fat.fat_datacancelamento is null and fat.con_codigo = req.con_codigo ) > 0 ");
            buf.append("  left join faturarequisicao      fre on fer.fil_kodigo = fre.fil_kodigo and fer.fil_codigo = fre.fil_codigo and fer.req_codigo = fre.req_codigo and req.con_codigo = fre.con_codigo and fer.fat_codigo = fre.fat_codigo ");
            buf.append("                                      and (select count(fat.fat_codigo) from fatura fat where fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo and fat.fat_datacancelamento is null and fat.con_codigo = fre.con_codigo) > 0 ");
            buf.append("  left join fatura fat on fre.fil_codigo = fat.fil_codigo  and  fre.fat_codigo = fat.fat_codigo and fat.fat_datacancelamento is null and con.con_codigo = fat.con_codigo ");
            buf.append("     left join agrupaexameconvenio aec  on a.fil_codigo  = aec.fil_codigo ");
            buf.append("          and a.exa_codigo = aec.exa_codigo ");
            buf.append("          and a.mco_codigo = aec.mco_codigo ");
            buf.append("          and con.con_codigo  = aec.con_codigo ");
            buf.append("          and aec.aec_tipo = '").append("F").append("' ");
            buf.append("     left join agrupaexameconvenio aec2 on a.fil_codigo  = aec2.fil_codigo ");
            buf.append("          and a.exa_codigo  = aec2.exa_codigo ");
            buf.append("          and a.mco_codigo  = aec2.mco_codigo ");
            buf.append("          and aec2.aec_ignorarconvenio ");
            buf.append("          and aec2.aec_tipo = '").append("F").append("' ");
            buf.append("     left join exameagrupaexameconvenio agr  on aec.fil_codigo  = agr.fil_codigo ");
            buf.append("          and aec.exa_codigo = agr.exa_codigo ");
            buf.append("          and aec.mco_codigo = agr.mco_codigo ");
            buf.append("          and aec.con_codigo = agr.con_codigo ");
            buf.append("          and agr.aec_tipo = '").append("F").append("' ");
            buf.append("     left join exameagrupaexameconvenio agr2 on aec2.fil_codigo = agr2.fil_codigo ");
            buf.append("          and aec2.exa_codigo = agr2.exa_codigo ");
            buf.append("          and aec2.mco_codigo = agr2.mco_codigo ");
            buf.append("          and aec2.con_codigo = agr2.con_codigo ");
            buf.append("          and agr.fil_codigo IS NULL ");
            buf.append("          and agr2.aec_tipo = '").append("F").append("' ");
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufWhere.append(" and req.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0)) != null) {
                bufWhere.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO, 0)) != null) {
                bufWhere.append(" and sit.sit_codigo in (");
                for (int i = 0; i < situacao.length; ++i) {
                    bufWhere.append(situacao[i]);
                    if (i >= situacao.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    bufWhere.append(" and (req.req_dtfatura + req.req_horafatura) >= '");
                    bufWhere.append(Funcoes.formataData("yyyy-MM-dd HH:mm", this.getFiltroData(FILTRO_DATA_INICIAL) + " " + this.getFiltroHora(FILTRO_HORA_INICIAL)));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    bufWhere.append(" and (req.req_dtfatura + req.req_hora) <= '");
                    bufWhere.append(Funcoes.formataData("yyyy-MM-dd HH:mm", this.getFiltroData(FILTRO_DATA_FINAL) + " " + this.getFiltroHora(FILTRO_HORA_FINAL)));
                    bufWhere.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    bufWhere.append(" and cast(req.req_dtfatura as date) >= '");
                    bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    bufWhere.append(" and cast(req.req_dtfatura as date) <= '");
                    bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    bufWhere.append(" and req_horafatura >= '");
                    bufWhere.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    bufWhere.append(" and req_horafatura <= '");
                    bufWhere.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    bufWhere.append("'");
                }
            }
            bufWhere.append(" and req.req_excluida = false and a.exr_excluido = false ");
            bufWhere.append(" and a.usr_codmaterial IS NOT NULL ");
            buf.append(bufWhere.toString());
            StringBuilder bufGroupOrder = new StringBuilder();
            bufGroupOrder.append("  con.con_fantasia");
            bufGroupOrder.append(", con.con_razao");
            bufGroupOrder.append(", con.con_codigo");
            bufGroupOrder.append(", cast(req.req_dtfatura as date)");
            buf.append(" group by ");
            buf.append(bufGroupOrder.toString());
            buf.append(" order by ");
            buf.append(bufGroupOrder.toString());
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (ArraysUtil.contem(Constantes.CAMPOS_FILIAL, campos[i])) continue;
                        o[i] = campos[i].equalsIgnoreCase("quantidadeRequisicoesFaturadas") ? Integer.valueOf(rs.getInt("quantidadeRequisicoesFaturadas")) : (campos[i].equalsIgnoreCase("quantidadeExamesFaturados") ? Integer.valueOf(rs.getInt("quantidadeExamesFaturados")) : rs.getObject(campos[i]));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) != null && this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ").append(RelatorioCotaFaturamento.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioCotaFaturamento.this.panelCentro.removeAll();
                            RelatorioCotaFaturamento.this.panelCentro.repaint();
                            RelatorioCotaFaturamento.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_HORA_INICIAL, this.getFiltroHora(FILTRO_HORA_INICIAL));
                    var.put(FILTRO_HORA_FINAL, this.getFiltroHora(FILTRO_HORA_FINAL));
                    var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (situacao != null) {
                        for (i = 0; i < situacao.length; ++i) {
                            buf.append(situacao[i]);
                            if (i >= situacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SITUACAO, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioCotaFaturamento");
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870102101");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870102100");
    }
}

