/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class RelatorioConveniosFaturar
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_EXAME = "filtroExame";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_SITUACAO_CADASTRO = "filtroSituacaoRequisicao";
    private static final String FILTRO_DEVE_GUIA = "deveGuia";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_SEM_COBRANCA = "filtroSemCobranca";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "qtdeRequisicoesConvenio", "qtdeExamesConvenio", "valorTotalExamesConvenio"});

    public RelatorioConveniosFaturar() {
        this.montaBarraDescricao("Relat\u00f3rio de Conv\u00eanios para faturar", "Listagem dos conv\u00eanios para faturamento", "relatorios/rel_convenio_faturar.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SITUACAO_CADASTRO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCheck(FILTRO_DEVE_GUIA, "Sem pedido/guia", false);
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_SEM_COBRANCA, "Sem cobran\u00e7a no balc\u00e3o (100%)", false);
        this.setModuloConfigurar(RelatorioConveniosFaturar.getModuloConfigurar());
        this.setModuloAcesso(RelatorioConveniosFaturar.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            String[] conselho = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0);
            String[] crm = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1);
            String[] uf = this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2);
            String[] exame = this.getSelecionadosFiltro(FILTRO_EXAME, 0);
            String[] setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0);
            String[] situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO_CADASTRO, 0);
            String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
            String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
            String horaInicial = this.getFiltroHora(FILTRO_HORA_INICIAL);
            String horaFinal = this.getFiltroHora(FILTRO_HORA_FINAL);
            boolean deveGuia = this.getFiltroCheck(FILTRO_DEVE_GUIA);
            boolean intervaloHora = this.getFiltroCheck(FILTRO_INTERVALO_HORA);
            boolean semCobrancaBalcao = this.getFiltroCheck(FILTRO_SEM_COBRANCA);
            String[] paciente = null;
            if (intervaloHora && (Funcoes.textoVazio(dataInicial) || Funcoes.textoVazio(horaInicial) || Funcoes.textoVazio(dataFinal) || Funcoes.textoVazio(horaFinal))) {
                Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos!", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String sql = RelatorioConveniosFaturar.getSelect(filiais, convenio, conselho, crm, uf, exame, setor, situacao, paciente, dataInicial, dataFinal, horaInicial, horaFinal, deveGuia, intervaloHora, semCobrancaBalcao);
            this.imprimirRelatorio(this, this.panelCentro, sql, null, convenio, conselho, crm, uf, exame, setor, situacao, paciente, dataInicial, dataFinal, horaInicial, horaFinal, deveGuia, new Runnable(){

                @Override
                public void run() {
                    RelatorioConveniosFaturar.this.panelCentro.removeAll();
                    RelatorioConveniosFaturar.this.panelCentro.repaint();
                    RelatorioConveniosFaturar.this.habilitaBotaoImprimir(true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    RelatorioConveniosFaturar.this.habilitaBotaoImprimir(true);
                }
            });
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void imprimirRelatorio(Component pai, JPanel panel, String sql, String[] filiais, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] exames, String[] setores, String[] situacao, String[] pacientes, String dataInicial, String dataFinal, String horaInicial, String horaFinal, boolean deveGuia, Runnable acaoFechar, Runnable acaoFimRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            ModeloGridTable modelo = new ModeloGridTable(campos);
            do {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    if (ArraysUtil.contem(Constantes.CAMPOS_FILIAL, campos[i])) continue;
                    o[i] = campos[i].equalsIgnoreCase("qtdeRequisicoesConvenio") ? Integer.valueOf(rs.getInt("qtdeRequisicoesConvenio")) : (campos[i].equalsIgnoreCase("qtdeExamesConvenio") ? Integer.valueOf(rs.getInt("qtdeExamesConvenio")) : rs.getObject(campos[i]));
                }
                modelo.addLine(o);
            } while (rs.next());
            String codigoFilial = Variaveis.filialPadrao;
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) != null && this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length == 1) {
                codigoFilial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
            }
            Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
            RelatorioUtil.preencheDadosFilial(regFilial, modelo);
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioConveniosFaturar.getModuloAcesso());
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i;
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(panel);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                if (acaoFechar != null) {
                    gerador.setAcaoFechar(acaoFechar);
                }
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put(FILTRO_DEVE_GUIA, this.getFiltroCheck(FILTRO_DEVE_GUIA) ? "Sim" : "N\u00e3o");
                var.put(FILTRO_DATA_INICIAL, dataInicial);
                var.put(FILTRO_DATA_FINAL, dataFinal);
                var.put(FILTRO_HORA_INICIAL, horaInicial);
                var.put(FILTRO_HORA_FINAL, horaFinal);
                var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                var.put(FILTRO_SEM_COBRANCA, this.getFiltroCheck(FILTRO_SEM_COBRANCA) ? "Sim" : "N\u00e3o");
                buf.delete(0, buf.length());
                if (convenios != null) {
                    for (i = 0; i < convenios.length; ++i) {
                        buf.append(convenios[i]);
                        if (i >= convenios.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_CONVENIO, buf.toString());
                buf.delete(0, buf.length());
                if (medicosCrm != null && medicosUF != null) {
                    for (i = 0; i < medicosCrm.length; ++i) {
                        buf.append(medicosConselho[i]).append(": ");
                        buf.append(medicosCrm[i]);
                        buf.append("(");
                        buf.append(medicosUF[i]);
                        buf.append(")");
                        if (i >= medicosCrm.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_MEDICO, buf.toString());
                buf.delete(0, buf.length());
                if (exames != null) {
                    for (i = 0; i < exames.length; ++i) {
                        buf.append(exames[i]);
                        if (i >= exames.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_EXAME, buf.toString());
                buf.delete(0, buf.length());
                if (setores != null) {
                    for (i = 0; i < setores.length; ++i) {
                        buf.append(setores[i]);
                        if (i >= setores.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_SETOR, buf.toString());
                buf.delete(0, buf.length());
                if (situacao != null) {
                    for (i = 0; i < situacao.length; ++i) {
                        buf.append(situacao[i]);
                        if (i >= situacao.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put(FILTRO_SITUACAO_CADASTRO, buf.toString());
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                panel.revalidate();
            }
        } else {
            Funcoes.mensagem(pai, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            if (acaoFimRelatorio != null) {
                acaoFimRelatorio.run();
            }
        }
        Conexao.fecharStatement(st);
    }

    public static String getSelect(String[] filiais, String[] convenios, String[] medicosConselho, String[] medicosCrm, String[] medicosUF, String[] exames, String[] setores, String[] situacoes, String[] pacientes, String dataInicial, String dataFinal, String horaInicial, String horaFinal, Boolean deveGuia, Boolean intervaloHora, Boolean semCobrancaBalcao) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select con.con_codigo as codigoConvenio, ");
        buf.append("       con.con_razao as razaoSocialConvenio, ");
        buf.append("       con.con_fantasia as fantasiaConvenio, ");
        buf.append("       count(distinct req.req_codigo) as qtdeRequisicoesConvenio, ");
        buf.append("       count(a.exa_codigo) as qtdeExamesConvenio, ");
        buf.append("       sum(calculaprecototalexamerequisicao(a.fil_codigo, req.con_codigo, req.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExamesConvenio ");
        buf.append("from examerequisicao a ");
        buf.append("     join requisicao req on a.fil_codigo = req.fil_codigo");
        buf.append("          and a.req_codigo = req.req_codigo");
        buf.append("     left join exames exa on a.fil_codigo = exa.fil_codigo ");
        buf.append("     and a.exa_codigo = exa.exa_codigo ");
        buf.append("     left join examesetor ese on exa.fil_codigo = ese.fil_codigo ");
        buf.append("          and exa.exa_codigo = ese.exa_codigo ");
        buf.append("          and ese.ese_default ");
        buf.append("     left join materialcoleta mco on a.fil_codigo = mco.fil_codigo ");
        buf.append("          and a.mco_codigo= mco.mco_codigo ");
        buf.append("     left join examematcoleta emc on a.fil_codigo = emc.fil_codigo ");
        buf.append("          and a.exa_codigo = emc.exa_codigo ");
        buf.append("          and a.mco_codigo = emc.mco_codigo ");
        buf.append("     left join convenios con  on req.fil_codigo  = con.fil_codigo ");
        buf.append("          and req.con_codigo   = con.con_codigo ");
        buf.append("     left join agrupaexameconvenio aec  on a.fil_codigo  = aec.fil_codigo ");
        buf.append("          and a.exa_codigo = aec.exa_codigo ");
        buf.append("          and a.mco_codigo = aec.mco_codigo ");
        buf.append("          and con.con_codigo  = aec.con_codigo ");
        buf.append("          and aec.aec_tipo = '").append("F").append("' ");
        buf.append("     left join agrupaexameconvenio aec2 on a.fil_codigo  = aec2.fil_codigo ");
        buf.append("          and a.exa_codigo  = aec2.exa_codigo ");
        buf.append("          and a.mco_codigo  = aec2.mco_codigo ");
        buf.append("          and aec2.aec_ignorarconvenio ");
        buf.append("          and aec2.aec_tipo = '").append("F").append("' ");
        buf.append("     left join exameagrupaexameconvenio agr  on aec.fil_codigo  = agr.fil_codigo ");
        buf.append("          and aec.exa_codigo = agr.exa_codigo ");
        buf.append("          and aec.mco_codigo = agr.mco_codigo ");
        buf.append("          and aec.con_codigo = agr.con_codigo ");
        buf.append("          and agr.aec_tipo = '").append("F").append("' ");
        buf.append("     left join exameagrupaexameconvenio agr2 on aec2.fil_codigo = agr2.fil_codigo ");
        buf.append("          and aec2.exa_codigo = agr2.exa_codigo ");
        buf.append("          and aec2.mco_codigo = agr2.mco_codigo ");
        buf.append("          and aec2.con_codigo = agr2.con_codigo ");
        buf.append("          and agr.fil_codigo IS NULL ");
        buf.append("          and agr2.aec_tipo = '").append("F").append("' ");
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append("where a.fil_codigo in (");
        for (i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (convenios != null) {
            buf.append(" and req.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (situacoes != null && situacoes.length > 0) {
            buf.append(" and req.sit_codigo in (");
            for (i = 0; i < situacoes.length; ++i) {
                buf.append(situacoes[i]);
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (pacientes != null) {
            buf.append(" and req.pac_codigo in (");
            for (i = 0; i < pacientes.length; ++i) {
                buf.append(pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (medicosCrm != null && medicosUF != null && medicosCrm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (i = 0; i < medicosCrm.length; ++i) {
                buf.append("(req.med_conselho = '");
                buf.append(medicosConselho[i]);
                buf.append("' and req.med_crm = '");
                buf.append(medicosCrm[i]);
                buf.append("' and req.med_uf = '");
                buf.append(medicosUF[i]);
                buf.append("')");
                if (i >= medicosCrm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        if (exames != null) {
            buf.append(" and a.exa_codigo in (");
            for (i = 0; i < exames.length; ++i) {
                buf.append("'");
                buf.append(exames[i]);
                buf.append("'");
                if (i >= exames.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and ese.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append("'");
                buf.append(setores[i]);
                buf.append("'");
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (!intervaloHora.booleanValue()) {
            if (dataInicial != null && Funcoes.verificaData(dataInicial)) {
                buf.append(" and req.req_dtfatura >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataInicial));
                buf.append("'");
            }
            if (dataFinal != null && Funcoes.verificaData(dataFinal)) {
                buf.append(" and req.req_dtfatura <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", dataFinal));
                buf.append("'");
            }
            if (horaInicial != null && Funcoes.verificaHora(horaInicial)) {
                buf.append(" and req.req_horafatura >= '");
                buf.append(horaInicial);
                buf.append("'");
            }
            if (horaFinal != null && Funcoes.verificaHora(horaFinal)) {
                buf.append(" and req.req_horafatura <= '");
                buf.append(horaFinal);
                buf.append("'");
            }
        } else {
            buf.append(" and ((req.req_dtfatura + ");
            buf.append(" req.req_horafatura) >= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ");
            buf.append(horaInicial);
            buf.append("') and ((");
            buf.append(" req.req_dtfatura + ");
            buf.append(" req.req_horafatura) <= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ");
            buf.append(horaFinal);
            buf.append("')");
        }
        if (deveGuia.booleanValue()) {
            buf.append(" and req.req_deveguia = true ");
        }
        buf.append(" and (a.exr_naofaturar <> true or a.exr_naofaturar is null)");
        buf.append(" and a.exr_datafatura is null ");
        buf.append(" and a.exr_datacortesia is null ");
        buf.append(" and req.req_excluida = false and a.exr_excluido = false ");
        if (semCobrancaBalcao.booleanValue()) {
            buf.append(" and (con.con_cobrexame = false or con.con_percpgto < 100) ");
        }
        buf.append(" group by con.con_fantasia, con.con_razao, con.con_codigo ");
        buf.append(" order by con.con_fantasia, con.con_razao, con.con_codigo ");
        return buf.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870102300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870102301");
    }
}

