/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.financeiro.faturamento.ConvenioEntidade;
import jalis.laboratorio.relatorios.financeiro.faturamento.Entidade;
import jalis.laboratorio.relatorios.financeiro.faturamento.ListaConvenioEntidade;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioComissao
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDEM_CONVENIO = "filtroOrdemConvenio";
    private static final String FILTRO_ORDEM_REPRESENTANTE = "filtroOrdemRepresentante";
    private static final String FILTRO_CAMPO_DATA = "filtroDataBanco";
    private static final String FILTRO_MOSTRAR_GERADOS = "filtroMostrarGerados";
    private static final String[] CAMPOS_DATA = new String[]{"Emiss\u00e3o", "Vencimento", "Baixa"};
    private static final String[] ORDEM_CONVENIO = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"};
    private static final String[] ORDEM_REPRESENTANTE = new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"};
    protected static String[] camposConvenio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio"});
    private final String[] camposCadastro = new String[]{"fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private final String[] camposConvenioEntidade = new String[]{"codigoCadastro", "percentualComissao", "tipoParcela", "tipoPagamento", "valorBaseComissao", "valorComissao"};
    private final String[] camposFaturaRequisicao = new String[]{"totalMateriaisFaturaRequisicao", "totalExamesFaturaRequisicao"};
    private final String[] camposFatura = new String[]{"codigosFaturas", "quantidadeExames", "quantidadeRequisicoes", "codigoFilial"};
    private final String[] camposNotaFiscal = new String[]{"codigoNotaFiscal", "numeroNotaFiscal", "valorTotalNotaFiscal"};
    private final String[] camposBaixa = new String[]{"dataUltimaBaixa", "valorBaixado", "codigoUltimaBaixa"};
    private final String[] camposComissao = new String[]{"comissaoGerada", "somatorioValorBaseComissao", "somatorioValorComissao"};
    private String[] camposRelatorio = new String[0];
    private PreparedStatement prstCadastro;

    public RelatorioComissao() {
        this.montaBarraDescricao("Comiss\u00e3o de representantes", "Listagem das comiss\u00f5es dos representates dos conv\u00eanios no per\u00edodo", "relatorios/rel_financeiro_faturamento_comissao_representante.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ENTIDADE, "Representante", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "R" + "' and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial", "ent_fantasia"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOS_DATA, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM_REPRESENTANTE, "Ord Represe.:", ORDEM_REPRESENTANTE, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM_CONVENIO, "Ord Conv\u00eanio:", ORDEM_CONVENIO, 0);
        this.adicionaFiltroCheck(FILTRO_MOSTRAR_GERADOS, "Mostrar Gerados", false);
        this.setModuloConfigurar(RelatorioComissao.getModuloConfigurar());
        this.setModuloAcesso(RelatorioComissao.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposConvenio);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposFatura);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposConvenioEntidade);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposFaturaRequisicao);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastro);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposNotaFiscal);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposBaixa);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposComissao);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block60: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select ent.ent_codigo as codigoCadastro ");
            buf.append("       ,ent.ent_fantasia as fantasiaCadastro ");
            buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
            buf.append("       ,ent.ent_fone as foneCadastro ");
            buf.append("       ,ent.ent_endereco as enderecoCadastro ");
            buf.append("       ,ent.ent_numeroendereco as numeroEnderecoCadastro ");
            buf.append("       ,ent.ent_tipologradouroendereco as tipoLogradouroCadastro ");
            buf.append("       ,ent.ent_fax as faxCadastro ");
            buf.append("       ,ent.ent_complemento as complementoCadastro ");
            buf.append("       ,ent.ent_cep as cepCadastro ");
            buf.append("       ,ent.cid_codigo as codigoCidadeCadastro ");
            buf.append("       ,cident.cid_nome as nomeCidadeCadastro ");
            buf.append("   from entidade ent ");
            buf.append("   left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("  where ent.fil_codigo = ? ");
            buf.append("    and ent.ent_codigo = ? ");
            this.prstCadastro = Conexao.getPreparedStatement(buf.toString());
            ArrayList<ConvenioEntidade> listaFaturamento = new ArrayList<ConvenioEntidade>();
            ArrayList<ConvenioEntidade> listaNotaFiscal = new ArrayList<ConvenioEntidade>();
            ArrayList<ConvenioEntidade> listaBaixa = new ArrayList<ConvenioEntidade>();
            String filial = null;
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null) {
                filial = Variaveis.filialPadrao;
            } else {
                if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length > 1) {
                    Funcoes.mensagem(this, "Somente uma filial pode ser selecionada.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                filial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
            }
            try {
                ConvenioEntidade aux;
                String[] entidade;
                this.setCursor(Cursor.getPredefinedCursor(3));
                buf.setLength(0);
                buf.append(" select cen_tipoparcela as tipo ");
                buf.append("       ,con_codigo as convenio ");
                buf.append("       ,ent_codigo as entidade ");
                buf.append("   from convenioentidade ");
                buf.append("  where fil_codigo = ").append(filial);
                String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
                if (convenio != null) {
                    buf.append("  and con_codigo IN (");
                    for (int i = 0; i < convenio.length; ++i) {
                        buf.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0)) != null) {
                    buf.append(" and ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        buf.append(entidade[i]);
                        if (i >= entidade.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append("  order by cen_tipoparcela ");
                buf.append("          ,con_codigo ");
                buf.append("          ,ent_codigo ");
                ListaConvenioEntidade listaConvenioEntidade = new ListaConvenioEntidade();
                ResultSet rsConvenioEntidade = Conexao.executeQuery(Conexao.getStatement(), buf);
                while (rsConvenioEntidade.next()) {
                    ConvenioEntidade convenioEntidade = new ConvenioEntidade(rsConvenioEntidade.getInt("convenio"), rsConvenioEntidade.getInt("entidade"));
                    if (rsConvenioEntidade.getString("tipo").equalsIgnoreCase("C") || rsConvenioEntidade.getString("tipo").equalsIgnoreCase("N")) {
                        listaFaturamento.add(convenioEntidade);
                    } else if (rsConvenioEntidade.getString("tipo").equalsIgnoreCase("F")) {
                        listaNotaFiscal.add(convenioEntidade);
                    } else if (rsConvenioEntidade.getString("tipo").equalsIgnoreCase("B")) {
                        listaBaixa.add(convenioEntidade);
                    }
                    if (listaConvenioEntidade.getEntidadeConfigurada(convenioEntidade) != null) continue;
                    listaConvenioEntidade.adicionaConvenioEntidade(convenioEntidade);
                }
                buf.setLength(0);
                if (listaFaturamento.size() > 0) {
                    buf.append("(select distinct nfi.nfi_codigo as codigoNotaFiscal ");
                    buf.append("       ,nfi.nfi_numero as numeroNotaFiscal ");
                    buf.append("       ,nfi.nfi_valortotal as valorTotalNotaFiscal ");
                    buf.append("       ,a.fil_codigo as codigoFilial ");
                    buf.append("       ,con.con_codigo as codigoConvenio ");
                    buf.append("       ,con.con_razao as razaoSocialConvenio ");
                    buf.append("       ,con.con_fantasia as fantasiaConvenio ");
                    buf.append("       ,ent.ent_codigo as codigoCadastro ");
                    buf.append("       ,ent.ent_fantasia as fantasiaCadastro ");
                    buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
                    buf.append("       ,ent.ent_fone as foneCadastro ");
                    buf.append("       ,ent.ent_endereco as enderecoCadastro ");
                    buf.append("       ,ent.ent_numeroendereco as numeroEnderecoCadastro ");
                    buf.append("       ,ent.ent_tipologradouroendereco as tipoLogradouroCadastro ");
                    buf.append("       ,ent.ent_fax as faxCadastro ");
                    buf.append("       ,ent.ent_complemento as complementoCadastro ");
                    buf.append("       ,ent.ent_cep as cepCadastro ");
                    buf.append("       ,ent.cid_codigo as codigoCidadeCadastro ");
                    buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_valortotal, 0) ELSE 0 END) as valorTotalBaixa ");
                    buf.append("       ,(a.fat_totalexames + a.fat_totalmateriais + a.fat_adicional + a.fat_despcobranca - ((a.fat_totalexames + a.fat_totalmateriais) * a.fat_percdesconto / 100)) as valorBaseComissao ");
                    buf.append("       ,(a.fat_totalexames + a.fat_totalmateriais + a.fat_adicional + a.fat_despcobranca - ((a.fat_totalexames + a.fat_totalmateriais) * a.fat_percdesconto / 100)) * cen.cen_comissao / 100 as valorComissao ");
                    buf.append("       ,cen.cen_tipoparcela as tipoParcela ");
                    buf.append("       ,cen.cen_tipopagamento as tipoPagamento ");
                    buf.append("       ,cen.cen_comissao as percentualComissao ");
                    buf.append("       ,0 as quantidadeExames ");
                    buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
                    buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
                    buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
                    buf.append("\t\t   ,MAX(bxa.bxa_codigo) as codigoUltimaBaixa ");
                    buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataUltimaBaixa ");
                    buf.append("\t\t   ,MAX(bxa.bxa_valortotal) as valorBaixado ");
                    buf.append("       ,MAX(rpg.rpg_codigo) as codigoReceber ");
                    buf.append("       ,array_to_string(array_agg(distinct a.fat_codigo), ', ') as codigosFaturas ");
                    buf.append("       ,'F' as tipoComissao ");
                    buf.append("       ,((select COUNT(1) ");
                    buf.append("           from faturareceberpagar frp ");
                    buf.append("           join receberpagar       rpg on frp.fil_codigo = rpg.fil_codigo and frp.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("          where rpg.rpg_origem = '").append("C").append("' ");
                    buf.append("            and rpg.rpg_tipo = '").append("P").append("' ");
                    buf.append("            and frp.fil_codigo = a.fil_codigo ");
                    buf.append("            and frp.fat_codigo = a.fat_codigo ");
                    buf.append("            and frp.frp_tipo = '").append("C").append("' ");
                    buf.append("            and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("')) ");
                    buf.append(" + ");
                    buf.append("        (select COUNT(1) ");
                    buf.append("           from receberpagarrp   rrp ");
                    buf.append("           join receberpagar     rpg2 on rrp.fil_kodigo = rpg2.fil_codigo and rrp.rpg_kodigo = rpg2.rpg_codigo ");
                    buf.append("          where rpg2.rpg_origem = '").append("C").append("' ");
                    buf.append("            and rpg2.rpg_tipo = '").append("P").append("' ");
                    buf.append("            and rpg2.ent_codigo = cen.ent_codigo ");
                    buf.append("            and rrp.rrp_tipo = '").append("C").append("' ");
                    buf.append("            and rrp.fil_codigo = a.fil_codigo ");
                    buf.append("            and rrp.rpg_codigo IN (select rpg_codigo ");
                    buf.append("                                     from receberpagar ");
                    buf.append("                                    where fil_codigo = a.fil_codigo ");
                    buf.append("                                      and nfi_codigo = nfi.nfi_codigo ");
                    buf.append("                                      and rpg_origem = '").append("N").append("' ");
                    buf.append("                                      and rpg_tipo = '").append("R").append("' ");
                    buf.append("                                      and rpg_situacao <> '").append("C").append("') ");
                    buf.append("            and rpg2.rpg_situacao <> '").append("X").append("')) > 0 as comissaoGerada ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("   from fatura a ");
                    buf.append("   join faturarequisicao \t      fre on (a.fil_codigo = fre.fil_codigo and a.fat_codigo \t= fre.fat_codigo) ");
                    buf.append("   join requisicao \t\t\t\t      req on (fre.fil_codigo = req.fil_codigo and fre.req_codigo = req.req_codigo) ");
                    buf.append("   join convenios \t\t\t\t      con on (a.fil_codigo = con.fil_codigo and a.con_codigo \t= con.con_codigo) ");
                    buf.append("   join convenioentidade \t      cen on (con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo) ");
                    buf.append("   join entidade \t\t\t\t\t      ent on (cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo) ");
                    buf.append("   left join faturanotafiscal   fnf on a.fil_codigo = fnf.fil_codigo and a.fat_codigo \t= fnf.fat_codigo ");
                    buf.append("   left join notafiscal \t\t\t  nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo and nfi.usr_codcancelada IS NULL ");
                    buf.append("   left join receberpagar       rpg on nfi.fil_codigo = rpg.fil_codigo and nfi.nfi_codigo = rpg.nfi_codigo and rpg.rpg_origem = '").append("N").append("' and rpg.rpg_tipo = '").append("R").append("' and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("') ");
                    buf.append("   left join baixareceberpagar  brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
                    buf.append("   left join baixa \t\t\t\t\t\t  bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao = '").append("Q").append("' ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append("  where a.fat_datacancelamento IS NULL ");
                    buf.append("    and a.fil_codigo = ").append(filial);
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                        buf.append("'");
                    }
                    buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
                    for (int i = 0; i < listaFaturamento.size(); ++i) {
                        aux = (ConvenioEntidade)listaFaturamento.get(i);
                        buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                        if (i >= listaFaturamento.size() - 1) continue;
                        buf.append(" UNION select ");
                    }
                    buf.append(") ");
                    buf.append("  group by nfi.nfi_codigo ");
                    buf.append("          ,a.fat_codigo ");
                    buf.append("          ,a.fil_codigo ");
                    buf.append("          ,con.con_codigo ");
                    buf.append("          ,con.con_fantasia ");
                    buf.append("          ,cen.cen_comissao ");
                    buf.append("          ,ent.ent_codigo ");
                    buf.append("          ,ent.ent_fantasia ");
                    buf.append("          ,ent.ent_razaosocial ");
                    buf.append("          ,ent.ent_fone ");
                    buf.append("          ,ent.ent_endereco ");
                    buf.append("          ,ent.ent_numeroendereco ");
                    buf.append("          ,ent.ent_tipologradouroendereco ");
                    buf.append("          ,ent.ent_fax ");
                    buf.append("          ,ent.ent_complemento ");
                    buf.append("          ,ent.ent_cep ");
                    buf.append("          ,ent.cid_codigo ");
                    buf.append("          ,a.fat_totalexames ");
                    buf.append("          ,a.fat_totalmateriais ");
                    buf.append("          ,a.fat_adicional ");
                    buf.append("          ,a.fat_despcobranca ");
                    buf.append("          ,a.fat_percdesconto ");
                    buf.append("          ,cen.ent_codigo ");
                    buf.append("          ,nfi.nfi_numero ");
                    buf.append("          ,nfi.nfi_valortotal ");
                    buf.append("          ,con.con_razao ");
                    buf.append("          ,cen.cen_tipoparcela ");
                    buf.append("          ,cen.cen_tipopagamento ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                    buf.append(" having CASE WHEN MAX(nfi.nfi_codigo) IS NOT NULL THEN nfi.nfi_codigo IS NOT NULL ELSE true END ");
                    buf.append(") ");
                }
                if (listaBaixa.size() > 0) {
                    if (buf.length() > 0) {
                        buf.append(" UNION ");
                    }
                    buf.append("(select distinct nfi.nfi_codigo as codigoNotaFiscal ");
                    buf.append("       ,nfi.nfi_numero as numeroNotaFiscal ");
                    buf.append("       ,nfi.nfi_valortotal as valorTotalNotaFiscal ");
                    buf.append("       ,a.fil_codigo as codigoFilial ");
                    buf.append("       ,con.con_codigo as codigoConvenio ");
                    buf.append("       ,con.con_razao as razaoSocialConvenio ");
                    buf.append("       ,con.con_fantasia as fantasiaConvenio ");
                    buf.append("       ,ent.ent_codigo as codigoCadastro ");
                    buf.append("       ,ent.ent_fantasia as fantasiaCadastro ");
                    buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
                    buf.append("       ,ent.ent_fone as foneCadastro ");
                    buf.append("       ,ent.ent_endereco as enderecoCadastro ");
                    buf.append("       ,ent.ent_numeroendereco as numeroEnderecoCadastro ");
                    buf.append("       ,ent.ent_tipologradouroendereco as tipoLogradouroCadastro ");
                    buf.append("       ,ent.ent_fax as faxCadastro ");
                    buf.append("       ,ent.ent_complemento as complementoCadastro ");
                    buf.append("       ,ent.ent_cep as cepCadastro ");
                    buf.append("       ,ent.cid_codigo as codigoCidadeCadastro ");
                    buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_valortotal, 0) ELSE 0 END as valorTotalBaixa ");
                    buf.append("       ,CASE WHEN a.rpg_codigo IS NOT NULL THEN COALESCE(a.rpg_valortotal, 0) ELSE SUM((fat.fat_totalexames + fat.fat_totalmateriais + fat.fat_adicional + fat.fat_despcobranca - ((fat.fat_totalexames + fat.fat_totalmateriais) * fat.fat_percdesconto / 100))) END as valorBaseComissao ");
                    buf.append("       ,CASE WHEN a.rpg_codigo IS NOT NULL THEN (COALESCE(a.rpg_valortotal, 0) * cen.cen_comissao / 100) ELSE SUM((fat.fat_totalexames + fat.fat_totalmateriais + fat.fat_adicional + fat.fat_despcobranca - ((fat.fat_totalexames + fat.fat_totalmateriais) * fat.fat_percdesconto / 100)) * cen.cen_comissao / 100) END as valorComissao ");
                    buf.append("       ,cen.cen_tipoparcela as tipoParcela ");
                    buf.append("       ,cen.cen_tipopagamento as tipoPagamento ");
                    buf.append("       ,cen.cen_comissao as percentualComissao ");
                    buf.append("       ,0 as quantidadeExames ");
                    buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
                    buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
                    buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
                    buf.append("\t\t   ,MAX(bxa.bxa_codigo) as codigoUltimaBaixa ");
                    buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataUltimaBaixa ");
                    buf.append("\t\t   ,MAX(bxa.bxa_valortotal) as valorBaixado ");
                    buf.append("       ,a.rpg_codigo as codigoReceber ");
                    buf.append("       ,array_to_string(array_agg(distinct fat.fat_codigo), ', ') as codigosFaturas ");
                    buf.append("       ,'B' as tipoComissao ");
                    buf.append("       ,(select COUNT(1) ");
                    buf.append("           from receberpagarrp   rrp ");
                    buf.append("           join receberpagar     rpg2 on rrp.fil_kodigo = rpg2.fil_codigo and rrp.rpg_kodigo = rpg2.rpg_codigo ");
                    buf.append("          where rpg2.rpg_origem = '").append("C").append("' ");
                    buf.append("            and rpg2.rpg_tipo = '").append("P").append("' ");
                    buf.append("            and rpg2.ent_codigo = cen.ent_codigo ");
                    buf.append("            and rrp.rrp_tipo = '").append("C").append("' ");
                    buf.append("            and rrp.fil_codigo = a.fil_codigo ");
                    buf.append("            and rrp.rpg_codigo = a.rpg_codigo ");
                    buf.append("            and rpg2.rpg_situacao <> '").append("X").append("') > 0 as comissaoGerada ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("   from receberpagar     a ");
                    buf.append("   join notafiscal       nfi on a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo ");
                    buf.append("   join faturanotafiscal fnf on nfi.fil_codigo = fnf.fil_codigo and nfi.nfi_codigo = fnf.nfi_codigo ");
                    buf.append("   join fatura           fat on fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
                    buf.append("   join faturarequisicao fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
                    buf.append("   join requisicao \t\t\t req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
                    buf.append("   join baixareceberpagar\tbrp on a.fil_codigo = brp.fil_codigo and a.rpg_codigo = brp.rpg_codigo ");
                    buf.append("   join baixa \t\t\t\t\t\tbxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo ");
                    buf.append("   join convenios \t\t\t con on nfi.fil_codigo = con.fil_codigo and nfi.con_codigo = con.con_codigo ");
                    buf.append("   join convenioentidade cen on con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo ");
                    buf.append("   join entidade \t\t\t\t ent on cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append("  where fat.fat_datacancelamento IS NULL ");
                    buf.append("    and nfi.usr_codcancelada IS NULL ");
                    buf.append("    and a.rpg_tipo = '").append("R").append("' and a.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') ");
                    buf.append("    and bxa.bxa_situacao = '").append("Q").append("' ");
                    buf.append("    and nfi.fil_codigo = ").append(filial);
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                        buf.append("'");
                    }
                    buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
                    for (int i = 0; i < listaBaixa.size(); ++i) {
                        aux = (ConvenioEntidade)listaBaixa.get(i);
                        buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                        if (i >= listaBaixa.size() - 1) continue;
                        buf.append(" UNION select ");
                    }
                    buf.append(") ");
                    buf.append("  group by nfi.nfi_codigo ");
                    buf.append("          ,a.fil_codigo ");
                    buf.append("          ,con.con_codigo ");
                    buf.append("          ,con.con_fantasia ");
                    buf.append("          ,bxa.bxa_codigo ");
                    buf.append("          ,a.rpg_valortotal ");
                    buf.append("          ,a.rpg_codigo ");
                    buf.append("          ,cen.cen_comissao ");
                    buf.append("          ,ent.ent_codigo ");
                    buf.append("          ,ent.ent_fantasia ");
                    buf.append("          ,ent.ent_razaosocial ");
                    buf.append("          ,ent.ent_fone ");
                    buf.append("          ,ent.ent_endereco ");
                    buf.append("          ,ent.ent_numeroendereco ");
                    buf.append("          ,ent.ent_tipologradouroendereco ");
                    buf.append("          ,ent.ent_fax ");
                    buf.append("          ,ent.ent_complemento ");
                    buf.append("          ,ent.ent_cep ");
                    buf.append("          ,ent.cid_codigo ");
                    buf.append("          ,cen.ent_codigo ");
                    buf.append("          ,nfi.nfi_numero ");
                    buf.append("          ,nfi.nfi_valortotal ");
                    buf.append("          ,con.con_razao ");
                    buf.append("          ,cen.cen_tipoparcela ");
                    buf.append("          ,cen.cen_tipopagamento ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                    buf.append(") ");
                }
                if (listaNotaFiscal.size() > 0) {
                    if (buf.length() > 0) {
                        buf.append(" UNION ");
                    }
                    buf.append("(select distinct a.nfi_codigo as codigoNotaFiscal ");
                    buf.append("       ,a.nfi_numero as numeroNotaFiscal ");
                    buf.append("       ,a.nfi_valortotal as valorTotalNotaFiscal ");
                    buf.append("       ,a.fil_codigo as codigoFilial ");
                    buf.append("       ,con.con_codigo as codigoConvenio ");
                    buf.append("       ,con.con_razao as razaoSocialConvenio ");
                    buf.append("       ,con.con_fantasia as fantasiaConvenio ");
                    buf.append("       ,ent.ent_codigo as codigoCadastro ");
                    buf.append("       ,ent.ent_fantasia as fantasiaCadastro ");
                    buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
                    buf.append("       ,ent.ent_fone as foneCadastro ");
                    buf.append("       ,ent.ent_endereco as enderecoCadastro ");
                    buf.append("       ,ent.ent_numeroendereco as numeroEnderecoCadastro ");
                    buf.append("       ,ent.ent_tipologradouroendereco as tipoLogradouroCadastro ");
                    buf.append("       ,ent.ent_fax as faxCadastro ");
                    buf.append("       ,ent.ent_complemento as complementoCadastro ");
                    buf.append("       ,ent.ent_cep as cepCadastro ");
                    buf.append("       ,ent.cid_codigo as codigoCidadeCadastro ");
                    buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_valortotal, 0) ELSE 0 END as valorTotalBaixa ");
                    buf.append("       ,a.nfi_valortotal as valorBaseComissao ");
                    buf.append("       ,a.nfi_valortotal * cen.cen_comissao / 100 as valorComissao ");
                    buf.append("       ,cen.cen_tipoparcela as tipoParcela ");
                    buf.append("       ,cen.cen_tipopagamento as tipoPagamento ");
                    buf.append("       ,cen.cen_comissao as percentualComissao ");
                    buf.append("       ,0 as quantidadeExames ");
                    buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
                    buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
                    buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
                    buf.append("\t\t   ,MAX(bxa.bxa_codigo) as codigoUltimaBaixa ");
                    buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataUltimaBaixa ");
                    buf.append("\t\t   ,MAX(bxa.bxa_valortotal) as valorBaixado ");
                    buf.append("       ,MAX(rpg2.rpg_codigo) as codigoReceber ");
                    buf.append("       ,array_to_string(array_agg(distinct fat.fat_codigo), ', ') as codigosFaturas ");
                    buf.append("       ,'N' as tipoComissao ");
                    buf.append("       ,rpg.rpg_codigo IS NOT NULL as comissaoGerada ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("   from notafiscal       a ");
                    buf.append("   join faturanotafiscal fnf on a.fil_codigo = fnf.fil_codigo and a.nfi_codigo = fnf.nfi_codigo ");
                    buf.append("   join fatura           fat on fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
                    buf.append("   join faturarequisicao fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
                    buf.append("   join requisicao \t\t\t req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
                    buf.append("   join convenios \t\t\t con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                    buf.append("   join convenioentidade cen on con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo ");
                    buf.append("   join entidade \t\t\t\t ent on cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo ");
                    buf.append("   left join receberpagar      rpg on a.fil_codigo = rpg.fil_codigo and a.nfi_codigo = rpg.nfi_codigo and rpg.rpg_tipo = '").append("P").append("' and rpg.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') and rpg.rpg_origem = '").append("C").append("' ");
                    buf.append("   left join receberpagar      rpg2 on a.fil_codigo = rpg2.fil_codigo and a.nfi_codigo = rpg2.nfi_codigo and rpg2.rpg_tipo = '").append("R").append("' and rpg2.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') and rpg2.rpg_origem = '").append("N").append("' ");
                    buf.append("   left join baixareceberpagar brp on rpg2.fil_codigo = brp.fil_codigo and rpg2.rpg_codigo = brp.rpg_codigo ");
                    buf.append("   left join baixa \t\t\t\t\t\t bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao = '").append("Q").append("' ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append("  where fat.fat_datacancelamento IS NULL ");
                    buf.append("    and a.usr_codcancelada IS NULL ");
                    buf.append("    and a.fil_codigo = ").append(filial);
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        buf.append(" and ").append(this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Emiss\u00e3o") ? "fat_dtemis" : (this.getFiltroCombo(FILTRO_CAMPO_DATA).equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                        buf.append("'");
                    }
                    buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
                    for (int i = 0; i < listaNotaFiscal.size(); ++i) {
                        aux = (ConvenioEntidade)listaNotaFiscal.get(i);
                        buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                        if (i >= listaNotaFiscal.size() - 1) continue;
                        buf.append(" UNION select ");
                    }
                    buf.append(") ");
                    buf.append("  group by a.nfi_codigo ");
                    buf.append("          ,a.fil_codigo ");
                    buf.append("          ,con.con_codigo ");
                    buf.append("          ,con.con_fantasia ");
                    buf.append("          ,bxa.bxa_codigo ");
                    buf.append("          ,rpg2.rpg_valortotal ");
                    buf.append("          ,rpg.rpg_codigo ");
                    buf.append("          ,cen.cen_comissao ");
                    buf.append("          ,ent.ent_codigo ");
                    buf.append("          ,ent.ent_fantasia ");
                    buf.append("          ,ent.ent_razaosocial ");
                    buf.append("          ,ent.ent_fone ");
                    buf.append("          ,ent.ent_endereco ");
                    buf.append("          ,ent.ent_numeroendereco ");
                    buf.append("          ,ent.ent_tipologradouroendereco ");
                    buf.append("          ,ent.ent_fax ");
                    buf.append("          ,ent.ent_complemento ");
                    buf.append("          ,ent.ent_cep ");
                    buf.append("          ,ent.cid_codigo ");
                    buf.append("          ,a.nfi_valortotal ");
                    buf.append("          ,cen.ent_codigo ");
                    buf.append("          ,a.nfi_numero ");
                    buf.append("          ,a.nfi_valortotal ");
                    buf.append("          ,con.con_razao ");
                    buf.append("          ,cen.cen_tipoparcela ");
                    buf.append("          ,cen.cen_tipopagamento ");
                    buf.append(" , ");
                    buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                    buf.append(") ");
                }
                buf.insert(0, " select * from ( ");
                buf.append(") comissao ");
                buf.append(" order by ");
                if (this.getFiltroCombo(FILTRO_ORDEM_REPRESENTANTE).equals(ORDEM_REPRESENTANTE[0])) {
                    buf.append(" codigoCadastro ");
                } else if (this.getFiltroCombo(FILTRO_ORDEM_REPRESENTANTE).equals(ORDEM_REPRESENTANTE[1])) {
                    buf.append(" fantasiaCadastro ");
                } else if (this.getFiltroCombo(FILTRO_ORDEM_REPRESENTANTE).equals(ORDEM_REPRESENTANTE[2])) {
                    buf.append(" razaoSocialCadastro ");
                }
                if (this.getFiltroCombo(FILTRO_ORDEM_CONVENIO).equals(ORDEM_CONVENIO[0])) {
                    buf.append(" ,codigoConvenio ");
                } else if (this.getFiltroCombo(FILTRO_ORDEM_CONVENIO).equals(ORDEM_CONVENIO[1])) {
                    buf.append(" ,fantasiaConvenio ");
                } else if (this.getFiltroCombo(FILTRO_ORDEM_CONVENIO).equals(ORDEM_CONVENIO[2])) {
                    buf.append(" ,razaoSocialConvenio ");
                }
                boolean mostrarGerados = this.getFiltroCheck(FILTRO_MOSTRAR_GERADOS);
                if (listaFaturamento.size() > 0 || listaBaixa.size() > 0 || listaNotaFiscal.size() > 0) {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                        do {
                            if (!mostrarGerados && rs.getBoolean("comissaoGerada")) continue;
                            ConvenioEntidade convenioEntidade = listaConvenioEntidade.getEntidadeConfigurada(new ConvenioEntidade(rs.getInt("codigoConvenio"), rs.getInt("codigoCadastro")));
                            int pos = -1;
                            Object[] o = new Object[this.camposRelatorio.length];
                            for (int i = 0; i < this.camposRelatorio.length; ++i) {
                                pos = modelo.findColumn(this.camposRelatorio[i]);
                                if (this.camposRelatorio[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                                    o[pos] = Tipos.tipoLogradouroDescricao(rs.getString(this.camposRelatorio[i]));
                                    continue;
                                }
                                if (this.camposRelatorio[i].equalsIgnoreCase("tipoParcela")) {
                                    o[pos] = Tipos.tipoGerarParcelasComissao(rs.getString(this.camposRelatorio[i]));
                                    continue;
                                }
                                if (this.camposRelatorio[i].equalsIgnoreCase("tipoPagamento")) {
                                    o[pos] = Tipos.tipoParcelamentoComissao(this.camposRelatorio[i]);
                                    continue;
                                }
                                if (ArraysUtil.contem(this.camposComissao, this.camposRelatorio[i])) continue;
                                if (this.camposRelatorio[i].equalsIgnoreCase("quantidadeExames")) {
                                    o[pos] = this.getQuantidadeExamesFaturas(rs.getInt("codigoFilial"), rs.getString("codigosFaturas"));
                                    continue;
                                }
                                if (this.camposRelatorio[i].equalsIgnoreCase("valorBaseComissao")) {
                                    listaConvenioEntidade.adicionaValorBaseComissao(convenioEntidade, rs.getBigDecimal("valorBaseComissao"));
                                    o[pos] = rs.getObject(this.camposRelatorio[i]);
                                    continue;
                                }
                                if (this.camposRelatorio[i].equalsIgnoreCase("valorComissao")) {
                                    listaConvenioEntidade.adicionaValorComissao(convenioEntidade, rs.getBigDecimal("valorComissao"));
                                    o[pos] = rs.getObject(this.camposRelatorio[i]);
                                    continue;
                                }
                                o[pos] = rs.getObject(this.camposRelatorio[i]);
                            }
                            modelo.addLine(o);
                        } while (rs.next());
                        for (int i = 0; i < modelo.getRowCount(); ++i) {
                            Entidade aux2 = new Entidade((Integer)modelo.getValueAt(i, modelo.findColumn("codigoCadastro")));
                            modelo.setValueAt(listaConvenioEntidade.getSomatorioValorBase(aux2), i, modelo.findColumn("somatorioValorBaseComissao"));
                            modelo.setValueAt(listaConvenioEntidade.getSomatorioValorComissao(aux2), i, modelo.findColumn("somatorioValorComissao"));
                        }
                        if (modelo.getRowCount() > 0) {
                            buf.delete(0, buf.length());
                            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                            buf.append(RelatorioComissao.getModuloAcesso());
                            rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                                gerador.setPai(this.panelCentro);
                                gerador.setPreVisualizar(true);
                                gerador.setZoomPreVisualizar(1.0f);
                                gerador.setAcaoFechar(new Runnable(){

                                    @Override
                                    public void run() {
                                        RelatorioComissao.this.panelCentro.removeAll();
                                        RelatorioComissao.this.panelCentro.repaint();
                                        RelatorioComissao.this.habilitaBotaoImprimir(true);
                                    }
                                });
                                HashMap<String, Object> var = new HashMap<String, Object>();
                                var.put(FILTRO_ORDEM_CONVENIO, this.getFiltroCombo(FILTRO_ORDEM_CONVENIO));
                                var.put(FILTRO_ORDEM_REPRESENTANTE, this.getFiltroCombo(FILTRO_ORDEM_REPRESENTANTE));
                                var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                                var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                                var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                                var.put(FILTRO_MOSTRAR_GERADOS, this.getFiltroCheck(FILTRO_MOSTRAR_GERADOS) ? "Sim" : "N\u00e3o");
                                var.put(FILTRO_FILIAL, filial);
                                buf.delete(0, buf.length());
                                if (convenio != null) {
                                    for (int i = 0; i < convenio.length; ++i) {
                                        buf.append(convenio[i]);
                                        if (i >= convenio.length - 1) continue;
                                        buf.append(", ");
                                    }
                                }
                                var.put(FILTRO_CONVENIO, buf.toString());
                                buf.delete(0, buf.length());
                                if (entidade != null) {
                                    for (int i = 0; i < entidade.length; ++i) {
                                        buf.append(entidade[i]);
                                        if (i >= entidade.length - 1) continue;
                                        buf.append(", ");
                                    }
                                }
                                var.put(FILTRO_ENTIDADE, buf.toString());
                                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                                this.panelCentro.revalidate();
                            }
                        } else {
                            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                            this.habilitaBotaoImprimir(true);
                        }
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block60;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioComissao");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int getQuantidadeExamesFaturas(int codigoFilial, String codigosFaturas) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(fat_qtdeexames) as qtde ");
        buf.append("   from fatura ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and fat_codigo IN (").append(codigosFaturas).append(") ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                return rs.getInt("qtde");
            }
        }
        catch (SQLException sqle) {
            return 0;
        }
        return 0;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870101500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0870101501");
    }

    private void preencheDadosCadastro(Object[] array, ModeloGridTable modelo, ConvenioEntidade convenioEntidade) throws SQLException {
        if (convenioEntidade != null) {
            array[modelo.findColumn((String)"fantasiaCadastro")] = convenioEntidade.fantasiaCadastro;
            array[modelo.findColumn((String)"razaoSocialCadastro")] = convenioEntidade.razaoSocialCadastro;
            array[modelo.findColumn((String)"foneCadastro")] = convenioEntidade.foneCadastro;
            array[modelo.findColumn((String)"enderecoCadastro")] = convenioEntidade.enderecoCadastro;
            array[modelo.findColumn((String)"faxCadastro")] = convenioEntidade.faxCadastro;
            array[modelo.findColumn((String)"complementoCadastro")] = convenioEntidade.complementoCadastro;
            array[modelo.findColumn((String)"cepCadastro")] = convenioEntidade.cepCadastro;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pegaDadosCadastro(PreparedStatement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo, ConvenioEntidade convenioEntidade) throws SQLException {
        st.setInt(1, filial);
        st.setInt(2, codigo);
        try (ResultSet rs = null;){
            rs = st.executeQuery();
            if (rs.next() && convenioEntidade != null) {
                convenioEntidade.fantasiaCadastro = rs.getString("fantasiaCadastro");
                convenioEntidade.razaoSocialCadastro = rs.getString("razaoSocialCadastro");
                convenioEntidade.foneCadastro = rs.getString("foneCadastro");
                convenioEntidade.enderecoCadastro = rs.getString("enderecoCadastro");
                convenioEntidade.faxCadastro = rs.getString("faxCadastro");
                convenioEntidade.complementoCadastro = rs.getString("complementoCadastro");
                convenioEntidade.cepCadastro = rs.getString("cepCadastro");
                this.preencheDadosCadastro(array, modelo, convenioEntidade);
            }
        }
    }
}

