/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class RelatorioBPA
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo AMB", "Qtde Exames", "Qtde Requisi\u00e7\u00f5es"};
    private final String FILTRO_FATURA = "filtroFatura";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String AGRUPA_CODIGO_AMB = "filtroAgrupaCodAmb";
    public static String[] campos;

    public RelatorioBPA() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "codigoMetodologia", "dataEmissaoFatura", "dataVencimentoFatura", "dataConferenciaFatura", "dataInicialFatura", "dataFinalFatura", "valorExame", "valorMaterial", "valorCH", "codigoExame", "descricaoExame", "codigoAMB", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "quantidadeExames", "quantidadeRequisicoes", "mensagemFatura"});
        this.montaBarraDescricao("Relat\u00f3rio Boletim de Produ\u00e7\u00e3o Ambulatorial", "Listagem dos exames faturados no per\u00edodo para entrega de BPA", "relatorios/rel_bpa.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa("filtroFatura", "Fatura", 5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp;
                Hashtable hash = Pesquisas.fatura(RelatorioBPA.this.getTopLevelAncestor());
                if (hash != null && (tmp = hash.get("fat_codigo").toString()) != null) {
                    RelatorioBPA.this.setFiltroComPesquisa("filtroFatura", tmp);
                }
            }
        }, 1);
        this.adicionaFiltroCombo("filtroOrdem", "Ordem", this.ordem, 0);
        this.adicionaFiltroCheck("filtroAgrupaCodAmb", " Agrupa por C\u00f3digo AMB", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioBPA.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (Funcoes.textoVazio(this.getFiltroComPesquisa("filtroFatura"))) {
            Funcoes.mensagem(this, "O c\u00f3digo da fatura deve ser informado", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        System.gc();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder bufWhere = new StringBuilder();
        try {
            ModeloGridTable modelo = new ModeloGridTable(campos);
            ResultSet rs = null;
            StringBuilder buf = new StringBuilder();
            if (!this.agruparPorCodAmb()) {
                buf.append(" select count(a.exa_codigo) as quantidadeExames \t\t\t\t");
                buf.append("       ,sum(a.fer_total) as valorExame \t\t\t\t\t\t\t\t\t");
                buf.append("       ,sum(a.fer_totalch) as valorCH \t\t\t\t\t\t\t\t\t");
                buf.append("       ,sum(a.fer_totalmateriais) as valorMaterial \t\t\t");
                buf.append("       ,d.con_fantasia as fantasiaConvenio \t\t\t\t\t\t\t");
                buf.append("       ,d.con_codigo as codigoConvenio\t\t\t\t\t\t\t\t\t");
                buf.append("       ,d.con_razao as razaoSocialConvenio \t\t\t\t\t\t\t");
                buf.append("       ,fat.fat_dtinicio as dataInicialFatura \t\t\t\t\t");
                buf.append("       ,fat.fat_dtfim as dataFinalFatura \t\t\t\t\t\t\t\t");
                buf.append("       ,fat.fat_dtemis as dataEmissaoFatura \t\t\t\t\t\t");
                buf.append("       ,fat.fat_dtvenc as dataVencimentoFatura \t\t\t\t\t");
                buf.append("       ,fat.fat_dtconferencia as dataConferenciaFatura \t");
                buf.append("       ,c.exa_codigo as codigoExame \t\t\t\t\t\t\t\t\t\t");
                buf.append("       ,c.exa_descricao as descricaoExame \t\t\t\t\t\t\t");
                buf.append("       ,a.mco_codfilho as codigoMaterialColetado \t\t\t\t");
                buf.append("       ,m.mco_descricao as descricaoMaterialColetado \t\t");
                buf.append("       ,m.mco_abreviatura as abreviaturaMaterialColetado");
                buf.append("       ,'' as codigoAMB ");
                buf.append(" \t    ,array_to_string(Array_agg(DISTINCT fat.fat_mensagem), ', ') \t\t\t\t\tAS mensagemFatura ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("       ,exr.met_codigo as codigoMetodologia ");
                } else {
                    buf.append("       ,null as codigoMetodologia ");
                }
                buf.append("       , ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("   \tfrom faturaexamerequisicao a ");
                buf.append("   \t\tjoin faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fil_kodigo = b.fil_kodigo and a.fat_codigo = b.fat_codigo and a.req_codigo = b.req_codigo ");
                buf.append("   \t\tjoin examerequisicao exr on a.fil_kodigo = exr.fil_codigo and a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo ");
                buf.append("  \t\tleft join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
                buf.append("  \t\tleft join exames c on a.fil_kodigo = c.fil_codigo and a.exa_codfilho = c.exa_codigo ");
                buf.append("   \t\tleft join convenios d on fat.fil_codigo = d.fil_codigo and fat.con_codigo = d.con_codigo ");
                buf.append("   \t\tleft join materialcoleta m on a.fil_kodigo = m.fil_codigo and a.mco_codfilho = m.mco_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                bufWhere.append("\t\twhere a.fil_codigo = ").append(Variaveis.filialPadrao).append(" and fat.fat_datacancelamento is null ");
                if (!Funcoes.textoVazio(this.getFiltroComPesquisa("filtroFatura"))) {
                    bufWhere.append(" and fat.fat_codigo = '");
                    bufWhere.append(this.getFiltroComPesquisa("filtroFatura"));
                    bufWhere.append("'");
                }
                buf.append(bufWhere.toString());
                buf.append(" \tgroup by filial.fil_codigo, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\tfilial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\tfilial.fil_complemento, filial.fil_cep, filial.fil_fone, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\tfilial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\tcidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\tbairrofilial.bai_descricao, filial.fil_cnes, fat.fat_dtinicio, fat.fat_dtfim,\t\t\t\t\t\t\t\t\t\t\t");
                buf.append("\t\t\t\td.con_fantasia, d.con_codigo, d.con_razao, fat.fat_dtemis, fat.fat_dtvenc, fat.fat_dtconferencia, ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("  exr.met_codigo, ");
                }
                buf.append("\tc.exa_codigo, c.exa_descricao, a.mco_codfilho, m.mco_descricao, m.mco_abreviatura ");
                buf.append("\torder by ");
                if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[1])) {
                    buf.append("c.exa_descricao");
                } else {
                    buf.append("c.exa_codigo ");
                }
            } else if (this.agruparPorCodAmb()) {
                buf.append(" SELECT Count(a.exa_codigo)    AS quantidadeExames                                                   ");
                buf.append(" \t,Sum(a.fer_total)           AS valorExame                                                         ");
                buf.append("\t  ,Sum(a.fer_totalch)         AS valorCH                                                            ");
                buf.append(" \t,Sum(a.fer_totalmateriais)  AS valorMaterial                                                      ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT c.exa_codigo ),', ')         AS codigoExame                   ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT m.mco_abreviatura),', ')     AS abreviaturaMaterialColetado   ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT c.exa_descricao),', ')       AS descricaoExame                ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT dtp.dtp_codamb),', ')        AS codigoAMB                     ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT d.con_fantasia),', ')        AS fantasiaConvenio              ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_descricao), ', ') AS descricaoFilial               ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT a.mco_codfilho),', ')        AS codigoMaterialColetado        ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_codigo), ', ')\t\t AS codigoFilial                  ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_descricao), ', ') AS descricaoFilial               ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_cnpj), ', ')\t\t\t AS cnpjFilial                    ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_endereco), ', ')  AS enderecoFilial                ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_complemento), ', ') AS complementoFilial           ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT  filial.fil_cep), ', ')  \t\t\t AS cepFilial                   ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_fone), ', ') \t\t\t AS foneFilial                  ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_fax), ', ')  \t\t\t AS faxFilial                   ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_razaosocial), ', ') AS razaoSocialFilial           ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT filial.fil_cnes), ', ') \t\t\t AS CNESFilial                  ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT cidadefilial.cid_codigo), ', ') AS codigoCidadeFilial         ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT cidadefilial.cid_nome), ', ') \tAS descricaoCidadeFilial      ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT cidadefilial.cid_uf), ', ') \t  AS estadoCidadeFilial         ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT bairrofilial.bai_codigo), ', ')  AS codigoBairroFilial        ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT bairrofilial.bai_descricao), ', ') AS descricaoBairroFilial \t");
                buf.append(" \t,Count(distinct b.req_codigo) AS quantidadeRequisicoes                                            ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT d.con_codigo), ', ') \t\t\t\t\t\t\tAS codigoConvenio           ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT  d.con_razao), ', ') \t\t\t\t\t\t  AS razaoSocialConvenio      ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT exr.met_codigo), ', ') \t\t\t\t\t\tAS codigoMetodologia        ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_dtemis), ', ') \t\t\t\t\t\tAS dataEmissaoFatura        ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_dtvenc), ', ') \t\t \t\t\t\tAS dataVencimentoFatura     ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_dtconferencia), ', ')     AS dataConferenciaFatura    ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_dtinicio), ', ') \t\t\t\t\tAS dataInicialFatura        ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_dtfim), ', ') \t\t\t\t\t\tAS dataFinalFatura          ");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT m.mco_descricao), ', ') \t\t\t\t\tAS descricaoMaterialColetado");
                buf.append(" \t,array_to_string(Array_agg(DISTINCT fat.fat_mensagem), ', ') \t\t\t\t\tAS mensagemFatura ");
                buf.append(" FROM  faturaexamerequisicao a                                                                                                                                      ");
                buf.append(" \t\tJOIN faturarequisicao b  ON a.fil_codigo = b.fil_codigo AND a.fil_kodigo = b.fil_kodigo AND a.fat_codigo = b.fat_codigo AND a.req_codigo = b.req_codigo          ");
                buf.append(" \t\tJOIN examerequisicao exr  ON a.fil_kodigo = exr.fil_codigo AND a.req_codigo = exr.req_codigo AND a.exa_codigo = exr.exa_codigo AND a.mco_codigo = exr.mco_codigo ");
                buf.append(" \t\tLEFT JOIN fatura fat ON b.fil_codigo = fat.fil_codigo AND b.fat_codigo = fat.fat_codigo                                                                          ");
                buf.append(" \t\tLEFT JOIN exames c  ON a.fil_kodigo = c.fil_codigo  AND a.exa_codfilho = c.exa_codigo                                                                            ");
                buf.append(" \t\tLEFT JOIN convenios d ON fat.fil_codigo = d.fil_codigo AND fat.con_codigo = d.con_codigo                                                                         ");
                buf.append(" \t\tLEFT JOIN materialcoleta m  ON a.fil_kodigo = m.fil_codigo AND a.mco_codfilho = m.mco_codigo                                                                     ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("\t\t\tLEFT JOIN detalhetabelapreco dtp ON dtp.exa_codigo = c.exa_codigo  and dtp.fil_codigo = a.fil_codigo and dtp.tpe_codigo = d.tpe_codigo  and dtp.mco_codigo = m.mco_codigo    ");
                buf.append("\t\t\tWHERE a.fil_codigo = ").append(Variaveis.filialPadrao).append(" AND fat.fat_datacancelamento is null ");
                if (!Funcoes.textoVazio(this.getFiltroComPesquisa("filtroFatura"))) {
                    buf.append("\t  AND fat.fat_codigo = '").append(this.getFiltroComPesquisa("filtroFatura")).append("'");
                }
                buf.append(" group by dtp.dtp_codamb ");
                buf.append(" order by ");
                if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[1])) {
                    buf.append(" descricaoExame ");
                } else {
                    buf.append(" codigoExame ");
                }
            }
            rs = Conexao.executeQuery(st, buf.toString());
            System.gc();
            if (rs.next()) {
                int colunaReq;
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (!this.agruparPorCodAmb()) {
                            if (campos[i].equals("quantidadeRequisicoes")) {
                                o[i] = this.quantidadeRequisicoesPorConvenio(st2, bufWhere.toString(), rs.getString("codigoExame"), rs.getString("codigoMaterialColetado"));
                                continue;
                            }
                            if (campos[i].equals("codigoAMB")) {
                                o[i] = ExameUtil.getCodigoAMB(rs.getString("codigoFilial"), rs.getString("codigoExame"), rs.getInt("codigoMaterialColetado"), rs.getInt("codigoConvenio"), rs.getInt("codigoMetodologia"));
                                continue;
                            }
                            if (this.isDataFatura(i)) {
                                o[i] = this.getData(rs, i);
                                continue;
                            }
                            o[i] = rs.getObject(campos[i]);
                            continue;
                        }
                        o[i] = this.isDataFatura(i) ? this.getData(rs, i) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[2])) {
                    int colunaAMB = modelo.findColumn("codigoAMB");
                    if (colunaAMB > -1) {
                        modelo.ordenarColuna(colunaAMB, 1, false);
                    }
                } else if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[3])) {
                    int colunaExa = modelo.findColumn("quantidadeExames");
                    if (colunaExa > -1) {
                        modelo.ordenarColuna(colunaExa, 1, false);
                    }
                } else if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[4]) && (colunaReq = modelo.findColumn("quantidadeRequisicoes")) > -1) {
                    modelo.ordenarColuna(colunaReq, 1, false);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioBPA.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioBPA.this.panelCentro.removeAll();
                            RelatorioBPA.this.panelCentro.repaint();
                            RelatorioBPA.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    buf.delete(0, buf.length());
                    buf.append(this.getFiltroComPesquisa("filtroFatura"));
                    var.put("filtroFatura", buf.toString());
                    var.put("filtroAgrupaCodAmb", this.getAgrupadoAmb());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioBPA");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean isDataFatura(int i) {
        return campos[i].equals("dataInicialFatura") || campos[i].equals("dataFinalFatura");
    }

    private String getData(ResultSet rs, int i) throws SQLException, ParseException {
        String dataString = rs.getObject(campos[i]).toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date data = df.parse(dataString);
        return Funcoes.formataData("dd/MM/yyyy", data);
    }

    private String getAgrupadoAmb() {
        return this.agruparPorCodAmb() ? "Sim" : "N\u00e3o";
    }

    private boolean agruparPorCodAmb() {
        return this.getFiltroCheck("filtroAgrupaCodAmb");
    }

    private int quantidadeRequisicoesPorConvenio(Statement st, String filtro, String exame, String material) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("\tselect count(b.req_codigo) as quantidadeRequisicoes ");
        buf.append("\t\tfrom faturarequisicao b ");
        buf.append("\t\tjoin faturaexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fil_kodigo = c.fil_kodigo and b.fat_codigo = c.fat_codigo and b.req_codigo = c.req_codigo ");
        buf.append("\t\tjoin fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append("\twhere b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and fat.fat_datacancelamento is null ");
        if (!Funcoes.textoVazio(this.getFiltroData("filtroFatura"))) {
            buf.append(" and fat.fat_codigo = '");
            buf.append(this.getFiltroData("filtroFatura"));
            buf.append("'");
        }
        if (!Funcoes.textoVazio(exame)) {
            buf.append(" and c.exa_codfilho = '");
            buf.append(exame);
            buf.append("'");
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and c.mco_codfilho = ");
            buf.append(material);
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0870100400");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0870100401");
    }
}

