/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.caixa;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioDevedores
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Paciente", "Esta\u00e7\u00e3o", "Usu\u00e1rio", "Esta\u00e7\u00e3o + Usu\u00e1rio"};
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_DEVE_GUIA = "deveGuia";
    private final String FILTRO_NAO_DEVE_APRESENTAR_SEM_MATERIAL = "semMaterial";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "dadosClinicosRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "gestanteRequisicao", "dumRequisicao", "matriculaRequisicao", "anomesIdadeRequisicao", "idadeRequisicao", "avisarPacienteRequisicao", "senhaWebRequisicao", "titularRequisicao", "alturaRequisicao", "pesoRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "coletadoRequisicao", "dataAberturaRequisicao", "neonatoRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "nomeSocialPaciente", "quartoRequisicao", "leitoRequisicao", "codigoAla", "descricaoAla", "codigoPaciente", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "vipPaciente", "grupoSanguineoPaciente", "fatorrhPaciente", "fatorduPaciente", "corPaciente", "observacaoPaciente", "dadosClinicosPaciente", "pesoPaciente", "alturaPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "profissaoPaciente", "fumantePaciente", "diabeticoPaciente", "rgPaciente", "cpfPaciente", "estadoCivilPaciente", "numeroFilhosPaciente", "dataHoraCadastroPaciente", "dumPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "impressoraDestino", "naoImprimirDestino", "cepDestino", "complementoDestino", "enderecoDestino", "foneDestino", "enviarWebDestino", "codigoCidadeDestino", "descricaoCidadeDestino", "estadoCidadeDestino", "codigoBairrodestino", "descricaoBairrodestino", "codigoColeta", "descricaoColeta", "cepColeta", "complementoColeta", "enderecoColeta", "foneColeta", "codigoCidadeColeta", "descricaoCidadeColeta", "estadoCidadeColeta", "codigoBairroColeta", "descricaoBairroColeta", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "percentualAcrescimoConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "codigoPrioridade", "descricaoPrioridade", "codigoTabela", "descricaoTabela", "valorCHTabela", "moedaTabela", "codigoCidadeConvenio", "descricaoCidadeConvenio", "estadoCidadeConvenio", "codigoBairroConvenio", "descricaoBairroConvenio", "codigoModelo", "descricaoModelo", "crmMedico", "conselhoMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "tipoMedico", "comissaoMedico", "cepMedico", "complementoMedico", "enderecoMedico", "celularMedico", "faxMedico", "foneMedico", "emailMedico", "siteMedico", "senhaWebMedico", "codigoCidadeMedico", "descricaoCidadeMedico", "estadoCidadeMedico", "codigoBairroMedico", "descricaoBairroMedico", "codigoEstacao", "descricaoEstacao", "tipoLogradouroPaciente", "tipoLogradouroCobrancaPaciente", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "tipoLogradouroMedico", "numeroEnderecoPaciente", "numeroEnderecoCobrancaPaciente", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "numeroEnderecoMedico", "generoPaciente", "descricaoProdutoRequisicao", "dataFabricacaoProdutoRequisicao", "numeroRegistroProdutoRequisicao", "temperaturaColetaProdutoRequisicao", "numeroLoteProdutoRequisicao", "dataValidadeProdutoRequisicao", "marcaProdutoRequisicao", "lacreProdutoRequisicao", "lacreContraProvaProdutoRequisicao", "lacreContraProvaEmpresaProdutoRequisicao", "documentoReferenciaProdutoRequisicao", "temperaturaRecebimentoProdutoRequisicao", "caracteristicasSanitariasProdutoRequisicao", "condicoesAmbientaisProdutoRequisicao", "procedimentoColetaProdutoRequisicao", "tipoRecebimentoProdutoRequisicao", "partidaProdutoRequisicao", "qtdeAmostrasProdutoRequisicao", "qtdeUnidadeProdutoRequisicao", "codigoUnidadeProdutoRequisicao", "descricaoUnidadeProdutoRequisicao", "codigoEmbalagemProdutoRequisicao", "nomeResponsavelRequisicao_", "foneResponsavelRequisicao_", "cargoResponsavelRequisicao_", "emailResponsavelRequisicao_", "nomeResponsavelRequisicao", "foneResponsavelRequisicao", "cargoResponsavelRequisicao", "emailResponsavelRequisicao", "descricaoEmbalagemProdutoRequisicao", "codigoBairroCobrancaPaciente", "descricaoBairroCobrancaPaciente", "codigoCidadeCobrancaPaciente", "descricaoCidadeCobrancaPaciente", "estadoCidadeCobrancaPaciente", "razaoSocialPaciente", "cnpjPaciente", "inscricaoEstadualPaciente", "proprietarioPaciente", "sifPaciente", "enderecoCobrancaPaciente", "complementoCobrancaPaciente", "cepCobrancaPaciente", "foneCobrancaPaciente", "responsavelCobrancaPaciente", "totalTaxaRequisicao"});

    public RelatorioDevedores() {
        this.montaBarraDescricao("Relat\u00f3rio de devedores de caixa", "Listagem das requisi\u00e7\u00f5es devedoras de caixa", "relatorios/lanc_devedores.jpg");
        this.adicionaRelatorioListener(this);
        if (!this.naoPermiteFiltrarFilial()) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("deveGuia", "Sem pedido/guia", false);
        this.adicionaFiltroCheck("semMaterial", "N\u00e3o apresentar sem material", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioDevedores.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] coleta;
            String[] destino;
            String[] usuario;
            String[] convenio;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
            buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_notacaixa as notaCaixaRequisicao, ");
            buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, ");
            buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, a.req_totaltaxa as totalTaxaRequisicao, ");
            buf.append("a.req_hora as horaRequisicao, a.req_gestante as gestanteRequisicao, a.req_dum as dumRequisicao, ");
            buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
            buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
            buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
            buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
            buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
            buf.append("a.req_telacoleta as coletadoRequisicao, a.req_datarequisicao as dataAberturaRequisicao, ");
            buf.append("a.req_neonato as neonatoRequisicao, a.req_validadeguia as validadeGuiaRequisicao,  ");
            buf.append("a.req_guia as guiaRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
            buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
            buf.append("ala.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
            buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, paciente.pac_nomesocial as nomeSocialPaciente, ");
            buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
            buf.append("paciente.pac_vip as vipPaciente, paciente.pac_grpsangue as grupoSanguineoPaciente, ");
            buf.append("paciente.pac_fatorrh as fatorrhPaciente, paciente.pac_fatordu as fatorduPaciente, ");
            buf.append("paciente.pac_cor as corPaciente, paciente.pac_observ as observacaoPaciente, ");
            buf.append("paciente.pac_dadoclinico as dadosClinicosPaciente, paciente.pac_peso as pesoPaciente, ");
            buf.append("paciente.pac_altura as alturaPaciente, paciente.pac_matricconv as matriculaConvenioPaciente, ");
            buf.append("paciente.pac_titularconv as titularConvenioPaciente, paciente.pac_profissao as profissaoPaciente, ");
            buf.append("paciente.pac_fumante as fumantePaciente, paciente.pac_diabetico as diabeticoPaciente, ");
            buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
            buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
            buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, paciente.pac_dum as dumPaciente, ");
            buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
            buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
            buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
            buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, paciente.pac_email as emailPaciente, ");
            buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, ");
            buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
            buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
            buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, ");
            buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
            buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
            buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
            buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
            buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
            buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
            buf.append("destino.des_impressora as impressoraDestino, destino.des_naoimprimir as naoImprimirDestino,  ");
            buf.append("destino.des_cep as cepDestino, destino.des_complemento as complementoDestino, ");
            buf.append("destino.des_endereco as enderecoDestino, destino.des_fone as foneDestino, ");
            buf.append("destino.des_enviarweb as enviarWebDestino,  ");
            buf.append("ciddestino.cid_codigo as codigoCidadeDestino, ciddestino.cid_nome as descricaoCidadeDestino, ");
            buf.append("ciddestino.cid_uf as estadoCidadeDestino, ");
            buf.append("baidestino.bai_codigo as codigoBairroDestino, baidestino.bai_descricao as descricaoBairroDestino, ");
            buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
            buf.append("coleta.col_cep as cepColeta, coleta.col_complemento as complementoColeta, ");
            buf.append("coleta.col_endereco as enderecoColeta, coleta.col_fone as foneColeta, ");
            buf.append("cidcoleta.cid_codigo as codigoCidadeColeta, cidcoleta.cid_nome as descricaoCidadeColeta, ");
            buf.append("cidcoleta.cid_uf as estadoCidadeColeta, ");
            buf.append("baicoleta.bai_codigo as codigoBairroColeta, baicoleta.bai_descricao as descricaoBairroColeta, ");
            buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
            buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
            buf.append("convenio.con_tppgto as tipoPagamentoConvenio, ");
            buf.append("convenio.con_fatfmaterial as faturarFaltaMaterialConvenio, convenio.con_descexame as habilitarDescontoConvenio,  ");
            buf.append("convenio.con_multa as multaConvenio,  ");
            buf.append("convenio.con_mora as moraConvenio, convenio.con_fatfiliais as faturarFiliaisConvenio, ");
            buf.append("convenio.con_nr1via as quantidade1ViaConvenio, convenio.con_nrexames as numeroExamesConvenio,  ");
            buf.append("convenio.con_viasfatura as viasFaturaConvenio, convenio.con_impbloqueto as imprimirBloquetoConvenio,  ");
            buf.append("convenio.con_nr2via as quantidade2ViaConvenio, convenio.con_tpcalcfatu as tipoCalculoFaturaConvenio,  ");
            buf.append("convenio.con_percpgto as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
            buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_titdep as titularDependenteConvenio, ");
            buf.append("convenio.con_maskcart as mascaraCarteiraConvenio, convenio.con_contato as contatoConvenio, ");
            buf.append("convenio.con_informarmat as obrigaMatriculaConvenio, convenio.con_cep as cepConvenio,  ");
            buf.append("convenio.con_complemento as complementoConvenio, convenio.con_endereco as enderecoConvenio,  ");
            buf.append("convenio.con_tipologradouroendereco as tipoLogradouroConvenio, convenio.con_numeroendereco as numeroEnderecoConvenio, ");
            buf.append("convenio.con_cepcobranca as cepCobrancaConvenio, convenio.con_complcobranca as complementoCobrancaConvenio,  ");
            buf.append("convenio.con_endcobranca as enderecoCobrancaConvenio, convenio.con_fax as faxConvenio, ");
            buf.append("convenio.con_numeroendcobranca as numeroEnderecoCobrancaConvenio, convenio.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio, ");
            buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
            buf.append("convenio.con_valorch as valorCHConvenio, convenio.con_site as siteConvenio, ");
            buf.append("convenio.con_email2 as email2Convenio, convenio.con_email1 as email1Convenio,  ");
            buf.append("convenio.con_tpcalcch as tipoCalculoCHConvenio, convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
            buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_senhaweb as senhaWebConvenio,  ");
            buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
            buf.append("convenio.con_proibidoweb as proibidoWebConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
            buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
            buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
            buf.append("prioridade.pri_codigo as codigoPrioridade, prioridade.pri_descricao as descricaoPrioridade, ");
            buf.append("tabela.tpe_codigo as codigoTabela, tabela.tpe_descricao as descricaoTabela,  ");
            buf.append("tabela.tpe_valorch as valorCHTabela, tabela.tpe_moeda as moedaTabela, ");
            buf.append("cidconvenio.cid_codigo as codigoCidadeConvenio, cidconvenio.cid_nome as descricaoCidadeConvenio,  ");
            buf.append("cidconvenio.cid_uf as estadoCidadeConvenio, ");
            buf.append("baiconvenio.bai_codigo as codigoBairroConvenio, baiconvenio.bai_descricao as descricaoBairroConvenio, ");
            buf.append("layout.lay_codigo as codigoModelo, layout.lay_descricao as descricaoModelo, ");
            buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
            buf.append("medico.med_abrev as abreviaturaMedico, ");
            buf.append("medico.med_tipo as tipoMedico,  ");
            buf.append("medico.med_comissao as comissaoMedico, medico.med_cep as cepMedico, medico.med_complemento as complementoMedico,  ");
            buf.append("medico.med_endereco as enderecoMedico, medico.med_celular as celularMedico, medico.med_fax as faxMedico,  ");
            buf.append("medico.med_tipologradouroendereco as tipoLogradouroMedico, medico.med_numeroendereco as numeroEnderecoMedico, ");
            buf.append("medico.med_fone as foneMedico, medico.med_email as emailMedico, medico.med_site as siteMedico, medico.med_senhaweb as senhaWebMedico, ");
            buf.append("cidmedico.cid_codigo as codigoCidadeMedico, cidmedico.cid_nome as descricaoCidadeMedico, cidmedico.cid_uf as estadoCidadeMedico,  ");
            buf.append("baimedico.bai_codigo as codigoBairroMedico, baimedico.bai_descricao as descricaoBairroMedico, ");
            buf.append("a.est_codigo as codigoEstacao, estacoes.est_descricao as descricaoEstacao, ");
            buf.append("a.req_descricaoproduto as descricaoProdutoRequisicao, ");
            buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
            buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
            buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
            buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
            buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
            buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
            buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
            buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
            buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
            buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
            buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
            buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
            buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
            buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
            buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
            buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
            buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
            buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
            buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
            buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
            buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
            buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
            buf.append("ent.ent_email as emailResponsavelRequisicao, ");
            buf.append("ent.ent_fone as foneResponsavelRequisicao, ");
            buf.append("paciente.bai_codigocobranca as codigoBairroCobrancaPaciente, ");
            buf.append("baicobranca.bai_descricao as descricaoBairroCobrancaPaciente, ");
            buf.append("paciente.cid_codigocobranca as codigoCidadeCobrancaPaciente, ");
            buf.append("cidcobranca.cid_nome as descricaoCidadeCobrancaPaciente, ");
            buf.append("cidcobranca.cid_uf as estadoCidadeCobrancaPaciente, ");
            buf.append("paciente.pac_razaosocial as razaoSocialPaciente, ");
            buf.append("paciente.pac_cnpj as cnpjPaciente, ");
            buf.append("paciente.pac_ie as inscricaoEstadualPaciente, ");
            buf.append("paciente.pac_proprietario as proprietarioPaciente, ");
            buf.append("paciente.pac_sif as sifPaciente, ");
            buf.append("paciente.pac_enderecocobranca as enderecoCobrancaPaciente, ");
            buf.append("paciente.pac_numeroenderecocobranca as numeroEnderecoCobrancaPaciente, ");
            buf.append("paciente.pac_tipologradouroendcobranca as tipoLogradouroCobrancaPaciente, ");
            buf.append("paciente.pac_complementocobranca as complementoCobrancaPaciente, ");
            buf.append("paciente.pac_cepcobranca as cepCobrancaPaciente, ");
            buf.append("paciente.pac_fonecobranca as foneCobrancaPaciente, ");
            buf.append("paciente.pac_responsavelcobranca as responsavelCobrancaPaciente, ");
            buf.append("idg.ige_descricao as generoPaciente, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from requisicao a ");
            buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
            buf.append("join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
            buf.append("join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
            buf.append("join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
            buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
            buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
            buf.append("join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
            buf.append("join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
            buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
            buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
            buf.append("left join cidades cidconvenio on convenio.fil_codigo = cidconvenio.fil_codigo and convenio.cid_codigo = cidconvenio.cid_codigo ");
            buf.append("left join cidades cidmedico on medico.fil_codigo = cidmedico.fil_codigo and medico.cid_codigo = cidmedico.cid_codigo ");
            buf.append("left join cidades ciddestino on destino.fil_codigo = ciddestino.fil_codigo and destino.cid_codigo = ciddestino.cid_codigo ");
            buf.append("left join cidades cidcoleta on coleta.fil_codigo = cidcoleta.fil_codigo and coleta.cid_codigo = cidcoleta.cid_codigo ");
            buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
            buf.append("left join bairro baiconvenio on convenio.fil_codigo = baiconvenio.fil_codigo and convenio.bai_codigo = baiconvenio.bai_codigo ");
            buf.append("left join bairro baimedico on medico.fil_codigo = baimedico.fil_codigo and medico.bai_codigo = baimedico.bai_codigo ");
            buf.append("left join bairro baidestino on destino.fil_codigo = baidestino.fil_codigo and destino.bai_codigo = baidestino.bai_codigo ");
            buf.append("left join bairro baicoleta on coleta.fil_codigo = baicoleta.fil_codigo and coleta.bai_codigo = baicoleta.bai_codigo ");
            buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
            buf.append("left join layout on convenio.fil_codigo = layout.fil_codigo and convenio.lay_codigo = layout.lay_codigo ");
            buf.append("left join prioridade on convenio.fil_codigo = prioridade.fil_codigo and convenio.pri_codigo = prioridade.pri_codigo ");
            buf.append("left join tabelaprecoexames tabela on convenio.fil_codigo = tabela.fil_codigo and convenio.tpe_codigo = tabela.tpe_codigo ");
            buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
            buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
            buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
            buf.append("left join cidades cidcobranca on paciente.fil_codigo = cidcobranca.fil_codigo and paciente.cid_codigocobranca = cidcobranca.cid_codigo ");
            buf.append("left join bairro baicobranca on paciente.fil_codigo = baicobranca.fil_codigo and paciente.bai_codigocobranca = baicobranca.bai_codigo ");
            buf.append("left join identidadegenero idg on coalesce(paciente.pac_genero, 0) = idg.ige_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where ");
            String[] filial = null;
            if (this.naoPermiteFiltrarFilial()) {
                buf.append(" a.fil_codigo = ").append(Variaveis.filialPadrao);
            } else {
                filial = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filial != null) {
                    buf.append(" a.fil_codigo in (");
                    for (int i = 0; i < filial.length; ++i) {
                        buf.append(filial[i]);
                        if (i >= filial.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                } else {
                    buf.append(" a.fil_codigo = ").append(Variaveis.filialPadrao);
                }
            }
            if (this.getFiltroCheck("semMaterial")) {
                buf.append(" and (select todosExamesNaSituacao(a.fil_codigo, a.req_codigo, 'F') = false) ");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" and convenio.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" and a.req_excluida = false ");
            if (this.getFiltroCheck("deveGuia")) {
                buf.append(" and a.req_deveguia = true ");
            } else {
                buf.append(" and a.req_total > a.req_totpago ");
            }
            String[] estacao = this.getSelecionadosFiltro("filtroEstacao", 0);
            if (estacao != null) {
                buf.append(" and a.est_codigo in (");
                for (int i = 0; i < estacao.length; ++i) {
                    buf.append(estacao[i]);
                    if (i >= estacao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((destino = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                buf.append(" and a.des_codigo in (");
                for (int i = 0; i < destino.length; ++i) {
                    buf.append("'");
                    buf.append(destino[i]);
                    buf.append("'");
                    if (i >= destino.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coleta = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coleta.length; ++i) {
                    buf.append("'");
                    buf.append(coleta[i]);
                    buf.append("'");
                    if (i >= coleta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and a.req_data >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and a.req_data <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            buf.append(" order by a.fil_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.req_datarequisicao, a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("upper(paciente.pac_nome), a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("a.est_codigo, a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append("a.usr_codigo, a.req_codigo");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                buf.append("a.est_codigo, a.usr_codigo, a.req_codigo");
            } else {
                buf.append("a.req_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("tipoMedico") ? Tipos.tipoMedico(rs.getString("tipoMedico")) : (campos[i].equalsIgnoreCase("tipoLogradouroPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaPaciente") || campos[i].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") || campos[i].equalsIgnoreCase("tipoLogradouroMedico") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equals("anomesIdadeRequisicao") || campos[i].equals("anomesIdadePaciente") || campos[i].equals("tipoIdadeMinimaExame") || campos[i].equals("tipoIdadeMaximaExame") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equals("sexoPaciente") || campos[i].equals("sexoExame") ? Tipos.tipoSexo(rs.getString(campos[i])) : (campos[i].equals("situacaoExameRequisicao") ? Tipos.tipoSituacaoExame(rs.getString(campos[i])) : (campos[i].equals("corPaciente") ? Tipos.tipoCor(rs.getString(campos[i])) : (campos[i].equals("estadoCivilPaciente") ? Tipos.tipoEstadoCivil(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("fumantePaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("fumantePaciente")) : (campos[i].equalsIgnoreCase("diabeticoPaciente") ? Tipos.tipoFumanteDiabetico(rs.getString("diabeticoPaciente")) : (campos[i].equals("tipoPagamentoConvenio") ? Tipos.tipoPagamento(rs.getString(campos[i])) : (campos[i].equals("tipoCalculoFaturaConvenio") ? Tipos.tipoCalculoFatura(rs.getString(campos[i])) : (campos[i].equals("titularDependenteConvenio") ? Tipos.tipoTitularDependente(rs.getString(campos[i])) : (campos[i].equals("tipoCalculoCHConvenio") ? Tipos.tipoCalculoCH(rs.getString(campos[i])) : (campos[i].equals("tipoUltimoPagamentoRequisicao") ? Tipos.tipoPagamento(rs.getString(campos[i])) : rs.getObject(campos[i]))))))))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioDevedores.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioDevedores.this.panelCentro.removeAll();
                            RelatorioDevedores.this.panelCentro.repaint();
                            RelatorioDevedores.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("deveGuia", this.getFiltroCheck("deveGuia"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("semMaterial", this.getFiltroCheck("semMaterial"));
                    buf.delete(0, buf.length());
                    if (filial != null) {
                        for (i = 0; i < filial.length; ++i) {
                            buf.append(filial[i]);
                            if (i >= filial.length - 1) continue;
                            buf.append(", ");
                        }
                    } else {
                        buf.append(Variaveis.filialPadrao);
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (estacao != null) {
                        for (i = 0; i < estacao.length; ++i) {
                            buf.append(estacao[i]);
                            if (i >= estacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    buf.delete(0, buf.length());
                    if (destino != null) {
                        for (i = 0; i < destino.length; ++i) {
                            buf.append(destino[i]);
                            if (i >= destino.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        for (i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0840102500");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0840102501");
    }

    public static long getModuloAcessoNaoPermiteFiltrarFilial() {
        return Long.parseLong("0840102502");
    }

    public boolean naoPermiteFiltrarFilial() {
        return Acesso.getAcesso(RelatorioDevedores.getModuloAcessoNaoPermiteFiltrarFilial());
    }
}

