/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.caixa;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.financeiro.caixa.RetornoRelatorioCaixa;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class RelatorioCaixa
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String REQUISI\u00c7\u00c3O = "Requisi\u00e7\u00e3o";
    private static final String DATA = "Data";
    private static final String USU\u00c1RIO = "Usu\u00e1rio";
    private static final String DATA_HORA = "Data + Hora";
    private static final String C\u00d3DIGO = "C\u00f3digo";
    public static final String PARAMETROS_CAIXA = "RelatorioCaixa.ultimoFiltro";
    private final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Usu\u00e1rio", "Requisi\u00e7\u00e3o", "Data"};
    private String[] itensPagamento = new String[]{"Todos", Tipos.tipoPagamento("H"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("D"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("C"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("F"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CONTA = "filtroConta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_PAGAMENTO = "filtroPagamento";
    private final String FILTRO_CAUCAO = "filtroCaucao";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CONVENO = "filtroConvenioExcluido";
    private final String FILTRO_OCULTAR_CANCELADOS = "filtroOcultarCancelados";
    private final String FILTRO_IGNORAR_ESTACAO = "filtroIgnorarEstacao";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_IGNORAR_TIPO_LANCAMENTO_ORDENAR = "filtroIgnorarTipoLancamentoOrdenar";
    private final String VARIAVEL_QTDELANCAMENTOS = "quantidadeLancamentos";
    private final String VARIAVEL_QTDECANCELAMENTOS = "quantidadeCancelamentos";
    private final String VARIAVEL_QTDEDEBITOS = "quantidadeDebitos";
    private final String VARIAVEL_QTDECREDITOS = "quantidadeCreditos";
    private final String VARIAVEL_TOTALDEBITOS = "totalDebitos";
    private final String VARIAVEL_TOTALCREDITOS = "totalCreditos";
    private final String VARIAVEL_QTDEDEBITOSCANCELADOS = "quantidadeDebitosCancelados";
    private final String VARIAVEL_QTDECREDITOSCANCELADOS = "quantidadeCreditosCancelados";
    private final String VARIAVEL_TOTALDEBITOSCANCELADOS = "totalDebitosCancelados";
    private static final String VARIAVEL_TOTALCREDITOSCANCELADOS = "totalCreditosCancelados";
    private static final String VARIAVEL_QTDEDEBITOS_CHEQUE = "quantidadeDebitosCheque";
    private final String VARIAVEL_QTDEDEBITOS_CARTAO_DEBITO = "quantidadeDebitosCartaoDebito";
    private final String VARIAVEL_QTDEDEBITOS_CARTAO_CREDITO = "quantidadeDebitosCartaoCredito";
    private final String VARIAVEL_QTDEDEBITOS_PREDATADO = "quantidadeDebitosPreDatado";
    private final String VARIAVEL_QTDEDEBITOS_CAUCAO = "quantidadeDebitosCaucao";
    private final String VARIAVEL_QTDEDEBITOS_DINHEIRO = "quantidadeDebitosDinheiro";
    private final String VARIAVEL_QTDEDEBITOS_DEPOSITO = "quantidadeDebitosDeposito";
    private final String VARIAVEL_QTDEDEBITOS_ONLINE = "quantidadeDebitosOnLine";
    private final String VARIAVEL_QTDEDEBITOS_FOLHA = "quantidadeDebitosFolha";
    private final String VARIAVEL_QTDEDEBITOS_TRANSFERENCIA = "quantidadeDebitosTransferencia";
    private final String VARIAVEL_QTDECREDITOS_CHEQUE = "quantidadeCreditosCheque";
    private final String VARIAVEL_QTDECREDITOS_CARTAO_DEBITO = "quantidadeCreditosCartaoDebito";
    private final String VARIAVEL_QTDECREDITOS_CARTAO_CREDITO = "quantidadeCreditosCartaoCredito";
    private final String VARIAVEL_QTDECREDITOS_PREDATADO = "quantidadeCreditosPreDatado";
    private final String VARIAVEL_QTDECREDITOS_CAUCAO = "quantidadeCreditosCaucao";
    private final String VARIAVEL_QTDECREDITOS_DINHEIRO = "quantidadeCreditosDinheiro";
    private final String VARIAVEL_QTDECREDITOS_DEPOSITO = "quantidadeCreditosDeposito";
    private final String VARIAVEL_QTDECREDITOS_TRANSFERENCIA = "quantidadeCreditosTransferencia";
    private final String VARIAVEL_TOTALDEBITOS_CHEQUE = "totalDebitosCheque";
    private final String VARIAVEL_TOTALDEBITOS_CARTAO_DEBITO = "totalDebitosCartaoDebito";
    private final String VARIAVEL_TOTALDEBITOS_CARTAO_CREDITO = "totalDebitosCartaoCredito";
    private final String VARIAVEL_TOTALDEBITOS_PREDATADO = "totalDebitosPreDatado";
    private final String VARIAVEL_TOTALDEBITOS_CAUCAO = "totalDebitosCaucao";
    private final String VARIAVEL_TOTALDEBITOS_DINHEIRO = "totalDebitosDinheiro";
    private final String VARIAVEL_TOTALDEBITOS_DEPOSITO = "totalDebitosDeposito";
    private final String VARIAVEL_TOTALDEBITOS_ONLINE = "totalDebitosOnLine";
    private static final String VARIAVEL_TOTALDEBITOS_FOLHA = "totalDebitosFolha";
    private static final String VARIAVEL_TOTALDEBITOS_TRANSFERENCIA = "totalDebitosTransferencia";
    private final String VARIAVEL_TOTALCREDITOS_CHEQUE = "totalCreditosCheque";
    private final String VARIAVEL_TOTALCREDITOS_CARTAO_DEBITO = "totalCreditosCartaoDebito";
    private final String VARIAVEL_TOTALCREDITOS_CARTAO_CREDITO = "totalCreditosCartaoCredito";
    private final String VARIAVEL_TOTALCREDITOS_PREDATADO = "totalCreditosPreDatado";
    private final String VARIAVEL_TOTALCREDITOS_CAUCAO = "totalCreditosCaucao";
    private final String VARIAVEL_TOTALCREDITOS_DINHEIRO = "totalCreditosDinheiro";
    private final String VARIAVEL_TOTALCREDITOS_DEPOSITO = "totalCreditosDeposito";
    private final String VARIAVEL_TOTALCREDITOS_TRANSFERENCIA = "totalCreditosTransferencia";
    private final String VARIAVEL_QTDEDEBITOS_CHEQUE_CANCELADOS = "quantidadeDebitosChequeCancelados";
    private final String VARIAVEL_QTDEDEBITOS_CARTAO_DEBITO_CANCELADOS = "quantidadeDebitosCartaoDebitoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_CARTAO_CREDITO_CANCELADOS = "quantidadeDebitosCartaoCreditoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_PREDATADO_CANCELADOS = "quantidadeDebitosPreDatadoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_CAUCAO_CANCELADOS = "quantidadeDebitosCaucaoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_DINHEIRO_CANCELADOS = "quantidadeDebitosDinheiroCancelados";
    private final String VARIAVEL_QTDEDEBITOS_DEPOSITO_CANCELADOS = "quantidadeDebitosDepositoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_ONLINE_CANCELADOS = "quantidadeDebitosOnLineCancelados";
    private final String VARIAVEL_QTDEDEBITOS_FOLHA_CANCELADOS = "quantidadeDebitosFolhaCancelados";
    private final String VARIAVEL_QTDEDEBITOS_TRANSFERENCIA_CANCELADOS = "quantidadeDebitosTransferenciaCancelados";
    private final String VARIAVEL_QTDECREDITOS_CHEQUE_CANCELADOS = "quantidadeCreditosChequeCancelados";
    private final String VARIAVEL_QTDECREDITOS_CARTAO_DEBITO_CANCELADOS = "quantidadeCreditosCartaoDebitoCancelados";
    private final String VARIAVEL_QTDECREDITOS_CARTAO_CREDITO_CANCELADOS = "quantidadeCreditosCartaoCreditoCancelados";
    private final String VARIAVEL_QTDECREDITOS_PREDATADO_CANCELADOS = "quantidadeCreditosPreDatadoCancelados";
    private final String VARIAVEL_QTDECREDITOS_CAUCAO_CANCELADOS = "quantidadeCreditosCaucaoCancelados";
    private final String VARIAVEL_QTDECREDITOS_DINHEIRO_CANCELADOS = "quantidadeCreditosDinheiroCancelados";
    private final String VARIAVEL_QTDECREDITOS_DEPOSITO_CANCELADOS = "quantidadeCreditosDepositoCancelados";
    private final String VARIAVEL_QTDECREDITOS_TRANSFERENCIA_CANCELADOS = "quantidadeCreditosTransferenciaCancelados";
    private final String VARIAVEL_TOTALDEBITOS_CHEQUE_CANCELADOS = "totalDebitosChequeCancelados";
    private final String VARIAVEL_TOTALDEBITOS_CARTAO_DEBITO_CANCELADOS = "totalDebitosCartaoDebitoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_CARTAO_CREDITO_CANCELADOS = "totalDebitosCartaoCreditoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_PREDATADO_CANCELADOS = "totalDebitosPreDatadoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_CAUCAO_CANCELADOS = "totalDebitosCaucaoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_DINHEIRO_CANCELADOS = "totalDebitosDinheiroCancelados";
    private final String VARIAVEL_TOTALDEBITOS_DEPOSITO_CANCELADOS = "totalDebitosDepositoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_ONLINE_CANCELADOS = "totalDebitosOnLineCancelados";
    private final String VARIAVEL_TOTALDEBITOS_FOLHA_CANCELADOS = "totalDebitosFolhaCancelados";
    private final String VARIAVEL_TOTALDEBITOS_TRANSFERENCIA_CANCELADOS = "totalDebitosTransferenciaCancelados";
    private final String VARIAVEL_TOTALCREDITOS_CHEQUE_CANCELADOS = "totalCreditosChequeCancelados";
    private final String VARIAVEL_TOTALCREDITOS_CARTAO_DEBITO_CANCELADOS = "totalCreditosCartaoDebitoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_CARTAO_CREDITO_CANCELADOS = "totalCreditosCartaoCreditoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_PREDATADO_CANCELADOS = "totalCreditosPreDatadoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_CAUCAO_CANCELADOS = "totalCreditosCaucaoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_DINHEIRO_CANCELADOS = "totalCreditosDinheiroCancelados";
    private final String VARIAVEL_TOTALCREDITOS_DEPOSITO_CANCELADOS = "totalCreditosDepositoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_TRANSFERENCIA_CANCELADOS = "totalCreditosTransferenciaCancelados";
    private final String VARIAVEL_QTDEDEBITOS_PROMISSORIA = "quantidadeDebitosPromissoria";
    private final String VARIAVEL_QTDECREDITOS_PROMISSORIA = "quantidadeCreditosPromissoria";
    private final String VARIAVEL_TOTALDEBITOS_PROMISSORIA = "totalDebitosPromissoria";
    private final String VARIAVEL_TOTALCREDITOS_PROMISSORIA = "totalCreditosPromissoria";
    private final String VARIAVEL_QTDEDEBITOS_PROMISSORIA_CANCELADOS = "quantidadeDebitosPromissoriaCancelados";
    private final String VARIAVEL_QTDECREDITOS_PROMISSORIA_CANCELADOS = "quantidadeCreditosPromissoriaCancelados";
    private final String VARIAVEL_TOTALDEBITOS_PROMISSORIA_CANCELADOS = "totalDebitosPromissoriaCancelados";
    private final String VARIAVEL_TOTALCREDITOS_PROMISSORIA_CANCELADOS = "totalCreditosPromissoriaCancelados";
    private final String VARIAVEL_QTDEDEBITOS_DEBITO_AUTOMATICO = "quantidadeDebitosDebAutomatico";
    private final String VARIAVEL_QTDECREDITOS_DEBITO_AUTOMATICO = "quantidadeCreditosDebAutomatico";
    private final String VARIAVEL_TOTALDEBITOS_DEBITO_AUTOMATICO = "totalDebitosDebAutomatico";
    private final String VARIAVEL_TOTALCREDITOS_DEBITO_AUTOMATICO = "totalCreditosDebAutomatico";
    private final String VARIAVEL_QTDEDEBITOS_DEBITO_AUTOMATICO_CANCELADOS = "quantidadeDebitosDebAutomaticoCancelados";
    private final String VARIAVEL_QTDECREDITOS_DEBITO_AUTOMATICO_CANCELADOS = "quantidadeCreditosDebAutomaticoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_DEBITO_AUTOMATICO_CANCELADOS = "totalDebitosDebAutomaticoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_DEBITO_AUTOMATICO_CANCELADOS = "totalCreditosDebAutomaticoCancelados";
    private final String VARIAVEL_QTDEDEBITOS_BOLETO = "quantidadeDebitosBoleto";
    private final String VARIAVEL_QTDECREDITOS_BOLETO = "quantidadeCreditosBoleto";
    private final String VARIAVEL_TOTALDEBITOS_BOLETO = "totalDebitosBoleto";
    private final String VARIAVEL_TOTALCREDITOS_BOLETO = "totalCreditosBoleto";
    private final String VARIAVEL_QTDEDEBITOS_BOLETO_CANCELADOS = "quantidadeDebitosBoletoCancelados";
    private final String VARIAVEL_QTDECREDITOS_BOLETO_CANCELADOS = "quantidadeCreditosBoletoCancelados";
    private final String VARIAVEL_TOTALDEBITOS_BOLETO_CANCELADOS = "totalDebitosBoletoCancelados";
    private final String VARIAVEL_TOTALCREDITOS_BOLETO_CANCELADOS = "totalCreditosBoletoCancelados";
    private final String VARIAVEL_QTDECREDITOS_PIX = "quantidadeCreditosPix";
    private final String VARIAVEL_QTDECREDITOS_PIX_CANCELADOS = "quantidadeCreditosPixCancelados";
    private final String VARIAVEL_TOTALCREDITOS_PIX = "totalCreditosPix";
    private final String VARIAVEL_TOTALCREDITOS_PIX_CANCELADOS = "totalCreditosPixCancelados";
    private final String VARIAVEL_QTDEDEBITOS_PIX = "quantidadeDebitosPix";
    private final String VARIAVEL_QTDEDEBITOS_PIX_CANCELADOS = "quantidadeDebitosPixCancelados";
    private final String VARIAVEL_TOTALDEBITOS_PIX = "totalDebitosPix";
    private final String VARIAVEL_TOTALDEBITOS_PIX_CANCELADOS = "totalDebitosPixCancelados";
    private final String VARIAVEL_QTDE_CREDITOS_ONLINE = "quantidadeCreditosOnline";
    private final String VARIAVEL_QTDE_CREDITOS_ONLINE_CANCELADOS = "quantidadeOnlineCancelados";
    private final String VARIAVEL_TOTAL_CREDITOS_ONLINE = "totalCreditosOnline";
    private final String VARIAVEL_TOTAL_CREDITOS_ONLINE_CANCELADOS = "totalCreditosOnlineCancelados";
    private static Map<String, Integer> contadoresTipoCredito = new HashMap<String, Integer>();
    private static Map<String, Integer> contadoresTipoDebito = new HashMap<String, Integer>();
    private static Map<String, Double> totaisTipoCredito = new HashMap<String, Double>();
    private static Map<String, Double> totaisTipoDebito = new HashMap<String, Double>();
    private static Map<String, Integer> contadoresTipoCreditoCancelados = new HashMap<String, Integer>();
    private static Map<String, Integer> contadoresTipoDebitoCancelados = new HashMap<String, Integer>();
    private static Map<String, Double> totaisTipoCreditoCancelados = new HashMap<String, Double>();
    private static Map<String, Double> totaisTipoDebitoCancelados = new HashMap<String, Double>();
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLancamento", "dataHoraLancamento", "dataLancamento", "tipoLancamento", "valorLancamento", "bancoLancamento", "agenciaLancamento", "documentoLancamento", "observacaoLancamento", "tipoDocumentoLancamento", "tipoPagamentoLancamento", "numeroChequeLancamento", "validadeCartaoLancamento", "cartaoCreditoLancamento", "contaLancamento", "dataConciliacaoLancamento", "dataVencimentoLancamento", "indiceTipoLancamento", "numeroCartaoLancamento", "canceladoLancamento", "usuarioCancelamentoLancamento", "dataCancelamentoLancamento", "nomeUsuarioCancelamentoLancamento", "codigoMotivoCancelamento", "descricaoMotivoCancelamento", "descricaoCancelamentoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "codigoEstacaoLancamento", "descricaoEstacaoLancamento", "codigoReduzidoConta", "contaConta", "titularConta", "codigoUsuarioLancamento", "nomeUsuarioLancamento", "codigoRequisicao", "dataRequisicao", "dataFaturaRequisicao", "urgenteRequisicao", "dataEntregaRequisicao", "notaCaixaRequisicao", "observacaoRequisicao", "totalPagoRequisicao", "totalRequisicao", "horaEntregaRequisicao", "horaFaturaRequisicao", "horaRequisicao", "matriculaRequisicao", "avisarPacienteRequisicao", "titularRequisicao", "valorAcrescimoRequisicao", "percentualAcrescimoRequisicao", "valorDescontoRequisicao", "percentualDescontoRequisicao", "dataAberturaRequisicao", "validadeGuiaRequisicao", "guiaRequisicao", "tipoUltimoPagamentoRequisicao", "codigoPaciente", "nomePaciente", "dataNascimentoPaciente", "vipPaciente", "observacaoPaciente", "matriculaConvenioPaciente", "titularConvenioPaciente", "rgPaciente", "cpfPaciente", "dataHoraCadastroPaciente", "faxPaciente", "celularPaciente", "foneComercialPaciente", "fonePaciente", "cepPaciente", "complementoPaciente", "enderecoPaciente", "numeroEnderecoPaciente", "tipoLogradouroPaciente", "emailPaciente", "anomesIdadePaciente", "idadePaciente", "foneContatoPaciente", "contatoPaciente", "maePaciente", "paiPaciente", "codigoCidadePaciente", "descricaoCidadePaciente", "estadoCidadePaciente", "codigoBairroPaciente", "descricaoBairroPaciente", "codigoUsuarioRequisicao", "nomeUsuarioRequisicao", "codigoUsuarioAberturaRequisicao", "nomeUsuarioAberturaRequisicao", "codigoDestino", "descricaoDestino", "codigoColeta", "descricaoColeta", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "observacaoConvenio", "tipoPagamentoConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "faxConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "inscricaoMunicipalConvenio", "percentualAcrescimoConvenio", "percentualBonusConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "cobrarMateriaisConvenio", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "abreviaturaMedico", "comissaoMedico", "descricaoHistoricoUsuario", "codigoFilialDestinoOrigem", "totalTaxaRequisicao", "nomeFuncionarioDescontoFolhaLancamento", "setorFuncionarioDescontoFolhaLancamento", "nomeFuncionarioAutorizacaoDescontoFolhaLancamento", "numeroNotaFiscal", "nomeSocialPaciente", "tipoTransferencia", "pix"});
    private boolean isOcultarFiltroConvenio = Acesso.getAcesso(Long.parseLong("0840102302"));

    public RelatorioCaixa() {
        this.montaBarraDescricao("Relat\u00f3rio de caixa", "Listagem dos lan\u00e7amentos em caixa realizados no per\u00edodo", "relatorios/rel_finan_caixa.jpg");
        this.adicionaRelatorioListener(this);
        if (!RelatorioCaixa.naoPermiteFiltrarFilial()) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{C\u00d3DIGO, "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{C\u00d3DIGO, "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", USU\u00c1RIO, "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{C\u00d3DIGO, "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConta", "Conta caixa", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao + " and cco_tipo = '" + "X" + "'", 2, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{C\u00d3DIGO, "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        if (!this.isOcultarFiltroConvenio) {
            this.adicionaItemFiltro("filtroConvenioExcluido", "Conv\u00eanio exclu\u00eddo", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{C\u00d3DIGO, "Conv\u00eanio"}, new int[]{70, 0});
        }
        this.adicionaFiltroCombo("filtroPagamento", "Pagamento:", this.itensPagamento, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("filtroCaucao", "Ocultar cau\u00e7\u00e3o", false);
        this.adicionaFiltroCheck("filtroOcultarCancelados", "Ocultar cancelados", false);
        this.adicionaFiltroCheck("filtroIgnorarEstacao", "N\u00e3o agrupar por esta\u00e7\u00e3o", false);
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de Hora", false);
        this.adicionaFiltroCheck("filtroIgnorarTipoLancamentoOrdenar", "Ignorar tipo ao ordenar", false);
        this.adicionaNomeVariavel("quantidadeLancamentos");
        this.adicionaNomeVariavel("quantidadeCancelamentos");
        this.adicionaNomeVariavel("quantidadeDebitos");
        this.adicionaNomeVariavel("quantidadeCreditos");
        this.adicionaNomeVariavel("totalDebitos");
        this.adicionaNomeVariavel("totalCreditos");
        this.adicionaNomeVariavel(VARIAVEL_TOTALCREDITOSCANCELADOS);
        this.adicionaNomeVariavel("totalDebitosCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosCancelados");
        this.adicionaNomeVariavel(VARIAVEL_QTDEDEBITOS_CHEQUE);
        this.adicionaNomeVariavel("quantidadeDebitosCartaoDebito");
        this.adicionaNomeVariavel("quantidadeDebitosCartaoCredito");
        this.adicionaNomeVariavel("quantidadeDebitosPreDatado");
        this.adicionaNomeVariavel("quantidadeDebitosCaucao");
        this.adicionaNomeVariavel("quantidadeDebitosDinheiro");
        this.adicionaNomeVariavel("quantidadeDebitosDeposito");
        this.adicionaNomeVariavel("quantidadeDebitosOnLine");
        this.adicionaNomeVariavel("quantidadeDebitosFolha");
        this.adicionaNomeVariavel("quantidadeDebitosTransferencia");
        this.adicionaNomeVariavel("quantidadeCreditosCheque");
        this.adicionaNomeVariavel("quantidadeCreditosCartaoDebito");
        this.adicionaNomeVariavel("quantidadeCreditosCartaoCredito");
        this.adicionaNomeVariavel("quantidadeCreditosPreDatado");
        this.adicionaNomeVariavel("quantidadeCreditosCaucao");
        this.adicionaNomeVariavel("quantidadeCreditosDinheiro");
        this.adicionaNomeVariavel("quantidadeCreditosDeposito");
        this.adicionaNomeVariavel("quantidadeCreditosTransferencia");
        this.adicionaNomeVariavel("totalDebitosCheque");
        this.adicionaNomeVariavel("totalDebitosCartaoDebito");
        this.adicionaNomeVariavel("totalDebitosCartaoCredito");
        this.adicionaNomeVariavel("totalDebitosPreDatado");
        this.adicionaNomeVariavel("totalDebitosCaucao");
        this.adicionaNomeVariavel("totalDebitosDinheiro");
        this.adicionaNomeVariavel("totalDebitosDeposito");
        this.adicionaNomeVariavel("totalDebitosOnLine");
        this.adicionaNomeVariavel(VARIAVEL_TOTALDEBITOS_FOLHA);
        this.adicionaNomeVariavel(VARIAVEL_TOTALDEBITOS_TRANSFERENCIA);
        this.adicionaNomeVariavel("totalCreditosCheque");
        this.adicionaNomeVariavel("totalCreditosCartaoDebito");
        this.adicionaNomeVariavel("totalCreditosCartaoCredito");
        this.adicionaNomeVariavel("totalCreditosPreDatado");
        this.adicionaNomeVariavel("totalCreditosCaucao");
        this.adicionaNomeVariavel("totalCreditosDinheiro");
        this.adicionaNomeVariavel("totalCreditosDeposito");
        this.adicionaNomeVariavel("totalCreditosTransferencia");
        this.adicionaNomeVariavel("quantidadeDebitosChequeCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosCartaoDebitoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosCartaoCreditoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosPreDatadoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosCaucaoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosDinheiroCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosDepositoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosOnLineCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosFolhaCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosTransferenciaCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosChequeCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosCartaoDebitoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosCartaoCreditoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosPreDatadoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosCaucaoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosDinheiroCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosDepositoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosTransferenciaCancelados");
        this.adicionaNomeVariavel("totalDebitosChequeCancelados");
        this.adicionaNomeVariavel("totalDebitosCartaoDebitoCancelados");
        this.adicionaNomeVariavel("totalDebitosCartaoCreditoCancelados");
        this.adicionaNomeVariavel("totalDebitosPreDatadoCancelados");
        this.adicionaNomeVariavel("totalDebitosCaucaoCancelados");
        this.adicionaNomeVariavel("totalDebitosDinheiroCancelados");
        this.adicionaNomeVariavel("totalDebitosDepositoCancelados");
        this.adicionaNomeVariavel("totalDebitosOnLineCancelados");
        this.adicionaNomeVariavel("totalDebitosFolhaCancelados");
        this.adicionaNomeVariavel("totalDebitosTransferenciaCancelados");
        this.adicionaNomeVariavel("totalCreditosChequeCancelados");
        this.adicionaNomeVariavel("totalCreditosCartaoDebitoCancelados");
        this.adicionaNomeVariavel("totalCreditosCartaoCreditoCancelados");
        this.adicionaNomeVariavel("totalCreditosPreDatadoCancelados");
        this.adicionaNomeVariavel("totalCreditosCaucaoCancelados");
        this.adicionaNomeVariavel("totalCreditosDinheiroCancelados");
        this.adicionaNomeVariavel("totalCreditosDepositoCancelados");
        this.adicionaNomeVariavel("totalCreditosTransferenciaCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosPromissoria");
        this.adicionaNomeVariavel("quantidadeCreditosPromissoria");
        this.adicionaNomeVariavel("totalDebitosPromissoria");
        this.adicionaNomeVariavel("totalCreditosPromissoria");
        this.adicionaNomeVariavel("quantidadeDebitosPromissoriaCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosPromissoriaCancelados");
        this.adicionaNomeVariavel("totalDebitosPromissoriaCancelados");
        this.adicionaNomeVariavel("totalCreditosPromissoriaCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosDebAutomatico");
        this.adicionaNomeVariavel("quantidadeCreditosDebAutomatico");
        this.adicionaNomeVariavel("totalDebitosDebAutomatico");
        this.adicionaNomeVariavel("totalCreditosDebAutomatico");
        this.adicionaNomeVariavel("quantidadeDebitosDebAutomaticoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosDebAutomaticoCancelados");
        this.adicionaNomeVariavel("totalDebitosDebAutomaticoCancelados");
        this.adicionaNomeVariavel("totalCreditosDebAutomaticoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosBoleto");
        this.adicionaNomeVariavel("quantidadeCreditosBoleto");
        this.adicionaNomeVariavel("totalDebitosBoleto");
        this.adicionaNomeVariavel("totalCreditosBoleto");
        this.adicionaNomeVariavel("quantidadeDebitosBoletoCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosBoletoCancelados");
        this.adicionaNomeVariavel("totalDebitosBoletoCancelados");
        this.adicionaNomeVariavel("totalCreditosBoletoCancelados");
        this.adicionaNomeVariavel("quantidadeDebitosPix");
        this.adicionaNomeVariavel("quantidadeCreditosPix");
        this.adicionaNomeVariavel("totalDebitosPix");
        this.adicionaNomeVariavel("totalCreditosPix");
        this.adicionaNomeVariavel("quantidadeDebitosPixCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosPixCancelados");
        this.adicionaNomeVariavel("totalDebitosPixCancelados");
        this.adicionaNomeVariavel("totalCreditosPixCancelados");
        this.adicionaNomeVariavel("quantidadeCreditosOnline");
        this.adicionaNomeVariavel("quantidadeOnlineCancelados");
        this.adicionaNomeVariavel("totalCreditosOnline");
        this.adicionaNomeVariavel("totalCreditosOnlineCancelados");
        contadoresTipoDebito.put("H", 0);
        contadoresTipoDebito.put("I", 0);
        contadoresTipoDebito.put("O", 0);
        contadoresTipoDebito.put("C", 0);
        contadoresTipoDebito.put("P", 0);
        contadoresTipoDebito.put("A", 0);
        contadoresTipoDebito.put("D", 0);
        contadoresTipoDebito.put("E", 0);
        contadoresTipoDebito.put("U", 0);
        contadoresTipoDebito.put("N", 0);
        contadoresTipoDebito.put("F", 0);
        contadoresTipoDebito.put("S", 0);
        contadoresTipoDebito.put("B", 0);
        contadoresTipoDebito.put("W", 0);
        contadoresTipoDebito.put("Y", 0);
        contadoresTipoCredito.put("H", 0);
        contadoresTipoCredito.put("I", 0);
        contadoresTipoCredito.put("O", 0);
        contadoresTipoCredito.put("C", 0);
        contadoresTipoCredito.put("P", 0);
        contadoresTipoCredito.put("A", 0);
        contadoresTipoCredito.put("D", 0);
        contadoresTipoCredito.put("E", 0);
        contadoresTipoCredito.put("U", 0);
        contadoresTipoCredito.put("N", 0);
        contadoresTipoCredito.put("F", 0);
        contadoresTipoCredito.put("S", 0);
        contadoresTipoCredito.put("B", 0);
        contadoresTipoCredito.put("W", 0);
        contadoresTipoCredito.put("Y", 0);
        totaisTipoDebito.put("H", 0.0);
        totaisTipoDebito.put("I", 0.0);
        totaisTipoDebito.put("O", 0.0);
        totaisTipoDebito.put("C", 0.0);
        totaisTipoDebito.put("P", 0.0);
        totaisTipoDebito.put("A", 0.0);
        totaisTipoDebito.put("D", 0.0);
        totaisTipoDebito.put("E", 0.0);
        totaisTipoDebito.put("U", 0.0);
        totaisTipoDebito.put("N", 0.0);
        totaisTipoDebito.put("F", 0.0);
        totaisTipoDebito.put("S", 0.0);
        totaisTipoDebito.put("B", 0.0);
        totaisTipoDebito.put("W", 0.0);
        totaisTipoDebito.put("Y", 0.0);
        totaisTipoCredito.put("H", 0.0);
        totaisTipoCredito.put("I", 0.0);
        totaisTipoCredito.put("O", 0.0);
        totaisTipoCredito.put("C", 0.0);
        totaisTipoCredito.put("P", 0.0);
        totaisTipoCredito.put("A", 0.0);
        totaisTipoCredito.put("D", 0.0);
        totaisTipoCredito.put("E", 0.0);
        totaisTipoCredito.put("U", 0.0);
        totaisTipoCredito.put("N", 0.0);
        totaisTipoCredito.put("F", 0.0);
        totaisTipoCredito.put("S", 0.0);
        totaisTipoCredito.put("B", 0.0);
        totaisTipoCredito.put("W", 0.0);
        totaisTipoCredito.put("Y", 0.0);
        contadoresTipoDebitoCancelados.put("H", 0);
        contadoresTipoDebitoCancelados.put("I", 0);
        contadoresTipoDebitoCancelados.put("O", 0);
        contadoresTipoDebitoCancelados.put("C", 0);
        contadoresTipoDebitoCancelados.put("P", 0);
        contadoresTipoDebitoCancelados.put("A", 0);
        contadoresTipoDebitoCancelados.put("D", 0);
        contadoresTipoDebitoCancelados.put("E", 0);
        contadoresTipoDebitoCancelados.put("U", 0);
        contadoresTipoDebitoCancelados.put("N", 0);
        contadoresTipoDebitoCancelados.put("F", 0);
        contadoresTipoDebitoCancelados.put("S", 0);
        contadoresTipoDebitoCancelados.put("B", 0);
        contadoresTipoDebitoCancelados.put("W", 0);
        contadoresTipoDebitoCancelados.put("Y", 0);
        contadoresTipoCreditoCancelados.put("H", 0);
        contadoresTipoCreditoCancelados.put("I", 0);
        contadoresTipoCreditoCancelados.put("O", 0);
        contadoresTipoCreditoCancelados.put("C", 0);
        contadoresTipoCreditoCancelados.put("P", 0);
        contadoresTipoCreditoCancelados.put("A", 0);
        contadoresTipoCreditoCancelados.put("D", 0);
        contadoresTipoCreditoCancelados.put("E", 0);
        contadoresTipoCreditoCancelados.put("U", 0);
        contadoresTipoCreditoCancelados.put("N", 0);
        contadoresTipoCreditoCancelados.put("F", 0);
        contadoresTipoCreditoCancelados.put("S", 0);
        contadoresTipoCreditoCancelados.put("B", 0);
        contadoresTipoCreditoCancelados.put("W", 0);
        contadoresTipoCreditoCancelados.put("Y", 0);
        totaisTipoDebitoCancelados.put("H", 0.0);
        totaisTipoDebitoCancelados.put("I", 0.0);
        totaisTipoDebitoCancelados.put("O", 0.0);
        totaisTipoDebitoCancelados.put("C", 0.0);
        totaisTipoDebitoCancelados.put("P", 0.0);
        totaisTipoDebitoCancelados.put("A", 0.0);
        totaisTipoDebitoCancelados.put("D", 0.0);
        totaisTipoDebitoCancelados.put("E", 0.0);
        totaisTipoDebitoCancelados.put("U", 0.0);
        totaisTipoDebitoCancelados.put("N", 0.0);
        totaisTipoDebitoCancelados.put("F", 0.0);
        totaisTipoDebitoCancelados.put("S", 0.0);
        totaisTipoDebitoCancelados.put("B", 0.0);
        totaisTipoDebitoCancelados.put("W", 0.0);
        totaisTipoDebitoCancelados.put("Y", 0.0);
        totaisTipoCreditoCancelados.put("H", 0.0);
        totaisTipoCreditoCancelados.put("I", 0.0);
        totaisTipoCreditoCancelados.put("O", 0.0);
        totaisTipoCreditoCancelados.put("C", 0.0);
        totaisTipoCreditoCancelados.put("P", 0.0);
        totaisTipoCreditoCancelados.put("A", 0.0);
        totaisTipoCreditoCancelados.put("D", 0.0);
        totaisTipoCreditoCancelados.put("E", 0.0);
        totaisTipoCreditoCancelados.put("U", 0.0);
        totaisTipoCreditoCancelados.put("N", 0.0);
        totaisTipoCreditoCancelados.put("F", 0.0);
        totaisTipoCreditoCancelados.put("S", 0.0);
        totaisTipoCreditoCancelados.put("B", 0.0);
        totaisTipoCreditoCancelados.put("W", 0.0);
        totaisTipoCreditoCancelados.put("Y", 0.0);
        this.setModuloConfigurar(Long.parseLong("0840102301"));
        this.setModuloAcesso(RelatorioCaixa.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_CAIXA);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "estacao"))) {
                this.setSelecionadosFiltro("filtroEstacao", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "usuario"))) {
                this.setSelecionadosFiltro("filtroUsuario", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "conta"))) {
                this.setSelecionadosFiltro("filtroConta", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.setFiltroData("filtroHoraInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.setFiltroData("filtroHoraFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "pagamento"))) {
                this.setFiltroCombo("filtroPagamento", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "caucao"))) {
                this.setFiltroCheck("filtroCaucao", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordem"))) {
                this.setFiltroCombo("ordemRelatorio", tmp);
            }
            if (!this.isOcultarFiltroConvenio && !Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "convenio"))) {
                this.setSelecionadosFiltro("filtroConvenioExcluido", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ocultarcancelados"))) {
                this.setFiltroCheck("filtroOcultarCancelados", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ignorarestacao"))) {
                this.setFiltroCheck("filtroIgnorarEstacao", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ignorartipolancamentoordenar"))) {
                this.setFiltroCheck("filtroIgnorarTipoLancamentoOrdenar", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        boolean intervaloHora = this.getFiltroCheck("filtroIntervaloHora");
        String filtroDataInicial = this.getFiltroData("filtroDataInicial");
        String filtroHoraInicial = this.getFiltroHora("filtroHoraInicial");
        String filtroDataFinal = this.getFiltroData("filtroDataFinal");
        String filtroHoraFinal = this.getFiltroHora("filtroHoraFinal");
        if (intervaloHora) {
            if (!filtroDataInicial.isEmpty() && filtroHoraInicial.isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (filtroDataInicial.isEmpty() && !filtroHoraInicial.isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!filtroDataFinal.isEmpty() && filtroHoraFinal.isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (filtroDataFinal.isEmpty() && !filtroHoraFinal.isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        String[] estacao = this.getSelecionadosFiltro("filtroEstacao", 0);
        String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
        String[] conta = this.getSelecionadosFiltro("filtroConta", 0);
        String[] conveniosExcluidos = this.getSelecionadosFiltro("filtroConvenioExcluido", 0);
        String tipoPagamento = this.getFiltroCombo("filtroPagamento").toString();
        boolean filtroCheckCaucao = this.getFiltroCheck("filtroCaucao");
        boolean filtroCheckOcultarCancelados = this.getFiltroCheck("filtroOcultarCancelados");
        String filtroComboOrdem = this.getFiltroCombo("ordemRelatorio").toString();
        boolean filtroCheckIgnorarTipoLancOrdenar = this.getFiltroCheck("filtroIgnorarTipoLancamentoOrdenar");
        boolean filtroCheckIgnorarEstacao = this.getFiltroCheck("filtroIgnorarEstacao");
        if (conveniosExcluidos != null && conveniosExcluidos.length > 0) {
            StringBuilder b = new StringBuilder();
            for (String s : conveniosExcluidos) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(s);
            }
            if (Funcoes.mensagem(this, "Os seguintes conv\u00eanios n\u00e3o ter\u00e3o seus lan\u00e7amentos demonstrados, podendo gerar uma informa\u00e7\u00e3o inexata:" + b.toString() + "\nConfirma a gera\u00e7\u00e3o do relat\u00f3rio?", 4) == 1) {
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        if (filtroCheckOcultarCancelados && Funcoes.mensagem(this, "Os lan\u00e7amentos cancelados n\u00e3o ser\u00e3o demonstrados, podendo gerar uma informa\u00e7\u00e3o inexata.\nConfirma a gera\u00e7\u00e3o do relat\u00f3rio?", 4) == 1) {
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            return;
        }
        Statement st = Conexao.getStatement();
        this.gerarRelatorio(false, RelatorioCaixa.naoPermiteFiltrarFilial(), st, intervaloHora, filtroDataInicial, filtroHoraInicial, filtroDataFinal, filtroHoraFinal, Variaveis.filialPadrao, filiais, estacao, usuario, conta, conveniosExcluidos, tipoPagamento, filtroCheckCaucao, filtroCheckOcultarCancelados, filtroComboOrdem, filtroCheckIgnorarTipoLancOrdenar, filtroCheckIgnorarEstacao, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public RetornoRelatorioCaixa gerarRelatorio(boolean isColetaWeb, boolean acessoFilial, Statement st, boolean intervaloHora, String filtroDataInicial, String filtroHoraInicial, String filtroDataFinal, String filtroHoraFinal, String filial, String[] filiais, String[] estacao, String[] usuario, String[] conta, String[] conveniosExcluidos, String tipoPagamento, boolean filtroCheckCaucao, boolean filtroCheckOcultarCancelados, String filtroComboOrdem, boolean filtroCheckIgnorarTipoLancOrdenar, boolean filtroCheckIgnorarEstacao, int casasPrecoExame, RoundingMode round) {
        try {
            for (String s : contadoresTipoDebito.keySet()) {
                if (!contadoresTipoDebito.containsKey(s)) continue;
                contadoresTipoDebito.put(s, 0);
            }
            for (String s : contadoresTipoCredito.keySet()) {
                if (!contadoresTipoCredito.containsKey(s)) continue;
                contadoresTipoCredito.put(s, 0);
            }
            for (String s : totaisTipoDebito.keySet()) {
                if (!totaisTipoDebito.containsKey(s)) continue;
                totaisTipoDebito.put(s, 0.0);
            }
            for (String s : totaisTipoCredito.keySet()) {
                if (!totaisTipoCredito.containsKey(s)) continue;
                totaisTipoCredito.put(s, 0.0);
            }
            for (String s : contadoresTipoDebitoCancelados.keySet()) {
                if (!contadoresTipoDebitoCancelados.containsKey(s)) continue;
                contadoresTipoDebitoCancelados.put(s, 0);
            }
            for (String s : contadoresTipoCreditoCancelados.keySet()) {
                if (!contadoresTipoCreditoCancelados.containsKey(s)) continue;
                contadoresTipoCreditoCancelados.put(s, 0);
            }
            for (String s : totaisTipoDebitoCancelados.keySet()) {
                if (!totaisTipoDebitoCancelados.containsKey(s)) continue;
                totaisTipoDebitoCancelados.put(s, 0.0);
            }
            for (String s : totaisTipoCreditoCancelados.keySet()) {
                if (!totaisTipoCreditoCancelados.containsKey(s)) continue;
                totaisTipoCreditoCancelados.put(s, 0.0);
            }
            String queryRelatorio = RelatorioCaixa.getSqlRelatorio(acessoFilial, filial, filiais, estacao, usuario, conta, conveniosExcluidos, intervaloHora, filtroDataInicial, filtroHoraInicial, filtroDataFinal, filtroHoraFinal, tipoPagamento, filtroCheckCaucao, filtroCheckOcultarCancelados, filtroComboOrdem, filtroCheckIgnorarTipoLancOrdenar, filtroCheckIgnorarEstacao);
            int qtdeCreditos = 0;
            int qtdeDebitos = 0;
            int qtdeCanceladosCreditos = 0;
            int qtdeCanceladosDebitos = 0;
            double totalCreditos = 0.0;
            double totalDebitos = 0.0;
            double totalCanceladosCreditos = 0.0;
            double totalCanceladosDebitos = 0.0;
            ResultSet rs = st.executeQuery(queryRelatorio);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    String chave;
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equalsIgnoreCase("tipoLogradouroPaciente") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equals("tipoLancamento") ? Tipos.tipoLancamentoCaixa(rs.getString(campos[i])) : (campos[i].equals("indiceTipoLancamento") ? Integer.valueOf(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1) : (campos[i].equals("valorLancamento") ? Double.valueOf(rs.getDouble(campos[i]) * (double)(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1)) : (campos[i].equals("valorTotalLancamento") ? Double.valueOf(rs.getDouble(campos[i]) * (double)(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1)) : (campos[i].equals("tipoDocumentoLancamento") ? Tipos.tipoDocumento(rs.getString(campos[i])) : (campos[i].equals("tipoUltimoPagamentoRequisicao") || campos[i].equals("tipoPagamentoLancamento") ? Tipos.tipoPagamento(rs.getString(campos[i])) : rs.getObject(campos[i])))))));
                    }
                    modelo.addLine(o);
                    if (rs.getString("tipoLancamento").equals("C")) {
                        ++qtdeCreditos;
                        totalCreditos += rs.getDouble("valorLancamento");
                        chave = rs.getString("tipoPagamentoLancamento");
                        if (contadoresTipoCredito.containsKey(chave)) {
                            contadoresTipoCredito.put(chave, contadoresTipoCredito.get(chave) + 1);
                        }
                        if (totaisTipoCredito.containsKey(chave)) {
                            totaisTipoCredito.put(chave, totaisTipoCredito.get(chave) + rs.getDouble("valorLancamento"));
                        }
                        if (!rs.getBoolean("canceladoLancamento")) continue;
                        ++qtdeCanceladosCreditos;
                        totalCanceladosCreditos += rs.getDouble("valorLancamento");
                        if (contadoresTipoCreditoCancelados.containsKey(chave)) {
                            contadoresTipoCreditoCancelados.put(chave, contadoresTipoCreditoCancelados.get(chave) + 1);
                        }
                        if (!totaisTipoCreditoCancelados.containsKey(chave)) continue;
                        totaisTipoCreditoCancelados.put(chave, totaisTipoCreditoCancelados.get(chave) + rs.getDouble("valorLancamento"));
                        continue;
                    }
                    ++qtdeDebitos;
                    totalDebitos += rs.getDouble("valorLancamento");
                    chave = rs.getString("tipoPagamentoLancamento");
                    if (contadoresTipoDebito.containsKey(chave)) {
                        contadoresTipoDebito.put(chave, contadoresTipoDebito.get(chave) + 1);
                    }
                    if (totaisTipoDebito.containsKey(chave)) {
                        totaisTipoDebito.put(chave, totaisTipoDebito.get(chave) + rs.getDouble("valorLancamento"));
                    }
                    if (!rs.getBoolean("canceladoLancamento")) continue;
                    ++qtdeCanceladosDebitos;
                    totalCanceladosDebitos += rs.getDouble("valorLancamento");
                    if (contadoresTipoDebitoCancelados.containsKey(chave)) {
                        contadoresTipoDebitoCancelados.put(chave, contadoresTipoDebitoCancelados.get(chave) + 1);
                    }
                    if (!totaisTipoDebitoCancelados.containsKey(chave)) continue;
                    totaisTipoDebitoCancelados.put(chave, totaisTipoDebitoCancelados.get(chave) + rs.getDouble("valorLancamento"));
                } while (rs.next());
                StringBuilder buf = new StringBuilder();
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioCaixa.getModuloAcesso());
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(casasPrecoExame, round);
                    if (!isColetaWeb) {
                        gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(() -> {
                            this.panelCentro.removeAll();
                            this.panelCentro.repaint();
                            this.habilitaBotaoImprimir(true);
                        });
                    }
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", filtroComboOrdem);
                    var.put("filtroDataInicial", filtroDataInicial);
                    var.put("filtroDataFinal", filtroDataFinal);
                    var.put("filtroHoraInicial", filtroHoraInicial);
                    var.put("filtroHoraFinal", filtroHoraFinal);
                    var.put("filtroPagamento", this.getFiltroCombo("filtroPagamento"));
                    var.put("filtroCaucao", filtroCheckCaucao);
                    var.put("filtroIgnorarEstacao", filtroCheckIgnorarEstacao);
                    var.put("filtroIntervaloHora", intervaloHora ? "Sim" : "N\u00e3o");
                    var.put("filtroIgnorarTipoLancamentoOrdenar", filtroCheckIgnorarTipoLancOrdenar ? "Sim" : "N\u00e3o");
                    var.put("quantidadeLancamentos", qtdeCreditos + qtdeDebitos);
                    var.put("quantidadeCancelamentos", qtdeCanceladosCreditos + qtdeCanceladosDebitos);
                    var.put("quantidadeCreditosCancelados", qtdeCanceladosCreditos);
                    var.put("quantidadeDebitosCancelados", qtdeCanceladosDebitos);
                    var.put("quantidadeCreditos", qtdeCreditos);
                    var.put("quantidadeDebitos", qtdeDebitos);
                    var.put("totalCreditos", totalCreditos);
                    var.put("totalDebitos", totalDebitos);
                    var.put(VARIAVEL_TOTALCREDITOSCANCELADOS, totalCanceladosCreditos);
                    var.put("totalDebitosCancelados", totalCanceladosDebitos);
                    StringBuilder p = new StringBuilder();
                    p.append("<ordem>").append(filtroComboOrdem).append("</ordem>");
                    p.append("<datainicial>").append(filtroDataInicial).append("</datainicial>");
                    p.append("<datafinal>").append(filtroDataFinal).append("</datafinal>");
                    p.append("<horainicial>").append(filtroHoraInicial).append("</horainicial>");
                    p.append("<horafinal>").append(filtroHoraFinal).append("</horafinal>");
                    p.append("<pagamento>").append(this.getFiltroCombo("filtroPagamento")).append("</pagamento>");
                    p.append("<caucao>").append(filtroCheckCaucao).append("</caucao>");
                    p.append("<ocultarcancelados>").append(filtroCheckOcultarCancelados).append("</ocultarcancelados>");
                    p.append("<ignorarestacao>").append(filtroCheckIgnorarEstacao).append("</ignorarestacao>");
                    p.append("<ignorartipolancamentoordenar>").append(filtroCheckIgnorarTipoLancOrdenar).append("</ignorartipolancamentoordenar>");
                    p.append("<intervalohora>").append(intervaloHora).append("</intervalohora>");
                    var.put(VARIAVEL_QTDEDEBITOS_CHEQUE, contadoresTipoDebito.get("H"));
                    var.put("quantidadeDebitosCartaoDebito", contadoresTipoDebito.get("I"));
                    var.put("quantidadeDebitosCartaoCredito", contadoresTipoDebito.get("O") + contadoresTipoDebito.get("C"));
                    var.put("quantidadeDebitosPreDatado", contadoresTipoDebito.get("P"));
                    var.put("quantidadeDebitosCaucao", contadoresTipoDebito.get("A"));
                    var.put("quantidadeDebitosDinheiro", contadoresTipoDebito.get("D"));
                    var.put("quantidadeDebitosDeposito", contadoresTipoDebito.get("E"));
                    var.put("quantidadeDebitosOnLine", contadoresTipoDebito.get("N"));
                    var.put("quantidadeDebitosFolha", contadoresTipoDebito.get("F"));
                    var.put("quantidadeDebitosTransferencia", contadoresTipoDebito.get("W"));
                    var.put("quantidadeCreditosCheque", contadoresTipoCredito.get("H"));
                    var.put("quantidadeCreditosCartaoDebito", contadoresTipoCredito.get("I"));
                    var.put("quantidadeCreditosCartaoCredito", contadoresTipoCredito.get("O") + contadoresTipoCredito.get("C"));
                    var.put("quantidadeCreditosPreDatado", contadoresTipoCredito.get("P"));
                    var.put("quantidadeCreditosCaucao", contadoresTipoCredito.get("A"));
                    var.put("quantidadeCreditosDinheiro", contadoresTipoCredito.get("D"));
                    var.put("quantidadeCreditosDeposito", contadoresTipoCredito.get("E"));
                    var.put("quantidadeCreditosTransferencia", contadoresTipoCredito.get("W"));
                    var.put("totalDebitosCheque", totaisTipoDebito.get("H"));
                    var.put("totalDebitosCartaoDebito", totaisTipoDebito.get("I"));
                    var.put("totalDebitosCartaoCredito", totaisTipoDebito.get("O") + totaisTipoDebito.get("C"));
                    var.put("totalDebitosPreDatado", totaisTipoDebito.get("P"));
                    var.put("totalDebitosCaucao", totaisTipoDebito.get("A"));
                    var.put("totalDebitosDinheiro", totaisTipoDebito.get("D"));
                    var.put("totalDebitosDeposito", totaisTipoDebito.get("E"));
                    var.put("totalDebitosOnLine", totaisTipoDebito.get("N"));
                    var.put(VARIAVEL_TOTALDEBITOS_FOLHA, totaisTipoDebito.get("F"));
                    var.put(VARIAVEL_TOTALDEBITOS_TRANSFERENCIA, totaisTipoDebito.get("W"));
                    var.put("totalCreditosCheque", totaisTipoCredito.get("H"));
                    var.put("totalCreditosCartaoDebito", totaisTipoCredito.get("I"));
                    var.put("totalCreditosCartaoCredito", totaisTipoCredito.get("O") + totaisTipoCredito.get("C"));
                    var.put("totalCreditosPreDatado", totaisTipoCredito.get("P"));
                    var.put("totalCreditosCaucao", totaisTipoCredito.get("A"));
                    var.put("totalCreditosDinheiro", totaisTipoCredito.get("D"));
                    var.put("totalCreditosDeposito", totaisTipoCredito.get("E"));
                    var.put("totalCreditosTransferencia", totaisTipoCredito.get("W"));
                    var.put("quantidadeDebitosChequeCancelados", contadoresTipoDebitoCancelados.get("H"));
                    var.put("quantidadeDebitosCartaoDebitoCancelados", contadoresTipoDebitoCancelados.get("I"));
                    var.put("quantidadeDebitosCartaoCreditoCancelados", contadoresTipoDebitoCancelados.get("O") + contadoresTipoDebitoCancelados.get("C"));
                    var.put("quantidadeDebitosPreDatadoCancelados", contadoresTipoDebitoCancelados.get("P"));
                    var.put("quantidadeDebitosCaucaoCancelados", contadoresTipoDebitoCancelados.get("A"));
                    var.put("quantidadeDebitosDinheiroCancelados", contadoresTipoDebitoCancelados.get("D"));
                    var.put("quantidadeDebitosDepositoCancelados", contadoresTipoDebitoCancelados.get("E"));
                    var.put("quantidadeDebitosTransferenciaCancelados", contadoresTipoDebitoCancelados.get("W"));
                    var.put("quantidadeDebitosOnLineCancelados", contadoresTipoDebitoCancelados.get("N"));
                    var.put("quantidadeDebitosFolhaCancelados", contadoresTipoDebitoCancelados.get("F"));
                    var.put("quantidadeCreditosChequeCancelados", contadoresTipoCreditoCancelados.get("H"));
                    var.put("quantidadeCreditosCartaoDebitoCancelados", contadoresTipoCreditoCancelados.get("I"));
                    var.put("quantidadeCreditosCartaoCreditoCancelados", contadoresTipoCreditoCancelados.get("O") + contadoresTipoCreditoCancelados.get("C"));
                    var.put("quantidadeCreditosPreDatadoCancelados", contadoresTipoCreditoCancelados.get("P"));
                    var.put("quantidadeCreditosCaucaoCancelados", contadoresTipoCreditoCancelados.get("A"));
                    var.put("quantidadeCreditosDinheiroCancelados", contadoresTipoCreditoCancelados.get("D"));
                    var.put("quantidadeCreditosDepositoCancelados", contadoresTipoCreditoCancelados.get("E"));
                    var.put("quantidadeCreditosTransferenciaCancelados", contadoresTipoCreditoCancelados.get("W"));
                    var.put("totalDebitosChequeCancelados", totaisTipoDebitoCancelados.get("H"));
                    var.put("totalDebitosCartaoDebitoCancelados", totaisTipoDebitoCancelados.get("I"));
                    var.put("totalDebitosCartaoCreditoCancelados", totaisTipoDebitoCancelados.get("O") + totaisTipoDebitoCancelados.get("C"));
                    var.put("totalDebitosPreDatadoCancelados", totaisTipoDebitoCancelados.get("P"));
                    var.put("totalDebitosCaucaoCancelados", totaisTipoDebitoCancelados.get("A"));
                    var.put("totalDebitosDinheiroCancelados", totaisTipoDebitoCancelados.get("D"));
                    var.put("totalDebitosDepositoCancelados", totaisTipoDebitoCancelados.get("E"));
                    var.put("totalDebitosOnLineCancelados", totaisTipoDebitoCancelados.get("N"));
                    var.put("totalDebitosFolhaCancelados", totaisTipoDebitoCancelados.get("F"));
                    var.put("totalDebitosTransferenciaCancelados", totaisTipoDebitoCancelados.get("W"));
                    var.put("totalCreditosChequeCancelados", totaisTipoCreditoCancelados.get("H"));
                    var.put("totalCreditosCartaoDebitoCancelados", totaisTipoCreditoCancelados.get("I"));
                    var.put("totalCreditosCartaoCreditoCancelados", totaisTipoCreditoCancelados.get("O") + totaisTipoCreditoCancelados.get("C"));
                    var.put("totalCreditosPreDatadoCancelados", totaisTipoCreditoCancelados.get("P"));
                    var.put("totalCreditosCaucaoCancelados", totaisTipoCreditoCancelados.get("A"));
                    var.put("totalCreditosDinheiroCancelados", totaisTipoCreditoCancelados.get("D"));
                    var.put("totalCreditosDepositoCancelados", totaisTipoCreditoCancelados.get("E"));
                    var.put("totalCreditosTransferenciaCancelados", totaisTipoCreditoCancelados.get("W"));
                    var.put("quantidadeDebitosPromissoria", contadoresTipoDebito.get("S"));
                    var.put("quantidadeCreditosPromissoria", contadoresTipoCredito.get("S"));
                    var.put("totalDebitosPromissoria", totaisTipoDebito.get("S"));
                    var.put("totalCreditosPromissoria", totaisTipoCredito.get("S"));
                    var.put("quantidadeDebitosPromissoriaCancelados", contadoresTipoDebitoCancelados.get("S"));
                    var.put("quantidadeCreditosPromissoriaCancelados", contadoresTipoCreditoCancelados.get("S"));
                    var.put("totalDebitosPromissoriaCancelados", totaisTipoDebitoCancelados.get("S"));
                    var.put("totalCreditosPromissoriaCancelados", totaisTipoCreditoCancelados.get("S"));
                    var.put("quantidadeDebitosDebAutomatico", contadoresTipoDebito.get("U"));
                    var.put("quantidadeCreditosDebAutomatico", contadoresTipoCredito.get("U"));
                    var.put("totalDebitosDebAutomatico", totaisTipoDebito.get("U"));
                    var.put("totalCreditosDebAutomatico", totaisTipoCredito.get("U"));
                    var.put("quantidadeDebitosDebAutomaticoCancelados", contadoresTipoDebitoCancelados.get("U"));
                    var.put("quantidadeCreditosDebAutomaticoCancelados", contadoresTipoCreditoCancelados.get("U"));
                    var.put("totalDebitosDebAutomaticoCancelados", totaisTipoDebitoCancelados.get("U"));
                    var.put("totalCreditosDebAutomaticoCancelados", totaisTipoCreditoCancelados.get("U"));
                    var.put("quantidadeDebitosBoleto", contadoresTipoDebito.get("B"));
                    var.put("quantidadeCreditosBoleto", contadoresTipoCredito.get("B"));
                    var.put("totalDebitosBoleto", totaisTipoDebito.get("B"));
                    var.put("totalCreditosBoleto", totaisTipoCredito.get("B"));
                    var.put("quantidadeDebitosBoletoCancelados", contadoresTipoDebitoCancelados.get("B"));
                    var.put("quantidadeCreditosBoletoCancelados", contadoresTipoCreditoCancelados.get("B"));
                    var.put("totalDebitosBoletoCancelados", totaisTipoDebitoCancelados.get("B"));
                    var.put("totalCreditosBoletoCancelados", totaisTipoCreditoCancelados.get("B"));
                    var.put("quantidadeDebitosPix", contadoresTipoDebito.get("Y"));
                    var.put("quantidadeCreditosPix", contadoresTipoCredito.get("Y"));
                    var.put("totalDebitosPix", totaisTipoDebito.get("Y"));
                    var.put("totalCreditosPix", totaisTipoCredito.get("Y"));
                    var.put("quantidadeDebitosPixCancelados", contadoresTipoDebitoCancelados.get("Y"));
                    var.put("quantidadeCreditosPixCancelados", contadoresTipoCreditoCancelados.get("Y"));
                    var.put("totalDebitosPixCancelados", totaisTipoDebitoCancelados.get("Y"));
                    var.put("totalCreditosPixCancelados", totaisTipoCreditoCancelados.get("Y"));
                    var.put("quantidadeCreditosOnline", contadoresTipoCredito.get("N"));
                    var.put("quantidadeOnlineCancelados", contadoresTipoCreditoCancelados.get("N"));
                    var.put("totalCreditosOnline", totaisTipoCredito.get("N"));
                    var.put("totalCreditosOnlineCancelados", totaisTipoCreditoCancelados.get("N"));
                    p.append("<filial>");
                    buf.delete(0, buf.length());
                    if (filiais != null && filiais.length > 0) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    } else {
                        buf.append(filial);
                    }
                    var.put("filtroFilial", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</filial>");
                    buf.delete(0, buf.length());
                    if (estacao != null) {
                        p.append("<estacao>");
                        for (i = 0; i < estacao.length; ++i) {
                            buf.append(estacao[i]);
                            if (i >= estacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</estacao>");
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        p.append("<usuario>");
                        for (i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</usuario>");
                    buf.delete(0, buf.length());
                    if (conta != null) {
                        p.append("<conta>");
                        for (i = 0; i < conta.length; ++i) {
                            buf.append(conta[i]);
                            if (i >= conta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConta", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</conta>");
                    buf.delete(0, buf.length());
                    if (conveniosExcluidos != null) {
                        p.append("<convenio>");
                        for (i = 0; i < conveniosExcluidos.length; ++i) {
                            buf.append(conveniosExcluidos[i]);
                            if (i >= conveniosExcluidos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenioExcluido", buf.toString());
                    p.append(buf.toString().replaceAll(" ", "")).append("</convenio>");
                    RetornoRelatorioCaixa retorno = new RetornoRelatorioCaixa();
                    Relatorio rel = new Relatorio(modelo, var, casasPrecoExame, round);
                    String layoutRelatorio = rs.getString("rel_xml");
                    rel.setConfiguracao(layoutRelatorio);
                    if (filtroCheckIgnorarEstacao) {
                        rel.removerBandaCabecalhoGrupo("Banda4");
                    }
                    if (isColetaWeb) {
                        gerador.executar(layoutRelatorio, modelo, var, false, true, isColetaWeb);
                        retorno.setPdf(Impressao.gerarPdfRelatorio(gerador.getRelatorio(), layoutRelatorio));
                        retorno.setXmlParametrosRelatorio(p.toString());
                        return retorno;
                    }
                    ParametrosUsuarios.setValor(PARAMETROS_CAIXA, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    if (!isColetaWeb) {
                        gerador.executar(rel);
                        this.panelCentro.revalidate();
                    }
                }
            } else if (!isColetaWeb) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            } else {
                return new RetornoRelatorioCaixa();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    private static String getSqlRelatorio(boolean acessoFilial, String filial, String[] filiais, String[] estacao, String[] usuario, String[] conta, String[] conveniosExcluidos, boolean intervaloHora, String filtroDataInicial, String filtroHoraInicial, String filtroDataFinal, String filtroHoraFinal, String tipoPagamento, boolean filtroCheckCaucao, boolean filtroCheckOcultarCancelados, String filtroComboOrdem, boolean filtroCheckIgnorarTipoLancOrdenar, boolean filtroCheckIgnorarEstacao) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("lancto.lcx_codigo as codigoLancamento, lancto.lcx_datahora as dataHoraLancamento, cast(lancto.lcx_datahora as date) as dataLancamento, ");
        buf.append("lancto.lcx_tipo as tipoLancamento, lancto.lcx_valor as valorLancamento, lancto.lcx_valortotal as valorTotalLancamento, ");
        buf.append("lancto.lcx_banco as bancoLancamento,lancto.lcx_agencia as agenciaLancamento, ");
        buf.append("lancto.lcx_documento as documentoLancamento, lancto.lcx_obs as observacaoLancamento,");
        buf.append("lancto.lcx_tipodocumento as tipoDocumentoLancamento, lancto.lcx_tipopagamento as tipoPagamentoLancamento, ");
        buf.append("lancto.lcx_nrcheque as numeroChequeLancamento, lancto.lcx_validadecartao as validadeCartaoLancamento, ");
        buf.append("lancto.lcx_nrcartao as numeroCartaoLancamento, lancto.lcx_descricaohistorico as descricaoHistoricoUsuario, ");
        buf.append("lancto.lcx_nomedescfolha as nomeFuncionarioDescontoFolhaLancamento, ");
        buf.append("lancto.lcx_setordescfolha as setorFuncionarioDescontoFolhaLancamento, ");
        buf.append("lancto.lcx_autorizadodescfolha as nomeFuncionarioAutorizacaoDescontoFolhaLancamento, ");
        buf.append("(lancto.lcx_situacao = '").append("C").append("' or ");
        buf.append("(lancto.lcx_situacao = '").append("O").append("' and lancto.lcx_tipoorigem = '");
        buf.append("V").append("')) as canceladoLancamento, ");
        buf.append("lancto.lcx_cartaocredito as cartaoCreditoLancamento, lancto.lcx_conta as contaLancamento, ");
        buf.append("lancto.lcx_conciliacao as dataConciliacaoLancamento, lancto.lcx_vencimento as dataVencimentoLancamento, lancto.lcx_tipotransferencia as tipoTransferencia,  ");
        buf.append("lancto.usr_codigo as usuarioCancelamentoLancamento, lancto.lcx_datacancelado as dataCancelamentoLancamento, ");
        buf.append("lancto.lcx_pix as pix, ");
        buf.append("filiais.fil_codigo as codigoFilialDestinoOrigem ,");
        buf.append("usuariocancela.usr_nome as nomeUsuarioCancelamentoLancamento, ");
        buf.append("lancto.est_codigo as codigoEstacaoLancamento, estacoes.est_descricao as descricaoEstacaoLancamento, ");
        buf.append("conta.cco_reduzido as codigoReduzidoConta, conta.cco_conta as contaConta, conta.cco_titular as titularConta,");
        buf.append("usrlancto.usr_codigo as codigoUsuarioLancamento, usrlancto.usr_nome as nomeUsuarioLancamento, ");
        buf.append(" a.req_codigo as codigoRequisicao, a.req_data as dataRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
        buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
        buf.append("a.req_notacaixa as notaCaixaRequisicao, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, a.req_totaltaxa as totalTaxaRequisicao, ");
        buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
        buf.append("a.req_hora as horaRequisicao, ");
        buf.append("a.req_matricula as matriculaRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, ");
        buf.append("a.req_titular as titularRequisicao, ");
        buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
        buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
        buf.append("a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("a.req_validadeguia as validadeGuiaRequisicao,  ");
        buf.append("a.req_guia as guiaRequisicao, a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, ");
        buf.append("paciente.pac_nomesocial as nomeSocialPaciente, ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_vip as vipPaciente, ");
        buf.append("paciente.pac_observ as observacaoPaciente, ");
        buf.append("paciente.pac_matricconv as matriculaConvenioPaciente, ");
        buf.append("paciente.pac_titularconv as titularConvenioPaciente,  ");
        buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
        buf.append("paciente.pac_datahora as dataHoraCadastroPaciente, ");
        buf.append("paciente.pac_fax as faxPaciente, paciente.pac_celular as celularPaciente, ");
        buf.append("paciente.pac_fonecomercial as foneComercialPaciente, paciente.pac_fone as fonePaciente, ");
        buf.append("paciente.pac_cep as cepPaciente, paciente.pac_complemento as complementoPaciente, ");
        buf.append("paciente.pac_endereco as enderecoPaciente, paciente.pac_numeroendereco as numeroEnderecoPaciente, ");
        buf.append("paciente.pac_tipologradouroendereco as tipoLogradouroPaciente, paciente.pac_email as emailPaciente, ");
        buf.append("paciente.pac_anomes as anomesIdadePaciente, paciente.pac_idade as idadePaciente, ");
        buf.append("paciente.pac_fonecontato as foneContatoPaciente, paciente.pac_nomecontato as contatoPaciente, ");
        buf.append("paciente.pac_mae as maePaciente, paciente.pac_pai as paiPaciente, ");
        buf.append("cidpaciente.cid_codigo as codigoCidadePaciente, cidpaciente.cid_nome as descricaoCidadePaciente, ");
        buf.append("cidpaciente.cid_uf as estadoCidadePaciente, ");
        buf.append("baipaciente.bai_codigo as codigoBairroPaciente, baipaciente.bai_descricao as descricaoBairroPaciente, ");
        buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
        buf.append("usrabertura.usr_codigo as codigoUsuarioAberturaRequisicao, usrabertura.usr_nome as nomeUsuarioAberturaRequisicao, ");
        buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino,  ");
        buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
        buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
        buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
        buf.append("convenio.con_observ as observacaoConvenio, convenio.con_tppgto as tipoPagamentoConvenio, ");
        buf.append("convenio.con_percpgto as percentualBalcaoConvenio, convenio.con_cobrexame as cobrarExameBalcaoConvenio, ");
        buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, ");
        buf.append("convenio.con_fax as faxConvenio, ");
        buf.append("convenio.con_fone as foneConvenio, convenio.con_valorfilme as valorFilmeConvenio,  ");
        buf.append("convenio.con_valorch as valorCHConvenio, ");
        buf.append("convenio.con_inscmunic as inscricaoMunicipalConvenio,  ");
        buf.append("convenio.con_bonus as percentualBonusConvenio, convenio.con_validadeguia as obrigaValidadeGuiaConvenio,  ");
        buf.append("convenio.con_acrescimo as percentualAcrescimoConvenio, ");
        buf.append("convenio.con_codigoguia as obrigaGuiaConvenio, convenio.con_diasvalidade as diasValidadeGuia,  ");
        buf.append("convenio.con_ordemfatura as ordemFaturaConvenio, convenio.con_cobrmaterial as cobrarMateriaisConvenio, ");
        buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
        buf.append("medico.med_abrev as abreviaturaMedico, ");
        buf.append("medico.med_comissao as comissaoMedico, ");
        buf.append("motivo.mov_codigo as codigoMotivoCancelamento, motivo.mov_descricao as descricaoMotivoCancelamento, ");
        buf.append("lancto.lcx_descricaocancelado as descricaoCancelamentoLancamento, ");
        buf.append("historico.hpa_codigo as codigoHistoricoPadrao, historico.hpa_descricao as descricaoHistoricoPadrao, ");
        buf.append("(select array_agg (nfi.nfi_numero) from notafiscal nfi ");
        buf.append(" JOIN receberpagar rpg  ON nfi.fil_codigo = rpg.fil_codigo AND nfi.nfi_codigo = rpg.nfi_codigo AND ( rpg.usr_codcancelado IS NULL AND rpg.rpg_datacancelado IS NULL ) ");
        buf.append(" JOIN baixareceberpagar brp ON rpg.fil_codigo = brp.fil_codigo AND rpg.rpg_codigo = brp.rpg_codigo ");
        buf.append(" JOIN baixa bxa ON brp.fil_codigo = bxa.fil_codigo AND brp.bxa_codigo = bxa.bxa_codigo AND bxa.bxa_datacancelado IS NULL ");
        buf.append(" JOIN baixalanctocaixa blc ON bxa.fil_codigo = blc.fil_codigo AND bxa.bxa_codigo = blc.bxa_codigo");
        buf.append(" WHERE blc.lcx_codigo = lancto.lcx_codigo AND blc.fil_codigo = lancto.fil_codigo AND blc.est_codigo = lancto.est_codigo ");
        buf.append(" AND ( nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ( 'A', 'I' ) )");
        buf.append(" AND ( bxa.bxa_situacao <> 'P' or bxa.bxa_codigo IS NULL )) as numeroNotaFiscal,");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from lanctocaixa lancto ");
        buf.append("left join requisicaolanctocaixa rl on lancto.fil_codigo = rl.fil_codigo and lancto.lcx_codigo = rl.lcx_codigo and lancto.est_codigo = rl.est_codigo ");
        buf.append("left join requisicao a on rl.fil_codigo = a.fil_codigo and rl.req_codigo = a.req_codigo ");
        buf.append("left join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("left join usuario usrabertura on a.usr_codabertura = usrabertura.usr_codigo ");
        buf.append("left join usuario usuariocancela on lancto.usr_codcancelado = usuariocancela.usr_codigo ");
        buf.append("left join filiais_postocoleta filiais on filiais.fil_codigo = lancto.fil_codentrefilial ");
        buf.append("left join motivoscancelamentos motivo on lancto.fil_codigo = motivo.fil_codigo and lancto.mov_codigo = motivo.mov_codigo ");
        buf.append("left join historicopadrao historico on lancto.fil_codigo = historico.fil_codigo and lancto.hpa_codigo = historico.hpa_codigo ");
        buf.append("left join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("left join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("left join estacoes on lancto.est_codigo = estacoes.est_codigo ");
        buf.append("left join contacorrente conta on lancto.fil_codigo = conta.fil_codigo and lancto.cco_reduzido = conta.cco_reduzido ");
        buf.append("left join usuario usrlancto on lancto.usr_codigo = usrlancto.usr_codigo ");
        buf.append("left join cidades cidpaciente on paciente.fil_codigo = cidpaciente.fil_codigo and paciente.cid_codigo = cidpaciente.cid_codigo ");
        buf.append("left join bairro baipaciente on paciente.fil_codigo = baipaciente.fil_codigo and paciente.bai_codigo = baipaciente.bai_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append("where lancto.fil_codigo ");
        if (acessoFilial) {
            buf.append(" = ").append(filial);
        } else if (filiais == null || filiais.length == 0) {
            buf.append(" = ").append(filial);
        } else {
            buf.append(" in (");
            for (i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (estacao != null) {
            buf.append(" and lancto.est_codigo in (");
            for (i = 0; i < estacao.length; ++i) {
                buf.append(estacao[i]);
                if (i >= estacao.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (usuario != null) {
            buf.append(" and lancto.usr_codigo in (");
            for (i = 0; i < usuario.length; ++i) {
                buf.append("'");
                buf.append(usuario[i]);
                buf.append("'");
                if (i >= usuario.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (conta != null) {
            buf.append(" and lancto.cco_reduzido in (");
            for (i = 0; i < conta.length; ++i) {
                buf.append(conta[i]);
                if (i >= conta.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (conveniosExcluidos != null) {
            buf.append(" and a.con_codigo not in (");
            for (i = 0; i < conveniosExcluidos.length; ++i) {
                buf.append(conveniosExcluidos[i]);
                if (i >= conveniosExcluidos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (intervaloHora) {
            if (Funcoes.verificaData(filtroDataInicial) && Funcoes.verificaHora(filtroHoraInicial)) {
                buf.append(" and date_trunc('minute', lancto.lcx_datahora) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", filtroDataInicial)).append(" ").append(filtroHoraInicial);
                buf.append("'");
            }
            if (Funcoes.verificaData(filtroDataFinal) && Funcoes.verificaHora(filtroHoraFinal)) {
                buf.append(" and date_trunc('minute', lancto.lcx_datahora) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", filtroDataFinal)).append(" ").append(filtroHoraFinal);
                buf.append("'");
            }
        } else {
            if (Funcoes.verificaData(filtroDataInicial)) {
                buf.append(" and cast(lancto.lcx_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", filtroDataInicial));
                buf.append("'");
            }
            if (Funcoes.verificaData(filtroDataFinal)) {
                buf.append(" and cast(lancto.lcx_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", filtroDataFinal));
                buf.append("'");
            }
            if (Funcoes.verificaHora(filtroHoraInicial)) {
                buf.append(" and cast(lancto.lcx_datahora as time) >= '");
                buf.append(filtroHoraInicial);
                buf.append("'");
            }
            if (Funcoes.verificaHora(filtroHoraFinal)) {
                buf.append(" and cast(lancto.lcx_datahora as time) <= '");
                buf.append(filtroHoraFinal);
                buf.append("'");
            }
        }
        if (!tipoPagamento.equals("Todos")) {
            buf.append(" and lancto.lcx_tipopagamento IN ('");
            if (tipoPagamento.equals(Tipos.tipoPagamento("H"))) {
                buf.append("H");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("P"))) {
                buf.append("P");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("A"))) {
                buf.append("A");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("D"))) {
                buf.append("D");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("S"))) {
                buf.append("S");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("I"))) {
                buf.append("I");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("O"))) {
                buf.append("O");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("C"))) {
                buf.append("C");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("E"))) {
                buf.append("E");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("U"))) {
                buf.append("U");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("N"))) {
                buf.append("N");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("F"))) {
                buf.append("F");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("B"))) {
                buf.append("B");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("W"))) {
                buf.append("W");
            } else if (tipoPagamento.equals(Tipos.tipoPagamento("Y"))) {
                buf.append("Y");
            }
            buf.append("') ");
        }
        if (filtroCheckCaucao) {
            buf.append(" and lancto.lcx_tipopagamento != '");
            buf.append("A");
            buf.append("'");
        }
        if (filtroCheckOcultarCancelados) {
            buf.append(" and not (lancto.lcx_situacao = '").append("C").append("' or ");
            buf.append("(lancto.lcx_situacao = '").append("O").append("' and ");
            buf.append("lancto.lcx_tipoorigem = '").append("V").append("')) ");
        }
        buf.append(" and conta.cco_tipo = '").append("X").append("' ");
        buf.append(" order by lancto.fil_codigo, ");
        if (!filtroComboOrdem.equals(DATA) && !filtroCheckIgnorarTipoLancOrdenar) {
            buf.append("lancto.lcx_tipo, ");
        }
        if (!filtroCheckIgnorarEstacao) {
            buf.append("lancto.est_codigo, ");
        }
        if (filtroComboOrdem.equals(DATA_HORA)) {
            buf.append("lancto.lcx_datahora, lancto.lcx_codigo ");
        } else if (filtroComboOrdem.equals(USU\u00c1RIO)) {
            buf.append("lancto.usr_codigo, lancto.lcx_codigo ");
        } else if (filtroComboOrdem.equals(REQUISI\u00c7\u00c3O)) {
            buf.append("a.req_codigo, lancto.lcx_codigo ");
        } else if (filtroComboOrdem.equals(DATA)) {
            buf.append("cast(lancto.lcx_datahora as date), lancto.lcx_codigo  ");
        } else {
            buf.append("lancto.lcx_codigo ");
        }
        return buf.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0840102300");
    }

    public static long getModuloAcessoNaoPermiteFiltrarFilial() {
        return Long.parseLong("0840102303");
    }

    public static boolean naoPermiteFiltrarFilial() {
        return Acesso.getAcesso(RelatorioCaixa.getModuloAcessoNaoPermiteFiltrarFilial());
    }
}

