/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPlanos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] tipo = new String[]{"Todos", "Receitas", "Despesas"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"};
    private final String[] CAMPOSBANCO = new String[]{"plc_reduzido", "plc_conta", "plc_descricao"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0840102101");
    private final String FILTRO_TIPO = "filtroTipoPlanoConta";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "apropriarPlanoConta", "nivelPlanoConta"});

    public RelatorioPlanos() {
        this.setName("RelatorioPlanos");
        this.montaBarraDescricao("Relat\u00f3rio de planos de contas", "Listagem dos planos de contas cadastrados", "relatorios/rel_plano_contas.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroCombo("filtroTipoPlanoConta", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioPlanos.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.plc_reduzido as codigoPlanoConta, ");
            buf.append("a.plc_descricao as descricaoPlanoConta, ");
            buf.append("a.plc_conta as contaPlanoConta, ");
            buf.append("a.plc_tipo as tipoPlanoConta, ");
            buf.append("a.plc_apropriar as apropriarPlanoConta, ");
            buf.append("a.plc_nivel as nivelPlanoConta, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from planoconta a ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            if (!this.getFiltroCombo("filtroTipoPlanoConta").equals(this.tipo[0])) {
                buf.append(" and a.plc_tipo = '");
                if (this.getFiltroCombo("filtroTipoPlanoConta").equals(this.tipo[1])) {
                    buf.append("R");
                } else {
                    buf.append("D");
                }
                buf.append("' ");
            }
            buf.append("order by a.");
            buf.append(this.CAMPOSBANCO[this.getFiltroComboIndice("ordemRelatorio")]);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("tipoPlanoConta") ? Tipos.tipoPlanoContas(rs.getString(campos[i])) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioPlanos.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioPlanos.this.panelCentro.removeAll();
                            RelatorioPlanos.this.panelCentro.repaint();
                            RelatorioPlanos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroTipoPlanoConta", this.getFiltroCombo("filtroTipoPlanoConta"));
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0840102100");
    }
}

