/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioNotaFiscal
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private String[] ordem = new String[]{"N\u00famero", "Data", "Valor L\u00edq.", "Fantasia", "Raz\u00e3o Social", "Fant. + Data", "Raz. Social + Data"};
    private static final String CHAVENFSE_ISNULL = "' and a.nfi_chavenfse IS NULL ";
    private static final String CHAVENFSE_NOTNULL = "' and a.nfi_chavenfse IS NOT NULL ";
    private final String[] tipoCadastro = new String[]{"Todos", Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")};
    private final String[] tipoSituacao = new String[]{"Todas", Tipos.tipoSituacaoNotaFiscal("A", false), Tipos.tipoSituacaoNotaFiscal("C", false).concat(" (manual)"), Tipos.tipoSituacaoNotaFiscal("I", false), Tipos.tipoSituacaoNotaFiscal("E", false), Tipos.tipoSituacaoNotaFiscal("X", true), Tipos.tipoSituacaoNotaFiscal("A", true), Tipos.tipoSituacaoNotaFiscal("R", true), Tipos.tipoSituacaoNotaFiscal("D", true), Tipos.tipoSituacaoNotaFiscal("C", true), Tipos.tipoSituacaoNotaFiscal("N", true), Tipos.tipoSituacaoNotaFiscal("E", true), Tipos.tipoSituacaoNotaFiscal("O", true)};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_SERIE = "filtroSerie";
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_NUMERO_NOTA_FISCAL = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_FORMA_PGTO = "filtroFormaPgto";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_TIPO_CADASTRO = "filtroTipoCadastro";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO = "filtroTipo";
    private static final String[] CAMPOSDATA = new String[]{"Cadastro", "Emiss\u00e3o", "Impress\u00e3o"};
    private static final String[] CAMPOSDATABANCO = new String[]{"nfi_datahora", "nfi_dataemissao", "nfi_datahoraimpressao"};
    public static final int TIPO_LISTAGEM = 0;
    public static final int TIPO_CLIENTE = 1;
    public static final int TIPO_NOTA_FISCAL_ENTRADA = 0;
    public static final int TIPO_NOTA_FISCAL_SAIDA = 1;
    public static final int TIPO_NOTA_FISCAL_ENTRADA_DETALHADA = 2;
    private final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "usuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "codigoInternoNotaFiscal", "dataHoraImpressaoNotaFiscal", "situacaoNotaFiscal", "codigoFormaPgto", "codigoCadastro", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subtotalNotaFiscal", "baseCalculoImpostosNotaFiscal", "descricaoFormaPgto", "acumuladoImpostosNotaFiscal", "dataCancelamentoNotaFiscal", "usuarioCancelamentoNotaFiscal", "nomeUsuarioCancelamentoNotaFiscal", "usuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "descricaoMotivoCancelamento", "codigoMotivoCancelamento", "descricaoCancelamentoUsuario", "datasVencimentoNotaFiscal", "codigoUsuarioAutorizacaoFinanceiraNotaFiscal", "codigoUsuarioReimpressaoNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "codigoUsuarioCanceladaNotaFiscal", "tipoNotaFiscal", "percentualIrrfNotaFiscal", "percentualIssNotaFiscal", "percentualPisNotaFiscal", "percentualCsllNotaFiscal", "percentualCofinsNotaFiscal", "percentualInssNotaFiscal", "dataHoraReimpressaoNotaFiscal", "percentualIpiNotaFiscal", "valorIpiNotaFiscal", "percentualIcmsNotaFiscal", "valorIcmsNotaFiscal", "codigoPedidoNotaFiscal", "dataAutorizacaoFinanceiraNotaFiscal", "valorDescontoNotaFiscal", "percentualDescontoNotaFiscal", "valorFreteNotaFiscal", "codigoCfop", "motivoCfop", "isEletronica", "numeroRps", "isNotaEnviada", "percentualDescontoCondicional", "statusNfse", "motivoNfse", "dataStatusNfse", "protocoloNfse", "chaveRpsNfse", "chaveNfse", "irrfValorNotaFiscal", "issValorNotaFiscal", "pisValorNotaFiscal", "csllValorNotaFiscal", "cofinsValorNotaFiscal", "inssValorNotaFiscal", "nomePagador"});
    private int tipoRelatorio = 0;
    private int tipoNotaFiscalRelatorio = 1;
    public String[] campos = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastros);

    public RelatorioNotaFiscal(int tipoRelatorio, int tipoNotaFiscalRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        this.tipoNotaFiscalRelatorio = tipoNotaFiscalRelatorio;
        if (tipoRelatorio == 0) {
            if (tipoNotaFiscalRelatorio == 1) {
                this.montaBarraDescricao("Relat\u00f3rio de notas fiscais", "Listagem das notas fiscais", "relatorios/rel_financeiro_faturamento_nota_fiscal.jpg");
            } else if (tipoNotaFiscalRelatorio == 0) {
                this.montaBarraDescricao("Relat\u00f3rio de notas fiscais de entrada", "Listagem das notas fiscais de entrada", "relatorios/rel_estoque_pedido_rel_nf_entrada.jpg");
            } else {
                this.montaBarraDescricao("Relat\u00f3rio de notas fiscais de entrada detalhada", "Listagem das notas fiscais de entrada detalhada", "relatorios/rel_estoque_pedido_rel_nf_entrada_detalhada.jpg");
                this.campos = ArraysUtil.concatenar(this.camposRelatorio, new String[]{"fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "codigoMaterial", "descricaoMaterial", "quantidadeMaterial", "valorUnitarioMaterial", "valorIpiMaterial", "percentualIpiMaterial", "valorIcmsMaterial", "percentualIcmsMaterial", "valorTotalMaterial", "valorDescontoMaterial", "percentualDescontoMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida"});
            }
        } else {
            if (tipoNotaFiscalRelatorio == 1) {
                this.montaBarraDescricao("Relat\u00f3rio de notas fiscais por cadastro", "Listagem das notas fiscais por cadastro", "relatorios/rel_financeiro_notas-fiscais-por-cadastro.jpg");
            } else {
                this.montaBarraDescricao("Relat\u00f3rio de notas fiscais de entrada por cadastro", "Listagem das notas fiscais de entrada por cadastro", "relatorios/rel_estoque_pedido_rel_nf_entrada_por_cadastro.jpg");
            }
            this.ordem = new String[]{"N\u00famero", "Data", "Valor"};
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        if (tipoNotaFiscalRelatorio == 1) {
            this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
            }
            this.adicionaItemFiltro("filtroEntidade", "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        } else {
            this.adicionaItemFiltro("filtroEntidade", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'  and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_fantasia", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"}, new int[]{70, 0, 0});
        }
        this.adicionaItemFiltro("filtroSerie", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFormaPgto", "Forma Pagto.", "formapagto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"fpg_codigo", "fpg_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Nota:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        if (tipoNotaFiscalRelatorio == 1) {
            this.adicionaFiltroCombo("filtroTipoCadastro", "Cadastro:", this.tipoCadastro, 0);
            this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", CAMPOSDATA, 0);
        }
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.tipoSituacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioNotaFiscal.getModuloConfigurar(tipoRelatorio, tipoNotaFiscalRelatorio));
        this.setModuloAcesso(RelatorioNotaFiscal.getModuloAcesso(tipoRelatorio, tipoNotaFiscalRelatorio));
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block107: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                ResultSet rs;
                String[] formapgto;
                String[] paciente;
                String[] entidade;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.ser_codigo \t\t\t\tas serieNotaFiscal ");
                buf.append("\t   ,a.nfi_numero \t\t\t\t\tas numeroNotaFiscal ");
                buf.append("\t   ,a.nfi_tipocadastro \t\tas tipoCadastroNotaFiscal ");
                buf.append("\t   ,a.usr_codigo \t\t\t\t\tas usuarioNotaFiscal ");
                buf.append("\t   ,a.nfi_datahora \t\t\t\tas dataHoraNotaFiscal ");
                buf.append("\t   ,a.nfi_dataemissao \t\tas dataEmissaoNotaFiscal ");
                buf.append("\t   ,a.nfi_datahoraimpressao\tas dataHoraImpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_situacao \t\t\t\t\tas situacaoNotaFiscal ");
                buf.append("     ,a.nfi_codigo            as codigoInternoNotaFiscal ");
                buf.append("\t   ,a.fpg_codigo \t\t\t\t\t\tas codigoFormaPgto ");
                buf.append("     ,fpg.fpg_descricao       as descricaoFormaPgto");
                buf.append("\t   ,a.nfi_observacao \t\t\t\tas observacaoNotaFiscal ");
                buf.append("\t   ,a.nfi_subtotal    \t\t\tas subtotalNotaFiscal ");
                buf.append("\t   ,a.nfi_valortotal \t\t\t\tas valorTotalNotaFiscal ");
                buf.append("\t   ,a.nfi_impostoacumulado  as baseCalculoImpostosNotaFiscal ");
                buf.append("     ,a.nfi_descricaocancelamento\tas descricaoCancelamentoUsuario ");
                buf.append("\t   ,a.mov_codigo \t\t\t\t\t\tas codigoMotivoCancelamento ");
                buf.append("\t   ,mov.mov_descricao  \t\t \tas descricaoMotivoCancelamento ");
                buf.append("\t   ,a.usr_codautorizafinanceira as codigoUsuarioAutorizacaoFinanceiraNotaFiscal ");
                buf.append("     ,a.usr_codreimpressao\t\tas codigoUsuarioReimpressaoNotaFiscal ");
                buf.append("     ,a.usr_codimpressao\t\t\tas codigoUsuarioImpressaoNotaFiscal ");
                buf.append("     ,a.usr_codcancelada\t\t\tas codigoUsuarioCanceladaNotaFiscal ");
                buf.append("\t   ,a.nfi_tipo\t\t\t\t\t\t\tas tipoNotaFiscal ");
                buf.append("     ,a.nfi_irrfpercentual\t\tas percentualIrrfNotaFiscal ");
                buf.append("     ,a.nfi_isspercentual\t\t\tas percentualIssNotaFiscal ");
                buf.append("     ,a.nfi_pispercentual\t\t\tas percentualPisNotaFiscal ");
                buf.append("\t   ,a.nfi_csllpercentual\t\tas percentualCsllNotaFiscal ");
                buf.append("\t   ,a.nfi_cofinspercentual\tas percentualCofinsNotaFiscal ");
                buf.append("\t   ,a.nfi_insspercentual\t\tas percentualInssNotaFiscal ");
                buf.append("     ,a.nfi_datahorareimpressao\tas dataHoraReimpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_ipipercentual\t\t\tas percentualIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_ipivalor\t\t\t\t\tas valorIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_icmspercentual\t\tas percentualIcmsNotaFiscal ");
                buf.append("\t   ,a.nfi_icmsvalor\t\t\t\t\tas valorIcmsNotaFiscal ");
                buf.append("\t   ,a.ped_codigo\t\t\t\t\t\tas codigoPedidoNotaFiscal ");
                buf.append("\t   ,a.nfi_dataautorizafinanceira\tas dataAutorizacaoFinanceiraNotaFiscal ");
                buf.append("\t   ,a.nfi_valordesconto\t\t\tas valorDescontoNotaFiscal ");
                buf.append("     ,a.nfi_percentualdesconto\tas percentualDescontoNotaFiscal ");
                buf.append("\t   ,a.nfi_valorfrete\t\t\t\tas valorFreteNotaFiscal ");
                buf.append("\t   ,a.nfi_nomepagador\t\t\t\t\tas nomePagador ");
                buf.append("\t   ,cfo.cfo_codigo\t\t\t\t\tas codigoCfop ");
                buf.append("\t   ,cfo.cfo_motivo\t\t\t\t\tas motivoCfop ");
                if (this.tipoNotaFiscalRelatorio == 2) {
                    buf.append("\t ,nfm.mat_codigo\t\t\t\t\tas codigoMaterial ");
                    buf.append("\t ,mat.mat_descricao\t\t\t\tas descricaoMaterial ");
                    buf.append("   ,nfm_quantidade          as quantidadeMaterial ");
                    buf.append("   ,nfm_valorunitario       as valorUnitarioMaterial ");
                    buf.append("   ,nfm_valoripi            as valorIpiMaterial ");
                    buf.append("   ,nfm_percentualipi        as percentualIpiMaterial ");
                    buf.append("   ,nfm_valoricms            as valorIcmsMaterial ");
                    buf.append("   ,nfm_percentualicms       as percentualIcmsMaterial ");
                    buf.append("   ,nfm_valortotal           as valorTotalMaterial");
                    buf.append("   ,nfm_valordesconto        as valorDescontoMaterial ");
                    buf.append("   ,nfm_percentualdesconto   as percentualDescontoMaterial ");
                    buf.append("   ,un.unm_codigo   as codigoUnidadeMedida ");
                    buf.append("   ,un.unm_descricao   as descricaoUnidadeMedida ");
                }
                buf.append("     ,nfi_irrfvalor as irrfValorNotaFiscal ");
                buf.append("     ,nfi_issvalor as issValorNotaFiscal ");
                buf.append("     ,nfi_pisvalor as pisValorNotaFiscal ");
                buf.append("     ,nfi_csllvalor as csllValorNotaFiscal ");
                buf.append("     ,nfi_cofinsvalor as cofinsValorNotaFiscal ");
                buf.append("     ,nfi_inssvalor as inssValorNotaFiscal ");
                buf.append("     ,nfi_irrfvalor + nfi_issvalor + nfi_pisvalor + nfi_csllvalor + nfi_cofinsvalor + nfi_inssvalor as acumuladoImpostosNotaFiscal ");
                buf.append("     ,case ");
                buf.append("          when a.nfi_tipocadastro = '").append("O").append("' then a.con_codigo ");
                buf.append("  \t\t\t\twhen a.nfi_tipocadastro = '").append("P").append("' then a.pac_codigo ");
                buf.append("  \t\t\t\twhen a.nfi_tipocadastro = '").append("U").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\twhen a.nfi_tipocadastro = '").append("F").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\twhen a.nfi_tipocadastro = '").append("C").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\twhen a.nfi_tipocadastro = '").append("R").append("' then a.ent_codigo ");
                buf.append("  \t\t\t\telse a.ent_codigo ");
                buf.append("\t\t end as codigoCadastro ");
                buf.append("     ,case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("  \t\t\t\twhen a.ent_codigo is not null then ent.ent_fantasia ");
                buf.append("  \t\t\t\telse con.con_fantasia ");
                buf.append("\t\t end as fantasiaCadastro ");
                buf.append("     ,case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append("  \t\t\t\telse '' ");
                buf.append("\t\t end as nomeSocialPaciente ");
                buf.append("     ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_razaosocial ");
                buf.append("  \t\t\t\t\telse con.con_razao ");
                buf.append("\t\t end as razaoSocialCadastro ");
                buf.append("     ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fone ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fone ");
                buf.append("  \t\t\t\t\telse con.con_fone ");
                buf.append("\t\t\t end as foneCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_endereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_endereco ");
                buf.append("  \t\t\t\t\telse con.con_endereco ");
                buf.append("\t\t\t end as enderecoCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_numeroendereco ");
                buf.append("  \t\t\t\t\telse con.con_numeroendereco ");
                buf.append("\t\t\t end as numeroEnderecoCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_tipologradouroendereco ");
                buf.append("  \t\t\t\t\telse con.con_tipologradouroendereco ");
                buf.append("\t\t\t end as tipoLogradouroCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fax ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fax ");
                buf.append("  \t\t\t\t\telse con.con_fax ");
                buf.append("\t\t\t end as faxCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then coalesce(pac.pac_cnpj, pac.pac_cpf) ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cpfcnpj ");
                buf.append("  \t\t\t\t\telse con.con_cnpjcpf ");
                buf.append("\t\t\t end as cnpjCpfCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then coalesce(pac.pac_ie, pac.pac_rg) ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_rgie ");
                buf.append("  \t\t\t\t\telse con.con_inscrest ");
                buf.append("\t\t\t end as ieRgCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_complemento ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_complemento ");
                buf.append("  \t\t\t\t\telse con.con_complemento ");
                buf.append("\t\t\t end as complementoCadastro ");
                buf.append("       ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_cep ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cep ");
                buf.append("  \t\t\t\t\telse con.con_cep ");
                buf.append("\t\t\t end as cepCadastro, ");
                buf.append("       a.nfi_datahoracancelada as dataCancelamentoNotaFiscal, ");
                buf.append("       usrcancelamento.usr_codigo as usuarioCancelamentoNotaFiscal, ");
                buf.append("       usrcancelamento.usr_nome as nomeUsuarioCancelamentoNotaFiscal, ");
                buf.append("       usrimpressao.usr_codigo as usuarioImpressaoNotaFiscal, ");
                buf.append("       usrimpressao.usr_nome as nomeUsuarioImpressaoNotaFiscal, ");
                buf.append("       null as datasVencimentoNotaFiscal ");
                buf.append("       ,case");
                buf.append("\t\t\t \t\twhen (a.nfi_situacao = 'A' or a.nfi_situacao = 'C' or a.nfi_situacao = 'E') and a.nfi_chavenfse is not null then true");
                buf.append("\t\t\t \t\twhen (a.nfi_situacao = 'A' or a.nfi_situacao = 'C' or a.nfi_situacao = 'E') and a.nfi_chavenfse is  null then false");
                buf.append("\t\t\t\t\twhen  a.nfi_situacao = 'I' then false");
                buf.append("\t\t\t \t\telse true");
                buf.append("\t\t\tend as isEletronica, ");
                buf.append("       a.nfi_numerorps as numeroRps, ");
                buf.append("       a.nfi_notaenviada as isNotaEnviada, ");
                buf.append("       a.nfi_percdescontocondicionado as percentualDescontoCondicional, ");
                buf.append("       a.nfi_statusnfse as statusNfse, ");
                buf.append("       a.nfi_motivonfse as motivoNfse, ");
                buf.append("       a.nfi_datastatusnfse as dataStatusNfse, ");
                buf.append("       a.nfi_protocolonfse as protocoloNfse, ");
                buf.append("       a.nfi_chaverpsnfse as chaveRpsNfse, ");
                buf.append("       a.nfi_chavenfse as chaveNfse, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from notafiscal a ");
                buf.append("  left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("  left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
                buf.append("  left join formapagto fpg on a.fpg_codigo = fpg.fpg_codigo and a.fil_codigo = fpg.fil_codigo ");
                buf.append("  left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("  left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("  left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
                buf.append("  left join usuario usrcancelamento on a.usr_codcancelada = usrcancelamento.usr_codigo ");
                buf.append("  left join usuario usrimpressao on a.usr_codimpressao = usrimpressao.usr_codigo ");
                buf.append("  left join motivoscancelamentos mov on a.fil_codigo = mov.fil_codigo and a.mov_codigo = mov.mov_codigo ");
                buf.append("  left join cfop cfo on (a.fil_codigo = cfo.fil_codigo and a.cfo_codigo = cfo.cfo_codigo) ");
                if (this.tipoNotaFiscalRelatorio == 2) {
                    buf.append("  left join notafiscalmaterial nfm on a.fil_codigo = nfm.fil_codigo and a.nfi_codigo = nfm.nfi_codigo ");
                    buf.append("  left join  material mat on nfm.fil_codigo = mat.fil_codigo AND nfm.mat_codigo = mat.mat_codigo ");
                    buf.append("  left join  unidademedida un on mat.fil_codigo = un.fil_codigo and mat.unm_codigo = un.unm_codigo ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (this.getSelecionadosFiltro("filtroConvenio", 0) != null || this.getSelecionadosFiltro("filtroEntidade", 0) != null || this.getSelecionadosFiltroAvancado("filtroPaciente", 0) != null) {
                    buf.append(" and ( ");
                }
                StringBuilder aux = new StringBuilder();
                String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                if (convenio != null) {
                    aux.append(" a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        aux.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        aux.append(", ");
                    }
                    aux.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    if (aux.length() > 0) {
                        aux.append(" or ");
                    }
                    aux.append(" a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        aux.append("'");
                        aux.append(entidade[i]);
                        aux.append("'");
                        if (i >= entidade.length - 1) continue;
                        aux.append(", ");
                    }
                    aux.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                    if (aux.length() > 0) {
                        aux.append(" or ");
                    }
                    aux.append(" a.pac_codigo in (");
                    for (int i = 0; i < paciente.length; ++i) {
                        aux.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        aux.append(", ");
                    }
                    aux.append(")");
                }
                if (aux.length() > 0) {
                    aux.append(" ) ");
                }
                buf.append(aux.toString());
                String[] serie = this.getSelecionadosFiltro("filtroSerie", 0);
                if (serie != null) {
                    buf.append(" and a.ser_codigo in (");
                    for (int i = 0; i < serie.length; ++i) {
                        buf.append("'");
                        buf.append(serie[i]);
                        buf.append("'");
                        if (i >= serie.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((formapgto = this.getSelecionadosFiltro("filtroFormaPgto", 0)) != null) {
                    buf.append(" and a.fpg_codigo in (");
                    for (int i = 0; i < formapgto.length; ++i) {
                        buf.append("'");
                        buf.append(formapgto[i]);
                        buf.append("'");
                        if (i >= formapgto.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (this.tipoNotaFiscalRelatorio == 1) {
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        buf.append(" and cast(a." + CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) >= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        buf.append(" and cast(a." + CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) <= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                        buf.append("'");
                    }
                } else {
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        buf.append(" and cast(a.nfi_dataemissao as date) >= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        buf.append(" and cast(a.nfi_dataemissao as date) <= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                        buf.append("'");
                    }
                }
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    buf.append(" and a.nfi_numero =").append(this.getFiltroTexto("filtroNumeroDocumento")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" and a.nfi_valortotal >= ").append(this.getFiltroTexto("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" and a.nfi_valortotal <= ").append(this.getFiltroTexto("filtroValorFinal")).append(" ");
                }
                if (!Funcoes.textoVazio((String)this.getFiltroCombo("filtroSituacao"))) {
                    if (!this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[0])) {
                        buf.append(" and a.nfi_situacao = '");
                    }
                    if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[1])) {
                        buf.append("A' and a.nfi_chavenfse IS NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[2])) {
                        buf.append("C' and a.nfi_chavenfse IS NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[3])) {
                        buf.append("I' and a.nfi_chavenfse IS NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[4])) {
                        buf.append("E' and a.nfi_chavenfse IS NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[5])) {
                        buf.append("X' and a.nfi_chavenfse IS NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[6])) {
                        buf.append("A' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[7])) {
                        buf.append("R' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[8])) {
                        buf.append("D' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[9])) {
                        buf.append("C' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[10])) {
                        buf.append("N' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[11])) {
                        buf.append("E' and a.nfi_chavenfse IS NOT NULL ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[12])) {
                        buf.append("O' and a.nfi_chavenfse IS NOT NULL ");
                    }
                }
                if (this.tipoNotaFiscalRelatorio == 1) {
                    buf.append(" and a.nfi_tipo in ('").append("S").append("', '").append("F").append("') ");
                } else {
                    buf.append(" and a.nfi_tipo = '").append("E").append("' ");
                }
                if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[1])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("U").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[2])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("F").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[3])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("C").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[4])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("R").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[5])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("P").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[6])) {
                    buf.append(" and a.nfi_tipocadastro = '").append("O").append("' ");
                }
                buf.append(" order by a.fil_codigo ");
                if (this.tipoRelatorio == 1) {
                    buf.append(" , fantasiaCadastro ");
                }
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                    buf.append(", a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    if (this.tipoNotaFiscalRelatorio == 1) {
                        buf.append(", ").append(CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")]);
                    } else {
                        buf.append(" , a.nfi_dataemissao, a.nfi_numero ");
                    }
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append(", valorTotalNotaFiscal, a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                    buf.append(", fantasiaCadastro, a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                    buf.append(", razaoSocialCadastro, a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                    if (this.tipoNotaFiscalRelatorio == 1) {
                        buf.append(", fantasiaCadastro, ").append(CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")]);
                    } else {
                        buf.append(", fantasiaCadastro, a.nfi_dataemissao ");
                    }
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[6])) {
                    if (this.tipoNotaFiscalRelatorio == 1) {
                        buf.append(", razaoSocialCadastro, ").append(CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")]);
                    } else {
                        buf.append(", razaoSocialCadastro, a.nfi_dataemissao ");
                    }
                }
                if (this.tipoNotaFiscalRelatorio == 2) {
                    buf.append(", nfm.nfm_ordem");
                }
                if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.campos);
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[modelo.findColumn((String)this.campos[i])] = this.campos[i].equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i])) : (this.campos[i].equals("tipoCadastroNotaFiscal") ? Tipos.tipoCadastro(rs.getString(this.campos[i])) : (this.campos[i].equals("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getString(this.campos[i]), rs.getBoolean("isEletronica")) : (this.campos[i].equals("datasVencimentoNotaFiscal") ? new NotaFiscalService().pegaVencimentoParcelas(st2, rs.getInt("codigoFilial"), rs.getInt("codigoInternoNotaFiscal")) : rs.getObject(this.campos[i]))));
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioNotaFiscal.getModuloAcesso(this.tipoRelatorio, this.tipoNotaFiscalRelatorio));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioNotaFiscal.this.panelCentro.removeAll();
                                RelatorioNotaFiscal.this.panelCentro.repaint();
                                RelatorioNotaFiscal.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                        var.put("filtroTipoCadastro", this.getFiltroCombo("filtroTipoCadastro"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        buf.delete(0, buf.length());
                        if (formapgto != null) {
                            for (i = 0; i < formapgto.length; ++i) {
                                buf.append(formapgto[i]);
                                if (i >= formapgto.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFormaPgto", buf.toString());
                        buf.delete(0, buf.length());
                        if (serie != null) {
                            for (i = 0; i < serie.length; ++i) {
                                buf.append(serie[i]);
                                if (i >= serie.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSerie", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block107;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio, int tipoNotaFiscalRelatorio) {
        if (tipoRelatorio == 0) {
            if (tipoNotaFiscalRelatorio == 1) {
                return Long.parseLong("0870200100");
            }
            if (tipoNotaFiscalRelatorio == 0) {
                return Long.parseLong("0800900300");
            }
            return Long.parseLong("0800900600");
        }
        if (tipoNotaFiscalRelatorio == 1) {
            return Long.parseLong("0870200200");
        }
        return Long.parseLong("0800900500");
    }

    public static long getModuloConfigurar(int tipoRelatorio, int tipoNotaFiscalRelatorio) {
        if (tipoRelatorio == 0) {
            if (tipoNotaFiscalRelatorio == 1) {
                return Long.parseLong("0870200101");
            }
            if (tipoNotaFiscalRelatorio == 0) {
                return Long.parseLong("0800900301");
            }
            return Long.parseLong("0800900601");
        }
        if (tipoNotaFiscalRelatorio == 1) {
            return Long.parseLong("0870200201");
        }
        return Long.parseLong("0800900501");
    }
}

