/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioContas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] tipo = new String[]{"Todas", "Caixa", "Corrente"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Nome"};
    private final long ACESSO_CONFIGURAR = Long.parseLong("0840100701");
    private final String FILTRO_TIPOCONTA = "filtroTipoConta";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoAgencia", "descricaoAgencia", "codigoBanco", "descricaoBanco", "codigoConta", "numeroConta", "titularConta", "tipoConta", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "inativaConta", "saldoInicialConta", "dataSaldoInicialConta"});

    public RelatorioContas() {
        this.setName("RelatorioContas");
        this.montaBarraDescricao("Relat\u00f3rio de contas corrente", "Listagem das contas corrente cadastradas", "relatorios/rel_contas.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroCombo("filtroTipoConta", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioContas.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select a.cco_reduzido as codigoConta, ");
            buf.append("a.cco_conta as numeroConta, ");
            buf.append("a.cco_titular as titularConta, ");
            buf.append("a.cco_sldinicial as saldoInicialConta, ");
            buf.append("a.cco_dtsldinicial as dataSaldoInicialConta, ");
            buf.append("a.cco_tipo as tipoConta, ");
            buf.append("a.cco_inativa as inativaConta, ");
            buf.append("b.bac_codigo as codigoBanco, ");
            buf.append("b.bac_descricao as descricaoBanco, ");
            buf.append("c.age_codigo as codigoAgencia, ");
            buf.append("c.age_descricao as descricaoAgencia, ");
            buf.append("d.hpa_codigo as codigoHistoricoPadrao, ");
            buf.append("d.hpa_descricao as descricaoHistoricoPadrao, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from contacorrente a ");
            buf.append(" left join banco b on a.fil_codigo = b.fil_codigo and ");
            buf.append(" a.bac_codigo = b.bac_codigo ");
            buf.append(" left join agencia c on a.fil_codigo = c.fil_codigo and ");
            buf.append(" a.age_codigo = c.age_codigo and a.bac_codigo = c.bac_codigo ");
            buf.append(" left join historicopadrao d on a.fil_codigo = d.fil_codigo and ");
            buf.append(" a.hpa_codigo = d.hpa_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            if (!this.getFiltroCombo("filtroTipoConta").equals(this.tipo[0])) {
                buf.append(" and a.cco_tipo = '");
                buf.append(this.getFiltroCombo("filtroTipoConta").equals(this.tipo[1]) ? "X" : "C");
                buf.append("' ");
            }
            buf.append("order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals("Nome")) {
                buf.append("a.cco_conta");
            } else {
                buf.append("a.cco_reduzido");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = campos[i].equals("tipoConta") ? Tipos.tipoContaCorrente(rs.getString(campos[i])) : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioContas.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioContas.this.panelCentro.removeAll();
                            RelatorioContas.this.panelCentro.repaint();
                            RelatorioContas.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroTipoConta", this.getFiltroCombo("filtroTipoConta"));
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0840100700");
    }
}

