/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPedidoCompra
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_PEDIDO_COMPRA = "filtroPedidoCompra";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_FORNECEDOR = "filtroFornecedor";
    private static final String[] camposPedido = new String[]{"codigoPedido", "dataHoraPedido", "observacaoPedido", "codigoUsuarioExclusaoPedido", "dataAutorizacaoPedido", "totalPedido", "valorDescontoPedido", "percentualDescontoPedido", "codigoUsuarioPedido", "codigoUsuarioAutorizacaoPedido", "dataExclusaoPedido", "nomeVendedorPedido", "valorFretePedido", "somatorioTotalPedido"};
    private static final String[] camposPedidoMaterial = new String[]{"quantidadePedidoMaterial", "valorUnitarioPedidoMaterial", "valorDescontoPedidoMaterial", "percentualDescontoPedidoMaterial", "totalPedidoMaterial"};
    private static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial"};
    private static final String[] camposFormaPagto = new String[]{"codigoFormaPagto", "descricaoFormaPagto"};
    private final String[] camposCadastro = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private String[] camposRelatorio = null;
    private Integer codigoPedidoCompra = null;

    public RelatorioPedidoCompra() {
        this.montaBarraDescricao("Relat\u00f3rio de pedido de compra", "Listagem dos pedidos de compra", "relatorios/rel_estoque_pedido_rel_pedido_de_compra.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFornecedor", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "' and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroPedidoCompra", "Pedido Compra", "pedido", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ped_codigo", "ped_datahora", "usr_codigo", "ped_observacao", "ped_total"}, new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio", "Observa\u00e7\u00e3o", "Total"}, new int[]{60, 70, 70, 0, 70});
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 8);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 8);
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.setModuloConfigurar(RelatorioPedidoCompra.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPedidoCompra.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposPedido);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposPedidoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposFormaPagto);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastro);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    public void imprimirPressionado(Integer codigoPedidoCompra) {
        this.codigoPedidoCompra = codigoPedidoCompra;
        this.panelCard.setVisible(false);
        this.buttonConfigurar.setVisible(false);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorioPedidoCompra.this.setVisible(false);
                RelatorioPedidoCompra.this.getParent().getParent().getParent().setVisible(false);
            }
        });
        this.imprimirPressionado();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block31: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] fornecedor;
                String[] pedido;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.ped_codigo as codigoPedido, ");
                buf.append("       a.ped_datahora as dataHoraPedido, ");
                buf.append("       a.ped_observacao as observacaoPedido, ");
                buf.append("       a.usr_codexclusao as codigoUsuarioExclusaoPedido, ");
                buf.append("       a.ped_dataautorizacao as dataAutorizacaoPedido, ");
                buf.append("       a.ped_total as totalPedido, ");
                buf.append("       a.ped_valordesconto as valorDescontoPedido, ");
                buf.append("       a.ped_percentualdesconto as percentualDescontoPedido, ");
                buf.append("       a.usr_codigo as codigoUsuarioPedido, ");
                buf.append("       a.usr_codautorizacao as codigoUsuarioAutorizacaoPedido, ");
                buf.append("       a.ped_dataexclusao as dataExclusaoPedido, ");
                buf.append("       a.ped_nomevendedor as nomeVendedorPedido, ");
                buf.append("       a.ped_valorfrete as valorFretePedido, ");
                buf.append("       a.ent_codigo as codigoFornecedorPedido, ");
                buf.append("       pma.pma_quantidade as quantidadePedidoMaterial, ");
                buf.append("       pma.pma_valorunitario as valorUnitarioPedidoMaterial, ");
                buf.append("       pma.pma_valordesconto as valorDescontoPedidoMaterial, ");
                buf.append("       pma.pma_percentualdesconto as percentualDescontoPedidoMaterial, ");
                buf.append("       pma.pma_total as totalPedidoMaterial, ");
                buf.append("       mat.mat_codigo as codigoMaterial, ");
                buf.append("       mat.mat_descricao as descricaoMaterial, ");
                buf.append("       fpg.fpg_codigo as codigoFormaPagto, ");
                buf.append("       fpg.fpg_descricao as descricaoFormaPagto ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from pedido a ");
                buf.append("  left join pedidomaterial pma on (a.fil_codigo = pma.fil_codigo and a.ped_codigo = pma.ped_codigo) ");
                buf.append("  left join material mat on (pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo)");
                buf.append("  left join formapagto fpg on (a.fil_codigo = fpg.fil_codigo and a.fpg_codigo = fpg.fpg_codigo)");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((pedido = this.getSelecionadosFiltro("filtroPedidoCompra", 0)) != null) {
                    buf.append(" and a.ped_codigo in (");
                    for (int i = 0; i < pedido.length; ++i) {
                        buf.append("'");
                        buf.append(pedido[i]);
                        buf.append("'");
                        if (i >= pedido.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((fornecedor = this.getSelecionadosFiltro("filtroFornecedor", 0)) != null) {
                    buf.append(" and a.ent_codigo in (");
                    for (int i = 0; i < fornecedor.length; ++i) {
                        buf.append("'");
                        buf.append(fornecedor[i]);
                        buf.append("'");
                        if (i >= fornecedor.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a.ped_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a.ped_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" and a.ped_total >= ").append(this.getFiltroDecimal("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" and a.ped_total <= ").append(this.getFiltroDecimal("filtroValorFinal")).append(" ");
                }
                if (this.codigoPedidoCompra != null) {
                    buf.append(" and a.ped_codigo = ").append(this.codigoPedidoCompra);
                }
                buf.append(" order by a.fil_codigo, a.ped_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    int codigo = -1;
                    Double somatorioTotalPedido = 0.0;
                    do {
                        Object[] o = new Object[this.camposRelatorio.length];
                        for (int i = 0; i < this.camposRelatorio.length; ++i) {
                            if (ArraysUtil.contem(this.camposCadastro, this.camposRelatorio[i])) continue;
                            if (this.camposRelatorio[i].equalsIgnoreCase("totalPedido") && codigo != rs.getInt("codigoPedido")) {
                                somatorioTotalPedido = somatorioTotalPedido + rs.getDouble(this.camposRelatorio[i]);
                                codigo = rs.getInt("codigoPedido");
                            }
                            if (this.camposRelatorio[i].equalsIgnoreCase("somatorioTotalPedido")) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                        }
                        this.pegaDadosCadastro(st2, o, modelo, rs.getInt("codigoFilial"), rs.getInt("codigoFornecedorPedido"));
                        o[modelo.findColumn((String)"somatorioTotalPedido")] = somatorioTotalPedido;
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioPedidoCompra.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioPedidoCompra.this.panelCentro.removeAll();
                                RelatorioPedidoCompra.this.panelCentro.repaint();
                                RelatorioPedidoCompra.this.habilitaBotaoImprimir(true);
                                if (RelatorioPedidoCompra.this.codigoPedidoCompra != null) {
                                    RelatorioPedidoCompra.this.getParent().getParent().getParent().setVisible(false);
                                }
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroValorInicial", this.getFiltroData("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroData("filtroValorFinal"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (pedido != null) {
                            for (i = 0; i < pedido.length; ++i) {
                                buf.append(pedido[i]);
                                if (i >= pedido.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroPedidoCompra", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (fornecedor != null) {
                            for (i = 0; i < fornecedor.length; ++i) {
                                buf.append(fornecedor[i]);
                                if (i >= fornecedor.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFornecedor", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block31;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("ent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
        buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
        buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro, ent.ent_cpfcnpj as cnpjCpfCadastro, ent.ent_rgie as ieRgCadastro ");
        buf.append("from entidade ent ");
        buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
        buf.append("where ent.fil_codigo = ").append(filial);
        buf.append(" and ent.ent_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        int pos = -1;
        if (rs.next()) {
            for (String s : this.camposCadastro) {
                if (rs.findColumn(s) <= 0 || (pos = modelo.findColumn(s)) <= -1) continue;
                array[pos] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800900101");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800900100");
    }
}

