/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioEntradaMaterialFornecedor
extends FrmRelPadrao {
    private String[] ordem = new String[]{"Nota Fiscal", "Data", "Fantasia", "Raz\u00e3o Social", "Valor Total", "Fant. + Data", "Raz. Social + Data"};
    private final String[] tipoSituacao = new String[]{"Todas", Tipos.tipoSituacaoNotaFiscal("A", false), Tipos.tipoSituacaoNotaFiscal("C", false), Tipos.tipoSituacaoNotaFiscal("I", false), Tipos.tipoSituacaoNotaFiscal("E", false), Tipos.tipoSituacaoNotaFiscal("X", true), Tipos.tipoSituacaoNotaFiscal("A", true), Tipos.tipoSituacaoNotaFiscal("R", true), Tipos.tipoSituacaoNotaFiscal("D", true), Tipos.tipoSituacaoNotaFiscal("C", true), Tipos.tipoSituacaoNotaFiscal("N", true), Tipos.tipoSituacaoNotaFiscal("E", true), Tipos.tipoSituacaoNotaFiscal("O", true)};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_SERIE = "filtroSerie";
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_NUMERO_NOTA_FISCAL = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_FORMA_PGTO = "filtroFormaPgto";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private final int TIPO_NOTA_FISCAL_ENTRADA = 0;
    private final String[] camposCadastros = new String[]{"codigoFornecedor", "fantasiaFornecedor", "razaoSocialFornecedor", "foneFornecedor", "enderecoFornecedor", "faxFornecedor", "complementoFornecedor", "cepFornecedor", "cnpjCpfFornecedor", "ieRgFornecedor", "numeroEnderecoFornecedor", "tipoLogradouroFornecedor"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "usuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "codigoInternoNotaFiscal", "dataHoraImpressaoNotaFiscal", "situacaoNotaFiscal", "codigoFormaPgto", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subtotalNotaFiscal", "baseCalculoImpostosNotaFiscal", "descricaoFormaPgto", "acumuladoImpostosNotaFiscal", "dataCancelamentoNotaFiscal", "usuarioCancelamentoNotaFiscal", "nomeUsuarioCancelamentoNotaFiscal", "usuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "descricaoMotivoCancelamento", "codigoMotivoCancelamento", "descricaoCancelamentoUsuario", "datasVencimentoNotaFiscal", "codigoUsuarioAutorizacaoFinanceiraNotaFiscal", "codigoUsuarioReimpressaoNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "codigoUsuarioCanceladaNotaFiscal", "tipoNotaFiscal", "percentualIrrfNotaFiscal", "percentualIssNotaFiscal", "percentualPisNotaFiscal", "percentualCsllNotaFiscal", "percentualCofinsNotaFiscal", "percentualInssNotaFiscal", "dataHoraReimpressaoNotaFiscal", "percentualIpiNotaFiscal", "valorIpiNotaFiscal", "percentualIcmsNotaFiscal", "valorIcmsNotaFiscal", "codigoPedidoNotaFiscal", "dataAutorizacaoFinanceiraNotaFiscal", "valorDescontoNotaFiscal", "percentualDescontoNotaFiscal", "valorFreteNotaFiscal", "codigoCfop", "motivoCfop", "isEletronica", "codigoMaterial", "descricaoMaterial", "materialInativo", "valorUnitarioMaterial", "quantidadeMaterial", "valorTotalMaterial", "descricaoTipoMaterial"});
    private final String[] campos = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastros);

    public RelatorioEntradaMaterialFornecedor() {
        this.montaBarraDescricao("Relat\u00f3rio de entrada de material por fornecedor", "Listagem das notas fiscais de entrada por fornecedor", "relatorios/rel_estoque_pedido_material_fornecedor.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " AND ent_tipo = '" + "F" + "'  AND ent_inativo = false", 1, new String[]{"ent_codigo", "ent_fantasia", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro("filtroSerie", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFormaPgto", "Forma Pagto.", "formapagto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"fpg_codigo", "fpg_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTipoMaterial", "Tipo de material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Nota:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.tipoSituacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroMaterialInativo", "Mostrar material inativo", false);
        this.setModuloConfigurar(RelatorioEntradaMaterialFornecedor.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEntradaMaterialFornecedor.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block79: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] tipoMaterial;
                String[] formapgto;
                StringBuilder buf = new StringBuilder();
                buf.append(" SELECT a.ser_codigo \t\t\t\tAS serieNotaFiscal ");
                buf.append("\t   ,a.nfi_numero \t\t\t\t\tAS numeroNotaFiscal ");
                buf.append("\t   ,a.nfi_tipocadastro \t\tAS tipoCadastroNotaFiscal ");
                buf.append("\t   ,a.usr_codigo \t\t\t\t\tAS usuarioNotaFiscal ");
                buf.append("\t   ,a.nfi_datahora \t\t\t\tAS dataHoraNotaFiscal ");
                buf.append("\t   ,a.nfi_dataemissao \t\tAS dataEmissaoNotaFiscal ");
                buf.append("\t   ,a.nfi_datahoraimpressao\tAS dataHoraImpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_situacao \t\t\t\t\tAS situacaoNotaFiscal ");
                buf.append("     ,a.nfi_codigo            AS codigoInternoNotaFiscal ");
                buf.append("\t   ,a.fpg_codigo \t\t\t\t\t\tAS codigoFormaPgto ");
                buf.append("     ,fpg.fpg_descricao       AS descricaoFormaPgto");
                buf.append("\t   ,a.nfi_observacao \t\t\t\tAS observacaoNotaFiscal ");
                buf.append("\t   ,a.nfi_subtotal    \t\t\tAS subtotalNotaFiscal ");
                buf.append("\t   ,a.nfi_valortotal \t\t\t\tAS valorTotalNotaFiscal ");
                buf.append("\t   ,a.nfi_impostoacumulado  AS baseCalculoImpostosNotaFiscal ");
                buf.append("     ,a.nfi_descricaocancelamento\tAS descricaoCancelamentoUsuario ");
                buf.append("\t   ,a.mov_codigo \t\t\t\t\t\tAS codigoMotivoCancelamento ");
                buf.append("\t   ,mov.mov_descricao  \t\t \tAS descricaoMotivoCancelamento ");
                buf.append("\t   ,a.usr_codautorizafinanceira AS codigoUsuarioAutorizacaoFinanceiraNotaFiscal ");
                buf.append("     ,a.usr_codreimpressao\t\tAS codigoUsuarioReimpressaoNotaFiscal ");
                buf.append("     ,a.usr_codimpressao\t\t\tAS codigoUsuarioImpressaoNotaFiscal ");
                buf.append("     ,a.usr_codcancelada\t\t\tAS codigoUsuarioCanceladaNotaFiscal ");
                buf.append("\t   ,a.nfi_tipo\t\t\t\t\t\t\tAS tipoNotaFiscal ");
                buf.append("     ,a.nfi_irrfpercentual\t\tAS percentualIrrfNotaFiscal ");
                buf.append("     ,a.nfi_isspercentual\t\t\tAS percentualIssNotaFiscal ");
                buf.append("     ,a.nfi_pispercentual\t\t\tAS percentualPisNotaFiscal ");
                buf.append("\t   ,a.nfi_csllpercentual\t\tAS percentualCsllNotaFiscal ");
                buf.append("\t   ,a.nfi_cofinspercentual\tAS percentualCofinsNotaFiscal ");
                buf.append("\t   ,a.nfi_insspercentual\t\tAS percentualInssNotaFiscal ");
                buf.append("     ,a.nfi_datahorareimpressao\tAS dataHoraReimpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_ipipercentual\t\t\tAS percentualIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_ipivalor\t\t\t\t\tAS valorIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_icmspercentual\t\tAS percentualIcmsNotaFiscal ");
                buf.append("\t   ,a.nfi_icmsvalor\t\t\t\t\tAS valorIcmsNotaFiscal ");
                buf.append("\t   ,a.ped_codigo\t\t\t\t\t\tAS codigoPedidoNotaFiscal ");
                buf.append("\t   ,a.nfi_dataautorizafinanceira\tAS dataAutorizacaoFinanceiraNotaFiscal ");
                buf.append("\t   ,a.nfi_valordesconto\t\t\tAS valorDescontoNotaFiscal ");
                buf.append("     ,a.nfi_percentualdesconto\tAS percentualDescontoNotaFiscal ");
                buf.append("\t   ,a.nfi_valorfrete\t\t\t\tAS valorFreteNotaFiscal ");
                buf.append("\t   ,cfo.cfo_codigo\t\t\t\t\tAS codigoCfop ");
                buf.append("\t   ,cfo.cfo_motivo\t\t\t\t\tAS motivoCfop ");
                buf.append("     ,nfi_irrfvalor + nfi_issvalor + nfi_pisvalor + nfi_csllvalor + nfi_cofinsvalor + nfi_inssvalor AS acumuladoImpostosNotaFiscal ");
                buf.append("     ,mat.mat_codigo AS codigoMaterial ");
                buf.append("     ,mat.mat_descricao AS descricaoMaterial ");
                buf.append("\t\t ,mat.mat_inativo as materialInativo ");
                buf.append("     ,nfm.nfm_valorunitario AS valorUnitarioMaterial ");
                buf.append("     ,nfm.nfm_quantidade AS quantidadeMaterial ");
                buf.append("     ,nfm.nfm_valortotal AS valorTotalMaterial ");
                buf.append("     ,a.ent_codigo AS codigoFornecedor ");
                buf.append("     ,ent.ent_fantasia AS fantasiaFornecedor ");
                buf.append("     ,ent.ent_razaosocial AS razaoSocialFornecedor ");
                buf.append("     ,ent.ent_fone AS foneFornecedor ");
                buf.append("     ,ent.ent_endereco AS enderecoFornecedor ");
                buf.append("     ,ent.ent_numeroendereco as numeroEnderecoFornecedor ");
                buf.append("     ,ent.ent_tipologradouroendereco as tipoLogradouroFornecedor ");
                buf.append("     ,ent.ent_fax AS faxFornecedor ");
                buf.append("     ,ent.ent_cpfcnpj AS cnpjCpfFornecedor ");
                buf.append("     ,ent.ent_rgie AS ieRgFornecedor ");
                buf.append("     ,ent.ent_complemento AS complementoFornecedor ");
                buf.append("     ,ent.ent_cep AS cepFornecedor ");
                buf.append("     ,a.nfi_datahoracancelada AS dataCancelamentoNotaFiscal ");
                buf.append("     ,usrcancelamento.usr_codigo AS usuarioCancelamentoNotaFiscal ");
                buf.append("     ,usrcancelamento.usr_nome AS nomeUsuarioCancelamentoNotaFiscal ");
                buf.append("     ,usrimpressao.usr_codigo AS usuarioImpressaoNotaFiscal ");
                buf.append("     ,usrimpressao.usr_nome AS nomeUsuarioImpressaoNotaFiscal ");
                buf.append("     ,null AS datasVencimentoNotaFiscal ");
                buf.append("     ,a.nfi_numerorps IS NOT NULL AS isEletronica ");
                buf.append("     ,tm.tpm_descricao AS descricaoTipoMaterial, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  FROM notafiscal a ");
                buf.append("  LEFT JOIN usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("  LEFT JOIN series s on a.fil_codigo = s.fil_codigo AND a.ser_codigo = s.ser_codigo ");
                buf.append("  LEFT JOIN formapagto fpg on a.fpg_codigo = fpg.fpg_codigo AND a.fil_codigo = fpg.fil_codigo ");
                buf.append("  LEFT JOIN entidade ent on a.fil_codigo = ent.fil_codigo AND a.ent_codigo = ent.ent_codigo ");
                buf.append("  LEFT JOIN usuario usrcancelamento on a.usr_codcancelada = usrcancelamento.usr_codigo ");
                buf.append("  LEFT JOIN usuario usrimpressao on a.usr_codimpressao = usrimpressao.usr_codigo ");
                buf.append("  LEFT JOIN motivoscancelamentos mov on a.fil_codigo = mov.fil_codigo AND a.mov_codigo = mov.mov_codigo ");
                buf.append("  LEFT JOIN cfop cfo on (a.fil_codigo = cfo.fil_codigo AND a.cfo_codigo = cfo.cfo_codigo) ");
                buf.append("  LEFT JOIN notafiscalmaterial nfm on nfm.fil_codigo = a.fil_codigo and nfm.nfi_codigo = a.nfi_codigo ");
                buf.append("  LEFT JOIN material mat on mat.fil_codigo = nfm.fil_codigo AND mat.mat_codigo = nfm.mat_codigo ");
                buf.append("\tLEFT JOIN tipomaterial tm on tm.fil_codigo = mat.fil_codigo and tm.tpm_codigo = mat.tpm_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("WHERE a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" AND a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                StringBuilder aux = new StringBuilder();
                String[] entidade = this.getSelecionadosFiltro("filtroEntidade", 0);
                if (entidade != null) {
                    if (aux.length() > 0) {
                        aux.append(" or ");
                    }
                    aux.append(" AND a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        aux.append("'");
                        aux.append(entidade[i]);
                        aux.append("'");
                        if (i >= entidade.length - 1) continue;
                        aux.append(", ");
                    }
                    aux.append(") ");
                }
                buf.append(aux.toString());
                String[] serie = this.getSelecionadosFiltro("filtroSerie", 0);
                if (serie != null) {
                    buf.append(" AND a.ser_codigo in (");
                    for (int i = 0; i < serie.length; ++i) {
                        buf.append("'");
                        buf.append(serie[i]);
                        buf.append("'");
                        if (i >= serie.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if ((formapgto = this.getSelecionadosFiltro("filtroFormaPgto", 0)) != null) {
                    buf.append(" AND a.fpg_codigo in (");
                    for (int i = 0; i < formapgto.length; ++i) {
                        buf.append("'");
                        buf.append(formapgto[i]);
                        buf.append("'");
                        if (i >= formapgto.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" AND cast(a.nfi_dataemissao as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" AND cast(a.nfi_dataemissao as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    buf.append(" AND a.nfi_numero =").append(this.getFiltroTexto("filtroNumeroDocumento")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" AND a.nfi_valortotal >= ").append(this.getFiltroTexto("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" AND a.nfi_valortotal <= ").append(this.getFiltroTexto("filtroValorFinal")).append(" ");
                }
                if (!Funcoes.textoVazio((String)this.getFiltroCombo("filtroSituacao"))) {
                    if (!this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[0])) {
                        buf.append(" AND a.nfi_situacao = '");
                    }
                    if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[1])) {
                        buf.append("A");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[2])) {
                        buf.append("C");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[3])) {
                        buf.append("I");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[4])) {
                        buf.append("E");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[5])) {
                        buf.append("X");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[6])) {
                        buf.append("A");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[7])) {
                        buf.append("R");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[8])) {
                        buf.append("D");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[9])) {
                        buf.append("C");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[10])) {
                        buf.append("N");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[11])) {
                        buf.append("E");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[12])) {
                        buf.append("O");
                    }
                    if (!this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[0])) {
                        buf.append("' ");
                    }
                }
                buf.append(" AND a.nfi_tipo = '").append("E").append("' ");
                if (!this.getFiltroCheck("filtroMaterialInativo")) {
                    buf.append(" AND mat.mat_inativo = false ");
                }
                if ((tipoMaterial = this.getSelecionadosFiltro("filtroTipoMaterial", 0)) != null) {
                    buf.append("   and tm.tpm_codigo in (");
                    for (int i = 0; i < tipoMaterial.length; ++i) {
                        buf.append(tipoMaterial[i]);
                        if (i >= tipoMaterial.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(") ");
                }
                buf.append(" ORDER BY a.fil_codigo ");
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                    buf.append(", codigoFornecedor, a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append(", codigoFornecedor, a.nfi_dataemissao ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append(", fantasiaFornecedor ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                    buf.append(", razaoSocialFornecedor ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                    buf.append(", codigoFornecedor, valorTotalMaterial ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                    buf.append(", fantasiaFornecedor, a.nfi_dataemissao");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[6])) {
                    buf.append(", razaoSocialFornecedor, a.nfi_dataemissao ");
                }
                buf.append(", nfm.nfm_ordem");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.campos);
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[modelo.findColumn((String)this.campos[i])] = this.campos[i].equalsIgnoreCase("tipoLogradouroFornecedor") ? Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i])) : (this.campos[i].equals("tipoCadastroNotaFiscal") ? Tipos.tipoCadastro(rs.getString(this.campos[i])) : (this.campos[i].equals("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getString(this.campos[i]), rs.getBoolean("isEletronica")) : (this.campos[i].equals("datasVencimentoNotaFiscal") ? new NotaFiscalService().pegaVencimentoParcelas(st2, rs.getInt("codigoFilial"), rs.getInt("codigoInternoNotaFiscal")) : (this.campos[i].equalsIgnoreCase("materialInativo") ? (rs.getBoolean(this.campos[i]) ? "Sim" : "N\u00e3o") : rs.getObject(this.campos[i])))));
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioEntradaMaterialFornecedor.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioEntradaMaterialFornecedor.this.panelCentro.removeAll();
                                RelatorioEntradaMaterialFornecedor.this.panelCentro.repaint();
                                RelatorioEntradaMaterialFornecedor.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (formapgto != null) {
                            for (i = 0; i < formapgto.length; ++i) {
                                buf.append(formapgto[i]);
                                if (i >= formapgto.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFormaPgto", buf.toString());
                        buf.delete(0, buf.length());
                        if (serie != null) {
                            for (i = 0; i < serie.length; ++i) {
                                buf.append(serie[i]);
                                if (i >= serie.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSerie", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (tipoMaterial != null) {
                            for (i = 0; i < tipoMaterial.length; ++i) {
                                buf.append(tipoMaterial[i]);
                                if (i >= tipoMaterial.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroTipoMaterial", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block79;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800900700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800900701");
    }
}

