/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.TableModel;

public class RelatorioEntradaMaterialAnualDetalhado
extends FrmRelPadrao {
    private static final int COLUNA_FILTRO = 0;
    private static final String NOTA_ENTRADA = "E";
    private static final int POSICAO_INICIAL_CONTEUDO_SQL = 0;
    private static final String FILTRO_INATIVO = "filtroInativo";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private final String FILTRO_FORNECEDOR = "filtroFornecedor";
    private final String FILTRO_ANO = "filtroData";
    private final String FILTRO_POR_MOVIMENTO = "filtroPorMovimento";
    private final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "quantidadeJaneiro", "valorUnitarioJaneiro", "entidadeJaneiro", "quantidadeFevereiro", "valorUnitarioFevereiro", "entidadeFevereiro", "quantidadeMarco", "valorUnitarioMarco", "entidadeMarco", "quantidadeAbril", "valorUnitarioAbril", "entidadeAbril", "quantidadeMaio", "valorUnitarioMaio", "entidadeMaio", "quantidadeJunho", "valorUnitarioJunho", "entidadeJunho", "quantidadeJulho", "valorUnitarioJulho", "entidadeJulho", "quantidadeAgosto", "valorUnitarioAgosto", "entidadeAgosto", "quantidadeSetembro", "valorUnitarioSetembro", "entidadeSetembro", "quantidadeOutubro", "valorUnitarioOutubro", "entidadeOutubro", "quantidadeNovembro", "valorUnitarioNovembro", "entidadeNovembro", "quantidadeDezembro", "valorUnitarioDezembro", "entidadeDezembro"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.camposMaterial);

    public RelatorioEntradaMaterialAnualDetalhado() {
        this.montaBarraDescricao("Relat\u00f3rio de entrada de material anual", "Relat\u00f3rio de entrada de material anual", "relatorios/rel_estoque_pedido_entrada_anual.jpg");
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFornecedor", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " AND ent_tipo = '" + "F" + "'  AND ent_inativo = false", 1, new String[]{"ent_codigo", "ent_fantasia", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroNumero("filtroData", "Ano:", 4);
        this.adicionaFiltroCheck(FILTRO_INATIVO, "Mostrar inativos", false);
        this.adicionaFiltroCheck("filtroPorMovimento", "Somente com movimento", false);
        this.adicionaRelatorioListener(this);
        this.setModuloConfigurar(RelatorioEntradaMaterialAnualDetalhado.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEntradaMaterialAnualDetalhado.getModuloAcesso());
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        if (this.validarCampo()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement statement = Conexao.getStatement();
            ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
            StringBuffer sql = new StringBuffer();
            ResultSet resultSetRelatorio = null;
            try {
                sql.append(" select Array_to_string(Array_agg(ent.ent_codigo) , null) as entidade, ");
                sql.append(" mat.mat_codigo as codigoMaterial, upper(mat.mat_descricao) as descricaoMaterial, ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 1 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeJaneiro,            ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 1 THEN nfm.nfm_valorunitario ELSE null                               ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 1 THEN   (ent.ent_codigo)                           ");
                sql.append("     ELSE null END) AS valorUnitarioJaneiro,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 1 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeJaneiro,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 2 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeFevereiro,          ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 2 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 2 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioFevereiro,                                                                                   ");
                sql.append(" array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 2 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeFevereiro, ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 3 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeMarco,              ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 3 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 3 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioMarco,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 3 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeMarco,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 4 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeAbril,              ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 4 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 4 THEN   (ent.ent_codigo)                           ");
                sql.append("     ELSE null END) AS valorUnitarioAbril,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 4 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeAbril,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 5 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeMaio,               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 5 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 5 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioMaio,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 5 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeMaio,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 6 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeJunho,              ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 6 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 6 THEN   (ent.ent_codigo)                          ");
                sql.append("     ELSE null END) AS valorUnitarioJunho,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 6 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeJunho,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 7 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeJulho,              ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 7 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 7 THEN   (ent.ent_codigo)                          ");
                sql.append("     ELSE null END) AS valorUnitarioJulho,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 7 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeJulho, ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 8 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeAgosto,             ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 8 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 8 THEN   (ent.ent_codigo)                           ");
                sql.append("     ELSE null END) AS valorUnitarioAgosto,                                                                                   ");
                sql.append(" array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 8 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeAgosto,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 9 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeSetembro,           ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 9 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 9 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioSetembro,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 9 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeSetembro,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 10 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeOutubro,           ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 10 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 10 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioOutubro,                                                                                   ");
                sql.append(" array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 10 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeOutubro, ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 11 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeNovembro,          ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 11 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 11 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioNovembro,                                                                                   ");
                sql.append("  array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 11 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeNovembro,  ");
                sql.append("                                                                                                                               ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 12 THEN nfm.nfm_quantidade ELSE 0 END) AS quantidadeDezembro,          ");
                sql.append("  Sum(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 12 THEN nfm.nfm_valorunitario ELSE null                                ");
                sql.append("  \t END) /  Count(CASE WHEN Extract(month FROM a.nfi_dataemissao) = 12 THEN   (ent.ent_codigo)                            ");
                sql.append("     ELSE null END) AS valorUnitarioDezembro,                                                                                   ");
                sql.append(" array_to_string(array_agg((CASE WHEN Extract(month FROM a.nfi_dataemissao) = 12 THEN (ent.ent_codigo) ELSE null END)), '- ') as entidadeDezembro, ");
                sql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                sql.append(" from notafiscal a ");
                sql.append("  left join entidade ent on ent.fil_codigo = a.fil_codigo and ent.ent_codigo = a.ent_codigo ");
                sql.append("  left join notafiscalmaterial nfm on nfm.fil_codigo = a.fil_codigo and nfm.nfi_codigo = a.nfi_codigo ");
                sql.append("  left join material mat on mat.fil_codigo = nfm.fil_codigo and mat.mat_codigo = nfm.mat_codigo ");
                sql.append("  left join tipomaterial tm on tm.fil_codigo = mat.fil_codigo and tm.tpm_codigo = mat.tpm_codigo ");
                sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                sql.append(" where extract(YEAR from a.nfi_dataemissao) = '").append(this.anoInformado()).append("'");
                sql.append("   and upper(nfi_tipo) = upper('").append(NOTA_ENTRADA).append("') ").append(" and a.fil_codigo ");
                this.addFiltroFilial(sql);
                if (this.getSelecionadosFiltro("filtroFornecedor", 0) != null) {
                    sql.append("   and a.ent_codigo ");
                    this.addFiltroSelecionado(sql, "filtroFornecedor");
                }
                if (this.getSelecionadosFiltro("filtroMaterial", 0) != null) {
                    sql.append("   and mat.mat_codigo ");
                    this.addFiltroSelecionado(sql, "filtroMaterial");
                }
                if (this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0) != null) {
                    sql.append("   and tm.tpm_codigo ");
                    this.addFiltroSelecionado(sql, FILTRO_TIPO_MATERIAL);
                }
                if (this.produtoMovimentado()) {
                    sql.append(" and (select count(1) from lanctoestoque lce where lce.fil_codigo = a.fil_codigo and ");
                    sql.append(" lce.mat_codigo = mat.mat_codigo and Extract(year FROM lce.lce_datahora) = '").append(this.anoInformado()).append("') > 0");
                }
                if (!this.mostraInativos()) {
                    sql.append(" and mat.mat_inativo = false ");
                }
                sql.append(" group by mat.mat_codigo, mat.mat_descricao ").append(", ").append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                sql.append(" order by mat.mat_codigo ");
                resultSetRelatorio = Conexao.executeQuery(statement, sql.toString());
                if (resultSetRelatorio.next()) {
                    do {
                        Object[] objectsResult = new Object[this.camposRelatorio.length];
                        for (int i = 0; i < this.camposRelatorio.length; ++i) {
                            objectsResult[i] = this.camposRelatorio[i].trim().contains("entidade") ? this.getListaCodigoFornecedor(resultSetRelatorio.getObject(this.camposRelatorio[i])) : resultSetRelatorio.getObject(this.camposRelatorio[i]);
                        }
                        modelo.addLine(objectsResult);
                    } while (resultSetRelatorio.next());
                }
                StringBuffer relatorio = new StringBuffer();
                relatorio.append("select rel_xml from relatoriosistema where rel_codigo = ");
                relatorio.append(RelatorioEntradaMaterialAnualDetalhado.getModuloAcesso());
                ResultSet resultSetLayout = Conexao.executeQuery(statement, relatorio.toString());
                if (modelo.getRowCount() > 0) {
                    if (resultSetLayout.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioEntradaMaterialAnualDetalhado.this.panelCentro.removeAll();
                                RelatorioEntradaMaterialAnualDetalhado.this.panelCentro.repaint();
                                RelatorioEntradaMaterialAnualDetalhado.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroFilial", this.getSelecionadosFiltro("filtroFilial", 0) != null ? this.getSelecionadosFiltro("filtroFilial", 0) : Variaveis.filialPadrao);
                        var.put("filtroFornecedor", this.getSelecionadosFiltro("filtroFornecedor", 0));
                        var.put("filtroMaterial", this.getSelecionadosFiltro("filtroMaterial", 0));
                        var.put(FILTRO_TIPO_MATERIAL, this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0));
                        var.put("filtroData", this.anoInformado());
                        var.put(FILTRO_INATIVO, this.getFiltroCheck(FILTRO_INATIVO) ? "Sim" : "N\u00e3o");
                        var.put("filtroPorMovimento", this.getFiltroCheck("filtroPorMovimento") ? "Sim" : "N\u00e3o");
                        gerador.executar(resultSetLayout.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                        resultSetLayout.close();
                        resultSetRelatorio.close();
                    } else {
                        Funcoes.mensagem(this, "O layout do relat\u00f3rio n\u00e3o foi encontrado.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.requisitaFocoComponente("filtroData");
                    this.habilitaBotaoImprimir(true);
                }
                sql.delete(0, sql.length());
            }
            catch (Exception e) {
                try {
                    Funcoes.mensagem(this, "Relat\u00f3rio de entrada de material anual. " + e, 1);
                    this.habilitaBotaoImprimir(true);
                    sql.delete(0, sql.length());
                }
                catch (Throwable throwable) {
                    sql.delete(0, sql.length());
                    Conexao.fecharStatement(statement);
                    System.gc();
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                System.gc();
                this.setCursor(Cursor.getDefaultCursor());
            }
            Conexao.fecharStatement(statement);
            System.gc();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Object getListaCodigoFornecedor(Object fornecedor) {
        String[] vetorFornecedor;
        HashSet<String> lista = new HashSet<String>();
        if (fornecedor != null && !fornecedor.toString().trim().isEmpty() && (vetorFornecedor = fornecedor.toString().trim().split("- ")).length > 0) {
            for (String fornCod : vetorFornecedor) {
                lista.add(fornCod);
            }
        }
        return ((Object)lista).toString().replace("[", "").replace("]", "");
    }

    private void addFiltroFilial(StringBuffer sql) {
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        StringBuilder bufFilial = new StringBuilder();
        if (this.nenhumaFilialInformada(filiais)) {
            bufFilial.append(" = ").append(Variaveis.filialPadrao);
        } else {
            bufFilial.append(" in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufFilial.append(filiais[i]);
                if (!this.quantidadeMenorQueTotal(filiais, i)) continue;
                bufFilial.append(", ");
            }
            bufFilial.append(")");
        }
        sql.append(bufFilial.toString());
    }

    private boolean nenhumaFilialInformada(String[] filiais) {
        return filiais == null || filiais.length == 0;
    }

    private void addFiltroSelecionado(StringBuffer sql, String filtro) {
        String[] selecionados = this.getSelecionadosFiltro(filtro, 0);
        StringBuffer bufSelecionado = new StringBuffer();
        if (selecionados != null) {
            bufSelecionado.append(" in (");
            for (int i = 0; i < selecionados.length; ++i) {
                bufSelecionado.append("'");
                bufSelecionado.append(selecionados[i]);
                bufSelecionado.append("'");
                if (!this.quantidadeMenorQueTotal(selecionados, i)) continue;
                bufSelecionado.append(", ");
            }
            bufSelecionado.append(")");
        }
        sql.append(bufSelecionado.toString());
    }

    private boolean quantidadeMenorQueTotal(String[] selecionados, int i) {
        return i < selecionados.length - 1;
    }

    private void apagarSplash(SplashMensagem splashMensagem) {
        if (splashMensagem != null) {
            splashMensagem.apagar();
        }
    }

    private boolean validarCampo() {
        Integer ano;
        if (Funcoes.textoVazio(this.anoInformado())) {
            Funcoes.mensagem(this, "O ano deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            this.requisitaFocoComponente("filtroData");
            return false;
        }
        if (!Funcoes.textoVazio(this.anoInformado()) && (ano = Integer.valueOf(Integer.parseInt(this.getFiltroTexto("filtroData")))) < 1900) {
            Funcoes.mensagem(this, "Ano inv\u00e1lido.", 2);
            this.habilitaBotaoImprimir(true);
            this.requisitaFocoComponente("filtroData");
            return false;
        }
        return true;
    }

    private String anoInformado() {
        return this.getFiltroTexto("filtroData");
    }

    private boolean mostraInativos() {
        return this.getFiltroCheck(FILTRO_INATIVO);
    }

    private boolean produtoMovimentado() {
        return this.getFiltroCheck("filtroPorMovimento");
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800901200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800901201");
    }
}

