/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class RelatorioAutorizacaoFinanceira
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private boolean auxErro = false;
    private static final String FILTRO_NOTA = "filtroNota";
    private static final String[] camposCadastros = new String[]{"tipoLogradouroCadastro", "codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "nomeSocialPaciente", "cnpjCpfCadastro", "ieRgCadastro"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "usuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "codigoInternoNotaFiscal", "isEletronica", "dataHoraImpressaoNotaFiscal", "situacaoNotaFiscal", "codigoFormaPgto", "codigoCadastro", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subtotalNotaFiscal", "baseCalculoImpostosNotaFiscal", "descricaoFormaPgto", "acumuladoImpostosNotaFiscal", "dataCancelamentoNotaFiscal", "usuarioCancelamentoNotaFiscal", "nomeUsuarioCancelamentoNotaFiscal", "dataImpressaoNotaFiscal", "usuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "descricaoMotivoCancelamento", "codigoMotivoCancelamento", "descricaoCancelamentoUsuario", "datasVencimentoNotaFiscal"});
    protected static final String[] campos = ArraysUtil.concatenar(camposRelatorio, camposCadastros);

    public RelatorioAutorizacaoFinanceira() {
        this.montaBarraDescricao("Relat\u00f3rio de autoriza\u00e7\u00e3o financeira", "Impress\u00e3o de autoriza\u00e7\u00e3o financeira", "relatorios/rel_estoque_pedido_rel_autorizacao_financeira.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa(FILTRO_NOTA, "Nota Fiscal:", 5, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalService service = new NotaFiscalService();
                try {
                    Hashtable selecionados = service.pesquisaNotaEntradaVO(RelatorioAutorizacaoFinanceira.this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada");
                    if (selecionados != null && selecionados.size() > 0) {
                        NotaFiscalVO notaVO = (NotaFiscalVO)service.getVO(Variaveis.filialPadrao, selecionados.get("nfi_codigo").toString());
                        if (notaVO == null) {
                            return;
                        }
                        NotaFiscalBean notaBean = (NotaFiscalBean)service.get(Variaveis.filialPadrao, notaVO.getCodigo().toString());
                        if (notaBean != null) {
                            RelatorioAutorizacaoFinanceira.this.setFiltroComPesquisa(RelatorioAutorizacaoFinanceira.FILTRO_NOTA, notaBean.getCodigo().toString());
                        }
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(RelatorioAutorizacaoFinanceira.this, e1.getMessage(), e1.getStackTrace(), "RelatorioAutorizacaoFinanceira:RelatorioAutorizacaoFinanceira");
                }
            }
        }, 1);
        this.setModuloConfigurar(RelatorioAutorizacaoFinanceira.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAutorizacaoFinanceira.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block7: {
            this.auxErro = false;
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, Variaveis.filialPadrao, this.getFiltroComPesquisa(FILTRO_NOTA));
                if (modelo != null && modelo.getRowCount() > 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoFinanceira.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAutorizacaoFinanceira.this.panelCentro.removeAll();
                                RelatorioAutorizacaoFinanceira.this.panelCentro.repaint();
                                RelatorioAutorizacaoFinanceira.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_NOTA, this.getFiltroComPesquisa(FILTRO_NOTA));
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block7;
                }
                if (!this.auxErro) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDialog gerarRelatorio(Object owner, Statement st, Statement st2, String filial, String codigoNota) {
        JDialog dialogo;
        block6: {
            dialogo = null;
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, filial, codigoNota);
                if (modelo != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoFinanceira.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        dialogo = new JDialog(owner instanceof Dialog ? (Dialog)owner : (Frame)owner);
                        final Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(dialogo);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                gerador.getPai().setVisible(false);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_NOTA, codigoNota);
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    }
                    break block6;
                }
                Funcoes.mensagem(owner instanceof Dialog ? (Dialog)owner : (Frame)owner, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(owner instanceof Dialog ? (Dialog)owner : (Frame)owner, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        return dialogo;
    }

    private ModeloGridTable geraModeloDados(Statement st, Statement st2, String filial, String codigoNota) throws SQLException {
        if (Funcoes.textoVazio(codigoNota)) {
            Funcoes.mensagem(this, "Uma Nota Fiscal deve ser selecionada para o relat\u00f3rio.", 2);
            this.habilitaBotaoImprimir(true);
            this.auxErro = true;
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select a.ser_codigo \t\t\t\tas serieNotaFiscal ");
        buf.append("\t  ,a.nfi_numero \t\t\t\t\tas numeroNotaFiscal ");
        buf.append("\t  ,a.nfi_tipocadastro \t\tas tipoCadastroNotaFiscal ");
        buf.append("\t  ,a.usr_codigo \t\t\t\t\tas usuarioNotaFiscal ");
        buf.append("\t  ,a.nfi_datahora \t\t\t\tas dataHoraNotaFiscal ");
        buf.append("\t  ,a.nfi_dataemissao \t\t\tas dataEmissaoNotaFiscal ");
        buf.append("\t  ,a.nfi_datahoraimpressao \tas dataHoraImpressaoNotaFiscal ");
        buf.append("\t  ,a.nfi_situacao \t\t\t\t\tas situacaoNotaFiscal ");
        buf.append("    ,a.nfi_codigo            \tas codigoInternoNotaFiscal ");
        buf.append("\t  ,a.fpg_codigo \t\t\t\t\t\tas codigoFormaPgto ");
        buf.append("    ,fpg.fpg_descricao       \tas descricaoFormaPgto");
        buf.append("\t  ,a.nfi_observacao \t\t\t\tas observacaoNotaFiscal ");
        buf.append("\t  ,a.nfi_subtotal    \t\t \t\tas subtotalNotaFiscal ");
        buf.append("\t  ,a.nfi_valortotal \t\t   \tas valorTotalNotaFiscal ");
        buf.append("\t  ,a.nfi_impostoacumulado  \t   \tas baseCalculoImpostosNotaFiscal ");
        buf.append("\t  ,a.nfi_descricaocancelamento \tas descricaoCancelamentoUsuario ");
        buf.append("\t  ,a.mov_codigo \t\t\t   \tas codigoMotivoCancelamento ");
        buf.append("\t  ,mov.mov_descricao  \t\tas descricaoMotivoCancelamento ");
        buf.append("    ,nfi_irrfvalor + nfi_issvalor + nfi_pisvalor + nfi_csllvalor + nfi_cofinsvalor + nfi_inssvalor as acumuladoImpostosNotaFiscal ");
        buf.append("    ,case when a.nfi_tipocadastro = '").append("O").append("' then a.con_codigo ");
        buf.append("    \t\t\twhen a.nfi_tipocadastro = '").append("P").append("' then a.pac_codigo ");
        buf.append("  \t  \t\twhen a.nfi_tipocadastro = '").append("U").append("' then a.ent_codigo ");
        buf.append("  \t\t  \twhen a.nfi_tipocadastro = '").append("F").append("' then a.ent_codigo ");
        buf.append("    \t\t\twhen a.nfi_tipocadastro = '").append("C").append("' then a.ent_codigo ");
        buf.append("  \t  \t\twhen a.nfi_tipocadastro = '").append("R").append("' then a.ent_codigo ");
        buf.append("  \t\t  \telse a.ent_codigo ");
        buf.append("\t   end as codigoCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_nome ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_fantasia ");
        buf.append("  \t\t  \telse con.con_fantasia ");
        buf.append("\t   end as fantasiaCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_nomesocial ");
        buf.append("  \t\t  \telse con.con_fantasia ");
        buf.append("\t   end as nomeSocialPaciente ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_nome ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_razaosocial ");
        buf.append("  \t\t  \telse con.con_razao ");
        buf.append("\t   end as razaoSocialCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_fone ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_fone ");
        buf.append("  \t\t  \telse con.con_fone ");
        buf.append("\t   end as foneCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_endereco");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_endereco ");
        buf.append("  \t\t  \telse con.con_endereco ");
        buf.append("\t   end as enderecoCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_numeroendereco");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_numeroendereco ");
        buf.append("\t   end as numeroEnderecoCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_tipologradouroendereco");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_tipologradouroendereco ");
        buf.append("\t   end as tipoLogradouroCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_fax ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_fax ");
        buf.append("  \t\t  \telse con.con_fax ");
        buf.append("\t   end as faxCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then coalesce(pac.pac_cnpj, pac.pac_cpf) ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_cpfcnpj ");
        buf.append("  \t\t  \telse con.con_cnpjcpf ");
        buf.append("\t   end as cnpjCpfCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then coalesce(pac.pac_ie, pac.pac_rg) ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_rgie ");
        buf.append("  \t\t  \telse con.con_inscrest ");
        buf.append("\t   end as ieRgCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_complemento ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_complemento ");
        buf.append("  \t\t  \telse con.con_complemento ");
        buf.append("\t   end as complementoCadastro ");
        buf.append("    ,case when a.pac_codigo is not null then pac.pac_cep ");
        buf.append("  \t  \t\twhen a.ent_codigo is not null then ent.ent_cep ");
        buf.append("  \t\t  \telse con.con_cep ");
        buf.append("\t   end as cepCadastro ");
        buf.append("    ,a.nfi_datahoracancelada \t\tas dataCancelamentoNotaFiscal ");
        buf.append("    ,usrcancelamento.usr_codigo as usuarioCancelamentoNotaFiscal ");
        buf.append("\t  ,usrcancelamento.usr_nome \tas nomeUsuarioCancelamentoNotaFiscal ");
        buf.append("    ,a.nfi_datahoraimpressao \t\tas dataImpressaoNotaFiscal ");
        buf.append("\t  ,usrimpressao.usr_codigo \t\tas usuarioImpressaoNotaFiscal ");
        buf.append("    ,usrimpressao.usr_nome \t\t\tas nomeUsuarioImpressaoNotaFiscal ");
        buf.append("    ,null \t\t\t\t\t\t\t\t\t\t\tas datasVencimentoNotaFiscal ");
        buf.append("\t  ,a.nfi_numerorps IS NOT NULL\tas isEletronica, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("  from notafiscal a ");
        buf.append("  left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
        buf.append("  left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
        buf.append("  left join formapagto fpg on a.fpg_codigo = fpg.fpg_codigo and a.fil_codigo = fpg.fil_codigo ");
        buf.append("  left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append("  left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
        buf.append("  left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
        buf.append("  left join usuario usrcancelamento on a.usr_codcancelada = usrcancelamento.usr_codigo ");
        buf.append("  left join usuario usrimpressao on a.usr_codimpressao = usrimpressao.usr_codigo ");
        buf.append("  left join motivoscancelamentos mov on a.fil_codigo = mov.fil_codigo and a.mov_codigo = mov.mov_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and a.nfi_codigo = ").append(codigoNota);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ModeloGridTable modelo = new ModeloGridTable(campos);
        if (rs.next()) {
            do {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    o[modelo.findColumn((String)RelatorioAutorizacaoFinanceira.campos[i])] = campos[i].equals("tipoCadastroNotaFiscal") ? Tipos.tipoCadastro(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(campos[i])) : (campos[i].equals("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getString(campos[i]), rs.getBoolean("isEletronica")) : (campos[i].equals("datasVencimentoNotaFiscal") ? new NotaFiscalService().pegaVencimentoParcelas(st2, rs.getInt("codigoFilial"), rs.getInt("codigoInternoNotaFiscal")) : rs.getObject(campos[i]))));
                }
                modelo.addLine(o);
            } while (rs.next());
        }
        return modelo;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800900400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800900401");
    }
}

