/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.vo.estoque.PedidoVO;
import jalis.relatorio.Gerador;
import jalis.service.estoque.PedidoService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class RelatorioAutorizacaoCompra
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private boolean auxErro = false;
    private static final String FILTRO_PEDIDO = "filtroPedido";
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "cnpjCadastro", "cpfCadastro", "ieCadastro", "rgCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private static final String[] camposPedido = new String[]{"codigoPedido", "dataHoraPedido", "observacaoPedido", "dataAutorizacaoPedido", "totalPedido", "valorDescontoPedido", "percentualDescontoPedido", "codigoUsuarioPedido", "codigoUsuarioExclusaoPedido", "codigoUsuarioAutorizacaoPedido", "nomeUsuarioAutorizacaoPedido", "assinaturaUsuarioAutorizacaoPedido", "codigoEntidadePedido", "dataExclusaoPedido", "nomeVendedorPedido", "valorFretePedido"};
    private static final String[] camposPedidoMaterial = new String[]{"codigoMaterialPedidoMaterial", "quantidadePedidoMaterial", "valorUnitarioPedidoMaterial", "valorDescontoPedidoMaterial", "percentualDescontoPedidoMaterial", "totalPedidoMaterial"};
    private static final String[] camposFormaPagtoPedido = new String[]{"codigoFormaPagamentoPedido", "descricaoFormaPagamentoPedido"};
    private static final String[] camposCotacao = new String[]{"codigoCotacao", "codigoUsuarioCotacao", "dataHoraCotacao", "situacaoCotacao", "dataFechamentoCotacao", "observacaoCotacao", "dataAberturaCotacao"};
    private static final String[] camposCotacaoEntidade = new String[]{"codigoEntidadeCotacaoEntidade", "totalCotacaoEntidade", "percentualDescontoCotacaoEntidade", "valorDescontoCotacaoEntidade", "vendedorCotacaoEntidade", "prazoEntregaCotacaoEntidade", "valorFreteCotacaoEntidade", "validadeCotacaoCotacaoEntidade", "tipoDescontoCotacaoEntidade", "situacaoCotacaoEntidade"};
    private static final String[] camposFormaPagtoCotacaoEntidade = new String[]{"codigoFormaPagamentoCotacaoEntidade", "descricaoFormaPagamentoCotacaoEntidade"};
    private static final String[] camposMaterial = new String[]{"descricaoMaterial"};
    private static final String[] camposParcela = new String[]{"dataParcela0", "valorParcela0", "dataParcela1", "valorParcela1", "dataParcela2", "valorParcela2", "dataParcela3", "valorParcela3", "dataParcela4", "valorParcela4", "dataParcela5", "valorParcela5"};
    private static String[] camposRelatorio = null;
    private static final int QTDE_PARCELAS = 6;

    public RelatorioAutorizacaoCompra() {
        this.montaBarraDescricao("Relat\u00f3rio de autoriza\u00e7\u00e3o de compra", "Impress\u00e3o de autoriza\u00e7\u00e3o de pedido de compra", "relatorios/rel_estoque_pedido_rel_de_autorizacao_compra.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa(FILTRO_PEDIDO, "Pedido:", 7, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String codigoPedido = new PedidoService().pesquisaPedidoAutorizadoVO(Laboratorio.getInstancia(), new PedidoVO());
                    PedidoBean pedido = (PedidoBean)new PedidoService().get(codigoPedido);
                    if (pedido != null) {
                        RelatorioAutorizacaoCompra.this.setFiltroComPesquisa(RelatorioAutorizacaoCompra.FILTRO_PEDIDO, pedido.getCodigo().toString());
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(RelatorioAutorizacaoCompra.this, e1.getMessage(), e1.getStackTrace(), "RelatorioAutorizacaoCompra");
                }
            }
        }, 1);
        try {
            camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposCotacao);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposPedido);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposCotacaoEntidade);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposFormaPagtoCotacaoEntidade);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposFormaPagtoPedido);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposMaterial);
            camposRelatorio = ArraysUtil.concatenar(camposRelatorio, camposPedidoMaterial);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "RelatorioAutorizacaoCompra:RelatorioAutorizacaoCompra");
        }
        this.setModuloConfigurar(RelatorioAutorizacaoCompra.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAutorizacaoCompra.getModuloAcesso());
        this.setCamposConfigurador(ArraysUtil.concatenar(ArraysUtil.concatenar(camposRelatorio, camposCadastros), camposParcela));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block8: {
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            if (this.getFiltroComPesquisa(FILTRO_PEDIDO).isEmpty()) {
                Funcoes.mensagem(this, "Selecione o pedido de compra a ser impresso.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, Variaveis.filialPadrao, this.getFiltroComPesquisa(FILTRO_PEDIDO));
                if (modelo != null && modelo.getRowCount() > 0) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoCompra.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAutorizacaoCompra.this.panelCentro.removeAll();
                                RelatorioAutorizacaoCompra.this.panelCentro.repaint();
                                RelatorioAutorizacaoCompra.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_PEDIDO, this.getFiltroComPesquisa(FILTRO_PEDIDO));
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block8;
                }
                if (!this.auxErro) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDialog gerarRelatorio(Object owner, Statement st, Statement st2, String filial, String codigoPedido) {
        JDialog dialogo;
        block6: {
            dialogo = null;
            try {
                ModeloGridTable modelo = this.geraModeloDados(st, st2, filial, codigoPedido);
                if (modelo != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAutorizacaoCompra.getModuloAcesso());
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        dialogo = new JDialog(owner instanceof Dialog ? (Dialog)owner : (Frame)owner);
                        final Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(dialogo);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                gerador.getPai().setVisible(false);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_PEDIDO, codigoPedido);
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    }
                    break block6;
                }
                Funcoes.mensagem(owner instanceof Dialog ? (Dialog)owner : (Frame)owner, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(owner instanceof Dialog ? (Dialog)owner : (Frame)owner, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        return dialogo;
    }

    private ModeloGridTable geraModeloDados(Statement st, Statement st2, String filial, String codigoPedido) throws SQLException {
        if (Funcoes.textoVazio(codigoPedido)) {
            Funcoes.mensagem(this, "", 2);
            this.habilitaBotaoImprimir(true);
            this.auxErro = true;
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select a.ped_codigo \t\t\t\tas codigoPedido, ");
        buf.append("       a.ped_datahora \t\t\t\tas dataHoraPedido, ");
        buf.append("\t   a.ped_observacao \t\t\tas observacaoPedido, ");
        buf.append("\t   a.ped_dataautorizacao\t\tas dataAutorizacaoPedido, ");
        buf.append("       a.ped_total\t\t\t\t\tas totalPedido, ");
        buf.append("\t   a.ped_valordesconto\t\t\tas valorDescontoPedido, ");
        buf.append("\t   a.ped_percentualdesconto\t\tas percentualDescontoPedido, ");
        buf.append("\t   a.usr_codigo\t\t\t\t\tas codigoUsuarioPedido, ");
        buf.append("\t   a.usr_codexclusao\t\t\tas codigoUsuarioExclusaoPedido, ");
        buf.append("\t   a.usr_codautorizacao\t\t\tas codigoUsuarioAutorizacaoPedido, ");
        buf.append("\t   usrAutoriza.usr_nome\t\t\tas nomeUsuarioAutorizacaoPedido, ");
        buf.append("\t   usrAutoriza.usr_assinatura\tas assinaturaUsuarioAutorizacaoPedido, ");
        buf.append("\t   a.ent_codigo\t\t\t\t\tas codigoEntidadePedido, ");
        buf.append("\t   a.ped_dataexclusao\t\t\tas dataExclusaoPedido, ");
        buf.append("\t   a.ped_nomevendedor\t\t\tas nomeVendedorPedido, ");
        buf.append("\t   a.ped_valorfrete\t\t\t\tas valorFretePedido, ");
        buf.append("\t   pma.mat_codigo\t\t\t\tas codigoMaterialPedidoMaterial, ");
        buf.append("\t   pma.pma_quantidade\t\t\tas quantidadePedidoMaterial, ");
        buf.append("       pma.pma_valorunitario\t\tas valorUnitarioPedidoMaterial, ");
        buf.append("\t   pma.pma_valordesconto\t\tas valorDescontoPedidoMaterial, ");
        buf.append("\t   pma.pma_percentualdesconto\tas percentualDescontoPedidoMaterial, ");
        buf.append("\t   pma.pma_total \t\t\t\tas totalPedidoMaterial, ");
        buf.append("\t   cot.cot_codigo \t\t\t\tas codigoCotacao, ");
        buf.append("       cot.usr_codigo \t\t\t\tas codigoUsuarioCotacao, ");
        buf.append("       cot.cot_datahora \t\t\tas dataHoraCotacao, ");
        buf.append("       cot.cot_situacao \t\t\tas situacaoCotacao, ");
        buf.append("       cot.cot_datafechamento \t\tas dataFechamentoCotacao, ");
        buf.append("       cot.cot_observacao \t\t\tas observacaoCotacao, ");
        buf.append("       cot.cot_dataabertura \t\tas dataAberturaCotacao, ");
        buf.append("       cte.ent_codigo \t\t\t\tas codigoEntidadeCotacaoEntidade, ");
        buf.append("\t   cte.cte_total \t\t\t\tas totalCotacaoEntidade, ");
        buf.append("\t   cte.cte_percentualdesconto \tas percentualDescontoCotacaoEntidade, ");
        buf.append("       cte.cte_valordesconto\t\tas valorDescontoCotacaoEntidade, ");
        buf.append("       cte.cte_vendedor\t\t\t\tas vendedorCotacaoEntidade, ");
        buf.append("\t   cte.cte_prazoentrega\t\t\tas prazoEntregaCotacaoEntidade, ");
        buf.append("\t   cte.cte_valorfrete\t\t\tas valorFreteCotacaoEntidade, ");
        buf.append("\t   cte.cte_validadecotacao \t\tas validadeCotacaoCotacaoEntidade, ");
        buf.append("\t   cte.cte_tipodesconto\t\t\tas tipoDescontoCotacaoEntidade, ");
        buf.append("\t   cte.cte_situacao \t\t\tas situacaoCotacaoEntidade, ");
        buf.append("       fpg2.fpg_codigo\t\t\t\tas codigoFormaPagamentoCotacaoEntidade, ");
        buf.append("\t   fpg2.fpg_descricao\t\t\tas descricaoFormaPagamentoCotacaoEntidade, ");
        buf.append("       fpg1.fpg_codigo\t\t\t\tas codigoFormaPagamentoPedido, ");
        buf.append("\t   fpg1.fpg_descricao\t\t\tas descricaoFormaPagamentoPedido, ");
        buf.append("       mat.mat_descricao\t\t\tas descricaoMaterial, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from pedido a ");
        buf.append(" left join pedidomaterial pma on (a.fil_codigo = pma.fil_codigo and a.ped_codigo = pma.ped_codigo) ");
        buf.append(" left join formapagto fpg1 on (a.fil_codigo = fpg1.fil_codigo and a.fpg_codigo = fpg1.fpg_codigo) ");
        buf.append(" left join cotacao cot on (a.fil_codigo = cot.fil_codigo and a.cot_codigo = cot.cot_codigo) ");
        buf.append(" left join cotacaoentidade cte on (a.fil_codigo = cte.fil_codigo and a.cot_codigo = cte.cot_codigo and cte.cte_situacao = '").append("V").append("') ");
        buf.append(" left join formapagto fpg2 on (cte.fil_codigo = fpg2.fil_codigo and cte.fpg_codigo = fpg2.fpg_codigo) ");
        buf.append(" left join material mat on (pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo) ");
        buf.append(" left join usuario usrAutoriza on a.usr_codautorizacao = usrAutoriza.usr_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" where a.fil_codigo = ").append(filial);
        buf.append("   and a.ped_codigo = ").append(codigoPedido);
        buf.append(" order by a.fil_codigo, a.ped_codigo ");
        int filialPedido = -1;
        int cotacao = -1;
        int entidade = -1;
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ModeloGridTable modelo = new ModeloGridTable(ArraysUtil.concatenar(ArraysUtil.concatenar(camposRelatorio, camposCadastros), camposParcela));
        if (rs.next()) {
            filialPedido = rs.getInt("codigoFilial");
            cotacao = rs.getInt("codigoCotacao");
            entidade = rs.getInt("codigoEntidadePedido");
            do {
                Object[] o = new Object[camposRelatorio.length + camposCadastros.length + camposParcela.length];
                for (int i = 0; i < camposRelatorio.length; ++i) {
                    if (camposRelatorio[i].equals("situacaoCotacao")) {
                        if (rs.getString(camposRelatorio[i]) == null) continue;
                        o[modelo.findColumn((String)RelatorioAutorizacaoCompra.camposRelatorio[i])] = Tipos.tipoCotacao(rs.getString(camposRelatorio[i]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("tipoDescontoCotacaoEntidade")) {
                        if (rs.getString(camposRelatorio[i]) == null) continue;
                        o[modelo.findColumn((String)RelatorioAutorizacaoCompra.camposRelatorio[i])] = Tipos.tipoDesconto(rs.getString(camposRelatorio[i]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("situacaoCotacaoEntidade")) {
                        if (rs.getString(camposRelatorio[i]) == null) continue;
                        o[modelo.findColumn((String)RelatorioAutorizacaoCompra.camposRelatorio[i])] = Tipos.tipoSituacaoFornecedorCotacao(rs.getString(camposRelatorio[i]));
                        continue;
                    }
                    o[modelo.findColumn((String)RelatorioAutorizacaoCompra.camposRelatorio[i])] = rs.getObject(camposRelatorio[i]);
                }
                RelatorioAutorizacaoCompra.pegaDadosCadastro(st2, o, modelo, rs.getInt("codigoFilial"), rs.getInt("codigoEntidadePedido"));
                modelo.addLine(o);
            } while (rs.next());
        }
        if (cotacao >= 0) {
            buf.delete(0, buf.length());
            buf.append(" select cep_datavencimento as data ");
            buf.append("       ,cep_valor as valor ");
            buf.append("   from cotacaoentidadeparcela ");
            buf.append("  where fil_codigo = ").append(filialPedido);
            buf.append("    and cot_codigo = ").append(cotacao);
            buf.append("    and ent_codigo = ").append(entidade);
            buf.append("  order by cep_codigo ");
            rs = Conexao.executeQuery(st, buf.toString());
            Date[] datas = new Date[6];
            Double[] valores = new Double[6];
            for (int i = 0; rs.next() && i < 6; ++i) {
                datas[i] = rs.getDate("data");
                valores[i] = rs.getDouble("valor");
            }
            for (int j = 0; j < modelo.getRowCount(); ++j) {
                for (int k = 0; k < 6; ++k) {
                    modelo.setValueAt(datas[k], j, modelo.findColumn("dataParcela" + k));
                    modelo.setValueAt(valores[k], j, modelo.findColumn("valorParcela" + k));
                }
            }
        }
        return modelo;
    }

    private static void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ent.ent_codigo \t\tas codigoCadastro, ");
        buf.append("        ent.ent_fantasia \tas fantasiaCadastro, ");
        buf.append("        ent.ent_razaosocial as razaoSocialCadastro, ");
        buf.append("        ent.ent_fone \t\tas foneCadastro, ");
        buf.append("        ent.ent_endereco \tas enderecoCadastro, ");
        buf.append("        ent.ent_numeroendereco as numeroEnderecoCadastro, ");
        buf.append("        ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
        buf.append("        ent.ent_fax \t\tas faxCadastro, ");
        buf.append("        ent.ent_complemento as complementoCadastro, ");
        buf.append("        ent.ent_cep \t\tas cepCadastro, ");
        buf.append("        ent.ent_cpfcnpj \tas cpfCadastro, ");
        buf.append("        ent.ent_cpfcnpj \tas cnpjCadastro, ");
        buf.append("        ent.ent_rgie \t\tas rgCadastro, ");
        buf.append("        ent.ent_rgie \t\tas ieCadastro, ");
        buf.append("        ent.cid_codigo \t\tas codigoCidadeCadastro, ");
        buf.append("        cident.cid_nome \tas nomeCidadeCadastro ");
        buf.append("   from entidade ent ");
        buf.append("   left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
        buf.append("  where ent.fil_codigo = ").append(filial);
        buf.append("    and ent.ent_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        int pos = -1;
        if (rs.next()) {
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || (pos = modelo.findColumn(s)) <= -1) continue;
                array[pos] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(modelo.getColumnName(pos))) : rs.getObject(s);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800900200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800900201");
    }
}

