/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.relatorios.estoque.pedido.CamposAssociacao;
import jalis.laboratorio.relatorios.estoque.pedido.JanelaAssociacoes;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.table.TableModel;

public class RelatorioAnalisePesquisaFornecedor
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final String PARAMETROS_RELATORIO_ANALISE_PESQUISA = "RelatorioAnalisePesquisa.ultimoFiltro";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_FORNECEDOR = "filtroFornecedor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String CONFIG_CAMPOS_ANALISADOS = "config-campos-analisados";
    private final String MODELO_RELATORIO = "modelo-relatorio";
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Valor"});
    private ArrayList<CamposAssociacao> listaCampos = new ArrayList();
    private ArrayList<String> listaCamposModelo = new ArrayList();
    private HashMap<String, String> mapCampos = new HashMap();
    private StringBuilder buiFiltros = new StringBuilder();
    private JButton buttonConfigurarAssociacoes = ComponenteFactory.novoJButton("Configurar Associa\u00e7\u00f5es", this);
    public String[] campos = new String[]{"codigoFornecedor", "fantasiaFornecedor", "quantidadePesquisa1", "quantidadePesquisa2", "quantidadePesquisa3", "quantidadePesquisa4", "quantidadePesquisa5", "quantidadePesquisa6", "quantidadePesquisa7", "quantidadePesquisa8", "quantidadePesquisa9", "quantidadePesquisa10", "percentualPesquisa1", "percentualPesquisa2", "percentualPesquisa3", "percentualPesquisa4", "percentualPesquisa5", "percentualPesquisa6", "percentualPesquisa7", "percentualPesquisa8", "percentualPesquisa9", "percentualPesquisa10", "quantidadeRegistros"};

    public RelatorioAnalisePesquisaFornecedor() {
        this.montaBarraDescricao("An\u00e1lise de pesquisa de fornecedores", "Relat\u00f3rio para an\u00e1lise de dados de pesquisa de fornecedores", "relatorios/rel_estoque_pedido_pesquisa_fornecedor.jpg");
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroFornecedor", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'", 1, new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.setModuloConfigurar(RelatorioAnalisePesquisaFornecedor.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAnalisePesquisaFornecedor.getModuloAcesso());
        this.buttonConfigurarAssociacoes.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaAssociacoes janela = JanelaAssociacoes.novaInstancia(Laboratorio.getInstancia());
                janela.setAssociacoes(RelatorioAnalisePesquisaFornecedor.this.listaCampos);
                janela.setVisible(true);
                RelatorioAnalisePesquisaFornecedor.this.listaCampos = janela.getAssociacoes();
                Statement st = null;
                try {
                    st = Conexao.getStatement();
                    RelatorioAnalisePesquisaFornecedor.this.salvarAtributos(st, RelatorioAnalisePesquisaFornecedor.getModuloAcesso(), RelatorioAnalisePesquisaFornecedor.this.getAtributosEditor(RelatorioAnalisePesquisaFornecedor.this.carregarXMLModelo()));
                    Conexao.arquivaSQL();
                    if (st == null) return;
                }
                catch (SQLException e1) {
                    try {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel configurar:", e1.getStackTrace());
                        if (st == null) return;
                    }
                    catch (Throwable throwable) {
                        if (st == null) throw throwable;
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    return;
                }
                Conexao.fecharStatement(st);
                return;
            }
        });
        this.panelBotoesE.add(this.buttonConfigurarAssociacoes);
        this.carregaParametros();
        this.adicionaCamposConfigurador();
        this.adicionaRelatorioListener(this);
    }

    private void adicionaCamposConfigurador() {
        this.setCamposConfigurador(null);
        ArrayList<String> listaAux = new ArrayList<String>();
        if (!this.listaCampos.isEmpty()) {
            String[] camposAnalisados = this.listaCampos.toString().split(",");
            for (int i = 0; i < camposAnalisados.length; ++i) {
                String rotulo = camposAnalisados[i].replace("[", "");
                rotulo = rotulo.replace("]", "");
                this.mapCampos.put("rotuloPesquisa" + (i + 1), rotulo.split("=")[0] + "(" + rotulo.split("=")[1] + ")");
                listaAux.add("rotuloPesquisa" + (i + 1));
            }
        }
        this.campos = ArraysUtil.concatenar(this.campos, listaAux.toArray(new String[listaAux.size()]));
        this.campos = ArraysUtil.concatenar(this.campos, Constantes.CAMPOS_FILIAL);
        this.setCamposConfigurador(this.campos);
    }

    private void carregaParametros() {
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RELATORIO_ANALISE_PESQUISA);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filiais");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "filtroDataInicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "filtroDataFinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "fornecedores"))) {
                this.setSelecionadosFiltro("filtroFornecedor", 0, tmp.split(","));
            }
        }
        if (!Funcoes.textoVazio(parametros = this.carregarXMLCamposAssociados())) {
            for (int i = 0; i < 10; ++i) {
                String tmp = StringUtil.getValor(parametros, "pesquisa" + i);
                if (Funcoes.textoVazio(tmp)) continue;
                String[] valores = tmp.split("=");
                String campo = valores[0];
                String valor = valores[1];
                CamposAssociacao objeto = new CamposAssociacao();
                objeto.setCampo(campo);
                objeto.setValor(valor);
                this.listaCampos.add(objeto);
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        if (this.validarDados()) {
            this.consultar();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800901300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800901301");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void consultar() {
        block39: {
            ResultSet rs;
            Statement st;
            block38: {
                String[] filiais;
                String[] entidades;
                String percentualPesquisa;
                String campoPesquisa;
                block37: {
                    int i;
                    this.adicionaCamposConfigurador();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    st = Conexao.getStatement();
                    rs = null;
                    campoPesquisa = "quantidadePesquisa";
                    percentualPesquisa = "percentualPesquisa";
                    this.limparValoresCampos();
                    this.buiFiltros.setLength(0);
                    entidades = this.getSelecionadosFiltro("filtroFornecedor", 0);
                    this.panelCentro.removeAll();
                    StringBuilder sql = new StringBuilder();
                    sql.append(" select nfi_pesquisafornecedor, ent.ent_codigo as codigoFornecedor, ent.ent_fantasia as fantasiaFornecedor, ");
                    for (int i2 = 1; i2 <= 10; ++i2) {
                        sql.append("0 as quantidadePesquisa").append(i2).append(", ");
                        sql.append("0 as percentualPesquisa").append(i2).append(", ");
                    }
                    sql.append(" 0 as quantidadeRegistros, ");
                    sql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    sql.append(" from notafiscal a ");
                    sql.append(" left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                    sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    sql.append(" where a.nfi_dataemissao between ").append(this.getDataFormatada(this.getFiltroData("filtroDataInicial"), "yyyy-MM-dd"));
                    sql.append(" \t and ").append(this.getDataFormatada(this.getFiltroData("filtroDataFinal"), "yyyy-MM-dd"));
                    sql.append("   and a.nfi_datahoracancelada is null and a.nfi_pesquisafornecedor is not null ");
                    sql.append("   and a.nfi_tipo = '").append("E").append("' ");
                    filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    if (filiais == null) {
                        filiais = new String[]{Variaveis.filialPadrao};
                    }
                    sql.append(" and a.fil_codigo in (");
                    for (i = 0; i < filiais.length; ++i) {
                        sql.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        sql.append(", ");
                    }
                    sql.append(") ");
                    if (entidades != null) {
                        sql.append(" and ent.ent_codigo in (");
                        for (i = 0; i < entidades.length; ++i) {
                            sql.append(entidades[i]);
                            if (i >= entidades.length - 1) continue;
                            sql.append(", ");
                        }
                        sql.append(")");
                    }
                    sql.append(" order by ent.ent_codigo ");
                    rs = Conexao.executeQuery(st, sql.toString());
                    if (rs.next()) break block37;
                    this.setCursor(Cursor.getDefaultCursor());
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    Conexao.fecharStatement(st);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                        this.habilitaBotaoImprimir(true);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                rs.beforeFirst();
                int qtdeLinhas = -1;
                while (rs.next()) {
                    ++qtdeLinhas;
                }
                rs.first();
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                int contaRegistros = 0;
                int codigoFornecedorAnterior = 0;
                Object[] o = new Object[this.campos.length];
                do {
                    int i;
                    --qtdeLinhas;
                    if (codigoFornecedorAnterior == 0) {
                        codigoFornecedorAnterior = rs.getInt("codigoFornecedor");
                    }
                    Map<String, Object> camposResultado = Resultado.getCamposResultado(rs.getString("nfi_pesquisafornecedor"), true);
                    if (codigoFornecedorAnterior != rs.getInt("codigoFornecedor")) {
                        int pos;
                        for (i = 0; i < this.listaCampos.size(); ++i) {
                            pos = modelo.findColumn(campoPesquisa + (i + 1));
                            o[pos] = this.listaCampos.get(i).getQuantidade();
                        }
                        for (i = 0; i < this.listaCampos.size(); ++i) {
                            pos = modelo.findColumn(percentualPesquisa + (i + 1));
                            o[pos] = new BigDecimal((double)this.listaCampos.get(i).getQuantidade().intValue() * 100.0 / (double)contaRegistros).setScale(2, RoundingMode.HALF_UP);
                        }
                        modelo.addLine(o);
                        contaRegistros = 1;
                        o = new Object[this.campos.length];
                        this.limparValoresCampos();
                        codigoFornecedorAnterior = rs.getInt("codigoFornecedor");
                    } else {
                        ++contaRegistros;
                    }
                    block20: for (String chave : camposResultado.keySet()) {
                        for (CamposAssociacao campoAssocia : this.listaCampos) {
                            if (campoAssocia.getCampo() == null || !campoAssocia.getCampo().equalsIgnoreCase(chave) || !camposResultado.get(chave).toString().equalsIgnoreCase(campoAssocia.getValor())) continue;
                            campoAssocia.incrementaContador();
                            continue block20;
                        }
                    }
                    block22: for (i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].indexOf("rotulo") > -1) {
                            for (String s : this.mapCampos.keySet()) {
                                if (!this.campos[i].equalsIgnoreCase(s)) continue;
                                o[i] = this.mapCampos.get(s);
                                continue block22;
                            }
                            continue;
                        }
                        if (this.campos[i].equalsIgnoreCase("quantidadeRegistros")) {
                            o[i] = contaRegistros;
                            continue;
                        }
                        if (this.campos[i].indexOf(campoPesquisa) != -1) continue;
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    if (qtdeLinhas != -1) continue;
                    for (i = 0; i < this.listaCampos.size(); ++i) {
                        int pos = modelo.findColumn(campoPesquisa + (i + 1));
                        o[pos] = this.listaCampos.get(i).getQuantidade();
                    }
                    for (i = 0; i < this.listaCampos.size(); ++i) {
                        int pos = modelo.findColumn(percentualPesquisa + (i + 1));
                        o[pos] = new BigDecimal((double)this.listaCampos.get(i).getQuantidade().intValue() * 100.0 / (double)contaRegistros).setScale(2, RoundingMode.HALF_UP);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String layout = this.carregarXMLModelo();
                if (Funcoes.textoVazio(layout)) break block38;
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioAnalisePesquisaFornecedor.this.panelCentro.removeAll();
                        RelatorioAnalisePesquisaFornecedor.this.panelCentro.repaint();
                        RelatorioAnalisePesquisaFornecedor.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("filtroFilial", filiais);
                var.put("filtroFornecedor", entidades);
                var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                this.gravarParametrosUsuario(filiais, "filiais", false);
                this.gravarParametrosUsuario(new String[]{this.getFiltroData("filtroDataInicial")}, "filtroDataInicial", false);
                this.gravarParametrosUsuario(new String[]{this.getFiltroData("filtroDataFinal")}, "filtroDataFinal", false);
                this.gravarParametrosUsuario(entidades, "fornecedores", true);
                gerador.executar(layout, (TableModel)modelo, var);
                this.panelCentro.revalidate();
            }
            Conexao.fecharStatement(st);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                this.habilitaBotaoImprimir(true);
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            break block39;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    this.habilitaBotaoImprimir(true);
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        ErrorLogger.mostraMensagem(this, e2.getMessage(), e2.getStackTrace());
                        this.habilitaBotaoImprimir(true);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    this.habilitaBotaoImprimir(true);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e3.getMessage(), e3.getStackTrace());
                    this.habilitaBotaoImprimir(true);
                }
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
            }
        }
    }

    private void limparValoresCampos() {
        for (CamposAssociacao campoAssocia : this.listaCampos) {
            campoAssocia.iniciaContador();
        }
    }

    private boolean validarDados() {
        if (this.listaCampos.isEmpty()) {
            Funcoes.mensagem(this, "Nenhum campo foi associado.", 2);
            this.buttonConfigurarAssociacoes.grabFocus();
            this.habilitaBotaoImprimir(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "A data final deve ser informada.", 2);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        return true;
    }

    private String getDataFormatada(String filtroData, String formatoDate) {
        StringBuilder date = new StringBuilder();
        date.append("'");
        date.append(Funcoes.formataData(formatoDate, filtroData));
        date.append("'");
        return date.toString();
    }

    private void gravarParametrosUsuario(String[] filtro, String campo, boolean gravar) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (filtro != null) {
            String valores = StringUtil.implode(filtro, ",");
            buf.append(StringUtil.getTag(campo, valores));
        }
        this.buiFiltros.append(buf.toString());
        if (gravar) {
            ParametrosUsuarios.setValor(PARAMETROS_RELATORIO_ANALISE_PESQUISA, StringUtil.getTag("filtros", this.buiFiltros.toString()));
            this.buiFiltros.setLength(0);
        }
    }

    @Override
    public String getAtributosEditor(String modelo) {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.getTag("config-campos-analisados", this.getXmlCampos(this.listaCampos)));
        buf.append(StringUtil.getTag("modelo-relatorio", modelo));
        return StringUtil.textoDB(buf.toString());
    }

    public String carregarXMLCamposAssociados() {
        String modelo = "";
        try {
            modelo = super.carregarXMLModelo();
            if (modelo != null && !Funcoes.textoVazio(modelo) && !Funcoes.textoVazio(StringUtil.getValor(modelo, "config-campos-analisados"))) {
                modelo = StringUtil.getValor(modelo, "config-campos-analisados");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar as legendas da consulta.\n", e.getStackTrace(), "PesquisaFornecedor(439)");
        }
        return modelo;
    }

    @Override
    public String carregarXMLModelo() {
        String modelo = "";
        try {
            modelo = super.carregarXMLModelo();
            if (modelo != null && !Funcoes.textoVazio(modelo) && !Funcoes.textoVazio(StringUtil.getValor(modelo, "modelo-relatorio"))) {
                modelo = StringUtil.getValor(modelo, "modelo-relatorio");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar o modelo de consulta.\n", e.getStackTrace(), "PesquisaFornecedor(399)");
        }
        return modelo;
    }

    private String getXmlCampos(ArrayList<CamposAssociacao> lista) {
        StringBuilder buf = new StringBuilder();
        int contador = 0;
        for (CamposAssociacao campo : lista) {
            buf.append(StringUtil.getTag("pesquisa" + contador++, campo.toString()));
        }
        return buf.toString();
    }
}

