/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.relatorios.estoque.pedido.CamposAssociacao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class JanelaAssociacoes
extends AbstractDialogoOKCancelar {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panel = new JPanel(this.grid);
    private TTextField txtValor = new TTextField(30, 3);
    private JComboBox comboCampos = new JComboBox();
    private JButton botaoOK = new JButton("OK");
    private JLabel labelCampo = new JLabel("Valor:");
    private JLabel labelComboCampos = new JLabel("Campo:");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Valor"});
    private JButton botaoFechar = new JButton("Fechar");
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private int linhaAlterada = -1;

    public static JanelaAssociacoes novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new JanelaAssociacoes((Frame)owner, "Associa\u00e7\u00f5es");
        }
        if (owner instanceof Dialog) {
            return new JanelaAssociacoes((Dialog)owner, "Associa\u00e7\u00f5es");
        }
        return null;
    }

    public JanelaAssociacoes(Frame owner, String title) {
        super(owner, title);
        this.montaTela(owner);
    }

    public JanelaAssociacoes(Dialog owner, String title) {
        super(owner, title);
        this.montaTela(owner);
    }

    private void montaTela(Window owner) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.modelo.setColumnSize(new int[]{180, 0}, this.tabela);
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.scroll.setPreferredSize(new Dimension(new Dimension(345, 180)));
        this.botaoFechar.setMnemonic('F');
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.panelBotoes.add(this.botaoFechar);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(0, 1, 1, 2);
        this.labelComboCampos.setPreferredSize(new Dimension(50, 20));
        this.panel.add((Component)this.labelComboCampos, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.anchor = 17;
        this.comboCampos.setPreferredSize(new Dimension(150, 20));
        this.panel.add((Component)this.comboCampos, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 0;
        this.labelCampo.setPreferredSize(new Dimension(50, 20));
        this.panel.add((Component)this.labelCampo, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(0, 0, 1, 1);
        this.txtValor.setPreferredSize(new Dimension(150, 21));
        this.txtValor.setMinimumSize(new Dimension(150, 21));
        this.panel.add((Component)this.txtValor, this.constraints);
        this.constraints.gridx = 3;
        this.constraints.gridy = 1;
        this.constraints.fill = 0;
        this.botaoOK.setPreferredSize(new Dimension(40, 20));
        this.botaoOK.setMinimumSize(new Dimension(40, 20));
        this.panel.add((Component)this.botaoOK, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 4;
        this.panel.add((Component)this.scroll, this.constraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.pack();
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(JanelaAssociacoes.this.txtValor.getText())) {
                    boolean isLocalizado = false;
                    for (int i = 0; i < JanelaAssociacoes.this.modelo.getRowCount(); ++i) {
                        String campo = (String)JanelaAssociacoes.this.modelo.getValueAt(i, 0);
                        String valor = (String)JanelaAssociacoes.this.modelo.getValueAt(i, 1);
                        if (!campo.equalsIgnoreCase(JanelaAssociacoes.this.comboCampos.getSelectedItem().toString()) || !valor.equalsIgnoreCase(JanelaAssociacoes.this.txtValor.getText())) continue;
                        isLocalizado = true;
                        break;
                    }
                    if (isLocalizado) {
                        Funcoes.mensagem(JanelaAssociacoes.this, "Associa\u00e7\u00e3o j\u00e1 foi adicionada.", 2);
                    } else if (JanelaAssociacoes.this.modelo.getRowCount() < 10) {
                        if (JanelaAssociacoes.this.comboCampos.getSelectedItem() != null) {
                            JanelaAssociacoes.this.modelo.addLine(new Object[]{JanelaAssociacoes.this.comboCampos.getSelectedItem(), JanelaAssociacoes.this.txtValor.getText()});
                        } else {
                            Funcoes.mensagem(JanelaAssociacoes.this, "Nenhum campo selecionado.", 2);
                        }
                    } else {
                        Funcoes.mensagem(JanelaAssociacoes.this, "Limite de associa\u00e7\u00f5es excedido (m\u00e1ximo 10 associa\u00e7\u00f5es).", 2);
                    }
                    JanelaAssociacoes.this.txtValor.clear();
                    JanelaAssociacoes.this.txtValor.grabFocus();
                }
            }
        });
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaAssociacoes.this.setVisible(false);
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha;
                if (e.getKeyCode() == 127 && JanelaAssociacoes.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(JanelaAssociacoes.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    JanelaAssociacoes.this.modelo.removeLine(JanelaAssociacoes.this.tabela.getSelectedRow());
                } else if (e.getKeyCode() == 32 && (linha = JanelaAssociacoes.this.tabela.getSelectedRow()) > -1) {
                    String item = (String)JanelaAssociacoes.this.modelo.getValueAt(linha, 0);
                    String valor = (String)JanelaAssociacoes.this.modelo.getValueAt(linha, 1);
                    JanelaAssociacoes.this.txtValor.setText(valor);
                    JanelaAssociacoes.this.comboCampos.setSelectedItem(item);
                    JanelaAssociacoes.this.modelo.removeLine(linha);
                }
            }
        });
        this.carregaLegendas();
    }

    public ArrayList<CamposAssociacao> getAssociacoes() {
        ArrayList<CamposAssociacao> associacoes = new ArrayList<CamposAssociacao>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            CamposAssociacao novo = new CamposAssociacao();
            novo.setCampo((String)this.modelo.getValueAt(i, 0));
            novo.setValor((String)this.modelo.getValueAt(i, 1));
            associacoes.add(novo);
        }
        return associacoes;
    }

    public void setAssociacoes(ArrayList<CamposAssociacao> campos) {
        this.modelo.clear();
        for (int i = 0; i < campos.size(); ++i) {
            this.modelo.addLine(new Object[]{campos.get(i).getCampo(), campos.get(i).getValor()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaLegendas() {
        String modelo;
        Statement st;
        block6: {
            st = Conexao.getStatement();
            modelo = "";
            try {
                StringBuilder b = new StringBuilder();
                b.append("select lay_pesquisafornecedor from layout ");
                b.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                b.append("  and lay_codigo = ").append(ParametrosGerais.getLayCodigo());
                ResultSet rs = Conexao.executeQuery(st, b);
                if (!rs.next()) break block6;
                modelo = rs.getString(1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar layout de pesquisa de fornecedor.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        if (modelo != null) {
            String[] tmp;
            for (String campo : tmp = DialogoConfigurador.getCamposResultado(modelo.toString())) {
                this.comboCampos.addItem(campo);
            }
        }
    }
}

