/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPlanilhaCotacao
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_COTACAO = "filtroCotacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_DATA_CRIACAO_INI = "filtroDataCriacaoInicial";
    private final String FILTRO_DATA_CRIACAO_FIM = "filtroDataCriacaoFinal";
    private final String FILTRO_DATA_ABERTURA_INI = "filtroDataAberturaInicial";
    private final String FILTRO_DATA_ABERTURA_FIM = "filtroDataAberturaFinal";
    private final String FILTRO_DATA_FECHAMENTO_INI = "filtroDataFechamentoInicial";
    private final String FILTRO_DATA_FECHAMENTO_FIM = "filtroDataFechamentoFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String[] SITUACAO = new String[]{Tipos.tipoCotacao("S"), Tipos.tipoCotacao("A"), Tipos.tipoCotacao("F"), Tipos.tipoCotacao("C"), "Exceto Cancelada", "Todas"};
    private static final String[] ORDEM = new String[]{"C\u00f3digo", "Usu\u00e1rio", "Data Cria\u00e7\u00e3o", "Data Abertura", "Data Fechamento", "Situa\u00e7\u00e3o"};
    private final String[] camposCadastro = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private final String[] camposCotacao = new String[]{"codigoCotacao", "usuarioCotacao", "dataHoraCotacao", "situacaoCotacao", "dataFechamentoCotacao", "dataAberturaCotacao", "observacaoCotacao"};
    private final String[] camposCotacaoMaterial = new String[]{"quantidadeCotacaoMaterial"};
    private final String[] camposCotacaoEntidade = new String[]{"totalCotacaoEntidade", "percentualDescontoCotacaoEntidade", "valorDescontoCotacaoEntidade", "vendedorCotacaoEntidade", "prazoEntregaCotacaoEntidade", "valorFreteCotacaoEntidade", "validadeCotacaoEntidade", "situacaoCotacaoEntidade", "tipoDescontoCotacaoEntidade", "codigoEntidade"};
    private final String[] camposCotacaoMaterialEntidade = new String[]{"valorUnitarioCotacaoMaterialEntidade", "valorDescontoCotacaoMaterialEntidade", "percentualDescontoCotacaoMaterialEntidade", "valorTotalCotacaoMaterialEntidade", "situacaoCotacaoMaterialEntidade", "quantidadeCotacaoMaterialEntidade", "tipoDescontoCotacaoMaterialEntidade"};
    private final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial"};
    private String[] camposRelatorio = null;
    private static final int QUANTIDADE_FORNECEDORES = 6;

    public RelatorioPlanilhaCotacao() {
        this.montaBarraDescricao("Planilha de cota\u00e7\u00e3o", "Planilha \"fornecedores x materiais\" da cota\u00e7\u00e3o", "relatorios/rel_estoque_cotacao_planilha_cotacao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCotacao", "Cota\u00e7\u00e3o", "cotacao", "", 1, new String[]{"cot_codigo", "cot_observacao"}, new String[]{"C\u00f3digo", "Observa\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'  and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataCriacaoInicial", "Dt Solicit. Ini:");
        this.adicionaFiltroData("filtroDataCriacaoFinal", "Dt Solicit. Fin:");
        this.adicionaFiltroData("filtroDataAberturaInicial", "Dt Abert. Ini:");
        this.adicionaFiltroData("filtroDataAberturaFinal", "Dt Abert. Fin:");
        this.adicionaFiltroData("filtroDataFechamentoInicial", "Dt Fecha. Ini:");
        this.adicionaFiltroData("filtroDataFechamentoFinal", "Dt Fecha. Fin:");
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", SITUACAO, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", ORDEM, 0);
        this.setModuloConfigurar(RelatorioPlanilhaCotacao.getModuloConfigurar());
        this.setModuloAcesso(RelatorioPlanilhaCotacao.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.camposCotacao);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCotacaoMaterial);
        for (int indice = 0; indice <= 6; ++indice) {
            String[] camposCadastroAux = new String[this.camposCadastro.length];
            for (int i = 0; i < this.camposCadastro.length; ++i) {
                camposCadastroAux[i] = this.camposCadastro[i] + indice;
            }
            this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCadastroAux);
            String[] camposCotacaoEntidadeAux = new String[this.camposCotacaoEntidade.length];
            for (int i = 0; i < this.camposCotacaoEntidade.length; ++i) {
                camposCotacaoEntidadeAux[i] = this.camposCotacaoEntidade[i] + indice;
            }
            this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCotacaoEntidadeAux);
            String[] camposCotacaoMaterialEntidadeAux = new String[this.camposCotacaoMaterialEntidade.length];
            for (int i = 0; i < this.camposCotacaoMaterialEntidade.length; ++i) {
                camposCotacaoMaterialEntidadeAux[i] = this.camposCotacaoMaterialEntidade[i] + indice;
            }
            this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCotacaoMaterialEntidadeAux);
        }
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block62: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            ArrayList<Cotacao> arrayCotacoes = new ArrayList<Cotacao>();
            try {
                String[] entidade;
                String[] usuario;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.cot_codigo as codigoCotacao ");
                buf.append(" \t\t\t,a.usr_codigo as usuarioCotacao ");
                buf.append(" \t\t\t,a.cot_datahora as dataHoraCotacao ");
                buf.append(" \t\t\t,a.cot_situacao as situacaoCotacao ");
                buf.append(" \t\t\t,a.cot_datafechamento as dataFechamentoCotacao ");
                buf.append(" \t\t\t,a.cot_observacao as observacaoCotacao ");
                buf.append(" \t\t\t,a.cot_dataabertura as dataAberturaCotacao ");
                buf.append(" \t\t\t,cma.cma_quantidade as quantidadeCotacaoMaterial ");
                buf.append(" \t\t\t,cte.ent_codigo as codigoEntidade ");
                buf.append(" \t\t\t,cte.cte_total as totalCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_percentualdesconto as percentualDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valordesconto as valorDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_vendedor as vendedorCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_prazoentrega as prazoEntregaCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valorfrete as valorFreteCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_validadecotacao as validadeCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_situacao as situacaoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_tipodesconto as tipoDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cme.cme_valorunitario as valorUnitarioCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valordesconto as valorDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_percentualdesconto as percentualDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valortotal as valorTotalCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_situacao as situacaoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_quantidade as quantidadeCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_tipodesconto as tipoDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,mat.mat_codigo as codigoMaterial ");
                buf.append(" \t\t\t,mat.mat_descricao as descricaoMaterial ");
                buf.append(" \t\t\t,mat.mat_valorultcompra as valorUltimaCompraMaterial ");
                buf.append(" \t\t\t,mat.mat_dataultcompra as dataUltimaCompraMaterial ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from cotacao a ");
                buf.append("  left join cotacaomaterial cma on (a.fil_codigo = cma.fil_codigo and a.cot_codigo = cma.cot_codigo) ");
                buf.append("  left join cotacaoentidade cte on (a.fil_codigo = cte.fil_codigo and a.cot_codigo = cte.cot_codigo) ");
                buf.append("  left join cotacaomaterialentidade cme on (a.fil_codigo = cme.fil_codigo and a.cot_codigo = cme.cot_codigo ");
                buf.append("                                            and cma.mat_codigo = cme.mat_codigo and cte.ent_codigo = cme.ent_codigo) ");
                buf.append("  left join material mat on (cma.fil_codigo = mat.fil_codigo and cma.mat_codigo = mat.mat_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] cotacaoFiltro = this.getSelecionadosFiltro("filtroCotacao", 0);
                if (cotacaoFiltro != null) {
                    buf.append(" and a.cot_codigo in (");
                    for (int i = 0; i < cotacaoFiltro.length; ++i) {
                        buf.append("'");
                        buf.append(cotacaoFiltro[i]);
                        buf.append("'");
                        if (i >= cotacaoFiltro.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    buf.append(" and cte.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        buf.append("'");
                        buf.append(entidade[i]);
                        buf.append("'");
                        if (i >= entidade.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataCriacaoInicial"))) {
                    buf.append(" and cast(a.cot_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataCriacaoInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataCriacaoFinal"))) {
                    buf.append(" and cast(a.cot_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataCriacaoFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFechamentoInicial"))) {
                    buf.append(" and cast(a.cot_datafechamento as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFechamentoInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFechamentoFinal"))) {
                    buf.append(" and cast(a.cot_datafechamento as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFechamentoFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataAberturaInicial"))) {
                    buf.append(" and cast(a.cot_dataabertura as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataAberturaInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataAberturaFinal"))) {
                    buf.append(" and cast(a.cot_dataabertura as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataAberturaFinal")));
                    buf.append("'");
                }
                if (!Funcoes.textoVazio((String)this.getFiltroCombo("filtroSituacao"))) {
                    if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[0])) {
                        buf.append(" and a.cot_situacao = '").append("S").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[1])) {
                        buf.append(" and a.cot_situacao = '").append("A").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[2])) {
                        buf.append(" and a.cot_situacao = '").append("F").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[3])) {
                        buf.append(" and a.cot_situacao = '").append("C").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[4])) {
                        buf.append(" and a.cot_situacao <> '").append("C").append("' ");
                    }
                }
                buf.append(" order by a.fil_codigo ");
                if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[0])) {
                    buf.append(", a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[1])) {
                    buf.append(", a.usr_codigo, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[2])) {
                    buf.append(", a.cot_datahora, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[3])) {
                    buf.append(", a.cot_dataabertura, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[4])) {
                    buf.append(", a.cot_datafechamento, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[5])) {
                    buf.append(", a.cot_situacao, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        Object[] objCotacao = new Object[Constantes.CAMPOS_FILIAL.length + this.camposCotacao.length];
                        Object[] objMaterial = new Object[this.camposMaterial.length + this.camposCotacaoMaterial.length];
                        Object[] objFornecedor = new Object[this.camposCadastro.length + this.camposCotacaoEntidade.length + this.camposCotacaoMaterialEntidade.length];
                        String[] auxCamposCotacao = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.camposCotacao);
                        for (int i = 0; i < auxCamposCotacao.length; ++i) {
                            objCotacao[i] = auxCamposCotacao[i].equals("situacaoCotacao") ? Tipos.tipoCotacao(rs.getString(auxCamposCotacao[i])) : rs.getObject(auxCamposCotacao[i]);
                        }
                        String[] auxCamposMaterial = ArraysUtil.concatenar(this.camposMaterial, this.camposCotacaoMaterial);
                        for (int i = 0; i < auxCamposMaterial.length; ++i) {
                            objMaterial[i] = auxCamposMaterial[i].equals("situacaoCotacaoEntidade") ? Tipos.tipoSituacaoFornecedorCotacao(rs.getString(auxCamposMaterial[i])) : (auxCamposMaterial[i].equals("tipoDescontoCotacaoEntidade") || auxCamposMaterial[i].equals("tipoDescontoCotacaoMaterialEntidade") ? Tipos.tipoDesconto(rs.getString(auxCamposMaterial[i])) : (auxCamposMaterial[i].equals("situacaoCotacaoMaterialEntidade") ? Tipos.situacaoMaterialFornecedor(rs.getString(auxCamposMaterial[i])) : rs.getObject(auxCamposMaterial[i])));
                        }
                        String[] auxCamposFornecedor = ArraysUtil.concatenar(this.camposCadastro, this.camposCotacaoEntidade);
                        auxCamposFornecedor = ArraysUtil.concatenar(auxCamposFornecedor, this.camposCotacaoMaterialEntidade);
                        for (int i = 0; i < auxCamposFornecedor.length; ++i) {
                            if (auxCamposFornecedor[i].equals("situacaoCotacaoEntidade")) {
                                if (rs.getString(auxCamposFornecedor[i]) == null) continue;
                                objFornecedor[i] = Tipos.tipoSituacaoFornecedorCotacao(rs.getString(auxCamposFornecedor[i]));
                                continue;
                            }
                            if (auxCamposFornecedor[i].equals("tipoDescontoCotacaoEntidade") || auxCamposFornecedor[i].equals("tipoDescontoCotacaoMaterialEntidade")) {
                                if (rs.getString(auxCamposFornecedor[i]) == null) continue;
                                objFornecedor[i] = Tipos.tipoDesconto(rs.getString(auxCamposFornecedor[i]));
                                continue;
                            }
                            if (auxCamposFornecedor[i].equals("situacaoCotacaoMaterialEntidade")) {
                                if (rs.getString(auxCamposFornecedor[i]) == null) continue;
                                objFornecedor[i] = Tipos.situacaoMaterialFornecedor(rs.getString(auxCamposFornecedor[i]));
                                continue;
                            }
                            if (ArraysUtil.contem(this.camposCadastro, auxCamposFornecedor[i])) continue;
                            objFornecedor[i] = rs.getObject(auxCamposFornecedor[i]);
                        }
                        this.pegaDadosCadastro(st2, objFornecedor, rs.getInt("codigoFilial"), rs.getInt("codigoEntidade"));
                        Cotacao cotacao = null;
                        for (int i = 0; i < arrayCotacoes.size(); ++i) {
                            if (((Cotacao)arrayCotacoes.get(i)).getCodigoCotacao() != rs.getInt("codigoCotacao")) continue;
                            cotacao = (Cotacao)arrayCotacoes.get(i);
                            break;
                        }
                        if (cotacao == null) {
                            cotacao = new Cotacao(rs.getInt("codigoCotacao"), objCotacao);
                            arrayCotacoes.add(cotacao);
                        }
                        cotacao.addMaterial(rs.getInt("codigoMaterial"), objMaterial);
                        cotacao.addFornecedor(rs.getInt("codigoMaterial"), rs.getInt("codigoEntidade"), objFornecedor);
                    } while (rs.next());
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    for (int i = 0; i < arrayCotacoes.size(); ++i) {
                        Cotacao cotacao = (Cotacao)arrayCotacoes.get(i);
                        for (int j = 0; j < cotacao.getMateriais().size(); ++j) {
                            Material material = cotacao.getMateriais().get(j);
                            Object[] obj = ArraysUtil.concatenar(cotacao.getValores(), material.getValores());
                            for (int k = 0; k < material.getFornecedores().size(); ++k) {
                                Fornecedor fornecedor = material.getFornecedores().get(k);
                                obj = ArraysUtil.concatenar(obj, fornecedor.getValores());
                            }
                            obj = ArraysUtil.concatenar(obj, new Object[this.camposRelatorio.length - obj.length]);
                            modelo.addLine(obj);
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioPlanilhaCotacao.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioPlanilhaCotacao.this.panelCentro.removeAll();
                                RelatorioPlanilhaCotacao.this.panelCentro.repaint();
                                RelatorioPlanilhaCotacao.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroDataCriacaoInicial", this.getFiltroData("filtroDataCriacaoInicial"));
                        var.put("filtroDataCriacaoFinal", this.getFiltroData("filtroDataCriacaoFinal"));
                        var.put("filtroDataAberturaInicial", this.getFiltroData("filtroDataAberturaInicial"));
                        var.put("filtroDataAberturaFinal", this.getFiltroData("filtroDataAberturaFinal"));
                        var.put("filtroDataFechamentoInicial", this.getFiltroData("filtroDataFechamentoInicial"));
                        var.put("filtroDataFechamentoFinal", this.getFiltroData("filtroDataFechamentoFinal"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (cotacaoFiltro != null) {
                            for (int i = 0; i < cotacaoFiltro.length; ++i) {
                                buf.append(cotacaoFiltro[i]);
                                if (i >= cotacaoFiltro.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroCotacao", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (int i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block62;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800800200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800800201");
    }

    private void pegaDadosCadastro(Statement st, Object[] array, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("ent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
        buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
        buf.append("ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
        buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro, ent.ent_cpfcnpj as cnpjCpfCadastro, ent.ent_rgie as ieRgCadastro ");
        buf.append("from entidade ent ");
        buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
        buf.append("where ent.fil_codigo = ").append(filial);
        buf.append(" and ent.ent_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        int pos = -1;
        if (rs.next()) {
            for (String s : this.camposCadastro) {
                if (rs.findColumn(s) <= 0 || (pos = ArraysUtil.indice((Object[])this.camposCadastro, s)) <= -1) continue;
                array[pos] = this.camposCadastro[pos].equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    static /* synthetic */ String[] access$300(RelatorioPlanilhaCotacao x0) {
        return x0.camposCotacao;
    }

    static /* synthetic */ String[] access$400(RelatorioPlanilhaCotacao x0) {
        return x0.camposMaterial;
    }

    static /* synthetic */ String[] access$500(RelatorioPlanilhaCotacao x0) {
        return x0.camposCotacaoMaterial;
    }

    static /* synthetic */ String[] access$600(RelatorioPlanilhaCotacao x0) {
        return x0.camposCadastro;
    }

    static /* synthetic */ String[] access$700(RelatorioPlanilhaCotacao x0) {
        return x0.camposCotacaoEntidade;
    }

    static /* synthetic */ String[] access$800(RelatorioPlanilhaCotacao x0) {
        return x0.camposCotacaoMaterialEntidade;
    }

    class Fornecedor {
        private int codigoFornecedor = -1;
        private Object[] valores = new String[RelatorioPlanilhaCotacao.access$600(RelatorioPlanilhaCotacao.this).length + RelatorioPlanilhaCotacao.access$700(RelatorioPlanilhaCotacao.this).length + RelatorioPlanilhaCotacao.access$800(RelatorioPlanilhaCotacao.this).length];

        public Fornecedor(int codigoFornecedor, Object[] valores) {
            this.codigoFornecedor = codigoFornecedor;
            this.valores = valores;
        }

        public int getCodigoFornecedor() {
            return this.codigoFornecedor;
        }

        public Object[] getValores() {
            return this.valores;
        }
    }

    class Material {
        private int codigoMaterial = -1;
        private Object[] valores = new String[RelatorioPlanilhaCotacao.access$400(RelatorioPlanilhaCotacao.this).length + RelatorioPlanilhaCotacao.access$500(RelatorioPlanilhaCotacao.this).length];
        private ArrayList<Fornecedor> fornecedores = null;

        public Material(int codigoMaterial, Object[] valores) {
            this.codigoMaterial = codigoMaterial;
            this.valores = valores;
            this.fornecedores = new ArrayList();
        }

        public int getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public Object[] getValores() {
            return this.valores;
        }

        public ArrayList<Fornecedor> getFornecedores() {
            return this.fornecedores;
        }

        public Fornecedor getFornecedor(int i) {
            return this.fornecedores.get(i);
        }

        public void addFornecedor(int codigoFornecedor, Object[] valores) {
            for (int i = 0; i < this.fornecedores.size(); ++i) {
                if (this.fornecedores.get(i).getCodigoFornecedor() != codigoFornecedor) continue;
                return;
            }
            Fornecedor forn = new Fornecedor(codigoFornecedor, valores);
            this.fornecedores.add(forn);
        }
    }

    class Cotacao {
        private int codigoCotacao = -1;
        private Object[] valores = new String[Constantes.CAMPOS_FILIAL.length + RelatorioPlanilhaCotacao.access$300(RelatorioPlanilhaCotacao.this).length];
        private ArrayList<Material> materiais = null;

        public int getCodigoCotacao() {
            return this.codigoCotacao;
        }

        public Object[] getValores() {
            return this.valores;
        }

        public ArrayList<Material> getMateriais() {
            return this.materiais;
        }

        public Material getMaterial(int i) {
            return this.materiais.get(i);
        }

        public Cotacao(int codigoCotacao, Object[] valores) {
            this.codigoCotacao = codigoCotacao;
            this.valores = valores;
            this.materiais = new ArrayList();
        }

        public void addMaterial(int codigoMaterial, Object[] valores) {
            for (int i = 0; i < this.materiais.size(); ++i) {
                if (this.materiais.get(i).getCodigoMaterial() != codigoMaterial) continue;
                return;
            }
            Material mat = new Material(codigoMaterial, valores);
            this.materiais.add(mat);
        }

        public void addFornecedor(int codigoMaterial, int codigoFornecedor, Object[] valores) {
            Material mat = null;
            for (int i = 0; i < this.materiais.size(); ++i) {
                if (this.materiais.get(i).getCodigoMaterial() != codigoMaterial) continue;
                mat = this.materiais.get(i);
                break;
            }
            if (mat != null) {
                mat.addFornecedor(codigoFornecedor, valores);
            }
        }
    }
}

