/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioEntradaMaterial
extends FrmRelPadrao {
    private String[] ordem = new String[]{"N\u00famero", "Data cadastro", "Valor", "Fantasia", "Raz\u00e3o Social", "Fant. + Data", "Raz. Social + Data"};
    private final String[] tipoSituacao = new String[]{"Todas", Tipos.tipoSituacaoNotaFiscal("A", false), Tipos.tipoSituacaoNotaFiscal("C", false)};
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_SERIE = "filtroSeries";
    private final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "materialInativo", "codigoMaterial", "descricaoMaterial", "quantidadeMaterial", "valorUnitarioMaterial", "valorIpiMaterial", "percentualIpiMaterial", "valorIcmsMaterial", "percentualIcmsMaterial", "valorTotalMaterial", "valorDescontoMaterial", "percentualDescontoMaterial", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"serieNotaFiscal", "numeroNotaFiscal", "tipoCadastroNotaFiscal", "usuarioNotaFiscal", "dataHoraNotaFiscal", "dataEmissaoNotaFiscal", "codigoInternoNotaFiscal", "dataHoraImpressaoNotaFiscal", "situacaoNotaFiscal", "codigoFormaPgto", "observacaoNotaFiscal", "valorTotalNotaFiscal", "subtotalNotaFiscal", "baseCalculoImpostosNotaFiscal", "descricaoFormaPgto", "acumuladoImpostosNotaFiscal", "dataCancelamentoNotaFiscal", "usuarioCancelamentoNotaFiscal", "nomeUsuarioCancelamentoNotaFiscal", "usuarioImpressaoNotaFiscal", "nomeUsuarioImpressaoNotaFiscal", "descricaoMotivoCancelamento", "codigoMotivoCancelamento", "descricaoCancelamentoUsuario", "datasVencimentoNotaFiscal", "codigoUsuarioAutorizacaoFinanceiraNotaFiscal", "codigoUsuarioReimpressaoNotaFiscal", "codigoUsuarioImpressaoNotaFiscal", "codigoUsuarioCanceladaNotaFiscal", "tipoNotaFiscal", "percentualIrrfNotaFiscal", "percentualIssNotaFiscal", "percentualPisNotaFiscal", "percentualCsllNotaFiscal", "percentualCofinsNotaFiscal", "percentualInssNotaFiscal", "dataHoraReimpressaoNotaFiscal", "percentualIpiNotaFiscal", "valorIpiNotaFiscal", "percentualIcmsNotaFiscal", "valorIcmsNotaFiscal", "codigoPedidoNotaFiscal", "dataAutorizacaoFinanceiraNotaFiscal", "valorDescontoNotaFiscal", "percentualDescontoNotaFiscal", "valorFreteNotaFiscal", "codigoCfop", "motivoCfop", "isEletronica", "numeroRps", "isNotaEnviada", "percentualDescontoCondicional", "statusNfse", "motivoNfse", "dataStatusNfse", "protocoloNfse", "chaveRpsNfse", "chaveNfse"});
    public String[] campos = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastros);

    public RelatorioEntradaMaterial() {
        this.montaBarraDescricao("Entrada de materiais por fornecedor", "Listagem de entrada de materiais por fornecedor", "relatorios/rel_estoque_cotacao_material_fornecedor.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSeries", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'  and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_fantasia", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro("filtroTipoMaterial", "Tipo material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.tipoSituacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroMaterialInativo", "Mostrar material inativo", false);
        this.setCamposConfigurador(this.campos);
        this.setModuloConfigurar(RelatorioEntradaMaterial.getModuloConfigurar());
        this.setModuloAcesso(RelatorioEntradaMaterial.getModuloAcesso());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block39: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] series;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.ser_codigo \t\t as serieNotaFiscal ");
                buf.append("\t   ,a.nfi_numero \t\t\t as numeroNotaFiscal ");
                buf.append("\t   ,a.nfi_tipocadastro as tipoCadastroNotaFiscal ");
                buf.append("\t   ,a.usr_codigo \t\t\t as usuarioNotaFiscal ");
                buf.append("\t   ,a.nfi_datahora \t\t as dataHoraNotaFiscal ");
                buf.append("\t   ,a.nfi_dataemissao  as dataEmissaoNotaFiscal ");
                buf.append("\t   ,a.nfi_datahoraimpressao\tas dataHoraImpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_situacao \t\t\t\t as situacaoNotaFiscal ");
                buf.append("     ,a.nfi_codigo           as codigoInternoNotaFiscal ");
                buf.append("\t   ,a.fpg_codigo \t\t\t\t\t as codigoFormaPgto ");
                buf.append("     ,fpg.fpg_descricao      as descricaoFormaPgto");
                buf.append("\t   ,a.nfi_observacao \t\t\t as observacaoNotaFiscal ");
                buf.append("\t   ,a.nfi_subtotal    \t\t as subtotalNotaFiscal ");
                buf.append("\t   ,a.nfi_valortotal \t\t\t as valorTotalNotaFiscal ");
                buf.append("\t   ,a.nfi_impostoacumulado as baseCalculoImpostosNotaFiscal ");
                buf.append("     ,a.nfi_descricaocancelamento\tas descricaoCancelamentoUsuario ");
                buf.append("\t   ,a.mov_codigo \t\t\tas codigoMotivoCancelamento ");
                buf.append("\t   ,mov.mov_descricao as descricaoMotivoCancelamento ");
                buf.append("\t   ,a.usr_codautorizafinanceira as codigoUsuarioAutorizacaoFinanceiraNotaFiscal ");
                buf.append("     ,a.usr_codreimpressao\t as codigoUsuarioReimpressaoNotaFiscal ");
                buf.append("     ,a.usr_codimpressao\t\t as codigoUsuarioImpressaoNotaFiscal ");
                buf.append("     ,a.usr_codcancelada\t\t as codigoUsuarioCanceladaNotaFiscal ");
                buf.append("\t   ,a.nfi_tipo\t\t\t\t\t\t as tipoNotaFiscal ");
                buf.append("     ,a.nfi_irrfpercentual\t as percentualIrrfNotaFiscal ");
                buf.append("     ,a.nfi_isspercentual\t\t as percentualIssNotaFiscal ");
                buf.append("     ,a.nfi_pispercentual\t\t as percentualPisNotaFiscal ");
                buf.append("\t   ,a.nfi_csllpercentual\t as percentualCsllNotaFiscal ");
                buf.append("\t   ,a.nfi_cofinspercentual as percentualCofinsNotaFiscal ");
                buf.append("\t   ,a.nfi_insspercentual\t as percentualInssNotaFiscal ");
                buf.append("     ,a.nfi_datahorareimpressao\tas dataHoraReimpressaoNotaFiscal ");
                buf.append("\t   ,a.nfi_ipipercentual\t as percentualIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_ipivalor\t\t\t as valorIpiNotaFiscal ");
                buf.append("\t   ,a.nfi_icmspercentual as percentualIcmsNotaFiscal ");
                buf.append("\t   ,a.nfi_icmsvalor\t\t\t as valorIcmsNotaFiscal ");
                buf.append("\t   ,a.ped_codigo\t\t\t\t as codigoPedidoNotaFiscal ");
                buf.append("\t   ,a.nfi_dataautorizafinanceira\tas dataAutorizacaoFinanceiraNotaFiscal ");
                buf.append("\t   ,a.nfi_valordesconto\t\t\tas valorDescontoNotaFiscal ");
                buf.append("     ,a.nfi_percentualdesconto as percentualDescontoNotaFiscal ");
                buf.append("\t   ,a.nfi_valorfrete\t\t\t\tas valorFreteNotaFiscal ");
                buf.append("     ,a.nfi_numerorps IS NOT NULL as isEletronica ");
                buf.append("     ,a.nfi_numerorps as numeroRps ");
                buf.append("     ,a.nfi_notaenviada as isNotaEnviada ");
                buf.append("     ,a.nfi_percdescontocondicionado as percentualDescontoCondicional ");
                buf.append("     ,a.nfi_statusnfse as statusNfse ");
                buf.append("     ,a.nfi_motivonfse as motivoNfse ");
                buf.append("     ,a.nfi_datastatusnfse as dataStatusNfse ");
                buf.append("     ,a.nfi_protocolonfse as protocoloNfse ");
                buf.append("     ,a.nfi_chaverpsnfse as chaveRpsNfse ");
                buf.append("     ,a.nfi_chavenfse as chaveNfse ");
                buf.append("\t   ,nfm.mat_codigo\t\t\t\t as codigoMaterial ");
                buf.append("\t   ,mat.mat_descricao\t\t\t as descricaoMaterial ");
                buf.append("\t\t ,mat.mat_inativo        as materialInativo ");
                buf.append("     ,nfm_quantidade         as quantidadeMaterial ");
                buf.append("     ,nfm_valorunitario      as valorUnitarioMaterial ");
                buf.append("     ,nfm_valoripi           as valorIpiMaterial ");
                buf.append("     ,nfm_percentualipi      as percentualIpiMaterial ");
                buf.append("     ,nfm_valoricms          as valorIcmsMaterial ");
                buf.append("     ,nfm_percentualicms     as percentualIcmsMaterial ");
                buf.append("     ,nfm_valortotal         as valorTotalMaterial");
                buf.append("     ,nfm_valordesconto      as valorDescontoMaterial ");
                buf.append("     ,nfm_percentualdesconto as percentualDescontoMaterial ");
                buf.append("     ,nfi_irrfvalor + nfi_issvalor + nfi_pisvalor + nfi_csllvalor + nfi_cofinsvalor + nfi_inssvalor as acumuladoImpostosNotaFiscal ");
                buf.append("     ,a.ent_codigo as codigoCadastro ");
                buf.append("     ,ent.ent_fantasia as fantasiaCadastro ");
                buf.append("     ,ent.ent_razaosocial as razaoSocialCadastro ");
                buf.append("     ,ent.ent_fone as foneCadastro ");
                buf.append("     ,ent.ent_endereco as enderecoCadastro ");
                buf.append("     ,ent.ent_numeroendereco as numeroEnderecoCadastro ");
                buf.append("     ,ent.ent_tipologradouroendereco as tipoLogradouroCadastro ");
                buf.append("     ,ent.ent_fax as faxCadastro ");
                buf.append("     ,ent.ent_cpfcnpj as cnpjCpfCadastro ");
                buf.append("     ,ent.ent_rgie as ieRgCadastro ");
                buf.append("     ,ent.ent_complemento as complementoCadastro ");
                buf.append("     ,ent.ent_cep as cepCadastro ");
                buf.append("     ,a.nfi_datahoracancelada as dataCancelamentoNotaFiscal ");
                buf.append("     ,usrcancelamento.usr_codigo as usuarioCancelamentoNotaFiscal ");
                buf.append("     ,usrcancelamento.usr_nome as nomeUsuarioCancelamentoNotaFiscal ");
                buf.append("     ,usrimpressao.usr_codigo as usuarioImpressaoNotaFiscal ");
                buf.append("     ,usrimpressao.usr_nome as nomeUsuarioImpressaoNotaFiscal ");
                buf.append("     ,null as datasVencimentoNotaFiscal ");
                buf.append("\t   ,cfo.cfo_codigo\t\t\t\t\tas codigoCfop ");
                buf.append("\t   ,cfo.cfo_motivo\t\t\t\t\tas motivoCfop, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from notafiscal a ");
                buf.append("left join notafiscalmaterial nfm on a.fil_codigo = nfm.fil_codigo and a.nfi_codigo = nfm.nfi_codigo ");
                buf.append("left join material mat on nfm.fil_codigo = mat.fil_codigo AND nfm.mat_codigo = mat.mat_codigo ");
                buf.append("left join tipomaterial tpm on mat.tpm_codigo = tpm.tpm_codigo and mat.fil_codigo = tpm.fil_codigo ");
                buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("left join formapagto fpg on a.fpg_codigo = fpg.fpg_codigo and a.fil_codigo = fpg.fil_codigo ");
                buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("left join usuario usrcancelamento on a.usr_codcancelada = usrcancelamento.usr_codigo ");
                buf.append("left join usuario usrimpressao on a.usr_codimpressao = usrimpressao.usr_codigo ");
                buf.append("left join motivoscancelamentos mov on a.fil_codigo = mov.fil_codigo and a.mov_codigo = mov.mov_codigo ");
                buf.append("left join cfop cfo on (a.fil_codigo = cfo.fil_codigo and a.cfo_codigo = cfo.cfo_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
                String[] material = this.getSelecionadosFiltro("filtroMaterial", 0);
                if (material != null) {
                    buf.append(" and mat.mat_codigo in (");
                    for (int i = 0; i < material.length; ++i) {
                        buf.append("'").append(material[i]).append("'");
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((series = this.getSelecionadosFiltro("filtroSeries", 0)) != null) {
                    buf.append(" and a.ser_codigo in (");
                    for (int i = 0; i < series.length; ++i) {
                        buf.append("'").append(series[i]).append("'");
                        if (i >= series.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (this.getSelecionadosFiltro("filtroEntidade", 0) != null) {
                    buf.append(" and ( ");
                }
                StringBuilder aux = new StringBuilder();
                String[] entidade = this.getSelecionadosFiltro("filtroEntidade", 0);
                if (entidade != null) {
                    if (aux.length() > 0) {
                        aux.append(" or ");
                    }
                    aux.append(" a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        aux.append("'").append(entidade[i]).append("'");
                        if (i >= entidade.length - 1) continue;
                        aux.append(", ");
                    }
                    aux.append(")");
                }
                if (aux.length() > 0) {
                    aux.append(" ) ");
                }
                buf.append(aux.toString());
                this.getSelecionadosFiltroValoresConcat("filtroTipoMaterial", 0, buf, " and tpm.tpm_codigo in ", false, false);
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a.nfi_dataemissao as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a.nfi_dataemissao as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                this.getSituacao(buf, this.getFiltroComboIndice("filtroSituacao"));
                buf.append(" and a.nfi_tipo = '").append("E").append("' ");
                if (!this.getFiltroCheck("filtroMaterialInativo")) {
                    buf.append(" and mat.mat_inativo = false ");
                }
                buf.append(" order by a.fil_codigo, mat.mat_codigo ");
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                    buf.append(", a.nfi_numero ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append(", a.nfi_dataemissao");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append(", a.nfi_valortotal ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                    buf.append(", fantasiaCadastro ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                    buf.append(", razaoSocialCadastro ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                    buf.append(", fantasiaCadastro, a.nfi_datahora ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[6])) {
                    buf.append(", razaoSocialCadastro, a.nfi_datahora ");
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.campos);
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[modelo.findColumn((String)this.campos[i])] = this.campos[i].equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i])) : (this.campos[i].equals("tipoCadastroNotaFiscal") ? Tipos.tipoCadastro(rs.getString(this.campos[i])) : (this.campos[i].equals("situacaoNotaFiscal") ? Tipos.tipoSituacaoNotaFiscal(rs.getString(this.campos[i]), rs.getBoolean("isEletronica")) : (this.campos[i].equals("datasVencimentoNotaFiscal") ? new NotaFiscalService().pegaVencimentoParcelas(st2, rs.getInt("codigoFilial"), rs.getInt("codigoInternoNotaFiscal")) : (this.campos[i].equals("materialInativo") ? (rs.getBoolean(this.campos[i]) ? "Sim" : "N\u00e3o") : rs.getObject(this.campos[i])))));
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioEntradaMaterial.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioEntradaMaterial.this.panelCentro.removeAll();
                                RelatorioEntradaMaterial.this.panelCentro.repaint();
                                RelatorioEntradaMaterial.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        buf.delete(0, buf.length());
                        if (series != null) {
                            for (i = 0; i < series.length; ++i) {
                                buf.append(series[i]);
                                if (i >= series.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSeries", buf.toString());
                        buf.delete(0, buf.length());
                        if (material != null) {
                            for (i = 0; i < material.length; ++i) {
                                buf.append(material[i]);
                                if (i >= material.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroMaterial", buf.toString());
                        var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") ? "Sim" : "N\u00e3o");
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block39;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void getSituacao(StringBuilder buf, int sit) {
        String[] tipos = new String[]{"A", "C"};
        if (!this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[0]) && this.getFiltroCombo("filtroSituacao").equals(this.tipoSituacao[sit])) {
            buf.append(" and a.nfi_situacao = '").append(tipos[sit - 1]).append("'");
        }
        tipos = null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800900800");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800900801");
    }
}

