/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioCotacao
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_COTACAO = "filtroCotacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_DATA_CRIACAO_INI = "filtroDataCriacaoInicial";
    private final String FILTRO_DATA_CRIACAO_FIM = "filtroDataCriacaoFinal";
    private final String FILTRO_DATA_ABERTURA_INI = "filtroDataAberturaInicial";
    private final String FILTRO_DATA_ABERTURA_FIM = "filtroDataAberturaFinal";
    private final String FILTRO_DATA_FECHAMENTO_INI = "filtroDataFechamentoInicial";
    private final String FILTRO_DATA_FECHAMENTO_FIM = "filtroDataFechamentoFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_SOMENTE_VENCEDOR = "filtroSomenteVencedor";
    private static final String[] SITUACAO = new String[]{"Todas", Tipos.tipoCotacao("S"), Tipos.tipoCotacao("A"), Tipos.tipoCotacao("F"), Tipos.tipoCotacao("C"), "Exceto Cancelada"};
    private static final String[] ORDEM = new String[]{"C\u00f3digo", "Usu\u00e1rio", "Data Cria\u00e7\u00e3o", "Data Abertura", "Data Fechamento", "Situa\u00e7\u00e3o"};
    public static final int TIPO_LISTAGEM = 0;
    public static final int TIPO_VENCEDOR = 1;
    private int tipoRelatorio = 0;
    private final String[] camposCadastro = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "cnpjCpfCadastro", "ieRgCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro"};
    private final String[] camposCotacao = new String[]{"codigoCotacao", "usuarioCotacao", "dataHoraCotacao", "situacaoCotacao", "dataFechamentoCotacao", "dataAberturaCotacao", "observacaoCotacao"};
    private final String[] camposCotacaoMaterial = new String[]{"quantidadeCotacaoMaterial"};
    private final String[] camposCotacaoEntidade = new String[]{"totalCotacaoEntidade", "percentualDescontoCotacaoEntidade", "valorDescontoCotacaoEntidade", "vendedorCotacaoEntidade", "prazoEntregaCotacaoEntidade", "valorFreteCotacaoEntidade", "validadeCotacaoEntidade", "situacaoCotacaoEntidade", "tipoDescontoCotacaoEntidade", "codigoEntidade"};
    private final String[] camposCotacaoMaterialEntidade = new String[]{"valorUnitarioCotacaoMaterialEntidade", "valorDescontoCotacaoMaterialEntidade", "percentualDescontoCotacaoMaterialEntidade", "valorTotalCotacaoMaterialEntidade", "situacaoCotacaoMaterialEntidade", "quantidadeCotacaoMaterialEntidade", "tipoDescontoCotacaoMaterialEntidade"};
    private final String[] camposFormaPagamento = new String[]{"codigoFormaPagamento", "descricaoFormaPagamento"};
    private final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial"};
    private final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private String[] camposRelatorio = null;
    private Integer codigoCotacao = null;

    public RelatorioCotacao(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de cota\u00e7\u00e3o", "Listagem das cota\u00e7\u00f5es dos produtos do vencedor", "relatorios/rel_estoque_cotacao_cotacao.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCotacao", "Cota\u00e7\u00e3o", "cotacao", "", 1, new String[]{"cot_codigo", "cot_observacao"}, new String[]{"C\u00f3digo", "Observa\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_tipo = '" + "F" + "'  and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataCriacaoInicial", "Dt Solicit. Ini:");
        this.adicionaFiltroData("filtroDataCriacaoFinal", "Dt Solicit. Fin:");
        this.adicionaFiltroData("filtroDataAberturaInicial", "Dt Abert. Ini:");
        this.adicionaFiltroData("filtroDataAberturaFinal", "Dt Abert. Fin:");
        this.adicionaFiltroData("filtroDataFechamentoInicial", "Dt Fecha. Ini:");
        this.adicionaFiltroData("filtroDataFechamentoFinal", "Dt Fecha. Fin:");
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", SITUACAO, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", ORDEM, 0);
        this.adicionaFiltroCheck("filtroSomenteVencedor", "Somente Forn. Vencedor", false);
        if (tipoRelatorio == 0) {
            this.setModuloConfigurar(RelatorioCotacao.getModuloConfigurar(0));
            this.setModuloAcesso(RelatorioCotacao.getModuloAcesso(0));
        }
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.camposCotacao);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCotacaoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCotacaoEntidade);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCotacaoMaterialEntidade);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposFormaPagamento);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, this.camposCadastro);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    public void imprimirPressionado(Integer codigoCotacao) {
        this.codigoCotacao = codigoCotacao;
        this.panelCard.setVisible(false);
        this.buttonConfigurar.setVisible(false);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorioCotacao.this.setVisible(false);
                RelatorioCotacao.this.getParent().getParent().getParent().setVisible(false);
            }
        });
        this.imprimirPressionado();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block59: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] entidade;
                String[] usuario;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.cot_codigo as codigoCotacao ");
                buf.append(" \t\t\t,a.usr_codigo as usuarioCotacao ");
                buf.append(" \t\t\t,a.cot_datahora as dataHoraCotacao ");
                buf.append(" \t\t\t,a.cot_situacao as situacaoCotacao ");
                buf.append(" \t\t\t,a.cot_datafechamento as dataFechamentoCotacao ");
                buf.append(" \t\t\t,a.cot_observacao as observacaoCotacao ");
                buf.append(" \t\t\t,a.cot_dataabertura as dataAberturaCotacao ");
                buf.append(" \t\t\t,cma.cma_quantidade as quantidadeCotacaoMaterial ");
                buf.append(" \t\t\t,cte.ent_codigo as codigoEntidade ");
                buf.append(" \t\t\t,cte.cte_total as totalCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_percentualdesconto as percentualDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valordesconto as valorDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_vendedor as vendedorCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_prazoentrega as prazoEntregaCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valorfrete as valorFreteCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_validadecotacao as validadeCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_situacao as situacaoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_tipodesconto as tipoDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cme.cme_valorunitario as valorUnitarioCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valordesconto as valorDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_percentualdesconto as percentualDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valortotal as valorTotalCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_situacao as situacaoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_quantidade as quantidadeCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_tipodesconto as tipoDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,fpg.fpg_codigo as codigoFormaPagamento ");
                buf.append(" \t\t\t,fpg.fpg_descricao as descricaoFormaPagamento ");
                buf.append(" \t\t\t,mat.mat_codigo as codigoMaterial ");
                buf.append(" \t\t\t,mat.mat_descricao as descricaoMaterial ");
                buf.append(" \t\t\t,mat.mat_valorultcompra as valorUltimaCompraMaterial ");
                buf.append(" \t\t\t,mat.mat_dataultcompra as dataUltimaCompraMaterial ");
                buf.append(" \t\t\t,unm.unm_codigo as codigoUnidadeMedida ");
                buf.append(" \t\t\t,unm.unm_descricao as descricaoUnidadeMedida ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from cotacao a ");
                buf.append("  left join cotacaomaterial cma on (a.fil_codigo = cma.fil_codigo and a.cot_codigo = cma.cot_codigo) ");
                buf.append("  left join cotacaoentidade cte on (a.fil_codigo = cte.fil_codigo and a.cot_codigo = cte.cot_codigo) ");
                buf.append("  left join cotacaomaterialentidade cme on (a.fil_codigo = cme.fil_codigo and a.cot_codigo = cme.cot_codigo ");
                buf.append("                                            and cma.mat_codigo = cme.mat_codigo and cte.ent_codigo = cme.ent_codigo) ");
                buf.append("  left join formapagto fpg on (cte.fil_codigo = fpg.fil_codigo and cte.fpg_codigo = fpg.fpg_codigo) ");
                buf.append("  left join material mat on (cma.fil_codigo = mat.fil_codigo and cma.mat_codigo = mat.mat_codigo) ");
                buf.append("  left join unidademedida unm on (mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                String[] cotacao = this.getSelecionadosFiltro("filtroCotacao", 0);
                if (cotacao != null) {
                    buf.append(" and a.cot_codigo in (");
                    for (int i = 0; i < cotacao.length; ++i) {
                        buf.append("'");
                        buf.append(cotacao[i]);
                        buf.append("'");
                        if (i >= cotacao.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    buf.append(" and cte.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        buf.append("'");
                        buf.append(entidade[i]);
                        buf.append("'");
                        if (i >= entidade.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataCriacaoInicial"))) {
                    buf.append(" and cast(a.cot_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataCriacaoInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataCriacaoFinal"))) {
                    buf.append(" and cast(a.cot_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataCriacaoFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFechamentoInicial"))) {
                    buf.append(" and cast(a.cot_datafechamento as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFechamentoInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFechamentoFinal"))) {
                    buf.append(" and cast(a.cot_datafechamento as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFechamentoFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataAberturaInicial"))) {
                    buf.append(" and cast(a.cot_dataabertura as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataAberturaInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataAberturaFinal"))) {
                    buf.append(" and cast(a.cot_dataabertura as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataAberturaFinal")));
                    buf.append("'");
                }
                if (this.codigoCotacao == null && !Funcoes.textoVazio((String)this.getFiltroCombo("filtroSituacao"))) {
                    if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[1])) {
                        buf.append(" and a.cot_situacao = '").append("S").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[2])) {
                        buf.append(" and a.cot_situacao = '").append("A").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[3])) {
                        buf.append(" and a.cot_situacao = '").append("F").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[4])) {
                        buf.append(" and a.cot_situacao = '").append("C").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(SITUACAO[5])) {
                        buf.append(" and a.cot_situacao <> '").append("C").append("' ");
                    }
                }
                if (this.getFiltroCheck("filtroSomenteVencedor")) {
                    buf.append(" and a.cot_situacao = '").append("F").append("' ");
                    buf.append(" and cte.cte_situacao = '").append("V").append("' ");
                }
                if (this.codigoCotacao != null) {
                    buf.append(" and a.cot_codigo = ").append(this.codigoCotacao);
                    buf.append(" and cte.cte_situacao = '").append("V").append("' ");
                }
                buf.append(" order by a.fil_codigo ");
                if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[0])) {
                    buf.append(", a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[1])) {
                    buf.append(", a.usr_codigo, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[2])) {
                    buf.append(", a.cot_datahora, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[3])) {
                    buf.append(", a.cot_dataabertura, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[4])) {
                    buf.append(", a.cot_datafechamento, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(ORDEM[5])) {
                    buf.append(", a.cot_situacao, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        Object[] o = new Object[this.camposRelatorio.length];
                        for (int i = 0; i < this.camposRelatorio.length; ++i) {
                            if (this.camposRelatorio[i].equals("situacaoCotacao")) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoCotacao(rs.getString(this.camposRelatorio[i]));
                                continue;
                            }
                            if (this.camposRelatorio[i].equals("situacaoCotacaoEntidade")) {
                                if (rs.getString(this.camposRelatorio[i]) == null) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoSituacaoFornecedorCotacao(rs.getString(this.camposRelatorio[i]));
                                continue;
                            }
                            if (this.camposRelatorio[i].equals("tipoDescontoCotacaoEntidade") || this.camposRelatorio[i].equals("tipoDescontoCotacaoMaterialEntidade")) {
                                if (rs.getString(this.camposRelatorio[i]) == null) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoDesconto(rs.getString(this.camposRelatorio[i]));
                                continue;
                            }
                            if (this.camposRelatorio[i].equals("situacaoCotacaoMaterialEntidade")) {
                                if (rs.getString(this.camposRelatorio[i]) == null) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.situacaoMaterialFornecedor(rs.getString(this.camposRelatorio[i]));
                                continue;
                            }
                            if (ArraysUtil.contem(this.camposCadastro, this.camposRelatorio[i])) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                        }
                        this.pegaDadosCadastro(st2, o, modelo, rs.getInt("codigoFilial"), rs.getInt("codigoEntidade"));
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(RelatorioCotacao.getModuloAcesso(0));
                    }
                    if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioCotacao.this.panelCentro.removeAll();
                                RelatorioCotacao.this.panelCentro.repaint();
                                RelatorioCotacao.this.habilitaBotaoImprimir(true);
                                if (RelatorioCotacao.this.codigoCotacao != null) {
                                    RelatorioCotacao.this.getParent().getParent().getParent().setVisible(false);
                                }
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroDataCriacaoInicial", this.getFiltroData("filtroDataCriacaoInicial"));
                        var.put("filtroDataCriacaoFinal", this.getFiltroData("filtroDataCriacaoFinal"));
                        var.put("filtroDataAberturaInicial", this.getFiltroData("filtroDataAberturaInicial"));
                        var.put("filtroDataAberturaFinal", this.getFiltroData("filtroDataAberturaFinal"));
                        var.put("filtroDataFechamentoInicial", this.getFiltroData("filtroDataFechamentoInicial"));
                        var.put("filtroDataFechamentoFinal", this.getFiltroData("filtroDataFechamentoFinal"));
                        var.put("filtroSomenteVencedor", this.getFiltroCheck("filtroSomenteVencedor") ? "Sim" : "N\u00e3o");
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (cotacao != null) {
                            for (i = 0; i < cotacao.length; ++i) {
                                buf.append(cotacao[i]);
                                if (i >= cotacao.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroCotacao", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block59;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModeloGridTable getModeloDados(Statement st, String cotacao, String entidade) {
        ModeloGridTable modelo;
        Statement st2;
        block13: {
            if (Funcoes.textoVazio(cotacao) || Funcoes.textoVazio(entidade)) {
                return null;
            }
            st2 = Conexao.getStatement();
            modelo = new ModeloGridTable(this.camposRelatorio);
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select a.cot_codigo as codigoCotacao ");
                buf.append(" \t\t\t,a.usr_codigo as usuarioCotacao ");
                buf.append(" \t\t\t,a.cot_datahora as dataHoraCotacao ");
                buf.append(" \t\t\t,a.cot_situacao as situacaoCotacao ");
                buf.append(" \t\t\t,a.cot_datafechamento as dataFechamentoCotacao ");
                buf.append(" \t\t\t,a.cot_observacao as observacaoCotacao ");
                buf.append(" \t\t\t,a.cot_dataabertura as dataAberturaCotacao ");
                buf.append(" \t\t\t,cma.cma_quantidade as quantidadeCotacaoMaterial ");
                buf.append(" \t\t\t,cte.ent_codigo as codigoEntidade ");
                buf.append(" \t\t\t,cte.cte_total as totalCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_percentualdesconto as percentualDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valordesconto as valorDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_vendedor as vendedorCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_prazoentrega as prazoEntregaCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_valorfrete as valorFreteCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_validadecotacao as validadeCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_situacao as situacaoCotacaoEntidade ");
                buf.append(" \t\t\t,cte.cte_tipodesconto as tipoDescontoCotacaoEntidade ");
                buf.append(" \t\t\t,cme.cme_valorunitario as valorUnitarioCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valordesconto as valorDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_percentualdesconto as percentualDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_valortotal as valorTotalCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_situacao as situacaoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_quantidade as quantidadeCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,cme.cme_tipodesconto as tipoDescontoCotacaoMaterialEntidade ");
                buf.append(" \t\t\t,fpg.fpg_codigo as codigoFormaPagamento ");
                buf.append(" \t\t\t,fpg.fpg_descricao as descricaoFormaPagamento ");
                buf.append(" \t\t\t,mat.mat_codigo as codigoMaterial ");
                buf.append(" \t\t\t,mat.mat_descricao as descricaoMaterial ");
                buf.append(" \t\t\t,mat.mat_valorultcompra as valorUltimaCompraMaterial ");
                buf.append(" \t\t\t,mat.mat_dataultcompra as dataUltimaCompraMaterial ");
                buf.append(" \t\t\t,unm.unm_codigo as codigoUnidadeMedida ");
                buf.append(" \t\t\t,unm.unm_descricao as descricaoUnidadeMedida ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from cotacao a ");
                buf.append("  left join cotacaomaterial cma on (a.fil_codigo = cma.fil_codigo and a.cot_codigo = cma.cot_codigo) ");
                buf.append("  left join cotacaoentidade cte on (a.fil_codigo = cte.fil_codigo and a.cot_codigo = cte.cot_codigo) ");
                buf.append("  left join cotacaomaterialentidade cme on (a.fil_codigo = cme.fil_codigo and a.cot_codigo = cme.cot_codigo ");
                buf.append("                                            and cma.mat_codigo = cme.mat_codigo and cte.ent_codigo = cme.ent_codigo) ");
                buf.append("  left join formapagto fpg on (cte.fil_codigo = fpg.fil_codigo and cte.fpg_codigo = fpg.fpg_codigo) ");
                buf.append("  left join material mat on (cma.fil_codigo = mat.fil_codigo and cma.mat_codigo = mat.mat_codigo) ");
                buf.append("  left join unidademedida unm on (mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                if (cotacao != null) {
                    buf.append(" and a.cot_codigo in (").append(cotacao).append(")");
                }
                if (entidade != null) {
                    buf.append(" and cte.ent_codigo in (").append(entidade).append(")");
                }
                buf.append(" order by a.fil_codigo, a.cot_codigo, cte.ent_codigo, cma.mat_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block13;
                do {
                    Object[] o = new Object[this.camposRelatorio.length];
                    for (int i = 0; i < this.camposRelatorio.length; ++i) {
                        if (this.camposRelatorio[i].equals("situacaoCotacao")) {
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoCotacao(rs.getString(this.camposRelatorio[i]));
                            continue;
                        }
                        if (this.camposRelatorio[i].equals("situacaoCotacaoEntidade")) {
                            if (rs.getString(this.camposRelatorio[i]) == null) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoSituacaoFornecedorCotacao(rs.getString(this.camposRelatorio[i]));
                            continue;
                        }
                        if (this.camposRelatorio[i].equals("tipoDescontoCotacaoEntidade") || this.camposRelatorio[i].equals("tipoDescontoCotacaoMaterialEntidade")) {
                            if (rs.getString(this.camposRelatorio[i]) == null) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoDesconto(rs.getString(this.camposRelatorio[i]));
                            continue;
                        }
                        if (this.camposRelatorio[i].equals("situacaoCotacaoMaterialEntidade")) {
                            if (rs.getString(this.camposRelatorio[i]) == null) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.situacaoMaterialFornecedor(rs.getString(this.camposRelatorio[i]));
                            continue;
                        }
                        if (ArraysUtil.contem(this.camposCadastro, this.camposRelatorio[i])) continue;
                        o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                    }
                    this.pegaDadosCadastro(st2, o, modelo, rs.getInt("codigoFilial"), rs.getInt("codigoEntidade"));
                    modelo.addLine(o);
                } while (rs.next());
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st2);
            }
        }
        Conexao.fecharStatement(st2);
        return modelo;
    }

    public String getXMLRelatorio(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioCotacao.getModuloAcesso(this.tipoRelatorio));
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return "";
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0800800100");
        }
        return Long.parseLong("0800800100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0800800101");
        }
        return Long.parseLong("0800800101");
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("ent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
        buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
        buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro, ent.ent_cpfcnpj as cnpjCpfCadastro, ent.ent_rgie as ieRgCadastro ");
        buf.append("from entidade ent ");
        buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
        buf.append("where ent.fil_codigo = ").append(filial);
        buf.append(" and ent.ent_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        int pos = -1;
        if (rs.next()) {
            for (String s : this.camposCadastro) {
                if (rs.findColumn(s) <= 0 || (pos = modelo.findColumn(s)) <= -1) continue;
                if (modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro")) {
                    array[pos] = Tipos.tipoLogradouroDescricao(rs.getString(modelo.getColumnName(pos)));
                    continue;
                }
                array[modelo.findColumn((String)s)] = rs.getObject(s);
            }
        }
    }
}

