/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado.relatoriotransferenciaestoquesdetalhado;

import jalis.laboratorio.relatorios.estoque.almoxarifado.relatoriotransferenciaestoquesdetalhado.RelatorioTransferenciaEstoqueDetalhadoDao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.util.ArraysUtil;
import jalis.util.ModeloGridTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelatorioTransferenciaEstoqueDetalhadoService {
    private final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoMaterial", "descricaoMaterial", "observacaoMaterial", "inativoMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "codigoCelulaDestino", "codigoCelulaOrigem", "descricaoCelulaDestino", "descricaoCelulaOrigem", "inativaCelulaOrigem", "inativaCelulaDestino", "baixaAutomaticaCelulaDestino", "baixaAutomaticaCelulaOrigem", "codigoTransferencia", "dataHoraTransferencia", "codigoUsuarioTransferencia", "quantidadeTransferencia", "totalPeps", "totalUeps", "totalCmc", "quantidadeTransferenciaLote", "codigoLote", "numeroLote", "dataLote", "validadeLote"});
    private final RelatorioTransferenciaEstoqueDetalhadoDao dao = new RelatorioTransferenciaEstoqueDetalhadoDao();
    private String[] filiaisSelecionadas;
    private String[] celulasOrigemSelecionadas;
    private String[] celulasDestinoSelecionadas;
    private String[] materiaisSelecionados;
    private String[] tiposMateriaisSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;
    private ModeloGridTable modelo;

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        return this.dao.getLayoutRelatorio(codigoModuloAcesso);
    }

    public boolean modeloPreenchido() throws SQLException {
        this.definirFiltrosSelecionadosPeloUsuario();
        this.modelo = new ModeloGridTable(this.campos);
        ResultSet resultadoConsulta = this.dao.recuperarDados();
        HashMap<Integer, List<Integer>> adicionados = new HashMap<Integer, List<Integer>>();
        if (resultadoConsulta.next()) {
            do {
                adicionados.putAll(this.converterRegistroParaModelo(resultadoConsulta, adicionados));
            } while (resultadoConsulta.next());
            return true;
        }
        return false;
    }

    private Map<Integer, List<Integer>> converterRegistroParaModelo(ResultSet resultadoConsulta, Map<Integer, List<Integer>> codMaterialColumn) throws SQLException {
        Object[] o = new Object[this.campos.length];
        for (int i = 0; i < this.campos.length; ++i) {
            o[this.modelo.findColumn((String)this.campos[i])] = resultadoConsulta.getObject(this.campos[i]);
        }
        if (!codMaterialColumn.isEmpty() && codMaterialColumn.containsKey(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoTransferencia")))) {
            if (codMaterialColumn.get(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoTransferencia"))).contains(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoMaterial")))) {
                return codMaterialColumn;
            }
            if (codMaterialColumn.containsKey(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoTransferencia"))) && codMaterialColumn.get(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoTransferencia"))).contains(resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoMaterial")))) {
                return codMaterialColumn;
            }
        }
        codMaterialColumn.put((Integer)resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoTransferencia")), Arrays.asList((Integer)resultadoConsulta.getObject(resultadoConsulta.findColumn("codigoMaterial"))));
        this.modelo.addLine(o);
        return codMaterialColumn;
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.dao.setCelulasDestinoSelecionadas(this.celulasDestinoSelecionadas);
        this.dao.setCelulasOrigemSelecionadas(this.celulasOrigemSelecionadas);
        this.dao.setDataFinalInformada(this.dataFinalInformada);
        this.dao.setDataInicialInformada(this.dataInicialInformada);
        this.dao.setFiliaisSelecionadas(this.filiaisSelecionadas);
        this.dao.setMateriaisSelecionados(this.materiaisSelecionados);
        this.dao.setTiposMateriaisSelecionados(this.tiposMateriaisSelecionados);
    }

    public String[] getCampos() {
        return this.campos;
    }

    public String[] getFiliaisSelecionadas() {
        return this.filiaisSelecionadas;
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public String[] getCelulasOrigemSelecionadas() {
        return this.celulasOrigemSelecionadas;
    }

    public void setCelulasOrigemSelecionadas(String[] celulasOrigemSelecionadas) {
        this.celulasOrigemSelecionadas = celulasOrigemSelecionadas;
    }

    public String[] getCelulasDestinoSelecionadas() {
        return this.celulasDestinoSelecionadas;
    }

    public void setCelulasDestinoSelecionadas(String[] celulasDestinoSelecionadas) {
        this.celulasDestinoSelecionadas = celulasDestinoSelecionadas;
    }

    public String[] getMateriaisSelecionados() {
        return this.materiaisSelecionados;
    }

    public void setMateriaisSelecionados(String[] materiaisSelecionados) {
        this.materiaisSelecionados = materiaisSelecionados;
    }

    public String[] getTiposMateriaisSelecionados() {
        return this.tiposMateriaisSelecionados;
    }

    public void setTiposMateriaisSelecionados(String[] tiposMateriaisSelecionados) {
        this.tiposMateriaisSelecionados = tiposMateriaisSelecionados;
    }

    public String getDataInicialInformada() {
        return this.dataInicialInformada;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public String getDataFinalInformada() {
        return this.dataFinalInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }

    public ModeloGridTable getModelo() {
        return this.modelo;
    }
}

