/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado.relatoriotransferenciaestoquesdetalhado;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RelatorioTransferenciaEstoqueDetalhadoDao {
    private String[] filiaisSelecionadas;
    private String[] celulasOrigemSelecionadas;
    private String[] celulasDestinoSelecionadas;
    private String[] materiaisSelecionados;
    private String[] tiposMateriaisSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(codigoModuloAcesso);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    public ResultSet recuperarDados() throws SQLException {
        Statement st = Conexao.getStatement();
        return Conexao.executeQuery(st, this.getSqlRelatorio());
    }

    private String getSqlRelatorio() {
        StringBuilder sqlRelatorio = new StringBuilder();
        sqlRelatorio.append(this.getSqlSelect());
        sqlRelatorio.append(this.getSqlFrom());
        sqlRelatorio.append(this.getSqlWhere());
        sqlRelatorio.append(this.getSqlGroupBy());
        sqlRelatorio.append(this.getSqlOrderBy());
        return sqlRelatorio.toString();
    }

    private String getSqlSelect() {
        StringBuilder sqlSelect = new StringBuilder("select ");
        sqlSelect.append("a.tra_codigo as codigoTransferencia, ");
        sqlSelect.append("a.tra_datahora as dataHoraTransferencia, ");
        sqlSelect.append("a.usr_codigo as codigoUsuarioTransferencia, ");
        sqlSelect.append("a.cel_codorigem as codigoCelulaOrigem, ");
        sqlSelect.append("a.cel_coddestino as codigoCelulaDestino, ");
        sqlSelect.append("trm.trm_quantidade as quantidadeTransferencia, ");
        sqlSelect.append("celorigem.cel_descricao as descricaoCelulaOrigem, ");
        sqlSelect.append("celorigem.cel_inativa as inativaCelulaOrigem, ");
        sqlSelect.append("celorigem.cel_baixarautomatico as baixaAutomaticaCelulaOrigem, ");
        sqlSelect.append("celdestino.cel_descricao as descricaoCelulaDestino, ");
        sqlSelect.append("celdestino.cel_inativa as inativaCelulaDestino, ");
        sqlSelect.append("celdestino.cel_baixarautomatico as baixaAutomaticaCelulaDestino, ");
        sqlSelect.append("mat.mat_codigo as codigoMaterial, ");
        sqlSelect.append("mat.mat_descricao as descricaoMaterial, ");
        sqlSelect.append("mat.mat_inativo as inativoMaterial, ");
        sqlSelect.append("mat.mat_observacao as observacaoMaterial, ");
        sqlSelect.append("tpm.tpm_codigo as codigoTipoMaterial, ");
        sqlSelect.append("tpm.tpm_descricao as descricaoTipoMaterial, ");
        sqlSelect.append("unm.unm_codigo as codigoUnidadeMedida, ");
        sqlSelect.append("unm.unm_descricao as descricaoUnidadeMedida, ");
        sqlSelect.append("mat.mat_valorultcompra as valorUltimaCompraMaterial, ");
        sqlSelect.append("mat.mat_dataultcompra as dataUltimaCompraMaterial, ");
        sqlSelect.append("saldoest.sde_totalpeps as totalpeps, ");
        sqlSelect.append("saldoest.sde_totalueps as totalueps, ");
        sqlSelect.append("saldoest.sde_totalcmc as totalcmc, ");
        sqlSelect.append("filial.fil_codigo as codigoFilial, ");
        sqlSelect.append("filial.fil_descricao as descricaoFilial, ");
        sqlSelect.append("filial.fil_cnpj as cnpjFilial, ");
        sqlSelect.append("filial.fil_endereco as enderecoFilial, ");
        sqlSelect.append("filial.fil_complemento as complementoFilial, ");
        sqlSelect.append("filial.fil_cep as cepFilial, ");
        sqlSelect.append("filial.fil_fone as foneFilial, ");
        sqlSelect.append("filial.fil_fax as faxFilial, ");
        sqlSelect.append("filial.fil_razaosocial as razaoSocialFilial, ");
        sqlSelect.append("filial.fil_cnes as CNESFilial, ");
        sqlSelect.append("cidadefilial.cid_codigo as codigoCidadeFilial, ");
        sqlSelect.append("cidadefilial.cid_nome as descricaoCidadeFilial, ");
        sqlSelect.append("cidadefilial.cid_uf as estadoCidadeFilial, ");
        sqlSelect.append("bairrofilial.bai_codigo as codigoBairroFilial, ");
        sqlSelect.append("bairrofilial.bai_descricao as descricaoBairroFilial, ");
        sqlSelect.append("matlotelctoest.mll_quantidade as quantidadeTransferenciaLote, ");
        sqlSelect.append("matlotelctoest.mll_codigo as codigoLote, ");
        sqlSelect.append("matlote.mll_lote as numeroLote, ");
        sqlSelect.append("matlote.mll_datalote as dataLote, ");
        sqlSelect.append("matlote.mll_validadelote as validadeLote ");
        return sqlSelect.toString();
    }

    private String getSqlFrom() {
        StringBuilder sqlFrom = new StringBuilder(" from ");
        sqlFrom.append("transfestoque a ");
        sqlFrom.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        sqlFrom.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
        sqlFrom.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sqlFrom.append("left join transfestoquematerial trm on a.fil_codigo = trm.fil_codigo and a.tra_codigo = trm.tra_codigo ");
        sqlFrom.append("left join celulaestoque celorigem on a.fil_codigo = celorigem.fil_codigo and a.cel_codorigem = celorigem.cel_codigo ");
        sqlFrom.append("left join celulaestoque celdestino on a.fil_codigo = celdestino.fil_codigo and a.cel_coddestino = celdestino.cel_codigo ");
        sqlFrom.append("left join material mat on trm.fil_codigo = mat.fil_codigo and trm.mat_codigo = mat.mat_codigo ");
        sqlFrom.append("left join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
        sqlFrom.append("left join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
        sqlFrom.append("left join saldoestoque saldoest on ( mat.fil_codigo = saldoest.fil_codigo and mat.mat_codigo = saldoest.mat_codigo ) and ( saldoest.sde_data = ( select MAX(sde_data) from saldoestoque se where mat.fil_codigo = se.fil_codigo and mat.mat_codigo = se.mat_codigo )) ");
        sqlFrom.append("left join transfestoquelanctoestoque transfestlctoest on transfestlctoest.fil_codigo = a.fil_codigo and transfestlctoest.tra_codigo = a.tra_codigo ");
        sqlFrom.append("left join materiallotelanctoestoque matlotelctoest on matlotelctoest.fil_codigo = transfestlctoest.fil_codigo and matlotelctoest.lce_codigo = transfestlctoest.lce_codigo ");
        sqlFrom.append("left join materiallote matlote on matlote.fil_codigo = matlotelctoest.fil_codigo and matlote.mll_codigo = matlotelctoest.mll_codigo and matlote.mll_quantidade = matlotelctoest.mll_quantidade and matlote.usr_codigo = a.usr_codigo and matlote.mat_codigo = trm.mat_codigo ");
        return sqlFrom.toString();
    }

    private String getSqlWhere() {
        StringBuilder sqlWhere = new StringBuilder(" where ");
        sqlWhere.append(this.filialIn());
        sqlWhere.append(this.celulaOrigemIn());
        sqlWhere.append(this.celulaDestinoIn());
        sqlWhere.append(this.materialIn());
        sqlWhere.append(this.tipoMaterialIn());
        sqlWhere.append(this.dataBetween());
        sqlWhere.append("and trm.trm_datacancelamento IS NULL ");
        sqlWhere.append("and a.tra_datacancelamento IS NULL ");
        sqlWhere.append("and (matlotelctoest.mll_quantidade is not null or trm.trm_quantidade is not null) ");
        sqlWhere.append("and ((matlotelctoest.mll_quantidade IS NULL AND matlote.mll_codigo IS NULL) OR (matlotelctoest.mll_quantidade IS NOT NULL AND matlote.mll_lote IS NOT NULL)) ");
        return sqlWhere.toString();
    }

    private String filialIn() {
        StringBuilder filialIn = new StringBuilder("filial.fil_codigo in(");
        if (this.filiaisSelecionadas == null || this.filiaisSelecionadas.length <= 0) {
            this.filiaisSelecionadas = new String[]{Variaveis.filialPadrao};
        }
        filialIn.append(this.getCondicoesIntegerIn(this.filiaisSelecionadas));
        return filialIn.toString();
    }

    private String celulaOrigemIn() {
        StringBuilder celulaOrigemIn = new StringBuilder();
        if (this.celulasOrigemSelecionadas != null && this.celulasOrigemSelecionadas.length > 0) {
            celulaOrigemIn.append("and a.cel_codorigem in (");
            celulaOrigemIn.append(this.getCondicoesIntegerIn(this.celulasOrigemSelecionadas));
        }
        return celulaOrigemIn.toString();
    }

    private String celulaDestinoIn() {
        StringBuilder celulaDestinoIn = new StringBuilder();
        if (this.celulasDestinoSelecionadas != null && this.celulasDestinoSelecionadas.length > 0) {
            celulaDestinoIn.append("and a.cel_coddestino in (");
            celulaDestinoIn.append(this.getCondicoesIntegerIn(this.celulasDestinoSelecionadas));
        }
        return celulaDestinoIn.toString();
    }

    private String materialIn() {
        StringBuilder materialIn = new StringBuilder();
        if (this.materiaisSelecionados != null && this.materiaisSelecionados.length > 0) {
            materialIn.append("and mat.mat_codigo in (");
            materialIn.append(this.getCondicoesIntegerIn(this.materiaisSelecionados));
        }
        return materialIn.toString();
    }

    private String tipoMaterialIn() {
        StringBuilder tipoMaterialIn = new StringBuilder();
        if (this.tiposMateriaisSelecionados != null && this.tiposMateriaisSelecionados.length > 0) {
            tipoMaterialIn.append("and tpm.tpm_codigo in (");
            tipoMaterialIn.append(this.getCondicoesIntegerIn(this.tiposMateriaisSelecionados));
        }
        return tipoMaterialIn.toString();
    }

    private String dataBetween() {
        StringBuilder data = new StringBuilder();
        if (!Funcoes.textoVazio(this.dataInicialInformada) && Funcoes.verificaData(this.dataInicialInformada)) {
            data.append(" and cast(date_trunc('minute',a.tra_datahora) as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialInformada)).append("'");
        }
        if (!Funcoes.textoVazio(this.dataFinalInformada) && Funcoes.verificaData(this.dataFinalInformada)) {
            data.append(" and cast(date_trunc('minute',a.tra_datahora) as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalInformada)).append("'");
        }
        return data.toString();
    }

    private String getCondicoesIntegerIn(String[] condicoesInteger) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < condicoesInteger.length; ++i) {
            sb.append(condicoesInteger[i]);
            if (i >= condicoesInteger.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getSqlGroupBy() {
        StringBuilder groupBy = new StringBuilder(" group by ");
        groupBy.append("a.tra_codigo, a.tra_datahora, a.usr_codigo, a.cel_codorigem, a.cel_coddestino, trm.trm_quantidade, celorigem.cel_descricao, ");
        groupBy.append("celorigem.cel_inativa, celorigem.cel_baixarautomatico, celdestino.cel_descricao, celdestino.cel_inativa, celdestino.cel_baixarautomatico, ");
        groupBy.append("mat.mat_codigo, mat.mat_descricao, mat.mat_inativo, mat.mat_observacao, tpm.tpm_codigo, tpm.tpm_descricao, unm.unm_codigo, ");
        groupBy.append("unm.unm_descricao, mat.mat_valorultcompra, mat.mat_dataultcompra, saldoest.sde_totalpeps, saldoest.sde_totalueps, saldoest.sde_totalcmc, ");
        groupBy.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
        groupBy.append("filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome,cidadefilial.cid_uf, ");
        groupBy.append("bairrofilial.bai_codigo, bairrofilial.bai_descricao, matlotelctoest.mll_quantidade, matlotelctoest.mll_codigo,matlote.mll_lote, ");
        groupBy.append("matlote.mll_datalote, matlote.mll_validadelote ");
        return groupBy.toString();
    }

    private String getSqlOrderBy() {
        StringBuilder orderBy = new StringBuilder("order by ");
        orderBy.append("filial.fil_codigo, a.tra_codigo, mat.mat_codigo ");
        return orderBy.toString();
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public void setCelulasOrigemSelecionadas(String[] celulasOrigemSelecionadas) {
        this.celulasOrigemSelecionadas = celulasOrigemSelecionadas;
    }

    public void setCelulasDestinoSelecionadas(String[] celulasDestinoSelecionadas) {
        this.celulasDestinoSelecionadas = celulasDestinoSelecionadas;
    }

    public void setMateriaisSelecionados(String[] materiaisSelecionados) {
        this.materiaisSelecionados = materiaisSelecionados;
    }

    public void setTiposMateriaisSelecionados(String[] tiposMateriaisSelecionados) {
        this.tiposMateriaisSelecionados = tiposMateriaisSelecionados;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }
}

