/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado.relatoriotransferenciaestoquesdetalhado;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.estoque.almoxarifado.relatoriotransferenciaestoquesdetalhado.RelatorioTransferenciaEstoqueDetalhadoService;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioTransferenciaEstoqueDetalhado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String RELATORIO_ICONE = "relatorios/rel_transf_estoque_detalhado.jpg";
    private static final String RELATORIO_DESCRITIVO = "Listagem de transfer\u00eancia entre estoques detalhado por lotes do material";
    private static final String RELATORIO_TITULO = "Relat\u00f3rio de Transfer\u00eancia entre estoques detalhado";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CELULA_ORIGEM = "filtroCelulaOrigem";
    private static final String FILTRO_CELULA_DESTINO = "filtroCelulaDestino";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final long MODULO_ACESSO_CODIGO = Long.parseLong("0801001800");
    private static final long MODULO_CONFIGURAR_CODIGO = Long.parseLong("0801001801");
    private final RelatorioTransferenciaEstoqueDetalhadoService service = new RelatorioTransferenciaEstoqueDetalhadoService();

    public RelatorioTransferenciaEstoqueDetalhado() {
        this.montaBarraDescricao(RELATORIO_TITULO, RELATORIO_DESCRITIVO, RELATORIO_ICONE);
        this.adicionaRelatorioListener(this);
        this.adicionarFiltros();
        this.adicionarFiltrosPorData();
        this.setModuloConfigurar(RelatorioTransferenciaEstoqueDetalhado.getModuloConfigurar());
        this.setModuloAcesso(RelatorioTransferenciaEstoqueDetalhado.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    private void adicionarFiltros() {
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CELULA_ORIGEM, "C\u00e9lula Origem", "celulaestoque", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa", "Padr\u00e3o"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_CELULA_DESTINO, "C\u00e9lula Destino", "celulaestoque", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa", "Padr\u00e3o"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
    }

    private void adicionarFiltrosPorData() {
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
    }

    @Override
    public void imprimirPressionado() {
        try {
            this.definirFiltrosSelecionadosPeloUsuario();
            if (Funcoes.textoVazio(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO))) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.service.modeloPreenchido()) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.gerarRelatorio();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.service.setCelulasDestinoSelecionadas(this.getSelecionadosFiltro(FILTRO_CELULA_DESTINO, 0));
        this.service.setCelulasOrigemSelecionadas(this.getSelecionadosFiltro(FILTRO_CELULA_ORIGEM, 0));
        this.service.setDataFinalInformada(this.getFiltroData(FILTRO_DATA_FINAL));
        this.service.setDataInicialInformada(this.getFiltroData(FILTRO_DATA_INICIAL));
        this.service.setFiliaisSelecionadas(this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
        this.service.setMateriaisSelecionados(this.getSelecionadosFiltro(FILTRO_MATERIAL, 0));
        this.service.setTiposMateriaisSelecionados(this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0));
    }

    private void gerarRelatorio() throws SQLException {
        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
        gerador.setPai(this.panelCentro);
        gerador.setPreVisualizar(true);
        gerador.setZoomPreVisualizar(0.5f);
        gerador.setAcaoFechar(new Runnable(){

            @Override
            public void run() {
                RelatorioTransferenciaEstoqueDetalhado.this.panelCentro.removeAll();
                RelatorioTransferenciaEstoqueDetalhado.this.panelCentro.repaint();
                RelatorioTransferenciaEstoqueDetalhado.this.habilitaBotaoImprimir(true);
            }
        });
        gerador.executar(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO), (TableModel)this.service.getModelo(), this.adicionarVariaveisAoRelatorio());
        this.panelCentro.revalidate();
    }

    private Map<String, Object> adicionarVariaveisAoRelatorio() {
        HashMap<String, Object> variaveis = new HashMap<String, Object>();
        variaveis.put(FILTRO_FILIAL, this.getValoresSelecionados(this.service.getFiliaisSelecionadas()));
        variaveis.put(FILTRO_CELULA_ORIGEM, this.getValoresSelecionados(this.service.getCelulasOrigemSelecionadas()));
        variaveis.put(FILTRO_CELULA_DESTINO, this.getValoresSelecionados(this.service.getCelulasDestinoSelecionadas()));
        variaveis.put(FILTRO_MATERIAL, this.getValoresSelecionados(this.service.getMateriaisSelecionados()));
        variaveis.put(FILTRO_TIPO_MATERIAL, this.getValoresSelecionados(this.service.getTiposMateriaisSelecionados()));
        variaveis.put(FILTRO_DATA_FINAL, this.service.getDataFinalInformada());
        variaveis.put(FILTRO_DATA_INICIAL, this.service.getDataInicialInformada());
        return variaveis;
    }

    private String getValoresSelecionados(String[] selecionados) {
        StringBuilder sb = new StringBuilder();
        if (selecionados != null && selecionados.length > 0) {
            for (int i = 0; i < selecionados.length; ++i) {
                sb.append(selecionados[i]);
                if (i >= selecionados.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static long getModuloAcesso() {
        return MODULO_ACESSO_CODIGO;
    }

    public static long getModuloConfigurar() {
        return MODULO_CONFIGURAR_CODIGO;
    }
}

