/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioTransferenciaEstoqueMaterial
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final String FILTRO_FILIAL = "filtroFilial";
    public static final String FILTRO_CELULA_ORIGEM = "filtroCelulaOrigem";
    public static final String FILTRO_CELULA_DESTINO = "filtroCelulaDestino";
    public static final String FILTRO_MATERIAL = "filtroMaterial";
    public static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    public static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    public static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    protected static String[] campos = null;
    public static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "observacaoMaterial", "inativoMaterial", "codigoUnidadeMedida", "descricaoUnidadeMedida"};
    public static final String[] camposCelula = new String[]{"codigoCelulaDestino", "codigoCelulaOrigem", "descricaoCelulaDestino", "descricaoCelulaOrigem", "inativaCelulaOrigem", "inativaCelulaDestino", "baixaAutomaticaCelulaDestino", "baixaAutomaticaCelulaOrigem"};
    public static final String[] camposTransferenciaEstoque = new String[]{"codigoTransferencia", "dataHoraTransferencia", "codigoUsuarioTransferencia", "quantidadeTransferencia"};
    public static final String[] camposSaldoEstoque = new String[]{"totalPeps", "totalUeps", "totalCmc"};

    public RelatorioTransferenciaEstoqueMaterial() {
        this.montaBarraDescricao("Relat\u00f3rio de transfer\u00eancia entre estoques por material", "Listagem de transfer\u00eancia entre estoques", "relatorios/rel_estoque_almoxarifado_transf_estoque_material.jpg");
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CELULA_ORIGEM, "C\u00e9lula Origem", "celulaestoque", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa", "Padr\u00e3o"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_CELULA_DESTINO, "C\u00e9lula Destino", "celulaestoque", " fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa", "Padr\u00e3o"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
        this.adicionaRelatorioListener(this);
        this.setModuloAcesso(RelatorioTransferenciaEstoqueMaterial.getModuloAcesso());
        this.setModuloConfigurar(RelatorioTransferenciaEstoqueMaterial.getModuloConfigurar());
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposMaterial);
        campos = ArraysUtil.concatenar(campos, camposCelula);
        campos = ArraysUtil.concatenar(campos, camposTransferenciaEstoque);
        campos = ArraysUtil.concatenar(campos, camposSaldoEstoque);
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        String[] tipoMaterial;
        String[] material;
        String[] celulaDestino;
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("Select ");
        buf.append("  a.tra_codigo as codigoTransferencia, ");
        buf.append("  a.tra_datahora as dataHoraTransferencia, ");
        buf.append("  a.usr_codigo as codigoUsuarioTransferencia, ");
        buf.append("  a.cel_codorigem as codigoCelulaOrigem, ");
        buf.append("  a.cel_coddestino as codigoCelulaDestino,");
        buf.append("  trm.trm_quantidade as quantidadeTransferencia, ");
        buf.append("  celorigem.cel_descricao as descricaoCelulaOrigem, ");
        buf.append("  celorigem.cel_inativa as inativaCelulaOrigem, ");
        buf.append("  celorigem.cel_baixarautomatico as baixaAutomaticaCelulaOrigem, ");
        buf.append("  celdestino.cel_descricao as descricaoCelulaDestino, ");
        buf.append("  celdestino.cel_inativa as inativaCelulaDestino, ");
        buf.append("  celdestino.cel_baixarautomatico as baixaAutomaticaCelulaDestino, ");
        buf.append("  mat.mat_codigo as codigoMaterial, ");
        buf.append("  mat.mat_descricao as descricaoMaterial, ");
        buf.append("  mat.mat_inativo as inativoMaterial, ");
        buf.append("  mat.mat_observacao as observacaoMaterial, ");
        buf.append("  tpm.tpm_codigo as codigoTipoMaterial, ");
        buf.append("  tpm.tpm_descricao as descricaoTipoMaterial, ");
        buf.append("  unm.unm_codigo as codigoUnidadeMedida, ");
        buf.append("  unm.unm_descricao as descricaoUnidadeMedida, ");
        buf.append("  saldoest.sde_totalpeps as totalpeps,");
        buf.append("  saldoest.sde_totalueps as totalueps,");
        buf.append("  saldoest.sde_totalcmc as totalcmc,");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from transfestoque a ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append(" left join transfestoquematerial trm  on a.fil_codigo = trm.fil_codigo and a.tra_codigo = trm.tra_codigo ");
        buf.append(" left join celulaestoque celorigem  \ton a.fil_codigo = celorigem.fil_codigo and a.cel_codorigem = celorigem.cel_codigo ");
        buf.append(" left join celulaestoque celdestino   on a.fil_codigo = celdestino.fil_codigo and a.cel_coddestino = celdestino.cel_codigo ");
        buf.append(" left join material mat on trm.fil_codigo = mat.fil_codigo and trm.mat_codigo = mat.mat_codigo ");
        buf.append(" left join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
        buf.append(" left join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
        buf.append(" left join saldoestoque saldoest on (mat.fil_codigo = saldoest.fil_codigo and mat.mat_codigo = saldoest.mat_codigo) ");
        buf.append(" and (saldoest.sde_data = (select MAX(sde_data) from saldoestoque se where mat.fil_codigo = se.fil_codigo and mat.mat_codigo = se.mat_codigo)) ");
        buf.append("where ");
        String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" filial.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        String[] celulaOrigem = this.getSelecionadosFiltro(FILTRO_CELULA_ORIGEM, 0);
        if (celulaOrigem != null) {
            buf.append(" and a.cel_codorigem in (");
            for (int i = 0; i < celulaOrigem.length; ++i) {
                buf.append(celulaOrigem[i]);
                if (i >= celulaOrigem.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if ((celulaDestino = this.getSelecionadosFiltro(FILTRO_CELULA_DESTINO, 0)) != null) {
            buf.append(" and a.cel_coddestino in (");
            for (int i = 0; i < celulaDestino.length; ++i) {
                buf.append(celulaDestino[i]);
                if (i >= celulaDestino.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if ((material = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0)) != null) {
            buf.append(" and mat.mat_codigo in (");
            for (int i = 0; i < material.length; ++i) {
                buf.append(material[i]);
                if (i >= material.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if ((tipoMaterial = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0)) != null) {
            buf.append(" and tpm.tpm_codigo in (");
            for (int i = 0; i < tipoMaterial.length; ++i) {
                buf.append(tipoMaterial[i]);
                if (i >= tipoMaterial.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            buf.append("  and cast(date_trunc('minute',a.tra_datahora) as date) >= '");
            buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
            buf.append("  and cast(date_trunc('minute',a.tra_datahora) as date) <= '");
            buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData(FILTRO_DATA_FINAL)));
            buf.append("'");
        }
        buf.append(" and trm.trm_datacancelamento IS NULL ");
        buf.append(" and a.tra_datacancelamento IS NULL ");
        buf.append(" group by ").append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append("\t,a.tra_codigo\t\t\t\t\t\t\t\t\t\t\t\t ");
        buf.append(" \t,a.tra_datahora                      ");
        buf.append(" \t,a.usr_codigo                        ");
        buf.append(" \t,a.cel_codorigem                     ");
        buf.append(" \t,a.cel_coddestino                    ");
        buf.append(" \t,trm.trm_quantidade                  ");
        buf.append(" \t,celorigem.cel_descricao             ");
        buf.append(" \t,celorigem.cel_inativa               ");
        buf.append(" \t,celorigem.cel_baixarautomatico      ");
        buf.append(" \t,celdestino.cel_descricao            ");
        buf.append(" \t,celdestino.cel_inativa              ");
        buf.append(" \t,celdestino.cel_baixarautomatico     ");
        buf.append(" \t,mat.mat_codigo                      ");
        buf.append(" \t,mat.mat_descricao                   ");
        buf.append(" \t,mat.mat_inativo                     ");
        buf.append(" \t,mat.mat_observacao                  ");
        buf.append(" \t,tpm.tpm_codigo                      ");
        buf.append(" \t,tpm.tpm_descricao                   ");
        buf.append(" \t,unm.unm_codigo                      ");
        buf.append(" \t,unm.unm_descricao                   ");
        buf.append("  ,saldoest.sde_totalpeps              ");
        buf.append("  ,saldoest.sde_totalueps              ");
        buf.append("  ,saldoest.sde_totalcmc               ");
        buf.append(" order by filial.fil_codigo, mat.mat_codigo, a.tra_codigo");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[modelo.findColumn((String)RelatorioTransferenciaEstoqueMaterial.campos[i])] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioTransferenciaEstoqueMaterial.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioTransferenciaEstoqueMaterial.this.panelCentro.removeAll();
                            RelatorioTransferenciaEstoqueMaterial.this.panelCentro.repaint();
                            RelatorioTransferenciaEstoqueMaterial.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (celulaOrigem != null) {
                        for (i = 0; i < celulaOrigem.length; ++i) {
                            buf.append(celulaOrigem[i]);
                            if (i >= celulaOrigem.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put(FILTRO_CELULA_ORIGEM, buf.toString());
                    buf.delete(0, buf.length());
                    if (celulaDestino != null) {
                        for (i = 0; i < celulaDestino.length; ++i) {
                            buf.append(celulaDestino[i]);
                            if (i >= celulaDestino.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put(FILTRO_CELULA_DESTINO, buf.toString());
                    buf.delete(0, buf.length());
                    if (material != null) {
                        for (i = 0; i < material.length; ++i) {
                            buf.append(material[i]);
                            if (i >= material.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put(FILTRO_MATERIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (tipoMaterial != null) {
                        for (i = 0; i < tipoMaterial.length; ++i) {
                            buf.append(tipoMaterial[i]);
                            if (i >= tipoMaterial.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801001300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801001301");
    }
}

