/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioSaldoEstoqueCelula
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_DATAINICIAL = "filtroDataInicial";
    private final String FILTRO_DATAFINAL = "filtroDataFinal";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CELULA = "filtroCelula";
    private final String FILTRO_SOMENTE_COM_MOVIMENTACAO = "filtroSomenteComMovimentacao";
    private final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposSaldos = new String[]{"dataSaldo", "saldoEstoque", "valorEntrada", "valorSaida", "saldoEstoqueDisponivel", "mensagemSaldo", "mensagemSaldoDisponivel", "valorPeps", "valorUeps", "valorCmc", "valorFinalPeps", "valorFinalUeps", "valorFinalCmc"};
    private static final String[] camposCelula = new String[]{"codigoCelula", "descricaoCelula", "inativaCelula", "padraoCelula", "dataSaldoAnterior", "saldoEstoqueAnterior", "valorEntradaAnterior", "mensagemSaldoAnterior", "valorPepsAnterior", "valorUepsAnterior", "valorCmcAnterior", "valorUnitarioCmc"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposSaldos), ArraysUtil.concatenar(camposCelula, camposMaterial)), camposUnidadeMedida);
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public RelatorioSaldoEstoqueCelula() {
        this.montaBarraDescricao("Relat\u00f3rio de saldo de estoque por c\u00e9lula", "Listagem di\u00e1ria do saldo de estoque de materiais por c\u00e9lula", "relatorios/rel_estoque_almoxarifado_rel_saldo_estoque_por_celula.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCelula", "C\u00e9lula", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa?", "Padr\u00e3o?"}, new int[]{70, 0, 60, 60});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroSomenteComMovimentacao", "Somente com movimento", false);
        this.adicionaFiltroCheck("filtroMaterialInativo", "Mostrar material inativo", false);
        this.setModuloConfigurar(RelatorioSaldoEstoqueCelula.getModuloConfigurar());
        this.setModuloAcesso(RelatorioSaldoEstoqueCelula.getModuloAcesso());
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void imprimirPressionado() {
        filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        codigoFilial = null;
        if (filiais != null) {
            if (filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            codigoFilial = filiais[0];
        } else {
            codigoFilial = Variaveis.filialPadrao;
        }
        celula = this.getSelecionadosFiltro("filtroCelula", 0);
        material = this.getSelecionadosFiltro("filtroMaterial", 0);
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Insira uma data inicial para o relat\u00f3rio", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        somenteComMovimentacao = this.getFiltroCheck("filtroSomenteComMovimentacao");
        this.setCursor(Cursor.getPredefinedCursor(3));
        listaCelulas = new ArrayList<DadosCelula>();
        st = Conexao.getStatement();
        st2 = Conexao.getStatement();
        stCelula = Conexao.getStatement();
        stMaterial = Conexao.getStatement();
        buf = null;
        rs = null;
        try {
            bufAux = new StringBuilder();
            bufAux.append(" select cel.cel_codigo \tas codigoCelula, ");
            bufAux.append("        cel.cel_descricao as descricaoCelula, ");
            bufAux.append("        cel.cel_inativa \tas inativaCelula, ");
            bufAux.append("        cel.cel_padrao \tas padraoCelula ");
            bufAux.append("   from celulaestoque cel ");
            bufAux.append("  where cel.fil_codigo = ").append(Variaveis.filialPadrao);
            if (celula != null) {
                bufAux.append("    and cel.cel_codigo IN (");
                for (i = 0; i < celula.length; ++i) {
                    if (i != celula.length - 1) {
                        bufAux.append(celula[i]).append(", ");
                        continue;
                    }
                    bufAux.append(celula[i]);
                }
                bufAux.append(") ");
            }
            bufAux.append(" order by cel.cel_codigo ");
            rsCelula = Conexao.executeQuery(stCelula, bufAux.toString());
            bufAux.setLength(0);
            bufAux.append(" select a.mat_codigo as codigoMaterial, ");
            bufAux.append("        a.mat_descricao as descricaoMaterial, ");
            bufAux.append("        unm.unm_codigo  as codigoUnidadeMedida, ");
            bufAux.append("        unm.unm_descricao as descricaoUnidadeMedida, ");
            bufAux.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            bufAux.append(" from material a ");
            bufAux.append(" left join unidademedida unm on (a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo) ");
            bufAux.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            bufAux.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            if (material != null) {
                bufAux.append("    and a.mat_codigo IN (");
                for (i = 0; i < material.length; ++i) {
                    if (i != material.length - 1) {
                        bufAux.append(material[i]).append(", ");
                        continue;
                    }
                    bufAux.append(material[i]);
                }
                bufAux.append(") ");
            }
            if (!this.getFiltroCheck("filtroMaterialInativo")) {
                bufAux.append(" and a.mat_inativo = false ");
            }
            bufAux.append(" order by a.mat_codigo ");
            rsFilialMaterial = Conexao.executeQuery(stMaterial, bufAux.toString());
            while (rsCelula.next()) {
                rsFilialMaterial.beforeFirst();
                while (rsFilialMaterial.next()) {
                    if (somenteComMovimentacao && (valores = this.getValorMovimentoCelula(codigoFilial, rsFilialMaterial.getInt("codigoMaterial"), Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataInicial")), Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) == false ? Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataFinal")) : null, rsCelula.getInt("codigoCelula")))[0].compareTo(BigDecimal.ZERO) == 0 && valores[1].compareTo(BigDecimal.ZERO) == 0) continue;
                    dadosCelula = new DadosCelula(rsCelula.getInt("codigoCelula"), rsCelula.getString("descricaoCelula"), rsFilialMaterial.getInt("codigoMaterial"), rsCelula.getBoolean("inativaCelula"), rsCelula.getBoolean("padraoCelula"));
                    bufAnterior = new StringBuilder();
                    bufAnterior.append(" select ces.ces_data as dataAnterior ");
                    bufAnterior.append("       ,ces.ces_saldo as estoqueDisponivelAnterior ");
                    bufAnterior.append("       ,COALESCE(ces.ces_totalpeps, 0) as valorPeps ");
                    bufAnterior.append("       ,COALESCE(ces.ces_totalueps, 0) as valorUeps ");
                    bufAnterior.append("       ,COALESCE(ces.ces_totalcmc, 0) as valorCmc ");
                    bufAnterior.append("   from saldoestoquecelula ces ");
                    bufAnterior.append("  where ces.fil_codigo = ").append(codigoFilial);
                    bufAnterior.append("    and ces.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                    bufAnterior.append("    and ces.ces_data < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                    bufAnterior.append("    and ces.cel_codigo = ").append(dadosCelula.getCodigoCelula());
                    bufAnterior.append("  order by ces.ces_data desc ");
                    dataAnterior = null;
                    valorEntradaLiberar = BigDecimal.ZERO;
                    valorSaidaLiberar = BigDecimal.ZERO;
                    dados = null;
                    dadosAnteriores = null;
                    inseriu = false;
                    rs = Conexao.executeQuery(st, bufAnterior.toString());
                    if (rs.next()) {
                        dataAnterior = rs.getDate("dataAnterior");
                        dadosAnteriores = new DadosSaldoEstoqueCelulaMaterial(dataAnterior, rs.getBigDecimal("estoqueDisponivelAnterior"), rs.getBigDecimal("valorPeps"), rs.getBigDecimal("valorUeps"), rs.getBigDecimal("valorCmc"), true);
                    }
                    if (dadosAnteriores != null) {
                        bufAnterior.setLength(0);
                        bufAnterior.append(" select 0 as valorSaidaLiberar, ");
                        bufAnterior.append("        SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN COALESCE(lce.lce_quantidade, 0) ELSE 0 END) as valorEntradaLiberar ");
                        bufAnterior.append("   from lanctoestoque lce ");
                        bufAnterior.append("  where lce.fil_codigo = ").append(codigoFilial);
                        bufAnterior.append("    and lce.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                        bufAnterior.append("    and (lce.lce_conciliacao IS NULL OR cast(lce.lce_conciliacao as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("') ");
                        bufAnterior.append("    and cast(lce.lce_datahora as date) < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                        bufAnterior.append("    and lce.cel_codigo = ").append(dadosCelula.getCodigoCelula());
                        bufAnterior.append("    and lce.lce_tipo = '").append("E").append("' ");
                        rs = Conexao.executeQuery(st, bufAnterior.toString());
                        if (rs.next()) {
                            valorEntradaLiberar = valorEntradaLiberar.add(rs.getBigDecimal("valorEntradaLiberar") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorEntradaLiberar"));
                            valorSaidaLiberar = valorSaidaLiberar.add(rs.getBigDecimal("valorSaidaLiberar") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorSaidaLiberar"));
                            dadosAnteriores.setValorEntradaLiberar(valorEntradaLiberar);
                            dadosAnteriores.setValorSaidaLiberar(valorSaidaLiberar);
                            dadosAnteriores.setSaldoEstoque(dadosAnteriores.getSaldoEstoqueDisponivel());
                            dadosAnteriores.setSaldoEstoqueDisponivel(dadosAnteriores.getSaldoEstoqueDisponivel().add(dadosAnteriores.getValorEntradaLiberar()).subtract(dadosAnteriores.getValorSaidaLiberar()));
                        } else {
                            dadosAnteriores.setSaldoEstoqueDisponivel(dadosAnteriores.getSaldoEstoque());
                        }
                        dadosCelula.addDadoSaldoEstoqueCelula(dadosAnteriores);
                        inseriu = true;
                    }
                    buf = new StringBuilder();
                    buf.append(" select ces.ces_data as dataSaldo ");
                    buf.append("       ,ces.ces_saldo as estoqueDisponivel ");
                    buf.append("       ,COALESCE(ces.ces_totalpeps, 0) as valorPeps ");
                    buf.append("       ,COALESCE(ces.ces_totalueps, 0) as valorUeps ");
                    buf.append("       ,COALESCE(ces.ces_totalcmc, 0) as valorCmc ");
                    buf.append("   from saldoestoquecelula ces ");
                    buf.append("  where ces.fil_codigo = ").append(codigoFilial);
                    buf.append("    and ces.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                    buf.append("    and ces.ces_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                    buf.append("    and ces.cel_codigo = ").append(dadosCelula.getCodigoCelula());
                    if (!Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
                        buf.append("    and ces.ces_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
                    }
                    buf.append("  order by ces.ces_data");
                    rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        dados = new DadosSaldoEstoqueCelulaMaterial(rs.getDate("dataSaldo"), rs.getBigDecimal("estoqueDisponivel"), rs.getBigDecimal("valorPeps"), rs.getBigDecimal("valorUeps"), rs.getBigDecimal("valorCmc"), false);
                        buf.setLength(0);
                        buf.append(" select 0 as valorSaidaLiberar, ");
                        buf.append("        SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END) as valorEntradaLiberar ");
                        buf.append("   from lanctoestoque lce ");
                        buf.append("  where lce.fil_codigo = ").append(codigoFilial);
                        buf.append("    and lce.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                        buf.append("    and cast(lce.lce_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", dados.getData())).append("' ");
                        buf.append("    and (lce.lce_conciliacao IS NULL OR cast(lce.lce_conciliacao as date) > '").append(Funcoes.formataData("yyyy-MM-dd", dados.getData())).append("') ");
                        buf.append("    and lce.cel_codigo = ").append(dadosCelula.getCodigoCelula());
                        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
                        rsLiberar = Conexao.executeQuery(st2, buf.toString());
                        if (rsLiberar.next()) {
                            valorEntradaLiberar = valorEntradaLiberar.add(rsLiberar.getBigDecimal("valorEntradaLiberar") == null ? BigDecimal.ZERO : rsLiberar.getBigDecimal("valorEntradaLiberar"));
                            valorSaidaLiberar = valorSaidaLiberar.add(rsLiberar.getBigDecimal("valorSaidaLiberar") == null ? BigDecimal.ZERO : rsLiberar.getBigDecimal("valorSaidaLiberar"));
                            dados.setValorEntradaLiberar(valorEntradaLiberar);
                            dados.setValorSaidaLiberar(valorSaidaLiberar);
                            dados.setSaldoEstoque(dados.getSaldoEstoqueDisponivel());
                        } else {
                            dados.setSaldoEstoque(dados.getSaldoEstoqueDisponivel());
                        }
                        dadosCelula.addDadoSaldoEstoqueCelula(dados);
                        inseriu = true;
                    }
                    if (!inseriu && !somenteComMovimentacao) {
                        dadosCelula.addDadoSaldoEstoqueCelula(new DadosSaldoEstoqueCelulaMaterial(null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false));
                    }
                    listaCelulas.add(dadosCelula);
                }
            }
            modelo = new ModeloGridTable(RelatorioSaldoEstoqueCelula.camposRelatorio);
            materialAnterior = -1;
            for (k = 0; k < listaCelulas.size(); ++k) {
                celulaAux = (DadosCelula)listaCelulas.get(k);
                if (celulaAux.getCodigoMaterial() != materialAnterior) {
                    rsFilialMaterial.beforeFirst();
                    while (rsFilialMaterial.next() && (materialAnterior = rsFilialMaterial.getInt("codigoMaterial")) != celulaAux.getCodigoMaterial()) {
                    }
                }
                for (i = 0; i < celulaAux.getSaldosCelula().size(); ++i) {
                    o = new Object[RelatorioSaldoEstoqueCelula.camposRelatorio.length];
                    saldoAux = celulaAux.getSaldosCelula().get(i);
                    o[modelo.findColumn((String)"dataSaldo")] = saldoAux.getData();
                    o[modelo.findColumn((String)"saldoEstoque")] = saldoAux.getSaldoEstoque().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorEntrada")] = saldoAux.getValorEntradaLiberar().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorSaida")] = saldoAux.getValorSaidaLiberar().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorPeps")] = saldoAux.getValorPeps().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorUeps")] = saldoAux.getValorUeps().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorCmc")] = saldoAux.getValorCmc().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"saldoEstoqueDisponivel")] = saldoAux.getSaldoEstoqueDisponivel().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorUnitarioCmc")] = saldoAux.getSaldoEstoque().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(4, this.ROUND) : saldoAux.getValorCmc().divide(saldoAux.getSaldoEstoque(), this.ROUND).setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"mensagemSaldo")] = saldoAux.isSaldoAnterior() != false ? "ESTOQUE ANTERIOR" : "ESTOQUE";
                    o[modelo.findColumn((String)"mensagemSaldoDisponivel")] = "ESTOQUE DISPON\u00cdVEL";
                    o[modelo.findColumn((String)"codigoCelula")] = celulaAux.getCodigoCelula();
                    o[modelo.findColumn((String)"descricaoCelula")] = celulaAux.getDescricaoCelula();
                    o[modelo.findColumn((String)"inativaCelula")] = celulaAux.isInativa();
                    o[modelo.findColumn((String)"padraoCelula")] = celulaAux.isPadrao();
                    for (j = 0; j < Constantes.CAMPOS_FILIAL.length; ++j) {
                        o[modelo.findColumn((String)Constantes.CAMPOS_FILIAL[j])] = rsFilialMaterial.getObject(Constantes.CAMPOS_FILIAL[j]);
                    }
                    for (j = 0; j < RelatorioSaldoEstoqueCelula.camposMaterial.length; ++j) {
                        o[modelo.findColumn((String)RelatorioSaldoEstoqueCelula.camposMaterial[j])] = rsFilialMaterial.getObject(RelatorioSaldoEstoqueCelula.camposMaterial[j]);
                    }
                    for (j = 0; j < RelatorioSaldoEstoqueCelula.camposUnidadeMedida.length; ++j) {
                        o[modelo.findColumn((String)RelatorioSaldoEstoqueCelula.camposUnidadeMedida[j])] = rsFilialMaterial.getObject(RelatorioSaldoEstoqueCelula.camposUnidadeMedida[j]);
                    }
                    if (i == celulaAux.getSaldosCelula().size() - 1) {
                        o[modelo.findColumn((String)"valorFinalPeps")] = o[modelo.findColumn("valorPeps")];
                        o[modelo.findColumn((String)"valorFinalUeps")] = o[modelo.findColumn("valorUeps")];
                        o[modelo.findColumn((String)"valorFinalCmc")] = o[modelo.findColumn("valorCmc")];
                    } else {
                        o[modelo.findColumn((String)"valorFinalPeps")] = BigDecimal.ZERO.setScale(4, this.ROUND);
                        o[modelo.findColumn((String)"valorFinalUeps")] = BigDecimal.ZERO.setScale(4, this.ROUND);
                        o[modelo.findColumn((String)"valorFinalCmc")] = BigDecimal.ZERO.setScale(4, this.ROUND);
                    }
                    modelo.addLine(o);
                }
            }
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioSaldoEstoqueCelula.getModuloAcesso());
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next() && modelo.getRowCount() > 0) {
                gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(1.0f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioSaldoEstoqueCelula.this.panelCentro.removeAll();
                        RelatorioSaldoEstoqueCelula.this.panelCentro.repaint();
                        RelatorioSaldoEstoqueCelula.this.habilitaBotaoImprimir(true);
                    }
                });
                var = new HashMap<String, Object>();
                var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                var.put("filtroSomenteComMovimentacao", this.getFiltroCheck("filtroSomenteComMovimentacao") != false ? "Sim" : "N\u00e3o");
                var.put("filtroMaterialInativo", this.getFiltroCheck("filtroMaterialInativo") != false ? "Sim" : "N\u00e3o");
                var.put("filtroFilial", codigoFilial);
                buf.delete(0, buf.length());
                if (material != null) {
                    for (i = 0; i < material.length; ++i) {
                        buf.append(material[i]);
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroMaterial", buf.toString());
                buf.delete(0, buf.length());
                if (celula != null) {
                    for (i = 0; i < celula.length; ++i) {
                        buf.append(celula[i]);
                        if (i >= celula.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroCelula", buf.toString());
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            ** if (st == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                ** if (st == null) goto lbl-1000
            }
            catch (Throwable var25_35) {
                if (st != null) {
                    Conexao.fecharStatement(new Statement[]{st, st2});
                }
                throw var25_35;
            }
lbl-1000:
            // 1 sources

            {
                Conexao.fecharStatement(new Statement[]{st, st2});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Conexao.fecharStatement(new Statement[]{st, st2});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801000400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801000401");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal[] getValorMovimentoCelula(String filial, Integer codigoMaterial, Date dataInicial, Date dataFinal, Integer celula) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as entradas, ");
        buf.append("        COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as saidas ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_situacao = '").append("O").append("' ");
        buf.append("    and lce.cel_codigo = ").append(celula);
        if (dataInicial != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        try {
            if (rs.next()) {
                BigDecimal[] bigDecimalArray = new BigDecimal[]{rs.getBigDecimal("entradas"), rs.getBigDecimal("saidas")};
                return bigDecimalArray;
            }
        }
        finally {
            st.close();
        }
        return null;
    }

    class DadosSaldoEstoqueCelulaMaterial {
        private Date data = null;
        private BigDecimal saldoEstoque = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorPeps = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorUeps = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorCmc = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorEntradaLiberar = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorSaidaLiberar = BigDecimal.ZERO.setScale(4);
        private BigDecimal saldoEstoqueDisponivel = BigDecimal.ZERO.setScale(4);
        private boolean isSaldoAnterior = false;

        public Date getData() {
            return this.data;
        }

        public void setData(Date data) {
            this.data = data;
        }

        public BigDecimal getSaldoEstoque() {
            return this.saldoEstoque;
        }

        public BigDecimal getValorPeps() {
            return this.valorPeps;
        }

        public BigDecimal getValorUeps() {
            return this.valorUeps;
        }

        public BigDecimal getValorCmc() {
            return this.valorCmc;
        }

        public void setSaldoEstoque(BigDecimal saldoEstoque) {
            this.saldoEstoque = saldoEstoque;
        }

        public BigDecimal getValorEntradaLiberar() {
            return this.valorEntradaLiberar;
        }

        public void setValorEntradaLiberar(BigDecimal valorEntradaLiberar) {
            this.valorEntradaLiberar = valorEntradaLiberar;
        }

        public BigDecimal getValorSaidaLiberar() {
            return this.valorSaidaLiberar;
        }

        public void setValorSaidaLiberar(BigDecimal valorSaidaLiberar) {
            this.valorSaidaLiberar = valorSaidaLiberar;
        }

        public BigDecimal getSaldoEstoqueDisponivel() {
            return this.saldoEstoqueDisponivel;
        }

        public void setSaldoEstoqueDisponivel(BigDecimal saldoEstoqueDisponivel) {
            this.saldoEstoqueDisponivel = saldoEstoqueDisponivel;
        }

        public void setSaldoAnterior(boolean isSaldoAnterior) {
            this.isSaldoAnterior = isSaldoAnterior;
        }

        public boolean isSaldoAnterior() {
            return this.isSaldoAnterior;
        }

        public DadosSaldoEstoqueCelulaMaterial(Date data, BigDecimal saldoEstoqueDisponivel, BigDecimal valorPeps, BigDecimal valorUeps, BigDecimal valorCmc, boolean isSaldoAnterior) {
            this.data = data;
            this.saldoEstoqueDisponivel = saldoEstoqueDisponivel;
            this.valorPeps = valorPeps;
            this.valorUeps = valorUeps;
            this.valorCmc = valorCmc;
            this.isSaldoAnterior = isSaldoAnterior;
        }
    }

    class DadosCelula {
        private Integer codigoCelula = new Integer(-1);
        private Integer codigoMaterial = new Integer(-1);
        private String descricaoCelula = "";
        private boolean inativa = false;
        private boolean padrao = false;
        private ArrayList<DadosSaldoEstoqueCelulaMaterial> saldosCelula = new ArrayList();

        public boolean isInativa() {
            return this.inativa;
        }

        public void setInativa(boolean inativa) {
            this.inativa = inativa;
        }

        public boolean isPadrao() {
            return this.padrao;
        }

        public void setPadrao(boolean padrao) {
            this.padrao = padrao;
        }

        public Integer getCodigoCelula() {
            return this.codigoCelula;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public String getDescricaoCelula() {
            return this.descricaoCelula;
        }

        public void setDescricaoCelula(String descricaoCelula) {
            this.descricaoCelula = descricaoCelula;
        }

        public ArrayList<DadosSaldoEstoqueCelulaMaterial> getSaldosCelula() {
            return this.saldosCelula;
        }

        public void addDadoSaldoEstoqueCelula(DadosSaldoEstoqueCelulaMaterial dado) {
            this.saldosCelula.add(dado);
        }

        public DadosCelula(Integer codigoCelula, String descricaoCelula, Integer codigoMaterial, boolean inativa, boolean padrao) {
            this.codigoCelula = codigoCelula;
            this.descricaoCelula = descricaoCelula;
            this.codigoMaterial = codigoMaterial;
            this.padrao = padrao;
            this.inativa = inativa;
        }
    }
}

