/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioSaldoEstoque
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_DATAINICIAL = "filtroDataInicial";
    private final String FILTRO_DATAFINAL = "filtroDataFinal";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SOMENTE_COM_MOVIMENTACAO = "filtroSomenteComMovimentacao";
    private static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial"};
    private static final String[] camposUnidadeMedia = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposSaldo = new String[]{"dataSaldo", "saldoEstoque", "valorEntrada", "valorSaida", "saldoEstoqueDisponivel", "mensagemSaldo", "mensagemSaldoDisponivel", "valorPeps", "valorUeps", "valorCmc", "valorUnitarioCmc", "valorFinalPeps", "valorFinalUeps", "valorFinalCmc"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposSaldo), ArraysUtil.concatenar(camposMaterial, camposUnidadeMedia));
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public RelatorioSaldoEstoque() {
        this.montaBarraDescricao("Relat\u00f3rio de saldo de estoque", "Listagem di\u00e1ria do saldo de estoque de materiais", "relatorios/rel_estoque_almoxarifado_rel_saldo_estoque.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroSomenteComMovimentacao", "Somente com movimento", false);
        this.setModuloConfigurar(RelatorioSaldoEstoque.getModuloConfigurar());
        this.setModuloAcesso(RelatorioSaldoEstoque.getModuloAcesso());
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void imprimirPressionado() {
        filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        codigoFilial = null;
        if (filiais != null) {
            if (filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            codigoFilial = filiais[0];
        } else {
            codigoFilial = Variaveis.filialPadrao;
        }
        material = this.getSelecionadosFiltro("filtroMaterial", 0);
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Insira uma data inicial para o relat\u00f3rio", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        somenteComMovimentacao = this.getFiltroCheck("filtroSomenteComMovimentacao");
        this.setCursor(Cursor.getPredefinedCursor(3));
        listaSaldos = new ArrayList<DadosSaldoEstoque>();
        st = Conexao.getStatement();
        st2 = Conexao.getStatement();
        st3 = Conexao.getStatement();
        buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append(" select a.mat_codigo as codigoMaterial, ");
        buf.append("        a.mat_descricao as descricaoMaterial, ");
        buf.append("        unm.unm_codigo  as codigoUnidadeMedida, ");
        buf.append("        unm.unm_descricao as descricaoUnidadeMedida, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append(" from material a ");
        buf.append(" left join unidademedida unm on (a.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo) ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        if (material != null) {
            buf.append("    and a.mat_codigo IN (");
            for (i = 0; i < material.length; ++i) {
                if (i != material.length - 1) {
                    buf.append(material[i]).append(", ");
                    continue;
                }
                buf.append(material[i]);
            }
            buf.append(") ");
        }
        buf.append(" order by a.mat_codigo ");
        try {
            rsFilialMaterial = Conexao.executeQuery(st3, buf.toString());
            rs = null;
            if (rsFilialMaterial.next()) {
                dataAnterior /* !! */  = null;
                valorEntradaLiberar = BigDecimal.ZERO;
                valorSaidaLiberar = BigDecimal.ZERO;
                dados = null;
                do {
                    if (somenteComMovimentacao && (valores = this.getValorMovimento(codigoFilial, rsFilialMaterial.getInt("codigoMaterial"), Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataInicial")), Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) == false ? Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataFinal")) : null))[0].compareTo(BigDecimal.ZERO) == 0 && valores[1].compareTo(BigDecimal.ZERO) == 0) continue;
                    dataAnterior /* !! */  = null;
                    valorEntradaLiberar = BigDecimal.ZERO;
                    valorSaidaLiberar = BigDecimal.ZERO;
                    dados = null;
                    inseriu = false;
                    bufAnterior = new StringBuilder();
                    bufAnterior.append(" select sde.sde_data \tas dataAnterior ");
                    bufAnterior.append("       ,sde.sde_saldo \tas estoqueDisponivelAnterior ");
                    bufAnterior.append("       ,COALESCE(sde.sde_totalpeps, 0) as valorPeps ");
                    bufAnterior.append("       ,COALESCE(sde.sde_totalueps, 0) as valorUeps ");
                    bufAnterior.append("       ,COALESCE(sde.sde_totalcmc, 0) as valorCmc ");
                    bufAnterior.append("   from saldoestoque sde ");
                    bufAnterior.append("  where sde.fil_codigo = ").append(codigoFilial);
                    bufAnterior.append("    and sde.sde_data < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                    bufAnterior.append("    and sde.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                    bufAnterior.append("  order by sde.sde_data desc ");
                    rs = Conexao.executeQuery(st, bufAnterior.toString());
                    if (rs.next()) {
                        dataAnterior /* !! */  = rs.getDate("dataAnterior");
                        dados = new DadosSaldoEstoque(rsFilialMaterial.getInt("codigoMaterial"), dataAnterior /* !! */ , rs.getBigDecimal("estoqueDisponivelAnterior"), rs.getBigDecimal("valorPeps"), rs.getBigDecimal("valorUeps"), rs.getBigDecimal("valorCmc"), true);
                    } else {
                        dataAnterior /* !! */  = Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataInicial"));
                        dataAnterior /* !! */  = Funcoes.subtraiDias(dataAnterior /* !! */ , 1);
                    }
                    if (dados != null) {
                        bufAnterior.delete(0, bufAnterior.length());
                        bufAnterior.append(" select SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END) as valorSaidaLiberar, ");
                        bufAnterior.append("        SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END) as valorEntradaLiberar ");
                        bufAnterior.append("   from lanctoestoque lce ");
                        bufAnterior.append("  where lce.fil_codigo = ").append(codigoFilial);
                        bufAnterior.append("    and lce.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                        bufAnterior.append("    and lce.lce_situacao = '").append("A").append("' ");
                        bufAnterior.append("    and lce.lce_datahora <= '").append(Funcoes.formataData("yyyy-MM-dd", dataAnterior /* !! */ )).append("' ");
                        rs = Conexao.executeQuery(st, bufAnterior.toString());
                        if (rs.next()) {
                            valorEntradaLiberar = valorEntradaLiberar.add(rs.getBigDecimal("valorEntradaLiberar") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorEntradaLiberar"));
                            valorSaidaLiberar = valorSaidaLiberar.add(rs.getBigDecimal("valorSaidaLiberar") == null ? BigDecimal.ZERO : rs.getBigDecimal("valorSaidaLiberar"));
                            dados.setValorEntradaLiberar(valorEntradaLiberar);
                            dados.setValorSaidaLiberar(valorSaidaLiberar);
                            dados.setSaldoEstoque(dados.getSaldoEstoqueDisponivel().add(dados.getValorEntradaLiberar()).subtract(dados.getValorSaidaLiberar()));
                        } else {
                            dados.setSaldoEstoqueDisponivel(dados.getSaldoEstoque());
                        }
                        listaSaldos.add(dados);
                        inseriu = true;
                    }
                    buf.setLength(0);
                    buf.append(" select sde.sde_data\tas dataSaldo ");
                    buf.append("       ,sde.sde_saldo \tas estoqueDisponivel ");
                    buf.append("       ,COALESCE(sde.sde_totalpeps, 0) as valorPeps ");
                    buf.append("       ,COALESCE(sde.sde_totalueps, 0) as valorUeps ");
                    buf.append("       ,COALESCE(sde.sde_totalcmc, 0) as valorCmc ");
                    buf.append("   from saldoestoque sde ");
                    buf.append("  where sde.fil_codigo = ").append(codigoFilial);
                    buf.append("    and sde.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                    buf.append("    and sde.sde_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                    if (!Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
                        buf.append("    and sde.sde_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
                    }
                    buf.append("  order by sde.sde_data ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        dados = new DadosSaldoEstoque(rsFilialMaterial.getInt("codigoMaterial"), rs.getDate("dataSaldo"), rs.getBigDecimal("estoqueDisponivel"), rs.getBigDecimal("valorPeps"), rs.getBigDecimal("valorUeps"), rs.getBigDecimal("valorCmc"), false);
                        buf.delete(0, buf.length());
                        buf.append(" select SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END) as valorSaidaLiberar, ");
                        buf.append("        SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END) as valorEntradaLiberar ");
                        buf.append("   from lanctoestoque lce ");
                        buf.append("  where lce.fil_codigo = ").append(codigoFilial);
                        buf.append("    and lce.mat_codigo = ").append(rsFilialMaterial.getInt("codigoMaterial"));
                        buf.append("    and lce.lce_situacao = '").append("A").append("' ");
                        buf.append("    and lce.lce_datahora > '").append(Funcoes.formataData("yyyy-MM-dd", dataAnterior /* !! */ )).append("' ");
                        buf.append("    and lce.lce_datahora <= '").append(Funcoes.formataData("yyyy-MM-dd", dados.getData())).append("' ");
                        rsLiberar = Conexao.executeQuery(st2, buf.toString());
                        if (rsLiberar.next()) {
                            valorEntradaLiberar = rsLiberar.getBigDecimal("valorEntradaLiberar") == null ? BigDecimal.ZERO : rsLiberar.getBigDecimal("valorEntradaLiberar");
                            valorSaidaLiberar = rsLiberar.getBigDecimal("valorSaidaLiberar") == null ? BigDecimal.ZERO : rsLiberar.getBigDecimal("valorSaidaLiberar");
                            dados.setValorEntradaLiberar(valorEntradaLiberar);
                            dados.setValorSaidaLiberar(valorSaidaLiberar);
                            dados.setSaldoEstoque(dados.getSaldoEstoqueDisponivel());
                            dados.setSaldoEstoqueDisponivel(dados.getSaldoEstoqueDisponivel());
                        } else {
                            dados.setSaldoEstoque(dados.getSaldoEstoqueDisponivel());
                        }
                        listaSaldos.add(dados);
                        inseriu = true;
                    }
                    if (inseriu || somenteComMovimentacao) continue;
                    dados = new DadosSaldoEstoque(rsFilialMaterial.getInt("codigoMaterial"), null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false);
                    listaSaldos.add(dados);
                } while (rsFilialMaterial.next());
                modelo = new ModeloGridTable(RelatorioSaldoEstoque.camposRelatorio);
                materialAnterior = -1;
                o = null;
                for (i = 0; i < listaSaldos.size(); ++i) {
                    o = new Object[RelatorioSaldoEstoque.camposRelatorio.length];
                    if (((DadosSaldoEstoque)listaSaldos.get(i)).getCodigoMaterial() != materialAnterior) {
                        if (i > 0) {
                            modelo.setValueAt(o[modelo.findColumn("valorPeps")], modelo.getRowCount() - 1, modelo.findColumn("valorFinalPeps"));
                            modelo.setValueAt(o[modelo.findColumn("valorUeps")], modelo.getRowCount() - 1, modelo.findColumn("valorFinalUeps"));
                            modelo.setValueAt(o[modelo.findColumn("valorCmc")], modelo.getRowCount() - 1, modelo.findColumn("valorFinalCmc"));
                        }
                        rsFilialMaterial.beforeFirst();
                        while (rsFilialMaterial.next() && (materialAnterior = rsFilialMaterial.getInt("codigoMaterial")) != ((DadosSaldoEstoque)listaSaldos.get(i)).getCodigoMaterial()) {
                        }
                    } else {
                        modelo.setValueAt(BigDecimal.ZERO.setScale(4, this.ROUND), modelo.getRowCount() - 1, modelo.findColumn("valorFinalPeps"));
                        modelo.setValueAt(BigDecimal.ZERO.setScale(4, this.ROUND), modelo.getRowCount() - 1, modelo.findColumn("valorFinalUeps"));
                        modelo.setValueAt(BigDecimal.ZERO.setScale(4, this.ROUND), modelo.getRowCount() - 1, modelo.findColumn("valorFinalCmc"));
                    }
                    dados = (DadosSaldoEstoque)listaSaldos.get(i);
                    o[modelo.findColumn((String)"dataSaldo")] = dados.getData();
                    o[modelo.findColumn((String)"saldoEstoque")] = dados.getSaldoEstoque().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorPeps")] = dados.getValorPeps().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorUeps")] = dados.getValorUeps().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorCmc")] = dados.getValorCmc().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorEntrada")] = dados.getValorEntradaLiberar().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorSaida")] = dados.getValorSaidaLiberar().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"saldoEstoqueDisponivel")] = dados.getSaldoEstoqueDisponivel().setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"valorUnitarioCmc")] = dados.getSaldoEstoqueDisponivel().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.setScale(4, this.ROUND) : dados.getValorCmc().divide(dados.getSaldoEstoqueDisponivel(), this.ROUND).setScale(4, this.ROUND);
                    o[modelo.findColumn((String)"mensagemSaldo")] = dados.isSaldoInicial() != false ? "ESTOQUE ANTERIOR" : "ESTOQUE";
                    o[modelo.findColumn((String)"mensagemSaldoDisponivel")] = dados.isSaldoInicial() != false ? "ESTOQUE ANTERIOR TOTAL" : "ESTOQUE TOTAL";
                    for (j = 0; j < Constantes.CAMPOS_FILIAL.length; ++j) {
                        o[modelo.findColumn((String)Constantes.CAMPOS_FILIAL[j])] = rsFilialMaterial.getObject(Constantes.CAMPOS_FILIAL[j]);
                    }
                    for (j = 0; j < RelatorioSaldoEstoque.camposMaterial.length; ++j) {
                        o[modelo.findColumn((String)RelatorioSaldoEstoque.camposMaterial[j])] = rsFilialMaterial.getObject(RelatorioSaldoEstoque.camposMaterial[j]);
                    }
                    for (j = 0; j < RelatorioSaldoEstoque.camposUnidadeMedia.length; ++j) {
                        o[modelo.findColumn((String)RelatorioSaldoEstoque.camposUnidadeMedia[j])] = rsFilialMaterial.getObject(RelatorioSaldoEstoque.camposUnidadeMedia[j]);
                    }
                    if (i == listaSaldos.size() - 1) {
                        o[modelo.findColumn((String)"valorFinalPeps")] = o[modelo.findColumn("valorPeps")];
                        o[modelo.findColumn((String)"valorFinalUeps")] = o[modelo.findColumn("valorUeps")];
                        o[modelo.findColumn((String)"valorFinalCmc")] = o[modelo.findColumn("valorCmc")];
                    }
                    modelo.addLine(o);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioSaldoEstoque.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && modelo.getRowCount() > 0) {
                    gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioSaldoEstoque.this.panelCentro.removeAll();
                            RelatorioSaldoEstoque.this.panelCentro.repaint();
                            RelatorioSaldoEstoque.this.habilitaBotaoImprimir(true);
                        }
                    });
                    var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroSomenteComMovimentacao", this.getFiltroCheck("filtroSomenteComMovimentacao") != false ? "Sim" : "N\u00e3o");
                    var.put("filtroFilial", codigoFilial);
                    buf.delete(0, buf.length());
                    if (material != null) {
                        for (i = 0; i < material.length; ++i) {
                            buf.append(material[i]);
                            if (i >= material.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            ** if (st == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                ** if (st == null) goto lbl-1000
            }
            catch (Throwable var22_28) {
                if (st != null) {
                    Conexao.fecharStatement(new Statement[]{st, st2, st3});
                }
                throw var22_28;
            }
lbl-1000:
            // 1 sources

            {
                Conexao.fecharStatement(new Statement[]{st, st2, st3});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            Conexao.fecharStatement(new Statement[]{st, st2, st3});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801000300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801000301");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal[] getValorMovimento(String filial, Integer codigoMaterial, Date dataInicial, Date dataFinal) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("E").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as entradas, ");
        buf.append("        COALESCE(SUM(CASE WHEN lce.lce_tipo = '").append("S").append("' THEN lce.lce_quantidade ELSE 0 END), 0) as saidas ");
        buf.append("   from lanctoestoque lce ");
        buf.append("  where lce.fil_codigo = ").append(filial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_situacao = '").append("O").append("' ");
        if (dataInicial != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        }
        if (dataFinal != null) {
            buf.append("    and date_trunc('day', lce.lce_datahora) <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        try {
            if (rs.next()) {
                BigDecimal[] bigDecimalArray = new BigDecimal[]{rs.getBigDecimal("entradas"), rs.getBigDecimal("saidas")};
                return bigDecimalArray;
            }
        }
        finally {
            st.close();
        }
        return null;
    }

    class DadosSaldoEstoque {
        private Date data = null;
        private BigDecimal saldoEstoque = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorPeps = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorUeps = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorCmc = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorEntradaLiberar = BigDecimal.ZERO.setScale(4);
        private BigDecimal valorSaidaLiberar = BigDecimal.ZERO.setScale(4);
        private BigDecimal saldoEstoqueDisponivel = BigDecimal.ZERO.setScale(4);
        private boolean isSaldoAnterior = false;
        private Integer codigoMaterial = -1;

        public Date getData() {
            return this.data;
        }

        public void setData(Date data) {
            this.data = data;
        }

        public BigDecimal getSaldoEstoque() {
            return this.saldoEstoque;
        }

        public BigDecimal getValorPeps() {
            return this.valorPeps;
        }

        public BigDecimal getValorUeps() {
            return this.valorUeps;
        }

        public BigDecimal getValorCmc() {
            return this.valorCmc;
        }

        public void setSaldoEstoque(BigDecimal saldoEstoque) {
            this.saldoEstoque = saldoEstoque;
        }

        public BigDecimal getValorEntradaLiberar() {
            return this.valorEntradaLiberar;
        }

        public void setValorEntradaLiberar(BigDecimal valorEntradaLiberar) {
            this.valorEntradaLiberar = valorEntradaLiberar;
        }

        public BigDecimal getValorSaidaLiberar() {
            return this.valorSaidaLiberar;
        }

        public void setValorSaidaLiberar(BigDecimal valorSaidaLiberar) {
            this.valorSaidaLiberar = valorSaidaLiberar;
        }

        public BigDecimal getSaldoEstoqueDisponivel() {
            return this.saldoEstoqueDisponivel;
        }

        public void setSaldoEstoqueDisponivel(BigDecimal saldoEstoqueDisponivel) {
            this.saldoEstoqueDisponivel = saldoEstoqueDisponivel;
        }

        public boolean isSaldoInicial() {
            return this.isSaldoAnterior;
        }

        public Integer getCodigoMaterial() {
            return this.codigoMaterial;
        }

        public DadosSaldoEstoque(Integer codigoMaterial, Date data, BigDecimal saldoEstoqueDisponivel, BigDecimal valorPeps, BigDecimal valorUeps, BigDecimal valorCmc, boolean isSaldoAnterior) {
            this.codigoMaterial = codigoMaterial;
            this.data = data;
            this.saldoEstoqueDisponivel = saldoEstoqueDisponivel;
            this.valorPeps = valorPeps;
            this.valorUeps = valorUeps;
            this.valorCmc = valorCmc;
            this.isSaldoAnterior = isSaldoAnterior;
        }
    }
}

