/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRequisicaoMaterial
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CELULA_ESTOQUE = "filtroCelulaEstoque";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_REQUISICAO = "filtroRequisicao";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String[] SITUACAO = new String[]{"Todas", Tipos.getSituacaoRequisicaoEstoque("A"), Tipos.getSituacaoRequisicaoEstoque("O"), Tipos.getSituacaoRequisicaoEstoque("C")};
    private static final String[] camposRequisicao = new String[]{"filialRequisicao", "codigoRequisicao", "dataHoraRequisicao", "observacaoRequisicao", "codigoUsuarioRequisicao", "codigoUsuarioCancelamentoRequisicao", "codigoUsuarioAlmoxarifeRequisicao", "situacaoRequisicao", "dataHoraCancelamentoRequisicao", "dataHoraAlmoxarifeRequisicao", "origemRequisicao", "codigoCelula", "codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposRequisicaoMaterial = new String[]{"codigoMaterialRequisicaoMaterial", "quantidadeRequisicaoMaterial"};
    private static final String[] camposMaterial = new String[]{"descricaoMaterial"};
    private static final String[] camposCelula = new String[]{"descricaoCelula", "inativaCelula", "padraoCelula"};
    private String[] camposRelatorio = null;
    public static final int TIPO_REQUISICAO = 1;
    public static final int TIPO_LISTAGEM = 2;
    private int tipoRelatorio = 1;
    private Integer codigoRequisicao = null;

    public RelatorioRequisicaoMaterial(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de requisi\u00e7\u00f5es de material", "Listagem das requisi\u00e7\u00f5es de material", "relatorios/rel_estoque_almoxarifado_rel_requisicoes_material.jpg");
        } else {
            this.montaBarraDescricao("Requisi\u00e7\u00e3o de material", "Impress\u00e3o de requisi\u00e7\u00e3o de material", "relatorios/rel_estoque_almoxarifado_rel_requisicao_material.jpg");
        }
        this.adicionaRelatorioListener(this);
        if (tipoRelatorio == 2) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
            this.adicionaItemFiltro("filtroCelulaEstoque", "C\u00e9lula Estoque", "celulaestoque", "", 1, new String[]{"cel_codigo", "cel_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select a.ree_codigo, a.ree_datahora, a.usr_codigo, a.ree_observacao, a.cel_codigo, b.cel_descricao from requisicaoestoque a ");
        buf.append("left join celulaestoque b on a.fil_codigo = b.fil_codigo and a.cel_codigo = b.cel_codigo ");
        this.adicionaItemFiltro("filtroRequisicao", "Req. Estoque", buf.toString(), "a.fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ree_codigo", "ree_datahora", "usr_codigo", "cel_descricao", "ree_observacao"}, new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio", "C\u00e9lula", "Observa\u00e7\u00e3o"}, new int[]{60, 130, 70, 0, 80}, true);
        if (tipoRelatorio == 2) {
            this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
            this.adicionaFiltroData("filtroDataFinal", "Data Final:");
            this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.SITUACAO, 0);
        }
        this.setModuloConfigurar(RelatorioRequisicaoMaterial.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioRequisicaoMaterial.getModuloAcesso(tipoRelatorio));
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposRequisicao);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposRequisicaoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCelula);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    public void imprimirPressionado(Integer codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
        this.panelCard.setVisible(false);
        this.buttonConfigurar.setVisible(false);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorioRequisicaoMaterial.this.setVisible(false);
                RelatorioRequisicaoMaterial.this.getParent().getParent().getParent().setVisible(false);
            }
        });
        this.imprimirPressionado();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block46: {
            String[] requisicao;
            String[] celulas;
            String[] material;
            String[] usuario;
            String[] filiais;
            StringBuilder buf;
            block45: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                st = Conexao.getStatement();
                st2 = Conexao.getStatement();
                buf = new StringBuilder();
                buf.append("select a.fil_codigo as filialRequisicao, ");
                buf.append("       a.ree_codigo as codigoRequisicao, ");
                buf.append("       a.ree_datahora as dataHoraRequisicao, ");
                buf.append("       a.ree_observacao as observacaoRequisicao, ");
                buf.append("       a.usr_codigo as codigoUsuarioRequisicao, ");
                buf.append("       a.usr_codcancelamento as codigoUsuarioCancelamentoRequisicao, ");
                buf.append("       a.usr_codalmoxarife as codigoUsuarioAlmoxarifeRequisicao, ");
                buf.append("       a.ree_datahoraalmoxarife as dataHoraAlmoxarifeRequisicao, ");
                buf.append("       a.ree_situacao as situacaoRequisicao, ");
                buf.append("       a.ree_datahoracancelamento as dataHoraCancelamentoRequisicao, ");
                buf.append("       a.ree_origem as origemRequisicao, ");
                buf.append("       a.cel_codigo as codigoCelula, ");
                buf.append("       rem.mat_codigo as codigoMaterialRequisicaoMaterial, ");
                buf.append("       rem.rem_quantidade as quantidadeRequisicaoMaterial, ");
                buf.append("       mat.mat_descricao as descricaoMaterial, ");
                buf.append("       cel.cel_descricao as descricaoCelula, ");
                buf.append("       cel.cel_inativa as inativaCelula, ");
                buf.append("       cel.cel_padrao as padraoCelula, ");
                buf.append("       unm.unm_codigo as codigoUnidadeMedida, ");
                buf.append("       unm.unm_descricao as descricaoUnidadeMedida ");
                buf.append(", ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from requisicaoestoque a ");
                buf.append("  left join requisicaoestoquematerial rem on (a.fil_codigo = rem.fil_codigo and a.ree_codigo = rem.ree_codigo) ");
                buf.append("  left join material mat on (rem.fil_codigo = mat.fil_codigo and rem.mat_codigo = mat.mat_codigo) ");
                buf.append("  left join celulaestoque cel on (a.fil_codigo = cel.fil_codigo and a.cel_codigo = cel.cel_codigo) ");
                buf.append("  left join unidademedida unm on mat.fil_codigo = unm.fil_codigo and mat.unm_codigo = unm.unm_codigo ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append(" where a.fil_codigo ");
                filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (null == filiais || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (null != usuario) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (null != (material = this.getSelecionadosFiltro("filtroMaterial", 0))) {
                    buf.append(" and mat.mat_codigo in (");
                    for (int i = 0; i < material.length; ++i) {
                        buf.append("'");
                        buf.append(material[i]);
                        buf.append("'");
                        if (i >= material.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (null != (celulas = this.getSelecionadosFiltro("filtroCelulaEstoque", 0))) {
                    buf.append(" and a.cel_codigo in (");
                    for (int i = 0; i < celulas.length; ++i) {
                        buf.append(celulas[i]);
                        if (i >= celulas.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                requisicao = this.getSelecionadosFiltro("filtroRequisicao", 0);
                if (this.tipoRelatorio != 1 || null != this.codigoRequisicao || null != requisicao && requisicao.length > 0 && requisicao.length <= 1) break block45;
                if (null == requisicao || requisicao.length <= 0) {
                    Funcoes.mensagem(this, "Uma requisi\u00e7\u00e3o deve ser selecionada para o relat\u00f3rio.", 2);
                } else {
                    Funcoes.mensagem(this, "Somente uma requisi\u00e7\u00e3o deve ser selecionada para o relat\u00f3rio.", 2);
                }
                this.habilitaBotaoImprimir(true);
                this.setCursor(Cursor.getDefaultCursor());
                Conexao.fecharStatement(st, st2);
                return;
            }
            try {
                ResultSet rs;
                if (null != requisicao) {
                    buf.append(" and a.ree_codigo in (");
                    for (int i = 0; i < requisicao.length; ++i) {
                        buf.append("'");
                        buf.append(requisicao[i]);
                        buf.append("'");
                        if (i >= requisicao.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a.ree_datahora as date) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a.ree_datahora as date) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (null == this.codigoRequisicao && !Funcoes.textoVazio((String)this.getFiltroCombo("filtroSituacao"))) {
                    if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[1])) {
                        buf.append(" and a.ree_situacao = '").append("A").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[2])) {
                        buf.append(" and a.ree_situacao = '").append("O").append("' ");
                    } else if (this.getFiltroCombo("filtroSituacao").equals(this.SITUACAO[3])) {
                        buf.append(" and a.ree_situacao = '").append("C").append("' ");
                    }
                }
                if (null != this.codigoRequisicao) {
                    buf.append(" and a.ree_codigo = ").append(this.codigoRequisicao);
                }
                if (this.tipoRelatorio == 1) {
                    buf.append(" order by a.fil_codigo, a.ree_codigo ");
                    if (null != this.codigoRequisicao) {
                        buf.append(", mat.mat_descricao ");
                    }
                } else {
                    buf.append(" order by a.fil_codigo, a.cel_codigo, a.ree_codigo ");
                }
                if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        Object[] o = new Object[this.camposRelatorio.length];
                        for (int i = 0; i < this.camposRelatorio.length; ++i) {
                            if (this.camposRelatorio[i].equals("situacaoRequisicao")) {
                                if (rs.getString("situacaoRequisicao") == null) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.getSituacaoRequisicaoEstoque(rs.getString("situacaoRequisicao"));
                                continue;
                            }
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioRequisicaoMaterial.getModuloAcesso(this.tipoRelatorio));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioRequisicaoMaterial.this.panelCentro.removeAll();
                                RelatorioRequisicaoMaterial.this.panelCentro.repaint();
                                RelatorioRequisicaoMaterial.this.habilitaBotaoImprimir(true);
                                if (RelatorioRequisicaoMaterial.this.codigoRequisicao != null) {
                                    RelatorioRequisicaoMaterial.this.getParent().getParent().getParent().setVisible(false);
                                }
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        buf.delete(0, buf.length());
                        if (null != filiais) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (null != requisicao) {
                            for (i = 0; i < requisicao.length; ++i) {
                                buf.append(requisicao[i]);
                                if (i >= requisicao.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroRequisicao", buf.toString());
                        buf.delete(0, buf.length());
                        if (null != usuario) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        buf.delete(0, buf.length());
                        if (null != celulas) {
                            for (i = 0; i < celulas.length; ++i) {
                                buf.append(celulas[i]);
                                if (i >= celulas.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroCelulaEstoque", buf.toString());
                        buf.delete(0, buf.length());
                        if (null != material) {
                            for (i = 0; i < material.length; ++i) {
                                buf.append(material[i]);
                                if (i >= material.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroMaterial", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block46;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0801000101");
        }
        return Long.parseLong("0801000501");
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0801000100");
        }
        return Long.parseLong("0801000500");
    }
}

