/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;

public class RelatorioMovimentoEstoqueDetalhada
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CELULA = "filtroCelula";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_TIPO_MATERIAL = "filtroTipoMaterial";
    private static final String FILTRO_ORDENACAO = "filtroOrdenacao";
    private static final String FILTRO_SOMENTE_ESTOQUE = "filtroSomenteEstoque";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_MATERIAL_INATIVO = "filtroMaterialInativo";
    private static final String FILTRO_TIPO_LANCTO = "filtroTipoLancto";
    private static final String[] camposOrdenacao = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private static final String[] campoBanco = new String[]{"a.mat_codigo", "a.mat_descricao"};
    private static final String[] camposEstoque = new String[]{"codigoLancto", "tipoLancto", "tipoOrigemLancto", "dataHoraLancto", "quantidadeLancto", "codigoUsuarioLancto", "codigoUsuarioConciliacao", "valorUnitLancto", "valorTotalLancto", "valorUnitCMC", "valorUnitUEP", "valorUnitPEP", "dataHoraConciliacao", "valorCMC", "valorUEP", "valorPEP", "saldoAnteriorAcumulado", "dataSaldoAnterior", "saldoAnterior", "analiseCritica"};
    private static final String[] camposMaterial = new String[]{"codigoMaterial", "descricaoMaterial", "valorUnitarioMaterial", "valorUltimaCompraMaterial", "dataUltimaCompraMaterial", "quantidadeUltimaCompraMaterial", "pontoReposicaoMaterial", "dataUltimaEntregaMaterial", "reposicaoAutomaticaMaterial", "imobilizadoMaterial"};
    private static final String[] camposUnidadeMedida = new String[]{"codigoUnidadeMedida", "descricaoUnidadeMedida"};
    private static final String[] camposCelula = new String[]{"codigoCelula", "descricaoCelula"};
    private static final String[] camposTipoMaterial = new String[]{"codigoTipoMaterial", "descricaoTipoMaterial"};
    private static final String[] comboTipoLancto = new String[]{"Todos", "Entrada", "Sa\u00edda"};
    private String[] camposRelatorio = null;

    public RelatorioMovimentoEstoqueDetalhada() {
        this.montaBarraDescricao("Relat\u00f3rio de Movimenta\u00e7\u00e3o de Estoque Detalhada", "Movimenta\u00e7\u00e3o de estoque dos materiais no per\u00edodo detalhado", "relatorios/rel_estoque_almoxarifado_movimentacao_detalhada.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CELULA, "C\u00e9lula Estoque", "celulaestoque", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cel_codigo", "cel_descricao", "cel_inativa", "cel_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Inativa?", "Padr\u00e3o?"}, new int[]{60, 0, 60, 60});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_TIPO_MATERIAL, "Tipo Material", "tipomaterial", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
        this.adicionaFiltroCombo(FILTRO_TIPO_LANCTO, "Tipo:", comboTipoLancto, 0);
        this.adicionaFiltroCombo(FILTRO_ORDENACAO, "Ordem:", camposOrdenacao, 0);
        this.adicionaFiltroCheck(FILTRO_MATERIAL_INATIVO, "Apenas material inativo", false);
        this.setModuloConfigurar(RelatorioMovimentoEstoqueDetalhada.getModuloConfigurar());
        this.setModuloAcesso(RelatorioMovimentoEstoqueDetalhada.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, camposEstoque);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposUnidadeMedida);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposTipoMaterial);
        this.camposRelatorio = ArraysUtil.concatenar(this.camposRelatorio, camposCelula);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0801000900");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0801000901");
    }

    @Override
    public void imprimirPressionado() {
        int i;
        String[] tipoMaterial;
        if (this.getFiltroData(FILTRO_DATA_INICIAL) == null || Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar uma data inicial.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        String[] celulas = this.getSelecionadosFiltro(FILTRO_CELULA, 0);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = null;
        StringBuilder buf = new StringBuilder();
        if (celulas == null || celulas.length == 0) {
            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                buf.append(" select COALESCE(sdeini.sde_saldo, 0) as saldoAnterior, ");
                buf.append("        sdeini.sde_data as dataSaldoAnterior, ");
            } else {
                buf.append(" select 0 as saldoAnterior, ");
                buf.append("        cast(sdeini.sde_data as date) - interval '1 day' as dataSaldoAnterior, ");
            }
        } else {
            buf.append(" select ");
        }
        buf.append("  a.mat_codigo\t \t\t\t\tas codigoMaterial,");
        buf.append("\ta.mat_descricao\t\t\t\t\t\tas descricaoMaterial, ");
        buf.append("\ta.mat_valorunit\t\t\t\t\t\tas valorUnitarioMaterial, ");
        buf.append("\ta.mat_valorultcompra \t\t\tas valorUltimaCompraMaterial, ");
        buf.append("\ta.mat_dataultcompra \t\t\tas dataUltimaCompraMaterial, ");
        buf.append("\ta.mat_qtdeultcompra\t\t\t\tas quantidadeUltimaCompraMaterial, ");
        buf.append("\ta.mat_ptoreposicao\t\t\t\tas pontoReposicaoMaterial, ");
        buf.append("\ta.mat_dataultentrega \t\t\tas dataUltimaEntregaMaterial, ");
        buf.append("\ta.mat_reposicaoautomatica as reposicaoAutomaticaMaterial, ");
        buf.append("\ta.mat_imobilizado \t\t\t\tas imobilizadoMaterial, ");
        buf.append("\tlce.lce_codigo\t\t\t\t\t\tas codigoLancto, ");
        buf.append("\tlce.lce_datahora\t\t\t\t\tas dataHoraLancto, ");
        buf.append("\tlce.lce_tipo\t\t\t\t\t\t\tas tipoLancto, ");
        buf.append("\tlce.lce_tipoorigem\t\t\t\tas tipoOrigemLancto, ");
        buf.append("\tlce.lce_quantidade\t\t\t\tas quantidadeLancto, ");
        buf.append("\tlce.usr_codigo\t\t\t\t\t\tas codigoUsuarioLancto, ");
        buf.append("\tlce.usr_codconciliacao  \tas codigoUsuarioConciliacao, ");
        buf.append("\tlce.lce_valorunitario\t  \tas valorUnitLancto, ");
        buf.append("\tlce.lce_valortotal\t    \tas valorTotalLancto, ");
        buf.append("\tlce.lce_conciliacao\t    \tas dataHoraConciliacao, ");
        buf.append("\tlce.lce_analisecritica    as analiseCritica, ");
        buf.append("\tcel.cel_codigo \t\t\t\t\t\tas codigoCelula, ");
        buf.append("\tcel.cel_descricao\t\t\t\t\tas descricaoCelula, ");
        buf.append("\tunm.unm_codigo\t\t\t\t\t\tas codigoUnidadeMedida, ");
        buf.append("\tunm.unm_descricao\t\t\t\t\tas descricaoUnidadeMedida, ");
        buf.append("\ttpm.tpm_codigo \t\t\t\t\t\tas codigoTipoMaterial,\t");
        buf.append("\ttpm.tpm_descricao\t\t\t\t\tas descricaoTipoMaterial, ");
        buf.append("\tcmc.cmc_valor \t\t\t\t\t\tas valorCMC, ");
        buf.append("  cmc.cmc_valorunitario\t\t\tas valorUnitCMC, ");
        buf.append("\tround(SUM(pep.pep_valor), 4,").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(") as valorPEP, ");
        buf.append("\tround(case when coalesce(sum(pep.pep_quantidade), 0) = 0 then 0 else (SUM(pep.pep_valor) / SUM(pep.pep_quantidade)) end, 4, ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(")\tas valorUnitPEP, ");
        buf.append("\tround(SUM(uep.uep_valor), 4, ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(")\tas valorUEP, ");
        buf.append("\tround(case when coalesce(sum(uep.uep_quantidade), 0) = 0 then 0 else (SUM(uep.uep_valor) / SUM(uep.uep_quantidade)) end, 4, ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(")\tas valorUnitUEP, ");
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("FROM   material a ");
        if (celulas == null || celulas.length == 0) {
            buf.append("  left join saldoestoque sdeini on (a.fil_codigo = sdeini.fil_codigo and a.mat_codigo = sdeini.mat_codigo ");
            buf.append(" and (sdeini.sde_data = (select MAX(sde_data) ");
            buf.append("                           from saldoestoque ");
            buf.append("                          where fil_codigo = a.fil_codigo ");
            buf.append("                            and mat_codigo = a.mat_codigo ");
            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                buf.append("                            and sde_data < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' ");
            }
            buf.append("                        )");
            buf.append("      or sdeini.sde_data IS NULL) ");
            buf.append(") ");
        }
        buf.append("\t\t\t JOIN lanctoestoque lce    \tON a.fil_codigo = lce.fil_codigo \t  AND a.mat_codigo = lce.mat_codigo   ");
        buf.append("\tLEFT JOIN lanctoestoquecmc cmc \tON lce.fil_codigo = cmc.fil_codigo  AND lce.lce_codigo = cmc.lce_codigo ");
        buf.append("\tLEFT JOIN lanctoestoquepeps pep ON lce.fil_codigo = pep.fil_codigo  AND lce.lce_codigo = pep.lce_codigo ");
        buf.append("\tLEFT JOIN lanctoestoqueueps uep ON lce.fil_codigo = uep.fil_codigo  AND lce.lce_codigo = uep.lce_codigo ");
        buf.append("\t\t\t JOIN tipomaterial  tpm    \tON a.fil_codigo = tpm.fil_codigo    AND a.tpm_codigo = tpm.tpm_codigo   ");
        buf.append("\t\t\t JOIN unidademedida unm    \tON a.fil_codigo = unm.fil_codigo    AND a.unm_codigo = unm.unm_codigo   ");
        buf.append("\t\t\t JOIN celulaestoque cel    \tON a.fil_codigo = cel.fil_codigo    AND lce.cel_codigo = cel.cel_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        buf.append("WHERE a.fil_codigo  ");
        String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
        if (filiais == null || filiais.length == 0) {
            buf.append(" = ").append(Variaveis.filialPadrao);
        } else {
            buf.append(" in (");
            for (int i2 = 0; i2 < filiais.length; ++i2) {
                buf.append(filiais[i2]);
                if (i2 >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        String[] material = this.getSelecionadosFiltro(FILTRO_MATERIAL, 0);
        if (material != null) {
            buf.append(" and a.mat_codigo in (");
            for (int i3 = 0; i3 < material.length; ++i3) {
                buf.append(material[i3]);
                if (i3 >= material.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((tipoMaterial = this.getSelecionadosFiltro(FILTRO_TIPO_MATERIAL, 0)) != null) {
            buf.append(" and tpm.tpm_codigo in (");
            for (i = 0; i < tipoMaterial.length; ++i) {
                buf.append("'");
                buf.append(tipoMaterial[i]);
                buf.append("'");
                if (i >= tipoMaterial.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (celulas != null) {
            buf.append(" and cel.cel_codigo in (");
            for (i = 0; i < celulas.length; ++i) {
                buf.append(celulas[i]);
                if (i >= celulas.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.getFiltroCombo(FILTRO_TIPO_LANCTO).equals(comboTipoLancto[1])) {
            buf.append(" and lce.lce_tipo = '").append("E").append("' ");
        } else if (this.getFiltroCombo(FILTRO_TIPO_LANCTO).equals(comboTipoLancto[2])) {
            buf.append(" and lce.lce_tipo = '").append("S").append("' ");
        }
        if (this.getFiltroCheck(FILTRO_MATERIAL_INATIVO)) {
            buf.append(" and a.mat_inativo ");
        } else {
            buf.append(" and a.mat_inativo = false ");
        }
        buf.append("  and lce.lce_datahoracancelamento is null");
        if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            buf.append(" and cast(lce.lce_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append("' ");
        }
        if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
            buf.append(" and cast(lce.lce_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append("' ");
        }
        buf.append("GROUP  BY a.fil_codigo, \t\t");
        buf.append("\tlce.lce_codigo,\t \t\t\t\t \t");
        buf.append("\ta.mat_codigo,  \t\t\t\t\t\t");
        buf.append("\ta.mat_descricao,  \t\t\t\t");
        buf.append("\ta.mat_valorunit,  \t\t\t\t");
        buf.append("\ta.mat_valorultcompra, \t\t");
        buf.append("\ta.mat_dataultcompra,  \t\t");
        buf.append("\ta.mat_qtdeultcompra,  \t\t");
        buf.append("\ta.mat_ptoreposicao,  \t\t\t");
        buf.append("\ta.mat_dataultentrega,  \t\t");
        buf.append("\ta.mat_reposicaoautomatica,");
        buf.append("\ta.mat_imobilizado,  \t\t\t");
        buf.append("\tlce.lce_codigo,  \t\t\t\t\t");
        buf.append("\tlce.lce_datahora,  \t\t\t\t");
        buf.append("\tlce.lce_tipo,  \t\t\t\t\t\t");
        buf.append("\tlce.lce_tipoorigem, \t\t\t");
        buf.append("\tlce.lce_quantidade,  \t\t\t");
        buf.append("\tlce.usr_codigo,  \t\t\t\t\t");
        buf.append("\tlce.usr_codconciliacao,  \t");
        buf.append("\tlce.lce_valorunitario,  \t");
        buf.append("\tlce.lce_valortotal,  \t\t\t");
        buf.append("\tlce.lce_conciliacao,  \t\t");
        buf.append("\tlce.lce_analisecritica,   ");
        buf.append("\tcel.cel_codigo,  \t\t\t\t\t");
        buf.append("\tcel.cel_descricao,  \t\t\t");
        buf.append("\tunm.unm_codigo,  \t\t\t\t\t");
        buf.append("\tunm.unm_descricao,  \t\t\t");
        buf.append("\ttpm.tpm_codigo,  \t\t\t\t\t");
        buf.append("\ttpm.tpm_descricao,  \t\t\t");
        buf.append("\tcmc.cmc_valor,  \t\t\t\t\t");
        buf.append("\tcmc.cmc_valorunitario,  \t");
        if (celulas == null) {
            buf.append("\tsdeini.sde_saldo, ");
            buf.append("\tsdeini.sde_data,");
        }
        buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        buf.append(" order by a.fil_codigo, ");
        buf.append(campoBanco[this.getFiltroComboIndice(FILTRO_ORDENACAO)]);
        buf.append(" ,lce.lce_codigo ");
        if (celulas != null) {
            buf = new StringBuilder(buf.toString().replaceAll("sde", "ces"));
            buf = new StringBuilder(buf.toString().replaceAll("saldoestoque", "saldoestoquecelula"));
        }
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                do {
                    Object[] o = new Object[this.camposRelatorio.length];
                    for (int i4 = 0; i4 < this.camposRelatorio.length; ++i4) {
                        if (celulas != null && (this.camposRelatorio[i4].equalsIgnoreCase("saldoAnterior") || this.camposRelatorio[i4].equalsIgnoreCase("dataSaldoAnterior"))) continue;
                        o[i4] = this.camposRelatorio[i4].equalsIgnoreCase("tipoLancto") ? Tipos.tipoLancamentoEstoque(rs.getString(this.camposRelatorio[i4])) : (this.camposRelatorio[i4].equalsIgnoreCase("tipoOrigemLancto") ? Tipos.tipoOrigemLancamentoEstoque(rs.getString(this.camposRelatorio[i4])) : (this.colunaExiste(rs, this.camposRelatorio[i4]) ? rs.getObject(this.camposRelatorio[i4]) : null));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                BigDecimal valorSaldo = BigDecimal.ZERO;
                BigDecimal saldoInicial = BigDecimal.ZERO;
                Integer codigoMaterial = -1;
                st2 = Conexao.getStatement();
                for (int i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                    HashMap<String, Object> linha = modelo.getLine(i5);
                    Integer filial = (Integer)modelo.getValueAt(i5, modelo.findColumn("codigoFilial"));
                    if (codigoMaterial.intValue() != ((Integer)linha.get("codigoMaterial")).intValue()) {
                        codigoMaterial = (Integer)linha.get("codigoMaterial");
                        valorSaldo = BigDecimal.ZERO;
                        saldoInicial = BigDecimal.ZERO;
                        if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty()) {
                            saldoInicial = this.getSaldoAnterior(filial, codigoMaterial, Funcoes.stringToDate("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)), celulas, st2);
                            modelo.setValueAt(saldoInicial == null ? BigDecimal.ZERO : saldoInicial, i5, modelo.findColumn("saldoAnterior"));
                        } else {
                            modelo.setValueAt(BigDecimal.ZERO, i5, modelo.findColumn("saldoAnterior"));
                        }
                        valorSaldo = valorSaldo.add(saldoInicial == null ? BigDecimal.ZERO : saldoInicial);
                    }
                    valorSaldo = linha.get("tipoLancto").toString().equalsIgnoreCase(Tipos.tipoLancamentoEstoque("E")) ? valorSaldo.add((BigDecimal)linha.get("quantidadeLancto")) : valorSaldo.subtract((BigDecimal)linha.get("quantidadeLancto"));
                    modelo.setValueAt(valorSaldo, i5, modelo.findColumn("saldoAnteriorAcumulado"));
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioMovimentoEstoqueDetalhada.getModuloAcesso());
                rs.close();
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioMovimentoEstoqueDetalhada.this.panelCentro.removeAll();
                            RelatorioMovimentoEstoqueDetalhada.this.panelCentro.repaint();
                            RelatorioMovimentoEstoqueDetalhada.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_ORDENACAO, this.getFiltroCombo(FILTRO_ORDENACAO));
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_MATERIAL_INATIVO, this.getFiltroCheck(FILTRO_MATERIAL_INATIVO) ? "Sim" : "N\u00e3o");
                    var.put(FILTRO_TIPO_LANCTO, this.getFiltroCombo(FILTRO_TIPO_LANCTO));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i6 = 0; i6 < filiais.length; ++i6) {
                            buf.append(filiais[i6]);
                            if (i6 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (material != null) {
                        for (int i7 = 0; i7 < material.length; ++i7) {
                            buf.append(material[i7]);
                            if (i7 >= material.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_MATERIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (celulas != null) {
                        for (int i8 = 0; i8 < celulas.length; ++i8) {
                            buf.append(celulas[i8]);
                            if (i8 >= celulas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CELULA, buf.toString());
                    buf.delete(0, buf.length());
                    if (tipoMaterial != null) {
                        for (int i9 = 0; i9 < tipoMaterial.length; ++i9) {
                            buf.append(tipoMaterial[i9]);
                            if (i9 >= tipoMaterial.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_TIPO_MATERIAL, buf.toString());
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private BigDecimal getSaldoAnterior(Integer filial, Integer codigoMaterial, Date dataInicial, String[] celulas, Statement st) throws SQLException {
        ResultSet rs;
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(COALESCE(ces_saldo, 0)) as saldoAnterior ");
        buf.append("   from saldoestoquecelula ces ");
        buf.append("  where ces.fil_codigo = ").append(filial);
        buf.append("    and ces.mat_codigo = ").append(codigoMaterial);
        buf.append("    and ces.ces_data = (select MAX(ces_data) ");
        buf.append("                          from saldoestoquecelula ");
        buf.append("                         where fil_codigo = ces.fil_codigo ");
        buf.append("                           and mat_codigo = ces.mat_codigo ");
        buf.append("                           and cel_codigo = ces.cel_codigo ");
        buf.append("                           and ces_data < '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
        buf.append("                       ) ");
        if (celulas != null) {
            buf.append(" and ces.cel_codigo in (");
            for (int i = 0; i < celulas.length; ++i) {
                buf.append(celulas[i]);
                if (i >= celulas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
            return rs.getBigDecimal("saldoAnterior");
        }
        return BigDecimal.ZERO;
    }
}

